// Generated by delombok at Fri Sep 09 14:23:38 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.EventListParams;
import com.stripe.param.EventRetrieveParams;
import java.util.Map;

/**
 * Events are our way of letting you know when something interesting happens in your account. When
 * an interesting event occurs, we create a new {@code Event} object. For example, when a charge
 * succeeds, we create a {@code charge.succeeded} event; and when an invoice payment attempt fails,
 * we create an {@code invoice.payment_failed} event. Note that many API requests may cause multiple
 * events to be created. For example, if you create a new subscription for a customer, you will
 * receive both a {@code customer.subscription.created} event and a {@code charge.succeeded} event.
 *
 * <p>Events occur when the state of another API resource changes. The state of that resource at the
 * time of the change is embedded in the event's data field. For example, a {@code charge.succeeded}
 * event will contain a charge, and an {@code invoice.payment_failed} event will contain an invoice.
 *
 * <p>As with other API resources, you can use endpoints to retrieve an <a
 * href="https://stripe.com/docs/api#retrieve_event">individual event</a> or a <a
 * href="https://stripe.com/docs/api#list_events">list of events</a> from the API. We also have a
 * separate <a href="http://en.wikipedia.org/wiki/Webhook">webhooks</a> system for sending the
 * {@code Event} objects directly to an endpoint on your server. Webhooks are managed in your <a
 * href="https://dashboard.stripe.com/account/webhooks">account settings</a>, and our <a
 * href="https://stripe.com/docs/webhooks">Using Webhooks</a> guide will help you get set up.
 *
 * <p>When using <a href="https://stripe.com/docs/connect">Connect</a>, you can also receive
 * notifications of events that occur in connected accounts. For these events, there will be an
 * additional {@code account} attribute in the received {@code Event} object.
 *
 * <p><strong>NOTE:</strong> Right now, access to events through the <a
 * href="https://stripe.com/docs/api#retrieve_event">Retrieve Event API</a> is guaranteed only for
 * 30 days.
 */
public class Event extends ApiResource implements HasId {
  /**
   * The connected account that originated the event.
   */
  @SerializedName("account")
  String account;
  /**
   * The Stripe API version used to render {@code data}. <em>Note: This property is populated only
   * for events on or after October 31, 2014</em>.
   */
  @SerializedName("api_version")
  String apiVersion;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  @SerializedName("data")
  EventData data;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code event}.
   */
  @SerializedName("object")
  String object;
  /**
   * Number of webhooks that have yet to be successfully delivered (i.e., to return a 20x response)
   * to the URLs you've specified.
   */
  @SerializedName("pending_webhooks")
  Long pendingWebhooks;
  /**
   * Information on the API request that instigated the event.
   */
  @SerializedName("request")
  EventRequest request;
  /**
   * Description of the event (e.g., {@code invoice.created} or {@code charge.refunded}).
   */
  @SerializedName("type")
  String type;

  /**
   * List events, going back up to 30 days. Each event data is rendered according to Stripe API
   * version at its creation time, specified in <a
   * href="https://stripe.com/docs/api/events/object">event object</a> <code>api_version</code>
   * attribute (not according to your current Stripe API version or <code>Stripe-Version</code>
   * header).
   */
  public static EventCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * List events, going back up to 30 days. Each event data is rendered according to Stripe API
   * version at its creation time, specified in <a
   * href="https://stripe.com/docs/api/events/object">event object</a> <code>api_version</code>
   * attribute (not according to your current Stripe API version or <code>Stripe-Version</code>
   * header).
   */
  public static EventCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/events");
    return ApiResource.requestCollection(url, params, EventCollection.class, options);
  }

  /**
   * List events, going back up to 30 days. Each event data is rendered according to Stripe API
   * version at its creation time, specified in <a
   * href="https://stripe.com/docs/api/events/object">event object</a> <code>api_version</code>
   * attribute (not according to your current Stripe API version or <code>Stripe-Version</code>
   * header).
   */
  public static EventCollection list(EventListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * List events, going back up to 30 days. Each event data is rendered according to Stripe API
   * version at its creation time, specified in <a
   * href="https://stripe.com/docs/api/events/object">event object</a> <code>api_version</code>
   * attribute (not according to your current Stripe API version or <code>Stripe-Version</code>
   * header).
   */
  public static EventCollection list(EventListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/events");
    return ApiResource.requestCollection(url, params, EventCollection.class, options);
  }

  /**
   * Retrieves the details of an event. Supply the unique identifier of the event, which you might
   * have received in a webhook.
   */
  public static Event retrieve(String id) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the details of an event. Supply the unique identifier of the event, which you might
   * have received in a webhook.
   */
  public static Event retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the details of an event. Supply the unique identifier of the event, which you might
   * have received in a webhook.
   */
  public static Event retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/events/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Event.class, options);
  }

  /**
   * Retrieves the details of an event. Supply the unique identifier of the event, which you might
   * have received in a webhook.
   */
  public static Event retrieve(String id, EventRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/events/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Event.class, options);
  }

  /**
   * Get deserialization helper to handle failure due to schema incompatibility. When event API
   * version matches that of the library's pinned version, the following integration pattern is
   * safe.
   *
   * <pre>
   *   Event event = getEvent(); // either from webhook or event endpoint
   *   EventDataObjectDeserializer deserializer = event.getDataObjectDeserializer();
   *   Optional&lt;StripeObject&gt; stripeObject = deserializer.getObject();
   * </pre>
   *
   * You can ensure that webhook events has the same API version by creating webhook endpoint
   * specifying api version](https://stripe.com/docs/api/webhook_endpoints/create) as {@link
   * com.stripe.Stripe#API_VERSION}. For reading from old webhook endpoints or old events with
   * potential schema incompatibility, see {@link EventDataObjectDeserializer#deserialize()} and
   * {@link EventDataObjectDeserializer#deserializeUnsafe()}.
   */
  public EventDataObjectDeserializer getDataObjectDeserializer() {
    return new EventDataObjectDeserializer(apiVersion, type, data.object);
  }

  /**
   * The connected account that originated the event.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getAccount() {
    return this.account;
  }

  /**
   * The Stripe API version used to render {@code data}. <em>Note: This property is populated only
   * for events on or after October 31, 2014</em>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getApiVersion() {
    return this.apiVersion;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public EventData getData() {
    return this.data;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code event}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Number of webhooks that have yet to be successfully delivered (i.e., to return a 20x response)
   * to the URLs you've specified.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getPendingWebhooks() {
    return this.pendingWebhooks;
  }

  /**
   * Information on the API request that instigated the event.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public EventRequest getRequest() {
    return this.request;
  }

  /**
   * Description of the event (e.g., {@code invoice.created} or {@code charge.refunded}).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getType() {
    return this.type;
  }

  /**
   * The connected account that originated the event.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAccount(final String account) {
    this.account = account;
  }

  /**
   * The Stripe API version used to render {@code data}. <em>Note: This property is populated only
   * for events on or after October 31, 2014</em>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setApiVersion(final String apiVersion) {
    this.apiVersion = apiVersion;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setData(final EventData data) {
    this.data = data;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code event}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Number of webhooks that have yet to be successfully delivered (i.e., to return a 20x response)
   * to the URLs you've specified.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPendingWebhooks(final Long pendingWebhooks) {
    this.pendingWebhooks = pendingWebhooks;
  }

  /**
   * Information on the API request that instigated the event.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRequest(final EventRequest request) {
    this.request = request;
  }

  /**
   * Description of the event (e.g., {@code invoice.created} or {@code charge.refunded}).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setType(final String type) {
    this.type = type;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Event)) return false;
    final Event other = (Event) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$pendingWebhooks = this.getPendingWebhooks();
    final java.lang.Object other$pendingWebhooks = other.getPendingWebhooks();
    if (this$pendingWebhooks == null ? other$pendingWebhooks != null : !this$pendingWebhooks.equals(other$pendingWebhooks)) return false;
    final java.lang.Object this$account = this.getAccount();
    final java.lang.Object other$account = other.getAccount();
    if (this$account == null ? other$account != null : !this$account.equals(other$account)) return false;
    final java.lang.Object this$apiVersion = this.getApiVersion();
    final java.lang.Object other$apiVersion = other.getApiVersion();
    if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) return false;
    final java.lang.Object this$data = this.getData();
    final java.lang.Object other$data = other.getData();
    if (this$data == null ? other$data != null : !this$data.equals(other$data)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$request = this.getRequest();
    final java.lang.Object other$request = other.getRequest();
    if (this$request == null ? other$request != null : !this$request.equals(other$request)) return false;
    final java.lang.Object this$type = this.getType();
    final java.lang.Object other$type = other.getType();
    if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Event;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $pendingWebhooks = this.getPendingWebhooks();
    result = result * PRIME + ($pendingWebhooks == null ? 43 : $pendingWebhooks.hashCode());
    final java.lang.Object $account = this.getAccount();
    result = result * PRIME + ($account == null ? 43 : $account.hashCode());
    final java.lang.Object $apiVersion = this.getApiVersion();
    result = result * PRIME + ($apiVersion == null ? 43 : $apiVersion.hashCode());
    final java.lang.Object $data = this.getData();
    result = result * PRIME + ($data == null ? 43 : $data.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $request = this.getRequest();
    result = result * PRIME + ($request == null ? 43 : $request.hashCode());
    final java.lang.Object $type = this.getType();
    result = result * PRIME + ($type == null ? 43 : $type.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
