/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.issuing;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.ExpandableField;
import com.stripe.model.File;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.model.issuing.CardholderCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.issuing.CardholderCreateParams;
import com.stripe.param.issuing.CardholderListParams;
import com.stripe.param.issuing.CardholderRetrieveParams;
import com.stripe.param.issuing.CardholderUpdateParams;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Cardholder
extends ApiResource
implements HasId,
MetadataStore<Cardholder> {
    @SerializedName(value="billing")
    Billing billing;
    @SerializedName(value="company")
    Company company;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="email")
    String email;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="individual")
    Individual individual;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="name")
    String name;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="phone_number")
    String phoneNumber;
    @SerializedName(value="requirements")
    Requirements requirements;
    @SerializedName(value="spending_controls")
    SpendingControls spendingControls;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="type")
    String type;

    public static Cardholder create(Map<String, Object> params) throws StripeException {
        return Cardholder.create(params, (RequestOptions)null);
    }

    public static Cardholder create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/cardholders");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Cardholder.class, options);
    }

    public static Cardholder create(CardholderCreateParams params) throws StripeException {
        return Cardholder.create(params, (RequestOptions)null);
    }

    public static Cardholder create(CardholderCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/cardholders");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Cardholder.class, options);
    }

    public static CardholderCollection list(Map<String, Object> params) throws StripeException {
        return Cardholder.list(params, (RequestOptions)null);
    }

    public static CardholderCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/cardholders");
        return ApiResource.requestCollection(url, params, CardholderCollection.class, options);
    }

    public static CardholderCollection list(CardholderListParams params) throws StripeException {
        return Cardholder.list(params, (RequestOptions)null);
    }

    public static CardholderCollection list(CardholderListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/cardholders");
        return ApiResource.requestCollection(url, params, CardholderCollection.class, options);
    }

    public static Cardholder retrieve(String cardholder) throws StripeException {
        return Cardholder.retrieve(cardholder, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Cardholder retrieve(String cardholder, RequestOptions options) throws StripeException {
        return Cardholder.retrieve(cardholder, (Map<String, Object>)null, options);
    }

    public static Cardholder retrieve(String cardholder, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/cardholders/%s", ApiResource.urlEncodeId(cardholder)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Cardholder.class, options);
    }

    public static Cardholder retrieve(String cardholder, CardholderRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/cardholders/%s", ApiResource.urlEncodeId(cardholder)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Cardholder.class, options);
    }

    public Cardholder update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Cardholder update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/cardholders/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Cardholder.class, options);
    }

    public Cardholder update(CardholderUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Cardholder update(CardholderUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/cardholders/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Cardholder.class, options);
    }

    @Generated
    public Billing getBilling() {
        return this.billing;
    }

    @Generated
    public Company getCompany() {
        return this.company;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public Individual getIndividual() {
        return this.individual;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @Generated
    public Requirements getRequirements() {
        return this.requirements;
    }

    @Generated
    public SpendingControls getSpendingControls() {
        return this.spendingControls;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setBilling(Billing billing) {
        this.billing = billing;
    }

    @Generated
    public void setCompany(Company company) {
        this.company = company;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIndividual(Individual individual) {
        this.individual = individual;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    @Generated
    public void setRequirements(Requirements requirements) {
        this.requirements = requirements;
    }

    @Generated
    public void setSpendingControls(SpendingControls spendingControls) {
        this.spendingControls = spendingControls;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cardholder)) {
            return false;
        }
        Cardholder other = (Cardholder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Billing this$billing = this.getBilling();
        Billing other$billing = other.getBilling();
        if (this$billing == null ? other$billing != null : !((Object)this$billing).equals(other$billing)) {
            return false;
        }
        Company this$company = this.getCompany();
        Company other$company = other.getCompany();
        if (this$company == null ? other$company != null : !((Object)this$company).equals(other$company)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Individual this$individual = this.getIndividual();
        Individual other$individual = other.getIndividual();
        if (this$individual == null ? other$individual != null : !((Object)this$individual).equals(other$individual)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$phoneNumber = this.getPhoneNumber();
        String other$phoneNumber = other.getPhoneNumber();
        if (this$phoneNumber == null ? other$phoneNumber != null : !this$phoneNumber.equals(other$phoneNumber)) {
            return false;
        }
        Requirements this$requirements = this.getRequirements();
        Requirements other$requirements = other.getRequirements();
        if (this$requirements == null ? other$requirements != null : !((Object)this$requirements).equals(other$requirements)) {
            return false;
        }
        SpendingControls this$spendingControls = this.getSpendingControls();
        SpendingControls other$spendingControls = other.getSpendingControls();
        if (this$spendingControls == null ? other$spendingControls != null : !((Object)this$spendingControls).equals(other$spendingControls)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Cardholder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Billing $billing = this.getBilling();
        result = result * 59 + ($billing == null ? 43 : ((Object)$billing).hashCode());
        Company $company = this.getCompany();
        result = result * 59 + ($company == null ? 43 : ((Object)$company).hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Individual $individual = this.getIndividual();
        result = result * 59 + ($individual == null ? 43 : ((Object)$individual).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $phoneNumber = this.getPhoneNumber();
        result = result * 59 + ($phoneNumber == null ? 43 : $phoneNumber.hashCode());
        Requirements $requirements = this.getRequirements();
        result = result * 59 + ($requirements == null ? 43 : ((Object)$requirements).hashCode());
        SpendingControls $spendingControls = this.getSpendingControls();
        result = result * 59 + ($spendingControls == null ? 43 : ((Object)$spendingControls).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class Billing
    extends StripeObject {
        @SerializedName(value="address")
        Address address;

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public void setAddress(Address address) {
            this.address = address;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Billing)) {
                return false;
            }
            Billing other = (Billing)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Address this$address = this.getAddress();
            Address other$address = other.getAddress();
            return !(this$address == null ? other$address != null : !((Object)this$address).equals(other$address));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Billing;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Address $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            return result;
        }
    }

    public static class Company
    extends StripeObject {
        @SerializedName(value="tax_id_provided")
        Boolean taxIdProvided;

        @Generated
        public Boolean getTaxIdProvided() {
            return this.taxIdProvided;
        }

        @Generated
        public void setTaxIdProvided(Boolean taxIdProvided) {
            this.taxIdProvided = taxIdProvided;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Company)) {
                return false;
            }
            Company other = (Company)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$taxIdProvided = this.getTaxIdProvided();
            Boolean other$taxIdProvided = other.getTaxIdProvided();
            return !(this$taxIdProvided == null ? other$taxIdProvided != null : !((Object)this$taxIdProvided).equals(other$taxIdProvided));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Company;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $taxIdProvided = this.getTaxIdProvided();
            result = result * 59 + ($taxIdProvided == null ? 43 : ((Object)$taxIdProvided).hashCode());
            return result;
        }
    }

    public static class Individual
    extends StripeObject {
        @SerializedName(value="dob")
        DateOfBirth dob;
        @SerializedName(value="first_name")
        String firstName;
        @SerializedName(value="last_name")
        String lastName;
        @SerializedName(value="verification")
        Verification verification;

        @Generated
        public DateOfBirth getDob() {
            return this.dob;
        }

        @Generated
        public String getFirstName() {
            return this.firstName;
        }

        @Generated
        public String getLastName() {
            return this.lastName;
        }

        @Generated
        public Verification getVerification() {
            return this.verification;
        }

        @Generated
        public void setDob(DateOfBirth dob) {
            this.dob = dob;
        }

        @Generated
        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Generated
        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Generated
        public void setVerification(Verification verification) {
            this.verification = verification;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Individual)) {
                return false;
            }
            Individual other = (Individual)o;
            if (!other.canEqual(this)) {
                return false;
            }
            DateOfBirth this$dob = this.getDob();
            DateOfBirth other$dob = other.getDob();
            if (this$dob == null ? other$dob != null : !((Object)this$dob).equals(other$dob)) {
                return false;
            }
            String this$firstName = this.getFirstName();
            String other$firstName = other.getFirstName();
            if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
                return false;
            }
            String this$lastName = this.getLastName();
            String other$lastName = other.getLastName();
            if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
                return false;
            }
            Verification this$verification = this.getVerification();
            Verification other$verification = other.getVerification();
            return !(this$verification == null ? other$verification != null : !((Object)this$verification).equals(other$verification));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Individual;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DateOfBirth $dob = this.getDob();
            result = result * 59 + ($dob == null ? 43 : ((Object)$dob).hashCode());
            String $firstName = this.getFirstName();
            result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
            String $lastName = this.getLastName();
            result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
            Verification $verification = this.getVerification();
            result = result * 59 + ($verification == null ? 43 : ((Object)$verification).hashCode());
            return result;
        }

        public static class DateOfBirth
        extends StripeObject {
            @SerializedName(value="day")
            Long day;
            @SerializedName(value="month")
            Long month;
            @SerializedName(value="year")
            Long year;

            @Generated
            public Long getDay() {
                return this.day;
            }

            @Generated
            public Long getMonth() {
                return this.month;
            }

            @Generated
            public Long getYear() {
                return this.year;
            }

            @Generated
            public void setDay(Long day) {
                this.day = day;
            }

            @Generated
            public void setMonth(Long month) {
                this.month = month;
            }

            @Generated
            public void setYear(Long year) {
                this.year = year;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DateOfBirth)) {
                    return false;
                }
                DateOfBirth other = (DateOfBirth)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$day = this.getDay();
                Long other$day = other.getDay();
                if (this$day == null ? other$day != null : !((Object)this$day).equals(other$day)) {
                    return false;
                }
                Long this$month = this.getMonth();
                Long other$month = other.getMonth();
                if (this$month == null ? other$month != null : !((Object)this$month).equals(other$month)) {
                    return false;
                }
                Long this$year = this.getYear();
                Long other$year = other.getYear();
                return !(this$year == null ? other$year != null : !((Object)this$year).equals(other$year));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DateOfBirth;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $day = this.getDay();
                result = result * 59 + ($day == null ? 43 : ((Object)$day).hashCode());
                Long $month = this.getMonth();
                result = result * 59 + ($month == null ? 43 : ((Object)$month).hashCode());
                Long $year = this.getYear();
                result = result * 59 + ($year == null ? 43 : ((Object)$year).hashCode());
                return result;
            }
        }

        public static class Verification
        extends StripeObject {
            @SerializedName(value="document")
            Document document;

            @Generated
            public Document getDocument() {
                return this.document;
            }

            @Generated
            public void setDocument(Document document) {
                this.document = document;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Verification)) {
                    return false;
                }
                Verification other = (Verification)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Document this$document = this.getDocument();
                Document other$document = other.getDocument();
                return !(this$document == null ? other$document != null : !((Object)this$document).equals(other$document));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Verification;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Document $document = this.getDocument();
                result = result * 59 + ($document == null ? 43 : ((Object)$document).hashCode());
                return result;
            }

            public static class Document
            extends StripeObject {
                @SerializedName(value="back")
                ExpandableField<File> back;
                @SerializedName(value="front")
                ExpandableField<File> front;

                public String getBack() {
                    return this.back != null ? this.back.getId() : null;
                }

                public void setBack(String id) {
                    this.back = ApiResource.setExpandableFieldId(id, this.back);
                }

                public File getBackObject() {
                    return this.back != null ? this.back.getExpanded() : null;
                }

                public void setBackObject(File expandableObject) {
                    this.back = new ExpandableField<File>(expandableObject.getId(), expandableObject);
                }

                public String getFront() {
                    return this.front != null ? this.front.getId() : null;
                }

                public void setFront(String id) {
                    this.front = ApiResource.setExpandableFieldId(id, this.front);
                }

                public File getFrontObject() {
                    return this.front != null ? this.front.getExpanded() : null;
                }

                public void setFrontObject(File expandableObject) {
                    this.front = new ExpandableField<File>(expandableObject.getId(), expandableObject);
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Document)) {
                        return false;
                    }
                    Document other = (Document)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$back = this.getBack();
                    String other$back = other.getBack();
                    if (this$back == null ? other$back != null : !this$back.equals(other$back)) {
                        return false;
                    }
                    String this$front = this.getFront();
                    String other$front = other.getFront();
                    return !(this$front == null ? other$front != null : !this$front.equals(other$front));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Document;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $back = this.getBack();
                    result = result * 59 + ($back == null ? 43 : $back.hashCode());
                    String $front = this.getFront();
                    result = result * 59 + ($front == null ? 43 : $front.hashCode());
                    return result;
                }
            }
        }
    }

    public static class Requirements
    extends StripeObject {
        @SerializedName(value="disabled_reason")
        String disabledReason;
        @SerializedName(value="past_due")
        List<String> pastDue;

        @Generated
        public String getDisabledReason() {
            return this.disabledReason;
        }

        @Generated
        public List<String> getPastDue() {
            return this.pastDue;
        }

        @Generated
        public void setDisabledReason(String disabledReason) {
            this.disabledReason = disabledReason;
        }

        @Generated
        public void setPastDue(List<String> pastDue) {
            this.pastDue = pastDue;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Requirements)) {
                return false;
            }
            Requirements other = (Requirements)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$disabledReason = this.getDisabledReason();
            String other$disabledReason = other.getDisabledReason();
            if (this$disabledReason == null ? other$disabledReason != null : !this$disabledReason.equals(other$disabledReason)) {
                return false;
            }
            List<String> this$pastDue = this.getPastDue();
            List<String> other$pastDue = other.getPastDue();
            return !(this$pastDue == null ? other$pastDue != null : !((Object)this$pastDue).equals(other$pastDue));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Requirements;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $disabledReason = this.getDisabledReason();
            result = result * 59 + ($disabledReason == null ? 43 : $disabledReason.hashCode());
            List<String> $pastDue = this.getPastDue();
            result = result * 59 + ($pastDue == null ? 43 : ((Object)$pastDue).hashCode());
            return result;
        }
    }

    public static class SpendingControls
    extends StripeObject {
        @SerializedName(value="allowed_categories")
        List<String> allowedCategories;
        @SerializedName(value="blocked_categories")
        List<String> blockedCategories;
        @SerializedName(value="spending_limits")
        List<SpendingLimit> spendingLimits;
        @SerializedName(value="spending_limits_currency")
        String spendingLimitsCurrency;

        @Generated
        public List<String> getAllowedCategories() {
            return this.allowedCategories;
        }

        @Generated
        public List<String> getBlockedCategories() {
            return this.blockedCategories;
        }

        @Generated
        public List<SpendingLimit> getSpendingLimits() {
            return this.spendingLimits;
        }

        @Generated
        public String getSpendingLimitsCurrency() {
            return this.spendingLimitsCurrency;
        }

        @Generated
        public void setAllowedCategories(List<String> allowedCategories) {
            this.allowedCategories = allowedCategories;
        }

        @Generated
        public void setBlockedCategories(List<String> blockedCategories) {
            this.blockedCategories = blockedCategories;
        }

        @Generated
        public void setSpendingLimits(List<SpendingLimit> spendingLimits) {
            this.spendingLimits = spendingLimits;
        }

        @Generated
        public void setSpendingLimitsCurrency(String spendingLimitsCurrency) {
            this.spendingLimitsCurrency = spendingLimitsCurrency;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpendingControls)) {
                return false;
            }
            SpendingControls other = (SpendingControls)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$allowedCategories = this.getAllowedCategories();
            List<String> other$allowedCategories = other.getAllowedCategories();
            if (this$allowedCategories == null ? other$allowedCategories != null : !((Object)this$allowedCategories).equals(other$allowedCategories)) {
                return false;
            }
            List<String> this$blockedCategories = this.getBlockedCategories();
            List<String> other$blockedCategories = other.getBlockedCategories();
            if (this$blockedCategories == null ? other$blockedCategories != null : !((Object)this$blockedCategories).equals(other$blockedCategories)) {
                return false;
            }
            List<SpendingLimit> this$spendingLimits = this.getSpendingLimits();
            List<SpendingLimit> other$spendingLimits = other.getSpendingLimits();
            if (this$spendingLimits == null ? other$spendingLimits != null : !((Object)this$spendingLimits).equals(other$spendingLimits)) {
                return false;
            }
            String this$spendingLimitsCurrency = this.getSpendingLimitsCurrency();
            String other$spendingLimitsCurrency = other.getSpendingLimitsCurrency();
            return !(this$spendingLimitsCurrency == null ? other$spendingLimitsCurrency != null : !this$spendingLimitsCurrency.equals(other$spendingLimitsCurrency));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SpendingControls;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $allowedCategories = this.getAllowedCategories();
            result = result * 59 + ($allowedCategories == null ? 43 : ((Object)$allowedCategories).hashCode());
            List<String> $blockedCategories = this.getBlockedCategories();
            result = result * 59 + ($blockedCategories == null ? 43 : ((Object)$blockedCategories).hashCode());
            List<SpendingLimit> $spendingLimits = this.getSpendingLimits();
            result = result * 59 + ($spendingLimits == null ? 43 : ((Object)$spendingLimits).hashCode());
            String $spendingLimitsCurrency = this.getSpendingLimitsCurrency();
            result = result * 59 + ($spendingLimitsCurrency == null ? 43 : $spendingLimitsCurrency.hashCode());
            return result;
        }

        public static class SpendingLimit
        extends StripeObject {
            @SerializedName(value="amount")
            Long amount;
            @SerializedName(value="categories")
            List<String> categories;
            @SerializedName(value="interval")
            String interval;

            @Generated
            public Long getAmount() {
                return this.amount;
            }

            @Generated
            public List<String> getCategories() {
                return this.categories;
            }

            @Generated
            public String getInterval() {
                return this.interval;
            }

            @Generated
            public void setAmount(Long amount) {
                this.amount = amount;
            }

            @Generated
            public void setCategories(List<String> categories) {
                this.categories = categories;
            }

            @Generated
            public void setInterval(String interval) {
                this.interval = interval;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SpendingLimit)) {
                    return false;
                }
                SpendingLimit other = (SpendingLimit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$amount = this.getAmount();
                Long other$amount = other.getAmount();
                if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                    return false;
                }
                List<String> this$categories = this.getCategories();
                List<String> other$categories = other.getCategories();
                if (this$categories == null ? other$categories != null : !((Object)this$categories).equals(other$categories)) {
                    return false;
                }
                String this$interval = this.getInterval();
                String other$interval = other.getInterval();
                return !(this$interval == null ? other$interval != null : !this$interval.equals(other$interval));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SpendingLimit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $amount = this.getAmount();
                result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                List<String> $categories = this.getCategories();
                result = result * 59 + ($categories == null ? 43 : ((Object)$categories).hashCode());
                String $interval = this.getInterval();
                result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
                return result;
            }
        }
    }
}

