// Generated by delombok at Thu Sep 22 21:16:35 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model.treasury;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.treasury.InboundTransferCancelParams;
import com.stripe.param.treasury.InboundTransferCreateParams;
import com.stripe.param.treasury.InboundTransferFailParams;
import com.stripe.param.treasury.InboundTransferListParams;
import com.stripe.param.treasury.InboundTransferRetrieveParams;
import com.stripe.param.treasury.InboundTransferReturnInboundTransferParams;
import com.stripe.param.treasury.InboundTransferSucceedParams;
import java.util.Map;

/**
 * Use <a
 * href="https://stripe.com/docs/treasury/moving-money/financial-accounts/into/inbound-transfers">InboundTransfers</a>
 * to add funds to your <a
 * href="https://stripe.com/docs/api#financial_accounts">FinancialAccount</a> via a PaymentMethod
 * that is owned by you. The funds will be transferred via an ACH debit.
 */
public class InboundTransfer extends ApiResource implements HasId {
  /**
   * Amount (in cents) transferred.
   */
  @SerializedName("amount")
  Long amount;
  /**
   * Returns {@code true} if the InboundTransfer is able to be canceled.
   */
  @SerializedName("cancelable")
  Boolean cancelable;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @SerializedName("currency")
  String currency;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @SerializedName("description")
  String description;
  /**
   * Details about this InboundTransfer's failure. Only set when status is {@code failed}.
   */
  @SerializedName("failure_details")
  FailureDetails failureDetails;
  /**
   * The FinancialAccount that received the funds.
   */
  @SerializedName("financial_account")
  String financialAccount;
  /**
   * A <a href="https://stripe.com/docs/treasury/moving-money/regulatory-receipts">hosted
   * transaction receipt</a> URL that is provided when money movement is considered regulated under
   * Stripe's money transmission licenses.
   */
  @SerializedName("hosted_regulatory_receipt_url")
  String hostedRegulatoryReceiptUrl;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  @SerializedName("linked_flows")
  LinkedFlows linkedFlows;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code treasury.inbound_transfer}.
   */
  @SerializedName("object")
  String object;
  /**
   * The origin payment method to be debited for an InboundTransfer.
   */
  @SerializedName("origin_payment_method")
  String originPaymentMethod;
  /**
   * Details about the PaymentMethod for an InboundTransfer.
   */
  @SerializedName("origin_payment_method_details")
  OriginPaymentMethodDetails originPaymentMethodDetails;
  /**
   * Returns {@code true} if the funds for an InboundTransfer were returned after the
   * InboundTransfer went to the {@code succeeded} state.
   */
  @SerializedName("returned")
  Boolean returned;
  /**
   * Statement descriptor shown when funds are debited from the source. Not all payment networks
   * support {@code statement_descriptor}.
   */
  @SerializedName("statement_descriptor")
  String statementDescriptor;
  /**
   * Status of the InboundTransfer: {@code processing}, {@code succeeded}, {@code failed}, and
   * {@code canceled}. An InboundTransfer is {@code processing} if it is created and pending. The
   * status changes to {@code succeeded} once the funds have been &quot;confirmed&quot; and a {@code
   * transaction} is created and posted. The status changes to {@code failed} if the transfer fails.
   *
   * <p>One of {@code canceled}, {@code failed}, {@code processing}, or {@code succeeded}.
   */
  @SerializedName("status")
  String status;
  @SerializedName("status_transitions")
  StatusTransitions statusTransitions;
  /**
   * The Transaction associated with this object.
   */
  @SerializedName("transaction")
  ExpandableField<Transaction> transaction;

  /**
   * Get ID of expandable {@code transaction} object.
   */
  public String getTransaction() {
    return (this.transaction != null) ? this.transaction.getId() : null;
  }

  public void setTransaction(String id) {
    this.transaction = ApiResource.setExpandableFieldId(id, this.transaction);
  }

  /**
   * Get expanded {@code transaction}.
   */
  public Transaction getTransactionObject() {
    return (this.transaction != null) ? this.transaction.getExpanded() : null;
  }

  public void setTransactionObject(Transaction expandableObject) {
    this.transaction = new ExpandableField<Transaction>(expandableObject.getId(), expandableObject);
  }

  /**
   * Cancels an InboundTransfer.
   */
  public InboundTransfer cancel() throws StripeException {
    return cancel((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Cancels an InboundTransfer.
   */
  public InboundTransfer cancel(RequestOptions options) throws StripeException {
    return cancel((Map<String, Object>) null, options);
  }

  /**
   * Cancels an InboundTransfer.
   */
  public InboundTransfer cancel(Map<String, Object> params) throws StripeException {
    return cancel(params, (RequestOptions) null);
  }

  /**
   * Cancels an InboundTransfer.
   */
  public InboundTransfer cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/treasury/inbound_transfers/%s/cancel", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, InboundTransfer.class, options);
  }

  /**
   * Cancels an InboundTransfer.
   */
  public InboundTransfer cancel(InboundTransferCancelParams params) throws StripeException {
    return cancel(params, (RequestOptions) null);
  }

  /**
   * Cancels an InboundTransfer.
   */
  public InboundTransfer cancel(InboundTransferCancelParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/treasury/inbound_transfers/%s/cancel", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, InboundTransfer.class, options);
  }

  /**
   * Creates an InboundTransfer.
   */
  public static InboundTransfer create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates an InboundTransfer.
   */
  public static InboundTransfer create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/treasury/inbound_transfers");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, InboundTransfer.class, options);
  }

  /**
   * Creates an InboundTransfer.
   */
  public static InboundTransfer create(InboundTransferCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates an InboundTransfer.
   */
  public static InboundTransfer create(InboundTransferCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/treasury/inbound_transfers");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, InboundTransfer.class, options);
  }

  /**
   * Returns a list of InboundTransfers sent from the specified FinancialAccount.
   */
  public static InboundTransferCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of InboundTransfers sent from the specified FinancialAccount.
   */
  public static InboundTransferCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/treasury/inbound_transfers");
    return ApiResource.requestCollection(url, params, InboundTransferCollection.class, options);
  }

  /**
   * Returns a list of InboundTransfers sent from the specified FinancialAccount.
   */
  public static InboundTransferCollection list(InboundTransferListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of InboundTransfers sent from the specified FinancialAccount.
   */
  public static InboundTransferCollection list(InboundTransferListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/treasury/inbound_transfers");
    return ApiResource.requestCollection(url, params, InboundTransferCollection.class, options);
  }

  /**
   * Retrieves the details of an existing InboundTransfer.
   */
  public static InboundTransfer retrieve(String id) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the details of an existing InboundTransfer.
   */
  public static InboundTransfer retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the details of an existing InboundTransfer.
   */
  public static InboundTransfer retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/treasury/inbound_transfers/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, InboundTransfer.class, options);
  }

  /**
   * Retrieves the details of an existing InboundTransfer.
   */
  public static InboundTransfer retrieve(String id, InboundTransferRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/treasury/inbound_transfers/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, InboundTransfer.class, options);
  }


  public static class FailureDetails extends StripeObject {
    /**
     * Reason for the failure.
     *
     * <p>One of {@code account_closed}, {@code account_frozen}, {@code bank_account_restricted},
     * {@code bank_ownership_changed}, {@code debit_not_authorized}, {@code
     * incorrect_account_holder_address}, {@code incorrect_account_holder_name}, {@code
     * incorrect_account_holder_tax_id}, {@code insufficient_funds}, {@code invalid_account_number},
     * {@code invalid_currency}, {@code no_account}, or {@code other}.
     */
    @SerializedName("code")
    String code;

    /**
     * Reason for the failure.
     *
     * <p>One of {@code account_closed}, {@code account_frozen}, {@code bank_account_restricted},
     * {@code bank_ownership_changed}, {@code debit_not_authorized}, {@code
     * incorrect_account_holder_address}, {@code incorrect_account_holder_name}, {@code
     * incorrect_account_holder_tax_id}, {@code insufficient_funds}, {@code invalid_account_number},
     * {@code invalid_currency}, {@code no_account}, or {@code other}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCode() {
      return this.code;
    }

    /**
     * Reason for the failure.
     *
     * <p>One of {@code account_closed}, {@code account_frozen}, {@code bank_account_restricted},
     * {@code bank_ownership_changed}, {@code debit_not_authorized}, {@code
     * incorrect_account_holder_address}, {@code incorrect_account_holder_name}, {@code
     * incorrect_account_holder_tax_id}, {@code insufficient_funds}, {@code invalid_account_number},
     * {@code invalid_currency}, {@code no_account}, or {@code other}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCode(final String code) {
      this.code = code;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof InboundTransfer.FailureDetails)) return false;
      final InboundTransfer.FailureDetails other = (InboundTransfer.FailureDetails) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$code = this.getCode();
      final java.lang.Object other$code = other.getCode();
      if (this$code == null ? other$code != null : !this$code.equals(other$code)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof InboundTransfer.FailureDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $code = this.getCode();
      result = result * PRIME + ($code == null ? 43 : $code.hashCode());
      return result;
    }
  }


  public static class LinkedFlows extends StripeObject {
    /**
     * If funds for this flow were returned after the flow went to the {@code succeeded} state, this
     * field contains a reference to the ReceivedDebit return.
     */
    @SerializedName("received_debit")
    String receivedDebit;

    /**
     * If funds for this flow were returned after the flow went to the {@code succeeded} state, this
     * field contains a reference to the ReceivedDebit return.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getReceivedDebit() {
      return this.receivedDebit;
    }

    /**
     * If funds for this flow were returned after the flow went to the {@code succeeded} state, this
     * field contains a reference to the ReceivedDebit return.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setReceivedDebit(final String receivedDebit) {
      this.receivedDebit = receivedDebit;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof InboundTransfer.LinkedFlows)) return false;
      final InboundTransfer.LinkedFlows other = (InboundTransfer.LinkedFlows) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$receivedDebit = this.getReceivedDebit();
      final java.lang.Object other$receivedDebit = other.getReceivedDebit();
      if (this$receivedDebit == null ? other$receivedDebit != null : !this$receivedDebit.equals(other$receivedDebit)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof InboundTransfer.LinkedFlows;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $receivedDebit = this.getReceivedDebit();
      result = result * PRIME + ($receivedDebit == null ? 43 : $receivedDebit.hashCode());
      return result;
    }
  }


  public static class OriginPaymentMethodDetails extends StripeObject {
    @SerializedName("billing_details")
    BillingDetails billingDetails;
    /**
     * The type of the payment method used in the InboundTransfer.
     *
     * <p>Equal to {@code us_bank_account}.
     */
    @SerializedName("type")
    String type;
    @SerializedName("us_bank_account")
    UsBankAccount usBankAccount;


    public static class BillingDetails extends StripeObject {
      @SerializedName("address")
      Address address;
      /**
       * Email address.
       */
      @SerializedName("email")
      String email;
      /**
       * Full name.
       */
      @SerializedName("name")
      String name;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Address getAddress() {
        return this.address;
      }

      /**
       * Email address.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getEmail() {
        return this.email;
      }

      /**
       * Full name.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getName() {
        return this.name;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAddress(final Address address) {
        this.address = address;
      }

      /**
       * Email address.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setEmail(final String email) {
        this.email = email;
      }

      /**
       * Full name.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setName(final String name) {
        this.name = name;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof InboundTransfer.OriginPaymentMethodDetails.BillingDetails)) return false;
        final InboundTransfer.OriginPaymentMethodDetails.BillingDetails other = (InboundTransfer.OriginPaymentMethodDetails.BillingDetails) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$address = this.getAddress();
        final java.lang.Object other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) return false;
        final java.lang.Object this$email = this.getEmail();
        final java.lang.Object other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof InboundTransfer.OriginPaymentMethodDetails.BillingDetails;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $address = this.getAddress();
        result = result * PRIME + ($address == null ? 43 : $address.hashCode());
        final java.lang.Object $email = this.getEmail();
        result = result * PRIME + ($email == null ? 43 : $email.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        return result;
      }
    }


    public static class UsBankAccount extends StripeObject {
      /**
       * Account holder type: individual or company.
       *
       * <p>One of {@code company}, or {@code individual}.
       */
      @SerializedName("account_holder_type")
      String accountHolderType;
      /**
       * Account type: checkings or savings. Defaults to checking if omitted.
       *
       * <p>One of {@code checking}, or {@code savings}.
       */
      @SerializedName("account_type")
      String accountType;
      /** Name of the bank associated with the bank account. */
      @SerializedName("bank_name")
      String bankName;
      /**
       * Uniquely identifies this particular bank account. You can use this attribute to check
       * whether two bank accounts are the same.
       */
      @SerializedName("fingerprint")
      String fingerprint;
      /** Last four digits of the bank account number. */
      @SerializedName("last4")
      String last4;
      /**
       * The US bank account network used to debit funds.
       *
       * <p>Equal to {@code ach}.
       */
      @SerializedName("network")
      String network;
      @SerializedName("routing_number")
      String routingNumber;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getAccountHolderType() {
        return this.accountHolderType;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getAccountType() {
        return this.accountType;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getBankName() {
        return this.bankName;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getFingerprint() {
        return this.fingerprint;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getLast4() {
        return this.last4;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getNetwork() {
        return this.network;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getRoutingNumber() {
        return this.routingNumber;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAccountHolderType(final String accountHolderType) {
        this.accountHolderType = accountHolderType;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAccountType(final String accountType) {
        this.accountType = accountType;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setBankName(final String bankName) {
        this.bankName = bankName;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFingerprint(final String fingerprint) {
        this.fingerprint = fingerprint;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setLast4(final String last4) {
        this.last4 = last4;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setNetwork(final String network) {
        this.network = network;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRoutingNumber(final String routingNumber) {
        this.routingNumber = routingNumber;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof InboundTransfer.OriginPaymentMethodDetails.UsBankAccount)) return false;
        final InboundTransfer.OriginPaymentMethodDetails.UsBankAccount other = (InboundTransfer.OriginPaymentMethodDetails.UsBankAccount) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$accountHolderType = this.getAccountHolderType();
        final java.lang.Object other$accountHolderType = other.getAccountHolderType();
        if (this$accountHolderType == null ? other$accountHolderType != null : !this$accountHolderType.equals(other$accountHolderType)) return false;
        final java.lang.Object this$accountType = this.getAccountType();
        final java.lang.Object other$accountType = other.getAccountType();
        if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) return false;
        final java.lang.Object this$bankName = this.getBankName();
        final java.lang.Object other$bankName = other.getBankName();
        if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) return false;
        final java.lang.Object this$fingerprint = this.getFingerprint();
        final java.lang.Object other$fingerprint = other.getFingerprint();
        if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) return false;
        final java.lang.Object this$last4 = this.getLast4();
        final java.lang.Object other$last4 = other.getLast4();
        if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) return false;
        final java.lang.Object this$network = this.getNetwork();
        final java.lang.Object other$network = other.getNetwork();
        if (this$network == null ? other$network != null : !this$network.equals(other$network)) return false;
        final java.lang.Object this$routingNumber = this.getRoutingNumber();
        final java.lang.Object other$routingNumber = other.getRoutingNumber();
        if (this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof InboundTransfer.OriginPaymentMethodDetails.UsBankAccount;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $accountHolderType = this.getAccountHolderType();
        result = result * PRIME + ($accountHolderType == null ? 43 : $accountHolderType.hashCode());
        final java.lang.Object $accountType = this.getAccountType();
        result = result * PRIME + ($accountType == null ? 43 : $accountType.hashCode());
        final java.lang.Object $bankName = this.getBankName();
        result = result * PRIME + ($bankName == null ? 43 : $bankName.hashCode());
        final java.lang.Object $fingerprint = this.getFingerprint();
        result = result * PRIME + ($fingerprint == null ? 43 : $fingerprint.hashCode());
        final java.lang.Object $last4 = this.getLast4();
        result = result * PRIME + ($last4 == null ? 43 : $last4.hashCode());
        final java.lang.Object $network = this.getNetwork();
        result = result * PRIME + ($network == null ? 43 : $network.hashCode());
        final java.lang.Object $routingNumber = this.getRoutingNumber();
        result = result * PRIME + ($routingNumber == null ? 43 : $routingNumber.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BillingDetails getBillingDetails() {
      return this.billingDetails;
    }

    /**
     * The type of the payment method used in the InboundTransfer.
     *
     * <p>Equal to {@code us_bank_account}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public UsBankAccount getUsBankAccount() {
      return this.usBankAccount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBillingDetails(final BillingDetails billingDetails) {
      this.billingDetails = billingDetails;
    }

    /**
     * The type of the payment method used in the InboundTransfer.
     *
     * <p>Equal to {@code us_bank_account}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUsBankAccount(final UsBankAccount usBankAccount) {
      this.usBankAccount = usBankAccount;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof InboundTransfer.OriginPaymentMethodDetails)) return false;
      final InboundTransfer.OriginPaymentMethodDetails other = (InboundTransfer.OriginPaymentMethodDetails) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$billingDetails = this.getBillingDetails();
      final java.lang.Object other$billingDetails = other.getBillingDetails();
      if (this$billingDetails == null ? other$billingDetails != null : !this$billingDetails.equals(other$billingDetails)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      final java.lang.Object this$usBankAccount = this.getUsBankAccount();
      final java.lang.Object other$usBankAccount = other.getUsBankAccount();
      if (this$usBankAccount == null ? other$usBankAccount != null : !this$usBankAccount.equals(other$usBankAccount)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof InboundTransfer.OriginPaymentMethodDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $billingDetails = this.getBillingDetails();
      result = result * PRIME + ($billingDetails == null ? 43 : $billingDetails.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      final java.lang.Object $usBankAccount = this.getUsBankAccount();
      result = result * PRIME + ($usBankAccount == null ? 43 : $usBankAccount.hashCode());
      return result;
    }
  }


  /**
   * Routing number of the bank account.
   */
  public static class StatusTransitions extends StripeObject {
    /**
     * Timestamp describing when an InboundTransfer changed status to {@code canceled}.
     */
    @SerializedName("canceled_at")
    Long canceledAt;
    /**
     * Timestamp describing when an InboundTransfer changed status to {@code failed}.
     */
    @SerializedName("failed_at")
    Long failedAt;
    /**
     * Timestamp describing when an InboundTransfer changed status to {@code succeeded}.
     */
    @SerializedName("succeeded_at")
    Long succeededAt;

    /**
     * Timestamp describing when an InboundTransfer changed status to {@code canceled}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCanceledAt() {
      return this.canceledAt;
    }

    /**
     * Timestamp describing when an InboundTransfer changed status to {@code failed}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getFailedAt() {
      return this.failedAt;
    }

    /**
     * Timestamp describing when an InboundTransfer changed status to {@code succeeded}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getSucceededAt() {
      return this.succeededAt;
    }

    /**
     * Timestamp describing when an InboundTransfer changed status to {@code canceled}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCanceledAt(final Long canceledAt) {
      this.canceledAt = canceledAt;
    }

    /**
     * Timestamp describing when an InboundTransfer changed status to {@code failed}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFailedAt(final Long failedAt) {
      this.failedAt = failedAt;
    }

    /**
     * Timestamp describing when an InboundTransfer changed status to {@code succeeded}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSucceededAt(final Long succeededAt) {
      this.succeededAt = succeededAt;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof InboundTransfer.StatusTransitions)) return false;
      final InboundTransfer.StatusTransitions other = (InboundTransfer.StatusTransitions) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$canceledAt = this.getCanceledAt();
      final java.lang.Object other$canceledAt = other.getCanceledAt();
      if (this$canceledAt == null ? other$canceledAt != null : !this$canceledAt.equals(other$canceledAt)) return false;
      final java.lang.Object this$failedAt = this.getFailedAt();
      final java.lang.Object other$failedAt = other.getFailedAt();
      if (this$failedAt == null ? other$failedAt != null : !this$failedAt.equals(other$failedAt)) return false;
      final java.lang.Object this$succeededAt = this.getSucceededAt();
      final java.lang.Object other$succeededAt = other.getSucceededAt();
      if (this$succeededAt == null ? other$succeededAt != null : !this$succeededAt.equals(other$succeededAt)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof InboundTransfer.StatusTransitions;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $canceledAt = this.getCanceledAt();
      result = result * PRIME + ($canceledAt == null ? 43 : $canceledAt.hashCode());
      final java.lang.Object $failedAt = this.getFailedAt();
      result = result * PRIME + ($failedAt == null ? 43 : $failedAt.hashCode());
      final java.lang.Object $succeededAt = this.getSucceededAt();
      result = result * PRIME + ($succeededAt == null ? 43 : $succeededAt.hashCode());
      return result;
    }
  }

  public TestHelpers getTestHelpers() {
    return new TestHelpers(this);
  }


  public static class TestHelpers {
    private final InboundTransfer resource;

    private TestHelpers(InboundTransfer resource) {
      this.resource = resource;
    }

    /**
     * Transitions a test mode created InboundTransfer to the <code>succeeded</code> status. The
     * InboundTransfer must already be in the <code>processing</code> state.
     */
    public InboundTransfer succeed() throws StripeException {
      return succeed((Map<String, Object>) null, (RequestOptions) null);
    }

    /**
     * Transitions a test mode created InboundTransfer to the <code>succeeded</code> status. The
     * InboundTransfer must already be in the <code>processing</code> state.
     */
    public InboundTransfer succeed(RequestOptions options) throws StripeException {
      return succeed((Map<String, Object>) null, options);
    }

    /**
     * Transitions a test mode created InboundTransfer to the <code>succeeded</code> status. The
     * InboundTransfer must already be in the <code>processing</code> state.
     */
    public InboundTransfer succeed(Map<String, Object> params) throws StripeException {
      return succeed(params, (RequestOptions) null);
    }

    /**
     * Transitions a test mode created InboundTransfer to the <code>succeeded</code> status. The
     * InboundTransfer must already be in the <code>processing</code> state.
     */
    public InboundTransfer succeed(Map<String, Object> params, RequestOptions options) throws StripeException {
      String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/test_helpers/treasury/inbound_transfers/%s/succeed", ApiResource.urlEncodeId(this.resource.getId())));
      return ApiResource.request(ApiResource.RequestMethod.POST, url, params, InboundTransfer.class, options);
    }

    /**
     * Transitions a test mode created InboundTransfer to the <code>succeeded</code> status. The
     * InboundTransfer must already be in the <code>processing</code> state.
     */
    public InboundTransfer succeed(InboundTransferSucceedParams params) throws StripeException {
      return succeed(params, (RequestOptions) null);
    }

    /**
     * Transitions a test mode created InboundTransfer to the <code>succeeded</code> status. The
     * InboundTransfer must already be in the <code>processing</code> state.
     */
    public InboundTransfer succeed(InboundTransferSucceedParams params, RequestOptions options) throws StripeException {
      String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/test_helpers/treasury/inbound_transfers/%s/succeed", ApiResource.urlEncodeId(this.resource.getId())));
      return ApiResource.request(ApiResource.RequestMethod.POST, url, params, InboundTransfer.class, options);
    }

    /**
     * Transitions a test mode created InboundTransfer to the <code>failed</code> status. The
     * InboundTransfer must already be in the <code>processing</code> state.
     */
    public InboundTransfer fail() throws StripeException {
      return fail((Map<String, Object>) null, (RequestOptions) null);
    }

    /**
     * Transitions a test mode created InboundTransfer to the <code>failed</code> status. The
     * InboundTransfer must already be in the <code>processing</code> state.
     */
    public InboundTransfer fail(RequestOptions options) throws StripeException {
      return fail((Map<String, Object>) null, options);
    }

    /**
     * Transitions a test mode created InboundTransfer to the <code>failed</code> status. The
     * InboundTransfer must already be in the <code>processing</code> state.
     */
    public InboundTransfer fail(Map<String, Object> params) throws StripeException {
      return fail(params, (RequestOptions) null);
    }

    /**
     * Transitions a test mode created InboundTransfer to the <code>failed</code> status. The
     * InboundTransfer must already be in the <code>processing</code> state.
     */
    public InboundTransfer fail(Map<String, Object> params, RequestOptions options) throws StripeException {
      String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/test_helpers/treasury/inbound_transfers/%s/fail", ApiResource.urlEncodeId(this.resource.getId())));
      return ApiResource.request(ApiResource.RequestMethod.POST, url, params, InboundTransfer.class, options);
    }

    /**
     * Transitions a test mode created InboundTransfer to the <code>failed</code> status. The
     * InboundTransfer must already be in the <code>processing</code> state.
     */
    public InboundTransfer fail(InboundTransferFailParams params) throws StripeException {
      return fail(params, (RequestOptions) null);
    }

    /**
     * Transitions a test mode created InboundTransfer to the <code>failed</code> status. The
     * InboundTransfer must already be in the <code>processing</code> state.
     */
    public InboundTransfer fail(InboundTransferFailParams params, RequestOptions options) throws StripeException {
      String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/test_helpers/treasury/inbound_transfers/%s/fail", ApiResource.urlEncodeId(this.resource.getId())));
      return ApiResource.request(ApiResource.RequestMethod.POST, url, params, InboundTransfer.class, options);
    }

    /**
     * Marks the test mode InboundTransfer object as returned and links the InboundTransfer to a
     * ReceivedDebit. The InboundTransfer must already be in the <code>succeeded</code> state.
     */
    public InboundTransfer returnInboundTransfer() throws StripeException {
      return returnInboundTransfer((Map<String, Object>) null, (RequestOptions) null);
    }

    /**
     * Marks the test mode InboundTransfer object as returned and links the InboundTransfer to a
     * ReceivedDebit. The InboundTransfer must already be in the <code>succeeded</code> state.
     */
    public InboundTransfer returnInboundTransfer(RequestOptions options) throws StripeException {
      return returnInboundTransfer((Map<String, Object>) null, options);
    }

    /**
     * Marks the test mode InboundTransfer object as returned and links the InboundTransfer to a
     * ReceivedDebit. The InboundTransfer must already be in the <code>succeeded</code> state.
     */
    public InboundTransfer returnInboundTransfer(Map<String, Object> params) throws StripeException {
      return returnInboundTransfer(params, (RequestOptions) null);
    }

    /**
     * Marks the test mode InboundTransfer object as returned and links the InboundTransfer to a
     * ReceivedDebit. The InboundTransfer must already be in the <code>succeeded</code> state.
     */
    public InboundTransfer returnInboundTransfer(Map<String, Object> params, RequestOptions options) throws StripeException {
      String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/test_helpers/treasury/inbound_transfers/%s/return", ApiResource.urlEncodeId(this.resource.getId())));
      return ApiResource.request(ApiResource.RequestMethod.POST, url, params, InboundTransfer.class, options);
    }

    /**
     * Marks the test mode InboundTransfer object as returned and links the InboundTransfer to a
     * ReceivedDebit. The InboundTransfer must already be in the <code>succeeded</code> state.
     */
    public InboundTransfer returnInboundTransfer(InboundTransferReturnInboundTransferParams params) throws StripeException {
      return returnInboundTransfer(params, (RequestOptions) null);
    }

    /**
     * Marks the test mode InboundTransfer object as returned and links the InboundTransfer to a
     * ReceivedDebit. The InboundTransfer must already be in the <code>succeeded</code> state.
     */
    public InboundTransfer returnInboundTransfer(InboundTransferReturnInboundTransferParams params, RequestOptions options) throws StripeException {
      String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/test_helpers/treasury/inbound_transfers/%s/return", ApiResource.urlEncodeId(this.resource.getId())));
      return ApiResource.request(ApiResource.RequestMethod.POST, url, params, InboundTransfer.class, options);
    }
  }

  /**
   * Amount (in cents) transferred.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmount() {
    return this.amount;
  }

  /**
   * Returns {@code true} if the InboundTransfer is able to be canceled.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getCancelable() {
    return this.cancelable;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDescription() {
    return this.description;
  }

  /**
   * Details about this InboundTransfer's failure. Only set when status is {@code failed}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public FailureDetails getFailureDetails() {
    return this.failureDetails;
  }

  /**
   * The FinancialAccount that received the funds.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFinancialAccount() {
    return this.financialAccount;
  }

  /**
   * A <a href="https://stripe.com/docs/treasury/moving-money/regulatory-receipts">hosted
   * transaction receipt</a> URL that is provided when money movement is considered regulated under
   * Stripe's money transmission licenses.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getHostedRegulatoryReceiptUrl() {
    return this.hostedRegulatoryReceiptUrl;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LinkedFlows getLinkedFlows() {
    return this.linkedFlows;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code treasury.inbound_transfer}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * The origin payment method to be debited for an InboundTransfer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getOriginPaymentMethod() {
    return this.originPaymentMethod;
  }

  /**
   * Details about the PaymentMethod for an InboundTransfer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public OriginPaymentMethodDetails getOriginPaymentMethodDetails() {
    return this.originPaymentMethodDetails;
  }

  /**
   * Returns {@code true} if the funds for an InboundTransfer were returned after the
   * InboundTransfer went to the {@code succeeded} state.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getReturned() {
    return this.returned;
  }

  /**
   * Statement descriptor shown when funds are debited from the source. Not all payment networks
   * support {@code statement_descriptor}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatementDescriptor() {
    return this.statementDescriptor;
  }

  /**
   * Status of the InboundTransfer: {@code processing}, {@code succeeded}, {@code failed}, and
   * {@code canceled}. An InboundTransfer is {@code processing} if it is created and pending. The
   * status changes to {@code succeeded} once the funds have been &quot;confirmed&quot; and a {@code
   * transaction} is created and posted. The status changes to {@code failed} if the transfer fails.
   *
   * <p>One of {@code canceled}, {@code failed}, {@code processing}, or {@code succeeded}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public StatusTransitions getStatusTransitions() {
    return this.statusTransitions;
  }

  /**
   * Amount (in cents) transferred.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final Long amount) {
    this.amount = amount;
  }

  /**
   * Returns {@code true} if the InboundTransfer is able to be canceled.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCancelable(final Boolean cancelable) {
    this.cancelable = cancelable;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDescription(final String description) {
    this.description = description;
  }

  /**
   * Details about this InboundTransfer's failure. Only set when status is {@code failed}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFailureDetails(final FailureDetails failureDetails) {
    this.failureDetails = failureDetails;
  }

  /**
   * The FinancialAccount that received the funds.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFinancialAccount(final String financialAccount) {
    this.financialAccount = financialAccount;
  }

  /**
   * A <a href="https://stripe.com/docs/treasury/moving-money/regulatory-receipts">hosted
   * transaction receipt</a> URL that is provided when money movement is considered regulated under
   * Stripe's money transmission licenses.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHostedRegulatoryReceiptUrl(final String hostedRegulatoryReceiptUrl) {
    this.hostedRegulatoryReceiptUrl = hostedRegulatoryReceiptUrl;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLinkedFlows(final LinkedFlows linkedFlows) {
    this.linkedFlows = linkedFlows;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code treasury.inbound_transfer}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * The origin payment method to be debited for an InboundTransfer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOriginPaymentMethod(final String originPaymentMethod) {
    this.originPaymentMethod = originPaymentMethod;
  }

  /**
   * Details about the PaymentMethod for an InboundTransfer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOriginPaymentMethodDetails(final OriginPaymentMethodDetails originPaymentMethodDetails) {
    this.originPaymentMethodDetails = originPaymentMethodDetails;
  }

  /**
   * Returns {@code true} if the funds for an InboundTransfer were returned after the
   * InboundTransfer went to the {@code succeeded} state.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReturned(final Boolean returned) {
    this.returned = returned;
  }

  /**
   * Statement descriptor shown when funds are debited from the source. Not all payment networks
   * support {@code statement_descriptor}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatementDescriptor(final String statementDescriptor) {
    this.statementDescriptor = statementDescriptor;
  }

  /**
   * Status of the InboundTransfer: {@code processing}, {@code succeeded}, {@code failed}, and
   * {@code canceled}. An InboundTransfer is {@code processing} if it is created and pending. The
   * status changes to {@code succeeded} once the funds have been &quot;confirmed&quot; and a {@code
   * transaction} is created and posted. The status changes to {@code failed} if the transfer fails.
   *
   * <p>One of {@code canceled}, {@code failed}, {@code processing}, or {@code succeeded}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatusTransitions(final StatusTransitions statusTransitions) {
    this.statusTransitions = statusTransitions;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof InboundTransfer)) return false;
    final InboundTransfer other = (InboundTransfer) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$cancelable = this.getCancelable();
    final java.lang.Object other$cancelable = other.getCancelable();
    if (this$cancelable == null ? other$cancelable != null : !this$cancelable.equals(other$cancelable)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$returned = this.getReturned();
    final java.lang.Object other$returned = other.getReturned();
    if (this$returned == null ? other$returned != null : !this$returned.equals(other$returned)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$description = this.getDescription();
    final java.lang.Object other$description = other.getDescription();
    if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
    final java.lang.Object this$failureDetails = this.getFailureDetails();
    final java.lang.Object other$failureDetails = other.getFailureDetails();
    if (this$failureDetails == null ? other$failureDetails != null : !this$failureDetails.equals(other$failureDetails)) return false;
    final java.lang.Object this$financialAccount = this.getFinancialAccount();
    final java.lang.Object other$financialAccount = other.getFinancialAccount();
    if (this$financialAccount == null ? other$financialAccount != null : !this$financialAccount.equals(other$financialAccount)) return false;
    final java.lang.Object this$hostedRegulatoryReceiptUrl = this.getHostedRegulatoryReceiptUrl();
    final java.lang.Object other$hostedRegulatoryReceiptUrl = other.getHostedRegulatoryReceiptUrl();
    if (this$hostedRegulatoryReceiptUrl == null ? other$hostedRegulatoryReceiptUrl != null : !this$hostedRegulatoryReceiptUrl.equals(other$hostedRegulatoryReceiptUrl)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$linkedFlows = this.getLinkedFlows();
    final java.lang.Object other$linkedFlows = other.getLinkedFlows();
    if (this$linkedFlows == null ? other$linkedFlows != null : !this$linkedFlows.equals(other$linkedFlows)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$originPaymentMethod = this.getOriginPaymentMethod();
    final java.lang.Object other$originPaymentMethod = other.getOriginPaymentMethod();
    if (this$originPaymentMethod == null ? other$originPaymentMethod != null : !this$originPaymentMethod.equals(other$originPaymentMethod)) return false;
    final java.lang.Object this$originPaymentMethodDetails = this.getOriginPaymentMethodDetails();
    final java.lang.Object other$originPaymentMethodDetails = other.getOriginPaymentMethodDetails();
    if (this$originPaymentMethodDetails == null ? other$originPaymentMethodDetails != null : !this$originPaymentMethodDetails.equals(other$originPaymentMethodDetails)) return false;
    final java.lang.Object this$statementDescriptor = this.getStatementDescriptor();
    final java.lang.Object other$statementDescriptor = other.getStatementDescriptor();
    if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$statusTransitions = this.getStatusTransitions();
    final java.lang.Object other$statusTransitions = other.getStatusTransitions();
    if (this$statusTransitions == null ? other$statusTransitions != null : !this$statusTransitions.equals(other$statusTransitions)) return false;
    final java.lang.Object this$transaction = this.getTransaction();
    final java.lang.Object other$transaction = other.getTransaction();
    if (this$transaction == null ? other$transaction != null : !this$transaction.equals(other$transaction)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof InboundTransfer;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $cancelable = this.getCancelable();
    result = result * PRIME + ($cancelable == null ? 43 : $cancelable.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $returned = this.getReturned();
    result = result * PRIME + ($returned == null ? 43 : $returned.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $description = this.getDescription();
    result = result * PRIME + ($description == null ? 43 : $description.hashCode());
    final java.lang.Object $failureDetails = this.getFailureDetails();
    result = result * PRIME + ($failureDetails == null ? 43 : $failureDetails.hashCode());
    final java.lang.Object $financialAccount = this.getFinancialAccount();
    result = result * PRIME + ($financialAccount == null ? 43 : $financialAccount.hashCode());
    final java.lang.Object $hostedRegulatoryReceiptUrl = this.getHostedRegulatoryReceiptUrl();
    result = result * PRIME + ($hostedRegulatoryReceiptUrl == null ? 43 : $hostedRegulatoryReceiptUrl.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $linkedFlows = this.getLinkedFlows();
    result = result * PRIME + ($linkedFlows == null ? 43 : $linkedFlows.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $originPaymentMethod = this.getOriginPaymentMethod();
    result = result * PRIME + ($originPaymentMethod == null ? 43 : $originPaymentMethod.hashCode());
    final java.lang.Object $originPaymentMethodDetails = this.getOriginPaymentMethodDetails();
    result = result * PRIME + ($originPaymentMethodDetails == null ? 43 : $originPaymentMethodDetails.hashCode());
    final java.lang.Object $statementDescriptor = this.getStatementDescriptor();
    result = result * PRIME + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $statusTransitions = this.getStatusTransitions();
    result = result * PRIME + ($statusTransitions == null ? 43 : $statusTransitions.hashCode());
    final java.lang.Object $transaction = this.getTransaction();
    result = result * PRIME + ($transaction == null ? 43 : $transaction.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
