// Generated by delombok at Wed Nov 16 20:46:34 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiResource;

/**
 * Customers with certain payments enabled have a cash balance, representing funds that were paid by
 * the customer to a merchant, but have not yet been allocated to a payment. Cash Balance
 * Transactions represent when funds are moved into or out of this balance. This includes funding by
 * the customer, allocation to payments, and refunds to the customer.
 */
public class CustomerCashBalanceTransaction extends StripeObject implements HasId {
  @SerializedName("applied_to_payment")
  AppliedToPayment appliedToPayment;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @SerializedName("currency")
  String currency;
  /**
   * The customer whose available cash balance changed as a result of this transaction.
   */
  @SerializedName("customer")
  ExpandableField<Customer> customer;
  /**
   * The total available cash balance for the specified currency after this transaction was applied.
   * Represented in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest currency
   * unit</a>.
   */
  @SerializedName("ending_balance")
  Long endingBalance;
  @SerializedName("funded")
  Funded funded;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * The amount by which the cash balance changed, represented in the <a
   * href="https://stripe.com/docs/currencies#zero-decimal">smallest currency unit</a>. A positive
   * value represents funds being added to the cash balance, a negative value represents funds being
   * removed from the cash balance.
   */
  @SerializedName("net_amount")
  Long netAmount;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code customer_cash_balance_transaction}.
   */
  @SerializedName("object")
  String object;
  @SerializedName("refunded_from_payment")
  RefundedFromPayment refundedFromPayment;
  /**
   * The type of the cash balance transaction. One of {@code applied_to_payment}, {@code
   * unapplied_from_payment}, {@code refunded_from_payment}, {@code funded}, {@code
   * return_initiated}, or {@code return_canceled}. New types may be added in future. See <a
   * href="https://stripe.com/docs/payments/customer-balance#types">Customer Balance</a> to learn
   * more about these types.
   */
  @SerializedName("type")
  String type;
  @SerializedName("unapplied_from_payment")
  UnappliedFromPayment unappliedFromPayment;

  /**
   * Get ID of expandable {@code customer} object.
   */
  public String getCustomer() {
    return (this.customer != null) ? this.customer.getId() : null;
  }

  public void setCustomer(String id) {
    this.customer = ApiResource.setExpandableFieldId(id, this.customer);
  }

  /**
   * Get expanded {@code customer}.
   */
  public Customer getCustomerObject() {
    return (this.customer != null) ? this.customer.getExpanded() : null;
  }

  public void setCustomerObject(Customer expandableObject) {
    this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
  }


  public static class AppliedToPayment extends StripeObject {
    /**
     * The <a href="https://stripe.com/docs/api/payment_intents/object">Payment Intent</a> that
     * funds were applied to.
     */
    @SerializedName("payment_intent")
    ExpandableField<PaymentIntent> paymentIntent;

    /**
     * Get ID of expandable {@code paymentIntent} object.
     */
    public String getPaymentIntent() {
      return (this.paymentIntent != null) ? this.paymentIntent.getId() : null;
    }

    public void setPaymentIntent(String id) {
      this.paymentIntent = ApiResource.setExpandableFieldId(id, this.paymentIntent);
    }

    /**
     * Get expanded {@code paymentIntent}.
     */
    public PaymentIntent getPaymentIntentObject() {
      return (this.paymentIntent != null) ? this.paymentIntent.getExpanded() : null;
    }

    public void setPaymentIntentObject(PaymentIntent expandableObject) {
      this.paymentIntent = new ExpandableField<PaymentIntent>(expandableObject.getId(), expandableObject);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof CustomerCashBalanceTransaction.AppliedToPayment)) return false;
      final CustomerCashBalanceTransaction.AppliedToPayment other = (CustomerCashBalanceTransaction.AppliedToPayment) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$paymentIntent = this.getPaymentIntent();
      final java.lang.Object other$paymentIntent = other.getPaymentIntent();
      if (this$paymentIntent == null ? other$paymentIntent != null : !this$paymentIntent.equals(other$paymentIntent)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof CustomerCashBalanceTransaction.AppliedToPayment;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $paymentIntent = this.getPaymentIntent();
      result = result * PRIME + ($paymentIntent == null ? 43 : $paymentIntent.hashCode());
      return result;
    }
  }


  public static class Funded extends StripeObject {
    @SerializedName("bank_transfer")
    BankTransfer bankTransfer;


    public static class BankTransfer extends StripeObject {
      @SerializedName("eu_bank_transfer")
      EuBankTransfer euBankTransfer;
      /** The user-supplied reference field on the bank transfer. */
      @SerializedName("reference")
      String reference;
      /**
       * The funding method type used to fund the customer balance. Permitted values include: {@code
       * eu_bank_transfer}, {@code gb_bank_transfer}, {@code jp_bank_transfer}, or {@code
       * mx_bank_transfer}.
       *
       * <p>One of {@code eu_bank_transfer}, {@code gb_bank_transfer}, {@code jp_bank_transfer}, or
       * {@code mx_bank_transfer}.
       */
      @SerializedName("type")
      String type;


      public static class EuBankTransfer extends StripeObject {
        /** The BIC of the bank of the sender of the funding. */
        @SerializedName("bic")
        String bic;
        /** The last 4 digits of the IBAN of the sender of the funding. */
        @SerializedName("iban_last4")
        String ibanLast4;
        @SerializedName("sender_name")
        String senderName;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getBic() {
          return this.bic;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getIbanLast4() {
          return this.ibanLast4;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getSenderName() {
          return this.senderName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setBic(final String bic) {
          this.bic = bic;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setIbanLast4(final String ibanLast4) {
          this.ibanLast4 = ibanLast4;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setSenderName(final String senderName) {
          this.senderName = senderName;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof CustomerCashBalanceTransaction.Funded.BankTransfer.EuBankTransfer)) return false;
          final CustomerCashBalanceTransaction.Funded.BankTransfer.EuBankTransfer other = (CustomerCashBalanceTransaction.Funded.BankTransfer.EuBankTransfer) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$bic = this.getBic();
          final java.lang.Object other$bic = other.getBic();
          if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) return false;
          final java.lang.Object this$ibanLast4 = this.getIbanLast4();
          final java.lang.Object other$ibanLast4 = other.getIbanLast4();
          if (this$ibanLast4 == null ? other$ibanLast4 != null : !this$ibanLast4.equals(other$ibanLast4)) return false;
          final java.lang.Object this$senderName = this.getSenderName();
          final java.lang.Object other$senderName = other.getSenderName();
          if (this$senderName == null ? other$senderName != null : !this$senderName.equals(other$senderName)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof CustomerCashBalanceTransaction.Funded.BankTransfer.EuBankTransfer;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $bic = this.getBic();
          result = result * PRIME + ($bic == null ? 43 : $bic.hashCode());
          final java.lang.Object $ibanLast4 = this.getIbanLast4();
          result = result * PRIME + ($ibanLast4 == null ? 43 : $ibanLast4.hashCode());
          final java.lang.Object $senderName = this.getSenderName();
          result = result * PRIME + ($senderName == null ? 43 : $senderName.hashCode());
          return result;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public EuBankTransfer getEuBankTransfer() {
        return this.euBankTransfer;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getReference() {
        return this.reference;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getType() {
        return this.type;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setEuBankTransfer(final EuBankTransfer euBankTransfer) {
        this.euBankTransfer = euBankTransfer;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setReference(final String reference) {
        this.reference = reference;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setType(final String type) {
        this.type = type;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof CustomerCashBalanceTransaction.Funded.BankTransfer)) return false;
        final CustomerCashBalanceTransaction.Funded.BankTransfer other = (CustomerCashBalanceTransaction.Funded.BankTransfer) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$euBankTransfer = this.getEuBankTransfer();
        final java.lang.Object other$euBankTransfer = other.getEuBankTransfer();
        if (this$euBankTransfer == null ? other$euBankTransfer != null : !this$euBankTransfer.equals(other$euBankTransfer)) return false;
        final java.lang.Object this$reference = this.getReference();
        final java.lang.Object other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) return false;
        final java.lang.Object this$type = this.getType();
        final java.lang.Object other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof CustomerCashBalanceTransaction.Funded.BankTransfer;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $euBankTransfer = this.getEuBankTransfer();
        result = result * PRIME + ($euBankTransfer == null ? 43 : $euBankTransfer.hashCode());
        final java.lang.Object $reference = this.getReference();
        result = result * PRIME + ($reference == null ? 43 : $reference.hashCode());
        final java.lang.Object $type = this.getType();
        result = result * PRIME + ($type == null ? 43 : $type.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BankTransfer getBankTransfer() {
      return this.bankTransfer;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBankTransfer(final BankTransfer bankTransfer) {
      this.bankTransfer = bankTransfer;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof CustomerCashBalanceTransaction.Funded)) return false;
      final CustomerCashBalanceTransaction.Funded other = (CustomerCashBalanceTransaction.Funded) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$bankTransfer = this.getBankTransfer();
      final java.lang.Object other$bankTransfer = other.getBankTransfer();
      if (this$bankTransfer == null ? other$bankTransfer != null : !this$bankTransfer.equals(other$bankTransfer)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof CustomerCashBalanceTransaction.Funded;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $bankTransfer = this.getBankTransfer();
      result = result * PRIME + ($bankTransfer == null ? 43 : $bankTransfer.hashCode());
      return result;
    }
  }


  /**
   * The full name of the sender, as supplied by the sending bank.
   */
  public static class RefundedFromPayment extends StripeObject {
    /**
     * The <a href="https://stripe.com/docs/api/refunds/object">Refund</a> that moved these funds
     * into the customer's cash balance.
     */
    @SerializedName("refund")
    ExpandableField<Refund> refund;

    /**
     * Get ID of expandable {@code refund} object.
     */
    public String getRefund() {
      return (this.refund != null) ? this.refund.getId() : null;
    }

    public void setRefund(String id) {
      this.refund = ApiResource.setExpandableFieldId(id, this.refund);
    }

    /**
     * Get expanded {@code refund}.
     */
    public Refund getRefundObject() {
      return (this.refund != null) ? this.refund.getExpanded() : null;
    }

    public void setRefundObject(Refund expandableObject) {
      this.refund = new ExpandableField<Refund>(expandableObject.getId(), expandableObject);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof CustomerCashBalanceTransaction.RefundedFromPayment)) return false;
      final CustomerCashBalanceTransaction.RefundedFromPayment other = (CustomerCashBalanceTransaction.RefundedFromPayment) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$refund = this.getRefund();
      final java.lang.Object other$refund = other.getRefund();
      if (this$refund == null ? other$refund != null : !this$refund.equals(other$refund)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof CustomerCashBalanceTransaction.RefundedFromPayment;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $refund = this.getRefund();
      result = result * PRIME + ($refund == null ? 43 : $refund.hashCode());
      return result;
    }
  }


  public static class UnappliedFromPayment extends StripeObject {
    /**
     * The <a href="https://stripe.com/docs/api/payment_intents/object">Payment Intent</a> that
     * funds were unapplied from.
     */
    @SerializedName("payment_intent")
    ExpandableField<PaymentIntent> paymentIntent;

    /** Get ID of expandable {@code paymentIntent} object. */
    public String getPaymentIntent() {
      return (this.paymentIntent != null) ? this.paymentIntent.getId() : null;
    }

    public void setPaymentIntent(String id) {
      this.paymentIntent = ApiResource.setExpandableFieldId(id, this.paymentIntent);
    }

    /** Get expanded {@code paymentIntent}. */
    public PaymentIntent getPaymentIntentObject() {
      return (this.paymentIntent != null) ? this.paymentIntent.getExpanded() : null;
    }

    public void setPaymentIntentObject(PaymentIntent expandableObject) {
      this.paymentIntent = new ExpandableField<PaymentIntent>(expandableObject.getId(), expandableObject);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof CustomerCashBalanceTransaction.UnappliedFromPayment)) return false;
      final CustomerCashBalanceTransaction.UnappliedFromPayment other = (CustomerCashBalanceTransaction.UnappliedFromPayment) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$paymentIntent = this.getPaymentIntent();
      final java.lang.Object other$paymentIntent = other.getPaymentIntent();
      if (this$paymentIntent == null ? other$paymentIntent != null : !this$paymentIntent.equals(other$paymentIntent)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof CustomerCashBalanceTransaction.UnappliedFromPayment;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $paymentIntent = this.getPaymentIntent();
      result = result * PRIME + ($paymentIntent == null ? 43 : $paymentIntent.hashCode());
      return result;
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AppliedToPayment getAppliedToPayment() {
    return this.appliedToPayment;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * The total available cash balance for the specified currency after this transaction was applied.
   * Represented in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest currency
   * unit</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getEndingBalance() {
    return this.endingBalance;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Funded getFunded() {
    return this.funded;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * The amount by which the cash balance changed, represented in the <a
   * href="https://stripe.com/docs/currencies#zero-decimal">smallest currency unit</a>. A positive
   * value represents funds being added to the cash balance, a negative value represents funds being
   * removed from the cash balance.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getNetAmount() {
    return this.netAmount;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code customer_cash_balance_transaction}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public RefundedFromPayment getRefundedFromPayment() {
    return this.refundedFromPayment;
  }

  /**
   * The type of the cash balance transaction. One of {@code applied_to_payment}, {@code
   * unapplied_from_payment}, {@code refunded_from_payment}, {@code funded}, {@code
   * return_initiated}, or {@code return_canceled}. New types may be added in future. See <a
   * href="https://stripe.com/docs/payments/customer-balance#types">Customer Balance</a> to learn
   * more about these types.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getType() {
    return this.type;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public UnappliedFromPayment getUnappliedFromPayment() {
    return this.unappliedFromPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAppliedToPayment(final AppliedToPayment appliedToPayment) {
    this.appliedToPayment = appliedToPayment;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * The total available cash balance for the specified currency after this transaction was applied.
   * Represented in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest currency
   * unit</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEndingBalance(final Long endingBalance) {
    this.endingBalance = endingBalance;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFunded(final Funded funded) {
    this.funded = funded;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * The amount by which the cash balance changed, represented in the <a
   * href="https://stripe.com/docs/currencies#zero-decimal">smallest currency unit</a>. A positive
   * value represents funds being added to the cash balance, a negative value represents funds being
   * removed from the cash balance.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNetAmount(final Long netAmount) {
    this.netAmount = netAmount;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code customer_cash_balance_transaction}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRefundedFromPayment(final RefundedFromPayment refundedFromPayment) {
    this.refundedFromPayment = refundedFromPayment;
  }

  /**
   * The type of the cash balance transaction. One of {@code applied_to_payment}, {@code
   * unapplied_from_payment}, {@code refunded_from_payment}, {@code funded}, {@code
   * return_initiated}, or {@code return_canceled}. New types may be added in future. See <a
   * href="https://stripe.com/docs/payments/customer-balance#types">Customer Balance</a> to learn
   * more about these types.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setType(final String type) {
    this.type = type;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setUnappliedFromPayment(final UnappliedFromPayment unappliedFromPayment) {
    this.unappliedFromPayment = unappliedFromPayment;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof CustomerCashBalanceTransaction)) return false;
    final CustomerCashBalanceTransaction other = (CustomerCashBalanceTransaction) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$endingBalance = this.getEndingBalance();
    final java.lang.Object other$endingBalance = other.getEndingBalance();
    if (this$endingBalance == null ? other$endingBalance != null : !this$endingBalance.equals(other$endingBalance)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$netAmount = this.getNetAmount();
    final java.lang.Object other$netAmount = other.getNetAmount();
    if (this$netAmount == null ? other$netAmount != null : !this$netAmount.equals(other$netAmount)) return false;
    final java.lang.Object this$appliedToPayment = this.getAppliedToPayment();
    final java.lang.Object other$appliedToPayment = other.getAppliedToPayment();
    if (this$appliedToPayment == null ? other$appliedToPayment != null : !this$appliedToPayment.equals(other$appliedToPayment)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$customer = this.getCustomer();
    final java.lang.Object other$customer = other.getCustomer();
    if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) return false;
    final java.lang.Object this$funded = this.getFunded();
    final java.lang.Object other$funded = other.getFunded();
    if (this$funded == null ? other$funded != null : !this$funded.equals(other$funded)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$refundedFromPayment = this.getRefundedFromPayment();
    final java.lang.Object other$refundedFromPayment = other.getRefundedFromPayment();
    if (this$refundedFromPayment == null ? other$refundedFromPayment != null : !this$refundedFromPayment.equals(other$refundedFromPayment)) return false;
    final java.lang.Object this$type = this.getType();
    final java.lang.Object other$type = other.getType();
    if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
    final java.lang.Object this$unappliedFromPayment = this.getUnappliedFromPayment();
    final java.lang.Object other$unappliedFromPayment = other.getUnappliedFromPayment();
    if (this$unappliedFromPayment == null ? other$unappliedFromPayment != null : !this$unappliedFromPayment.equals(other$unappliedFromPayment)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof CustomerCashBalanceTransaction;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $endingBalance = this.getEndingBalance();
    result = result * PRIME + ($endingBalance == null ? 43 : $endingBalance.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $netAmount = this.getNetAmount();
    result = result * PRIME + ($netAmount == null ? 43 : $netAmount.hashCode());
    final java.lang.Object $appliedToPayment = this.getAppliedToPayment();
    result = result * PRIME + ($appliedToPayment == null ? 43 : $appliedToPayment.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $customer = this.getCustomer();
    result = result * PRIME + ($customer == null ? 43 : $customer.hashCode());
    final java.lang.Object $funded = this.getFunded();
    result = result * PRIME + ($funded == null ? 43 : $funded.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $refundedFromPayment = this.getRefundedFromPayment();
    result = result * PRIME + ($refundedFromPayment == null ? 43 : $refundedFromPayment.hashCode());
    final java.lang.Object $type = this.getType();
    result = result * PRIME + ($type == null ? 43 : $type.hashCode());
    final java.lang.Object $unappliedFromPayment = this.getUnappliedFromPayment();
    result = result * PRIME + ($unappliedFromPayment == null ? 43 : $unappliedFromPayment.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
