/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.giftcards;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.model.giftcards.TransactionCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.giftcards.TransactionCancelParams;
import com.stripe.param.giftcards.TransactionConfirmParams;
import com.stripe.param.giftcards.TransactionCreateParams;
import com.stripe.param.giftcards.TransactionListParams;
import com.stripe.param.giftcards.TransactionRetrieveParams;
import com.stripe.param.giftcards.TransactionUpdateParams;
import java.util.Map;
import lombok.Generated;

public class Transaction
extends ApiResource
implements HasId,
MetadataStore<Transaction> {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="confirmed_at")
    Long confirmedAt;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="created_by")
    CreatedBy createdBy;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="gift_card")
    String giftCard;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="transfer_group")
    String transferGroup;

    public Transaction cancel() throws StripeException {
        return this.cancel((Map<String, Object>)null, (RequestOptions)null);
    }

    public Transaction cancel(RequestOptions options) throws StripeException {
        return this.cancel((Map<String, Object>)null, options);
    }

    public Transaction cancel(Map<String, Object> params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public Transaction cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/gift_cards/transactions/%s/cancel", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Transaction.class, options);
    }

    public Transaction cancel(TransactionCancelParams params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public Transaction cancel(TransactionCancelParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/gift_cards/transactions/%s/cancel", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Transaction.class, options);
    }

    public Transaction confirm() throws StripeException {
        return this.confirm((Map<String, Object>)null, (RequestOptions)null);
    }

    public Transaction confirm(RequestOptions options) throws StripeException {
        return this.confirm((Map<String, Object>)null, options);
    }

    public Transaction confirm(Map<String, Object> params) throws StripeException {
        return this.confirm(params, (RequestOptions)null);
    }

    public Transaction confirm(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/gift_cards/transactions/%s/confirm", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Transaction.class, options);
    }

    public Transaction confirm(TransactionConfirmParams params) throws StripeException {
        return this.confirm(params, (RequestOptions)null);
    }

    public Transaction confirm(TransactionConfirmParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/gift_cards/transactions/%s/confirm", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Transaction.class, options);
    }

    public static Transaction create(Map<String, Object> params) throws StripeException {
        return Transaction.create(params, (RequestOptions)null);
    }

    public static Transaction create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/gift_cards/transactions");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Transaction.class, options);
    }

    public static Transaction create(TransactionCreateParams params) throws StripeException {
        return Transaction.create(params, (RequestOptions)null);
    }

    public static Transaction create(TransactionCreateParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/gift_cards/transactions");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Transaction.class, options);
    }

    public static TransactionCollection list(Map<String, Object> params) throws StripeException {
        return Transaction.list(params, (RequestOptions)null);
    }

    public static TransactionCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/gift_cards/transactions");
        return ApiResource.requestCollection(url, params, TransactionCollection.class, options);
    }

    public static TransactionCollection list(TransactionListParams params) throws StripeException {
        return Transaction.list(params, (RequestOptions)null);
    }

    public static TransactionCollection list(TransactionListParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/gift_cards/transactions");
        return ApiResource.requestCollection(url, params, TransactionCollection.class, options);
    }

    public static Transaction retrieve(String id) throws StripeException {
        return Transaction.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Transaction retrieve(String id, RequestOptions options) throws StripeException {
        return Transaction.retrieve(id, (Map<String, Object>)null, options);
    }

    public static Transaction retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/gift_cards/transactions/%s", ApiResource.urlEncodeId(id)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Transaction.class, options);
    }

    public static Transaction retrieve(String id, TransactionRetrieveParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/gift_cards/transactions/%s", ApiResource.urlEncodeId(id)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Transaction.class, options);
    }

    public Transaction update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Transaction update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/gift_cards/transactions/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Transaction.class, options);
    }

    public Transaction update(TransactionUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Transaction update(TransactionUpdateParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/gift_cards/transactions/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Transaction.class, options);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getConfirmedAt() {
        return this.confirmedAt;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public CreatedBy getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getGiftCard() {
        return this.giftCard;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getTransferGroup() {
        return this.transferGroup;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setConfirmedAt(Long confirmedAt) {
        this.confirmedAt = confirmedAt;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCreatedBy(CreatedBy createdBy) {
        this.createdBy = createdBy;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setGiftCard(String giftCard) {
        this.giftCard = giftCard;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setTransferGroup(String transferGroup) {
        this.transferGroup = transferGroup;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transaction)) {
            return false;
        }
        Transaction other = (Transaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$confirmedAt = this.getConfirmedAt();
        Long other$confirmedAt = other.getConfirmedAt();
        if (this$confirmedAt == null ? other$confirmedAt != null : !((Object)this$confirmedAt).equals(other$confirmedAt)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        CreatedBy this$createdBy = this.getCreatedBy();
        CreatedBy other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !((Object)this$createdBy).equals(other$createdBy)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$giftCard = this.getGiftCard();
        String other$giftCard = other.getGiftCard();
        if (this$giftCard == null ? other$giftCard != null : !this$giftCard.equals(other$giftCard)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$transferGroup = this.getTransferGroup();
        String other$transferGroup = other.getTransferGroup();
        return !(this$transferGroup == null ? other$transferGroup != null : !this$transferGroup.equals(other$transferGroup));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Transaction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $confirmedAt = this.getConfirmedAt();
        result = result * 59 + ($confirmedAt == null ? 43 : ((Object)$confirmedAt).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        CreatedBy $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : ((Object)$createdBy).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $giftCard = this.getGiftCard();
        result = result * 59 + ($giftCard == null ? 43 : $giftCard.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $transferGroup = this.getTransferGroup();
        result = result * 59 + ($transferGroup == null ? 43 : $transferGroup.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class CreatedBy
    extends StripeObject {
        @SerializedName(value="checkout")
        Checkout checkout;
        @SerializedName(value="order")
        Order order;
        @SerializedName(value="payment")
        Payment payment;
        @SerializedName(value="type")
        String type;

        @Generated
        public Checkout getCheckout() {
            return this.checkout;
        }

        @Generated
        public Order getOrder() {
            return this.order;
        }

        @Generated
        public Payment getPayment() {
            return this.payment;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setCheckout(Checkout checkout) {
            this.checkout = checkout;
        }

        @Generated
        public void setOrder(Order order) {
            this.order = order;
        }

        @Generated
        public void setPayment(Payment payment) {
            this.payment = payment;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreatedBy)) {
                return false;
            }
            CreatedBy other = (CreatedBy)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Checkout this$checkout = this.getCheckout();
            Checkout other$checkout = other.getCheckout();
            if (this$checkout == null ? other$checkout != null : !((Object)this$checkout).equals(other$checkout)) {
                return false;
            }
            Order this$order = this.getOrder();
            Order other$order = other.getOrder();
            if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
                return false;
            }
            Payment this$payment = this.getPayment();
            Payment other$payment = other.getPayment();
            if (this$payment == null ? other$payment != null : !((Object)this$payment).equals(other$payment)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CreatedBy;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Checkout $checkout = this.getCheckout();
            result = result * 59 + ($checkout == null ? 43 : ((Object)$checkout).hashCode());
            Order $order = this.getOrder();
            result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
            Payment $payment = this.getPayment();
            result = result * 59 + ($payment == null ? 43 : ((Object)$payment).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class Checkout
        extends StripeObject {
            @SerializedName(value="checkout_session")
            String checkoutSession;
            @SerializedName(value="line_item")
            String lineItem;

            @Generated
            public String getCheckoutSession() {
                return this.checkoutSession;
            }

            @Generated
            public String getLineItem() {
                return this.lineItem;
            }

            @Generated
            public void setCheckoutSession(String checkoutSession) {
                this.checkoutSession = checkoutSession;
            }

            @Generated
            public void setLineItem(String lineItem) {
                this.lineItem = lineItem;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Checkout)) {
                    return false;
                }
                Checkout other = (Checkout)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$checkoutSession = this.getCheckoutSession();
                String other$checkoutSession = other.getCheckoutSession();
                if (this$checkoutSession == null ? other$checkoutSession != null : !this$checkoutSession.equals(other$checkoutSession)) {
                    return false;
                }
                String this$lineItem = this.getLineItem();
                String other$lineItem = other.getLineItem();
                return !(this$lineItem == null ? other$lineItem != null : !this$lineItem.equals(other$lineItem));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Checkout;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $checkoutSession = this.getCheckoutSession();
                result = result * 59 + ($checkoutSession == null ? 43 : $checkoutSession.hashCode());
                String $lineItem = this.getLineItem();
                result = result * 59 + ($lineItem == null ? 43 : $lineItem.hashCode());
                return result;
            }
        }

        public static class Order
        extends StripeObject {
            @SerializedName(value="line_item")
            String lineItem;
            @SerializedName(value="order")
            String order;

            @Generated
            public String getLineItem() {
                return this.lineItem;
            }

            @Generated
            public String getOrder() {
                return this.order;
            }

            @Generated
            public void setLineItem(String lineItem) {
                this.lineItem = lineItem;
            }

            @Generated
            public void setOrder(String order) {
                this.order = order;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Order)) {
                    return false;
                }
                Order other = (Order)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$lineItem = this.getLineItem();
                String other$lineItem = other.getLineItem();
                if (this$lineItem == null ? other$lineItem != null : !this$lineItem.equals(other$lineItem)) {
                    return false;
                }
                String this$order = this.getOrder();
                String other$order = other.getOrder();
                return !(this$order == null ? other$order != null : !this$order.equals(other$order));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Order;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $lineItem = this.getLineItem();
                result = result * 59 + ($lineItem == null ? 43 : $lineItem.hashCode());
                String $order = this.getOrder();
                result = result * 59 + ($order == null ? 43 : $order.hashCode());
                return result;
            }
        }

        public static class Payment
        extends StripeObject {
            @SerializedName(value="payment_intent")
            String paymentIntent;

            @Generated
            public String getPaymentIntent() {
                return this.paymentIntent;
            }

            @Generated
            public void setPaymentIntent(String paymentIntent) {
                this.paymentIntent = paymentIntent;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Payment)) {
                    return false;
                }
                Payment other = (Payment)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$paymentIntent = this.getPaymentIntent();
                String other$paymentIntent = other.getPaymentIntent();
                return !(this$paymentIntent == null ? other$paymentIntent != null : !this$paymentIntent.equals(other$paymentIntent));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Payment;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $paymentIntent = this.getPaymentIntent();
                result = result * 59 + ($paymentIntent == null ? 43 : $paymentIntent.hashCode());
                return result;
            }
        }
    }
}

