/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.CashBalanceRetrieveParams;
import com.stripe.param.CashBalanceUpdateParams;
import java.util.Map;
import lombok.Generated;

public class CashBalance
extends ApiResource {
    @SerializedName(value="available")
    Map<String, Long> available;
    @SerializedName(value="customer")
    String customer;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="settings")
    Settings settings;

    public static CashBalance retrieve(String customer) throws StripeException {
        return CashBalance.retrieve(customer, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static CashBalance retrieve(String customer, RequestOptions options) throws StripeException {
        return CashBalance.retrieve(customer, (Map<String, Object>)null, options);
    }

    public static CashBalance retrieve(String customer, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/customers/%s/cash_balance", ApiResource.urlEncodeId(customer)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, CashBalance.class, options);
    }

    public static CashBalance retrieve(String customer, CashBalanceRetrieveParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/customers/%s/cash_balance", ApiResource.urlEncodeId(customer)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, CashBalance.class, options);
    }

    public CashBalance update(Map<String, Object> params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public CashBalance update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/customers/%s/cash_balance", ApiResource.urlEncodeId(this.getCustomer())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, CashBalance.class, options);
    }

    public CashBalance update(CashBalanceUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public CashBalance update(CashBalanceUpdateParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/customers/%s/cash_balance", ApiResource.urlEncodeId(this.getCustomer())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, CashBalance.class, options);
    }

    @Generated
    public Map<String, Long> getAvailable() {
        return this.available;
    }

    @Generated
    public String getCustomer() {
        return this.customer;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @Generated
    public void setAvailable(Map<String, Long> available) {
        this.available = available;
    }

    @Generated
    public void setCustomer(String customer) {
        this.customer = customer;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CashBalance)) {
            return false;
        }
        CashBalance other = (CashBalance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, Long> this$available = this.getAvailable();
        Map<String, Long> other$available = other.getAvailable();
        if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Settings this$settings = this.getSettings();
        Settings other$settings = other.getSettings();
        return !(this$settings == null ? other$settings != null : !((Object)this$settings).equals(other$settings));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CashBalance;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, Long> $available = this.getAvailable();
        result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Settings $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : ((Object)$settings).hashCode());
        return result;
    }

    public static class Settings
    extends StripeObject {
        @SerializedName(value="reconciliation_mode")
        String reconciliationMode;
        @SerializedName(value="using_merchant_default")
        Boolean usingMerchantDefault;

        @Generated
        public String getReconciliationMode() {
            return this.reconciliationMode;
        }

        @Generated
        public Boolean getUsingMerchantDefault() {
            return this.usingMerchantDefault;
        }

        @Generated
        public void setReconciliationMode(String reconciliationMode) {
            this.reconciliationMode = reconciliationMode;
        }

        @Generated
        public void setUsingMerchantDefault(Boolean usingMerchantDefault) {
            this.usingMerchantDefault = usingMerchantDefault;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Settings)) {
                return false;
            }
            Settings other = (Settings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$usingMerchantDefault = this.getUsingMerchantDefault();
            Boolean other$usingMerchantDefault = other.getUsingMerchantDefault();
            if (this$usingMerchantDefault == null ? other$usingMerchantDefault != null : !((Object)this$usingMerchantDefault).equals(other$usingMerchantDefault)) {
                return false;
            }
            String this$reconciliationMode = this.getReconciliationMode();
            String other$reconciliationMode = other.getReconciliationMode();
            return !(this$reconciliationMode == null ? other$reconciliationMode != null : !this$reconciliationMode.equals(other$reconciliationMode));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Settings;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $usingMerchantDefault = this.getUsingMerchantDefault();
            result = result * 59 + ($usingMerchantDefault == null ? 43 : ((Object)$usingMerchantDefault).hashCode());
            String $reconciliationMode = this.getReconciliationMode();
            result = result * 59 + ($reconciliationMode == null ? 43 : $reconciliationMode.hashCode());
            return result;
        }
    }
}

