/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.TaxCodeCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.TaxCodeListParams;
import com.stripe.param.TaxCodeRetrieveParams;
import java.util.Map;
import lombok.Generated;

public class TaxCode
extends ApiResource
implements HasId {
    @SerializedName(value="description")
    String description;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="name")
    String name;
    @SerializedName(value="object")
    String object;

    public static TaxCodeCollection list(Map<String, Object> params) throws StripeException {
        return TaxCode.list(params, (RequestOptions)null);
    }

    public static TaxCodeCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/tax_codes");
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, TaxCodeCollection.class, options);
    }

    public static TaxCodeCollection list(TaxCodeListParams params) throws StripeException {
        return TaxCode.list(params, (RequestOptions)null);
    }

    public static TaxCodeCollection list(TaxCodeListParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/tax_codes");
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, TaxCodeCollection.class, options);
    }

    public static TaxCode retrieve(String id) throws StripeException {
        return TaxCode.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static TaxCode retrieve(String id, RequestOptions options) throws StripeException {
        return TaxCode.retrieve(id, (Map<String, Object>)null, options);
    }

    public static TaxCode retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/tax_codes/%s", ApiResource.urlEncodeId(id)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, TaxCode.class, options);
    }

    public static TaxCode retrieve(String id, TaxCodeRetrieveParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/tax_codes/%s", ApiResource.urlEncodeId(id)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, TaxCode.class, options);
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaxCode)) {
            return false;
        }
        TaxCode other = (TaxCode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TaxCode;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }
}

