/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.UsageRecordCreateOnSubscriptionItemParams;
import java.util.Map;
import lombok.Generated;

public class UsageRecord
extends ApiResource
implements HasId {
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="quantity")
    Long quantity;
    @SerializedName(value="subscription_item")
    String subscriptionItem;
    @SerializedName(value="timestamp")
    Long timestamp;

    public static UsageRecord createOnSubscriptionItem(String subscriptionItem, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/subscription_items/%s/usage_records", ApiResource.urlEncodeId(subscriptionItem)));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, UsageRecord.class, options);
    }

    public static UsageRecord createOnSubscriptionItem(String subscriptionItem, UsageRecordCreateOnSubscriptionItemParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/subscription_items/%s/usage_records", ApiResource.urlEncodeId(subscriptionItem)));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, UsageRecord.class, options);
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Long getQuantity() {
        return this.quantity;
    }

    @Generated
    public String getSubscriptionItem() {
        return this.subscriptionItem;
    }

    @Generated
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setQuantity(Long quantity) {
        this.quantity = quantity;
    }

    @Generated
    public void setSubscriptionItem(String subscriptionItem) {
        this.subscriptionItem = subscriptionItem;
    }

    @Generated
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UsageRecord)) {
            return false;
        }
        UsageRecord other = (UsageRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$quantity = this.getQuantity();
        Long other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$subscriptionItem = this.getSubscriptionItem();
        String other$subscriptionItem = other.getSubscriptionItem();
        return !(this$subscriptionItem == null ? other$subscriptionItem != null : !this$subscriptionItem.equals(other$subscriptionItem));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UsageRecord;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $subscriptionItem = this.getSubscriptionItem();
        result = result * 59 + ($subscriptionItem == null ? 43 : $subscriptionItem.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }
}

