/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.capital;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.capital.FinancingTransactionCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.capital.FinancingTransactionListParams;
import com.stripe.param.capital.FinancingTransactionRetrieveParams;
import java.util.Map;
import lombok.Generated;

public class FinancingTransaction
extends ApiResource
implements HasId {
    @SerializedName(value="account")
    String account;
    @SerializedName(value="created_at")
    Long createdAt;
    @SerializedName(value="details")
    Details details;
    @SerializedName(value="financing_offer")
    String financingOffer;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="legacy_balance_transaction_source")
    String legacyBalanceTransactionSource;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="type")
    String type;
    @SerializedName(value="user_facing_description")
    String userFacingDescription;

    public static FinancingTransactionCollection list(Map<String, Object> params) throws StripeException {
        return FinancingTransaction.list(params, (RequestOptions)null);
    }

    public static FinancingTransactionCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/capital/financing_transactions");
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, FinancingTransactionCollection.class, options);
    }

    public static FinancingTransactionCollection list(FinancingTransactionListParams params) throws StripeException {
        return FinancingTransaction.list(params, (RequestOptions)null);
    }

    public static FinancingTransactionCollection list(FinancingTransactionListParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/capital/financing_transactions");
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, FinancingTransactionCollection.class, options);
    }

    public static FinancingTransaction retrieve(String financingTransaction) throws StripeException {
        return FinancingTransaction.retrieve(financingTransaction, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static FinancingTransaction retrieve(String financingTransaction, RequestOptions options) throws StripeException {
        return FinancingTransaction.retrieve(financingTransaction, (Map<String, Object>)null, options);
    }

    public static FinancingTransaction retrieve(String financingTransaction, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/capital/financing_transactions/%s", ApiResource.urlEncodeId(financingTransaction)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, FinancingTransaction.class, options);
    }

    public static FinancingTransaction retrieve(String financingTransaction, FinancingTransactionRetrieveParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/capital/financing_transactions/%s", ApiResource.urlEncodeId(financingTransaction)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, FinancingTransaction.class, options);
    }

    @Generated
    public String getAccount() {
        return this.account;
    }

    @Generated
    public Long getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Details getDetails() {
        return this.details;
    }

    @Generated
    public String getFinancingOffer() {
        return this.financingOffer;
    }

    @Generated
    public String getLegacyBalanceTransactionSource() {
        return this.legacyBalanceTransactionSource;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getUserFacingDescription() {
        return this.userFacingDescription;
    }

    @Generated
    public void setAccount(String account) {
        this.account = account;
    }

    @Generated
    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setDetails(Details details) {
        this.details = details;
    }

    @Generated
    public void setFinancingOffer(String financingOffer) {
        this.financingOffer = financingOffer;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLegacyBalanceTransactionSource(String legacyBalanceTransactionSource) {
        this.legacyBalanceTransactionSource = legacyBalanceTransactionSource;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setUserFacingDescription(String userFacingDescription) {
        this.userFacingDescription = userFacingDescription;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FinancingTransaction)) {
            return false;
        }
        FinancingTransaction other = (FinancingTransaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$createdAt = this.getCreatedAt();
        Long other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        Details this$details = this.getDetails();
        Details other$details = other.getDetails();
        if (this$details == null ? other$details != null : !((Object)this$details).equals(other$details)) {
            return false;
        }
        String this$financingOffer = this.getFinancingOffer();
        String other$financingOffer = other.getFinancingOffer();
        if (this$financingOffer == null ? other$financingOffer != null : !this$financingOffer.equals(other$financingOffer)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$legacyBalanceTransactionSource = this.getLegacyBalanceTransactionSource();
        String other$legacyBalanceTransactionSource = other.getLegacyBalanceTransactionSource();
        if (this$legacyBalanceTransactionSource == null ? other$legacyBalanceTransactionSource != null : !this$legacyBalanceTransactionSource.equals(other$legacyBalanceTransactionSource)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$userFacingDescription = this.getUserFacingDescription();
        String other$userFacingDescription = other.getUserFacingDescription();
        return !(this$userFacingDescription == null ? other$userFacingDescription != null : !this$userFacingDescription.equals(other$userFacingDescription));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FinancingTransaction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        Details $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
        String $financingOffer = this.getFinancingOffer();
        result = result * 59 + ($financingOffer == null ? 43 : $financingOffer.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $legacyBalanceTransactionSource = this.getLegacyBalanceTransactionSource();
        result = result * 59 + ($legacyBalanceTransactionSource == null ? 43 : $legacyBalanceTransactionSource.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $userFacingDescription = this.getUserFacingDescription();
        result = result * 59 + ($userFacingDescription == null ? 43 : $userFacingDescription.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class Details
    extends StripeObject {
        @SerializedName(value="advance_amount")
        Long advanceAmount;
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="fee_amount")
        Long feeAmount;
        @SerializedName(value="linked_payment")
        String linkedPayment;
        @SerializedName(value="reason")
        String reason;
        @SerializedName(value="reversed_transaction")
        String reversedTransaction;
        @SerializedName(value="total_amount")
        Long totalAmount;

        @Generated
        public Long getAdvanceAmount() {
            return this.advanceAmount;
        }

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public Long getFeeAmount() {
            return this.feeAmount;
        }

        @Generated
        public String getLinkedPayment() {
            return this.linkedPayment;
        }

        @Generated
        public String getReason() {
            return this.reason;
        }

        @Generated
        public String getReversedTransaction() {
            return this.reversedTransaction;
        }

        @Generated
        public Long getTotalAmount() {
            return this.totalAmount;
        }

        @Generated
        public void setAdvanceAmount(Long advanceAmount) {
            this.advanceAmount = advanceAmount;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public void setFeeAmount(Long feeAmount) {
            this.feeAmount = feeAmount;
        }

        @Generated
        public void setLinkedPayment(String linkedPayment) {
            this.linkedPayment = linkedPayment;
        }

        @Generated
        public void setReason(String reason) {
            this.reason = reason;
        }

        @Generated
        public void setReversedTransaction(String reversedTransaction) {
            this.reversedTransaction = reversedTransaction;
        }

        @Generated
        public void setTotalAmount(Long totalAmount) {
            this.totalAmount = totalAmount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Details)) {
                return false;
            }
            Details other = (Details)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$advanceAmount = this.getAdvanceAmount();
            Long other$advanceAmount = other.getAdvanceAmount();
            if (this$advanceAmount == null ? other$advanceAmount != null : !((Object)this$advanceAmount).equals(other$advanceAmount)) {
                return false;
            }
            Long this$feeAmount = this.getFeeAmount();
            Long other$feeAmount = other.getFeeAmount();
            if (this$feeAmount == null ? other$feeAmount != null : !((Object)this$feeAmount).equals(other$feeAmount)) {
                return false;
            }
            Long this$totalAmount = this.getTotalAmount();
            Long other$totalAmount = other.getTotalAmount();
            if (this$totalAmount == null ? other$totalAmount != null : !((Object)this$totalAmount).equals(other$totalAmount)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                return false;
            }
            String this$linkedPayment = this.getLinkedPayment();
            String other$linkedPayment = other.getLinkedPayment();
            if (this$linkedPayment == null ? other$linkedPayment != null : !this$linkedPayment.equals(other$linkedPayment)) {
                return false;
            }
            String this$reason = this.getReason();
            String other$reason = other.getReason();
            if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
                return false;
            }
            String this$reversedTransaction = this.getReversedTransaction();
            String other$reversedTransaction = other.getReversedTransaction();
            return !(this$reversedTransaction == null ? other$reversedTransaction != null : !this$reversedTransaction.equals(other$reversedTransaction));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Details;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $advanceAmount = this.getAdvanceAmount();
            result = result * 59 + ($advanceAmount == null ? 43 : ((Object)$advanceAmount).hashCode());
            Long $feeAmount = this.getFeeAmount();
            result = result * 59 + ($feeAmount == null ? 43 : ((Object)$feeAmount).hashCode());
            Long $totalAmount = this.getTotalAmount();
            result = result * 59 + ($totalAmount == null ? 43 : ((Object)$totalAmount).hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            String $linkedPayment = this.getLinkedPayment();
            result = result * 59 + ($linkedPayment == null ? 43 : $linkedPayment.hashCode());
            String $reason = this.getReason();
            result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
            String $reversedTransaction = this.getReversedTransaction();
            result = result * 59 + ($reversedTransaction == null ? 43 : $reversedTransaction.hashCode());
            return result;
        }
    }
}

