/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.terminal;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.File;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.terminal.ConfigurationCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.terminal.ConfigurationCreateParams;
import com.stripe.param.terminal.ConfigurationListParams;
import com.stripe.param.terminal.ConfigurationRetrieveParams;
import com.stripe.param.terminal.ConfigurationUpdateParams;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Configuration
extends ApiResource
implements HasId {
    @SerializedName(value="bbpos_wisepos_e")
    BbposWiseposE bbposWiseposE;
    @SerializedName(value="deleted")
    Boolean deleted;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="is_account_default")
    Boolean isAccountDefault;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="tipping")
    Tipping tipping;
    @SerializedName(value="verifone_p400")
    VerifoneP400 verifoneP400;

    public static Configuration create(Map<String, Object> params) throws StripeException {
        return Configuration.create(params, (RequestOptions)null);
    }

    public static Configuration create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/terminal/configurations");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Configuration.class, options);
    }

    public static Configuration create(ConfigurationCreateParams params) throws StripeException {
        return Configuration.create(params, (RequestOptions)null);
    }

    public static Configuration create(ConfigurationCreateParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/terminal/configurations");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Configuration.class, options);
    }

    public Configuration delete() throws StripeException {
        return this.delete(null, null);
    }

    public Configuration delete(RequestOptions options) throws StripeException {
        return this.delete(null, options);
    }

    public Configuration delete(Map<String, Object> params) throws StripeException {
        return this.delete(params, null);
    }

    public Configuration delete(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/terminal/configurations/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, Configuration.class, options);
    }

    public static ConfigurationCollection list(Map<String, Object> params) throws StripeException {
        return Configuration.list(params, (RequestOptions)null);
    }

    public static ConfigurationCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/terminal/configurations");
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, ConfigurationCollection.class, options);
    }

    public static ConfigurationCollection list(ConfigurationListParams params) throws StripeException {
        return Configuration.list(params, (RequestOptions)null);
    }

    public static ConfigurationCollection list(ConfigurationListParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/terminal/configurations");
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, ConfigurationCollection.class, options);
    }

    public static Configuration retrieve(String configuration) throws StripeException {
        return Configuration.retrieve(configuration, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Configuration retrieve(String configuration, RequestOptions options) throws StripeException {
        return Configuration.retrieve(configuration, (Map<String, Object>)null, options);
    }

    public static Configuration retrieve(String configuration, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/terminal/configurations/%s", ApiResource.urlEncodeId(configuration)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Configuration.class, options);
    }

    public static Configuration retrieve(String configuration, ConfigurationRetrieveParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/terminal/configurations/%s", ApiResource.urlEncodeId(configuration)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Configuration.class, options);
    }

    public Configuration update(Map<String, Object> params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Configuration update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/terminal/configurations/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Configuration.class, options);
    }

    public Configuration update(ConfigurationUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Configuration update(ConfigurationUpdateParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/terminal/configurations/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Configuration.class, options);
    }

    @Generated
    public BbposWiseposE getBbposWiseposE() {
        return this.bbposWiseposE;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public Boolean getIsAccountDefault() {
        return this.isAccountDefault;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Tipping getTipping() {
        return this.tipping;
    }

    @Generated
    public VerifoneP400 getVerifoneP400() {
        return this.verifoneP400;
    }

    @Generated
    public void setBbposWiseposE(BbposWiseposE bbposWiseposE) {
        this.bbposWiseposE = bbposWiseposE;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIsAccountDefault(Boolean isAccountDefault) {
        this.isAccountDefault = isAccountDefault;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setTipping(Tipping tipping) {
        this.tipping = tipping;
    }

    @Generated
    public void setVerifoneP400(VerifoneP400 verifoneP400) {
        this.verifoneP400 = verifoneP400;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        Boolean this$isAccountDefault = this.getIsAccountDefault();
        Boolean other$isAccountDefault = other.getIsAccountDefault();
        if (this$isAccountDefault == null ? other$isAccountDefault != null : !((Object)this$isAccountDefault).equals(other$isAccountDefault)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        BbposWiseposE this$bbposWiseposE = this.getBbposWiseposE();
        BbposWiseposE other$bbposWiseposE = other.getBbposWiseposE();
        if (this$bbposWiseposE == null ? other$bbposWiseposE != null : !((Object)this$bbposWiseposE).equals(other$bbposWiseposE)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Tipping this$tipping = this.getTipping();
        Tipping other$tipping = other.getTipping();
        if (this$tipping == null ? other$tipping != null : !((Object)this$tipping).equals(other$tipping)) {
            return false;
        }
        VerifoneP400 this$verifoneP400 = this.getVerifoneP400();
        VerifoneP400 other$verifoneP400 = other.getVerifoneP400();
        return !(this$verifoneP400 == null ? other$verifoneP400 != null : !((Object)this$verifoneP400).equals(other$verifoneP400));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Configuration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        Boolean $isAccountDefault = this.getIsAccountDefault();
        result = result * 59 + ($isAccountDefault == null ? 43 : ((Object)$isAccountDefault).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        BbposWiseposE $bbposWiseposE = this.getBbposWiseposE();
        result = result * 59 + ($bbposWiseposE == null ? 43 : ((Object)$bbposWiseposE).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Tipping $tipping = this.getTipping();
        result = result * 59 + ($tipping == null ? 43 : ((Object)$tipping).hashCode());
        VerifoneP400 $verifoneP400 = this.getVerifoneP400();
        result = result * 59 + ($verifoneP400 == null ? 43 : ((Object)$verifoneP400).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class BbposWiseposE
    extends StripeObject {
        @SerializedName(value="splashscreen")
        ExpandableField<File> splashscreen;

        public String getSplashscreen() {
            return this.splashscreen != null ? this.splashscreen.getId() : null;
        }

        public void setSplashscreen(String id) {
            this.splashscreen = ApiResource.setExpandableFieldId(id, this.splashscreen);
        }

        public File getSplashscreenObject() {
            return this.splashscreen != null ? this.splashscreen.getExpanded() : null;
        }

        public void setSplashscreenObject(File expandableObject) {
            this.splashscreen = new ExpandableField<File>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BbposWiseposE)) {
                return false;
            }
            BbposWiseposE other = (BbposWiseposE)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$splashscreen = this.getSplashscreen();
            String other$splashscreen = other.getSplashscreen();
            return !(this$splashscreen == null ? other$splashscreen != null : !this$splashscreen.equals(other$splashscreen));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BbposWiseposE;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $splashscreen = this.getSplashscreen();
            result = result * 59 + ($splashscreen == null ? 43 : $splashscreen.hashCode());
            return result;
        }
    }

    public static class Tipping
    extends StripeObject {
        @SerializedName(value="aud")
        Aud aud;
        @SerializedName(value="cad")
        Cad cad;
        @SerializedName(value="chf")
        Chf chf;
        @SerializedName(value="czk")
        Czk czk;
        @SerializedName(value="dkk")
        Dkk dkk;
        @SerializedName(value="eur")
        Eur eur;
        @SerializedName(value="gbp")
        Gbp gbp;
        @SerializedName(value="hkd")
        Hkd hkd;
        @SerializedName(value="myr")
        Myr myr;
        @SerializedName(value="nok")
        Nok nok;
        @SerializedName(value="nzd")
        Nzd nzd;
        @SerializedName(value="sek")
        Sek sek;
        @SerializedName(value="sgd")
        Sgd sgd;
        @SerializedName(value="usd")
        Usd usd;

        @Generated
        public Aud getAud() {
            return this.aud;
        }

        @Generated
        public Cad getCad() {
            return this.cad;
        }

        @Generated
        public Chf getChf() {
            return this.chf;
        }

        @Generated
        public Czk getCzk() {
            return this.czk;
        }

        @Generated
        public Dkk getDkk() {
            return this.dkk;
        }

        @Generated
        public Eur getEur() {
            return this.eur;
        }

        @Generated
        public Gbp getGbp() {
            return this.gbp;
        }

        @Generated
        public Hkd getHkd() {
            return this.hkd;
        }

        @Generated
        public Myr getMyr() {
            return this.myr;
        }

        @Generated
        public Nok getNok() {
            return this.nok;
        }

        @Generated
        public Nzd getNzd() {
            return this.nzd;
        }

        @Generated
        public Sek getSek() {
            return this.sek;
        }

        @Generated
        public Sgd getSgd() {
            return this.sgd;
        }

        @Generated
        public Usd getUsd() {
            return this.usd;
        }

        @Generated
        public void setAud(Aud aud) {
            this.aud = aud;
        }

        @Generated
        public void setCad(Cad cad) {
            this.cad = cad;
        }

        @Generated
        public void setChf(Chf chf) {
            this.chf = chf;
        }

        @Generated
        public void setCzk(Czk czk) {
            this.czk = czk;
        }

        @Generated
        public void setDkk(Dkk dkk) {
            this.dkk = dkk;
        }

        @Generated
        public void setEur(Eur eur) {
            this.eur = eur;
        }

        @Generated
        public void setGbp(Gbp gbp) {
            this.gbp = gbp;
        }

        @Generated
        public void setHkd(Hkd hkd) {
            this.hkd = hkd;
        }

        @Generated
        public void setMyr(Myr myr) {
            this.myr = myr;
        }

        @Generated
        public void setNok(Nok nok) {
            this.nok = nok;
        }

        @Generated
        public void setNzd(Nzd nzd) {
            this.nzd = nzd;
        }

        @Generated
        public void setSek(Sek sek) {
            this.sek = sek;
        }

        @Generated
        public void setSgd(Sgd sgd) {
            this.sgd = sgd;
        }

        @Generated
        public void setUsd(Usd usd) {
            this.usd = usd;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tipping)) {
                return false;
            }
            Tipping other = (Tipping)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Aud this$aud = this.getAud();
            Aud other$aud = other.getAud();
            if (this$aud == null ? other$aud != null : !((Object)this$aud).equals(other$aud)) {
                return false;
            }
            Cad this$cad = this.getCad();
            Cad other$cad = other.getCad();
            if (this$cad == null ? other$cad != null : !((Object)this$cad).equals(other$cad)) {
                return false;
            }
            Chf this$chf = this.getChf();
            Chf other$chf = other.getChf();
            if (this$chf == null ? other$chf != null : !((Object)this$chf).equals(other$chf)) {
                return false;
            }
            Czk this$czk = this.getCzk();
            Czk other$czk = other.getCzk();
            if (this$czk == null ? other$czk != null : !((Object)this$czk).equals(other$czk)) {
                return false;
            }
            Dkk this$dkk = this.getDkk();
            Dkk other$dkk = other.getDkk();
            if (this$dkk == null ? other$dkk != null : !((Object)this$dkk).equals(other$dkk)) {
                return false;
            }
            Eur this$eur = this.getEur();
            Eur other$eur = other.getEur();
            if (this$eur == null ? other$eur != null : !((Object)this$eur).equals(other$eur)) {
                return false;
            }
            Gbp this$gbp = this.getGbp();
            Gbp other$gbp = other.getGbp();
            if (this$gbp == null ? other$gbp != null : !((Object)this$gbp).equals(other$gbp)) {
                return false;
            }
            Hkd this$hkd = this.getHkd();
            Hkd other$hkd = other.getHkd();
            if (this$hkd == null ? other$hkd != null : !((Object)this$hkd).equals(other$hkd)) {
                return false;
            }
            Myr this$myr = this.getMyr();
            Myr other$myr = other.getMyr();
            if (this$myr == null ? other$myr != null : !((Object)this$myr).equals(other$myr)) {
                return false;
            }
            Nok this$nok = this.getNok();
            Nok other$nok = other.getNok();
            if (this$nok == null ? other$nok != null : !((Object)this$nok).equals(other$nok)) {
                return false;
            }
            Nzd this$nzd = this.getNzd();
            Nzd other$nzd = other.getNzd();
            if (this$nzd == null ? other$nzd != null : !((Object)this$nzd).equals(other$nzd)) {
                return false;
            }
            Sek this$sek = this.getSek();
            Sek other$sek = other.getSek();
            if (this$sek == null ? other$sek != null : !((Object)this$sek).equals(other$sek)) {
                return false;
            }
            Sgd this$sgd = this.getSgd();
            Sgd other$sgd = other.getSgd();
            if (this$sgd == null ? other$sgd != null : !((Object)this$sgd).equals(other$sgd)) {
                return false;
            }
            Usd this$usd = this.getUsd();
            Usd other$usd = other.getUsd();
            return !(this$usd == null ? other$usd != null : !((Object)this$usd).equals(other$usd));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Tipping;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Aud $aud = this.getAud();
            result = result * 59 + ($aud == null ? 43 : ((Object)$aud).hashCode());
            Cad $cad = this.getCad();
            result = result * 59 + ($cad == null ? 43 : ((Object)$cad).hashCode());
            Chf $chf = this.getChf();
            result = result * 59 + ($chf == null ? 43 : ((Object)$chf).hashCode());
            Czk $czk = this.getCzk();
            result = result * 59 + ($czk == null ? 43 : ((Object)$czk).hashCode());
            Dkk $dkk = this.getDkk();
            result = result * 59 + ($dkk == null ? 43 : ((Object)$dkk).hashCode());
            Eur $eur = this.getEur();
            result = result * 59 + ($eur == null ? 43 : ((Object)$eur).hashCode());
            Gbp $gbp = this.getGbp();
            result = result * 59 + ($gbp == null ? 43 : ((Object)$gbp).hashCode());
            Hkd $hkd = this.getHkd();
            result = result * 59 + ($hkd == null ? 43 : ((Object)$hkd).hashCode());
            Myr $myr = this.getMyr();
            result = result * 59 + ($myr == null ? 43 : ((Object)$myr).hashCode());
            Nok $nok = this.getNok();
            result = result * 59 + ($nok == null ? 43 : ((Object)$nok).hashCode());
            Nzd $nzd = this.getNzd();
            result = result * 59 + ($nzd == null ? 43 : ((Object)$nzd).hashCode());
            Sek $sek = this.getSek();
            result = result * 59 + ($sek == null ? 43 : ((Object)$sek).hashCode());
            Sgd $sgd = this.getSgd();
            result = result * 59 + ($sgd == null ? 43 : ((Object)$sgd).hashCode());
            Usd $usd = this.getUsd();
            result = result * 59 + ($usd == null ? 43 : ((Object)$usd).hashCode());
            return result;
        }

        public static class Aud
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Aud)) {
                    return false;
                }
                Aud other = (Aud)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Aud;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Cad
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Cad)) {
                    return false;
                }
                Cad other = (Cad)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Cad;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Chf
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Chf)) {
                    return false;
                }
                Chf other = (Chf)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Chf;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Czk
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Czk)) {
                    return false;
                }
                Czk other = (Czk)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Czk;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Dkk
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Dkk)) {
                    return false;
                }
                Dkk other = (Dkk)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Dkk;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Eur
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Eur)) {
                    return false;
                }
                Eur other = (Eur)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Eur;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Gbp
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Gbp)) {
                    return false;
                }
                Gbp other = (Gbp)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Gbp;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Hkd
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Hkd)) {
                    return false;
                }
                Hkd other = (Hkd)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Hkd;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Myr
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Myr)) {
                    return false;
                }
                Myr other = (Myr)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Myr;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Nok
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Nok)) {
                    return false;
                }
                Nok other = (Nok)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Nok;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Nzd
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Nzd)) {
                    return false;
                }
                Nzd other = (Nzd)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Nzd;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Sek
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Sek)) {
                    return false;
                }
                Sek other = (Sek)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Sek;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Sgd
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Sgd)) {
                    return false;
                }
                Sgd other = (Sgd)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Sgd;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }

        public static class Usd
        extends StripeObject {
            @SerializedName(value="fixed_amounts")
            List<Long> fixedAmounts;
            @SerializedName(value="percentages")
            List<Long> percentages;
            @SerializedName(value="smart_tip_threshold")
            Long smartTipThreshold;

            @Generated
            public List<Long> getFixedAmounts() {
                return this.fixedAmounts;
            }

            @Generated
            public List<Long> getPercentages() {
                return this.percentages;
            }

            @Generated
            public Long getSmartTipThreshold() {
                return this.smartTipThreshold;
            }

            @Generated
            public void setFixedAmounts(List<Long> fixedAmounts) {
                this.fixedAmounts = fixedAmounts;
            }

            @Generated
            public void setPercentages(List<Long> percentages) {
                this.percentages = percentages;
            }

            @Generated
            public void setSmartTipThreshold(Long smartTipThreshold) {
                this.smartTipThreshold = smartTipThreshold;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Usd)) {
                    return false;
                }
                Usd other = (Usd)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$smartTipThreshold = this.getSmartTipThreshold();
                Long other$smartTipThreshold = other.getSmartTipThreshold();
                if (this$smartTipThreshold == null ? other$smartTipThreshold != null : !((Object)this$smartTipThreshold).equals(other$smartTipThreshold)) {
                    return false;
                }
                List<Long> this$fixedAmounts = this.getFixedAmounts();
                List<Long> other$fixedAmounts = other.getFixedAmounts();
                if (this$fixedAmounts == null ? other$fixedAmounts != null : !((Object)this$fixedAmounts).equals(other$fixedAmounts)) {
                    return false;
                }
                List<Long> this$percentages = this.getPercentages();
                List<Long> other$percentages = other.getPercentages();
                return !(this$percentages == null ? other$percentages != null : !((Object)this$percentages).equals(other$percentages));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Usd;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $smartTipThreshold = this.getSmartTipThreshold();
                result = result * 59 + ($smartTipThreshold == null ? 43 : ((Object)$smartTipThreshold).hashCode());
                List<Long> $fixedAmounts = this.getFixedAmounts();
                result = result * 59 + ($fixedAmounts == null ? 43 : ((Object)$fixedAmounts).hashCode());
                List<Long> $percentages = this.getPercentages();
                result = result * 59 + ($percentages == null ? 43 : ((Object)$percentages).hashCode());
                return result;
            }
        }
    }

    public static class VerifoneP400
    extends StripeObject {
        @SerializedName(value="splashscreen")
        ExpandableField<File> splashscreen;

        public String getSplashscreen() {
            return this.splashscreen != null ? this.splashscreen.getId() : null;
        }

        public void setSplashscreen(String id) {
            this.splashscreen = ApiResource.setExpandableFieldId(id, this.splashscreen);
        }

        public File getSplashscreenObject() {
            return this.splashscreen != null ? this.splashscreen.getExpanded() : null;
        }

        public void setSplashscreenObject(File expandableObject) {
            this.splashscreen = new ExpandableField<File>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VerifoneP400)) {
                return false;
            }
            VerifoneP400 other = (VerifoneP400)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$splashscreen = this.getSplashscreen();
            String other$splashscreen = other.getSplashscreen();
            return !(this$splashscreen == null ? other$splashscreen != null : !this$splashscreen.equals(other$splashscreen));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof VerifoneP400;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $splashscreen = this.getSplashscreen();
            result = result * 59 + ($splashscreen == null ? 43 : $splashscreen.hashCode());
            return result;
        }
    }
}

