/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.PaymentSource;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.PaymentSourceCollectionCreateParams;
import com.stripe.param.PaymentSourceCollectionListParams;
import com.stripe.param.PaymentSourceCollectionRetrieveParams;
import java.util.Map;

public class PaymentSourceCollection
extends StripeCollection<PaymentSource> {
    public PaymentSource create(Map<String, Object> params) throws StripeException {
        return this.create(params, (RequestOptions)null);
    }

    public PaymentSource create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, this.getUrl());
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentSource.class, options);
    }

    public PaymentSource create(PaymentSourceCollectionCreateParams params) throws StripeException {
        return this.create(params, (RequestOptions)null);
    }

    public PaymentSource create(PaymentSourceCollectionCreateParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, this.getUrl());
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentSource.class, options);
    }

    public PaymentSourceCollection list(Map<String, Object> params) throws StripeException {
        return this.list(params, (RequestOptions)null);
    }

    public PaymentSourceCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, this.getUrl());
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, PaymentSourceCollection.class, options);
    }

    public PaymentSourceCollection list(PaymentSourceCollectionListParams params) throws StripeException {
        return this.list(params, (RequestOptions)null);
    }

    public PaymentSourceCollection list(PaymentSourceCollectionListParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, this.getUrl());
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, PaymentSourceCollection.class, options);
    }

    public PaymentSource retrieve(String id) throws StripeException {
        return this.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public PaymentSource retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, (Map<String, Object>)null, options);
    }

    public PaymentSource retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("%s/%s", this.getUrl(), ApiResource.urlEncodeId(id)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, PaymentSource.class, options);
    }

    public PaymentSource retrieve(String id, PaymentSourceCollectionRetrieveParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("%s/%s", this.getUrl(), ApiResource.urlEncodeId(id)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, PaymentSource.class, options);
    }
}

