/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Account;
import com.stripe.model.Application;
import com.stripe.model.Customer;
import com.stripe.model.Discount;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.Invoice;
import com.stripe.model.InvoiceCollection;
import com.stripe.model.InvoiceLineItemCollection;
import com.stripe.model.LineItemCollection;
import com.stripe.model.MetadataStore;
import com.stripe.model.QuoteCollection;
import com.stripe.model.QuoteLineCollection;
import com.stripe.model.StripeObject;
import com.stripe.model.Subscription;
import com.stripe.model.SubscriptionScheduleCollection;
import com.stripe.model.TaxRate;
import com.stripe.model.testhelpers.TestClock;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.QuoteAcceptParams;
import com.stripe.param.QuoteCancelParams;
import com.stripe.param.QuoteCreateParams;
import com.stripe.param.QuoteDraftQuoteParams;
import com.stripe.param.QuoteFinalizeQuoteParams;
import com.stripe.param.QuoteListComputedUpfrontLineItemsParams;
import com.stripe.param.QuoteListLineItemsParams;
import com.stripe.param.QuoteListLinesParams;
import com.stripe.param.QuoteListParams;
import com.stripe.param.QuoteMarkStaleQuoteParams;
import com.stripe.param.QuotePdfParams;
import com.stripe.param.QuotePreviewInvoiceLinesParams;
import com.stripe.param.QuotePreviewInvoicesParams;
import com.stripe.param.QuotePreviewSubscriptionSchedulesParams;
import com.stripe.param.QuoteReestimateParams;
import com.stripe.param.QuoteRetrieveParams;
import com.stripe.param.QuoteUpdateParams;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class Quote
extends ApiResource
implements HasId,
MetadataStore<Quote> {
    @SerializedName(value="amount_subtotal")
    Long amountSubtotal;
    @SerializedName(value="amount_total")
    Long amountTotal;
    @SerializedName(value="application")
    ExpandableField<Application> application;
    @SerializedName(value="application_fee_amount")
    Long applicationFeeAmount;
    @SerializedName(value="application_fee_percent")
    BigDecimal applicationFeePercent;
    @SerializedName(value="automatic_tax")
    AutomaticTax automaticTax;
    @SerializedName(value="collection_method")
    String collectionMethod;
    @SerializedName(value="computed")
    Computed computed;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="default_tax_rates")
    List<ExpandableField<TaxRate>> defaultTaxRates;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="discounts")
    List<ExpandableField<Discount>> discounts;
    @SerializedName(value="expires_at")
    Long expiresAt;
    @SerializedName(value="footer")
    String footer;
    @SerializedName(value="from_quote")
    FromQuote fromQuote;
    @SerializedName(value="header")
    String header;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="invoice")
    ExpandableField<Invoice> invoice;
    @SerializedName(value="invoice_settings")
    InvoiceSettings invoiceSettings;
    @SerializedName(value="line_items")
    LineItemCollection lineItems;
    @SerializedName(value="lines")
    List<String> lines;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="number")
    String number;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="on_behalf_of")
    ExpandableField<Account> onBehalfOf;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="status_details")
    StatusDetails statusDetails;
    @SerializedName(value="status_transitions")
    StatusTransitions statusTransitions;
    @SerializedName(value="subscription")
    ExpandableField<Subscription> subscription;
    @SerializedName(value="subscription_data")
    SubscriptionData subscriptionData;
    @SerializedName(value="subscription_data_overrides")
    List<SubscriptionDataOverride> subscriptionDataOverrides;
    @SerializedName(value="subscription_schedule")
    ExpandableField<com.stripe.model.SubscriptionSchedule> subscriptionSchedule;
    @SerializedName(value="subscription_schedules")
    List<SubscriptionSchedule> subscriptionSchedules;
    @SerializedName(value="test_clock")
    ExpandableField<TestClock> testClock;
    @SerializedName(value="total_details")
    TotalDetails totalDetails;
    @SerializedName(value="transfer_data")
    TransferData transferData;

    public String getApplication() {
        return this.application != null ? this.application.getId() : null;
    }

    public void setApplication(String id) {
        this.application = ApiResource.setExpandableFieldId(id, this.application);
    }

    public Application getApplicationObject() {
        return this.application != null ? this.application.getExpanded() : null;
    }

    public void setApplicationObject(Application expandableObject) {
        this.application = new ExpandableField<Application>(expandableObject.getId(), expandableObject);
    }

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public String getInvoice() {
        return this.invoice != null ? this.invoice.getId() : null;
    }

    public void setInvoice(String id) {
        this.invoice = ApiResource.setExpandableFieldId(id, this.invoice);
    }

    public Invoice getInvoiceObject() {
        return this.invoice != null ? this.invoice.getExpanded() : null;
    }

    public void setInvoiceObject(Invoice expandableObject) {
        this.invoice = new ExpandableField<Invoice>(expandableObject.getId(), expandableObject);
    }

    public String getOnBehalfOf() {
        return this.onBehalfOf != null ? this.onBehalfOf.getId() : null;
    }

    public void setOnBehalfOf(String id) {
        this.onBehalfOf = ApiResource.setExpandableFieldId(id, this.onBehalfOf);
    }

    public Account getOnBehalfOfObject() {
        return this.onBehalfOf != null ? this.onBehalfOf.getExpanded() : null;
    }

    public void setOnBehalfOfObject(Account expandableObject) {
        this.onBehalfOf = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
    }

    public String getSubscription() {
        return this.subscription != null ? this.subscription.getId() : null;
    }

    public void setSubscription(String id) {
        this.subscription = ApiResource.setExpandableFieldId(id, this.subscription);
    }

    public Subscription getSubscriptionObject() {
        return this.subscription != null ? this.subscription.getExpanded() : null;
    }

    public void setSubscriptionObject(Subscription expandableObject) {
        this.subscription = new ExpandableField<Subscription>(expandableObject.getId(), expandableObject);
    }

    public String getSubscriptionSchedule() {
        return this.subscriptionSchedule != null ? this.subscriptionSchedule.getId() : null;
    }

    public void setSubscriptionSchedule(String id) {
        this.subscriptionSchedule = ApiResource.setExpandableFieldId(id, this.subscriptionSchedule);
    }

    public com.stripe.model.SubscriptionSchedule getSubscriptionScheduleObject() {
        return this.subscriptionSchedule != null ? this.subscriptionSchedule.getExpanded() : null;
    }

    public void setSubscriptionScheduleObject(com.stripe.model.SubscriptionSchedule expandableObject) {
        this.subscriptionSchedule = new ExpandableField<com.stripe.model.SubscriptionSchedule>(expandableObject.getId(), expandableObject);
    }

    public String getTestClock() {
        return this.testClock != null ? this.testClock.getId() : null;
    }

    public void setTestClock(String id) {
        this.testClock = ApiResource.setExpandableFieldId(id, this.testClock);
    }

    public TestClock getTestClockObject() {
        return this.testClock != null ? this.testClock.getExpanded() : null;
    }

    public void setTestClockObject(TestClock expandableObject) {
        this.testClock = new ExpandableField<TestClock>(expandableObject.getId(), expandableObject);
    }

    public List<String> getDefaultTaxRates() {
        return this.defaultTaxRates != null ? this.defaultTaxRates.stream().map(x -> x.getId()).collect(Collectors.toList()) : null;
    }

    public void setDefaultTaxRates(List<String> ids) {
        if (ids == null) {
            this.defaultTaxRates = null;
            return;
        }
        if (this.defaultTaxRates != null && this.defaultTaxRates.stream().map(x -> x.getId()).collect(Collectors.toList()).equals(ids)) {
            return;
        }
        this.defaultTaxRates = ids != null ? ids.stream().map(id -> new ExpandableField<Object>((String)id, null)).collect(Collectors.toList()) : null;
    }

    public List<TaxRate> getDefaultTaxRateObjects() {
        return this.defaultTaxRates != null ? this.defaultTaxRates.stream().map(x -> (TaxRate)x.getExpanded()).collect(Collectors.toList()) : null;
    }

    public void setDefaultTaxRateObjects(List<TaxRate> objs) {
        this.defaultTaxRates = objs != null ? objs.stream().map(x -> new ExpandableField<TaxRate>(x.getId(), (TaxRate)x)).collect(Collectors.toList()) : null;
    }

    public List<String> getDiscounts() {
        return this.discounts != null ? this.discounts.stream().map(x -> x.getId()).collect(Collectors.toList()) : null;
    }

    public void setDiscounts(List<String> ids) {
        if (ids == null) {
            this.discounts = null;
            return;
        }
        if (this.discounts != null && this.discounts.stream().map(x -> x.getId()).collect(Collectors.toList()).equals(ids)) {
            return;
        }
        this.discounts = ids != null ? ids.stream().map(id -> new ExpandableField<Object>((String)id, null)).collect(Collectors.toList()) : null;
    }

    public List<Discount> getDiscountObjects() {
        return this.discounts != null ? this.discounts.stream().map(x -> (Discount)x.getExpanded()).collect(Collectors.toList()) : null;
    }

    public void setDiscountObjects(List<Discount> objs) {
        this.discounts = objs != null ? objs.stream().map(x -> new ExpandableField<Discount>(x.getId(), (Discount)x)).collect(Collectors.toList()) : null;
    }

    public Quote accept() throws StripeException {
        return this.accept((Map<String, Object>)null, (RequestOptions)null);
    }

    public Quote accept(RequestOptions options) throws StripeException {
        return this.accept((Map<String, Object>)null, options);
    }

    public Quote accept(Map<String, Object> params) throws StripeException {
        return this.accept(params, (RequestOptions)null);
    }

    public Quote accept(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/accept", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Quote.class, options);
    }

    public Quote accept(QuoteAcceptParams params) throws StripeException {
        return this.accept(params, (RequestOptions)null);
    }

    public Quote accept(QuoteAcceptParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/accept", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Quote.class, options);
    }

    public Quote cancel() throws StripeException {
        return this.cancel((Map<String, Object>)null, (RequestOptions)null);
    }

    public Quote cancel(RequestOptions options) throws StripeException {
        return this.cancel((Map<String, Object>)null, options);
    }

    public Quote cancel(Map<String, Object> params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public Quote cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/cancel", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Quote.class, options);
    }

    public Quote cancel(QuoteCancelParams params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public Quote cancel(QuoteCancelParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/cancel", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Quote.class, options);
    }

    public static Quote create(Map<String, Object> params) throws StripeException {
        return Quote.create(params, (RequestOptions)null);
    }

    public static Quote create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/quotes");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Quote.class, options);
    }

    public static Quote create(QuoteCreateParams params) throws StripeException {
        return Quote.create(params, (RequestOptions)null);
    }

    public static Quote create(QuoteCreateParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/quotes");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Quote.class, options);
    }

    public Quote draftQuote() throws StripeException {
        return this.draftQuote((Map<String, Object>)null, (RequestOptions)null);
    }

    public Quote draftQuote(RequestOptions options) throws StripeException {
        return this.draftQuote((Map<String, Object>)null, options);
    }

    public Quote draftQuote(Map<String, Object> params) throws StripeException {
        return this.draftQuote(params, (RequestOptions)null);
    }

    public Quote draftQuote(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/mark_draft", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Quote.class, options);
    }

    public Quote draftQuote(QuoteDraftQuoteParams params) throws StripeException {
        return this.draftQuote(params, (RequestOptions)null);
    }

    public Quote draftQuote(QuoteDraftQuoteParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/mark_draft", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Quote.class, options);
    }

    public Quote finalizeQuote() throws StripeException {
        return this.finalizeQuote((Map<String, Object>)null, (RequestOptions)null);
    }

    public Quote finalizeQuote(RequestOptions options) throws StripeException {
        return this.finalizeQuote((Map<String, Object>)null, options);
    }

    public Quote finalizeQuote(Map<String, Object> params) throws StripeException {
        return this.finalizeQuote(params, (RequestOptions)null);
    }

    public Quote finalizeQuote(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/finalize", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Quote.class, options);
    }

    public Quote finalizeQuote(QuoteFinalizeQuoteParams params) throws StripeException {
        return this.finalizeQuote(params, (RequestOptions)null);
    }

    public Quote finalizeQuote(QuoteFinalizeQuoteParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/finalize", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Quote.class, options);
    }

    public static QuoteCollection list(Map<String, Object> params) throws StripeException {
        return Quote.list(params, (RequestOptions)null);
    }

    public static QuoteCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/quotes");
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, QuoteCollection.class, options);
    }

    public static QuoteCollection list(QuoteListParams params) throws StripeException {
        return Quote.list(params, (RequestOptions)null);
    }

    public static QuoteCollection list(QuoteListParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/quotes");
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, QuoteCollection.class, options);
    }

    public LineItemCollection listComputedUpfrontLineItems() throws StripeException {
        return this.listComputedUpfrontLineItems((Map<String, Object>)null, (RequestOptions)null);
    }

    public LineItemCollection listComputedUpfrontLineItems(Map<String, Object> params) throws StripeException {
        return this.listComputedUpfrontLineItems(params, (RequestOptions)null);
    }

    public LineItemCollection listComputedUpfrontLineItems(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/computed_upfront_line_items", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, LineItemCollection.class, options);
    }

    public LineItemCollection listComputedUpfrontLineItems(QuoteListComputedUpfrontLineItemsParams params) throws StripeException {
        return this.listComputedUpfrontLineItems(params, (RequestOptions)null);
    }

    public LineItemCollection listComputedUpfrontLineItems(QuoteListComputedUpfrontLineItemsParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/computed_upfront_line_items", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, LineItemCollection.class, options);
    }

    public LineItemCollection listLineItems() throws StripeException {
        return this.listLineItems((Map<String, Object>)null, (RequestOptions)null);
    }

    public LineItemCollection listLineItems(Map<String, Object> params) throws StripeException {
        return this.listLineItems(params, (RequestOptions)null);
    }

    public LineItemCollection listLineItems(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/line_items", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, LineItemCollection.class, options);
    }

    public LineItemCollection listLineItems(QuoteListLineItemsParams params) throws StripeException {
        return this.listLineItems(params, (RequestOptions)null);
    }

    public LineItemCollection listLineItems(QuoteListLineItemsParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/line_items", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, LineItemCollection.class, options);
    }

    public QuoteLineCollection listLines() throws StripeException {
        return this.listLines((Map<String, Object>)null, (RequestOptions)null);
    }

    public QuoteLineCollection listLines(Map<String, Object> params) throws StripeException {
        return this.listLines(params, (RequestOptions)null);
    }

    public QuoteLineCollection listLines(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/lines", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, QuoteLineCollection.class, options);
    }

    public QuoteLineCollection listLines(QuoteListLinesParams params) throws StripeException {
        return this.listLines(params, (RequestOptions)null);
    }

    public QuoteLineCollection listLines(QuoteListLinesParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/lines", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, QuoteLineCollection.class, options);
    }

    public Quote markStaleQuote() throws StripeException {
        return this.markStaleQuote((Map<String, Object>)null, (RequestOptions)null);
    }

    public Quote markStaleQuote(RequestOptions options) throws StripeException {
        return this.markStaleQuote((Map<String, Object>)null, options);
    }

    public Quote markStaleQuote(Map<String, Object> params) throws StripeException {
        return this.markStaleQuote(params, (RequestOptions)null);
    }

    public Quote markStaleQuote(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/mark_stale", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Quote.class, options);
    }

    public Quote markStaleQuote(QuoteMarkStaleQuoteParams params) throws StripeException {
        return this.markStaleQuote(params, (RequestOptions)null);
    }

    public Quote markStaleQuote(QuoteMarkStaleQuoteParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/mark_stale", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Quote.class, options);
    }

    public InputStream pdf() throws StripeException {
        return this.pdf((Map<String, Object>)null, (RequestOptions)null);
    }

    public InputStream pdf(Map<String, Object> params) throws StripeException {
        return this.pdf(params, (RequestOptions)null);
    }

    public InputStream pdf(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getUploadBase(), options, String.format("/v1/quotes/%s/pdf", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.requestStream(ApiResource.RequestMethod.GET, url, params, options);
    }

    public InputStream pdf(QuotePdfParams params) throws StripeException {
        return this.pdf(params, (RequestOptions)null);
    }

    public InputStream pdf(QuotePdfParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getUploadBase(), options, String.format("/v1/quotes/%s/pdf", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.requestStream(ApiResource.RequestMethod.GET, url, params, options);
    }

    public InvoiceLineItemCollection previewInvoiceLines(String quote, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/preview_invoices/%s/lines", ApiResource.urlEncodeId(quote), ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, InvoiceLineItemCollection.class, options);
    }

    public InvoiceLineItemCollection previewInvoiceLines(String quote, QuotePreviewInvoiceLinesParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/preview_invoices/%s/lines", ApiResource.urlEncodeId(quote), ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, InvoiceLineItemCollection.class, options);
    }

    public InvoiceCollection previewInvoices() throws StripeException {
        return this.previewInvoices((Map<String, Object>)null, (RequestOptions)null);
    }

    public InvoiceCollection previewInvoices(Map<String, Object> params) throws StripeException {
        return this.previewInvoices(params, (RequestOptions)null);
    }

    public InvoiceCollection previewInvoices(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/preview_invoices", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, InvoiceCollection.class, options);
    }

    public InvoiceCollection previewInvoices(QuotePreviewInvoicesParams params) throws StripeException {
        return this.previewInvoices(params, (RequestOptions)null);
    }

    public InvoiceCollection previewInvoices(QuotePreviewInvoicesParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/preview_invoices", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, InvoiceCollection.class, options);
    }

    public SubscriptionScheduleCollection previewSubscriptionSchedules() throws StripeException {
        return this.previewSubscriptionSchedules((Map<String, Object>)null, (RequestOptions)null);
    }

    public SubscriptionScheduleCollection previewSubscriptionSchedules(Map<String, Object> params) throws StripeException {
        return this.previewSubscriptionSchedules(params, (RequestOptions)null);
    }

    public SubscriptionScheduleCollection previewSubscriptionSchedules(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/preview_subscription_schedules", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, SubscriptionScheduleCollection.class, options);
    }

    public SubscriptionScheduleCollection previewSubscriptionSchedules(QuotePreviewSubscriptionSchedulesParams params) throws StripeException {
        return this.previewSubscriptionSchedules(params, (RequestOptions)null);
    }

    public SubscriptionScheduleCollection previewSubscriptionSchedules(QuotePreviewSubscriptionSchedulesParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/preview_subscription_schedules", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, SubscriptionScheduleCollection.class, options);
    }

    public Quote reestimate() throws StripeException {
        return this.reestimate((Map<String, Object>)null, (RequestOptions)null);
    }

    public Quote reestimate(RequestOptions options) throws StripeException {
        return this.reestimate((Map<String, Object>)null, options);
    }

    public Quote reestimate(Map<String, Object> params) throws StripeException {
        return this.reestimate(params, (RequestOptions)null);
    }

    public Quote reestimate(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/reestimate", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Quote.class, options);
    }

    public Quote reestimate(QuoteReestimateParams params) throws StripeException {
        return this.reestimate(params, (RequestOptions)null);
    }

    public Quote reestimate(QuoteReestimateParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/reestimate", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Quote.class, options);
    }

    public static Quote retrieve(String quote) throws StripeException {
        return Quote.retrieve(quote, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Quote retrieve(String quote, RequestOptions options) throws StripeException {
        return Quote.retrieve(quote, (Map<String, Object>)null, options);
    }

    public static Quote retrieve(String quote, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s", ApiResource.urlEncodeId(quote)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Quote.class, options);
    }

    public static Quote retrieve(String quote, QuoteRetrieveParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s", ApiResource.urlEncodeId(quote)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Quote.class, options);
    }

    public Quote update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Quote update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Quote.class, options);
    }

    public Quote update(QuoteUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Quote update(QuoteUpdateParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Quote.class, options);
    }

    @Generated
    public Long getAmountSubtotal() {
        return this.amountSubtotal;
    }

    @Generated
    public Long getAmountTotal() {
        return this.amountTotal;
    }

    @Generated
    public Long getApplicationFeeAmount() {
        return this.applicationFeeAmount;
    }

    @Generated
    public BigDecimal getApplicationFeePercent() {
        return this.applicationFeePercent;
    }

    @Generated
    public AutomaticTax getAutomaticTax() {
        return this.automaticTax;
    }

    @Generated
    public String getCollectionMethod() {
        return this.collectionMethod;
    }

    @Generated
    public Computed getComputed() {
        return this.computed;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Long getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public String getFooter() {
        return this.footer;
    }

    @Generated
    public FromQuote getFromQuote() {
        return this.fromQuote;
    }

    @Generated
    public String getHeader() {
        return this.header;
    }

    @Generated
    public InvoiceSettings getInvoiceSettings() {
        return this.invoiceSettings;
    }

    @Generated
    public LineItemCollection getLineItems() {
        return this.lineItems;
    }

    @Generated
    public List<String> getLines() {
        return this.lines;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getNumber() {
        return this.number;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public StatusDetails getStatusDetails() {
        return this.statusDetails;
    }

    @Generated
    public StatusTransitions getStatusTransitions() {
        return this.statusTransitions;
    }

    @Generated
    public SubscriptionData getSubscriptionData() {
        return this.subscriptionData;
    }

    @Generated
    public List<SubscriptionDataOverride> getSubscriptionDataOverrides() {
        return this.subscriptionDataOverrides;
    }

    @Generated
    public List<SubscriptionSchedule> getSubscriptionSchedules() {
        return this.subscriptionSchedules;
    }

    @Generated
    public TotalDetails getTotalDetails() {
        return this.totalDetails;
    }

    @Generated
    public TransferData getTransferData() {
        return this.transferData;
    }

    @Generated
    public void setAmountSubtotal(Long amountSubtotal) {
        this.amountSubtotal = amountSubtotal;
    }

    @Generated
    public void setAmountTotal(Long amountTotal) {
        this.amountTotal = amountTotal;
    }

    @Generated
    public void setApplicationFeeAmount(Long applicationFeeAmount) {
        this.applicationFeeAmount = applicationFeeAmount;
    }

    @Generated
    public void setApplicationFeePercent(BigDecimal applicationFeePercent) {
        this.applicationFeePercent = applicationFeePercent;
    }

    @Generated
    public void setAutomaticTax(AutomaticTax automaticTax) {
        this.automaticTax = automaticTax;
    }

    @Generated
    public void setCollectionMethod(String collectionMethod) {
        this.collectionMethod = collectionMethod;
    }

    @Generated
    public void setComputed(Computed computed) {
        this.computed = computed;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setExpiresAt(Long expiresAt) {
        this.expiresAt = expiresAt;
    }

    @Generated
    public void setFooter(String footer) {
        this.footer = footer;
    }

    @Generated
    public void setFromQuote(FromQuote fromQuote) {
        this.fromQuote = fromQuote;
    }

    @Generated
    public void setHeader(String header) {
        this.header = header;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setInvoiceSettings(InvoiceSettings invoiceSettings) {
        this.invoiceSettings = invoiceSettings;
    }

    @Generated
    public void setLineItems(LineItemCollection lineItems) {
        this.lineItems = lineItems;
    }

    @Generated
    public void setLines(List<String> lines) {
        this.lines = lines;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setNumber(String number) {
        this.number = number;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setStatusDetails(StatusDetails statusDetails) {
        this.statusDetails = statusDetails;
    }

    @Generated
    public void setStatusTransitions(StatusTransitions statusTransitions) {
        this.statusTransitions = statusTransitions;
    }

    @Generated
    public void setSubscriptionData(SubscriptionData subscriptionData) {
        this.subscriptionData = subscriptionData;
    }

    @Generated
    public void setSubscriptionDataOverrides(List<SubscriptionDataOverride> subscriptionDataOverrides) {
        this.subscriptionDataOverrides = subscriptionDataOverrides;
    }

    @Generated
    public void setSubscriptionSchedules(List<SubscriptionSchedule> subscriptionSchedules) {
        this.subscriptionSchedules = subscriptionSchedules;
    }

    @Generated
    public void setTotalDetails(TotalDetails totalDetails) {
        this.totalDetails = totalDetails;
    }

    @Generated
    public void setTransferData(TransferData transferData) {
        this.transferData = transferData;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Quote)) {
            return false;
        }
        Quote other = (Quote)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amountSubtotal = this.getAmountSubtotal();
        Long other$amountSubtotal = other.getAmountSubtotal();
        if (this$amountSubtotal == null ? other$amountSubtotal != null : !((Object)this$amountSubtotal).equals(other$amountSubtotal)) {
            return false;
        }
        Long this$amountTotal = this.getAmountTotal();
        Long other$amountTotal = other.getAmountTotal();
        if (this$amountTotal == null ? other$amountTotal != null : !((Object)this$amountTotal).equals(other$amountTotal)) {
            return false;
        }
        Long this$applicationFeeAmount = this.getApplicationFeeAmount();
        Long other$applicationFeeAmount = other.getApplicationFeeAmount();
        if (this$applicationFeeAmount == null ? other$applicationFeeAmount != null : !((Object)this$applicationFeeAmount).equals(other$applicationFeeAmount)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$expiresAt = this.getExpiresAt();
        Long other$expiresAt = other.getExpiresAt();
        if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        BigDecimal this$applicationFeePercent = this.getApplicationFeePercent();
        BigDecimal other$applicationFeePercent = other.getApplicationFeePercent();
        if (this$applicationFeePercent == null ? other$applicationFeePercent != null : !((Object)this$applicationFeePercent).equals(other$applicationFeePercent)) {
            return false;
        }
        AutomaticTax this$automaticTax = this.getAutomaticTax();
        AutomaticTax other$automaticTax = other.getAutomaticTax();
        if (this$automaticTax == null ? other$automaticTax != null : !((Object)this$automaticTax).equals(other$automaticTax)) {
            return false;
        }
        String this$collectionMethod = this.getCollectionMethod();
        String other$collectionMethod = other.getCollectionMethod();
        if (this$collectionMethod == null ? other$collectionMethod != null : !this$collectionMethod.equals(other$collectionMethod)) {
            return false;
        }
        Computed this$computed = this.getComputed();
        Computed other$computed = other.getComputed();
        if (this$computed == null ? other$computed != null : !((Object)this$computed).equals(other$computed)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        List<String> this$defaultTaxRates = this.getDefaultTaxRates();
        List<String> other$defaultTaxRates = other.getDefaultTaxRates();
        if (this$defaultTaxRates == null ? other$defaultTaxRates != null : !((Object)this$defaultTaxRates).equals(other$defaultTaxRates)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<String> this$discounts = this.getDiscounts();
        List<String> other$discounts = other.getDiscounts();
        if (this$discounts == null ? other$discounts != null : !((Object)this$discounts).equals(other$discounts)) {
            return false;
        }
        String this$footer = this.getFooter();
        String other$footer = other.getFooter();
        if (this$footer == null ? other$footer != null : !this$footer.equals(other$footer)) {
            return false;
        }
        FromQuote this$fromQuote = this.getFromQuote();
        FromQuote other$fromQuote = other.getFromQuote();
        if (this$fromQuote == null ? other$fromQuote != null : !((Object)this$fromQuote).equals(other$fromQuote)) {
            return false;
        }
        String this$header = this.getHeader();
        String other$header = other.getHeader();
        if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$invoice = this.getInvoice();
        String other$invoice = other.getInvoice();
        if (this$invoice == null ? other$invoice != null : !this$invoice.equals(other$invoice)) {
            return false;
        }
        InvoiceSettings this$invoiceSettings = this.getInvoiceSettings();
        InvoiceSettings other$invoiceSettings = other.getInvoiceSettings();
        if (this$invoiceSettings == null ? other$invoiceSettings != null : !((Object)this$invoiceSettings).equals(other$invoiceSettings)) {
            return false;
        }
        LineItemCollection this$lineItems = this.getLineItems();
        LineItemCollection other$lineItems = other.getLineItems();
        if (this$lineItems == null ? other$lineItems != null : !((Object)this$lineItems).equals(other$lineItems)) {
            return false;
        }
        List<String> this$lines = this.getLines();
        List<String> other$lines = other.getLines();
        if (this$lines == null ? other$lines != null : !((Object)this$lines).equals(other$lines)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$number = this.getNumber();
        String other$number = other.getNumber();
        if (this$number == null ? other$number != null : !this$number.equals(other$number)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$onBehalfOf = this.getOnBehalfOf();
        String other$onBehalfOf = other.getOnBehalfOf();
        if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        StatusDetails this$statusDetails = this.getStatusDetails();
        StatusDetails other$statusDetails = other.getStatusDetails();
        if (this$statusDetails == null ? other$statusDetails != null : !((Object)this$statusDetails).equals(other$statusDetails)) {
            return false;
        }
        StatusTransitions this$statusTransitions = this.getStatusTransitions();
        StatusTransitions other$statusTransitions = other.getStatusTransitions();
        if (this$statusTransitions == null ? other$statusTransitions != null : !((Object)this$statusTransitions).equals(other$statusTransitions)) {
            return false;
        }
        String this$subscription = this.getSubscription();
        String other$subscription = other.getSubscription();
        if (this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription)) {
            return false;
        }
        SubscriptionData this$subscriptionData = this.getSubscriptionData();
        SubscriptionData other$subscriptionData = other.getSubscriptionData();
        if (this$subscriptionData == null ? other$subscriptionData != null : !((Object)this$subscriptionData).equals(other$subscriptionData)) {
            return false;
        }
        List<SubscriptionDataOverride> this$subscriptionDataOverrides = this.getSubscriptionDataOverrides();
        List<SubscriptionDataOverride> other$subscriptionDataOverrides = other.getSubscriptionDataOverrides();
        if (this$subscriptionDataOverrides == null ? other$subscriptionDataOverrides != null : !((Object)this$subscriptionDataOverrides).equals(other$subscriptionDataOverrides)) {
            return false;
        }
        String this$subscriptionSchedule = this.getSubscriptionSchedule();
        String other$subscriptionSchedule = other.getSubscriptionSchedule();
        if (this$subscriptionSchedule == null ? other$subscriptionSchedule != null : !this$subscriptionSchedule.equals(other$subscriptionSchedule)) {
            return false;
        }
        List<SubscriptionSchedule> this$subscriptionSchedules = this.getSubscriptionSchedules();
        List<SubscriptionSchedule> other$subscriptionSchedules = other.getSubscriptionSchedules();
        if (this$subscriptionSchedules == null ? other$subscriptionSchedules != null : !((Object)this$subscriptionSchedules).equals(other$subscriptionSchedules)) {
            return false;
        }
        String this$testClock = this.getTestClock();
        String other$testClock = other.getTestClock();
        if (this$testClock == null ? other$testClock != null : !this$testClock.equals(other$testClock)) {
            return false;
        }
        TotalDetails this$totalDetails = this.getTotalDetails();
        TotalDetails other$totalDetails = other.getTotalDetails();
        if (this$totalDetails == null ? other$totalDetails != null : !((Object)this$totalDetails).equals(other$totalDetails)) {
            return false;
        }
        TransferData this$transferData = this.getTransferData();
        TransferData other$transferData = other.getTransferData();
        return !(this$transferData == null ? other$transferData != null : !((Object)this$transferData).equals(other$transferData));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Quote;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amountSubtotal = this.getAmountSubtotal();
        result = result * 59 + ($amountSubtotal == null ? 43 : ((Object)$amountSubtotal).hashCode());
        Long $amountTotal = this.getAmountTotal();
        result = result * 59 + ($amountTotal == null ? 43 : ((Object)$amountTotal).hashCode());
        Long $applicationFeeAmount = this.getApplicationFeeAmount();
        result = result * 59 + ($applicationFeeAmount == null ? 43 : ((Object)$applicationFeeAmount).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $expiresAt = this.getExpiresAt();
        result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        BigDecimal $applicationFeePercent = this.getApplicationFeePercent();
        result = result * 59 + ($applicationFeePercent == null ? 43 : ((Object)$applicationFeePercent).hashCode());
        AutomaticTax $automaticTax = this.getAutomaticTax();
        result = result * 59 + ($automaticTax == null ? 43 : ((Object)$automaticTax).hashCode());
        String $collectionMethod = this.getCollectionMethod();
        result = result * 59 + ($collectionMethod == null ? 43 : $collectionMethod.hashCode());
        Computed $computed = this.getComputed();
        result = result * 59 + ($computed == null ? 43 : ((Object)$computed).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        List<String> $defaultTaxRates = this.getDefaultTaxRates();
        result = result * 59 + ($defaultTaxRates == null ? 43 : ((Object)$defaultTaxRates).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<String> $discounts = this.getDiscounts();
        result = result * 59 + ($discounts == null ? 43 : ((Object)$discounts).hashCode());
        String $footer = this.getFooter();
        result = result * 59 + ($footer == null ? 43 : $footer.hashCode());
        FromQuote $fromQuote = this.getFromQuote();
        result = result * 59 + ($fromQuote == null ? 43 : ((Object)$fromQuote).hashCode());
        String $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : $header.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $invoice = this.getInvoice();
        result = result * 59 + ($invoice == null ? 43 : $invoice.hashCode());
        InvoiceSettings $invoiceSettings = this.getInvoiceSettings();
        result = result * 59 + ($invoiceSettings == null ? 43 : ((Object)$invoiceSettings).hashCode());
        LineItemCollection $lineItems = this.getLineItems();
        result = result * 59 + ($lineItems == null ? 43 : ((Object)$lineItems).hashCode());
        List<String> $lines = this.getLines();
        result = result * 59 + ($lines == null ? 43 : ((Object)$lines).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $number = this.getNumber();
        result = result * 59 + ($number == null ? 43 : $number.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $onBehalfOf = this.getOnBehalfOf();
        result = result * 59 + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        StatusDetails $statusDetails = this.getStatusDetails();
        result = result * 59 + ($statusDetails == null ? 43 : ((Object)$statusDetails).hashCode());
        StatusTransitions $statusTransitions = this.getStatusTransitions();
        result = result * 59 + ($statusTransitions == null ? 43 : ((Object)$statusTransitions).hashCode());
        String $subscription = this.getSubscription();
        result = result * 59 + ($subscription == null ? 43 : $subscription.hashCode());
        SubscriptionData $subscriptionData = this.getSubscriptionData();
        result = result * 59 + ($subscriptionData == null ? 43 : ((Object)$subscriptionData).hashCode());
        List<SubscriptionDataOverride> $subscriptionDataOverrides = this.getSubscriptionDataOverrides();
        result = result * 59 + ($subscriptionDataOverrides == null ? 43 : ((Object)$subscriptionDataOverrides).hashCode());
        String $subscriptionSchedule = this.getSubscriptionSchedule();
        result = result * 59 + ($subscriptionSchedule == null ? 43 : $subscriptionSchedule.hashCode());
        List<SubscriptionSchedule> $subscriptionSchedules = this.getSubscriptionSchedules();
        result = result * 59 + ($subscriptionSchedules == null ? 43 : ((Object)$subscriptionSchedules).hashCode());
        String $testClock = this.getTestClock();
        result = result * 59 + ($testClock == null ? 43 : $testClock.hashCode());
        TotalDetails $totalDetails = this.getTotalDetails();
        result = result * 59 + ($totalDetails == null ? 43 : ((Object)$totalDetails).hashCode());
        TransferData $transferData = this.getTransferData();
        result = result * 59 + ($transferData == null ? 43 : ((Object)$transferData).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class AutomaticTax
    extends StripeObject {
        @SerializedName(value="enabled")
        Boolean enabled;
        @SerializedName(value="status")
        String status;

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AutomaticTax)) {
                return false;
            }
            AutomaticTax other = (AutomaticTax)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !this$status.equals(other$status));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AutomaticTax;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            return result;
        }
    }

    public static class Computed
    extends StripeObject {
        @SerializedName(value="recurring")
        Recurring recurring;
        @SerializedName(value="updated_at")
        Long updatedAt;
        @SerializedName(value="upfront")
        Upfront upfront;

        @Generated
        public Recurring getRecurring() {
            return this.recurring;
        }

        @Generated
        public Long getUpdatedAt() {
            return this.updatedAt;
        }

        @Generated
        public Upfront getUpfront() {
            return this.upfront;
        }

        @Generated
        public void setRecurring(Recurring recurring) {
            this.recurring = recurring;
        }

        @Generated
        public void setUpdatedAt(Long updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Generated
        public void setUpfront(Upfront upfront) {
            this.upfront = upfront;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Computed)) {
                return false;
            }
            Computed other = (Computed)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$updatedAt = this.getUpdatedAt();
            Long other$updatedAt = other.getUpdatedAt();
            if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
                return false;
            }
            Recurring this$recurring = this.getRecurring();
            Recurring other$recurring = other.getRecurring();
            if (this$recurring == null ? other$recurring != null : !((Object)this$recurring).equals(other$recurring)) {
                return false;
            }
            Upfront this$upfront = this.getUpfront();
            Upfront other$upfront = other.getUpfront();
            return !(this$upfront == null ? other$upfront != null : !((Object)this$upfront).equals(other$upfront));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Computed;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $updatedAt = this.getUpdatedAt();
            result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
            Recurring $recurring = this.getRecurring();
            result = result * 59 + ($recurring == null ? 43 : ((Object)$recurring).hashCode());
            Upfront $upfront = this.getUpfront();
            result = result * 59 + ($upfront == null ? 43 : ((Object)$upfront).hashCode());
            return result;
        }

        public static class Recurring
        extends StripeObject {
            @SerializedName(value="amount_subtotal")
            Long amountSubtotal;
            @SerializedName(value="amount_total")
            Long amountTotal;
            @SerializedName(value="interval")
            String interval;
            @SerializedName(value="interval_count")
            Long intervalCount;
            @SerializedName(value="total_details")
            TotalDetails totalDetails;

            @Generated
            public Long getAmountSubtotal() {
                return this.amountSubtotal;
            }

            @Generated
            public Long getAmountTotal() {
                return this.amountTotal;
            }

            @Generated
            public String getInterval() {
                return this.interval;
            }

            @Generated
            public Long getIntervalCount() {
                return this.intervalCount;
            }

            @Generated
            public TotalDetails getTotalDetails() {
                return this.totalDetails;
            }

            @Generated
            public void setAmountSubtotal(Long amountSubtotal) {
                this.amountSubtotal = amountSubtotal;
            }

            @Generated
            public void setAmountTotal(Long amountTotal) {
                this.amountTotal = amountTotal;
            }

            @Generated
            public void setInterval(String interval) {
                this.interval = interval;
            }

            @Generated
            public void setIntervalCount(Long intervalCount) {
                this.intervalCount = intervalCount;
            }

            @Generated
            public void setTotalDetails(TotalDetails totalDetails) {
                this.totalDetails = totalDetails;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Recurring)) {
                    return false;
                }
                Recurring other = (Recurring)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$amountSubtotal = this.getAmountSubtotal();
                Long other$amountSubtotal = other.getAmountSubtotal();
                if (this$amountSubtotal == null ? other$amountSubtotal != null : !((Object)this$amountSubtotal).equals(other$amountSubtotal)) {
                    return false;
                }
                Long this$amountTotal = this.getAmountTotal();
                Long other$amountTotal = other.getAmountTotal();
                if (this$amountTotal == null ? other$amountTotal != null : !((Object)this$amountTotal).equals(other$amountTotal)) {
                    return false;
                }
                Long this$intervalCount = this.getIntervalCount();
                Long other$intervalCount = other.getIntervalCount();
                if (this$intervalCount == null ? other$intervalCount != null : !((Object)this$intervalCount).equals(other$intervalCount)) {
                    return false;
                }
                String this$interval = this.getInterval();
                String other$interval = other.getInterval();
                if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) {
                    return false;
                }
                TotalDetails this$totalDetails = this.getTotalDetails();
                TotalDetails other$totalDetails = other.getTotalDetails();
                return !(this$totalDetails == null ? other$totalDetails != null : !((Object)this$totalDetails).equals(other$totalDetails));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Recurring;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $amountSubtotal = this.getAmountSubtotal();
                result = result * 59 + ($amountSubtotal == null ? 43 : ((Object)$amountSubtotal).hashCode());
                Long $amountTotal = this.getAmountTotal();
                result = result * 59 + ($amountTotal == null ? 43 : ((Object)$amountTotal).hashCode());
                Long $intervalCount = this.getIntervalCount();
                result = result * 59 + ($intervalCount == null ? 43 : ((Object)$intervalCount).hashCode());
                String $interval = this.getInterval();
                result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
                TotalDetails $totalDetails = this.getTotalDetails();
                result = result * 59 + ($totalDetails == null ? 43 : ((Object)$totalDetails).hashCode());
                return result;
            }

            public static class TotalDetails
            extends StripeObject {
                @SerializedName(value="amount_discount")
                Long amountDiscount;
                @SerializedName(value="amount_shipping")
                Long amountShipping;
                @SerializedName(value="amount_tax")
                Long amountTax;
                @SerializedName(value="breakdown")
                Breakdown breakdown;

                @Generated
                public Long getAmountDiscount() {
                    return this.amountDiscount;
                }

                @Generated
                public Long getAmountShipping() {
                    return this.amountShipping;
                }

                @Generated
                public Long getAmountTax() {
                    return this.amountTax;
                }

                @Generated
                public Breakdown getBreakdown() {
                    return this.breakdown;
                }

                @Generated
                public void setAmountDiscount(Long amountDiscount) {
                    this.amountDiscount = amountDiscount;
                }

                @Generated
                public void setAmountShipping(Long amountShipping) {
                    this.amountShipping = amountShipping;
                }

                @Generated
                public void setAmountTax(Long amountTax) {
                    this.amountTax = amountTax;
                }

                @Generated
                public void setBreakdown(Breakdown breakdown) {
                    this.breakdown = breakdown;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof TotalDetails)) {
                        return false;
                    }
                    TotalDetails other = (TotalDetails)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$amountDiscount = this.getAmountDiscount();
                    Long other$amountDiscount = other.getAmountDiscount();
                    if (this$amountDiscount == null ? other$amountDiscount != null : !((Object)this$amountDiscount).equals(other$amountDiscount)) {
                        return false;
                    }
                    Long this$amountShipping = this.getAmountShipping();
                    Long other$amountShipping = other.getAmountShipping();
                    if (this$amountShipping == null ? other$amountShipping != null : !((Object)this$amountShipping).equals(other$amountShipping)) {
                        return false;
                    }
                    Long this$amountTax = this.getAmountTax();
                    Long other$amountTax = other.getAmountTax();
                    if (this$amountTax == null ? other$amountTax != null : !((Object)this$amountTax).equals(other$amountTax)) {
                        return false;
                    }
                    Breakdown this$breakdown = this.getBreakdown();
                    Breakdown other$breakdown = other.getBreakdown();
                    return !(this$breakdown == null ? other$breakdown != null : !((Object)this$breakdown).equals(other$breakdown));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof TotalDetails;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $amountDiscount = this.getAmountDiscount();
                    result = result * 59 + ($amountDiscount == null ? 43 : ((Object)$amountDiscount).hashCode());
                    Long $amountShipping = this.getAmountShipping();
                    result = result * 59 + ($amountShipping == null ? 43 : ((Object)$amountShipping).hashCode());
                    Long $amountTax = this.getAmountTax();
                    result = result * 59 + ($amountTax == null ? 43 : ((Object)$amountTax).hashCode());
                    Breakdown $breakdown = this.getBreakdown();
                    result = result * 59 + ($breakdown == null ? 43 : ((Object)$breakdown).hashCode());
                    return result;
                }

                public static class Breakdown
                extends StripeObject {
                    @SerializedName(value="discounts")
                    List<Discount> discounts;
                    @SerializedName(value="taxes")
                    List<Tax> taxes;

                    @Generated
                    public List<Discount> getDiscounts() {
                        return this.discounts;
                    }

                    @Generated
                    public List<Tax> getTaxes() {
                        return this.taxes;
                    }

                    @Generated
                    public void setDiscounts(List<Discount> discounts) {
                        this.discounts = discounts;
                    }

                    @Generated
                    public void setTaxes(List<Tax> taxes) {
                        this.taxes = taxes;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Breakdown)) {
                            return false;
                        }
                        Breakdown other = (Breakdown)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        List<Discount> this$discounts = this.getDiscounts();
                        List<Discount> other$discounts = other.getDiscounts();
                        if (this$discounts == null ? other$discounts != null : !((Object)this$discounts).equals(other$discounts)) {
                            return false;
                        }
                        List<Tax> this$taxes = this.getTaxes();
                        List<Tax> other$taxes = other.getTaxes();
                        return !(this$taxes == null ? other$taxes != null : !((Object)this$taxes).equals(other$taxes));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Breakdown;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        List<Discount> $discounts = this.getDiscounts();
                        result = result * 59 + ($discounts == null ? 43 : ((Object)$discounts).hashCode());
                        List<Tax> $taxes = this.getTaxes();
                        result = result * 59 + ($taxes == null ? 43 : ((Object)$taxes).hashCode());
                        return result;
                    }

                    public static class Tax
                    extends StripeObject {
                        @SerializedName(value="amount")
                        Long amount;
                        @SerializedName(value="rate")
                        TaxRate rate;

                        @Generated
                        public Long getAmount() {
                            return this.amount;
                        }

                        @Generated
                        public TaxRate getRate() {
                            return this.rate;
                        }

                        @Generated
                        public void setAmount(Long amount) {
                            this.amount = amount;
                        }

                        @Generated
                        public void setRate(TaxRate rate) {
                            this.rate = rate;
                        }

                        @Generated
                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof Tax)) {
                                return false;
                            }
                            Tax other = (Tax)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            Long this$amount = this.getAmount();
                            Long other$amount = other.getAmount();
                            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                                return false;
                            }
                            TaxRate this$rate = this.getRate();
                            TaxRate other$rate = other.getRate();
                            return !(this$rate == null ? other$rate != null : !((Object)this$rate).equals(other$rate));
                        }

                        @Generated
                        protected boolean canEqual(Object other) {
                            return other instanceof Tax;
                        }

                        @Generated
                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            Long $amount = this.getAmount();
                            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                            TaxRate $rate = this.getRate();
                            result = result * 59 + ($rate == null ? 43 : ((Object)$rate).hashCode());
                            return result;
                        }
                    }

                    public static class Discount
                    extends StripeObject {
                        @SerializedName(value="amount")
                        Long amount;
                        @SerializedName(value="discount")
                        com.stripe.model.Discount discount;

                        @Generated
                        public Long getAmount() {
                            return this.amount;
                        }

                        @Generated
                        public com.stripe.model.Discount getDiscount() {
                            return this.discount;
                        }

                        @Generated
                        public void setAmount(Long amount) {
                            this.amount = amount;
                        }

                        @Generated
                        public void setDiscount(com.stripe.model.Discount discount) {
                            this.discount = discount;
                        }

                        @Generated
                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof Discount)) {
                                return false;
                            }
                            Discount other = (Discount)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            Long this$amount = this.getAmount();
                            Long other$amount = other.getAmount();
                            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                                return false;
                            }
                            com.stripe.model.Discount this$discount = this.getDiscount();
                            com.stripe.model.Discount other$discount = other.getDiscount();
                            return !(this$discount == null ? other$discount != null : !((Object)this$discount).equals(other$discount));
                        }

                        @Generated
                        protected boolean canEqual(Object other) {
                            return other instanceof Discount;
                        }

                        @Generated
                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            Long $amount = this.getAmount();
                            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                            com.stripe.model.Discount $discount = this.getDiscount();
                            result = result * 59 + ($discount == null ? 43 : ((Object)$discount).hashCode());
                            return result;
                        }
                    }
                }
            }
        }

        public static class Upfront
        extends StripeObject {
            @SerializedName(value="amount_subtotal")
            Long amountSubtotal;
            @SerializedName(value="amount_total")
            Long amountTotal;
            @SerializedName(value="line_items")
            LineItemCollection lineItems;
            @SerializedName(value="total_details")
            TotalDetails totalDetails;

            @Generated
            public Long getAmountSubtotal() {
                return this.amountSubtotal;
            }

            @Generated
            public Long getAmountTotal() {
                return this.amountTotal;
            }

            @Generated
            public LineItemCollection getLineItems() {
                return this.lineItems;
            }

            @Generated
            public TotalDetails getTotalDetails() {
                return this.totalDetails;
            }

            @Generated
            public void setAmountSubtotal(Long amountSubtotal) {
                this.amountSubtotal = amountSubtotal;
            }

            @Generated
            public void setAmountTotal(Long amountTotal) {
                this.amountTotal = amountTotal;
            }

            @Generated
            public void setLineItems(LineItemCollection lineItems) {
                this.lineItems = lineItems;
            }

            @Generated
            public void setTotalDetails(TotalDetails totalDetails) {
                this.totalDetails = totalDetails;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Upfront)) {
                    return false;
                }
                Upfront other = (Upfront)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$amountSubtotal = this.getAmountSubtotal();
                Long other$amountSubtotal = other.getAmountSubtotal();
                if (this$amountSubtotal == null ? other$amountSubtotal != null : !((Object)this$amountSubtotal).equals(other$amountSubtotal)) {
                    return false;
                }
                Long this$amountTotal = this.getAmountTotal();
                Long other$amountTotal = other.getAmountTotal();
                if (this$amountTotal == null ? other$amountTotal != null : !((Object)this$amountTotal).equals(other$amountTotal)) {
                    return false;
                }
                LineItemCollection this$lineItems = this.getLineItems();
                LineItemCollection other$lineItems = other.getLineItems();
                if (this$lineItems == null ? other$lineItems != null : !((Object)this$lineItems).equals(other$lineItems)) {
                    return false;
                }
                TotalDetails this$totalDetails = this.getTotalDetails();
                TotalDetails other$totalDetails = other.getTotalDetails();
                return !(this$totalDetails == null ? other$totalDetails != null : !((Object)this$totalDetails).equals(other$totalDetails));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Upfront;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $amountSubtotal = this.getAmountSubtotal();
                result = result * 59 + ($amountSubtotal == null ? 43 : ((Object)$amountSubtotal).hashCode());
                Long $amountTotal = this.getAmountTotal();
                result = result * 59 + ($amountTotal == null ? 43 : ((Object)$amountTotal).hashCode());
                LineItemCollection $lineItems = this.getLineItems();
                result = result * 59 + ($lineItems == null ? 43 : ((Object)$lineItems).hashCode());
                TotalDetails $totalDetails = this.getTotalDetails();
                result = result * 59 + ($totalDetails == null ? 43 : ((Object)$totalDetails).hashCode());
                return result;
            }

            public static class TotalDetails
            extends StripeObject {
                @SerializedName(value="amount_discount")
                Long amountDiscount;
                @SerializedName(value="amount_shipping")
                Long amountShipping;
                @SerializedName(value="amount_tax")
                Long amountTax;
                @SerializedName(value="breakdown")
                Breakdown breakdown;

                @Generated
                public Long getAmountDiscount() {
                    return this.amountDiscount;
                }

                @Generated
                public Long getAmountShipping() {
                    return this.amountShipping;
                }

                @Generated
                public Long getAmountTax() {
                    return this.amountTax;
                }

                @Generated
                public Breakdown getBreakdown() {
                    return this.breakdown;
                }

                @Generated
                public void setAmountDiscount(Long amountDiscount) {
                    this.amountDiscount = amountDiscount;
                }

                @Generated
                public void setAmountShipping(Long amountShipping) {
                    this.amountShipping = amountShipping;
                }

                @Generated
                public void setAmountTax(Long amountTax) {
                    this.amountTax = amountTax;
                }

                @Generated
                public void setBreakdown(Breakdown breakdown) {
                    this.breakdown = breakdown;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof TotalDetails)) {
                        return false;
                    }
                    TotalDetails other = (TotalDetails)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$amountDiscount = this.getAmountDiscount();
                    Long other$amountDiscount = other.getAmountDiscount();
                    if (this$amountDiscount == null ? other$amountDiscount != null : !((Object)this$amountDiscount).equals(other$amountDiscount)) {
                        return false;
                    }
                    Long this$amountShipping = this.getAmountShipping();
                    Long other$amountShipping = other.getAmountShipping();
                    if (this$amountShipping == null ? other$amountShipping != null : !((Object)this$amountShipping).equals(other$amountShipping)) {
                        return false;
                    }
                    Long this$amountTax = this.getAmountTax();
                    Long other$amountTax = other.getAmountTax();
                    if (this$amountTax == null ? other$amountTax != null : !((Object)this$amountTax).equals(other$amountTax)) {
                        return false;
                    }
                    Breakdown this$breakdown = this.getBreakdown();
                    Breakdown other$breakdown = other.getBreakdown();
                    return !(this$breakdown == null ? other$breakdown != null : !((Object)this$breakdown).equals(other$breakdown));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof TotalDetails;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $amountDiscount = this.getAmountDiscount();
                    result = result * 59 + ($amountDiscount == null ? 43 : ((Object)$amountDiscount).hashCode());
                    Long $amountShipping = this.getAmountShipping();
                    result = result * 59 + ($amountShipping == null ? 43 : ((Object)$amountShipping).hashCode());
                    Long $amountTax = this.getAmountTax();
                    result = result * 59 + ($amountTax == null ? 43 : ((Object)$amountTax).hashCode());
                    Breakdown $breakdown = this.getBreakdown();
                    result = result * 59 + ($breakdown == null ? 43 : ((Object)$breakdown).hashCode());
                    return result;
                }

                public static class Breakdown
                extends StripeObject {
                    @SerializedName(value="discounts")
                    List<Discount> discounts;
                    @SerializedName(value="taxes")
                    List<Tax> taxes;

                    @Generated
                    public List<Discount> getDiscounts() {
                        return this.discounts;
                    }

                    @Generated
                    public List<Tax> getTaxes() {
                        return this.taxes;
                    }

                    @Generated
                    public void setDiscounts(List<Discount> discounts) {
                        this.discounts = discounts;
                    }

                    @Generated
                    public void setTaxes(List<Tax> taxes) {
                        this.taxes = taxes;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Breakdown)) {
                            return false;
                        }
                        Breakdown other = (Breakdown)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        List<Discount> this$discounts = this.getDiscounts();
                        List<Discount> other$discounts = other.getDiscounts();
                        if (this$discounts == null ? other$discounts != null : !((Object)this$discounts).equals(other$discounts)) {
                            return false;
                        }
                        List<Tax> this$taxes = this.getTaxes();
                        List<Tax> other$taxes = other.getTaxes();
                        return !(this$taxes == null ? other$taxes != null : !((Object)this$taxes).equals(other$taxes));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Breakdown;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        List<Discount> $discounts = this.getDiscounts();
                        result = result * 59 + ($discounts == null ? 43 : ((Object)$discounts).hashCode());
                        List<Tax> $taxes = this.getTaxes();
                        result = result * 59 + ($taxes == null ? 43 : ((Object)$taxes).hashCode());
                        return result;
                    }

                    public static class Tax
                    extends StripeObject {
                        @SerializedName(value="amount")
                        Long amount;
                        @SerializedName(value="rate")
                        TaxRate rate;

                        @Generated
                        public Long getAmount() {
                            return this.amount;
                        }

                        @Generated
                        public TaxRate getRate() {
                            return this.rate;
                        }

                        @Generated
                        public void setAmount(Long amount) {
                            this.amount = amount;
                        }

                        @Generated
                        public void setRate(TaxRate rate) {
                            this.rate = rate;
                        }

                        @Generated
                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof Tax)) {
                                return false;
                            }
                            Tax other = (Tax)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            Long this$amount = this.getAmount();
                            Long other$amount = other.getAmount();
                            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                                return false;
                            }
                            TaxRate this$rate = this.getRate();
                            TaxRate other$rate = other.getRate();
                            return !(this$rate == null ? other$rate != null : !((Object)this$rate).equals(other$rate));
                        }

                        @Generated
                        protected boolean canEqual(Object other) {
                            return other instanceof Tax;
                        }

                        @Generated
                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            Long $amount = this.getAmount();
                            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                            TaxRate $rate = this.getRate();
                            result = result * 59 + ($rate == null ? 43 : ((Object)$rate).hashCode());
                            return result;
                        }
                    }

                    public static class Discount
                    extends StripeObject {
                        @SerializedName(value="amount")
                        Long amount;
                        @SerializedName(value="discount")
                        com.stripe.model.Discount discount;

                        @Generated
                        public Long getAmount() {
                            return this.amount;
                        }

                        @Generated
                        public com.stripe.model.Discount getDiscount() {
                            return this.discount;
                        }

                        @Generated
                        public void setAmount(Long amount) {
                            this.amount = amount;
                        }

                        @Generated
                        public void setDiscount(com.stripe.model.Discount discount) {
                            this.discount = discount;
                        }

                        @Generated
                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof Discount)) {
                                return false;
                            }
                            Discount other = (Discount)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            Long this$amount = this.getAmount();
                            Long other$amount = other.getAmount();
                            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                                return false;
                            }
                            com.stripe.model.Discount this$discount = this.getDiscount();
                            com.stripe.model.Discount other$discount = other.getDiscount();
                            return !(this$discount == null ? other$discount != null : !((Object)this$discount).equals(other$discount));
                        }

                        @Generated
                        protected boolean canEqual(Object other) {
                            return other instanceof Discount;
                        }

                        @Generated
                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            Long $amount = this.getAmount();
                            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                            com.stripe.model.Discount $discount = this.getDiscount();
                            result = result * 59 + ($discount == null ? 43 : ((Object)$discount).hashCode());
                            return result;
                        }
                    }
                }
            }
        }
    }

    public static class FromQuote
    extends StripeObject {
        @SerializedName(value="is_revision")
        Boolean isRevision;
        @SerializedName(value="quote")
        ExpandableField<Quote> quote;

        public String getQuote() {
            return this.quote != null ? this.quote.getId() : null;
        }

        public void setQuote(String id) {
            this.quote = ApiResource.setExpandableFieldId(id, this.quote);
        }

        public Quote getQuoteObject() {
            return this.quote != null ? this.quote.getExpanded() : null;
        }

        public void setQuoteObject(Quote expandableObject) {
            this.quote = new ExpandableField<Quote>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public Boolean getIsRevision() {
            return this.isRevision;
        }

        @Generated
        public void setIsRevision(Boolean isRevision) {
            this.isRevision = isRevision;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FromQuote)) {
                return false;
            }
            FromQuote other = (FromQuote)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$isRevision = this.getIsRevision();
            Boolean other$isRevision = other.getIsRevision();
            if (this$isRevision == null ? other$isRevision != null : !((Object)this$isRevision).equals(other$isRevision)) {
                return false;
            }
            String this$quote = this.getQuote();
            String other$quote = other.getQuote();
            return !(this$quote == null ? other$quote != null : !this$quote.equals(other$quote));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FromQuote;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $isRevision = this.getIsRevision();
            result = result * 59 + ($isRevision == null ? 43 : ((Object)$isRevision).hashCode());
            String $quote = this.getQuote();
            result = result * 59 + ($quote == null ? 43 : $quote.hashCode());
            return result;
        }
    }

    public static class InvoiceSettings
    extends StripeObject {
        @SerializedName(value="days_until_due")
        Long daysUntilDue;

        @Generated
        public Long getDaysUntilDue() {
            return this.daysUntilDue;
        }

        @Generated
        public void setDaysUntilDue(Long daysUntilDue) {
            this.daysUntilDue = daysUntilDue;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InvoiceSettings)) {
                return false;
            }
            InvoiceSettings other = (InvoiceSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$daysUntilDue = this.getDaysUntilDue();
            Long other$daysUntilDue = other.getDaysUntilDue();
            return !(this$daysUntilDue == null ? other$daysUntilDue != null : !((Object)this$daysUntilDue).equals(other$daysUntilDue));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InvoiceSettings;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $daysUntilDue = this.getDaysUntilDue();
            result = result * 59 + ($daysUntilDue == null ? 43 : ((Object)$daysUntilDue).hashCode());
            return result;
        }
    }

    public static class StatusDetails
    extends StripeObject {
        @SerializedName(value="canceled")
        Canceled canceled;
        @SerializedName(value="stale")
        Stale stale;

        @Generated
        public Canceled getCanceled() {
            return this.canceled;
        }

        @Generated
        public Stale getStale() {
            return this.stale;
        }

        @Generated
        public void setCanceled(Canceled canceled) {
            this.canceled = canceled;
        }

        @Generated
        public void setStale(Stale stale) {
            this.stale = stale;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatusDetails)) {
                return false;
            }
            StatusDetails other = (StatusDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Canceled this$canceled = this.getCanceled();
            Canceled other$canceled = other.getCanceled();
            if (this$canceled == null ? other$canceled != null : !((Object)this$canceled).equals(other$canceled)) {
                return false;
            }
            Stale this$stale = this.getStale();
            Stale other$stale = other.getStale();
            return !(this$stale == null ? other$stale != null : !((Object)this$stale).equals(other$stale));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof StatusDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Canceled $canceled = this.getCanceled();
            result = result * 59 + ($canceled == null ? 43 : ((Object)$canceled).hashCode());
            Stale $stale = this.getStale();
            result = result * 59 + ($stale == null ? 43 : ((Object)$stale).hashCode());
            return result;
        }

        public static class Canceled
        extends StripeObject {
            @SerializedName(value="reason")
            String reason;
            @SerializedName(value="transitioned_at")
            Long transitionedAt;

            @Generated
            public String getReason() {
                return this.reason;
            }

            @Generated
            public Long getTransitionedAt() {
                return this.transitionedAt;
            }

            @Generated
            public void setReason(String reason) {
                this.reason = reason;
            }

            @Generated
            public void setTransitionedAt(Long transitionedAt) {
                this.transitionedAt = transitionedAt;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Canceled)) {
                    return false;
                }
                Canceled other = (Canceled)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$transitionedAt = this.getTransitionedAt();
                Long other$transitionedAt = other.getTransitionedAt();
                if (this$transitionedAt == null ? other$transitionedAt != null : !((Object)this$transitionedAt).equals(other$transitionedAt)) {
                    return false;
                }
                String this$reason = this.getReason();
                String other$reason = other.getReason();
                return !(this$reason == null ? other$reason != null : !this$reason.equals(other$reason));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Canceled;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $transitionedAt = this.getTransitionedAt();
                result = result * 59 + ($transitionedAt == null ? 43 : ((Object)$transitionedAt).hashCode());
                String $reason = this.getReason();
                result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
                return result;
            }
        }

        public static class Stale
        extends StripeObject {
            @SerializedName(value="expires_at")
            Long expiresAt;
            @SerializedName(value="last_reason")
            LastReason lastReason;
            @SerializedName(value="last_updated_at")
            Long lastUpdatedAt;
            @SerializedName(value="transitioned_at")
            Long transitionedAt;

            @Generated
            public Long getExpiresAt() {
                return this.expiresAt;
            }

            @Generated
            public LastReason getLastReason() {
                return this.lastReason;
            }

            @Generated
            public Long getLastUpdatedAt() {
                return this.lastUpdatedAt;
            }

            @Generated
            public Long getTransitionedAt() {
                return this.transitionedAt;
            }

            @Generated
            public void setExpiresAt(Long expiresAt) {
                this.expiresAt = expiresAt;
            }

            @Generated
            public void setLastReason(LastReason lastReason) {
                this.lastReason = lastReason;
            }

            @Generated
            public void setLastUpdatedAt(Long lastUpdatedAt) {
                this.lastUpdatedAt = lastUpdatedAt;
            }

            @Generated
            public void setTransitionedAt(Long transitionedAt) {
                this.transitionedAt = transitionedAt;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Stale)) {
                    return false;
                }
                Stale other = (Stale)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expiresAt = this.getExpiresAt();
                Long other$expiresAt = other.getExpiresAt();
                if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
                    return false;
                }
                Long this$lastUpdatedAt = this.getLastUpdatedAt();
                Long other$lastUpdatedAt = other.getLastUpdatedAt();
                if (this$lastUpdatedAt == null ? other$lastUpdatedAt != null : !((Object)this$lastUpdatedAt).equals(other$lastUpdatedAt)) {
                    return false;
                }
                Long this$transitionedAt = this.getTransitionedAt();
                Long other$transitionedAt = other.getTransitionedAt();
                if (this$transitionedAt == null ? other$transitionedAt != null : !((Object)this$transitionedAt).equals(other$transitionedAt)) {
                    return false;
                }
                LastReason this$lastReason = this.getLastReason();
                LastReason other$lastReason = other.getLastReason();
                return !(this$lastReason == null ? other$lastReason != null : !((Object)this$lastReason).equals(other$lastReason));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Stale;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expiresAt = this.getExpiresAt();
                result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
                Long $lastUpdatedAt = this.getLastUpdatedAt();
                result = result * 59 + ($lastUpdatedAt == null ? 43 : ((Object)$lastUpdatedAt).hashCode());
                Long $transitionedAt = this.getTransitionedAt();
                result = result * 59 + ($transitionedAt == null ? 43 : ((Object)$transitionedAt).hashCode());
                LastReason $lastReason = this.getLastReason();
                result = result * 59 + ($lastReason == null ? 43 : ((Object)$lastReason).hashCode());
                return result;
            }

            public static class LastReason
            extends StripeObject {
                @SerializedName(value="line_invalid")
                String lineInvalid;
                @SerializedName(value="subscription_canceled")
                String subscriptionCanceled;
                @SerializedName(value="subscription_changed")
                SubscriptionChanged subscriptionChanged;
                @SerializedName(value="subscription_expired")
                String subscriptionExpired;
                @SerializedName(value="subscription_schedule_canceled")
                String subscriptionScheduleCanceled;
                @SerializedName(value="subscription_schedule_changed")
                SubscriptionScheduleChanged subscriptionScheduleChanged;
                @SerializedName(value="subscription_schedule_released")
                String subscriptionScheduleReleased;
                @SerializedName(value="type")
                String type;

                @Generated
                public String getLineInvalid() {
                    return this.lineInvalid;
                }

                @Generated
                public String getSubscriptionCanceled() {
                    return this.subscriptionCanceled;
                }

                @Generated
                public SubscriptionChanged getSubscriptionChanged() {
                    return this.subscriptionChanged;
                }

                @Generated
                public String getSubscriptionExpired() {
                    return this.subscriptionExpired;
                }

                @Generated
                public String getSubscriptionScheduleCanceled() {
                    return this.subscriptionScheduleCanceled;
                }

                @Generated
                public SubscriptionScheduleChanged getSubscriptionScheduleChanged() {
                    return this.subscriptionScheduleChanged;
                }

                @Generated
                public String getSubscriptionScheduleReleased() {
                    return this.subscriptionScheduleReleased;
                }

                @Generated
                public String getType() {
                    return this.type;
                }

                @Generated
                public void setLineInvalid(String lineInvalid) {
                    this.lineInvalid = lineInvalid;
                }

                @Generated
                public void setSubscriptionCanceled(String subscriptionCanceled) {
                    this.subscriptionCanceled = subscriptionCanceled;
                }

                @Generated
                public void setSubscriptionChanged(SubscriptionChanged subscriptionChanged) {
                    this.subscriptionChanged = subscriptionChanged;
                }

                @Generated
                public void setSubscriptionExpired(String subscriptionExpired) {
                    this.subscriptionExpired = subscriptionExpired;
                }

                @Generated
                public void setSubscriptionScheduleCanceled(String subscriptionScheduleCanceled) {
                    this.subscriptionScheduleCanceled = subscriptionScheduleCanceled;
                }

                @Generated
                public void setSubscriptionScheduleChanged(SubscriptionScheduleChanged subscriptionScheduleChanged) {
                    this.subscriptionScheduleChanged = subscriptionScheduleChanged;
                }

                @Generated
                public void setSubscriptionScheduleReleased(String subscriptionScheduleReleased) {
                    this.subscriptionScheduleReleased = subscriptionScheduleReleased;
                }

                @Generated
                public void setType(String type) {
                    this.type = type;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof LastReason)) {
                        return false;
                    }
                    LastReason other = (LastReason)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$lineInvalid = this.getLineInvalid();
                    String other$lineInvalid = other.getLineInvalid();
                    if (this$lineInvalid == null ? other$lineInvalid != null : !this$lineInvalid.equals(other$lineInvalid)) {
                        return false;
                    }
                    String this$subscriptionCanceled = this.getSubscriptionCanceled();
                    String other$subscriptionCanceled = other.getSubscriptionCanceled();
                    if (this$subscriptionCanceled == null ? other$subscriptionCanceled != null : !this$subscriptionCanceled.equals(other$subscriptionCanceled)) {
                        return false;
                    }
                    SubscriptionChanged this$subscriptionChanged = this.getSubscriptionChanged();
                    SubscriptionChanged other$subscriptionChanged = other.getSubscriptionChanged();
                    if (this$subscriptionChanged == null ? other$subscriptionChanged != null : !((Object)this$subscriptionChanged).equals(other$subscriptionChanged)) {
                        return false;
                    }
                    String this$subscriptionExpired = this.getSubscriptionExpired();
                    String other$subscriptionExpired = other.getSubscriptionExpired();
                    if (this$subscriptionExpired == null ? other$subscriptionExpired != null : !this$subscriptionExpired.equals(other$subscriptionExpired)) {
                        return false;
                    }
                    String this$subscriptionScheduleCanceled = this.getSubscriptionScheduleCanceled();
                    String other$subscriptionScheduleCanceled = other.getSubscriptionScheduleCanceled();
                    if (this$subscriptionScheduleCanceled == null ? other$subscriptionScheduleCanceled != null : !this$subscriptionScheduleCanceled.equals(other$subscriptionScheduleCanceled)) {
                        return false;
                    }
                    SubscriptionScheduleChanged this$subscriptionScheduleChanged = this.getSubscriptionScheduleChanged();
                    SubscriptionScheduleChanged other$subscriptionScheduleChanged = other.getSubscriptionScheduleChanged();
                    if (this$subscriptionScheduleChanged == null ? other$subscriptionScheduleChanged != null : !((Object)this$subscriptionScheduleChanged).equals(other$subscriptionScheduleChanged)) {
                        return false;
                    }
                    String this$subscriptionScheduleReleased = this.getSubscriptionScheduleReleased();
                    String other$subscriptionScheduleReleased = other.getSubscriptionScheduleReleased();
                    if (this$subscriptionScheduleReleased == null ? other$subscriptionScheduleReleased != null : !this$subscriptionScheduleReleased.equals(other$subscriptionScheduleReleased)) {
                        return false;
                    }
                    String this$type = this.getType();
                    String other$type = other.getType();
                    return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof LastReason;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $lineInvalid = this.getLineInvalid();
                    result = result * 59 + ($lineInvalid == null ? 43 : $lineInvalid.hashCode());
                    String $subscriptionCanceled = this.getSubscriptionCanceled();
                    result = result * 59 + ($subscriptionCanceled == null ? 43 : $subscriptionCanceled.hashCode());
                    SubscriptionChanged $subscriptionChanged = this.getSubscriptionChanged();
                    result = result * 59 + ($subscriptionChanged == null ? 43 : ((Object)$subscriptionChanged).hashCode());
                    String $subscriptionExpired = this.getSubscriptionExpired();
                    result = result * 59 + ($subscriptionExpired == null ? 43 : $subscriptionExpired.hashCode());
                    String $subscriptionScheduleCanceled = this.getSubscriptionScheduleCanceled();
                    result = result * 59 + ($subscriptionScheduleCanceled == null ? 43 : $subscriptionScheduleCanceled.hashCode());
                    SubscriptionScheduleChanged $subscriptionScheduleChanged = this.getSubscriptionScheduleChanged();
                    result = result * 59 + ($subscriptionScheduleChanged == null ? 43 : ((Object)$subscriptionScheduleChanged).hashCode());
                    String $subscriptionScheduleReleased = this.getSubscriptionScheduleReleased();
                    result = result * 59 + ($subscriptionScheduleReleased == null ? 43 : $subscriptionScheduleReleased.hashCode());
                    String $type = this.getType();
                    result = result * 59 + ($type == null ? 43 : $type.hashCode());
                    return result;
                }

                public static class SubscriptionChanged
                extends StripeObject {
                    @SerializedName(value="previous_subscription")
                    Subscription previousSubscription;

                    @Generated
                    public Subscription getPreviousSubscription() {
                        return this.previousSubscription;
                    }

                    @Generated
                    public void setPreviousSubscription(Subscription previousSubscription) {
                        this.previousSubscription = previousSubscription;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof SubscriptionChanged)) {
                            return false;
                        }
                        SubscriptionChanged other = (SubscriptionChanged)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Subscription this$previousSubscription = this.getPreviousSubscription();
                        Subscription other$previousSubscription = other.getPreviousSubscription();
                        return !(this$previousSubscription == null ? other$previousSubscription != null : !((Object)this$previousSubscription).equals(other$previousSubscription));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof SubscriptionChanged;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Subscription $previousSubscription = this.getPreviousSubscription();
                        result = result * 59 + ($previousSubscription == null ? 43 : ((Object)$previousSubscription).hashCode());
                        return result;
                    }
                }

                public static class SubscriptionScheduleChanged
                extends StripeObject {
                    @SerializedName(value="previous_subscription_schedule")
                    com.stripe.model.SubscriptionSchedule previousSubscriptionSchedule;

                    @Generated
                    public com.stripe.model.SubscriptionSchedule getPreviousSubscriptionSchedule() {
                        return this.previousSubscriptionSchedule;
                    }

                    @Generated
                    public void setPreviousSubscriptionSchedule(com.stripe.model.SubscriptionSchedule previousSubscriptionSchedule) {
                        this.previousSubscriptionSchedule = previousSubscriptionSchedule;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof SubscriptionScheduleChanged)) {
                            return false;
                        }
                        SubscriptionScheduleChanged other = (SubscriptionScheduleChanged)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        com.stripe.model.SubscriptionSchedule this$previousSubscriptionSchedule = this.getPreviousSubscriptionSchedule();
                        com.stripe.model.SubscriptionSchedule other$previousSubscriptionSchedule = other.getPreviousSubscriptionSchedule();
                        return !(this$previousSubscriptionSchedule == null ? other$previousSubscriptionSchedule != null : !((Object)this$previousSubscriptionSchedule).equals(other$previousSubscriptionSchedule));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof SubscriptionScheduleChanged;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        com.stripe.model.SubscriptionSchedule $previousSubscriptionSchedule = this.getPreviousSubscriptionSchedule();
                        result = result * 59 + ($previousSubscriptionSchedule == null ? 43 : ((Object)$previousSubscriptionSchedule).hashCode());
                        return result;
                    }
                }
            }
        }
    }

    public static class StatusTransitions
    extends StripeObject {
        @SerializedName(value="accepted_at")
        Long acceptedAt;
        @SerializedName(value="canceled_at")
        Long canceledAt;
        @SerializedName(value="finalized_at")
        Long finalizedAt;

        @Generated
        public Long getAcceptedAt() {
            return this.acceptedAt;
        }

        @Generated
        public Long getCanceledAt() {
            return this.canceledAt;
        }

        @Generated
        public Long getFinalizedAt() {
            return this.finalizedAt;
        }

        @Generated
        public void setAcceptedAt(Long acceptedAt) {
            this.acceptedAt = acceptedAt;
        }

        @Generated
        public void setCanceledAt(Long canceledAt) {
            this.canceledAt = canceledAt;
        }

        @Generated
        public void setFinalizedAt(Long finalizedAt) {
            this.finalizedAt = finalizedAt;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatusTransitions)) {
                return false;
            }
            StatusTransitions other = (StatusTransitions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$acceptedAt = this.getAcceptedAt();
            Long other$acceptedAt = other.getAcceptedAt();
            if (this$acceptedAt == null ? other$acceptedAt != null : !((Object)this$acceptedAt).equals(other$acceptedAt)) {
                return false;
            }
            Long this$canceledAt = this.getCanceledAt();
            Long other$canceledAt = other.getCanceledAt();
            if (this$canceledAt == null ? other$canceledAt != null : !((Object)this$canceledAt).equals(other$canceledAt)) {
                return false;
            }
            Long this$finalizedAt = this.getFinalizedAt();
            Long other$finalizedAt = other.getFinalizedAt();
            return !(this$finalizedAt == null ? other$finalizedAt != null : !((Object)this$finalizedAt).equals(other$finalizedAt));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof StatusTransitions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $acceptedAt = this.getAcceptedAt();
            result = result * 59 + ($acceptedAt == null ? 43 : ((Object)$acceptedAt).hashCode());
            Long $canceledAt = this.getCanceledAt();
            result = result * 59 + ($canceledAt == null ? 43 : ((Object)$canceledAt).hashCode());
            Long $finalizedAt = this.getFinalizedAt();
            result = result * 59 + ($finalizedAt == null ? 43 : ((Object)$finalizedAt).hashCode());
            return result;
        }
    }

    public static class SubscriptionData
    extends StripeObject {
        @SerializedName(value="bill_on_acceptance")
        BillOnAcceptance billOnAcceptance;
        @SerializedName(value="billing_behavior")
        String billingBehavior;
        @SerializedName(value="billing_cycle_anchor")
        String billingCycleAnchor;
        @SerializedName(value="description")
        String description;
        @SerializedName(value="effective_date")
        Long effectiveDate;
        @SerializedName(value="end_behavior")
        String endBehavior;
        @SerializedName(value="from_schedule")
        ExpandableField<com.stripe.model.SubscriptionSchedule> fromSchedule;
        @SerializedName(value="from_subscription")
        ExpandableField<Subscription> fromSubscription;
        @SerializedName(value="prebilling")
        Prebilling prebilling;
        @SerializedName(value="proration_behavior")
        String prorationBehavior;
        @SerializedName(value="trial_period_days")
        Long trialPeriodDays;

        public String getFromSchedule() {
            return this.fromSchedule != null ? this.fromSchedule.getId() : null;
        }

        public void setFromSchedule(String id) {
            this.fromSchedule = ApiResource.setExpandableFieldId(id, this.fromSchedule);
        }

        public com.stripe.model.SubscriptionSchedule getFromScheduleObject() {
            return this.fromSchedule != null ? this.fromSchedule.getExpanded() : null;
        }

        public void setFromScheduleObject(com.stripe.model.SubscriptionSchedule expandableObject) {
            this.fromSchedule = new ExpandableField<com.stripe.model.SubscriptionSchedule>(expandableObject.getId(), expandableObject);
        }

        public String getFromSubscription() {
            return this.fromSubscription != null ? this.fromSubscription.getId() : null;
        }

        public void setFromSubscription(String id) {
            this.fromSubscription = ApiResource.setExpandableFieldId(id, this.fromSubscription);
        }

        public Subscription getFromSubscriptionObject() {
            return this.fromSubscription != null ? this.fromSubscription.getExpanded() : null;
        }

        public void setFromSubscriptionObject(Subscription expandableObject) {
            this.fromSubscription = new ExpandableField<Subscription>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public BillOnAcceptance getBillOnAcceptance() {
            return this.billOnAcceptance;
        }

        @Generated
        public String getBillingBehavior() {
            return this.billingBehavior;
        }

        @Generated
        public String getBillingCycleAnchor() {
            return this.billingCycleAnchor;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public Long getEffectiveDate() {
            return this.effectiveDate;
        }

        @Generated
        public String getEndBehavior() {
            return this.endBehavior;
        }

        @Generated
        public Prebilling getPrebilling() {
            return this.prebilling;
        }

        @Generated
        public String getProrationBehavior() {
            return this.prorationBehavior;
        }

        @Generated
        public Long getTrialPeriodDays() {
            return this.trialPeriodDays;
        }

        @Generated
        public void setBillOnAcceptance(BillOnAcceptance billOnAcceptance) {
            this.billOnAcceptance = billOnAcceptance;
        }

        @Generated
        public void setBillingBehavior(String billingBehavior) {
            this.billingBehavior = billingBehavior;
        }

        @Generated
        public void setBillingCycleAnchor(String billingCycleAnchor) {
            this.billingCycleAnchor = billingCycleAnchor;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public void setEffectiveDate(Long effectiveDate) {
            this.effectiveDate = effectiveDate;
        }

        @Generated
        public void setEndBehavior(String endBehavior) {
            this.endBehavior = endBehavior;
        }

        @Generated
        public void setPrebilling(Prebilling prebilling) {
            this.prebilling = prebilling;
        }

        @Generated
        public void setProrationBehavior(String prorationBehavior) {
            this.prorationBehavior = prorationBehavior;
        }

        @Generated
        public void setTrialPeriodDays(Long trialPeriodDays) {
            this.trialPeriodDays = trialPeriodDays;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubscriptionData)) {
                return false;
            }
            SubscriptionData other = (SubscriptionData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$effectiveDate = this.getEffectiveDate();
            Long other$effectiveDate = other.getEffectiveDate();
            if (this$effectiveDate == null ? other$effectiveDate != null : !((Object)this$effectiveDate).equals(other$effectiveDate)) {
                return false;
            }
            Long this$trialPeriodDays = this.getTrialPeriodDays();
            Long other$trialPeriodDays = other.getTrialPeriodDays();
            if (this$trialPeriodDays == null ? other$trialPeriodDays != null : !((Object)this$trialPeriodDays).equals(other$trialPeriodDays)) {
                return false;
            }
            BillOnAcceptance this$billOnAcceptance = this.getBillOnAcceptance();
            BillOnAcceptance other$billOnAcceptance = other.getBillOnAcceptance();
            if (this$billOnAcceptance == null ? other$billOnAcceptance != null : !((Object)this$billOnAcceptance).equals(other$billOnAcceptance)) {
                return false;
            }
            String this$billingBehavior = this.getBillingBehavior();
            String other$billingBehavior = other.getBillingBehavior();
            if (this$billingBehavior == null ? other$billingBehavior != null : !this$billingBehavior.equals(other$billingBehavior)) {
                return false;
            }
            String this$billingCycleAnchor = this.getBillingCycleAnchor();
            String other$billingCycleAnchor = other.getBillingCycleAnchor();
            if (this$billingCycleAnchor == null ? other$billingCycleAnchor != null : !this$billingCycleAnchor.equals(other$billingCycleAnchor)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$endBehavior = this.getEndBehavior();
            String other$endBehavior = other.getEndBehavior();
            if (this$endBehavior == null ? other$endBehavior != null : !this$endBehavior.equals(other$endBehavior)) {
                return false;
            }
            String this$fromSchedule = this.getFromSchedule();
            String other$fromSchedule = other.getFromSchedule();
            if (this$fromSchedule == null ? other$fromSchedule != null : !this$fromSchedule.equals(other$fromSchedule)) {
                return false;
            }
            String this$fromSubscription = this.getFromSubscription();
            String other$fromSubscription = other.getFromSubscription();
            if (this$fromSubscription == null ? other$fromSubscription != null : !this$fromSubscription.equals(other$fromSubscription)) {
                return false;
            }
            Prebilling this$prebilling = this.getPrebilling();
            Prebilling other$prebilling = other.getPrebilling();
            if (this$prebilling == null ? other$prebilling != null : !((Object)this$prebilling).equals(other$prebilling)) {
                return false;
            }
            String this$prorationBehavior = this.getProrationBehavior();
            String other$prorationBehavior = other.getProrationBehavior();
            return !(this$prorationBehavior == null ? other$prorationBehavior != null : !this$prorationBehavior.equals(other$prorationBehavior));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SubscriptionData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $effectiveDate = this.getEffectiveDate();
            result = result * 59 + ($effectiveDate == null ? 43 : ((Object)$effectiveDate).hashCode());
            Long $trialPeriodDays = this.getTrialPeriodDays();
            result = result * 59 + ($trialPeriodDays == null ? 43 : ((Object)$trialPeriodDays).hashCode());
            BillOnAcceptance $billOnAcceptance = this.getBillOnAcceptance();
            result = result * 59 + ($billOnAcceptance == null ? 43 : ((Object)$billOnAcceptance).hashCode());
            String $billingBehavior = this.getBillingBehavior();
            result = result * 59 + ($billingBehavior == null ? 43 : $billingBehavior.hashCode());
            String $billingCycleAnchor = this.getBillingCycleAnchor();
            result = result * 59 + ($billingCycleAnchor == null ? 43 : $billingCycleAnchor.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $endBehavior = this.getEndBehavior();
            result = result * 59 + ($endBehavior == null ? 43 : $endBehavior.hashCode());
            String $fromSchedule = this.getFromSchedule();
            result = result * 59 + ($fromSchedule == null ? 43 : $fromSchedule.hashCode());
            String $fromSubscription = this.getFromSubscription();
            result = result * 59 + ($fromSubscription == null ? 43 : $fromSubscription.hashCode());
            Prebilling $prebilling = this.getPrebilling();
            result = result * 59 + ($prebilling == null ? 43 : ((Object)$prebilling).hashCode());
            String $prorationBehavior = this.getProrationBehavior();
            result = result * 59 + ($prorationBehavior == null ? 43 : $prorationBehavior.hashCode());
            return result;
        }

        public static class BillOnAcceptance
        extends StripeObject {
            @SerializedName(value="bill_from")
            BillFrom billFrom;
            @SerializedName(value="bill_until")
            BillUntil billUntil;

            @Generated
            public BillFrom getBillFrom() {
                return this.billFrom;
            }

            @Generated
            public BillUntil getBillUntil() {
                return this.billUntil;
            }

            @Generated
            public void setBillFrom(BillFrom billFrom) {
                this.billFrom = billFrom;
            }

            @Generated
            public void setBillUntil(BillUntil billUntil) {
                this.billUntil = billUntil;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BillOnAcceptance)) {
                    return false;
                }
                BillOnAcceptance other = (BillOnAcceptance)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                BillFrom this$billFrom = this.getBillFrom();
                BillFrom other$billFrom = other.getBillFrom();
                if (this$billFrom == null ? other$billFrom != null : !((Object)this$billFrom).equals(other$billFrom)) {
                    return false;
                }
                BillUntil this$billUntil = this.getBillUntil();
                BillUntil other$billUntil = other.getBillUntil();
                return !(this$billUntil == null ? other$billUntil != null : !((Object)this$billUntil).equals(other$billUntil));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof BillOnAcceptance;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                BillFrom $billFrom = this.getBillFrom();
                result = result * 59 + ($billFrom == null ? 43 : ((Object)$billFrom).hashCode());
                BillUntil $billUntil = this.getBillUntil();
                result = result * 59 + ($billUntil == null ? 43 : ((Object)$billUntil).hashCode());
                return result;
            }

            public static class BillFrom
            extends StripeObject {
                @SerializedName(value="computed")
                Long computed;
                @SerializedName(value="line_starts_at")
                LineStartsAt lineStartsAt;
                @SerializedName(value="timestamp")
                Long timestamp;
                @SerializedName(value="type")
                String type;

                @Generated
                public Long getComputed() {
                    return this.computed;
                }

                @Generated
                public LineStartsAt getLineStartsAt() {
                    return this.lineStartsAt;
                }

                @Generated
                public Long getTimestamp() {
                    return this.timestamp;
                }

                @Generated
                public String getType() {
                    return this.type;
                }

                @Generated
                public void setComputed(Long computed) {
                    this.computed = computed;
                }

                @Generated
                public void setLineStartsAt(LineStartsAt lineStartsAt) {
                    this.lineStartsAt = lineStartsAt;
                }

                @Generated
                public void setTimestamp(Long timestamp) {
                    this.timestamp = timestamp;
                }

                @Generated
                public void setType(String type) {
                    this.type = type;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof BillFrom)) {
                        return false;
                    }
                    BillFrom other = (BillFrom)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$computed = this.getComputed();
                    Long other$computed = other.getComputed();
                    if (this$computed == null ? other$computed != null : !((Object)this$computed).equals(other$computed)) {
                        return false;
                    }
                    Long this$timestamp = this.getTimestamp();
                    Long other$timestamp = other.getTimestamp();
                    if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
                        return false;
                    }
                    LineStartsAt this$lineStartsAt = this.getLineStartsAt();
                    LineStartsAt other$lineStartsAt = other.getLineStartsAt();
                    if (this$lineStartsAt == null ? other$lineStartsAt != null : !((Object)this$lineStartsAt).equals(other$lineStartsAt)) {
                        return false;
                    }
                    String this$type = this.getType();
                    String other$type = other.getType();
                    return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof BillFrom;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $computed = this.getComputed();
                    result = result * 59 + ($computed == null ? 43 : ((Object)$computed).hashCode());
                    Long $timestamp = this.getTimestamp();
                    result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
                    LineStartsAt $lineStartsAt = this.getLineStartsAt();
                    result = result * 59 + ($lineStartsAt == null ? 43 : ((Object)$lineStartsAt).hashCode());
                    String $type = this.getType();
                    result = result * 59 + ($type == null ? 43 : $type.hashCode());
                    return result;
                }

                public static class LineStartsAt
                extends StripeObject
                implements HasId {
                    @SerializedName(value="id")
                    String id;

                    @Generated
                    public void setId(String id) {
                        this.id = id;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof LineStartsAt)) {
                            return false;
                        }
                        LineStartsAt other = (LineStartsAt)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$id = this.getId();
                        String other$id = other.getId();
                        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof LineStartsAt;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $id = this.getId();
                        result = result * 59 + ($id == null ? 43 : $id.hashCode());
                        return result;
                    }

                    @Override
                    @Generated
                    public String getId() {
                        return this.id;
                    }
                }
            }

            public static class BillUntil
            extends StripeObject {
                @SerializedName(value="computed")
                Long computed;
                @SerializedName(value="duration")
                Duration duration;
                @SerializedName(value="line_ends_at")
                LineEndsAt lineEndsAt;
                @SerializedName(value="timestamp")
                Long timestamp;
                @SerializedName(value="type")
                String type;

                @Generated
                public Long getComputed() {
                    return this.computed;
                }

                @Generated
                public Duration getDuration() {
                    return this.duration;
                }

                @Generated
                public LineEndsAt getLineEndsAt() {
                    return this.lineEndsAt;
                }

                @Generated
                public Long getTimestamp() {
                    return this.timestamp;
                }

                @Generated
                public String getType() {
                    return this.type;
                }

                @Generated
                public void setComputed(Long computed) {
                    this.computed = computed;
                }

                @Generated
                public void setDuration(Duration duration) {
                    this.duration = duration;
                }

                @Generated
                public void setLineEndsAt(LineEndsAt lineEndsAt) {
                    this.lineEndsAt = lineEndsAt;
                }

                @Generated
                public void setTimestamp(Long timestamp) {
                    this.timestamp = timestamp;
                }

                @Generated
                public void setType(String type) {
                    this.type = type;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof BillUntil)) {
                        return false;
                    }
                    BillUntil other = (BillUntil)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$computed = this.getComputed();
                    Long other$computed = other.getComputed();
                    if (this$computed == null ? other$computed != null : !((Object)this$computed).equals(other$computed)) {
                        return false;
                    }
                    Long this$timestamp = this.getTimestamp();
                    Long other$timestamp = other.getTimestamp();
                    if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
                        return false;
                    }
                    Duration this$duration = this.getDuration();
                    Duration other$duration = other.getDuration();
                    if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
                        return false;
                    }
                    LineEndsAt this$lineEndsAt = this.getLineEndsAt();
                    LineEndsAt other$lineEndsAt = other.getLineEndsAt();
                    if (this$lineEndsAt == null ? other$lineEndsAt != null : !((Object)this$lineEndsAt).equals(other$lineEndsAt)) {
                        return false;
                    }
                    String this$type = this.getType();
                    String other$type = other.getType();
                    return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof BillUntil;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $computed = this.getComputed();
                    result = result * 59 + ($computed == null ? 43 : ((Object)$computed).hashCode());
                    Long $timestamp = this.getTimestamp();
                    result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
                    Duration $duration = this.getDuration();
                    result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
                    LineEndsAt $lineEndsAt = this.getLineEndsAt();
                    result = result * 59 + ($lineEndsAt == null ? 43 : ((Object)$lineEndsAt).hashCode());
                    String $type = this.getType();
                    result = result * 59 + ($type == null ? 43 : $type.hashCode());
                    return result;
                }

                public static class Duration
                extends StripeObject {
                    @SerializedName(value="interval")
                    String interval;
                    @SerializedName(value="interval_count")
                    Long intervalCount;

                    @Generated
                    public String getInterval() {
                        return this.interval;
                    }

                    @Generated
                    public Long getIntervalCount() {
                        return this.intervalCount;
                    }

                    @Generated
                    public void setInterval(String interval) {
                        this.interval = interval;
                    }

                    @Generated
                    public void setIntervalCount(Long intervalCount) {
                        this.intervalCount = intervalCount;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Duration)) {
                            return false;
                        }
                        Duration other = (Duration)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Long this$intervalCount = this.getIntervalCount();
                        Long other$intervalCount = other.getIntervalCount();
                        if (this$intervalCount == null ? other$intervalCount != null : !((Object)this$intervalCount).equals(other$intervalCount)) {
                            return false;
                        }
                        String this$interval = this.getInterval();
                        String other$interval = other.getInterval();
                        return !(this$interval == null ? other$interval != null : !this$interval.equals(other$interval));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Duration;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Long $intervalCount = this.getIntervalCount();
                        result = result * 59 + ($intervalCount == null ? 43 : ((Object)$intervalCount).hashCode());
                        String $interval = this.getInterval();
                        result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
                        return result;
                    }
                }

                public static class LineEndsAt
                extends StripeObject
                implements HasId {
                    @SerializedName(value="id")
                    String id;

                    @Generated
                    public void setId(String id) {
                        this.id = id;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof LineEndsAt)) {
                            return false;
                        }
                        LineEndsAt other = (LineEndsAt)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$id = this.getId();
                        String other$id = other.getId();
                        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof LineEndsAt;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $id = this.getId();
                        result = result * 59 + ($id == null ? 43 : $id.hashCode());
                        return result;
                    }

                    @Override
                    @Generated
                    public String getId() {
                        return this.id;
                    }
                }
            }
        }

        public static class Prebilling
        extends StripeObject {
            @SerializedName(value="iterations")
            Long iterations;

            @Generated
            public Long getIterations() {
                return this.iterations;
            }

            @Generated
            public void setIterations(Long iterations) {
                this.iterations = iterations;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Prebilling)) {
                    return false;
                }
                Prebilling other = (Prebilling)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$iterations = this.getIterations();
                Long other$iterations = other.getIterations();
                return !(this$iterations == null ? other$iterations != null : !((Object)this$iterations).equals(other$iterations));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Prebilling;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $iterations = this.getIterations();
                result = result * 59 + ($iterations == null ? 43 : ((Object)$iterations).hashCode());
                return result;
            }
        }
    }

    public static class TotalDetails
    extends StripeObject {
        @SerializedName(value="amount_discount")
        Long amountDiscount;
        @SerializedName(value="amount_shipping")
        Long amountShipping;
        @SerializedName(value="amount_tax")
        Long amountTax;
        @SerializedName(value="breakdown")
        Breakdown breakdown;

        @Generated
        public Long getAmountDiscount() {
            return this.amountDiscount;
        }

        @Generated
        public Long getAmountShipping() {
            return this.amountShipping;
        }

        @Generated
        public Long getAmountTax() {
            return this.amountTax;
        }

        @Generated
        public Breakdown getBreakdown() {
            return this.breakdown;
        }

        @Generated
        public void setAmountDiscount(Long amountDiscount) {
            this.amountDiscount = amountDiscount;
        }

        @Generated
        public void setAmountShipping(Long amountShipping) {
            this.amountShipping = amountShipping;
        }

        @Generated
        public void setAmountTax(Long amountTax) {
            this.amountTax = amountTax;
        }

        @Generated
        public void setBreakdown(Breakdown breakdown) {
            this.breakdown = breakdown;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TotalDetails)) {
                return false;
            }
            TotalDetails other = (TotalDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amountDiscount = this.getAmountDiscount();
            Long other$amountDiscount = other.getAmountDiscount();
            if (this$amountDiscount == null ? other$amountDiscount != null : !((Object)this$amountDiscount).equals(other$amountDiscount)) {
                return false;
            }
            Long this$amountShipping = this.getAmountShipping();
            Long other$amountShipping = other.getAmountShipping();
            if (this$amountShipping == null ? other$amountShipping != null : !((Object)this$amountShipping).equals(other$amountShipping)) {
                return false;
            }
            Long this$amountTax = this.getAmountTax();
            Long other$amountTax = other.getAmountTax();
            if (this$amountTax == null ? other$amountTax != null : !((Object)this$amountTax).equals(other$amountTax)) {
                return false;
            }
            Breakdown this$breakdown = this.getBreakdown();
            Breakdown other$breakdown = other.getBreakdown();
            return !(this$breakdown == null ? other$breakdown != null : !((Object)this$breakdown).equals(other$breakdown));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TotalDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amountDiscount = this.getAmountDiscount();
            result = result * 59 + ($amountDiscount == null ? 43 : ((Object)$amountDiscount).hashCode());
            Long $amountShipping = this.getAmountShipping();
            result = result * 59 + ($amountShipping == null ? 43 : ((Object)$amountShipping).hashCode());
            Long $amountTax = this.getAmountTax();
            result = result * 59 + ($amountTax == null ? 43 : ((Object)$amountTax).hashCode());
            Breakdown $breakdown = this.getBreakdown();
            result = result * 59 + ($breakdown == null ? 43 : ((Object)$breakdown).hashCode());
            return result;
        }

        public static class Breakdown
        extends StripeObject {
            @SerializedName(value="discounts")
            List<Discount> discounts;
            @SerializedName(value="taxes")
            List<Tax> taxes;

            @Generated
            public List<Discount> getDiscounts() {
                return this.discounts;
            }

            @Generated
            public List<Tax> getTaxes() {
                return this.taxes;
            }

            @Generated
            public void setDiscounts(List<Discount> discounts) {
                this.discounts = discounts;
            }

            @Generated
            public void setTaxes(List<Tax> taxes) {
                this.taxes = taxes;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Breakdown)) {
                    return false;
                }
                Breakdown other = (Breakdown)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<Discount> this$discounts = this.getDiscounts();
                List<Discount> other$discounts = other.getDiscounts();
                if (this$discounts == null ? other$discounts != null : !((Object)this$discounts).equals(other$discounts)) {
                    return false;
                }
                List<Tax> this$taxes = this.getTaxes();
                List<Tax> other$taxes = other.getTaxes();
                return !(this$taxes == null ? other$taxes != null : !((Object)this$taxes).equals(other$taxes));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Breakdown;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<Discount> $discounts = this.getDiscounts();
                result = result * 59 + ($discounts == null ? 43 : ((Object)$discounts).hashCode());
                List<Tax> $taxes = this.getTaxes();
                result = result * 59 + ($taxes == null ? 43 : ((Object)$taxes).hashCode());
                return result;
            }

            public static class Tax
            extends StripeObject {
                @SerializedName(value="amount")
                Long amount;
                @SerializedName(value="rate")
                TaxRate rate;

                @Generated
                public Long getAmount() {
                    return this.amount;
                }

                @Generated
                public TaxRate getRate() {
                    return this.rate;
                }

                @Generated
                public void setAmount(Long amount) {
                    this.amount = amount;
                }

                @Generated
                public void setRate(TaxRate rate) {
                    this.rate = rate;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Tax)) {
                        return false;
                    }
                    Tax other = (Tax)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$amount = this.getAmount();
                    Long other$amount = other.getAmount();
                    if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                        return false;
                    }
                    TaxRate this$rate = this.getRate();
                    TaxRate other$rate = other.getRate();
                    return !(this$rate == null ? other$rate != null : !((Object)this$rate).equals(other$rate));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Tax;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $amount = this.getAmount();
                    result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                    TaxRate $rate = this.getRate();
                    result = result * 59 + ($rate == null ? 43 : ((Object)$rate).hashCode());
                    return result;
                }
            }

            public static class Discount
            extends StripeObject {
                @SerializedName(value="amount")
                Long amount;
                @SerializedName(value="discount")
                com.stripe.model.Discount discount;

                @Generated
                public Long getAmount() {
                    return this.amount;
                }

                @Generated
                public com.stripe.model.Discount getDiscount() {
                    return this.discount;
                }

                @Generated
                public void setAmount(Long amount) {
                    this.amount = amount;
                }

                @Generated
                public void setDiscount(com.stripe.model.Discount discount) {
                    this.discount = discount;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Discount)) {
                        return false;
                    }
                    Discount other = (Discount)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$amount = this.getAmount();
                    Long other$amount = other.getAmount();
                    if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                        return false;
                    }
                    com.stripe.model.Discount this$discount = this.getDiscount();
                    com.stripe.model.Discount other$discount = other.getDiscount();
                    return !(this$discount == null ? other$discount != null : !((Object)this$discount).equals(other$discount));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Discount;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $amount = this.getAmount();
                    result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                    com.stripe.model.Discount $discount = this.getDiscount();
                    result = result * 59 + ($discount == null ? 43 : ((Object)$discount).hashCode());
                    return result;
                }
            }
        }
    }

    public static class TransferData
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="amount_percent")
        BigDecimal amountPercent;
        @SerializedName(value="destination")
        ExpandableField<Account> destination;

        public String getDestination() {
            return this.destination != null ? this.destination.getId() : null;
        }

        public void setDestination(String id) {
            this.destination = ApiResource.setExpandableFieldId(id, this.destination);
        }

        public Account getDestinationObject() {
            return this.destination != null ? this.destination.getExpanded() : null;
        }

        public void setDestinationObject(Account expandableObject) {
            this.destination = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public BigDecimal getAmountPercent() {
            return this.amountPercent;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public void setAmountPercent(BigDecimal amountPercent) {
            this.amountPercent = amountPercent;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransferData)) {
                return false;
            }
            TransferData other = (TransferData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            BigDecimal this$amountPercent = this.getAmountPercent();
            BigDecimal other$amountPercent = other.getAmountPercent();
            if (this$amountPercent == null ? other$amountPercent != null : !((Object)this$amountPercent).equals(other$amountPercent)) {
                return false;
            }
            String this$destination = this.getDestination();
            String other$destination = other.getDestination();
            return !(this$destination == null ? other$destination != null : !this$destination.equals(other$destination));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TransferData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            BigDecimal $amountPercent = this.getAmountPercent();
            result = result * 59 + ($amountPercent == null ? 43 : ((Object)$amountPercent).hashCode());
            String $destination = this.getDestination();
            result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
            return result;
        }
    }

    public static class SubscriptionSchedule
    extends StripeObject {
        @SerializedName(value="applies_to")
        AppliesTo appliesTo;
        @SerializedName(value="subscription_schedule")
        String subscriptionSchedule;

        @Generated
        public AppliesTo getAppliesTo() {
            return this.appliesTo;
        }

        @Generated
        public String getSubscriptionSchedule() {
            return this.subscriptionSchedule;
        }

        @Generated
        public void setAppliesTo(AppliesTo appliesTo) {
            this.appliesTo = appliesTo;
        }

        @Generated
        public void setSubscriptionSchedule(String subscriptionSchedule) {
            this.subscriptionSchedule = subscriptionSchedule;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubscriptionSchedule)) {
                return false;
            }
            SubscriptionSchedule other = (SubscriptionSchedule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AppliesTo this$appliesTo = this.getAppliesTo();
            AppliesTo other$appliesTo = other.getAppliesTo();
            if (this$appliesTo == null ? other$appliesTo != null : !((Object)this$appliesTo).equals(other$appliesTo)) {
                return false;
            }
            String this$subscriptionSchedule = this.getSubscriptionSchedule();
            String other$subscriptionSchedule = other.getSubscriptionSchedule();
            return !(this$subscriptionSchedule == null ? other$subscriptionSchedule != null : !this$subscriptionSchedule.equals(other$subscriptionSchedule));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SubscriptionSchedule;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AppliesTo $appliesTo = this.getAppliesTo();
            result = result * 59 + ($appliesTo == null ? 43 : ((Object)$appliesTo).hashCode());
            String $subscriptionSchedule = this.getSubscriptionSchedule();
            result = result * 59 + ($subscriptionSchedule == null ? 43 : $subscriptionSchedule.hashCode());
            return result;
        }

        public static class AppliesTo
        extends StripeObject {
            @SerializedName(value="new_reference")
            String newReference;
            @SerializedName(value="subscription_schedule")
            String subscriptionSchedule;
            @SerializedName(value="type")
            String type;

            @Generated
            public String getNewReference() {
                return this.newReference;
            }

            @Generated
            public String getSubscriptionSchedule() {
                return this.subscriptionSchedule;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setNewReference(String newReference) {
                this.newReference = newReference;
            }

            @Generated
            public void setSubscriptionSchedule(String subscriptionSchedule) {
                this.subscriptionSchedule = subscriptionSchedule;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AppliesTo)) {
                    return false;
                }
                AppliesTo other = (AppliesTo)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$newReference = this.getNewReference();
                String other$newReference = other.getNewReference();
                if (this$newReference == null ? other$newReference != null : !this$newReference.equals(other$newReference)) {
                    return false;
                }
                String this$subscriptionSchedule = this.getSubscriptionSchedule();
                String other$subscriptionSchedule = other.getSubscriptionSchedule();
                if (this$subscriptionSchedule == null ? other$subscriptionSchedule != null : !this$subscriptionSchedule.equals(other$subscriptionSchedule)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AppliesTo;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $newReference = this.getNewReference();
                result = result * 59 + ($newReference == null ? 43 : $newReference.hashCode());
                String $subscriptionSchedule = this.getSubscriptionSchedule();
                result = result * 59 + ($subscriptionSchedule == null ? 43 : $subscriptionSchedule.hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }
    }

    public static class SubscriptionDataOverride
    extends StripeObject {
        @SerializedName(value="applies_to")
        AppliesTo appliesTo;
        @SerializedName(value="bill_on_acceptance")
        BillOnAcceptance billOnAcceptance;
        @SerializedName(value="billing_behavior")
        String billingBehavior;
        @SerializedName(value="customer")
        String customer;
        @SerializedName(value="description")
        String description;
        @SerializedName(value="end_behavior")
        String endBehavior;
        @SerializedName(value="proration_behavior")
        String prorationBehavior;

        @Generated
        public AppliesTo getAppliesTo() {
            return this.appliesTo;
        }

        @Generated
        public BillOnAcceptance getBillOnAcceptance() {
            return this.billOnAcceptance;
        }

        @Generated
        public String getBillingBehavior() {
            return this.billingBehavior;
        }

        @Generated
        public String getCustomer() {
            return this.customer;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public String getEndBehavior() {
            return this.endBehavior;
        }

        @Generated
        public String getProrationBehavior() {
            return this.prorationBehavior;
        }

        @Generated
        public void setAppliesTo(AppliesTo appliesTo) {
            this.appliesTo = appliesTo;
        }

        @Generated
        public void setBillOnAcceptance(BillOnAcceptance billOnAcceptance) {
            this.billOnAcceptance = billOnAcceptance;
        }

        @Generated
        public void setBillingBehavior(String billingBehavior) {
            this.billingBehavior = billingBehavior;
        }

        @Generated
        public void setCustomer(String customer) {
            this.customer = customer;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public void setEndBehavior(String endBehavior) {
            this.endBehavior = endBehavior;
        }

        @Generated
        public void setProrationBehavior(String prorationBehavior) {
            this.prorationBehavior = prorationBehavior;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubscriptionDataOverride)) {
                return false;
            }
            SubscriptionDataOverride other = (SubscriptionDataOverride)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AppliesTo this$appliesTo = this.getAppliesTo();
            AppliesTo other$appliesTo = other.getAppliesTo();
            if (this$appliesTo == null ? other$appliesTo != null : !((Object)this$appliesTo).equals(other$appliesTo)) {
                return false;
            }
            BillOnAcceptance this$billOnAcceptance = this.getBillOnAcceptance();
            BillOnAcceptance other$billOnAcceptance = other.getBillOnAcceptance();
            if (this$billOnAcceptance == null ? other$billOnAcceptance != null : !((Object)this$billOnAcceptance).equals(other$billOnAcceptance)) {
                return false;
            }
            String this$billingBehavior = this.getBillingBehavior();
            String other$billingBehavior = other.getBillingBehavior();
            if (this$billingBehavior == null ? other$billingBehavior != null : !this$billingBehavior.equals(other$billingBehavior)) {
                return false;
            }
            String this$customer = this.getCustomer();
            String other$customer = other.getCustomer();
            if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$endBehavior = this.getEndBehavior();
            String other$endBehavior = other.getEndBehavior();
            if (this$endBehavior == null ? other$endBehavior != null : !this$endBehavior.equals(other$endBehavior)) {
                return false;
            }
            String this$prorationBehavior = this.getProrationBehavior();
            String other$prorationBehavior = other.getProrationBehavior();
            return !(this$prorationBehavior == null ? other$prorationBehavior != null : !this$prorationBehavior.equals(other$prorationBehavior));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SubscriptionDataOverride;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AppliesTo $appliesTo = this.getAppliesTo();
            result = result * 59 + ($appliesTo == null ? 43 : ((Object)$appliesTo).hashCode());
            BillOnAcceptance $billOnAcceptance = this.getBillOnAcceptance();
            result = result * 59 + ($billOnAcceptance == null ? 43 : ((Object)$billOnAcceptance).hashCode());
            String $billingBehavior = this.getBillingBehavior();
            result = result * 59 + ($billingBehavior == null ? 43 : $billingBehavior.hashCode());
            String $customer = this.getCustomer();
            result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $endBehavior = this.getEndBehavior();
            result = result * 59 + ($endBehavior == null ? 43 : $endBehavior.hashCode());
            String $prorationBehavior = this.getProrationBehavior();
            result = result * 59 + ($prorationBehavior == null ? 43 : $prorationBehavior.hashCode());
            return result;
        }

        public static class AppliesTo
        extends StripeObject {
            @SerializedName(value="new_reference")
            String newReference;
            @SerializedName(value="subscription_schedule")
            String subscriptionSchedule;
            @SerializedName(value="type")
            String type;

            @Generated
            public String getNewReference() {
                return this.newReference;
            }

            @Generated
            public String getSubscriptionSchedule() {
                return this.subscriptionSchedule;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setNewReference(String newReference) {
                this.newReference = newReference;
            }

            @Generated
            public void setSubscriptionSchedule(String subscriptionSchedule) {
                this.subscriptionSchedule = subscriptionSchedule;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AppliesTo)) {
                    return false;
                }
                AppliesTo other = (AppliesTo)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$newReference = this.getNewReference();
                String other$newReference = other.getNewReference();
                if (this$newReference == null ? other$newReference != null : !this$newReference.equals(other$newReference)) {
                    return false;
                }
                String this$subscriptionSchedule = this.getSubscriptionSchedule();
                String other$subscriptionSchedule = other.getSubscriptionSchedule();
                if (this$subscriptionSchedule == null ? other$subscriptionSchedule != null : !this$subscriptionSchedule.equals(other$subscriptionSchedule)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AppliesTo;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $newReference = this.getNewReference();
                result = result * 59 + ($newReference == null ? 43 : $newReference.hashCode());
                String $subscriptionSchedule = this.getSubscriptionSchedule();
                result = result * 59 + ($subscriptionSchedule == null ? 43 : $subscriptionSchedule.hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class BillOnAcceptance
        extends StripeObject {
            @SerializedName(value="bill_from")
            BillFrom billFrom;
            @SerializedName(value="bill_until")
            BillUntil billUntil;

            @Generated
            public BillFrom getBillFrom() {
                return this.billFrom;
            }

            @Generated
            public BillUntil getBillUntil() {
                return this.billUntil;
            }

            @Generated
            public void setBillFrom(BillFrom billFrom) {
                this.billFrom = billFrom;
            }

            @Generated
            public void setBillUntil(BillUntil billUntil) {
                this.billUntil = billUntil;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BillOnAcceptance)) {
                    return false;
                }
                BillOnAcceptance other = (BillOnAcceptance)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                BillFrom this$billFrom = this.getBillFrom();
                BillFrom other$billFrom = other.getBillFrom();
                if (this$billFrom == null ? other$billFrom != null : !((Object)this$billFrom).equals(other$billFrom)) {
                    return false;
                }
                BillUntil this$billUntil = this.getBillUntil();
                BillUntil other$billUntil = other.getBillUntil();
                return !(this$billUntil == null ? other$billUntil != null : !((Object)this$billUntil).equals(other$billUntil));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof BillOnAcceptance;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                BillFrom $billFrom = this.getBillFrom();
                result = result * 59 + ($billFrom == null ? 43 : ((Object)$billFrom).hashCode());
                BillUntil $billUntil = this.getBillUntil();
                result = result * 59 + ($billUntil == null ? 43 : ((Object)$billUntil).hashCode());
                return result;
            }

            public static class BillFrom
            extends StripeObject {
                @SerializedName(value="computed")
                Long computed;
                @SerializedName(value="line_starts_at")
                LineStartsAt lineStartsAt;
                @SerializedName(value="timestamp")
                Long timestamp;
                @SerializedName(value="type")
                String type;

                @Generated
                public Long getComputed() {
                    return this.computed;
                }

                @Generated
                public LineStartsAt getLineStartsAt() {
                    return this.lineStartsAt;
                }

                @Generated
                public Long getTimestamp() {
                    return this.timestamp;
                }

                @Generated
                public String getType() {
                    return this.type;
                }

                @Generated
                public void setComputed(Long computed) {
                    this.computed = computed;
                }

                @Generated
                public void setLineStartsAt(LineStartsAt lineStartsAt) {
                    this.lineStartsAt = lineStartsAt;
                }

                @Generated
                public void setTimestamp(Long timestamp) {
                    this.timestamp = timestamp;
                }

                @Generated
                public void setType(String type) {
                    this.type = type;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof BillFrom)) {
                        return false;
                    }
                    BillFrom other = (BillFrom)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$computed = this.getComputed();
                    Long other$computed = other.getComputed();
                    if (this$computed == null ? other$computed != null : !((Object)this$computed).equals(other$computed)) {
                        return false;
                    }
                    Long this$timestamp = this.getTimestamp();
                    Long other$timestamp = other.getTimestamp();
                    if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
                        return false;
                    }
                    LineStartsAt this$lineStartsAt = this.getLineStartsAt();
                    LineStartsAt other$lineStartsAt = other.getLineStartsAt();
                    if (this$lineStartsAt == null ? other$lineStartsAt != null : !((Object)this$lineStartsAt).equals(other$lineStartsAt)) {
                        return false;
                    }
                    String this$type = this.getType();
                    String other$type = other.getType();
                    return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof BillFrom;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $computed = this.getComputed();
                    result = result * 59 + ($computed == null ? 43 : ((Object)$computed).hashCode());
                    Long $timestamp = this.getTimestamp();
                    result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
                    LineStartsAt $lineStartsAt = this.getLineStartsAt();
                    result = result * 59 + ($lineStartsAt == null ? 43 : ((Object)$lineStartsAt).hashCode());
                    String $type = this.getType();
                    result = result * 59 + ($type == null ? 43 : $type.hashCode());
                    return result;
                }

                public static class LineStartsAt
                extends StripeObject
                implements HasId {
                    @SerializedName(value="id")
                    String id;

                    @Generated
                    public void setId(String id) {
                        this.id = id;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof LineStartsAt)) {
                            return false;
                        }
                        LineStartsAt other = (LineStartsAt)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$id = this.getId();
                        String other$id = other.getId();
                        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof LineStartsAt;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $id = this.getId();
                        result = result * 59 + ($id == null ? 43 : $id.hashCode());
                        return result;
                    }

                    @Override
                    @Generated
                    public String getId() {
                        return this.id;
                    }
                }
            }

            public static class BillUntil
            extends StripeObject {
                @SerializedName(value="computed")
                Long computed;
                @SerializedName(value="duration")
                Duration duration;
                @SerializedName(value="line_ends_at")
                LineEndsAt lineEndsAt;
                @SerializedName(value="timestamp")
                Long timestamp;
                @SerializedName(value="type")
                String type;

                @Generated
                public Long getComputed() {
                    return this.computed;
                }

                @Generated
                public Duration getDuration() {
                    return this.duration;
                }

                @Generated
                public LineEndsAt getLineEndsAt() {
                    return this.lineEndsAt;
                }

                @Generated
                public Long getTimestamp() {
                    return this.timestamp;
                }

                @Generated
                public String getType() {
                    return this.type;
                }

                @Generated
                public void setComputed(Long computed) {
                    this.computed = computed;
                }

                @Generated
                public void setDuration(Duration duration) {
                    this.duration = duration;
                }

                @Generated
                public void setLineEndsAt(LineEndsAt lineEndsAt) {
                    this.lineEndsAt = lineEndsAt;
                }

                @Generated
                public void setTimestamp(Long timestamp) {
                    this.timestamp = timestamp;
                }

                @Generated
                public void setType(String type) {
                    this.type = type;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof BillUntil)) {
                        return false;
                    }
                    BillUntil other = (BillUntil)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$computed = this.getComputed();
                    Long other$computed = other.getComputed();
                    if (this$computed == null ? other$computed != null : !((Object)this$computed).equals(other$computed)) {
                        return false;
                    }
                    Long this$timestamp = this.getTimestamp();
                    Long other$timestamp = other.getTimestamp();
                    if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
                        return false;
                    }
                    Duration this$duration = this.getDuration();
                    Duration other$duration = other.getDuration();
                    if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
                        return false;
                    }
                    LineEndsAt this$lineEndsAt = this.getLineEndsAt();
                    LineEndsAt other$lineEndsAt = other.getLineEndsAt();
                    if (this$lineEndsAt == null ? other$lineEndsAt != null : !((Object)this$lineEndsAt).equals(other$lineEndsAt)) {
                        return false;
                    }
                    String this$type = this.getType();
                    String other$type = other.getType();
                    return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof BillUntil;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $computed = this.getComputed();
                    result = result * 59 + ($computed == null ? 43 : ((Object)$computed).hashCode());
                    Long $timestamp = this.getTimestamp();
                    result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
                    Duration $duration = this.getDuration();
                    result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
                    LineEndsAt $lineEndsAt = this.getLineEndsAt();
                    result = result * 59 + ($lineEndsAt == null ? 43 : ((Object)$lineEndsAt).hashCode());
                    String $type = this.getType();
                    result = result * 59 + ($type == null ? 43 : $type.hashCode());
                    return result;
                }

                public static class Duration
                extends StripeObject {
                    @SerializedName(value="interval")
                    String interval;
                    @SerializedName(value="interval_count")
                    Long intervalCount;

                    @Generated
                    public String getInterval() {
                        return this.interval;
                    }

                    @Generated
                    public Long getIntervalCount() {
                        return this.intervalCount;
                    }

                    @Generated
                    public void setInterval(String interval) {
                        this.interval = interval;
                    }

                    @Generated
                    public void setIntervalCount(Long intervalCount) {
                        this.intervalCount = intervalCount;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Duration)) {
                            return false;
                        }
                        Duration other = (Duration)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Long this$intervalCount = this.getIntervalCount();
                        Long other$intervalCount = other.getIntervalCount();
                        if (this$intervalCount == null ? other$intervalCount != null : !((Object)this$intervalCount).equals(other$intervalCount)) {
                            return false;
                        }
                        String this$interval = this.getInterval();
                        String other$interval = other.getInterval();
                        return !(this$interval == null ? other$interval != null : !this$interval.equals(other$interval));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Duration;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Long $intervalCount = this.getIntervalCount();
                        result = result * 59 + ($intervalCount == null ? 43 : ((Object)$intervalCount).hashCode());
                        String $interval = this.getInterval();
                        result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
                        return result;
                    }
                }

                public static class LineEndsAt
                extends StripeObject
                implements HasId {
                    @SerializedName(value="id")
                    String id;

                    @Generated
                    public void setId(String id) {
                        this.id = id;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof LineEndsAt)) {
                            return false;
                        }
                        LineEndsAt other = (LineEndsAt)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$id = this.getId();
                        String other$id = other.getId();
                        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof LineEndsAt;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $id = this.getId();
                        result = result * 59 + ($id == null ? 43 : $id.hashCode());
                        return result;
                    }

                    @Override
                    @Generated
                    public String getId() {
                        return this.id;
                    }
                }
            }
        }
    }
}

