/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.treasury;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.treasury.DebitReversalCollection;
import com.stripe.model.treasury.Transaction;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.treasury.DebitReversalCreateParams;
import com.stripe.param.treasury.DebitReversalListParams;
import com.stripe.param.treasury.DebitReversalRetrieveParams;
import java.util.Map;
import lombok.Generated;

public class DebitReversal
extends ApiResource
implements HasId {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="financial_account")
    String financialAccount;
    @SerializedName(value="hosted_regulatory_receipt_url")
    String hostedRegulatoryReceiptUrl;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="linked_flows")
    LinkedFlows linkedFlows;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="network")
    String network;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="received_debit")
    String receivedDebit;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="status_transitions")
    StatusTransitions statusTransitions;
    @SerializedName(value="transaction")
    ExpandableField<Transaction> transaction;

    public String getTransaction() {
        return this.transaction != null ? this.transaction.getId() : null;
    }

    public void setTransaction(String id) {
        this.transaction = ApiResource.setExpandableFieldId(id, this.transaction);
    }

    public Transaction getTransactionObject() {
        return this.transaction != null ? this.transaction.getExpanded() : null;
    }

    public void setTransactionObject(Transaction expandableObject) {
        this.transaction = new ExpandableField<Transaction>(expandableObject.getId(), expandableObject);
    }

    public static DebitReversal create(Map<String, Object> params) throws StripeException {
        return DebitReversal.create(params, (RequestOptions)null);
    }

    public static DebitReversal create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/treasury/debit_reversals");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, DebitReversal.class, options);
    }

    public static DebitReversal create(DebitReversalCreateParams params) throws StripeException {
        return DebitReversal.create(params, (RequestOptions)null);
    }

    public static DebitReversal create(DebitReversalCreateParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/treasury/debit_reversals");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, DebitReversal.class, options);
    }

    public static DebitReversalCollection list(Map<String, Object> params) throws StripeException {
        return DebitReversal.list(params, (RequestOptions)null);
    }

    public static DebitReversalCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/treasury/debit_reversals");
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, DebitReversalCollection.class, options);
    }

    public static DebitReversalCollection list(DebitReversalListParams params) throws StripeException {
        return DebitReversal.list(params, (RequestOptions)null);
    }

    public static DebitReversalCollection list(DebitReversalListParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/treasury/debit_reversals");
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, DebitReversalCollection.class, options);
    }

    public static DebitReversal retrieve(String debitReversal) throws StripeException {
        return DebitReversal.retrieve(debitReversal, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static DebitReversal retrieve(String debitReversal, RequestOptions options) throws StripeException {
        return DebitReversal.retrieve(debitReversal, (Map<String, Object>)null, options);
    }

    public static DebitReversal retrieve(String debitReversal, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/treasury/debit_reversals/%s", ApiResource.urlEncodeId(debitReversal)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, DebitReversal.class, options);
    }

    public static DebitReversal retrieve(String debitReversal, DebitReversalRetrieveParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/treasury/debit_reversals/%s", ApiResource.urlEncodeId(debitReversal)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, DebitReversal.class, options);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getFinancialAccount() {
        return this.financialAccount;
    }

    @Generated
    public String getHostedRegulatoryReceiptUrl() {
        return this.hostedRegulatoryReceiptUrl;
    }

    @Generated
    public LinkedFlows getLinkedFlows() {
        return this.linkedFlows;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public String getNetwork() {
        return this.network;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getReceivedDebit() {
        return this.receivedDebit;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public StatusTransitions getStatusTransitions() {
        return this.statusTransitions;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setFinancialAccount(String financialAccount) {
        this.financialAccount = financialAccount;
    }

    @Generated
    public void setHostedRegulatoryReceiptUrl(String hostedRegulatoryReceiptUrl) {
        this.hostedRegulatoryReceiptUrl = hostedRegulatoryReceiptUrl;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLinkedFlows(LinkedFlows linkedFlows) {
        this.linkedFlows = linkedFlows;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setNetwork(String network) {
        this.network = network;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setReceivedDebit(String receivedDebit) {
        this.receivedDebit = receivedDebit;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setStatusTransitions(StatusTransitions statusTransitions) {
        this.statusTransitions = statusTransitions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebitReversal)) {
            return false;
        }
        DebitReversal other = (DebitReversal)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$financialAccount = this.getFinancialAccount();
        String other$financialAccount = other.getFinancialAccount();
        if (this$financialAccount == null ? other$financialAccount != null : !this$financialAccount.equals(other$financialAccount)) {
            return false;
        }
        String this$hostedRegulatoryReceiptUrl = this.getHostedRegulatoryReceiptUrl();
        String other$hostedRegulatoryReceiptUrl = other.getHostedRegulatoryReceiptUrl();
        if (this$hostedRegulatoryReceiptUrl == null ? other$hostedRegulatoryReceiptUrl != null : !this$hostedRegulatoryReceiptUrl.equals(other$hostedRegulatoryReceiptUrl)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        LinkedFlows this$linkedFlows = this.getLinkedFlows();
        LinkedFlows other$linkedFlows = other.getLinkedFlows();
        if (this$linkedFlows == null ? other$linkedFlows != null : !((Object)this$linkedFlows).equals(other$linkedFlows)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$network = this.getNetwork();
        String other$network = other.getNetwork();
        if (this$network == null ? other$network != null : !this$network.equals(other$network)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$receivedDebit = this.getReceivedDebit();
        String other$receivedDebit = other.getReceivedDebit();
        if (this$receivedDebit == null ? other$receivedDebit != null : !this$receivedDebit.equals(other$receivedDebit)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        StatusTransitions this$statusTransitions = this.getStatusTransitions();
        StatusTransitions other$statusTransitions = other.getStatusTransitions();
        if (this$statusTransitions == null ? other$statusTransitions != null : !((Object)this$statusTransitions).equals(other$statusTransitions)) {
            return false;
        }
        String this$transaction = this.getTransaction();
        String other$transaction = other.getTransaction();
        return !(this$transaction == null ? other$transaction != null : !this$transaction.equals(other$transaction));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DebitReversal;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $financialAccount = this.getFinancialAccount();
        result = result * 59 + ($financialAccount == null ? 43 : $financialAccount.hashCode());
        String $hostedRegulatoryReceiptUrl = this.getHostedRegulatoryReceiptUrl();
        result = result * 59 + ($hostedRegulatoryReceiptUrl == null ? 43 : $hostedRegulatoryReceiptUrl.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        LinkedFlows $linkedFlows = this.getLinkedFlows();
        result = result * 59 + ($linkedFlows == null ? 43 : ((Object)$linkedFlows).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $network = this.getNetwork();
        result = result * 59 + ($network == null ? 43 : $network.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $receivedDebit = this.getReceivedDebit();
        result = result * 59 + ($receivedDebit == null ? 43 : $receivedDebit.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        StatusTransitions $statusTransitions = this.getStatusTransitions();
        result = result * 59 + ($statusTransitions == null ? 43 : ((Object)$statusTransitions).hashCode());
        String $transaction = this.getTransaction();
        result = result * 59 + ($transaction == null ? 43 : $transaction.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class LinkedFlows
    extends StripeObject {
        @SerializedName(value="issuing_dispute")
        String issuingDispute;

        @Generated
        public String getIssuingDispute() {
            return this.issuingDispute;
        }

        @Generated
        public void setIssuingDispute(String issuingDispute) {
            this.issuingDispute = issuingDispute;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LinkedFlows)) {
                return false;
            }
            LinkedFlows other = (LinkedFlows)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$issuingDispute = this.getIssuingDispute();
            String other$issuingDispute = other.getIssuingDispute();
            return !(this$issuingDispute == null ? other$issuingDispute != null : !this$issuingDispute.equals(other$issuingDispute));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LinkedFlows;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $issuingDispute = this.getIssuingDispute();
            result = result * 59 + ($issuingDispute == null ? 43 : $issuingDispute.hashCode());
            return result;
        }
    }

    public static class StatusTransitions
    extends StripeObject {
        @SerializedName(value="completed_at")
        Long completedAt;

        @Generated
        public Long getCompletedAt() {
            return this.completedAt;
        }

        @Generated
        public void setCompletedAt(Long completedAt) {
            this.completedAt = completedAt;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatusTransitions)) {
                return false;
            }
            StatusTransitions other = (StatusTransitions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$completedAt = this.getCompletedAt();
            Long other$completedAt = other.getCompletedAt();
            return !(this$completedAt == null ? other$completedAt != null : !((Object)this$completedAt).equals(other$completedAt));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof StatusTransitions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $completedAt = this.getCompletedAt();
            result = result * 59 + ($completedAt == null ? 43 : ((Object)$completedAt).hashCode());
            return result;
        }
    }
}

