/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.financialconnections;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.financialconnections.InferredBalanceCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.financialconnections.InferredBalanceListParams;
import java.util.Map;
import lombok.Generated;

public class InferredBalance
extends ApiResource
implements HasId {
    @SerializedName(value="as_of")
    Long asOf;
    @SerializedName(value="current")
    Map<String, Long> current;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="object")
    String object;

    public static InferredBalanceCollection list(String account, Map<String, Object> params) throws StripeException {
        return InferredBalance.list(account, params, (RequestOptions)null);
    }

    public static InferredBalanceCollection list(String account, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/financial_connections/accounts/%s/inferred_balances", ApiResource.urlEncodeId(account)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, InferredBalanceCollection.class, options);
    }

    public static InferredBalanceCollection list(String account, InferredBalanceListParams params) throws StripeException {
        return InferredBalance.list(account, params, (RequestOptions)null);
    }

    public static InferredBalanceCollection list(String account, InferredBalanceListParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/financial_connections/accounts/%s/inferred_balances", ApiResource.urlEncodeId(account)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, InferredBalanceCollection.class, options);
    }

    @Generated
    public Long getAsOf() {
        return this.asOf;
    }

    @Generated
    public Map<String, Long> getCurrent() {
        return this.current;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public void setAsOf(Long asOf) {
        this.asOf = asOf;
    }

    @Generated
    public void setCurrent(Map<String, Long> current) {
        this.current = current;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InferredBalance)) {
            return false;
        }
        InferredBalance other = (InferredBalance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$asOf = this.getAsOf();
        Long other$asOf = other.getAsOf();
        if (this$asOf == null ? other$asOf != null : !((Object)this$asOf).equals(other$asOf)) {
            return false;
        }
        Map<String, Long> this$current = this.getCurrent();
        Map<String, Long> other$current = other.getCurrent();
        if (this$current == null ? other$current != null : !((Object)this$current).equals(other$current)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InferredBalance;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $asOf = this.getAsOf();
        result = result * 59 + ($asOf == null ? 43 : ((Object)$asOf).hashCode());
        Map<String, Long> $current = this.getCurrent();
        result = result * 59 + ($current == null ? 43 : ((Object)$current).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }
}

