/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.tax;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.tax.CalculationLineItemCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.tax.CalculationCreateParams;
import com.stripe.param.tax.CalculationListLineItemsParams;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Calculation
extends ApiResource
implements HasId {
    @SerializedName(value="amount_total")
    Long amountTotal;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="customer")
    String customer;
    @SerializedName(value="customer_details")
    CustomerDetails customerDetails;
    @SerializedName(value="expires_at")
    Long expiresAt;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="line_items")
    CalculationLineItemCollection lineItems;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="shipping_cost")
    ShippingCost shippingCost;
    @SerializedName(value="tax_amount_exclusive")
    Long taxAmountExclusive;
    @SerializedName(value="tax_amount_inclusive")
    Long taxAmountInclusive;
    @SerializedName(value="tax_breakdown")
    List<TaxBreakdown> taxBreakdown;
    @SerializedName(value="tax_date")
    Long taxDate;

    public static Calculation create(Map<String, Object> params) throws StripeException {
        return Calculation.create(params, (RequestOptions)null);
    }

    public static Calculation create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/tax/calculations");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Calculation.class, options);
    }

    public static Calculation create(CalculationCreateParams params) throws StripeException {
        return Calculation.create(params, (RequestOptions)null);
    }

    public static Calculation create(CalculationCreateParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/tax/calculations");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Calculation.class, options);
    }

    public CalculationLineItemCollection listLineItems() throws StripeException {
        return this.listLineItems((Map<String, Object>)null, (RequestOptions)null);
    }

    public CalculationLineItemCollection listLineItems(Map<String, Object> params) throws StripeException {
        return this.listLineItems(params, (RequestOptions)null);
    }

    public CalculationLineItemCollection listLineItems(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/tax/calculations/%s/line_items", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, CalculationLineItemCollection.class, options);
    }

    public CalculationLineItemCollection listLineItems(CalculationListLineItemsParams params) throws StripeException {
        return this.listLineItems(params, (RequestOptions)null);
    }

    public CalculationLineItemCollection listLineItems(CalculationListLineItemsParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/tax/calculations/%s/line_items", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, CalculationLineItemCollection.class, options);
    }

    @Generated
    public Long getAmountTotal() {
        return this.amountTotal;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getCustomer() {
        return this.customer;
    }

    @Generated
    public CustomerDetails getCustomerDetails() {
        return this.customerDetails;
    }

    @Generated
    public Long getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public CalculationLineItemCollection getLineItems() {
        return this.lineItems;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public ShippingCost getShippingCost() {
        return this.shippingCost;
    }

    @Generated
    public Long getTaxAmountExclusive() {
        return this.taxAmountExclusive;
    }

    @Generated
    public Long getTaxAmountInclusive() {
        return this.taxAmountInclusive;
    }

    @Generated
    public List<TaxBreakdown> getTaxBreakdown() {
        return this.taxBreakdown;
    }

    @Generated
    public Long getTaxDate() {
        return this.taxDate;
    }

    @Generated
    public void setAmountTotal(Long amountTotal) {
        this.amountTotal = amountTotal;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setCustomer(String customer) {
        this.customer = customer;
    }

    @Generated
    public void setCustomerDetails(CustomerDetails customerDetails) {
        this.customerDetails = customerDetails;
    }

    @Generated
    public void setExpiresAt(Long expiresAt) {
        this.expiresAt = expiresAt;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLineItems(CalculationLineItemCollection lineItems) {
        this.lineItems = lineItems;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setShippingCost(ShippingCost shippingCost) {
        this.shippingCost = shippingCost;
    }

    @Generated
    public void setTaxAmountExclusive(Long taxAmountExclusive) {
        this.taxAmountExclusive = taxAmountExclusive;
    }

    @Generated
    public void setTaxAmountInclusive(Long taxAmountInclusive) {
        this.taxAmountInclusive = taxAmountInclusive;
    }

    @Generated
    public void setTaxBreakdown(List<TaxBreakdown> taxBreakdown) {
        this.taxBreakdown = taxBreakdown;
    }

    @Generated
    public void setTaxDate(Long taxDate) {
        this.taxDate = taxDate;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Calculation)) {
            return false;
        }
        Calculation other = (Calculation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amountTotal = this.getAmountTotal();
        Long other$amountTotal = other.getAmountTotal();
        if (this$amountTotal == null ? other$amountTotal != null : !((Object)this$amountTotal).equals(other$amountTotal)) {
            return false;
        }
        Long this$expiresAt = this.getExpiresAt();
        Long other$expiresAt = other.getExpiresAt();
        if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$taxAmountExclusive = this.getTaxAmountExclusive();
        Long other$taxAmountExclusive = other.getTaxAmountExclusive();
        if (this$taxAmountExclusive == null ? other$taxAmountExclusive != null : !((Object)this$taxAmountExclusive).equals(other$taxAmountExclusive)) {
            return false;
        }
        Long this$taxAmountInclusive = this.getTaxAmountInclusive();
        Long other$taxAmountInclusive = other.getTaxAmountInclusive();
        if (this$taxAmountInclusive == null ? other$taxAmountInclusive != null : !((Object)this$taxAmountInclusive).equals(other$taxAmountInclusive)) {
            return false;
        }
        Long this$taxDate = this.getTaxDate();
        Long other$taxDate = other.getTaxDate();
        if (this$taxDate == null ? other$taxDate != null : !((Object)this$taxDate).equals(other$taxDate)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        CustomerDetails this$customerDetails = this.getCustomerDetails();
        CustomerDetails other$customerDetails = other.getCustomerDetails();
        if (this$customerDetails == null ? other$customerDetails != null : !((Object)this$customerDetails).equals(other$customerDetails)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        CalculationLineItemCollection this$lineItems = this.getLineItems();
        CalculationLineItemCollection other$lineItems = other.getLineItems();
        if (this$lineItems == null ? other$lineItems != null : !((Object)this$lineItems).equals(other$lineItems)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        ShippingCost this$shippingCost = this.getShippingCost();
        ShippingCost other$shippingCost = other.getShippingCost();
        if (this$shippingCost == null ? other$shippingCost != null : !((Object)this$shippingCost).equals(other$shippingCost)) {
            return false;
        }
        List<TaxBreakdown> this$taxBreakdown = this.getTaxBreakdown();
        List<TaxBreakdown> other$taxBreakdown = other.getTaxBreakdown();
        return !(this$taxBreakdown == null ? other$taxBreakdown != null : !((Object)this$taxBreakdown).equals(other$taxBreakdown));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Calculation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amountTotal = this.getAmountTotal();
        result = result * 59 + ($amountTotal == null ? 43 : ((Object)$amountTotal).hashCode());
        Long $expiresAt = this.getExpiresAt();
        result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $taxAmountExclusive = this.getTaxAmountExclusive();
        result = result * 59 + ($taxAmountExclusive == null ? 43 : ((Object)$taxAmountExclusive).hashCode());
        Long $taxAmountInclusive = this.getTaxAmountInclusive();
        result = result * 59 + ($taxAmountInclusive == null ? 43 : ((Object)$taxAmountInclusive).hashCode());
        Long $taxDate = this.getTaxDate();
        result = result * 59 + ($taxDate == null ? 43 : ((Object)$taxDate).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        CustomerDetails $customerDetails = this.getCustomerDetails();
        result = result * 59 + ($customerDetails == null ? 43 : ((Object)$customerDetails).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        CalculationLineItemCollection $lineItems = this.getLineItems();
        result = result * 59 + ($lineItems == null ? 43 : ((Object)$lineItems).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        ShippingCost $shippingCost = this.getShippingCost();
        result = result * 59 + ($shippingCost == null ? 43 : ((Object)$shippingCost).hashCode());
        List<TaxBreakdown> $taxBreakdown = this.getTaxBreakdown();
        result = result * 59 + ($taxBreakdown == null ? 43 : ((Object)$taxBreakdown).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class CustomerDetails
    extends StripeObject {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="address_source")
        String addressSource;
        @SerializedName(value="ip_address")
        String ipAddress;
        @SerializedName(value="tax_ids")
        List<TaxId> taxIds;
        @SerializedName(value="taxability_override")
        String taxabilityOverride;

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public String getAddressSource() {
            return this.addressSource;
        }

        @Generated
        public String getIpAddress() {
            return this.ipAddress;
        }

        @Generated
        public List<TaxId> getTaxIds() {
            return this.taxIds;
        }

        @Generated
        public String getTaxabilityOverride() {
            return this.taxabilityOverride;
        }

        @Generated
        public void setAddress(Address address) {
            this.address = address;
        }

        @Generated
        public void setAddressSource(String addressSource) {
            this.addressSource = addressSource;
        }

        @Generated
        public void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Generated
        public void setTaxIds(List<TaxId> taxIds) {
            this.taxIds = taxIds;
        }

        @Generated
        public void setTaxabilityOverride(String taxabilityOverride) {
            this.taxabilityOverride = taxabilityOverride;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomerDetails)) {
                return false;
            }
            CustomerDetails other = (CustomerDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Address this$address = this.getAddress();
            Address other$address = other.getAddress();
            if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                return false;
            }
            String this$addressSource = this.getAddressSource();
            String other$addressSource = other.getAddressSource();
            if (this$addressSource == null ? other$addressSource != null : !this$addressSource.equals(other$addressSource)) {
                return false;
            }
            String this$ipAddress = this.getIpAddress();
            String other$ipAddress = other.getIpAddress();
            if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
                return false;
            }
            List<TaxId> this$taxIds = this.getTaxIds();
            List<TaxId> other$taxIds = other.getTaxIds();
            if (this$taxIds == null ? other$taxIds != null : !((Object)this$taxIds).equals(other$taxIds)) {
                return false;
            }
            String this$taxabilityOverride = this.getTaxabilityOverride();
            String other$taxabilityOverride = other.getTaxabilityOverride();
            return !(this$taxabilityOverride == null ? other$taxabilityOverride != null : !this$taxabilityOverride.equals(other$taxabilityOverride));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CustomerDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Address $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            String $addressSource = this.getAddressSource();
            result = result * 59 + ($addressSource == null ? 43 : $addressSource.hashCode());
            String $ipAddress = this.getIpAddress();
            result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
            List<TaxId> $taxIds = this.getTaxIds();
            result = result * 59 + ($taxIds == null ? 43 : ((Object)$taxIds).hashCode());
            String $taxabilityOverride = this.getTaxabilityOverride();
            result = result * 59 + ($taxabilityOverride == null ? 43 : $taxabilityOverride.hashCode());
            return result;
        }

        public static class Address
        extends StripeObject {
            @SerializedName(value="city")
            String city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="line1")
            String line1;
            @SerializedName(value="line2")
            String line2;
            @SerializedName(value="postal_code")
            String postalCode;
            @SerializedName(value="state")
            String state;

            @Generated
            public String getCity() {
                return this.city;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public String getLine1() {
                return this.line1;
            }

            @Generated
            public String getLine2() {
                return this.line2;
            }

            @Generated
            public String getPostalCode() {
                return this.postalCode;
            }

            @Generated
            public String getState() {
                return this.state;
            }

            @Generated
            public void setCity(String city) {
                this.city = city;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public void setLine1(String line1) {
                this.line1 = line1;
            }

            @Generated
            public void setLine2(String line2) {
                this.line2 = line2;
            }

            @Generated
            public void setPostalCode(String postalCode) {
                this.postalCode = postalCode;
            }

            @Generated
            public void setState(String state) {
                this.state = state;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Address)) {
                    return false;
                }
                Address other = (Address)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$city = this.getCity();
                String other$city = other.getCity();
                if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                String this$line1 = this.getLine1();
                String other$line1 = other.getLine1();
                if (this$line1 == null ? other$line1 != null : !this$line1.equals(other$line1)) {
                    return false;
                }
                String this$line2 = this.getLine2();
                String other$line2 = other.getLine2();
                if (this$line2 == null ? other$line2 != null : !this$line2.equals(other$line2)) {
                    return false;
                }
                String this$postalCode = this.getPostalCode();
                String other$postalCode = other.getPostalCode();
                if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) {
                    return false;
                }
                String this$state = this.getState();
                String other$state = other.getState();
                return !(this$state == null ? other$state != null : !this$state.equals(other$state));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Address;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $city = this.getCity();
                result = result * 59 + ($city == null ? 43 : $city.hashCode());
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                String $line1 = this.getLine1();
                result = result * 59 + ($line1 == null ? 43 : $line1.hashCode());
                String $line2 = this.getLine2();
                result = result * 59 + ($line2 == null ? 43 : $line2.hashCode());
                String $postalCode = this.getPostalCode();
                result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
                String $state = this.getState();
                result = result * 59 + ($state == null ? 43 : $state.hashCode());
                return result;
            }
        }

        public static class TaxId
        extends StripeObject {
            @SerializedName(value="type")
            String type;
            @SerializedName(value="value")
            String value;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TaxId)) {
                    return false;
                }
                TaxId other = (TaxId)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof TaxId;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class ShippingCost
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="amount_tax")
        Long amountTax;
        @SerializedName(value="shipping_rate")
        String shippingRate;
        @SerializedName(value="tax_behavior")
        String taxBehavior;
        @SerializedName(value="tax_code")
        String taxCode;

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public Long getAmountTax() {
            return this.amountTax;
        }

        @Generated
        public String getShippingRate() {
            return this.shippingRate;
        }

        @Generated
        public String getTaxBehavior() {
            return this.taxBehavior;
        }

        @Generated
        public String getTaxCode() {
            return this.taxCode;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public void setAmountTax(Long amountTax) {
            this.amountTax = amountTax;
        }

        @Generated
        public void setShippingRate(String shippingRate) {
            this.shippingRate = shippingRate;
        }

        @Generated
        public void setTaxBehavior(String taxBehavior) {
            this.taxBehavior = taxBehavior;
        }

        @Generated
        public void setTaxCode(String taxCode) {
            this.taxCode = taxCode;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShippingCost)) {
                return false;
            }
            ShippingCost other = (ShippingCost)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            Long this$amountTax = this.getAmountTax();
            Long other$amountTax = other.getAmountTax();
            if (this$amountTax == null ? other$amountTax != null : !((Object)this$amountTax).equals(other$amountTax)) {
                return false;
            }
            String this$shippingRate = this.getShippingRate();
            String other$shippingRate = other.getShippingRate();
            if (this$shippingRate == null ? other$shippingRate != null : !this$shippingRate.equals(other$shippingRate)) {
                return false;
            }
            String this$taxBehavior = this.getTaxBehavior();
            String other$taxBehavior = other.getTaxBehavior();
            if (this$taxBehavior == null ? other$taxBehavior != null : !this$taxBehavior.equals(other$taxBehavior)) {
                return false;
            }
            String this$taxCode = this.getTaxCode();
            String other$taxCode = other.getTaxCode();
            return !(this$taxCode == null ? other$taxCode != null : !this$taxCode.equals(other$taxCode));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ShippingCost;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            Long $amountTax = this.getAmountTax();
            result = result * 59 + ($amountTax == null ? 43 : ((Object)$amountTax).hashCode());
            String $shippingRate = this.getShippingRate();
            result = result * 59 + ($shippingRate == null ? 43 : $shippingRate.hashCode());
            String $taxBehavior = this.getTaxBehavior();
            result = result * 59 + ($taxBehavior == null ? 43 : $taxBehavior.hashCode());
            String $taxCode = this.getTaxCode();
            result = result * 59 + ($taxCode == null ? 43 : $taxCode.hashCode());
            return result;
        }
    }

    public static class TaxBreakdown
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="inclusive")
        Boolean inclusive;
        @SerializedName(value="tax_rate_details")
        TaxRateDetails taxRateDetails;
        @SerializedName(value="taxable_amount")
        Long taxableAmount;

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public Boolean getInclusive() {
            return this.inclusive;
        }

        @Generated
        public TaxRateDetails getTaxRateDetails() {
            return this.taxRateDetails;
        }

        @Generated
        public Long getTaxableAmount() {
            return this.taxableAmount;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public void setInclusive(Boolean inclusive) {
            this.inclusive = inclusive;
        }

        @Generated
        public void setTaxRateDetails(TaxRateDetails taxRateDetails) {
            this.taxRateDetails = taxRateDetails;
        }

        @Generated
        public void setTaxableAmount(Long taxableAmount) {
            this.taxableAmount = taxableAmount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaxBreakdown)) {
                return false;
            }
            TaxBreakdown other = (TaxBreakdown)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            Boolean this$inclusive = this.getInclusive();
            Boolean other$inclusive = other.getInclusive();
            if (this$inclusive == null ? other$inclusive != null : !((Object)this$inclusive).equals(other$inclusive)) {
                return false;
            }
            Long this$taxableAmount = this.getTaxableAmount();
            Long other$taxableAmount = other.getTaxableAmount();
            if (this$taxableAmount == null ? other$taxableAmount != null : !((Object)this$taxableAmount).equals(other$taxableAmount)) {
                return false;
            }
            TaxRateDetails this$taxRateDetails = this.getTaxRateDetails();
            TaxRateDetails other$taxRateDetails = other.getTaxRateDetails();
            return !(this$taxRateDetails == null ? other$taxRateDetails != null : !((Object)this$taxRateDetails).equals(other$taxRateDetails));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TaxBreakdown;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            Boolean $inclusive = this.getInclusive();
            result = result * 59 + ($inclusive == null ? 43 : ((Object)$inclusive).hashCode());
            Long $taxableAmount = this.getTaxableAmount();
            result = result * 59 + ($taxableAmount == null ? 43 : ((Object)$taxableAmount).hashCode());
            TaxRateDetails $taxRateDetails = this.getTaxRateDetails();
            result = result * 59 + ($taxRateDetails == null ? 43 : ((Object)$taxRateDetails).hashCode());
            return result;
        }

        public static class TaxRateDetails
        extends StripeObject {
            @SerializedName(value="country")
            String country;
            @SerializedName(value="percentage_decimal")
            String percentageDecimal;
            @SerializedName(value="state")
            String state;
            @SerializedName(value="tax_type")
            String taxType;

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public String getPercentageDecimal() {
                return this.percentageDecimal;
            }

            @Generated
            public String getState() {
                return this.state;
            }

            @Generated
            public String getTaxType() {
                return this.taxType;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public void setPercentageDecimal(String percentageDecimal) {
                this.percentageDecimal = percentageDecimal;
            }

            @Generated
            public void setState(String state) {
                this.state = state;
            }

            @Generated
            public void setTaxType(String taxType) {
                this.taxType = taxType;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TaxRateDetails)) {
                    return false;
                }
                TaxRateDetails other = (TaxRateDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                String this$percentageDecimal = this.getPercentageDecimal();
                String other$percentageDecimal = other.getPercentageDecimal();
                if (this$percentageDecimal == null ? other$percentageDecimal != null : !this$percentageDecimal.equals(other$percentageDecimal)) {
                    return false;
                }
                String this$state = this.getState();
                String other$state = other.getState();
                if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                    return false;
                }
                String this$taxType = this.getTaxType();
                String other$taxType = other.getTaxType();
                return !(this$taxType == null ? other$taxType != null : !this$taxType.equals(other$taxType));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof TaxRateDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                String $percentageDecimal = this.getPercentageDecimal();
                result = result * 59 + ($percentageDecimal == null ? 43 : $percentageDecimal.hashCode());
                String $state = this.getState();
                result = result * 59 + ($state == null ? 43 : $state.hashCode());
                String $taxType = this.getTaxType();
                result = result * 59 + ($taxType == null ? 43 : $taxType.hashCode());
                return result;
            }
        }
    }
}

