/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.tax;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.tax.TransactionLineItemCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.tax.TransactionCreateFromCalculationParams;
import com.stripe.param.tax.TransactionCreateReversalParams;
import com.stripe.param.tax.TransactionListLineItemsParams;
import com.stripe.param.tax.TransactionRetrieveParams;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Transaction
extends ApiResource
implements HasId {
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="customer")
    String customer;
    @SerializedName(value="customer_details")
    CustomerDetails customerDetails;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="line_items")
    TransactionLineItemCollection lineItems;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="reference")
    String reference;
    @SerializedName(value="reversal")
    Reversal reversal;
    @SerializedName(value="shipping_cost")
    ShippingCost shippingCost;
    @SerializedName(value="tax_date")
    Long taxDate;
    @SerializedName(value="type")
    String type;

    public static Transaction createFromCalculation(Map<String, Object> params) throws StripeException {
        return Transaction.createFromCalculation(params, (RequestOptions)null);
    }

    public static Transaction createFromCalculation(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/tax/transactions/create_from_calculation");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Transaction.class, options);
    }

    public static Transaction createFromCalculation(TransactionCreateFromCalculationParams params) throws StripeException {
        return Transaction.createFromCalculation(params, (RequestOptions)null);
    }

    public static Transaction createFromCalculation(TransactionCreateFromCalculationParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/tax/transactions/create_from_calculation");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Transaction.class, options);
    }

    public static Transaction createReversal(Map<String, Object> params) throws StripeException {
        return Transaction.createReversal(params, (RequestOptions)null);
    }

    public static Transaction createReversal(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/tax/transactions/create_reversal");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Transaction.class, options);
    }

    public static Transaction createReversal(TransactionCreateReversalParams params) throws StripeException {
        return Transaction.createReversal(params, (RequestOptions)null);
    }

    public static Transaction createReversal(TransactionCreateReversalParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/tax/transactions/create_reversal");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Transaction.class, options);
    }

    public TransactionLineItemCollection listLineItems() throws StripeException {
        return this.listLineItems((Map<String, Object>)null, (RequestOptions)null);
    }

    public TransactionLineItemCollection listLineItems(Map<String, Object> params) throws StripeException {
        return this.listLineItems(params, (RequestOptions)null);
    }

    public TransactionLineItemCollection listLineItems(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/tax/transactions/%s/line_items", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.requestCollection(url, params, TransactionLineItemCollection.class, options);
    }

    public TransactionLineItemCollection listLineItems(TransactionListLineItemsParams params) throws StripeException {
        return this.listLineItems(params, (RequestOptions)null);
    }

    public TransactionLineItemCollection listLineItems(TransactionListLineItemsParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/tax/transactions/%s/line_items", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.requestCollection(url, params, TransactionLineItemCollection.class, options);
    }

    public static Transaction retrieve(String transaction) throws StripeException {
        return Transaction.retrieve(transaction, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Transaction retrieve(String transaction, RequestOptions options) throws StripeException {
        return Transaction.retrieve(transaction, (Map<String, Object>)null, options);
    }

    public static Transaction retrieve(String transaction, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/tax/transactions/%s", ApiResource.urlEncodeId(transaction)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Transaction.class, options);
    }

    public static Transaction retrieve(String transaction, TransactionRetrieveParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/tax/transactions/%s", ApiResource.urlEncodeId(transaction)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Transaction.class, options);
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getCustomer() {
        return this.customer;
    }

    @Generated
    public CustomerDetails getCustomerDetails() {
        return this.customerDetails;
    }

    @Generated
    public TransactionLineItemCollection getLineItems() {
        return this.lineItems;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getReference() {
        return this.reference;
    }

    @Generated
    public Reversal getReversal() {
        return this.reversal;
    }

    @Generated
    public ShippingCost getShippingCost() {
        return this.shippingCost;
    }

    @Generated
    public Long getTaxDate() {
        return this.taxDate;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setCustomer(String customer) {
        this.customer = customer;
    }

    @Generated
    public void setCustomerDetails(CustomerDetails customerDetails) {
        this.customerDetails = customerDetails;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLineItems(TransactionLineItemCollection lineItems) {
        this.lineItems = lineItems;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setReference(String reference) {
        this.reference = reference;
    }

    @Generated
    public void setReversal(Reversal reversal) {
        this.reversal = reversal;
    }

    @Generated
    public void setShippingCost(ShippingCost shippingCost) {
        this.shippingCost = shippingCost;
    }

    @Generated
    public void setTaxDate(Long taxDate) {
        this.taxDate = taxDate;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transaction)) {
            return false;
        }
        Transaction other = (Transaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$taxDate = this.getTaxDate();
        Long other$taxDate = other.getTaxDate();
        if (this$taxDate == null ? other$taxDate != null : !((Object)this$taxDate).equals(other$taxDate)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        CustomerDetails this$customerDetails = this.getCustomerDetails();
        CustomerDetails other$customerDetails = other.getCustomerDetails();
        if (this$customerDetails == null ? other$customerDetails != null : !((Object)this$customerDetails).equals(other$customerDetails)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        TransactionLineItemCollection this$lineItems = this.getLineItems();
        TransactionLineItemCollection other$lineItems = other.getLineItems();
        if (this$lineItems == null ? other$lineItems != null : !((Object)this$lineItems).equals(other$lineItems)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$reference = this.getReference();
        String other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
            return false;
        }
        Reversal this$reversal = this.getReversal();
        Reversal other$reversal = other.getReversal();
        if (this$reversal == null ? other$reversal != null : !((Object)this$reversal).equals(other$reversal)) {
            return false;
        }
        ShippingCost this$shippingCost = this.getShippingCost();
        ShippingCost other$shippingCost = other.getShippingCost();
        if (this$shippingCost == null ? other$shippingCost != null : !((Object)this$shippingCost).equals(other$shippingCost)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Transaction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $taxDate = this.getTaxDate();
        result = result * 59 + ($taxDate == null ? 43 : ((Object)$taxDate).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        CustomerDetails $customerDetails = this.getCustomerDetails();
        result = result * 59 + ($customerDetails == null ? 43 : ((Object)$customerDetails).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        TransactionLineItemCollection $lineItems = this.getLineItems();
        result = result * 59 + ($lineItems == null ? 43 : ((Object)$lineItems).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $reference = this.getReference();
        result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
        Reversal $reversal = this.getReversal();
        result = result * 59 + ($reversal == null ? 43 : ((Object)$reversal).hashCode());
        ShippingCost $shippingCost = this.getShippingCost();
        result = result * 59 + ($shippingCost == null ? 43 : ((Object)$shippingCost).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class CustomerDetails
    extends StripeObject {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="address_source")
        String addressSource;
        @SerializedName(value="ip_address")
        String ipAddress;
        @SerializedName(value="tax_ids")
        List<TaxId> taxIds;
        @SerializedName(value="taxability_override")
        String taxabilityOverride;

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public String getAddressSource() {
            return this.addressSource;
        }

        @Generated
        public String getIpAddress() {
            return this.ipAddress;
        }

        @Generated
        public List<TaxId> getTaxIds() {
            return this.taxIds;
        }

        @Generated
        public String getTaxabilityOverride() {
            return this.taxabilityOverride;
        }

        @Generated
        public void setAddress(Address address) {
            this.address = address;
        }

        @Generated
        public void setAddressSource(String addressSource) {
            this.addressSource = addressSource;
        }

        @Generated
        public void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Generated
        public void setTaxIds(List<TaxId> taxIds) {
            this.taxIds = taxIds;
        }

        @Generated
        public void setTaxabilityOverride(String taxabilityOverride) {
            this.taxabilityOverride = taxabilityOverride;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomerDetails)) {
                return false;
            }
            CustomerDetails other = (CustomerDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Address this$address = this.getAddress();
            Address other$address = other.getAddress();
            if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                return false;
            }
            String this$addressSource = this.getAddressSource();
            String other$addressSource = other.getAddressSource();
            if (this$addressSource == null ? other$addressSource != null : !this$addressSource.equals(other$addressSource)) {
                return false;
            }
            String this$ipAddress = this.getIpAddress();
            String other$ipAddress = other.getIpAddress();
            if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
                return false;
            }
            List<TaxId> this$taxIds = this.getTaxIds();
            List<TaxId> other$taxIds = other.getTaxIds();
            if (this$taxIds == null ? other$taxIds != null : !((Object)this$taxIds).equals(other$taxIds)) {
                return false;
            }
            String this$taxabilityOverride = this.getTaxabilityOverride();
            String other$taxabilityOverride = other.getTaxabilityOverride();
            return !(this$taxabilityOverride == null ? other$taxabilityOverride != null : !this$taxabilityOverride.equals(other$taxabilityOverride));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CustomerDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Address $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            String $addressSource = this.getAddressSource();
            result = result * 59 + ($addressSource == null ? 43 : $addressSource.hashCode());
            String $ipAddress = this.getIpAddress();
            result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
            List<TaxId> $taxIds = this.getTaxIds();
            result = result * 59 + ($taxIds == null ? 43 : ((Object)$taxIds).hashCode());
            String $taxabilityOverride = this.getTaxabilityOverride();
            result = result * 59 + ($taxabilityOverride == null ? 43 : $taxabilityOverride.hashCode());
            return result;
        }

        public static class Address
        extends StripeObject {
            @SerializedName(value="city")
            String city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="line1")
            String line1;
            @SerializedName(value="line2")
            String line2;
            @SerializedName(value="postal_code")
            String postalCode;
            @SerializedName(value="state")
            String state;

            @Generated
            public String getCity() {
                return this.city;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public String getLine1() {
                return this.line1;
            }

            @Generated
            public String getLine2() {
                return this.line2;
            }

            @Generated
            public String getPostalCode() {
                return this.postalCode;
            }

            @Generated
            public String getState() {
                return this.state;
            }

            @Generated
            public void setCity(String city) {
                this.city = city;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public void setLine1(String line1) {
                this.line1 = line1;
            }

            @Generated
            public void setLine2(String line2) {
                this.line2 = line2;
            }

            @Generated
            public void setPostalCode(String postalCode) {
                this.postalCode = postalCode;
            }

            @Generated
            public void setState(String state) {
                this.state = state;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Address)) {
                    return false;
                }
                Address other = (Address)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$city = this.getCity();
                String other$city = other.getCity();
                if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                String this$line1 = this.getLine1();
                String other$line1 = other.getLine1();
                if (this$line1 == null ? other$line1 != null : !this$line1.equals(other$line1)) {
                    return false;
                }
                String this$line2 = this.getLine2();
                String other$line2 = other.getLine2();
                if (this$line2 == null ? other$line2 != null : !this$line2.equals(other$line2)) {
                    return false;
                }
                String this$postalCode = this.getPostalCode();
                String other$postalCode = other.getPostalCode();
                if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) {
                    return false;
                }
                String this$state = this.getState();
                String other$state = other.getState();
                return !(this$state == null ? other$state != null : !this$state.equals(other$state));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Address;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $city = this.getCity();
                result = result * 59 + ($city == null ? 43 : $city.hashCode());
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                String $line1 = this.getLine1();
                result = result * 59 + ($line1 == null ? 43 : $line1.hashCode());
                String $line2 = this.getLine2();
                result = result * 59 + ($line2 == null ? 43 : $line2.hashCode());
                String $postalCode = this.getPostalCode();
                result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
                String $state = this.getState();
                result = result * 59 + ($state == null ? 43 : $state.hashCode());
                return result;
            }
        }

        public static class TaxId
        extends StripeObject {
            @SerializedName(value="type")
            String type;
            @SerializedName(value="value")
            String value;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TaxId)) {
                    return false;
                }
                TaxId other = (TaxId)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof TaxId;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Reversal
    extends StripeObject {
        @SerializedName(value="original_transaction")
        String originalTransaction;

        @Generated
        public String getOriginalTransaction() {
            return this.originalTransaction;
        }

        @Generated
        public void setOriginalTransaction(String originalTransaction) {
            this.originalTransaction = originalTransaction;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Reversal)) {
                return false;
            }
            Reversal other = (Reversal)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$originalTransaction = this.getOriginalTransaction();
            String other$originalTransaction = other.getOriginalTransaction();
            return !(this$originalTransaction == null ? other$originalTransaction != null : !this$originalTransaction.equals(other$originalTransaction));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Reversal;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $originalTransaction = this.getOriginalTransaction();
            result = result * 59 + ($originalTransaction == null ? 43 : $originalTransaction.hashCode());
            return result;
        }
    }

    public static class ShippingCost
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="amount_tax")
        Long amountTax;
        @SerializedName(value="shipping_rate")
        String shippingRate;
        @SerializedName(value="tax_behavior")
        String taxBehavior;
        @SerializedName(value="tax_breakdown")
        List<TaxBreakdown> taxBreakdown;
        @SerializedName(value="tax_code")
        String taxCode;

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public Long getAmountTax() {
            return this.amountTax;
        }

        @Generated
        public String getShippingRate() {
            return this.shippingRate;
        }

        @Generated
        public String getTaxBehavior() {
            return this.taxBehavior;
        }

        @Generated
        public List<TaxBreakdown> getTaxBreakdown() {
            return this.taxBreakdown;
        }

        @Generated
        public String getTaxCode() {
            return this.taxCode;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public void setAmountTax(Long amountTax) {
            this.amountTax = amountTax;
        }

        @Generated
        public void setShippingRate(String shippingRate) {
            this.shippingRate = shippingRate;
        }

        @Generated
        public void setTaxBehavior(String taxBehavior) {
            this.taxBehavior = taxBehavior;
        }

        @Generated
        public void setTaxBreakdown(List<TaxBreakdown> taxBreakdown) {
            this.taxBreakdown = taxBreakdown;
        }

        @Generated
        public void setTaxCode(String taxCode) {
            this.taxCode = taxCode;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShippingCost)) {
                return false;
            }
            ShippingCost other = (ShippingCost)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            Long this$amountTax = this.getAmountTax();
            Long other$amountTax = other.getAmountTax();
            if (this$amountTax == null ? other$amountTax != null : !((Object)this$amountTax).equals(other$amountTax)) {
                return false;
            }
            String this$shippingRate = this.getShippingRate();
            String other$shippingRate = other.getShippingRate();
            if (this$shippingRate == null ? other$shippingRate != null : !this$shippingRate.equals(other$shippingRate)) {
                return false;
            }
            String this$taxBehavior = this.getTaxBehavior();
            String other$taxBehavior = other.getTaxBehavior();
            if (this$taxBehavior == null ? other$taxBehavior != null : !this$taxBehavior.equals(other$taxBehavior)) {
                return false;
            }
            List<TaxBreakdown> this$taxBreakdown = this.getTaxBreakdown();
            List<TaxBreakdown> other$taxBreakdown = other.getTaxBreakdown();
            if (this$taxBreakdown == null ? other$taxBreakdown != null : !((Object)this$taxBreakdown).equals(other$taxBreakdown)) {
                return false;
            }
            String this$taxCode = this.getTaxCode();
            String other$taxCode = other.getTaxCode();
            return !(this$taxCode == null ? other$taxCode != null : !this$taxCode.equals(other$taxCode));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ShippingCost;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            Long $amountTax = this.getAmountTax();
            result = result * 59 + ($amountTax == null ? 43 : ((Object)$amountTax).hashCode());
            String $shippingRate = this.getShippingRate();
            result = result * 59 + ($shippingRate == null ? 43 : $shippingRate.hashCode());
            String $taxBehavior = this.getTaxBehavior();
            result = result * 59 + ($taxBehavior == null ? 43 : $taxBehavior.hashCode());
            List<TaxBreakdown> $taxBreakdown = this.getTaxBreakdown();
            result = result * 59 + ($taxBreakdown == null ? 43 : ((Object)$taxBreakdown).hashCode());
            String $taxCode = this.getTaxCode();
            result = result * 59 + ($taxCode == null ? 43 : $taxCode.hashCode());
            return result;
        }

        public static class TaxBreakdown
        extends StripeObject {
            @SerializedName(value="amount")
            Long amount;
            @SerializedName(value="jurisdiction")
            Jurisdiction jurisdiction;
            @SerializedName(value="sourcing")
            String sourcing;
            @SerializedName(value="tax_rate_details")
            TaxRateDetails taxRateDetails;
            @SerializedName(value="taxability_reason")
            String taxabilityReason;
            @SerializedName(value="taxable_amount")
            Long taxableAmount;

            @Generated
            public Long getAmount() {
                return this.amount;
            }

            @Generated
            public Jurisdiction getJurisdiction() {
                return this.jurisdiction;
            }

            @Generated
            public String getSourcing() {
                return this.sourcing;
            }

            @Generated
            public TaxRateDetails getTaxRateDetails() {
                return this.taxRateDetails;
            }

            @Generated
            public String getTaxabilityReason() {
                return this.taxabilityReason;
            }

            @Generated
            public Long getTaxableAmount() {
                return this.taxableAmount;
            }

            @Generated
            public void setAmount(Long amount) {
                this.amount = amount;
            }

            @Generated
            public void setJurisdiction(Jurisdiction jurisdiction) {
                this.jurisdiction = jurisdiction;
            }

            @Generated
            public void setSourcing(String sourcing) {
                this.sourcing = sourcing;
            }

            @Generated
            public void setTaxRateDetails(TaxRateDetails taxRateDetails) {
                this.taxRateDetails = taxRateDetails;
            }

            @Generated
            public void setTaxabilityReason(String taxabilityReason) {
                this.taxabilityReason = taxabilityReason;
            }

            @Generated
            public void setTaxableAmount(Long taxableAmount) {
                this.taxableAmount = taxableAmount;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TaxBreakdown)) {
                    return false;
                }
                TaxBreakdown other = (TaxBreakdown)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$amount = this.getAmount();
                Long other$amount = other.getAmount();
                if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                    return false;
                }
                Long this$taxableAmount = this.getTaxableAmount();
                Long other$taxableAmount = other.getTaxableAmount();
                if (this$taxableAmount == null ? other$taxableAmount != null : !((Object)this$taxableAmount).equals(other$taxableAmount)) {
                    return false;
                }
                Jurisdiction this$jurisdiction = this.getJurisdiction();
                Jurisdiction other$jurisdiction = other.getJurisdiction();
                if (this$jurisdiction == null ? other$jurisdiction != null : !((Object)this$jurisdiction).equals(other$jurisdiction)) {
                    return false;
                }
                String this$sourcing = this.getSourcing();
                String other$sourcing = other.getSourcing();
                if (this$sourcing == null ? other$sourcing != null : !this$sourcing.equals(other$sourcing)) {
                    return false;
                }
                TaxRateDetails this$taxRateDetails = this.getTaxRateDetails();
                TaxRateDetails other$taxRateDetails = other.getTaxRateDetails();
                if (this$taxRateDetails == null ? other$taxRateDetails != null : !((Object)this$taxRateDetails).equals(other$taxRateDetails)) {
                    return false;
                }
                String this$taxabilityReason = this.getTaxabilityReason();
                String other$taxabilityReason = other.getTaxabilityReason();
                return !(this$taxabilityReason == null ? other$taxabilityReason != null : !this$taxabilityReason.equals(other$taxabilityReason));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof TaxBreakdown;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $amount = this.getAmount();
                result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                Long $taxableAmount = this.getTaxableAmount();
                result = result * 59 + ($taxableAmount == null ? 43 : ((Object)$taxableAmount).hashCode());
                Jurisdiction $jurisdiction = this.getJurisdiction();
                result = result * 59 + ($jurisdiction == null ? 43 : ((Object)$jurisdiction).hashCode());
                String $sourcing = this.getSourcing();
                result = result * 59 + ($sourcing == null ? 43 : $sourcing.hashCode());
                TaxRateDetails $taxRateDetails = this.getTaxRateDetails();
                result = result * 59 + ($taxRateDetails == null ? 43 : ((Object)$taxRateDetails).hashCode());
                String $taxabilityReason = this.getTaxabilityReason();
                result = result * 59 + ($taxabilityReason == null ? 43 : $taxabilityReason.hashCode());
                return result;
            }

            public static class Jurisdiction
            extends StripeObject {
                @SerializedName(value="country")
                String country;
                @SerializedName(value="display_name")
                String displayName;
                @SerializedName(value="level")
                String level;
                @SerializedName(value="state")
                String state;

                @Generated
                public String getCountry() {
                    return this.country;
                }

                @Generated
                public String getDisplayName() {
                    return this.displayName;
                }

                @Generated
                public String getLevel() {
                    return this.level;
                }

                @Generated
                public String getState() {
                    return this.state;
                }

                @Generated
                public void setCountry(String country) {
                    this.country = country;
                }

                @Generated
                public void setDisplayName(String displayName) {
                    this.displayName = displayName;
                }

                @Generated
                public void setLevel(String level) {
                    this.level = level;
                }

                @Generated
                public void setState(String state) {
                    this.state = state;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Jurisdiction)) {
                        return false;
                    }
                    Jurisdiction other = (Jurisdiction)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$country = this.getCountry();
                    String other$country = other.getCountry();
                    if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                        return false;
                    }
                    String this$displayName = this.getDisplayName();
                    String other$displayName = other.getDisplayName();
                    if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                        return false;
                    }
                    String this$level = this.getLevel();
                    String other$level = other.getLevel();
                    if (this$level == null ? other$level != null : !this$level.equals(other$level)) {
                        return false;
                    }
                    String this$state = this.getState();
                    String other$state = other.getState();
                    return !(this$state == null ? other$state != null : !this$state.equals(other$state));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Jurisdiction;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $country = this.getCountry();
                    result = result * 59 + ($country == null ? 43 : $country.hashCode());
                    String $displayName = this.getDisplayName();
                    result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
                    String $level = this.getLevel();
                    result = result * 59 + ($level == null ? 43 : $level.hashCode());
                    String $state = this.getState();
                    result = result * 59 + ($state == null ? 43 : $state.hashCode());
                    return result;
                }
            }

            public static class TaxRateDetails
            extends StripeObject {
                @SerializedName(value="display_name")
                String displayName;
                @SerializedName(value="percentage_decimal")
                String percentageDecimal;
                @SerializedName(value="tax_type")
                String taxType;

                @Generated
                public String getDisplayName() {
                    return this.displayName;
                }

                @Generated
                public String getPercentageDecimal() {
                    return this.percentageDecimal;
                }

                @Generated
                public String getTaxType() {
                    return this.taxType;
                }

                @Generated
                public void setDisplayName(String displayName) {
                    this.displayName = displayName;
                }

                @Generated
                public void setPercentageDecimal(String percentageDecimal) {
                    this.percentageDecimal = percentageDecimal;
                }

                @Generated
                public void setTaxType(String taxType) {
                    this.taxType = taxType;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof TaxRateDetails)) {
                        return false;
                    }
                    TaxRateDetails other = (TaxRateDetails)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$displayName = this.getDisplayName();
                    String other$displayName = other.getDisplayName();
                    if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                        return false;
                    }
                    String this$percentageDecimal = this.getPercentageDecimal();
                    String other$percentageDecimal = other.getPercentageDecimal();
                    if (this$percentageDecimal == null ? other$percentageDecimal != null : !this$percentageDecimal.equals(other$percentageDecimal)) {
                        return false;
                    }
                    String this$taxType = this.getTaxType();
                    String other$taxType = other.getTaxType();
                    return !(this$taxType == null ? other$taxType != null : !this$taxType.equals(other$taxType));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof TaxRateDetails;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $displayName = this.getDisplayName();
                    result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
                    String $percentageDecimal = this.getPercentageDecimal();
                    result = result * 59 + ($percentageDecimal == null ? 43 : $percentageDecimal.hashCode());
                    String $taxType = this.getTaxType();
                    result = result * 59 + ($taxType == null ? 43 : $taxType.hashCode());
                    return result;
                }
            }
        }
    }
}

