/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.identity;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.model.identity.VerificationReport;
import com.stripe.model.identity.VerificationSessionCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.identity.VerificationSessionCancelParams;
import com.stripe.param.identity.VerificationSessionCreateParams;
import com.stripe.param.identity.VerificationSessionListParams;
import com.stripe.param.identity.VerificationSessionRedactParams;
import com.stripe.param.identity.VerificationSessionRetrieveParams;
import com.stripe.param.identity.VerificationSessionUpdateParams;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class VerificationSession
extends ApiResource
implements HasId,
MetadataStore<VerificationSession> {
    @SerializedName(value="client_secret")
    String clientSecret;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="last_error")
    LastError lastError;
    @SerializedName(value="last_verification_report")
    ExpandableField<VerificationReport> lastVerificationReport;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="options")
    Options options;
    @SerializedName(value="redaction")
    Redaction redaction;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="type")
    String type;
    @SerializedName(value="url")
    String url;
    @SerializedName(value="verified_outputs")
    VerifiedOutputs verifiedOutputs;

    public String getLastVerificationReport() {
        return this.lastVerificationReport != null ? this.lastVerificationReport.getId() : null;
    }

    public void setLastVerificationReport(String id) {
        this.lastVerificationReport = ApiResource.setExpandableFieldId(id, this.lastVerificationReport);
    }

    public VerificationReport getLastVerificationReportObject() {
        return this.lastVerificationReport != null ? this.lastVerificationReport.getExpanded() : null;
    }

    public void setLastVerificationReportObject(VerificationReport expandableObject) {
        this.lastVerificationReport = new ExpandableField<VerificationReport>(expandableObject.getId(), expandableObject);
    }

    public VerificationSession cancel() throws StripeException {
        return this.cancel((Map<String, Object>)null, (RequestOptions)null);
    }

    public VerificationSession cancel(RequestOptions options) throws StripeException {
        return this.cancel((Map<String, Object>)null, options);
    }

    public VerificationSession cancel(Map<String, Object> params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public VerificationSession cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/identity/verification_sessions/%s/cancel", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, VerificationSession.class, options);
    }

    public VerificationSession cancel(VerificationSessionCancelParams params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public VerificationSession cancel(VerificationSessionCancelParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/identity/verification_sessions/%s/cancel", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, VerificationSession.class, options);
    }

    public static VerificationSession create(Map<String, Object> params) throws StripeException {
        return VerificationSession.create(params, (RequestOptions)null);
    }

    public static VerificationSession create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/identity/verification_sessions");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, VerificationSession.class, options);
    }

    public static VerificationSession create(VerificationSessionCreateParams params) throws StripeException {
        return VerificationSession.create(params, (RequestOptions)null);
    }

    public static VerificationSession create(VerificationSessionCreateParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/identity/verification_sessions");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, VerificationSession.class, options);
    }

    public static VerificationSessionCollection list(Map<String, Object> params) throws StripeException {
        return VerificationSession.list(params, (RequestOptions)null);
    }

    public static VerificationSessionCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/identity/verification_sessions");
        return ApiResource.requestCollection(url, params, VerificationSessionCollection.class, options);
    }

    public static VerificationSessionCollection list(VerificationSessionListParams params) throws StripeException {
        return VerificationSession.list(params, (RequestOptions)null);
    }

    public static VerificationSessionCollection list(VerificationSessionListParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/identity/verification_sessions");
        return ApiResource.requestCollection(url, params, VerificationSessionCollection.class, options);
    }

    public VerificationSession redact() throws StripeException {
        return this.redact((Map<String, Object>)null, (RequestOptions)null);
    }

    public VerificationSession redact(RequestOptions options) throws StripeException {
        return this.redact((Map<String, Object>)null, options);
    }

    public VerificationSession redact(Map<String, Object> params) throws StripeException {
        return this.redact(params, (RequestOptions)null);
    }

    public VerificationSession redact(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/identity/verification_sessions/%s/redact", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, VerificationSession.class, options);
    }

    public VerificationSession redact(VerificationSessionRedactParams params) throws StripeException {
        return this.redact(params, (RequestOptions)null);
    }

    public VerificationSession redact(VerificationSessionRedactParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/identity/verification_sessions/%s/redact", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, VerificationSession.class, options);
    }

    public static VerificationSession retrieve(String session) throws StripeException {
        return VerificationSession.retrieve(session, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static VerificationSession retrieve(String session, RequestOptions options) throws StripeException {
        return VerificationSession.retrieve(session, (Map<String, Object>)null, options);
    }

    public static VerificationSession retrieve(String session, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/identity/verification_sessions/%s", ApiResource.urlEncodeId(session)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, VerificationSession.class, options);
    }

    public static VerificationSession retrieve(String session, VerificationSessionRetrieveParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/identity/verification_sessions/%s", ApiResource.urlEncodeId(session)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, VerificationSession.class, options);
    }

    public VerificationSession update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public VerificationSession update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/identity/verification_sessions/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, VerificationSession.class, options);
    }

    public VerificationSession update(VerificationSessionUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public VerificationSession update(VerificationSessionUpdateParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/identity/verification_sessions/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, VerificationSession.class, options);
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public LastError getLastError() {
        return this.lastError;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Options getOptions() {
        return this.options;
    }

    @Generated
    public Redaction getRedaction() {
        return this.redaction;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public VerifiedOutputs getVerifiedOutputs() {
        return this.verifiedOutputs;
    }

    @Generated
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLastError(LastError lastError) {
        this.lastError = lastError;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setOptions(Options options) {
        this.options = options;
    }

    @Generated
    public void setRedaction(Redaction redaction) {
        this.redaction = redaction;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setVerifiedOutputs(VerifiedOutputs verifiedOutputs) {
        this.verifiedOutputs = verifiedOutputs;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VerificationSession)) {
            return false;
        }
        VerificationSession other = (VerificationSession)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        LastError this$lastError = this.getLastError();
        LastError other$lastError = other.getLastError();
        if (this$lastError == null ? other$lastError != null : !((Object)this$lastError).equals(other$lastError)) {
            return false;
        }
        String this$lastVerificationReport = this.getLastVerificationReport();
        String other$lastVerificationReport = other.getLastVerificationReport();
        if (this$lastVerificationReport == null ? other$lastVerificationReport != null : !this$lastVerificationReport.equals(other$lastVerificationReport)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Options this$options = this.getOptions();
        Options other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        Redaction this$redaction = this.getRedaction();
        Redaction other$redaction = other.getRedaction();
        if (this$redaction == null ? other$redaction != null : !((Object)this$redaction).equals(other$redaction)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        VerifiedOutputs this$verifiedOutputs = this.getVerifiedOutputs();
        VerifiedOutputs other$verifiedOutputs = other.getVerifiedOutputs();
        return !(this$verifiedOutputs == null ? other$verifiedOutputs != null : !((Object)this$verifiedOutputs).equals(other$verifiedOutputs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VerificationSession;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        LastError $lastError = this.getLastError();
        result = result * 59 + ($lastError == null ? 43 : ((Object)$lastError).hashCode());
        String $lastVerificationReport = this.getLastVerificationReport();
        result = result * 59 + ($lastVerificationReport == null ? 43 : $lastVerificationReport.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Options $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        Redaction $redaction = this.getRedaction();
        result = result * 59 + ($redaction == null ? 43 : ((Object)$redaction).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        VerifiedOutputs $verifiedOutputs = this.getVerifiedOutputs();
        result = result * 59 + ($verifiedOutputs == null ? 43 : ((Object)$verifiedOutputs).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class LastError
    extends StripeObject {
        @SerializedName(value="code")
        String code;
        @SerializedName(value="reason")
        String reason;

        @Generated
        public String getCode() {
            return this.code;
        }

        @Generated
        public String getReason() {
            return this.reason;
        }

        @Generated
        public void setCode(String code) {
            this.code = code;
        }

        @Generated
        public void setReason(String reason) {
            this.reason = reason;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LastError)) {
                return false;
            }
            LastError other = (LastError)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            String this$reason = this.getReason();
            String other$reason = other.getReason();
            return !(this$reason == null ? other$reason != null : !this$reason.equals(other$reason));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LastError;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            String $reason = this.getReason();
            result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
            return result;
        }
    }

    public static class Options
    extends StripeObject {
        @SerializedName(value="document")
        Document document;
        @SerializedName(value="id_number")
        IdNumber idNumber;

        @Generated
        public Document getDocument() {
            return this.document;
        }

        @Generated
        public IdNumber getIdNumber() {
            return this.idNumber;
        }

        @Generated
        public void setDocument(Document document) {
            this.document = document;
        }

        @Generated
        public void setIdNumber(IdNumber idNumber) {
            this.idNumber = idNumber;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Options)) {
                return false;
            }
            Options other = (Options)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Document this$document = this.getDocument();
            Document other$document = other.getDocument();
            if (this$document == null ? other$document != null : !((Object)this$document).equals(other$document)) {
                return false;
            }
            IdNumber this$idNumber = this.getIdNumber();
            IdNumber other$idNumber = other.getIdNumber();
            return !(this$idNumber == null ? other$idNumber != null : !((Object)this$idNumber).equals(other$idNumber));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Options;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Document $document = this.getDocument();
            result = result * 59 + ($document == null ? 43 : ((Object)$document).hashCode());
            IdNumber $idNumber = this.getIdNumber();
            result = result * 59 + ($idNumber == null ? 43 : ((Object)$idNumber).hashCode());
            return result;
        }

        public static class Document
        extends StripeObject {
            @SerializedName(value="allowed_types")
            List<String> allowedTypes;
            @SerializedName(value="require_id_number")
            Boolean requireIdNumber;
            @SerializedName(value="require_live_capture")
            Boolean requireLiveCapture;
            @SerializedName(value="require_matching_selfie")
            Boolean requireMatchingSelfie;

            @Generated
            public List<String> getAllowedTypes() {
                return this.allowedTypes;
            }

            @Generated
            public Boolean getRequireIdNumber() {
                return this.requireIdNumber;
            }

            @Generated
            public Boolean getRequireLiveCapture() {
                return this.requireLiveCapture;
            }

            @Generated
            public Boolean getRequireMatchingSelfie() {
                return this.requireMatchingSelfie;
            }

            @Generated
            public void setAllowedTypes(List<String> allowedTypes) {
                this.allowedTypes = allowedTypes;
            }

            @Generated
            public void setRequireIdNumber(Boolean requireIdNumber) {
                this.requireIdNumber = requireIdNumber;
            }

            @Generated
            public void setRequireLiveCapture(Boolean requireLiveCapture) {
                this.requireLiveCapture = requireLiveCapture;
            }

            @Generated
            public void setRequireMatchingSelfie(Boolean requireMatchingSelfie) {
                this.requireMatchingSelfie = requireMatchingSelfie;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Document)) {
                    return false;
                }
                Document other = (Document)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$requireIdNumber = this.getRequireIdNumber();
                Boolean other$requireIdNumber = other.getRequireIdNumber();
                if (this$requireIdNumber == null ? other$requireIdNumber != null : !((Object)this$requireIdNumber).equals(other$requireIdNumber)) {
                    return false;
                }
                Boolean this$requireLiveCapture = this.getRequireLiveCapture();
                Boolean other$requireLiveCapture = other.getRequireLiveCapture();
                if (this$requireLiveCapture == null ? other$requireLiveCapture != null : !((Object)this$requireLiveCapture).equals(other$requireLiveCapture)) {
                    return false;
                }
                Boolean this$requireMatchingSelfie = this.getRequireMatchingSelfie();
                Boolean other$requireMatchingSelfie = other.getRequireMatchingSelfie();
                if (this$requireMatchingSelfie == null ? other$requireMatchingSelfie != null : !((Object)this$requireMatchingSelfie).equals(other$requireMatchingSelfie)) {
                    return false;
                }
                List<String> this$allowedTypes = this.getAllowedTypes();
                List<String> other$allowedTypes = other.getAllowedTypes();
                return !(this$allowedTypes == null ? other$allowedTypes != null : !((Object)this$allowedTypes).equals(other$allowedTypes));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Document;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $requireIdNumber = this.getRequireIdNumber();
                result = result * 59 + ($requireIdNumber == null ? 43 : ((Object)$requireIdNumber).hashCode());
                Boolean $requireLiveCapture = this.getRequireLiveCapture();
                result = result * 59 + ($requireLiveCapture == null ? 43 : ((Object)$requireLiveCapture).hashCode());
                Boolean $requireMatchingSelfie = this.getRequireMatchingSelfie();
                result = result * 59 + ($requireMatchingSelfie == null ? 43 : ((Object)$requireMatchingSelfie).hashCode());
                List<String> $allowedTypes = this.getAllowedTypes();
                result = result * 59 + ($allowedTypes == null ? 43 : ((Object)$allowedTypes).hashCode());
                return result;
            }
        }

        public static class IdNumber
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof IdNumber)) {
                    return false;
                }
                IdNumber other = (IdNumber)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof IdNumber;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }
    }

    public static class Redaction
    extends StripeObject {
        @SerializedName(value="status")
        String status;

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Redaction)) {
                return false;
            }
            Redaction other = (Redaction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !this$status.equals(other$status));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Redaction;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            return result;
        }
    }

    public static class VerifiedOutputs
    extends StripeObject {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="dob")
        Dob dob;
        @SerializedName(value="first_name")
        String firstName;
        @SerializedName(value="id_number")
        String idNumber;
        @SerializedName(value="id_number_type")
        String idNumberType;
        @SerializedName(value="last_name")
        String lastName;

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public Dob getDob() {
            return this.dob;
        }

        @Generated
        public String getFirstName() {
            return this.firstName;
        }

        @Generated
        public String getIdNumber() {
            return this.idNumber;
        }

        @Generated
        public String getIdNumberType() {
            return this.idNumberType;
        }

        @Generated
        public String getLastName() {
            return this.lastName;
        }

        @Generated
        public void setAddress(Address address) {
            this.address = address;
        }

        @Generated
        public void setDob(Dob dob) {
            this.dob = dob;
        }

        @Generated
        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Generated
        public void setIdNumber(String idNumber) {
            this.idNumber = idNumber;
        }

        @Generated
        public void setIdNumberType(String idNumberType) {
            this.idNumberType = idNumberType;
        }

        @Generated
        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VerifiedOutputs)) {
                return false;
            }
            VerifiedOutputs other = (VerifiedOutputs)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Address this$address = this.getAddress();
            Address other$address = other.getAddress();
            if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                return false;
            }
            Dob this$dob = this.getDob();
            Dob other$dob = other.getDob();
            if (this$dob == null ? other$dob != null : !((Object)this$dob).equals(other$dob)) {
                return false;
            }
            String this$firstName = this.getFirstName();
            String other$firstName = other.getFirstName();
            if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
                return false;
            }
            String this$idNumber = this.getIdNumber();
            String other$idNumber = other.getIdNumber();
            if (this$idNumber == null ? other$idNumber != null : !this$idNumber.equals(other$idNumber)) {
                return false;
            }
            String this$idNumberType = this.getIdNumberType();
            String other$idNumberType = other.getIdNumberType();
            if (this$idNumberType == null ? other$idNumberType != null : !this$idNumberType.equals(other$idNumberType)) {
                return false;
            }
            String this$lastName = this.getLastName();
            String other$lastName = other.getLastName();
            return !(this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof VerifiedOutputs;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Address $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            Dob $dob = this.getDob();
            result = result * 59 + ($dob == null ? 43 : ((Object)$dob).hashCode());
            String $firstName = this.getFirstName();
            result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
            String $idNumber = this.getIdNumber();
            result = result * 59 + ($idNumber == null ? 43 : $idNumber.hashCode());
            String $idNumberType = this.getIdNumberType();
            result = result * 59 + ($idNumberType == null ? 43 : $idNumberType.hashCode());
            String $lastName = this.getLastName();
            result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
            return result;
        }

        public static class Dob
        extends StripeObject {
            @SerializedName(value="day")
            Long day;
            @SerializedName(value="month")
            Long month;
            @SerializedName(value="year")
            Long year;

            @Generated
            public Long getDay() {
                return this.day;
            }

            @Generated
            public Long getMonth() {
                return this.month;
            }

            @Generated
            public Long getYear() {
                return this.year;
            }

            @Generated
            public void setDay(Long day) {
                this.day = day;
            }

            @Generated
            public void setMonth(Long month) {
                this.month = month;
            }

            @Generated
            public void setYear(Long year) {
                this.year = year;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Dob)) {
                    return false;
                }
                Dob other = (Dob)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$day = this.getDay();
                Long other$day = other.getDay();
                if (this$day == null ? other$day != null : !((Object)this$day).equals(other$day)) {
                    return false;
                }
                Long this$month = this.getMonth();
                Long other$month = other.getMonth();
                if (this$month == null ? other$month != null : !((Object)this$month).equals(other$month)) {
                    return false;
                }
                Long this$year = this.getYear();
                Long other$year = other.getYear();
                return !(this$year == null ? other$year != null : !((Object)this$year).equals(other$year));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Dob;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $day = this.getDay();
                result = result * 59 + ($day == null ? 43 : ((Object)$day).hashCode());
                Long $month = this.getMonth();
                result = result * 59 + ($month == null ? 43 : ((Object)$month).hashCode());
                Long $year = this.getYear();
                result = result * 59 + ($year == null ? 43 : ((Object)$year).hashCode());
                return result;
            }
        }
    }
}

