/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.checkout;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.Invoice;
import com.stripe.model.LineItemCollection;
import com.stripe.model.PaymentIntent;
import com.stripe.model.PaymentLink;
import com.stripe.model.SetupIntent;
import com.stripe.model.ShippingDetails;
import com.stripe.model.ShippingRate;
import com.stripe.model.StripeObject;
import com.stripe.model.Subscription;
import com.stripe.model.TaxId;
import com.stripe.model.TaxRate;
import com.stripe.model.checkout.SessionCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.checkout.SessionCreateParams;
import com.stripe.param.checkout.SessionExpireParams;
import com.stripe.param.checkout.SessionListLineItemsParams;
import com.stripe.param.checkout.SessionListParams;
import com.stripe.param.checkout.SessionRetrieveParams;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class Session
extends ApiResource
implements HasId {
    @SerializedName(value="after_expiration")
    AfterExpiration afterExpiration;
    @SerializedName(value="allow_promotion_codes")
    Boolean allowPromotionCodes;
    @SerializedName(value="amount_subtotal")
    Long amountSubtotal;
    @SerializedName(value="amount_total")
    Long amountTotal;
    @SerializedName(value="automatic_tax")
    AutomaticTax automaticTax;
    @SerializedName(value="billing_address_collection")
    String billingAddressCollection;
    @SerializedName(value="cancel_url")
    String cancelUrl;
    @SerializedName(value="client_reference_id")
    String clientReferenceId;
    @SerializedName(value="consent")
    Consent consent;
    @SerializedName(value="consent_collection")
    ConsentCollection consentCollection;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="currency_conversion")
    CurrencyConversion currencyConversion;
    @SerializedName(value="custom_fields")
    List<CustomField> customFields;
    @SerializedName(value="custom_text")
    CustomText customText;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="customer_creation")
    String customerCreation;
    @SerializedName(value="customer_details")
    CustomerDetails customerDetails;
    @SerializedName(value="customer_email")
    String customerEmail;
    @SerializedName(value="expires_at")
    Long expiresAt;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="invoice")
    ExpandableField<Invoice> invoice;
    @SerializedName(value="invoice_creation")
    InvoiceCreation invoiceCreation;
    @SerializedName(value="line_items")
    LineItemCollection lineItems;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="locale")
    String locale;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="mode")
    String mode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="payment_intent")
    ExpandableField<PaymentIntent> paymentIntent;
    @SerializedName(value="payment_link")
    ExpandableField<PaymentLink> paymentLink;
    @SerializedName(value="payment_method_collection")
    String paymentMethodCollection;
    @SerializedName(value="payment_method_options")
    PaymentMethodOptions paymentMethodOptions;
    @SerializedName(value="payment_method_types")
    List<String> paymentMethodTypes;
    @SerializedName(value="payment_status")
    String paymentStatus;
    @SerializedName(value="phone_number_collection")
    PhoneNumberCollection phoneNumberCollection;
    @SerializedName(value="recovered_from")
    String recoveredFrom;
    @SerializedName(value="setup_intent")
    ExpandableField<SetupIntent> setupIntent;
    @SerializedName(value="shipping_address_collection")
    ShippingAddressCollection shippingAddressCollection;
    @SerializedName(value="shipping_cost")
    ShippingCost shippingCost;
    @SerializedName(value="shipping_details")
    ShippingDetails shippingDetails;
    @SerializedName(value="shipping_options")
    List<ShippingOption> shippingOptions;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="submit_type")
    String submitType;
    @SerializedName(value="subscription")
    ExpandableField<Subscription> subscription;
    @SerializedName(value="success_url")
    String successUrl;
    @SerializedName(value="tax_id_collection")
    TaxIdCollection taxIdCollection;
    @SerializedName(value="total_details")
    TotalDetails totalDetails;
    @SerializedName(value="url")
    String url;

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public String getInvoice() {
        return this.invoice != null ? this.invoice.getId() : null;
    }

    public void setInvoice(String id) {
        this.invoice = ApiResource.setExpandableFieldId(id, this.invoice);
    }

    public Invoice getInvoiceObject() {
        return this.invoice != null ? this.invoice.getExpanded() : null;
    }

    public void setInvoiceObject(Invoice expandableObject) {
        this.invoice = new ExpandableField<Invoice>(expandableObject.getId(), expandableObject);
    }

    public String getPaymentIntent() {
        return this.paymentIntent != null ? this.paymentIntent.getId() : null;
    }

    public void setPaymentIntent(String id) {
        this.paymentIntent = ApiResource.setExpandableFieldId(id, this.paymentIntent);
    }

    public PaymentIntent getPaymentIntentObject() {
        return this.paymentIntent != null ? this.paymentIntent.getExpanded() : null;
    }

    public void setPaymentIntentObject(PaymentIntent expandableObject) {
        this.paymentIntent = new ExpandableField<PaymentIntent>(expandableObject.getId(), expandableObject);
    }

    public String getPaymentLink() {
        return this.paymentLink != null ? this.paymentLink.getId() : null;
    }

    public void setPaymentLink(String id) {
        this.paymentLink = ApiResource.setExpandableFieldId(id, this.paymentLink);
    }

    public PaymentLink getPaymentLinkObject() {
        return this.paymentLink != null ? this.paymentLink.getExpanded() : null;
    }

    public void setPaymentLinkObject(PaymentLink expandableObject) {
        this.paymentLink = new ExpandableField<PaymentLink>(expandableObject.getId(), expandableObject);
    }

    public String getSetupIntent() {
        return this.setupIntent != null ? this.setupIntent.getId() : null;
    }

    public void setSetupIntent(String id) {
        this.setupIntent = ApiResource.setExpandableFieldId(id, this.setupIntent);
    }

    public SetupIntent getSetupIntentObject() {
        return this.setupIntent != null ? this.setupIntent.getExpanded() : null;
    }

    public void setSetupIntentObject(SetupIntent expandableObject) {
        this.setupIntent = new ExpandableField<SetupIntent>(expandableObject.getId(), expandableObject);
    }

    public String getSubscription() {
        return this.subscription != null ? this.subscription.getId() : null;
    }

    public void setSubscription(String id) {
        this.subscription = ApiResource.setExpandableFieldId(id, this.subscription);
    }

    public Subscription getSubscriptionObject() {
        return this.subscription != null ? this.subscription.getExpanded() : null;
    }

    public void setSubscriptionObject(Subscription expandableObject) {
        this.subscription = new ExpandableField<Subscription>(expandableObject.getId(), expandableObject);
    }

    public static Session create(Map<String, Object> params) throws StripeException {
        return Session.create(params, (RequestOptions)null);
    }

    public static Session create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/checkout/sessions");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Session.class, options);
    }

    public static Session create(SessionCreateParams params) throws StripeException {
        return Session.create(params, (RequestOptions)null);
    }

    public static Session create(SessionCreateParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/checkout/sessions");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Session.class, options);
    }

    public Session expire() throws StripeException {
        return this.expire((Map<String, Object>)null, (RequestOptions)null);
    }

    public Session expire(RequestOptions options) throws StripeException {
        return this.expire((Map<String, Object>)null, options);
    }

    public Session expire(Map<String, Object> params) throws StripeException {
        return this.expire(params, (RequestOptions)null);
    }

    public Session expire(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/checkout/sessions/%s/expire", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Session.class, options);
    }

    public Session expire(SessionExpireParams params) throws StripeException {
        return this.expire(params, (RequestOptions)null);
    }

    public Session expire(SessionExpireParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/checkout/sessions/%s/expire", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Session.class, options);
    }

    public static SessionCollection list(Map<String, Object> params) throws StripeException {
        return Session.list(params, (RequestOptions)null);
    }

    public static SessionCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/checkout/sessions");
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, SessionCollection.class, options);
    }

    public static SessionCollection list(SessionListParams params) throws StripeException {
        return Session.list(params, (RequestOptions)null);
    }

    public static SessionCollection list(SessionListParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/checkout/sessions");
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, SessionCollection.class, options);
    }

    public LineItemCollection listLineItems() throws StripeException {
        return this.listLineItems((Map<String, Object>)null, (RequestOptions)null);
    }

    public LineItemCollection listLineItems(Map<String, Object> params) throws StripeException {
        return this.listLineItems(params, (RequestOptions)null);
    }

    public LineItemCollection listLineItems(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/checkout/sessions/%s/line_items", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, LineItemCollection.class, options);
    }

    public LineItemCollection listLineItems(SessionListLineItemsParams params) throws StripeException {
        return this.listLineItems(params, (RequestOptions)null);
    }

    public LineItemCollection listLineItems(SessionListLineItemsParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/checkout/sessions/%s/line_items", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, LineItemCollection.class, options);
    }

    public static Session retrieve(String session) throws StripeException {
        return Session.retrieve(session, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Session retrieve(String session, RequestOptions options) throws StripeException {
        return Session.retrieve(session, (Map<String, Object>)null, options);
    }

    public static Session retrieve(String session, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/checkout/sessions/%s", ApiResource.urlEncodeId(session)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Session.class, options);
    }

    public static Session retrieve(String session, SessionRetrieveParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/checkout/sessions/%s", ApiResource.urlEncodeId(session)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Session.class, options);
    }

    @Generated
    public AfterExpiration getAfterExpiration() {
        return this.afterExpiration;
    }

    @Generated
    public Boolean getAllowPromotionCodes() {
        return this.allowPromotionCodes;
    }

    @Generated
    public Long getAmountSubtotal() {
        return this.amountSubtotal;
    }

    @Generated
    public Long getAmountTotal() {
        return this.amountTotal;
    }

    @Generated
    public AutomaticTax getAutomaticTax() {
        return this.automaticTax;
    }

    @Generated
    public String getBillingAddressCollection() {
        return this.billingAddressCollection;
    }

    @Generated
    public String getCancelUrl() {
        return this.cancelUrl;
    }

    @Generated
    public String getClientReferenceId() {
        return this.clientReferenceId;
    }

    @Generated
    public Consent getConsent() {
        return this.consent;
    }

    @Generated
    public ConsentCollection getConsentCollection() {
        return this.consentCollection;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public CurrencyConversion getCurrencyConversion() {
        return this.currencyConversion;
    }

    @Generated
    public List<CustomField> getCustomFields() {
        return this.customFields;
    }

    @Generated
    public CustomText getCustomText() {
        return this.customText;
    }

    @Generated
    public String getCustomerCreation() {
        return this.customerCreation;
    }

    @Generated
    public CustomerDetails getCustomerDetails() {
        return this.customerDetails;
    }

    @Generated
    public String getCustomerEmail() {
        return this.customerEmail;
    }

    @Generated
    public Long getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public InvoiceCreation getInvoiceCreation() {
        return this.invoiceCreation;
    }

    @Generated
    public LineItemCollection getLineItems() {
        return this.lineItems;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getLocale() {
        return this.locale;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public String getMode() {
        return this.mode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getPaymentMethodCollection() {
        return this.paymentMethodCollection;
    }

    @Generated
    public PaymentMethodOptions getPaymentMethodOptions() {
        return this.paymentMethodOptions;
    }

    @Generated
    public List<String> getPaymentMethodTypes() {
        return this.paymentMethodTypes;
    }

    @Generated
    public String getPaymentStatus() {
        return this.paymentStatus;
    }

    @Generated
    public PhoneNumberCollection getPhoneNumberCollection() {
        return this.phoneNumberCollection;
    }

    @Generated
    public String getRecoveredFrom() {
        return this.recoveredFrom;
    }

    @Generated
    public ShippingAddressCollection getShippingAddressCollection() {
        return this.shippingAddressCollection;
    }

    @Generated
    public ShippingCost getShippingCost() {
        return this.shippingCost;
    }

    @Generated
    public ShippingDetails getShippingDetails() {
        return this.shippingDetails;
    }

    @Generated
    public List<ShippingOption> getShippingOptions() {
        return this.shippingOptions;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getSubmitType() {
        return this.submitType;
    }

    @Generated
    public String getSuccessUrl() {
        return this.successUrl;
    }

    @Generated
    public TaxIdCollection getTaxIdCollection() {
        return this.taxIdCollection;
    }

    @Generated
    public TotalDetails getTotalDetails() {
        return this.totalDetails;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public void setAfterExpiration(AfterExpiration afterExpiration) {
        this.afterExpiration = afterExpiration;
    }

    @Generated
    public void setAllowPromotionCodes(Boolean allowPromotionCodes) {
        this.allowPromotionCodes = allowPromotionCodes;
    }

    @Generated
    public void setAmountSubtotal(Long amountSubtotal) {
        this.amountSubtotal = amountSubtotal;
    }

    @Generated
    public void setAmountTotal(Long amountTotal) {
        this.amountTotal = amountTotal;
    }

    @Generated
    public void setAutomaticTax(AutomaticTax automaticTax) {
        this.automaticTax = automaticTax;
    }

    @Generated
    public void setBillingAddressCollection(String billingAddressCollection) {
        this.billingAddressCollection = billingAddressCollection;
    }

    @Generated
    public void setCancelUrl(String cancelUrl) {
        this.cancelUrl = cancelUrl;
    }

    @Generated
    public void setClientReferenceId(String clientReferenceId) {
        this.clientReferenceId = clientReferenceId;
    }

    @Generated
    public void setConsent(Consent consent) {
        this.consent = consent;
    }

    @Generated
    public void setConsentCollection(ConsentCollection consentCollection) {
        this.consentCollection = consentCollection;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setCurrencyConversion(CurrencyConversion currencyConversion) {
        this.currencyConversion = currencyConversion;
    }

    @Generated
    public void setCustomFields(List<CustomField> customFields) {
        this.customFields = customFields;
    }

    @Generated
    public void setCustomText(CustomText customText) {
        this.customText = customText;
    }

    @Generated
    public void setCustomerCreation(String customerCreation) {
        this.customerCreation = customerCreation;
    }

    @Generated
    public void setCustomerDetails(CustomerDetails customerDetails) {
        this.customerDetails = customerDetails;
    }

    @Generated
    public void setCustomerEmail(String customerEmail) {
        this.customerEmail = customerEmail;
    }

    @Generated
    public void setExpiresAt(Long expiresAt) {
        this.expiresAt = expiresAt;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setInvoiceCreation(InvoiceCreation invoiceCreation) {
        this.invoiceCreation = invoiceCreation;
    }

    @Generated
    public void setLineItems(LineItemCollection lineItems) {
        this.lineItems = lineItems;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setMode(String mode) {
        this.mode = mode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPaymentMethodCollection(String paymentMethodCollection) {
        this.paymentMethodCollection = paymentMethodCollection;
    }

    @Generated
    public void setPaymentMethodOptions(PaymentMethodOptions paymentMethodOptions) {
        this.paymentMethodOptions = paymentMethodOptions;
    }

    @Generated
    public void setPaymentMethodTypes(List<String> paymentMethodTypes) {
        this.paymentMethodTypes = paymentMethodTypes;
    }

    @Generated
    public void setPaymentStatus(String paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    @Generated
    public void setPhoneNumberCollection(PhoneNumberCollection phoneNumberCollection) {
        this.phoneNumberCollection = phoneNumberCollection;
    }

    @Generated
    public void setRecoveredFrom(String recoveredFrom) {
        this.recoveredFrom = recoveredFrom;
    }

    @Generated
    public void setShippingAddressCollection(ShippingAddressCollection shippingAddressCollection) {
        this.shippingAddressCollection = shippingAddressCollection;
    }

    @Generated
    public void setShippingCost(ShippingCost shippingCost) {
        this.shippingCost = shippingCost;
    }

    @Generated
    public void setShippingDetails(ShippingDetails shippingDetails) {
        this.shippingDetails = shippingDetails;
    }

    @Generated
    public void setShippingOptions(List<ShippingOption> shippingOptions) {
        this.shippingOptions = shippingOptions;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setSubmitType(String submitType) {
        this.submitType = submitType;
    }

    @Generated
    public void setSuccessUrl(String successUrl) {
        this.successUrl = successUrl;
    }

    @Generated
    public void setTaxIdCollection(TaxIdCollection taxIdCollection) {
        this.taxIdCollection = taxIdCollection;
    }

    @Generated
    public void setTotalDetails(TotalDetails totalDetails) {
        this.totalDetails = totalDetails;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Session)) {
            return false;
        }
        Session other = (Session)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$allowPromotionCodes = this.getAllowPromotionCodes();
        Boolean other$allowPromotionCodes = other.getAllowPromotionCodes();
        if (this$allowPromotionCodes == null ? other$allowPromotionCodes != null : !((Object)this$allowPromotionCodes).equals(other$allowPromotionCodes)) {
            return false;
        }
        Long this$amountSubtotal = this.getAmountSubtotal();
        Long other$amountSubtotal = other.getAmountSubtotal();
        if (this$amountSubtotal == null ? other$amountSubtotal != null : !((Object)this$amountSubtotal).equals(other$amountSubtotal)) {
            return false;
        }
        Long this$amountTotal = this.getAmountTotal();
        Long other$amountTotal = other.getAmountTotal();
        if (this$amountTotal == null ? other$amountTotal != null : !((Object)this$amountTotal).equals(other$amountTotal)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$expiresAt = this.getExpiresAt();
        Long other$expiresAt = other.getExpiresAt();
        if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        AfterExpiration this$afterExpiration = this.getAfterExpiration();
        AfterExpiration other$afterExpiration = other.getAfterExpiration();
        if (this$afterExpiration == null ? other$afterExpiration != null : !((Object)this$afterExpiration).equals(other$afterExpiration)) {
            return false;
        }
        AutomaticTax this$automaticTax = this.getAutomaticTax();
        AutomaticTax other$automaticTax = other.getAutomaticTax();
        if (this$automaticTax == null ? other$automaticTax != null : !((Object)this$automaticTax).equals(other$automaticTax)) {
            return false;
        }
        String this$billingAddressCollection = this.getBillingAddressCollection();
        String other$billingAddressCollection = other.getBillingAddressCollection();
        if (this$billingAddressCollection == null ? other$billingAddressCollection != null : !this$billingAddressCollection.equals(other$billingAddressCollection)) {
            return false;
        }
        String this$cancelUrl = this.getCancelUrl();
        String other$cancelUrl = other.getCancelUrl();
        if (this$cancelUrl == null ? other$cancelUrl != null : !this$cancelUrl.equals(other$cancelUrl)) {
            return false;
        }
        String this$clientReferenceId = this.getClientReferenceId();
        String other$clientReferenceId = other.getClientReferenceId();
        if (this$clientReferenceId == null ? other$clientReferenceId != null : !this$clientReferenceId.equals(other$clientReferenceId)) {
            return false;
        }
        Consent this$consent = this.getConsent();
        Consent other$consent = other.getConsent();
        if (this$consent == null ? other$consent != null : !((Object)this$consent).equals(other$consent)) {
            return false;
        }
        ConsentCollection this$consentCollection = this.getConsentCollection();
        ConsentCollection other$consentCollection = other.getConsentCollection();
        if (this$consentCollection == null ? other$consentCollection != null : !((Object)this$consentCollection).equals(other$consentCollection)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        CurrencyConversion this$currencyConversion = this.getCurrencyConversion();
        CurrencyConversion other$currencyConversion = other.getCurrencyConversion();
        if (this$currencyConversion == null ? other$currencyConversion != null : !((Object)this$currencyConversion).equals(other$currencyConversion)) {
            return false;
        }
        List<CustomField> this$customFields = this.getCustomFields();
        List<CustomField> other$customFields = other.getCustomFields();
        if (this$customFields == null ? other$customFields != null : !((Object)this$customFields).equals(other$customFields)) {
            return false;
        }
        CustomText this$customText = this.getCustomText();
        CustomText other$customText = other.getCustomText();
        if (this$customText == null ? other$customText != null : !((Object)this$customText).equals(other$customText)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        String this$customerCreation = this.getCustomerCreation();
        String other$customerCreation = other.getCustomerCreation();
        if (this$customerCreation == null ? other$customerCreation != null : !this$customerCreation.equals(other$customerCreation)) {
            return false;
        }
        CustomerDetails this$customerDetails = this.getCustomerDetails();
        CustomerDetails other$customerDetails = other.getCustomerDetails();
        if (this$customerDetails == null ? other$customerDetails != null : !((Object)this$customerDetails).equals(other$customerDetails)) {
            return false;
        }
        String this$customerEmail = this.getCustomerEmail();
        String other$customerEmail = other.getCustomerEmail();
        if (this$customerEmail == null ? other$customerEmail != null : !this$customerEmail.equals(other$customerEmail)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$invoice = this.getInvoice();
        String other$invoice = other.getInvoice();
        if (this$invoice == null ? other$invoice != null : !this$invoice.equals(other$invoice)) {
            return false;
        }
        InvoiceCreation this$invoiceCreation = this.getInvoiceCreation();
        InvoiceCreation other$invoiceCreation = other.getInvoiceCreation();
        if (this$invoiceCreation == null ? other$invoiceCreation != null : !((Object)this$invoiceCreation).equals(other$invoiceCreation)) {
            return false;
        }
        LineItemCollection this$lineItems = this.getLineItems();
        LineItemCollection other$lineItems = other.getLineItems();
        if (this$lineItems == null ? other$lineItems != null : !((Object)this$lineItems).equals(other$lineItems)) {
            return false;
        }
        String this$locale = this.getLocale();
        String other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$mode = this.getMode();
        String other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$paymentIntent = this.getPaymentIntent();
        String other$paymentIntent = other.getPaymentIntent();
        if (this$paymentIntent == null ? other$paymentIntent != null : !this$paymentIntent.equals(other$paymentIntent)) {
            return false;
        }
        String this$paymentLink = this.getPaymentLink();
        String other$paymentLink = other.getPaymentLink();
        if (this$paymentLink == null ? other$paymentLink != null : !this$paymentLink.equals(other$paymentLink)) {
            return false;
        }
        String this$paymentMethodCollection = this.getPaymentMethodCollection();
        String other$paymentMethodCollection = other.getPaymentMethodCollection();
        if (this$paymentMethodCollection == null ? other$paymentMethodCollection != null : !this$paymentMethodCollection.equals(other$paymentMethodCollection)) {
            return false;
        }
        PaymentMethodOptions this$paymentMethodOptions = this.getPaymentMethodOptions();
        PaymentMethodOptions other$paymentMethodOptions = other.getPaymentMethodOptions();
        if (this$paymentMethodOptions == null ? other$paymentMethodOptions != null : !((Object)this$paymentMethodOptions).equals(other$paymentMethodOptions)) {
            return false;
        }
        List<String> this$paymentMethodTypes = this.getPaymentMethodTypes();
        List<String> other$paymentMethodTypes = other.getPaymentMethodTypes();
        if (this$paymentMethodTypes == null ? other$paymentMethodTypes != null : !((Object)this$paymentMethodTypes).equals(other$paymentMethodTypes)) {
            return false;
        }
        String this$paymentStatus = this.getPaymentStatus();
        String other$paymentStatus = other.getPaymentStatus();
        if (this$paymentStatus == null ? other$paymentStatus != null : !this$paymentStatus.equals(other$paymentStatus)) {
            return false;
        }
        PhoneNumberCollection this$phoneNumberCollection = this.getPhoneNumberCollection();
        PhoneNumberCollection other$phoneNumberCollection = other.getPhoneNumberCollection();
        if (this$phoneNumberCollection == null ? other$phoneNumberCollection != null : !((Object)this$phoneNumberCollection).equals(other$phoneNumberCollection)) {
            return false;
        }
        String this$recoveredFrom = this.getRecoveredFrom();
        String other$recoveredFrom = other.getRecoveredFrom();
        if (this$recoveredFrom == null ? other$recoveredFrom != null : !this$recoveredFrom.equals(other$recoveredFrom)) {
            return false;
        }
        String this$setupIntent = this.getSetupIntent();
        String other$setupIntent = other.getSetupIntent();
        if (this$setupIntent == null ? other$setupIntent != null : !this$setupIntent.equals(other$setupIntent)) {
            return false;
        }
        ShippingAddressCollection this$shippingAddressCollection = this.getShippingAddressCollection();
        ShippingAddressCollection other$shippingAddressCollection = other.getShippingAddressCollection();
        if (this$shippingAddressCollection == null ? other$shippingAddressCollection != null : !((Object)this$shippingAddressCollection).equals(other$shippingAddressCollection)) {
            return false;
        }
        ShippingCost this$shippingCost = this.getShippingCost();
        ShippingCost other$shippingCost = other.getShippingCost();
        if (this$shippingCost == null ? other$shippingCost != null : !((Object)this$shippingCost).equals(other$shippingCost)) {
            return false;
        }
        ShippingDetails this$shippingDetails = this.getShippingDetails();
        ShippingDetails other$shippingDetails = other.getShippingDetails();
        if (this$shippingDetails == null ? other$shippingDetails != null : !((Object)this$shippingDetails).equals(other$shippingDetails)) {
            return false;
        }
        List<ShippingOption> this$shippingOptions = this.getShippingOptions();
        List<ShippingOption> other$shippingOptions = other.getShippingOptions();
        if (this$shippingOptions == null ? other$shippingOptions != null : !((Object)this$shippingOptions).equals(other$shippingOptions)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$submitType = this.getSubmitType();
        String other$submitType = other.getSubmitType();
        if (this$submitType == null ? other$submitType != null : !this$submitType.equals(other$submitType)) {
            return false;
        }
        String this$subscription = this.getSubscription();
        String other$subscription = other.getSubscription();
        if (this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription)) {
            return false;
        }
        String this$successUrl = this.getSuccessUrl();
        String other$successUrl = other.getSuccessUrl();
        if (this$successUrl == null ? other$successUrl != null : !this$successUrl.equals(other$successUrl)) {
            return false;
        }
        TaxIdCollection this$taxIdCollection = this.getTaxIdCollection();
        TaxIdCollection other$taxIdCollection = other.getTaxIdCollection();
        if (this$taxIdCollection == null ? other$taxIdCollection != null : !((Object)this$taxIdCollection).equals(other$taxIdCollection)) {
            return false;
        }
        TotalDetails this$totalDetails = this.getTotalDetails();
        TotalDetails other$totalDetails = other.getTotalDetails();
        if (this$totalDetails == null ? other$totalDetails != null : !((Object)this$totalDetails).equals(other$totalDetails)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Session;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $allowPromotionCodes = this.getAllowPromotionCodes();
        result = result * 59 + ($allowPromotionCodes == null ? 43 : ((Object)$allowPromotionCodes).hashCode());
        Long $amountSubtotal = this.getAmountSubtotal();
        result = result * 59 + ($amountSubtotal == null ? 43 : ((Object)$amountSubtotal).hashCode());
        Long $amountTotal = this.getAmountTotal();
        result = result * 59 + ($amountTotal == null ? 43 : ((Object)$amountTotal).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $expiresAt = this.getExpiresAt();
        result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        AfterExpiration $afterExpiration = this.getAfterExpiration();
        result = result * 59 + ($afterExpiration == null ? 43 : ((Object)$afterExpiration).hashCode());
        AutomaticTax $automaticTax = this.getAutomaticTax();
        result = result * 59 + ($automaticTax == null ? 43 : ((Object)$automaticTax).hashCode());
        String $billingAddressCollection = this.getBillingAddressCollection();
        result = result * 59 + ($billingAddressCollection == null ? 43 : $billingAddressCollection.hashCode());
        String $cancelUrl = this.getCancelUrl();
        result = result * 59 + ($cancelUrl == null ? 43 : $cancelUrl.hashCode());
        String $clientReferenceId = this.getClientReferenceId();
        result = result * 59 + ($clientReferenceId == null ? 43 : $clientReferenceId.hashCode());
        Consent $consent = this.getConsent();
        result = result * 59 + ($consent == null ? 43 : ((Object)$consent).hashCode());
        ConsentCollection $consentCollection = this.getConsentCollection();
        result = result * 59 + ($consentCollection == null ? 43 : ((Object)$consentCollection).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        CurrencyConversion $currencyConversion = this.getCurrencyConversion();
        result = result * 59 + ($currencyConversion == null ? 43 : ((Object)$currencyConversion).hashCode());
        List<CustomField> $customFields = this.getCustomFields();
        result = result * 59 + ($customFields == null ? 43 : ((Object)$customFields).hashCode());
        CustomText $customText = this.getCustomText();
        result = result * 59 + ($customText == null ? 43 : ((Object)$customText).hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        String $customerCreation = this.getCustomerCreation();
        result = result * 59 + ($customerCreation == null ? 43 : $customerCreation.hashCode());
        CustomerDetails $customerDetails = this.getCustomerDetails();
        result = result * 59 + ($customerDetails == null ? 43 : ((Object)$customerDetails).hashCode());
        String $customerEmail = this.getCustomerEmail();
        result = result * 59 + ($customerEmail == null ? 43 : $customerEmail.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $invoice = this.getInvoice();
        result = result * 59 + ($invoice == null ? 43 : $invoice.hashCode());
        InvoiceCreation $invoiceCreation = this.getInvoiceCreation();
        result = result * 59 + ($invoiceCreation == null ? 43 : ((Object)$invoiceCreation).hashCode());
        LineItemCollection $lineItems = this.getLineItems();
        result = result * 59 + ($lineItems == null ? 43 : ((Object)$lineItems).hashCode());
        String $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $paymentIntent = this.getPaymentIntent();
        result = result * 59 + ($paymentIntent == null ? 43 : $paymentIntent.hashCode());
        String $paymentLink = this.getPaymentLink();
        result = result * 59 + ($paymentLink == null ? 43 : $paymentLink.hashCode());
        String $paymentMethodCollection = this.getPaymentMethodCollection();
        result = result * 59 + ($paymentMethodCollection == null ? 43 : $paymentMethodCollection.hashCode());
        PaymentMethodOptions $paymentMethodOptions = this.getPaymentMethodOptions();
        result = result * 59 + ($paymentMethodOptions == null ? 43 : ((Object)$paymentMethodOptions).hashCode());
        List<String> $paymentMethodTypes = this.getPaymentMethodTypes();
        result = result * 59 + ($paymentMethodTypes == null ? 43 : ((Object)$paymentMethodTypes).hashCode());
        String $paymentStatus = this.getPaymentStatus();
        result = result * 59 + ($paymentStatus == null ? 43 : $paymentStatus.hashCode());
        PhoneNumberCollection $phoneNumberCollection = this.getPhoneNumberCollection();
        result = result * 59 + ($phoneNumberCollection == null ? 43 : ((Object)$phoneNumberCollection).hashCode());
        String $recoveredFrom = this.getRecoveredFrom();
        result = result * 59 + ($recoveredFrom == null ? 43 : $recoveredFrom.hashCode());
        String $setupIntent = this.getSetupIntent();
        result = result * 59 + ($setupIntent == null ? 43 : $setupIntent.hashCode());
        ShippingAddressCollection $shippingAddressCollection = this.getShippingAddressCollection();
        result = result * 59 + ($shippingAddressCollection == null ? 43 : ((Object)$shippingAddressCollection).hashCode());
        ShippingCost $shippingCost = this.getShippingCost();
        result = result * 59 + ($shippingCost == null ? 43 : ((Object)$shippingCost).hashCode());
        ShippingDetails $shippingDetails = this.getShippingDetails();
        result = result * 59 + ($shippingDetails == null ? 43 : ((Object)$shippingDetails).hashCode());
        List<ShippingOption> $shippingOptions = this.getShippingOptions();
        result = result * 59 + ($shippingOptions == null ? 43 : ((Object)$shippingOptions).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $submitType = this.getSubmitType();
        result = result * 59 + ($submitType == null ? 43 : $submitType.hashCode());
        String $subscription = this.getSubscription();
        result = result * 59 + ($subscription == null ? 43 : $subscription.hashCode());
        String $successUrl = this.getSuccessUrl();
        result = result * 59 + ($successUrl == null ? 43 : $successUrl.hashCode());
        TaxIdCollection $taxIdCollection = this.getTaxIdCollection();
        result = result * 59 + ($taxIdCollection == null ? 43 : ((Object)$taxIdCollection).hashCode());
        TotalDetails $totalDetails = this.getTotalDetails();
        result = result * 59 + ($totalDetails == null ? 43 : ((Object)$totalDetails).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class AfterExpiration
    extends StripeObject {
        @SerializedName(value="recovery")
        Recovery recovery;

        @Generated
        public Recovery getRecovery() {
            return this.recovery;
        }

        @Generated
        public void setRecovery(Recovery recovery) {
            this.recovery = recovery;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AfterExpiration)) {
                return false;
            }
            AfterExpiration other = (AfterExpiration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Recovery this$recovery = this.getRecovery();
            Recovery other$recovery = other.getRecovery();
            return !(this$recovery == null ? other$recovery != null : !((Object)this$recovery).equals(other$recovery));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AfterExpiration;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Recovery $recovery = this.getRecovery();
            result = result * 59 + ($recovery == null ? 43 : ((Object)$recovery).hashCode());
            return result;
        }

        public static class Recovery
        extends StripeObject {
            @SerializedName(value="allow_promotion_codes")
            Boolean allowPromotionCodes;
            @SerializedName(value="enabled")
            Boolean enabled;
            @SerializedName(value="expires_at")
            Long expiresAt;
            @SerializedName(value="url")
            String url;

            @Generated
            public Boolean getAllowPromotionCodes() {
                return this.allowPromotionCodes;
            }

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public Long getExpiresAt() {
                return this.expiresAt;
            }

            @Generated
            public String getUrl() {
                return this.url;
            }

            @Generated
            public void setAllowPromotionCodes(Boolean allowPromotionCodes) {
                this.allowPromotionCodes = allowPromotionCodes;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public void setExpiresAt(Long expiresAt) {
                this.expiresAt = expiresAt;
            }

            @Generated
            public void setUrl(String url) {
                this.url = url;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Recovery)) {
                    return false;
                }
                Recovery other = (Recovery)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$allowPromotionCodes = this.getAllowPromotionCodes();
                Boolean other$allowPromotionCodes = other.getAllowPromotionCodes();
                if (this$allowPromotionCodes == null ? other$allowPromotionCodes != null : !((Object)this$allowPromotionCodes).equals(other$allowPromotionCodes)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                    return false;
                }
                Long this$expiresAt = this.getExpiresAt();
                Long other$expiresAt = other.getExpiresAt();
                if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
                    return false;
                }
                String this$url = this.getUrl();
                String other$url = other.getUrl();
                return !(this$url == null ? other$url != null : !this$url.equals(other$url));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Recovery;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $allowPromotionCodes = this.getAllowPromotionCodes();
                result = result * 59 + ($allowPromotionCodes == null ? 43 : ((Object)$allowPromotionCodes).hashCode());
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                Long $expiresAt = this.getExpiresAt();
                result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
                String $url = this.getUrl();
                result = result * 59 + ($url == null ? 43 : $url.hashCode());
                return result;
            }
        }
    }

    public static class AutomaticTax
    extends StripeObject {
        @SerializedName(value="enabled")
        Boolean enabled;
        @SerializedName(value="status")
        String status;

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AutomaticTax)) {
                return false;
            }
            AutomaticTax other = (AutomaticTax)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !this$status.equals(other$status));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AutomaticTax;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            return result;
        }
    }

    public static class Consent
    extends StripeObject {
        @SerializedName(value="promotions")
        String promotions;
        @SerializedName(value="terms_of_service")
        String termsOfService;

        @Generated
        public String getPromotions() {
            return this.promotions;
        }

        @Generated
        public String getTermsOfService() {
            return this.termsOfService;
        }

        @Generated
        public void setPromotions(String promotions) {
            this.promotions = promotions;
        }

        @Generated
        public void setTermsOfService(String termsOfService) {
            this.termsOfService = termsOfService;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Consent)) {
                return false;
            }
            Consent other = (Consent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$promotions = this.getPromotions();
            String other$promotions = other.getPromotions();
            if (this$promotions == null ? other$promotions != null : !this$promotions.equals(other$promotions)) {
                return false;
            }
            String this$termsOfService = this.getTermsOfService();
            String other$termsOfService = other.getTermsOfService();
            return !(this$termsOfService == null ? other$termsOfService != null : !this$termsOfService.equals(other$termsOfService));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Consent;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $promotions = this.getPromotions();
            result = result * 59 + ($promotions == null ? 43 : $promotions.hashCode());
            String $termsOfService = this.getTermsOfService();
            result = result * 59 + ($termsOfService == null ? 43 : $termsOfService.hashCode());
            return result;
        }
    }

    public static class ConsentCollection
    extends StripeObject {
        @SerializedName(value="promotions")
        String promotions;
        @SerializedName(value="terms_of_service")
        String termsOfService;

        @Generated
        public String getPromotions() {
            return this.promotions;
        }

        @Generated
        public String getTermsOfService() {
            return this.termsOfService;
        }

        @Generated
        public void setPromotions(String promotions) {
            this.promotions = promotions;
        }

        @Generated
        public void setTermsOfService(String termsOfService) {
            this.termsOfService = termsOfService;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConsentCollection)) {
                return false;
            }
            ConsentCollection other = (ConsentCollection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$promotions = this.getPromotions();
            String other$promotions = other.getPromotions();
            if (this$promotions == null ? other$promotions != null : !this$promotions.equals(other$promotions)) {
                return false;
            }
            String this$termsOfService = this.getTermsOfService();
            String other$termsOfService = other.getTermsOfService();
            return !(this$termsOfService == null ? other$termsOfService != null : !this$termsOfService.equals(other$termsOfService));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ConsentCollection;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $promotions = this.getPromotions();
            result = result * 59 + ($promotions == null ? 43 : $promotions.hashCode());
            String $termsOfService = this.getTermsOfService();
            result = result * 59 + ($termsOfService == null ? 43 : $termsOfService.hashCode());
            return result;
        }
    }

    public static class CurrencyConversion
    extends StripeObject {
        @SerializedName(value="amount_subtotal")
        Long amountSubtotal;
        @SerializedName(value="amount_total")
        Long amountTotal;
        @SerializedName(value="fx_rate")
        BigDecimal fxRate;
        @SerializedName(value="source_currency")
        String sourceCurrency;

        @Generated
        public Long getAmountSubtotal() {
            return this.amountSubtotal;
        }

        @Generated
        public Long getAmountTotal() {
            return this.amountTotal;
        }

        @Generated
        public BigDecimal getFxRate() {
            return this.fxRate;
        }

        @Generated
        public String getSourceCurrency() {
            return this.sourceCurrency;
        }

        @Generated
        public void setAmountSubtotal(Long amountSubtotal) {
            this.amountSubtotal = amountSubtotal;
        }

        @Generated
        public void setAmountTotal(Long amountTotal) {
            this.amountTotal = amountTotal;
        }

        @Generated
        public void setFxRate(BigDecimal fxRate) {
            this.fxRate = fxRate;
        }

        @Generated
        public void setSourceCurrency(String sourceCurrency) {
            this.sourceCurrency = sourceCurrency;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CurrencyConversion)) {
                return false;
            }
            CurrencyConversion other = (CurrencyConversion)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amountSubtotal = this.getAmountSubtotal();
            Long other$amountSubtotal = other.getAmountSubtotal();
            if (this$amountSubtotal == null ? other$amountSubtotal != null : !((Object)this$amountSubtotal).equals(other$amountSubtotal)) {
                return false;
            }
            Long this$amountTotal = this.getAmountTotal();
            Long other$amountTotal = other.getAmountTotal();
            if (this$amountTotal == null ? other$amountTotal != null : !((Object)this$amountTotal).equals(other$amountTotal)) {
                return false;
            }
            BigDecimal this$fxRate = this.getFxRate();
            BigDecimal other$fxRate = other.getFxRate();
            if (this$fxRate == null ? other$fxRate != null : !((Object)this$fxRate).equals(other$fxRate)) {
                return false;
            }
            String this$sourceCurrency = this.getSourceCurrency();
            String other$sourceCurrency = other.getSourceCurrency();
            return !(this$sourceCurrency == null ? other$sourceCurrency != null : !this$sourceCurrency.equals(other$sourceCurrency));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CurrencyConversion;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amountSubtotal = this.getAmountSubtotal();
            result = result * 59 + ($amountSubtotal == null ? 43 : ((Object)$amountSubtotal).hashCode());
            Long $amountTotal = this.getAmountTotal();
            result = result * 59 + ($amountTotal == null ? 43 : ((Object)$amountTotal).hashCode());
            BigDecimal $fxRate = this.getFxRate();
            result = result * 59 + ($fxRate == null ? 43 : ((Object)$fxRate).hashCode());
            String $sourceCurrency = this.getSourceCurrency();
            result = result * 59 + ($sourceCurrency == null ? 43 : $sourceCurrency.hashCode());
            return result;
        }
    }

    public static class CustomText
    extends StripeObject {
        @SerializedName(value="shipping_address")
        ShippingAddress shippingAddress;
        @SerializedName(value="submit")
        Submit submit;

        @Generated
        public ShippingAddress getShippingAddress() {
            return this.shippingAddress;
        }

        @Generated
        public Submit getSubmit() {
            return this.submit;
        }

        @Generated
        public void setShippingAddress(ShippingAddress shippingAddress) {
            this.shippingAddress = shippingAddress;
        }

        @Generated
        public void setSubmit(Submit submit) {
            this.submit = submit;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomText)) {
                return false;
            }
            CustomText other = (CustomText)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ShippingAddress this$shippingAddress = this.getShippingAddress();
            ShippingAddress other$shippingAddress = other.getShippingAddress();
            if (this$shippingAddress == null ? other$shippingAddress != null : !((Object)this$shippingAddress).equals(other$shippingAddress)) {
                return false;
            }
            Submit this$submit = this.getSubmit();
            Submit other$submit = other.getSubmit();
            return !(this$submit == null ? other$submit != null : !((Object)this$submit).equals(other$submit));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CustomText;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ShippingAddress $shippingAddress = this.getShippingAddress();
            result = result * 59 + ($shippingAddress == null ? 43 : ((Object)$shippingAddress).hashCode());
            Submit $submit = this.getSubmit();
            result = result * 59 + ($submit == null ? 43 : ((Object)$submit).hashCode());
            return result;
        }

        public static class ShippingAddress
        extends StripeObject {
            @SerializedName(value="message")
            String message;

            @Generated
            public String getMessage() {
                return this.message;
            }

            @Generated
            public void setMessage(String message) {
                this.message = message;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ShippingAddress)) {
                    return false;
                }
                ShippingAddress other = (ShippingAddress)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$message = this.getMessage();
                String other$message = other.getMessage();
                return !(this$message == null ? other$message != null : !this$message.equals(other$message));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ShippingAddress;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $message = this.getMessage();
                result = result * 59 + ($message == null ? 43 : $message.hashCode());
                return result;
            }
        }

        public static class Submit
        extends StripeObject {
            @SerializedName(value="message")
            String message;

            @Generated
            public String getMessage() {
                return this.message;
            }

            @Generated
            public void setMessage(String message) {
                this.message = message;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Submit)) {
                    return false;
                }
                Submit other = (Submit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$message = this.getMessage();
                String other$message = other.getMessage();
                return !(this$message == null ? other$message != null : !this$message.equals(other$message));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Submit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $message = this.getMessage();
                result = result * 59 + ($message == null ? 43 : $message.hashCode());
                return result;
            }
        }
    }

    public static class CustomerDetails
    extends StripeObject {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="email")
        String email;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="phone")
        String phone;
        @SerializedName(value="tax_exempt")
        String taxExempt;
        @SerializedName(value="tax_ids")
        List<TaxId> taxIds;

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getPhone() {
            return this.phone;
        }

        @Generated
        public String getTaxExempt() {
            return this.taxExempt;
        }

        @Generated
        public List<TaxId> getTaxIds() {
            return this.taxIds;
        }

        @Generated
        public void setAddress(Address address) {
            this.address = address;
        }

        @Generated
        public void setEmail(String email) {
            this.email = email;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setPhone(String phone) {
            this.phone = phone;
        }

        @Generated
        public void setTaxExempt(String taxExempt) {
            this.taxExempt = taxExempt;
        }

        @Generated
        public void setTaxIds(List<TaxId> taxIds) {
            this.taxIds = taxIds;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomerDetails)) {
                return false;
            }
            CustomerDetails other = (CustomerDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Address this$address = this.getAddress();
            Address other$address = other.getAddress();
            if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$phone = this.getPhone();
            String other$phone = other.getPhone();
            if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
                return false;
            }
            String this$taxExempt = this.getTaxExempt();
            String other$taxExempt = other.getTaxExempt();
            if (this$taxExempt == null ? other$taxExempt != null : !this$taxExempt.equals(other$taxExempt)) {
                return false;
            }
            List<TaxId> this$taxIds = this.getTaxIds();
            List<TaxId> other$taxIds = other.getTaxIds();
            return !(this$taxIds == null ? other$taxIds != null : !((Object)this$taxIds).equals(other$taxIds));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CustomerDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Address $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $phone = this.getPhone();
            result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
            String $taxExempt = this.getTaxExempt();
            result = result * 59 + ($taxExempt == null ? 43 : $taxExempt.hashCode());
            List<TaxId> $taxIds = this.getTaxIds();
            result = result * 59 + ($taxIds == null ? 43 : ((Object)$taxIds).hashCode());
            return result;
        }

        public static class TaxId
        extends StripeObject {
            @SerializedName(value="type")
            String type;
            @SerializedName(value="value")
            String value;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TaxId)) {
                    return false;
                }
                TaxId other = (TaxId)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof TaxId;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class InvoiceCreation
    extends StripeObject {
        @SerializedName(value="enabled")
        Boolean enabled;
        @SerializedName(value="invoice_data")
        InvoiceData invoiceData;

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public InvoiceData getInvoiceData() {
            return this.invoiceData;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setInvoiceData(InvoiceData invoiceData) {
            this.invoiceData = invoiceData;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InvoiceCreation)) {
                return false;
            }
            InvoiceCreation other = (InvoiceCreation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                return false;
            }
            InvoiceData this$invoiceData = this.getInvoiceData();
            InvoiceData other$invoiceData = other.getInvoiceData();
            return !(this$invoiceData == null ? other$invoiceData != null : !((Object)this$invoiceData).equals(other$invoiceData));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InvoiceCreation;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            InvoiceData $invoiceData = this.getInvoiceData();
            result = result * 59 + ($invoiceData == null ? 43 : ((Object)$invoiceData).hashCode());
            return result;
        }

        public static class InvoiceData
        extends StripeObject {
            @SerializedName(value="account_tax_ids")
            List<ExpandableField<TaxId>> accountTaxIds;
            @SerializedName(value="custom_fields")
            List<CustomField> customFields;
            @SerializedName(value="description")
            String description;
            @SerializedName(value="footer")
            String footer;
            @SerializedName(value="metadata")
            Map<String, String> metadata;
            @SerializedName(value="rendering_options")
            RenderingOptions renderingOptions;

            public List<String> getAccountTaxIds() {
                return this.accountTaxIds != null ? this.accountTaxIds.stream().map(x -> x.getId()).collect(Collectors.toList()) : null;
            }

            public void setAccountTaxIds(List<String> ids) {
                if (ids == null) {
                    this.accountTaxIds = null;
                    return;
                }
                if (this.accountTaxIds != null && this.accountTaxIds.stream().map(x -> x.getId()).collect(Collectors.toList()).equals(ids)) {
                    return;
                }
                this.accountTaxIds = ids != null ? ids.stream().map(id -> new ExpandableField<Object>((String)id, null)).collect(Collectors.toList()) : null;
            }

            public List<TaxId> getAccountTaxIdObjects() {
                return this.accountTaxIds != null ? this.accountTaxIds.stream().map(x -> (TaxId)x.getExpanded()).collect(Collectors.toList()) : null;
            }

            public void setAccountTaxIdObjects(List<TaxId> objs) {
                this.accountTaxIds = objs != null ? objs.stream().map(x -> new ExpandableField<TaxId>(x.getId(), (TaxId)x)).collect(Collectors.toList()) : null;
            }

            @Generated
            public List<CustomField> getCustomFields() {
                return this.customFields;
            }

            @Generated
            public String getDescription() {
                return this.description;
            }

            @Generated
            public String getFooter() {
                return this.footer;
            }

            @Generated
            public Map<String, String> getMetadata() {
                return this.metadata;
            }

            @Generated
            public RenderingOptions getRenderingOptions() {
                return this.renderingOptions;
            }

            @Generated
            public void setCustomFields(List<CustomField> customFields) {
                this.customFields = customFields;
            }

            @Generated
            public void setDescription(String description) {
                this.description = description;
            }

            @Generated
            public void setFooter(String footer) {
                this.footer = footer;
            }

            @Generated
            public void setMetadata(Map<String, String> metadata) {
                this.metadata = metadata;
            }

            @Generated
            public void setRenderingOptions(RenderingOptions renderingOptions) {
                this.renderingOptions = renderingOptions;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof InvoiceData)) {
                    return false;
                }
                InvoiceData other = (InvoiceData)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<String> this$accountTaxIds = this.getAccountTaxIds();
                List<String> other$accountTaxIds = other.getAccountTaxIds();
                if (this$accountTaxIds == null ? other$accountTaxIds != null : !((Object)this$accountTaxIds).equals(other$accountTaxIds)) {
                    return false;
                }
                List<CustomField> this$customFields = this.getCustomFields();
                List<CustomField> other$customFields = other.getCustomFields();
                if (this$customFields == null ? other$customFields != null : !((Object)this$customFields).equals(other$customFields)) {
                    return false;
                }
                String this$description = this.getDescription();
                String other$description = other.getDescription();
                if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                    return false;
                }
                String this$footer = this.getFooter();
                String other$footer = other.getFooter();
                if (this$footer == null ? other$footer != null : !this$footer.equals(other$footer)) {
                    return false;
                }
                Map<String, String> this$metadata = this.getMetadata();
                Map<String, String> other$metadata = other.getMetadata();
                if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
                    return false;
                }
                RenderingOptions this$renderingOptions = this.getRenderingOptions();
                RenderingOptions other$renderingOptions = other.getRenderingOptions();
                return !(this$renderingOptions == null ? other$renderingOptions != null : !((Object)this$renderingOptions).equals(other$renderingOptions));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof InvoiceData;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<String> $accountTaxIds = this.getAccountTaxIds();
                result = result * 59 + ($accountTaxIds == null ? 43 : ((Object)$accountTaxIds).hashCode());
                List<CustomField> $customFields = this.getCustomFields();
                result = result * 59 + ($customFields == null ? 43 : ((Object)$customFields).hashCode());
                String $description = this.getDescription();
                result = result * 59 + ($description == null ? 43 : $description.hashCode());
                String $footer = this.getFooter();
                result = result * 59 + ($footer == null ? 43 : $footer.hashCode());
                Map<String, String> $metadata = this.getMetadata();
                result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
                RenderingOptions $renderingOptions = this.getRenderingOptions();
                result = result * 59 + ($renderingOptions == null ? 43 : ((Object)$renderingOptions).hashCode());
                return result;
            }

            public static class RenderingOptions
            extends StripeObject {
                @SerializedName(value="amount_tax_display")
                String amountTaxDisplay;

                @Generated
                public String getAmountTaxDisplay() {
                    return this.amountTaxDisplay;
                }

                @Generated
                public void setAmountTaxDisplay(String amountTaxDisplay) {
                    this.amountTaxDisplay = amountTaxDisplay;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof RenderingOptions)) {
                        return false;
                    }
                    RenderingOptions other = (RenderingOptions)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$amountTaxDisplay = this.getAmountTaxDisplay();
                    String other$amountTaxDisplay = other.getAmountTaxDisplay();
                    return !(this$amountTaxDisplay == null ? other$amountTaxDisplay != null : !this$amountTaxDisplay.equals(other$amountTaxDisplay));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof RenderingOptions;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $amountTaxDisplay = this.getAmountTaxDisplay();
                    result = result * 59 + ($amountTaxDisplay == null ? 43 : $amountTaxDisplay.hashCode());
                    return result;
                }
            }

            public static class CustomField
            extends StripeObject {
                @SerializedName(value="name")
                String name;
                @SerializedName(value="value")
                String value;

                @Generated
                public String getName() {
                    return this.name;
                }

                @Generated
                public String getValue() {
                    return this.value;
                }

                @Generated
                public void setName(String name) {
                    this.name = name;
                }

                @Generated
                public void setValue(String value) {
                    this.value = value;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof CustomField)) {
                        return false;
                    }
                    CustomField other = (CustomField)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$name = this.getName();
                    String other$name = other.getName();
                    if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                        return false;
                    }
                    String this$value = this.getValue();
                    String other$value = other.getValue();
                    return !(this$value == null ? other$value != null : !this$value.equals(other$value));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof CustomField;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $name = this.getName();
                    result = result * 59 + ($name == null ? 43 : $name.hashCode());
                    String $value = this.getValue();
                    result = result * 59 + ($value == null ? 43 : $value.hashCode());
                    return result;
                }
            }
        }
    }

    public static class PaymentMethodOptions
    extends StripeObject {
        @SerializedName(value="acss_debit")
        AcssDebit acssDebit;
        @SerializedName(value="affirm")
        Affirm affirm;
        @SerializedName(value="afterpay_clearpay")
        AfterpayClearpay afterpayClearpay;
        @SerializedName(value="alipay")
        Alipay alipay;
        @SerializedName(value="au_becs_debit")
        AuBecsDebit auBecsDebit;
        @SerializedName(value="bacs_debit")
        BacsDebit bacsDebit;
        @SerializedName(value="bancontact")
        Bancontact bancontact;
        @SerializedName(value="boleto")
        Boleto boleto;
        @SerializedName(value="card")
        Card card;
        @SerializedName(value="cashapp")
        Cashapp cashapp;
        @SerializedName(value="customer_balance")
        CustomerBalance customerBalance;
        @SerializedName(value="eps")
        Eps eps;
        @SerializedName(value="fpx")
        Fpx fpx;
        @SerializedName(value="giropay")
        Giropay giropay;
        @SerializedName(value="grabpay")
        Grabpay grabpay;
        @SerializedName(value="ideal")
        Ideal ideal;
        @SerializedName(value="klarna")
        Klarna klarna;
        @SerializedName(value="konbini")
        Konbini konbini;
        @SerializedName(value="link")
        Link link;
        @SerializedName(value="oxxo")
        Oxxo oxxo;
        @SerializedName(value="p24")
        P24 p24;
        @SerializedName(value="paynow")
        Paynow paynow;
        @SerializedName(value="pix")
        Pix pix;
        @SerializedName(value="sepa_debit")
        SepaDebit sepaDebit;
        @SerializedName(value="sofort")
        Sofort sofort;
        @SerializedName(value="us_bank_account")
        UsBankAccount usBankAccount;

        @Generated
        public AcssDebit getAcssDebit() {
            return this.acssDebit;
        }

        @Generated
        public Affirm getAffirm() {
            return this.affirm;
        }

        @Generated
        public AfterpayClearpay getAfterpayClearpay() {
            return this.afterpayClearpay;
        }

        @Generated
        public Alipay getAlipay() {
            return this.alipay;
        }

        @Generated
        public AuBecsDebit getAuBecsDebit() {
            return this.auBecsDebit;
        }

        @Generated
        public BacsDebit getBacsDebit() {
            return this.bacsDebit;
        }

        @Generated
        public Bancontact getBancontact() {
            return this.bancontact;
        }

        @Generated
        public Boleto getBoleto() {
            return this.boleto;
        }

        @Generated
        public Card getCard() {
            return this.card;
        }

        @Generated
        public Cashapp getCashapp() {
            return this.cashapp;
        }

        @Generated
        public CustomerBalance getCustomerBalance() {
            return this.customerBalance;
        }

        @Generated
        public Eps getEps() {
            return this.eps;
        }

        @Generated
        public Fpx getFpx() {
            return this.fpx;
        }

        @Generated
        public Giropay getGiropay() {
            return this.giropay;
        }

        @Generated
        public Grabpay getGrabpay() {
            return this.grabpay;
        }

        @Generated
        public Ideal getIdeal() {
            return this.ideal;
        }

        @Generated
        public Klarna getKlarna() {
            return this.klarna;
        }

        @Generated
        public Konbini getKonbini() {
            return this.konbini;
        }

        @Generated
        public Link getLink() {
            return this.link;
        }

        @Generated
        public Oxxo getOxxo() {
            return this.oxxo;
        }

        @Generated
        public P24 getP24() {
            return this.p24;
        }

        @Generated
        public Paynow getPaynow() {
            return this.paynow;
        }

        @Generated
        public Pix getPix() {
            return this.pix;
        }

        @Generated
        public SepaDebit getSepaDebit() {
            return this.sepaDebit;
        }

        @Generated
        public Sofort getSofort() {
            return this.sofort;
        }

        @Generated
        public UsBankAccount getUsBankAccount() {
            return this.usBankAccount;
        }

        @Generated
        public void setAcssDebit(AcssDebit acssDebit) {
            this.acssDebit = acssDebit;
        }

        @Generated
        public void setAffirm(Affirm affirm) {
            this.affirm = affirm;
        }

        @Generated
        public void setAfterpayClearpay(AfterpayClearpay afterpayClearpay) {
            this.afterpayClearpay = afterpayClearpay;
        }

        @Generated
        public void setAlipay(Alipay alipay) {
            this.alipay = alipay;
        }

        @Generated
        public void setAuBecsDebit(AuBecsDebit auBecsDebit) {
            this.auBecsDebit = auBecsDebit;
        }

        @Generated
        public void setBacsDebit(BacsDebit bacsDebit) {
            this.bacsDebit = bacsDebit;
        }

        @Generated
        public void setBancontact(Bancontact bancontact) {
            this.bancontact = bancontact;
        }

        @Generated
        public void setBoleto(Boleto boleto) {
            this.boleto = boleto;
        }

        @Generated
        public void setCard(Card card) {
            this.card = card;
        }

        @Generated
        public void setCashapp(Cashapp cashapp) {
            this.cashapp = cashapp;
        }

        @Generated
        public void setCustomerBalance(CustomerBalance customerBalance) {
            this.customerBalance = customerBalance;
        }

        @Generated
        public void setEps(Eps eps) {
            this.eps = eps;
        }

        @Generated
        public void setFpx(Fpx fpx) {
            this.fpx = fpx;
        }

        @Generated
        public void setGiropay(Giropay giropay) {
            this.giropay = giropay;
        }

        @Generated
        public void setGrabpay(Grabpay grabpay) {
            this.grabpay = grabpay;
        }

        @Generated
        public void setIdeal(Ideal ideal) {
            this.ideal = ideal;
        }

        @Generated
        public void setKlarna(Klarna klarna) {
            this.klarna = klarna;
        }

        @Generated
        public void setKonbini(Konbini konbini) {
            this.konbini = konbini;
        }

        @Generated
        public void setLink(Link link) {
            this.link = link;
        }

        @Generated
        public void setOxxo(Oxxo oxxo) {
            this.oxxo = oxxo;
        }

        @Generated
        public void setP24(P24 p24) {
            this.p24 = p24;
        }

        @Generated
        public void setPaynow(Paynow paynow) {
            this.paynow = paynow;
        }

        @Generated
        public void setPix(Pix pix) {
            this.pix = pix;
        }

        @Generated
        public void setSepaDebit(SepaDebit sepaDebit) {
            this.sepaDebit = sepaDebit;
        }

        @Generated
        public void setSofort(Sofort sofort) {
            this.sofort = sofort;
        }

        @Generated
        public void setUsBankAccount(UsBankAccount usBankAccount) {
            this.usBankAccount = usBankAccount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentMethodOptions)) {
                return false;
            }
            PaymentMethodOptions other = (PaymentMethodOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AcssDebit this$acssDebit = this.getAcssDebit();
            AcssDebit other$acssDebit = other.getAcssDebit();
            if (this$acssDebit == null ? other$acssDebit != null : !((Object)this$acssDebit).equals(other$acssDebit)) {
                return false;
            }
            Affirm this$affirm = this.getAffirm();
            Affirm other$affirm = other.getAffirm();
            if (this$affirm == null ? other$affirm != null : !((Object)this$affirm).equals(other$affirm)) {
                return false;
            }
            AfterpayClearpay this$afterpayClearpay = this.getAfterpayClearpay();
            AfterpayClearpay other$afterpayClearpay = other.getAfterpayClearpay();
            if (this$afterpayClearpay == null ? other$afterpayClearpay != null : !((Object)this$afterpayClearpay).equals(other$afterpayClearpay)) {
                return false;
            }
            Alipay this$alipay = this.getAlipay();
            Alipay other$alipay = other.getAlipay();
            if (this$alipay == null ? other$alipay != null : !((Object)this$alipay).equals(other$alipay)) {
                return false;
            }
            AuBecsDebit this$auBecsDebit = this.getAuBecsDebit();
            AuBecsDebit other$auBecsDebit = other.getAuBecsDebit();
            if (this$auBecsDebit == null ? other$auBecsDebit != null : !((Object)this$auBecsDebit).equals(other$auBecsDebit)) {
                return false;
            }
            BacsDebit this$bacsDebit = this.getBacsDebit();
            BacsDebit other$bacsDebit = other.getBacsDebit();
            if (this$bacsDebit == null ? other$bacsDebit != null : !((Object)this$bacsDebit).equals(other$bacsDebit)) {
                return false;
            }
            Bancontact this$bancontact = this.getBancontact();
            Bancontact other$bancontact = other.getBancontact();
            if (this$bancontact == null ? other$bancontact != null : !((Object)this$bancontact).equals(other$bancontact)) {
                return false;
            }
            Boleto this$boleto = this.getBoleto();
            Boleto other$boleto = other.getBoleto();
            if (this$boleto == null ? other$boleto != null : !((Object)this$boleto).equals(other$boleto)) {
                return false;
            }
            Card this$card = this.getCard();
            Card other$card = other.getCard();
            if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                return false;
            }
            Cashapp this$cashapp = this.getCashapp();
            Cashapp other$cashapp = other.getCashapp();
            if (this$cashapp == null ? other$cashapp != null : !((Object)this$cashapp).equals(other$cashapp)) {
                return false;
            }
            CustomerBalance this$customerBalance = this.getCustomerBalance();
            CustomerBalance other$customerBalance = other.getCustomerBalance();
            if (this$customerBalance == null ? other$customerBalance != null : !((Object)this$customerBalance).equals(other$customerBalance)) {
                return false;
            }
            Eps this$eps = this.getEps();
            Eps other$eps = other.getEps();
            if (this$eps == null ? other$eps != null : !((Object)this$eps).equals(other$eps)) {
                return false;
            }
            Fpx this$fpx = this.getFpx();
            Fpx other$fpx = other.getFpx();
            if (this$fpx == null ? other$fpx != null : !((Object)this$fpx).equals(other$fpx)) {
                return false;
            }
            Giropay this$giropay = this.getGiropay();
            Giropay other$giropay = other.getGiropay();
            if (this$giropay == null ? other$giropay != null : !((Object)this$giropay).equals(other$giropay)) {
                return false;
            }
            Grabpay this$grabpay = this.getGrabpay();
            Grabpay other$grabpay = other.getGrabpay();
            if (this$grabpay == null ? other$grabpay != null : !((Object)this$grabpay).equals(other$grabpay)) {
                return false;
            }
            Ideal this$ideal = this.getIdeal();
            Ideal other$ideal = other.getIdeal();
            if (this$ideal == null ? other$ideal != null : !((Object)this$ideal).equals(other$ideal)) {
                return false;
            }
            Klarna this$klarna = this.getKlarna();
            Klarna other$klarna = other.getKlarna();
            if (this$klarna == null ? other$klarna != null : !((Object)this$klarna).equals(other$klarna)) {
                return false;
            }
            Konbini this$konbini = this.getKonbini();
            Konbini other$konbini = other.getKonbini();
            if (this$konbini == null ? other$konbini != null : !((Object)this$konbini).equals(other$konbini)) {
                return false;
            }
            Link this$link = this.getLink();
            Link other$link = other.getLink();
            if (this$link == null ? other$link != null : !((Object)this$link).equals(other$link)) {
                return false;
            }
            Oxxo this$oxxo = this.getOxxo();
            Oxxo other$oxxo = other.getOxxo();
            if (this$oxxo == null ? other$oxxo != null : !((Object)this$oxxo).equals(other$oxxo)) {
                return false;
            }
            P24 this$p24 = this.getP24();
            P24 other$p24 = other.getP24();
            if (this$p24 == null ? other$p24 != null : !((Object)this$p24).equals(other$p24)) {
                return false;
            }
            Paynow this$paynow = this.getPaynow();
            Paynow other$paynow = other.getPaynow();
            if (this$paynow == null ? other$paynow != null : !((Object)this$paynow).equals(other$paynow)) {
                return false;
            }
            Pix this$pix = this.getPix();
            Pix other$pix = other.getPix();
            if (this$pix == null ? other$pix != null : !((Object)this$pix).equals(other$pix)) {
                return false;
            }
            SepaDebit this$sepaDebit = this.getSepaDebit();
            SepaDebit other$sepaDebit = other.getSepaDebit();
            if (this$sepaDebit == null ? other$sepaDebit != null : !((Object)this$sepaDebit).equals(other$sepaDebit)) {
                return false;
            }
            Sofort this$sofort = this.getSofort();
            Sofort other$sofort = other.getSofort();
            if (this$sofort == null ? other$sofort != null : !((Object)this$sofort).equals(other$sofort)) {
                return false;
            }
            UsBankAccount this$usBankAccount = this.getUsBankAccount();
            UsBankAccount other$usBankAccount = other.getUsBankAccount();
            return !(this$usBankAccount == null ? other$usBankAccount != null : !((Object)this$usBankAccount).equals(other$usBankAccount));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaymentMethodOptions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AcssDebit $acssDebit = this.getAcssDebit();
            result = result * 59 + ($acssDebit == null ? 43 : ((Object)$acssDebit).hashCode());
            Affirm $affirm = this.getAffirm();
            result = result * 59 + ($affirm == null ? 43 : ((Object)$affirm).hashCode());
            AfterpayClearpay $afterpayClearpay = this.getAfterpayClearpay();
            result = result * 59 + ($afterpayClearpay == null ? 43 : ((Object)$afterpayClearpay).hashCode());
            Alipay $alipay = this.getAlipay();
            result = result * 59 + ($alipay == null ? 43 : ((Object)$alipay).hashCode());
            AuBecsDebit $auBecsDebit = this.getAuBecsDebit();
            result = result * 59 + ($auBecsDebit == null ? 43 : ((Object)$auBecsDebit).hashCode());
            BacsDebit $bacsDebit = this.getBacsDebit();
            result = result * 59 + ($bacsDebit == null ? 43 : ((Object)$bacsDebit).hashCode());
            Bancontact $bancontact = this.getBancontact();
            result = result * 59 + ($bancontact == null ? 43 : ((Object)$bancontact).hashCode());
            Boleto $boleto = this.getBoleto();
            result = result * 59 + ($boleto == null ? 43 : ((Object)$boleto).hashCode());
            Card $card = this.getCard();
            result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
            Cashapp $cashapp = this.getCashapp();
            result = result * 59 + ($cashapp == null ? 43 : ((Object)$cashapp).hashCode());
            CustomerBalance $customerBalance = this.getCustomerBalance();
            result = result * 59 + ($customerBalance == null ? 43 : ((Object)$customerBalance).hashCode());
            Eps $eps = this.getEps();
            result = result * 59 + ($eps == null ? 43 : ((Object)$eps).hashCode());
            Fpx $fpx = this.getFpx();
            result = result * 59 + ($fpx == null ? 43 : ((Object)$fpx).hashCode());
            Giropay $giropay = this.getGiropay();
            result = result * 59 + ($giropay == null ? 43 : ((Object)$giropay).hashCode());
            Grabpay $grabpay = this.getGrabpay();
            result = result * 59 + ($grabpay == null ? 43 : ((Object)$grabpay).hashCode());
            Ideal $ideal = this.getIdeal();
            result = result * 59 + ($ideal == null ? 43 : ((Object)$ideal).hashCode());
            Klarna $klarna = this.getKlarna();
            result = result * 59 + ($klarna == null ? 43 : ((Object)$klarna).hashCode());
            Konbini $konbini = this.getKonbini();
            result = result * 59 + ($konbini == null ? 43 : ((Object)$konbini).hashCode());
            Link $link = this.getLink();
            result = result * 59 + ($link == null ? 43 : ((Object)$link).hashCode());
            Oxxo $oxxo = this.getOxxo();
            result = result * 59 + ($oxxo == null ? 43 : ((Object)$oxxo).hashCode());
            P24 $p24 = this.getP24();
            result = result * 59 + ($p24 == null ? 43 : ((Object)$p24).hashCode());
            Paynow $paynow = this.getPaynow();
            result = result * 59 + ($paynow == null ? 43 : ((Object)$paynow).hashCode());
            Pix $pix = this.getPix();
            result = result * 59 + ($pix == null ? 43 : ((Object)$pix).hashCode());
            SepaDebit $sepaDebit = this.getSepaDebit();
            result = result * 59 + ($sepaDebit == null ? 43 : ((Object)$sepaDebit).hashCode());
            Sofort $sofort = this.getSofort();
            result = result * 59 + ($sofort == null ? 43 : ((Object)$sofort).hashCode());
            UsBankAccount $usBankAccount = this.getUsBankAccount();
            result = result * 59 + ($usBankAccount == null ? 43 : ((Object)$usBankAccount).hashCode());
            return result;
        }

        public static class AcssDebit
        extends StripeObject {
            @SerializedName(value="currency")
            String currency;
            @SerializedName(value="mandate_options")
            MandateOptions mandateOptions;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;
            @SerializedName(value="verification_method")
            String verificationMethod;

            @Generated
            public String getCurrency() {
                return this.currency;
            }

            @Generated
            public MandateOptions getMandateOptions() {
                return this.mandateOptions;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public String getVerificationMethod() {
                return this.verificationMethod;
            }

            @Generated
            public void setCurrency(String currency) {
                this.currency = currency;
            }

            @Generated
            public void setMandateOptions(MandateOptions mandateOptions) {
                this.mandateOptions = mandateOptions;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public void setVerificationMethod(String verificationMethod) {
                this.verificationMethod = verificationMethod;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AcssDebit)) {
                    return false;
                }
                AcssDebit other = (AcssDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$currency = this.getCurrency();
                String other$currency = other.getCurrency();
                if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                    return false;
                }
                MandateOptions this$mandateOptions = this.getMandateOptions();
                MandateOptions other$mandateOptions = other.getMandateOptions();
                if (this$mandateOptions == null ? other$mandateOptions != null : !((Object)this$mandateOptions).equals(other$mandateOptions)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) {
                    return false;
                }
                String this$verificationMethod = this.getVerificationMethod();
                String other$verificationMethod = other.getVerificationMethod();
                return !(this$verificationMethod == null ? other$verificationMethod != null : !this$verificationMethod.equals(other$verificationMethod));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AcssDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $currency = this.getCurrency();
                result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
                MandateOptions $mandateOptions = this.getMandateOptions();
                result = result * 59 + ($mandateOptions == null ? 43 : ((Object)$mandateOptions).hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                String $verificationMethod = this.getVerificationMethod();
                result = result * 59 + ($verificationMethod == null ? 43 : $verificationMethod.hashCode());
                return result;
            }

            public static class MandateOptions
            extends StripeObject {
                @SerializedName(value="custom_mandate_url")
                String customMandateUrl;
                @SerializedName(value="default_for")
                List<String> defaultFor;
                @SerializedName(value="interval_description")
                String intervalDescription;
                @SerializedName(value="payment_schedule")
                String paymentSchedule;
                @SerializedName(value="transaction_type")
                String transactionType;

                @Generated
                public String getCustomMandateUrl() {
                    return this.customMandateUrl;
                }

                @Generated
                public List<String> getDefaultFor() {
                    return this.defaultFor;
                }

                @Generated
                public String getIntervalDescription() {
                    return this.intervalDescription;
                }

                @Generated
                public String getPaymentSchedule() {
                    return this.paymentSchedule;
                }

                @Generated
                public String getTransactionType() {
                    return this.transactionType;
                }

                @Generated
                public void setCustomMandateUrl(String customMandateUrl) {
                    this.customMandateUrl = customMandateUrl;
                }

                @Generated
                public void setDefaultFor(List<String> defaultFor) {
                    this.defaultFor = defaultFor;
                }

                @Generated
                public void setIntervalDescription(String intervalDescription) {
                    this.intervalDescription = intervalDescription;
                }

                @Generated
                public void setPaymentSchedule(String paymentSchedule) {
                    this.paymentSchedule = paymentSchedule;
                }

                @Generated
                public void setTransactionType(String transactionType) {
                    this.transactionType = transactionType;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof MandateOptions)) {
                        return false;
                    }
                    MandateOptions other = (MandateOptions)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$customMandateUrl = this.getCustomMandateUrl();
                    String other$customMandateUrl = other.getCustomMandateUrl();
                    if (this$customMandateUrl == null ? other$customMandateUrl != null : !this$customMandateUrl.equals(other$customMandateUrl)) {
                        return false;
                    }
                    List<String> this$defaultFor = this.getDefaultFor();
                    List<String> other$defaultFor = other.getDefaultFor();
                    if (this$defaultFor == null ? other$defaultFor != null : !((Object)this$defaultFor).equals(other$defaultFor)) {
                        return false;
                    }
                    String this$intervalDescription = this.getIntervalDescription();
                    String other$intervalDescription = other.getIntervalDescription();
                    if (this$intervalDescription == null ? other$intervalDescription != null : !this$intervalDescription.equals(other$intervalDescription)) {
                        return false;
                    }
                    String this$paymentSchedule = this.getPaymentSchedule();
                    String other$paymentSchedule = other.getPaymentSchedule();
                    if (this$paymentSchedule == null ? other$paymentSchedule != null : !this$paymentSchedule.equals(other$paymentSchedule)) {
                        return false;
                    }
                    String this$transactionType = this.getTransactionType();
                    String other$transactionType = other.getTransactionType();
                    return !(this$transactionType == null ? other$transactionType != null : !this$transactionType.equals(other$transactionType));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof MandateOptions;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $customMandateUrl = this.getCustomMandateUrl();
                    result = result * 59 + ($customMandateUrl == null ? 43 : $customMandateUrl.hashCode());
                    List<String> $defaultFor = this.getDefaultFor();
                    result = result * 59 + ($defaultFor == null ? 43 : ((Object)$defaultFor).hashCode());
                    String $intervalDescription = this.getIntervalDescription();
                    result = result * 59 + ($intervalDescription == null ? 43 : $intervalDescription.hashCode());
                    String $paymentSchedule = this.getPaymentSchedule();
                    result = result * 59 + ($paymentSchedule == null ? 43 : $paymentSchedule.hashCode());
                    String $transactionType = this.getTransactionType();
                    result = result * 59 + ($transactionType == null ? 43 : $transactionType.hashCode());
                    return result;
                }
            }
        }

        public static class Affirm
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Affirm)) {
                    return false;
                }
                Affirm other = (Affirm)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Affirm;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class AfterpayClearpay
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AfterpayClearpay)) {
                    return false;
                }
                AfterpayClearpay other = (AfterpayClearpay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AfterpayClearpay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Alipay
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Alipay)) {
                    return false;
                }
                Alipay other = (Alipay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Alipay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class AuBecsDebit
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AuBecsDebit)) {
                    return false;
                }
                AuBecsDebit other = (AuBecsDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AuBecsDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class BacsDebit
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BacsDebit)) {
                    return false;
                }
                BacsDebit other = (BacsDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof BacsDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Bancontact
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Bancontact)) {
                    return false;
                }
                Bancontact other = (Bancontact)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Bancontact;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Boleto
        extends StripeObject {
            @SerializedName(value="expires_after_days")
            Long expiresAfterDays;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public Long getExpiresAfterDays() {
                return this.expiresAfterDays;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setExpiresAfterDays(Long expiresAfterDays) {
                this.expiresAfterDays = expiresAfterDays;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Boleto)) {
                    return false;
                }
                Boleto other = (Boleto)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expiresAfterDays = this.getExpiresAfterDays();
                Long other$expiresAfterDays = other.getExpiresAfterDays();
                if (this$expiresAfterDays == null ? other$expiresAfterDays != null : !((Object)this$expiresAfterDays).equals(other$expiresAfterDays)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Boleto;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expiresAfterDays = this.getExpiresAfterDays();
                result = result * 59 + ($expiresAfterDays == null ? 43 : ((Object)$expiresAfterDays).hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Card
        extends StripeObject {
            @SerializedName(value="installments")
            Installments installments;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;
            @SerializedName(value="statement_descriptor_suffix_kana")
            String statementDescriptorSuffixKana;
            @SerializedName(value="statement_descriptor_suffix_kanji")
            String statementDescriptorSuffixKanji;

            @Generated
            public Installments getInstallments() {
                return this.installments;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public String getStatementDescriptorSuffixKana() {
                return this.statementDescriptorSuffixKana;
            }

            @Generated
            public String getStatementDescriptorSuffixKanji() {
                return this.statementDescriptorSuffixKanji;
            }

            @Generated
            public void setInstallments(Installments installments) {
                this.installments = installments;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public void setStatementDescriptorSuffixKana(String statementDescriptorSuffixKana) {
                this.statementDescriptorSuffixKana = statementDescriptorSuffixKana;
            }

            @Generated
            public void setStatementDescriptorSuffixKanji(String statementDescriptorSuffixKanji) {
                this.statementDescriptorSuffixKanji = statementDescriptorSuffixKanji;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Card)) {
                    return false;
                }
                Card other = (Card)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Installments this$installments = this.getInstallments();
                Installments other$installments = other.getInstallments();
                if (this$installments == null ? other$installments != null : !((Object)this$installments).equals(other$installments)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) {
                    return false;
                }
                String this$statementDescriptorSuffixKana = this.getStatementDescriptorSuffixKana();
                String other$statementDescriptorSuffixKana = other.getStatementDescriptorSuffixKana();
                if (this$statementDescriptorSuffixKana == null ? other$statementDescriptorSuffixKana != null : !this$statementDescriptorSuffixKana.equals(other$statementDescriptorSuffixKana)) {
                    return false;
                }
                String this$statementDescriptorSuffixKanji = this.getStatementDescriptorSuffixKanji();
                String other$statementDescriptorSuffixKanji = other.getStatementDescriptorSuffixKanji();
                return !(this$statementDescriptorSuffixKanji == null ? other$statementDescriptorSuffixKanji != null : !this$statementDescriptorSuffixKanji.equals(other$statementDescriptorSuffixKanji));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Card;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Installments $installments = this.getInstallments();
                result = result * 59 + ($installments == null ? 43 : ((Object)$installments).hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                String $statementDescriptorSuffixKana = this.getStatementDescriptorSuffixKana();
                result = result * 59 + ($statementDescriptorSuffixKana == null ? 43 : $statementDescriptorSuffixKana.hashCode());
                String $statementDescriptorSuffixKanji = this.getStatementDescriptorSuffixKanji();
                result = result * 59 + ($statementDescriptorSuffixKanji == null ? 43 : $statementDescriptorSuffixKanji.hashCode());
                return result;
            }

            public static class Installments
            extends StripeObject {
                @SerializedName(value="enabled")
                Boolean enabled;

                @Generated
                public Boolean getEnabled() {
                    return this.enabled;
                }

                @Generated
                public void setEnabled(Boolean enabled) {
                    this.enabled = enabled;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Installments)) {
                        return false;
                    }
                    Installments other = (Installments)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Boolean this$enabled = this.getEnabled();
                    Boolean other$enabled = other.getEnabled();
                    return !(this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Installments;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Boolean $enabled = this.getEnabled();
                    result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                    return result;
                }
            }
        }

        public static class Cashapp
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Cashapp)) {
                    return false;
                }
                Cashapp other = (Cashapp)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Cashapp;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class CustomerBalance
        extends StripeObject {
            @SerializedName(value="bank_transfer")
            BankTransfer bankTransfer;
            @SerializedName(value="funding_type")
            String fundingType;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public BankTransfer getBankTransfer() {
                return this.bankTransfer;
            }

            @Generated
            public String getFundingType() {
                return this.fundingType;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setBankTransfer(BankTransfer bankTransfer) {
                this.bankTransfer = bankTransfer;
            }

            @Generated
            public void setFundingType(String fundingType) {
                this.fundingType = fundingType;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CustomerBalance)) {
                    return false;
                }
                CustomerBalance other = (CustomerBalance)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                BankTransfer this$bankTransfer = this.getBankTransfer();
                BankTransfer other$bankTransfer = other.getBankTransfer();
                if (this$bankTransfer == null ? other$bankTransfer != null : !((Object)this$bankTransfer).equals(other$bankTransfer)) {
                    return false;
                }
                String this$fundingType = this.getFundingType();
                String other$fundingType = other.getFundingType();
                if (this$fundingType == null ? other$fundingType != null : !this$fundingType.equals(other$fundingType)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CustomerBalance;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                BankTransfer $bankTransfer = this.getBankTransfer();
                result = result * 59 + ($bankTransfer == null ? 43 : ((Object)$bankTransfer).hashCode());
                String $fundingType = this.getFundingType();
                result = result * 59 + ($fundingType == null ? 43 : $fundingType.hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static class BankTransfer
            extends StripeObject {
                @SerializedName(value="eu_bank_transfer")
                EuBankTransfer euBankTransfer;
                @SerializedName(value="requested_address_types")
                List<String> requestedAddressTypes;
                @SerializedName(value="type")
                String type;

                @Generated
                public EuBankTransfer getEuBankTransfer() {
                    return this.euBankTransfer;
                }

                @Generated
                public List<String> getRequestedAddressTypes() {
                    return this.requestedAddressTypes;
                }

                @Generated
                public String getType() {
                    return this.type;
                }

                @Generated
                public void setEuBankTransfer(EuBankTransfer euBankTransfer) {
                    this.euBankTransfer = euBankTransfer;
                }

                @Generated
                public void setRequestedAddressTypes(List<String> requestedAddressTypes) {
                    this.requestedAddressTypes = requestedAddressTypes;
                }

                @Generated
                public void setType(String type) {
                    this.type = type;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof BankTransfer)) {
                        return false;
                    }
                    BankTransfer other = (BankTransfer)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    EuBankTransfer this$euBankTransfer = this.getEuBankTransfer();
                    EuBankTransfer other$euBankTransfer = other.getEuBankTransfer();
                    if (this$euBankTransfer == null ? other$euBankTransfer != null : !((Object)this$euBankTransfer).equals(other$euBankTransfer)) {
                        return false;
                    }
                    List<String> this$requestedAddressTypes = this.getRequestedAddressTypes();
                    List<String> other$requestedAddressTypes = other.getRequestedAddressTypes();
                    if (this$requestedAddressTypes == null ? other$requestedAddressTypes != null : !((Object)this$requestedAddressTypes).equals(other$requestedAddressTypes)) {
                        return false;
                    }
                    String this$type = this.getType();
                    String other$type = other.getType();
                    return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof BankTransfer;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    EuBankTransfer $euBankTransfer = this.getEuBankTransfer();
                    result = result * 59 + ($euBankTransfer == null ? 43 : ((Object)$euBankTransfer).hashCode());
                    List<String> $requestedAddressTypes = this.getRequestedAddressTypes();
                    result = result * 59 + ($requestedAddressTypes == null ? 43 : ((Object)$requestedAddressTypes).hashCode());
                    String $type = this.getType();
                    result = result * 59 + ($type == null ? 43 : $type.hashCode());
                    return result;
                }

                public static class EuBankTransfer
                extends StripeObject {
                    @SerializedName(value="country")
                    String country;

                    @Generated
                    public String getCountry() {
                        return this.country;
                    }

                    @Generated
                    public void setCountry(String country) {
                        this.country = country;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof EuBankTransfer)) {
                            return false;
                        }
                        EuBankTransfer other = (EuBankTransfer)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$country = this.getCountry();
                        String other$country = other.getCountry();
                        return !(this$country == null ? other$country != null : !this$country.equals(other$country));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof EuBankTransfer;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $country = this.getCountry();
                        result = result * 59 + ($country == null ? 43 : $country.hashCode());
                        return result;
                    }
                }
            }
        }

        public static class Eps
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Eps)) {
                    return false;
                }
                Eps other = (Eps)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Eps;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Fpx
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Fpx)) {
                    return false;
                }
                Fpx other = (Fpx)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Fpx;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Giropay
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Giropay)) {
                    return false;
                }
                Giropay other = (Giropay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Giropay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Grabpay
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Grabpay)) {
                    return false;
                }
                Grabpay other = (Grabpay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Grabpay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Ideal
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ideal)) {
                    return false;
                }
                Ideal other = (Ideal)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ideal;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Klarna
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Klarna)) {
                    return false;
                }
                Klarna other = (Klarna)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Klarna;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Konbini
        extends StripeObject {
            @SerializedName(value="expires_after_days")
            Long expiresAfterDays;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public Long getExpiresAfterDays() {
                return this.expiresAfterDays;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setExpiresAfterDays(Long expiresAfterDays) {
                this.expiresAfterDays = expiresAfterDays;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Konbini)) {
                    return false;
                }
                Konbini other = (Konbini)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expiresAfterDays = this.getExpiresAfterDays();
                Long other$expiresAfterDays = other.getExpiresAfterDays();
                if (this$expiresAfterDays == null ? other$expiresAfterDays != null : !((Object)this$expiresAfterDays).equals(other$expiresAfterDays)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Konbini;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expiresAfterDays = this.getExpiresAfterDays();
                result = result * 59 + ($expiresAfterDays == null ? 43 : ((Object)$expiresAfterDays).hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Link
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Link)) {
                    return false;
                }
                Link other = (Link)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Link;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Oxxo
        extends StripeObject {
            @SerializedName(value="expires_after_days")
            Long expiresAfterDays;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public Long getExpiresAfterDays() {
                return this.expiresAfterDays;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setExpiresAfterDays(Long expiresAfterDays) {
                this.expiresAfterDays = expiresAfterDays;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Oxxo)) {
                    return false;
                }
                Oxxo other = (Oxxo)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expiresAfterDays = this.getExpiresAfterDays();
                Long other$expiresAfterDays = other.getExpiresAfterDays();
                if (this$expiresAfterDays == null ? other$expiresAfterDays != null : !((Object)this$expiresAfterDays).equals(other$expiresAfterDays)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Oxxo;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expiresAfterDays = this.getExpiresAfterDays();
                result = result * 59 + ($expiresAfterDays == null ? 43 : ((Object)$expiresAfterDays).hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class P24
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof P24)) {
                    return false;
                }
                P24 other = (P24)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof P24;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Paynow
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Paynow)) {
                    return false;
                }
                Paynow other = (Paynow)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Paynow;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Pix
        extends StripeObject {
            @SerializedName(value="expires_after_seconds")
            Long expiresAfterSeconds;

            @Generated
            public Long getExpiresAfterSeconds() {
                return this.expiresAfterSeconds;
            }

            @Generated
            public void setExpiresAfterSeconds(Long expiresAfterSeconds) {
                this.expiresAfterSeconds = expiresAfterSeconds;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Pix)) {
                    return false;
                }
                Pix other = (Pix)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expiresAfterSeconds = this.getExpiresAfterSeconds();
                Long other$expiresAfterSeconds = other.getExpiresAfterSeconds();
                return !(this$expiresAfterSeconds == null ? other$expiresAfterSeconds != null : !((Object)this$expiresAfterSeconds).equals(other$expiresAfterSeconds));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Pix;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expiresAfterSeconds = this.getExpiresAfterSeconds();
                result = result * 59 + ($expiresAfterSeconds == null ? 43 : ((Object)$expiresAfterSeconds).hashCode());
                return result;
            }
        }

        public static class SepaDebit
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SepaDebit)) {
                    return false;
                }
                SepaDebit other = (SepaDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SepaDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class Sofort
        extends StripeObject {
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Sofort)) {
                    return false;
                }
                Sofort other = (Sofort)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Sofort;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }
        }

        public static class UsBankAccount
        extends StripeObject {
            @SerializedName(value="financial_connections")
            FinancialConnections financialConnections;
            @SerializedName(value="setup_future_usage")
            String setupFutureUsage;
            @SerializedName(value="verification_method")
            String verificationMethod;

            @Generated
            public FinancialConnections getFinancialConnections() {
                return this.financialConnections;
            }

            @Generated
            public String getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public String getVerificationMethod() {
                return this.verificationMethod;
            }

            @Generated
            public void setFinancialConnections(FinancialConnections financialConnections) {
                this.financialConnections = financialConnections;
            }

            @Generated
            public void setSetupFutureUsage(String setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
            }

            @Generated
            public void setVerificationMethod(String verificationMethod) {
                this.verificationMethod = verificationMethod;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof UsBankAccount)) {
                    return false;
                }
                UsBankAccount other = (UsBankAccount)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                FinancialConnections this$financialConnections = this.getFinancialConnections();
                FinancialConnections other$financialConnections = other.getFinancialConnections();
                if (this$financialConnections == null ? other$financialConnections != null : !((Object)this$financialConnections).equals(other$financialConnections)) {
                    return false;
                }
                String this$setupFutureUsage = this.getSetupFutureUsage();
                String other$setupFutureUsage = other.getSetupFutureUsage();
                if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) {
                    return false;
                }
                String this$verificationMethod = this.getVerificationMethod();
                String other$verificationMethod = other.getVerificationMethod();
                return !(this$verificationMethod == null ? other$verificationMethod != null : !this$verificationMethod.equals(other$verificationMethod));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof UsBankAccount;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                FinancialConnections $financialConnections = this.getFinancialConnections();
                result = result * 59 + ($financialConnections == null ? 43 : ((Object)$financialConnections).hashCode());
                String $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                String $verificationMethod = this.getVerificationMethod();
                result = result * 59 + ($verificationMethod == null ? 43 : $verificationMethod.hashCode());
                return result;
            }

            public static class FinancialConnections
            extends StripeObject {
                @SerializedName(value="manual_entry")
                ManualEntry manualEntry;
                @SerializedName(value="permissions")
                List<String> permissions;
                @SerializedName(value="prefetch")
                List<String> prefetch;
                @SerializedName(value="return_url")
                String returnUrl;

                @Generated
                public ManualEntry getManualEntry() {
                    return this.manualEntry;
                }

                @Generated
                public List<String> getPermissions() {
                    return this.permissions;
                }

                @Generated
                public List<String> getPrefetch() {
                    return this.prefetch;
                }

                @Generated
                public String getReturnUrl() {
                    return this.returnUrl;
                }

                @Generated
                public void setManualEntry(ManualEntry manualEntry) {
                    this.manualEntry = manualEntry;
                }

                @Generated
                public void setPermissions(List<String> permissions) {
                    this.permissions = permissions;
                }

                @Generated
                public void setPrefetch(List<String> prefetch) {
                    this.prefetch = prefetch;
                }

                @Generated
                public void setReturnUrl(String returnUrl) {
                    this.returnUrl = returnUrl;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof FinancialConnections)) {
                        return false;
                    }
                    FinancialConnections other = (FinancialConnections)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    ManualEntry this$manualEntry = this.getManualEntry();
                    ManualEntry other$manualEntry = other.getManualEntry();
                    if (this$manualEntry == null ? other$manualEntry != null : !((Object)this$manualEntry).equals(other$manualEntry)) {
                        return false;
                    }
                    List<String> this$permissions = this.getPermissions();
                    List<String> other$permissions = other.getPermissions();
                    if (this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions)) {
                        return false;
                    }
                    List<String> this$prefetch = this.getPrefetch();
                    List<String> other$prefetch = other.getPrefetch();
                    if (this$prefetch == null ? other$prefetch != null : !((Object)this$prefetch).equals(other$prefetch)) {
                        return false;
                    }
                    String this$returnUrl = this.getReturnUrl();
                    String other$returnUrl = other.getReturnUrl();
                    return !(this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof FinancialConnections;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    ManualEntry $manualEntry = this.getManualEntry();
                    result = result * 59 + ($manualEntry == null ? 43 : ((Object)$manualEntry).hashCode());
                    List<String> $permissions = this.getPermissions();
                    result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
                    List<String> $prefetch = this.getPrefetch();
                    result = result * 59 + ($prefetch == null ? 43 : ((Object)$prefetch).hashCode());
                    String $returnUrl = this.getReturnUrl();
                    result = result * 59 + ($returnUrl == null ? 43 : $returnUrl.hashCode());
                    return result;
                }

                public static class ManualEntry
                extends StripeObject {
                    @SerializedName(value="mode")
                    String mode;

                    @Generated
                    public String getMode() {
                        return this.mode;
                    }

                    @Generated
                    public void setMode(String mode) {
                        this.mode = mode;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ManualEntry)) {
                            return false;
                        }
                        ManualEntry other = (ManualEntry)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$mode = this.getMode();
                        String other$mode = other.getMode();
                        return !(this$mode == null ? other$mode != null : !this$mode.equals(other$mode));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof ManualEntry;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $mode = this.getMode();
                        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
                        return result;
                    }
                }
            }
        }
    }

    public static class PhoneNumberCollection
    extends StripeObject {
        @SerializedName(value="enabled")
        Boolean enabled;

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PhoneNumberCollection)) {
                return false;
            }
            PhoneNumberCollection other = (PhoneNumberCollection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            return !(this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PhoneNumberCollection;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            return result;
        }
    }

    public static class ShippingAddressCollection
    extends StripeObject {
        @SerializedName(value="allowed_countries")
        List<String> allowedCountries;

        @Generated
        public List<String> getAllowedCountries() {
            return this.allowedCountries;
        }

        @Generated
        public void setAllowedCountries(List<String> allowedCountries) {
            this.allowedCountries = allowedCountries;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShippingAddressCollection)) {
                return false;
            }
            ShippingAddressCollection other = (ShippingAddressCollection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$allowedCountries = this.getAllowedCountries();
            List<String> other$allowedCountries = other.getAllowedCountries();
            return !(this$allowedCountries == null ? other$allowedCountries != null : !((Object)this$allowedCountries).equals(other$allowedCountries));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ShippingAddressCollection;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $allowedCountries = this.getAllowedCountries();
            result = result * 59 + ($allowedCountries == null ? 43 : ((Object)$allowedCountries).hashCode());
            return result;
        }
    }

    public static class ShippingCost
    extends StripeObject {
        @SerializedName(value="amount_subtotal")
        Long amountSubtotal;
        @SerializedName(value="amount_tax")
        Long amountTax;
        @SerializedName(value="amount_total")
        Long amountTotal;
        @SerializedName(value="shipping_rate")
        ExpandableField<ShippingRate> shippingRate;
        @SerializedName(value="taxes")
        List<Tax> taxes;

        public String getShippingRate() {
            return this.shippingRate != null ? this.shippingRate.getId() : null;
        }

        public void setShippingRate(String id) {
            this.shippingRate = ApiResource.setExpandableFieldId(id, this.shippingRate);
        }

        public ShippingRate getShippingRateObject() {
            return this.shippingRate != null ? this.shippingRate.getExpanded() : null;
        }

        public void setShippingRateObject(ShippingRate expandableObject) {
            this.shippingRate = new ExpandableField<ShippingRate>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public Long getAmountSubtotal() {
            return this.amountSubtotal;
        }

        @Generated
        public Long getAmountTax() {
            return this.amountTax;
        }

        @Generated
        public Long getAmountTotal() {
            return this.amountTotal;
        }

        @Generated
        public List<Tax> getTaxes() {
            return this.taxes;
        }

        @Generated
        public void setAmountSubtotal(Long amountSubtotal) {
            this.amountSubtotal = amountSubtotal;
        }

        @Generated
        public void setAmountTax(Long amountTax) {
            this.amountTax = amountTax;
        }

        @Generated
        public void setAmountTotal(Long amountTotal) {
            this.amountTotal = amountTotal;
        }

        @Generated
        public void setTaxes(List<Tax> taxes) {
            this.taxes = taxes;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShippingCost)) {
                return false;
            }
            ShippingCost other = (ShippingCost)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amountSubtotal = this.getAmountSubtotal();
            Long other$amountSubtotal = other.getAmountSubtotal();
            if (this$amountSubtotal == null ? other$amountSubtotal != null : !((Object)this$amountSubtotal).equals(other$amountSubtotal)) {
                return false;
            }
            Long this$amountTax = this.getAmountTax();
            Long other$amountTax = other.getAmountTax();
            if (this$amountTax == null ? other$amountTax != null : !((Object)this$amountTax).equals(other$amountTax)) {
                return false;
            }
            Long this$amountTotal = this.getAmountTotal();
            Long other$amountTotal = other.getAmountTotal();
            if (this$amountTotal == null ? other$amountTotal != null : !((Object)this$amountTotal).equals(other$amountTotal)) {
                return false;
            }
            String this$shippingRate = this.getShippingRate();
            String other$shippingRate = other.getShippingRate();
            if (this$shippingRate == null ? other$shippingRate != null : !this$shippingRate.equals(other$shippingRate)) {
                return false;
            }
            List<Tax> this$taxes = this.getTaxes();
            List<Tax> other$taxes = other.getTaxes();
            return !(this$taxes == null ? other$taxes != null : !((Object)this$taxes).equals(other$taxes));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ShippingCost;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amountSubtotal = this.getAmountSubtotal();
            result = result * 59 + ($amountSubtotal == null ? 43 : ((Object)$amountSubtotal).hashCode());
            Long $amountTax = this.getAmountTax();
            result = result * 59 + ($amountTax == null ? 43 : ((Object)$amountTax).hashCode());
            Long $amountTotal = this.getAmountTotal();
            result = result * 59 + ($amountTotal == null ? 43 : ((Object)$amountTotal).hashCode());
            String $shippingRate = this.getShippingRate();
            result = result * 59 + ($shippingRate == null ? 43 : $shippingRate.hashCode());
            List<Tax> $taxes = this.getTaxes();
            result = result * 59 + ($taxes == null ? 43 : ((Object)$taxes).hashCode());
            return result;
        }

        public static class Tax
        extends StripeObject {
            @SerializedName(value="amount")
            Long amount;
            @SerializedName(value="rate")
            TaxRate rate;
            @SerializedName(value="taxability_reason")
            String taxabilityReason;
            @SerializedName(value="taxable_amount")
            Long taxableAmount;

            @Generated
            public Long getAmount() {
                return this.amount;
            }

            @Generated
            public TaxRate getRate() {
                return this.rate;
            }

            @Generated
            public String getTaxabilityReason() {
                return this.taxabilityReason;
            }

            @Generated
            public Long getTaxableAmount() {
                return this.taxableAmount;
            }

            @Generated
            public void setAmount(Long amount) {
                this.amount = amount;
            }

            @Generated
            public void setRate(TaxRate rate) {
                this.rate = rate;
            }

            @Generated
            public void setTaxabilityReason(String taxabilityReason) {
                this.taxabilityReason = taxabilityReason;
            }

            @Generated
            public void setTaxableAmount(Long taxableAmount) {
                this.taxableAmount = taxableAmount;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Tax)) {
                    return false;
                }
                Tax other = (Tax)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$amount = this.getAmount();
                Long other$amount = other.getAmount();
                if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                    return false;
                }
                Long this$taxableAmount = this.getTaxableAmount();
                Long other$taxableAmount = other.getTaxableAmount();
                if (this$taxableAmount == null ? other$taxableAmount != null : !((Object)this$taxableAmount).equals(other$taxableAmount)) {
                    return false;
                }
                TaxRate this$rate = this.getRate();
                TaxRate other$rate = other.getRate();
                if (this$rate == null ? other$rate != null : !((Object)this$rate).equals(other$rate)) {
                    return false;
                }
                String this$taxabilityReason = this.getTaxabilityReason();
                String other$taxabilityReason = other.getTaxabilityReason();
                return !(this$taxabilityReason == null ? other$taxabilityReason != null : !this$taxabilityReason.equals(other$taxabilityReason));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Tax;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $amount = this.getAmount();
                result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                Long $taxableAmount = this.getTaxableAmount();
                result = result * 59 + ($taxableAmount == null ? 43 : ((Object)$taxableAmount).hashCode());
                TaxRate $rate = this.getRate();
                result = result * 59 + ($rate == null ? 43 : ((Object)$rate).hashCode());
                String $taxabilityReason = this.getTaxabilityReason();
                result = result * 59 + ($taxabilityReason == null ? 43 : $taxabilityReason.hashCode());
                return result;
            }
        }
    }

    public static class TaxIdCollection
    extends StripeObject {
        @SerializedName(value="enabled")
        Boolean enabled;

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaxIdCollection)) {
                return false;
            }
            TaxIdCollection other = (TaxIdCollection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            return !(this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TaxIdCollection;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            return result;
        }
    }

    public static class TotalDetails
    extends StripeObject {
        @SerializedName(value="amount_discount")
        Long amountDiscount;
        @SerializedName(value="amount_shipping")
        Long amountShipping;
        @SerializedName(value="amount_tax")
        Long amountTax;
        @SerializedName(value="breakdown")
        Breakdown breakdown;

        @Generated
        public Long getAmountDiscount() {
            return this.amountDiscount;
        }

        @Generated
        public Long getAmountShipping() {
            return this.amountShipping;
        }

        @Generated
        public Long getAmountTax() {
            return this.amountTax;
        }

        @Generated
        public Breakdown getBreakdown() {
            return this.breakdown;
        }

        @Generated
        public void setAmountDiscount(Long amountDiscount) {
            this.amountDiscount = amountDiscount;
        }

        @Generated
        public void setAmountShipping(Long amountShipping) {
            this.amountShipping = amountShipping;
        }

        @Generated
        public void setAmountTax(Long amountTax) {
            this.amountTax = amountTax;
        }

        @Generated
        public void setBreakdown(Breakdown breakdown) {
            this.breakdown = breakdown;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TotalDetails)) {
                return false;
            }
            TotalDetails other = (TotalDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amountDiscount = this.getAmountDiscount();
            Long other$amountDiscount = other.getAmountDiscount();
            if (this$amountDiscount == null ? other$amountDiscount != null : !((Object)this$amountDiscount).equals(other$amountDiscount)) {
                return false;
            }
            Long this$amountShipping = this.getAmountShipping();
            Long other$amountShipping = other.getAmountShipping();
            if (this$amountShipping == null ? other$amountShipping != null : !((Object)this$amountShipping).equals(other$amountShipping)) {
                return false;
            }
            Long this$amountTax = this.getAmountTax();
            Long other$amountTax = other.getAmountTax();
            if (this$amountTax == null ? other$amountTax != null : !((Object)this$amountTax).equals(other$amountTax)) {
                return false;
            }
            Breakdown this$breakdown = this.getBreakdown();
            Breakdown other$breakdown = other.getBreakdown();
            return !(this$breakdown == null ? other$breakdown != null : !((Object)this$breakdown).equals(other$breakdown));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TotalDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amountDiscount = this.getAmountDiscount();
            result = result * 59 + ($amountDiscount == null ? 43 : ((Object)$amountDiscount).hashCode());
            Long $amountShipping = this.getAmountShipping();
            result = result * 59 + ($amountShipping == null ? 43 : ((Object)$amountShipping).hashCode());
            Long $amountTax = this.getAmountTax();
            result = result * 59 + ($amountTax == null ? 43 : ((Object)$amountTax).hashCode());
            Breakdown $breakdown = this.getBreakdown();
            result = result * 59 + ($breakdown == null ? 43 : ((Object)$breakdown).hashCode());
            return result;
        }

        public static class Breakdown
        extends StripeObject {
            @SerializedName(value="discounts")
            List<Discount> discounts;
            @SerializedName(value="taxes")
            List<Tax> taxes;

            @Generated
            public List<Discount> getDiscounts() {
                return this.discounts;
            }

            @Generated
            public List<Tax> getTaxes() {
                return this.taxes;
            }

            @Generated
            public void setDiscounts(List<Discount> discounts) {
                this.discounts = discounts;
            }

            @Generated
            public void setTaxes(List<Tax> taxes) {
                this.taxes = taxes;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Breakdown)) {
                    return false;
                }
                Breakdown other = (Breakdown)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<Discount> this$discounts = this.getDiscounts();
                List<Discount> other$discounts = other.getDiscounts();
                if (this$discounts == null ? other$discounts != null : !((Object)this$discounts).equals(other$discounts)) {
                    return false;
                }
                List<Tax> this$taxes = this.getTaxes();
                List<Tax> other$taxes = other.getTaxes();
                return !(this$taxes == null ? other$taxes != null : !((Object)this$taxes).equals(other$taxes));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Breakdown;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<Discount> $discounts = this.getDiscounts();
                result = result * 59 + ($discounts == null ? 43 : ((Object)$discounts).hashCode());
                List<Tax> $taxes = this.getTaxes();
                result = result * 59 + ($taxes == null ? 43 : ((Object)$taxes).hashCode());
                return result;
            }

            public static class Tax
            extends StripeObject {
                @SerializedName(value="amount")
                Long amount;
                @SerializedName(value="rate")
                TaxRate rate;
                @SerializedName(value="taxability_reason")
                String taxabilityReason;
                @SerializedName(value="taxable_amount")
                Long taxableAmount;

                @Generated
                public Long getAmount() {
                    return this.amount;
                }

                @Generated
                public TaxRate getRate() {
                    return this.rate;
                }

                @Generated
                public String getTaxabilityReason() {
                    return this.taxabilityReason;
                }

                @Generated
                public Long getTaxableAmount() {
                    return this.taxableAmount;
                }

                @Generated
                public void setAmount(Long amount) {
                    this.amount = amount;
                }

                @Generated
                public void setRate(TaxRate rate) {
                    this.rate = rate;
                }

                @Generated
                public void setTaxabilityReason(String taxabilityReason) {
                    this.taxabilityReason = taxabilityReason;
                }

                @Generated
                public void setTaxableAmount(Long taxableAmount) {
                    this.taxableAmount = taxableAmount;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Tax)) {
                        return false;
                    }
                    Tax other = (Tax)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$amount = this.getAmount();
                    Long other$amount = other.getAmount();
                    if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                        return false;
                    }
                    Long this$taxableAmount = this.getTaxableAmount();
                    Long other$taxableAmount = other.getTaxableAmount();
                    if (this$taxableAmount == null ? other$taxableAmount != null : !((Object)this$taxableAmount).equals(other$taxableAmount)) {
                        return false;
                    }
                    TaxRate this$rate = this.getRate();
                    TaxRate other$rate = other.getRate();
                    if (this$rate == null ? other$rate != null : !((Object)this$rate).equals(other$rate)) {
                        return false;
                    }
                    String this$taxabilityReason = this.getTaxabilityReason();
                    String other$taxabilityReason = other.getTaxabilityReason();
                    return !(this$taxabilityReason == null ? other$taxabilityReason != null : !this$taxabilityReason.equals(other$taxabilityReason));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Tax;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $amount = this.getAmount();
                    result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                    Long $taxableAmount = this.getTaxableAmount();
                    result = result * 59 + ($taxableAmount == null ? 43 : ((Object)$taxableAmount).hashCode());
                    TaxRate $rate = this.getRate();
                    result = result * 59 + ($rate == null ? 43 : ((Object)$rate).hashCode());
                    String $taxabilityReason = this.getTaxabilityReason();
                    result = result * 59 + ($taxabilityReason == null ? 43 : $taxabilityReason.hashCode());
                    return result;
                }
            }

            public static class Discount
            extends StripeObject {
                @SerializedName(value="amount")
                Long amount;
                @SerializedName(value="discount")
                Discount discount;

                @Generated
                public Long getAmount() {
                    return this.amount;
                }

                @Generated
                public Discount getDiscount() {
                    return this.discount;
                }

                @Generated
                public void setAmount(Long amount) {
                    this.amount = amount;
                }

                @Generated
                public void setDiscount(Discount discount) {
                    this.discount = discount;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Discount)) {
                        return false;
                    }
                    Discount other = (Discount)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$amount = this.getAmount();
                    Long other$amount = other.getAmount();
                    if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                        return false;
                    }
                    Discount this$discount = this.getDiscount();
                    Discount other$discount = other.getDiscount();
                    return !(this$discount == null ? other$discount != null : !((Object)this$discount).equals(other$discount));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Discount;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $amount = this.getAmount();
                    result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                    Discount $discount = this.getDiscount();
                    result = result * 59 + ($discount == null ? 43 : ((Object)$discount).hashCode());
                    return result;
                }
            }
        }
    }

    public static class ShippingOption
    extends StripeObject {
        @SerializedName(value="shipping_amount")
        Long shippingAmount;
        @SerializedName(value="shipping_rate")
        ExpandableField<ShippingRate> shippingRate;

        public String getShippingRate() {
            return this.shippingRate != null ? this.shippingRate.getId() : null;
        }

        public void setShippingRate(String id) {
            this.shippingRate = ApiResource.setExpandableFieldId(id, this.shippingRate);
        }

        public ShippingRate getShippingRateObject() {
            return this.shippingRate != null ? this.shippingRate.getExpanded() : null;
        }

        public void setShippingRateObject(ShippingRate expandableObject) {
            this.shippingRate = new ExpandableField<ShippingRate>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public Long getShippingAmount() {
            return this.shippingAmount;
        }

        @Generated
        public void setShippingAmount(Long shippingAmount) {
            this.shippingAmount = shippingAmount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShippingOption)) {
                return false;
            }
            ShippingOption other = (ShippingOption)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$shippingAmount = this.getShippingAmount();
            Long other$shippingAmount = other.getShippingAmount();
            if (this$shippingAmount == null ? other$shippingAmount != null : !((Object)this$shippingAmount).equals(other$shippingAmount)) {
                return false;
            }
            String this$shippingRate = this.getShippingRate();
            String other$shippingRate = other.getShippingRate();
            return !(this$shippingRate == null ? other$shippingRate != null : !this$shippingRate.equals(other$shippingRate));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ShippingOption;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $shippingAmount = this.getShippingAmount();
            result = result * 59 + ($shippingAmount == null ? 43 : ((Object)$shippingAmount).hashCode());
            String $shippingRate = this.getShippingRate();
            result = result * 59 + ($shippingRate == null ? 43 : $shippingRate.hashCode());
            return result;
        }
    }

    public static class CustomField
    extends StripeObject {
        @SerializedName(value="dropdown")
        Dropdown dropdown;
        @SerializedName(value="key")
        String key;
        @SerializedName(value="label")
        Label label;
        @SerializedName(value="numeric")
        Numeric numeric;
        @SerializedName(value="optional")
        Boolean optional;
        @SerializedName(value="text")
        Text text;
        @SerializedName(value="type")
        String type;

        @Generated
        public Dropdown getDropdown() {
            return this.dropdown;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public Label getLabel() {
            return this.label;
        }

        @Generated
        public Numeric getNumeric() {
            return this.numeric;
        }

        @Generated
        public Boolean getOptional() {
            return this.optional;
        }

        @Generated
        public Text getText() {
            return this.text;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setDropdown(Dropdown dropdown) {
            this.dropdown = dropdown;
        }

        @Generated
        public void setKey(String key) {
            this.key = key;
        }

        @Generated
        public void setLabel(Label label) {
            this.label = label;
        }

        @Generated
        public void setNumeric(Numeric numeric) {
            this.numeric = numeric;
        }

        @Generated
        public void setOptional(Boolean optional) {
            this.optional = optional;
        }

        @Generated
        public void setText(Text text) {
            this.text = text;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomField)) {
                return false;
            }
            CustomField other = (CustomField)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$optional = this.getOptional();
            Boolean other$optional = other.getOptional();
            if (this$optional == null ? other$optional != null : !((Object)this$optional).equals(other$optional)) {
                return false;
            }
            Dropdown this$dropdown = this.getDropdown();
            Dropdown other$dropdown = other.getDropdown();
            if (this$dropdown == null ? other$dropdown != null : !((Object)this$dropdown).equals(other$dropdown)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            Label this$label = this.getLabel();
            Label other$label = other.getLabel();
            if (this$label == null ? other$label != null : !((Object)this$label).equals(other$label)) {
                return false;
            }
            Numeric this$numeric = this.getNumeric();
            Numeric other$numeric = other.getNumeric();
            if (this$numeric == null ? other$numeric != null : !((Object)this$numeric).equals(other$numeric)) {
                return false;
            }
            Text this$text = this.getText();
            Text other$text = other.getText();
            if (this$text == null ? other$text != null : !((Object)this$text).equals(other$text)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CustomField;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $optional = this.getOptional();
            result = result * 59 + ($optional == null ? 43 : ((Object)$optional).hashCode());
            Dropdown $dropdown = this.getDropdown();
            result = result * 59 + ($dropdown == null ? 43 : ((Object)$dropdown).hashCode());
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            Label $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : ((Object)$label).hashCode());
            Numeric $numeric = this.getNumeric();
            result = result * 59 + ($numeric == null ? 43 : ((Object)$numeric).hashCode());
            Text $text = this.getText();
            result = result * 59 + ($text == null ? 43 : ((Object)$text).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class Dropdown
        extends StripeObject {
            @SerializedName(value="options")
            List<Option> options;
            @SerializedName(value="value")
            String value;

            @Generated
            public List<Option> getOptions() {
                return this.options;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOptions(List<Option> options) {
                this.options = options;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Dropdown)) {
                    return false;
                }
                Dropdown other = (Dropdown)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<Option> this$options = this.getOptions();
                List<Option> other$options = other.getOptions();
                if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Dropdown;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<Option> $options = this.getOptions();
                result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }

            public static class Option
            extends StripeObject {
                @SerializedName(value="label")
                String label;
                @SerializedName(value="value")
                String value;

                @Generated
                public String getLabel() {
                    return this.label;
                }

                @Generated
                public String getValue() {
                    return this.value;
                }

                @Generated
                public void setLabel(String label) {
                    this.label = label;
                }

                @Generated
                public void setValue(String value) {
                    this.value = value;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Option)) {
                        return false;
                    }
                    Option other = (Option)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$label = this.getLabel();
                    String other$label = other.getLabel();
                    if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
                        return false;
                    }
                    String this$value = this.getValue();
                    String other$value = other.getValue();
                    return !(this$value == null ? other$value != null : !this$value.equals(other$value));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Option;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $label = this.getLabel();
                    result = result * 59 + ($label == null ? 43 : $label.hashCode());
                    String $value = this.getValue();
                    result = result * 59 + ($value == null ? 43 : $value.hashCode());
                    return result;
                }
            }
        }

        public static class Label
        extends StripeObject {
            @SerializedName(value="custom")
            String custom;
            @SerializedName(value="type")
            String type;

            @Generated
            public String getCustom() {
                return this.custom;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setCustom(String custom) {
                this.custom = custom;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Label)) {
                    return false;
                }
                Label other = (Label)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$custom = this.getCustom();
                String other$custom = other.getCustom();
                if (this$custom == null ? other$custom != null : !this$custom.equals(other$custom)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Label;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $custom = this.getCustom();
                result = result * 59 + ($custom == null ? 43 : $custom.hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Numeric
        extends StripeObject {
            @SerializedName(value="value")
            String value;

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Numeric)) {
                    return false;
                }
                Numeric other = (Numeric)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Numeric;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }

        public static class Text
        extends StripeObject {
            @SerializedName(value="value")
            String value;

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Text)) {
                    return false;
                }
                Text other = (Text)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Text;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }
}

