/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.financialconnections;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.financialconnections.AccountCollection;
import com.stripe.model.financialconnections.AccountOwnerCollection;
import com.stripe.model.financialconnections.AccountOwnership;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.financialconnections.AccountDisconnectParams;
import com.stripe.param.financialconnections.AccountListOwnersParams;
import com.stripe.param.financialconnections.AccountListParams;
import com.stripe.param.financialconnections.AccountRefreshParams;
import com.stripe.param.financialconnections.AccountRetrieveParams;
import com.stripe.param.financialconnections.AccountSubscribeParams;
import com.stripe.param.financialconnections.AccountUnsubscribeParams;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Account
extends ApiResource
implements HasId {
    @SerializedName(value="account_holder")
    AccountHolder accountHolder;
    @SerializedName(value="balance")
    Balance balance;
    @SerializedName(value="balance_refresh")
    BalanceRefresh balanceRefresh;
    @SerializedName(value="category")
    String category;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="display_name")
    String displayName;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="inferred_balances_refresh")
    InferredBalancesRefresh inferredBalancesRefresh;
    @SerializedName(value="institution_name")
    String institutionName;
    @SerializedName(value="last4")
    String last4;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="ownership")
    ExpandableField<AccountOwnership> ownership;
    @SerializedName(value="ownership_refresh")
    OwnershipRefresh ownershipRefresh;
    @SerializedName(value="permissions")
    List<String> permissions;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="subcategory")
    String subcategory;
    @SerializedName(value="subscriptions")
    List<String> subscriptions;
    @SerializedName(value="supported_payment_method_types")
    List<String> supportedPaymentMethodTypes;
    @SerializedName(value="transaction_refresh")
    TransactionRefresh transactionRefresh;

    public String getOwnership() {
        return this.ownership != null ? this.ownership.getId() : null;
    }

    public void setOwnership(String id) {
        this.ownership = ApiResource.setExpandableFieldId(id, this.ownership);
    }

    public AccountOwnership getOwnershipObject() {
        return this.ownership != null ? this.ownership.getExpanded() : null;
    }

    public void setOwnershipObject(AccountOwnership expandableObject) {
        this.ownership = new ExpandableField<AccountOwnership>(expandableObject.getId(), expandableObject);
    }

    public Account disconnect() throws StripeException {
        return this.disconnect((Map<String, Object>)null, (RequestOptions)null);
    }

    public Account disconnect(RequestOptions options) throws StripeException {
        return this.disconnect((Map<String, Object>)null, options);
    }

    public Account disconnect(Map<String, Object> params) throws StripeException {
        return this.disconnect(params, (RequestOptions)null);
    }

    public Account disconnect(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/financial_connections/accounts/%s/disconnect", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Account.class, options);
    }

    public Account disconnect(AccountDisconnectParams params) throws StripeException {
        return this.disconnect(params, (RequestOptions)null);
    }

    public Account disconnect(AccountDisconnectParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/financial_connections/accounts/%s/disconnect", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Account.class, options);
    }

    public static AccountCollection list(Map<String, Object> params) throws StripeException {
        return Account.list(params, (RequestOptions)null);
    }

    public static AccountCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/financial_connections/accounts");
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, AccountCollection.class, options);
    }

    public static AccountCollection list(AccountListParams params) throws StripeException {
        return Account.list(params, (RequestOptions)null);
    }

    public static AccountCollection list(AccountListParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/financial_connections/accounts");
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, AccountCollection.class, options);
    }

    public AccountOwnerCollection listOwners(Map<String, Object> params) throws StripeException {
        return this.listOwners(params, (RequestOptions)null);
    }

    public AccountOwnerCollection listOwners(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/financial_connections/accounts/%s/owners", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, AccountOwnerCollection.class, options);
    }

    public AccountOwnerCollection listOwners(AccountListOwnersParams params) throws StripeException {
        return this.listOwners(params, (RequestOptions)null);
    }

    public AccountOwnerCollection listOwners(AccountListOwnersParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/financial_connections/accounts/%s/owners", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, AccountOwnerCollection.class, options);
    }

    public Account refresh(Map<String, Object> params) throws StripeException {
        return this.refresh(params, (RequestOptions)null);
    }

    public Account refresh(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/financial_connections/accounts/%s/refresh", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Account.class, options);
    }

    public Account refresh(AccountRefreshParams params) throws StripeException {
        return this.refresh(params, (RequestOptions)null);
    }

    public Account refresh(AccountRefreshParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/financial_connections/accounts/%s/refresh", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Account.class, options);
    }

    public static Account retrieve(String account) throws StripeException {
        return Account.retrieve(account, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Account retrieve(String account, RequestOptions options) throws StripeException {
        return Account.retrieve(account, (Map<String, Object>)null, options);
    }

    public static Account retrieve(String account, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/financial_connections/accounts/%s", ApiResource.urlEncodeId(account)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Account.class, options);
    }

    public static Account retrieve(String account, AccountRetrieveParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/financial_connections/accounts/%s", ApiResource.urlEncodeId(account)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Account.class, options);
    }

    public Account subscribe(Map<String, Object> params) throws StripeException {
        return this.subscribe(params, (RequestOptions)null);
    }

    public Account subscribe(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/financial_connections/accounts/%s/subscribe", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Account.class, options);
    }

    public Account subscribe(AccountSubscribeParams params) throws StripeException {
        return this.subscribe(params, (RequestOptions)null);
    }

    public Account subscribe(AccountSubscribeParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/financial_connections/accounts/%s/subscribe", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Account.class, options);
    }

    public Account unsubscribe(Map<String, Object> params) throws StripeException {
        return this.unsubscribe(params, (RequestOptions)null);
    }

    public Account unsubscribe(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/financial_connections/accounts/%s/unsubscribe", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Account.class, options);
    }

    public Account unsubscribe(AccountUnsubscribeParams params) throws StripeException {
        return this.unsubscribe(params, (RequestOptions)null);
    }

    public Account unsubscribe(AccountUnsubscribeParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/financial_connections/accounts/%s/unsubscribe", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Account.class, options);
    }

    @Generated
    public AccountHolder getAccountHolder() {
        return this.accountHolder;
    }

    @Generated
    public Balance getBalance() {
        return this.balance;
    }

    @Generated
    public BalanceRefresh getBalanceRefresh() {
        return this.balanceRefresh;
    }

    @Generated
    public String getCategory() {
        return this.category;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public InferredBalancesRefresh getInferredBalancesRefresh() {
        return this.inferredBalancesRefresh;
    }

    @Generated
    public String getInstitutionName() {
        return this.institutionName;
    }

    @Generated
    public String getLast4() {
        return this.last4;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public OwnershipRefresh getOwnershipRefresh() {
        return this.ownershipRefresh;
    }

    @Generated
    public List<String> getPermissions() {
        return this.permissions;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getSubcategory() {
        return this.subcategory;
    }

    @Generated
    public List<String> getSubscriptions() {
        return this.subscriptions;
    }

    @Generated
    public List<String> getSupportedPaymentMethodTypes() {
        return this.supportedPaymentMethodTypes;
    }

    @Generated
    public TransactionRefresh getTransactionRefresh() {
        return this.transactionRefresh;
    }

    @Generated
    public void setAccountHolder(AccountHolder accountHolder) {
        this.accountHolder = accountHolder;
    }

    @Generated
    public void setBalance(Balance balance) {
        this.balance = balance;
    }

    @Generated
    public void setBalanceRefresh(BalanceRefresh balanceRefresh) {
        this.balanceRefresh = balanceRefresh;
    }

    @Generated
    public void setCategory(String category) {
        this.category = category;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setInferredBalancesRefresh(InferredBalancesRefresh inferredBalancesRefresh) {
        this.inferredBalancesRefresh = inferredBalancesRefresh;
    }

    @Generated
    public void setInstitutionName(String institutionName) {
        this.institutionName = institutionName;
    }

    @Generated
    public void setLast4(String last4) {
        this.last4 = last4;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setOwnershipRefresh(OwnershipRefresh ownershipRefresh) {
        this.ownershipRefresh = ownershipRefresh;
    }

    @Generated
    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setSubcategory(String subcategory) {
        this.subcategory = subcategory;
    }

    @Generated
    public void setSubscriptions(List<String> subscriptions) {
        this.subscriptions = subscriptions;
    }

    @Generated
    public void setSupportedPaymentMethodTypes(List<String> supportedPaymentMethodTypes) {
        this.supportedPaymentMethodTypes = supportedPaymentMethodTypes;
    }

    @Generated
    public void setTransactionRefresh(TransactionRefresh transactionRefresh) {
        this.transactionRefresh = transactionRefresh;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Account)) {
            return false;
        }
        Account other = (Account)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        AccountHolder this$accountHolder = this.getAccountHolder();
        AccountHolder other$accountHolder = other.getAccountHolder();
        if (this$accountHolder == null ? other$accountHolder != null : !((Object)this$accountHolder).equals(other$accountHolder)) {
            return false;
        }
        Balance this$balance = this.getBalance();
        Balance other$balance = other.getBalance();
        if (this$balance == null ? other$balance != null : !((Object)this$balance).equals(other$balance)) {
            return false;
        }
        BalanceRefresh this$balanceRefresh = this.getBalanceRefresh();
        BalanceRefresh other$balanceRefresh = other.getBalanceRefresh();
        if (this$balanceRefresh == null ? other$balanceRefresh != null : !((Object)this$balanceRefresh).equals(other$balanceRefresh)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        InferredBalancesRefresh this$inferredBalancesRefresh = this.getInferredBalancesRefresh();
        InferredBalancesRefresh other$inferredBalancesRefresh = other.getInferredBalancesRefresh();
        if (this$inferredBalancesRefresh == null ? other$inferredBalancesRefresh != null : !((Object)this$inferredBalancesRefresh).equals(other$inferredBalancesRefresh)) {
            return false;
        }
        String this$institutionName = this.getInstitutionName();
        String other$institutionName = other.getInstitutionName();
        if (this$institutionName == null ? other$institutionName != null : !this$institutionName.equals(other$institutionName)) {
            return false;
        }
        String this$last4 = this.getLast4();
        String other$last4 = other.getLast4();
        if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$ownership = this.getOwnership();
        String other$ownership = other.getOwnership();
        if (this$ownership == null ? other$ownership != null : !this$ownership.equals(other$ownership)) {
            return false;
        }
        OwnershipRefresh this$ownershipRefresh = this.getOwnershipRefresh();
        OwnershipRefresh other$ownershipRefresh = other.getOwnershipRefresh();
        if (this$ownershipRefresh == null ? other$ownershipRefresh != null : !((Object)this$ownershipRefresh).equals(other$ownershipRefresh)) {
            return false;
        }
        List<String> this$permissions = this.getPermissions();
        List<String> other$permissions = other.getPermissions();
        if (this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$subcategory = this.getSubcategory();
        String other$subcategory = other.getSubcategory();
        if (this$subcategory == null ? other$subcategory != null : !this$subcategory.equals(other$subcategory)) {
            return false;
        }
        List<String> this$subscriptions = this.getSubscriptions();
        List<String> other$subscriptions = other.getSubscriptions();
        if (this$subscriptions == null ? other$subscriptions != null : !((Object)this$subscriptions).equals(other$subscriptions)) {
            return false;
        }
        List<String> this$supportedPaymentMethodTypes = this.getSupportedPaymentMethodTypes();
        List<String> other$supportedPaymentMethodTypes = other.getSupportedPaymentMethodTypes();
        if (this$supportedPaymentMethodTypes == null ? other$supportedPaymentMethodTypes != null : !((Object)this$supportedPaymentMethodTypes).equals(other$supportedPaymentMethodTypes)) {
            return false;
        }
        TransactionRefresh this$transactionRefresh = this.getTransactionRefresh();
        TransactionRefresh other$transactionRefresh = other.getTransactionRefresh();
        return !(this$transactionRefresh == null ? other$transactionRefresh != null : !((Object)this$transactionRefresh).equals(other$transactionRefresh));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Account;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        AccountHolder $accountHolder = this.getAccountHolder();
        result = result * 59 + ($accountHolder == null ? 43 : ((Object)$accountHolder).hashCode());
        Balance $balance = this.getBalance();
        result = result * 59 + ($balance == null ? 43 : ((Object)$balance).hashCode());
        BalanceRefresh $balanceRefresh = this.getBalanceRefresh();
        result = result * 59 + ($balanceRefresh == null ? 43 : ((Object)$balanceRefresh).hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        InferredBalancesRefresh $inferredBalancesRefresh = this.getInferredBalancesRefresh();
        result = result * 59 + ($inferredBalancesRefresh == null ? 43 : ((Object)$inferredBalancesRefresh).hashCode());
        String $institutionName = this.getInstitutionName();
        result = result * 59 + ($institutionName == null ? 43 : $institutionName.hashCode());
        String $last4 = this.getLast4();
        result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $ownership = this.getOwnership();
        result = result * 59 + ($ownership == null ? 43 : $ownership.hashCode());
        OwnershipRefresh $ownershipRefresh = this.getOwnershipRefresh();
        result = result * 59 + ($ownershipRefresh == null ? 43 : ((Object)$ownershipRefresh).hashCode());
        List<String> $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $subcategory = this.getSubcategory();
        result = result * 59 + ($subcategory == null ? 43 : $subcategory.hashCode());
        List<String> $subscriptions = this.getSubscriptions();
        result = result * 59 + ($subscriptions == null ? 43 : ((Object)$subscriptions).hashCode());
        List<String> $supportedPaymentMethodTypes = this.getSupportedPaymentMethodTypes();
        result = result * 59 + ($supportedPaymentMethodTypes == null ? 43 : ((Object)$supportedPaymentMethodTypes).hashCode());
        TransactionRefresh $transactionRefresh = this.getTransactionRefresh();
        result = result * 59 + ($transactionRefresh == null ? 43 : ((Object)$transactionRefresh).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class AccountHolder
    extends StripeObject {
        @SerializedName(value="account")
        ExpandableField<com.stripe.model.Account> account;
        @SerializedName(value="customer")
        ExpandableField<Customer> customer;
        @SerializedName(value="type")
        String type;

        public String getAccount() {
            return this.account != null ? this.account.getId() : null;
        }

        public void setAccount(String id) {
            this.account = ApiResource.setExpandableFieldId(id, this.account);
        }

        public com.stripe.model.Account getAccountObject() {
            return this.account != null ? this.account.getExpanded() : null;
        }

        public void setAccountObject(com.stripe.model.Account expandableObject) {
            this.account = new ExpandableField<com.stripe.model.Account>(expandableObject.getId(), expandableObject);
        }

        public String getCustomer() {
            return this.customer != null ? this.customer.getId() : null;
        }

        public void setCustomer(String id) {
            this.customer = ApiResource.setExpandableFieldId(id, this.customer);
        }

        public Customer getCustomerObject() {
            return this.customer != null ? this.customer.getExpanded() : null;
        }

        public void setCustomerObject(Customer expandableObject) {
            this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AccountHolder)) {
                return false;
            }
            AccountHolder other = (AccountHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$account = this.getAccount();
            String other$account = other.getAccount();
            if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
                return false;
            }
            String this$customer = this.getCustomer();
            String other$customer = other.getCustomer();
            if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AccountHolder;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $account = this.getAccount();
            result = result * 59 + ($account == null ? 43 : $account.hashCode());
            String $customer = this.getCustomer();
            result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }
    }

    public static class Balance
    extends StripeObject {
        @SerializedName(value="as_of")
        Long asOf;
        @SerializedName(value="cash")
        Cash cash;
        @SerializedName(value="credit")
        Credit credit;
        @SerializedName(value="current")
        Map<String, Long> current;
        @SerializedName(value="type")
        String type;

        @Generated
        public Long getAsOf() {
            return this.asOf;
        }

        @Generated
        public Cash getCash() {
            return this.cash;
        }

        @Generated
        public Credit getCredit() {
            return this.credit;
        }

        @Generated
        public Map<String, Long> getCurrent() {
            return this.current;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setAsOf(Long asOf) {
            this.asOf = asOf;
        }

        @Generated
        public void setCash(Cash cash) {
            this.cash = cash;
        }

        @Generated
        public void setCredit(Credit credit) {
            this.credit = credit;
        }

        @Generated
        public void setCurrent(Map<String, Long> current) {
            this.current = current;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Balance)) {
                return false;
            }
            Balance other = (Balance)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$asOf = this.getAsOf();
            Long other$asOf = other.getAsOf();
            if (this$asOf == null ? other$asOf != null : !((Object)this$asOf).equals(other$asOf)) {
                return false;
            }
            Cash this$cash = this.getCash();
            Cash other$cash = other.getCash();
            if (this$cash == null ? other$cash != null : !((Object)this$cash).equals(other$cash)) {
                return false;
            }
            Credit this$credit = this.getCredit();
            Credit other$credit = other.getCredit();
            if (this$credit == null ? other$credit != null : !((Object)this$credit).equals(other$credit)) {
                return false;
            }
            Map<String, Long> this$current = this.getCurrent();
            Map<String, Long> other$current = other.getCurrent();
            if (this$current == null ? other$current != null : !((Object)this$current).equals(other$current)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Balance;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $asOf = this.getAsOf();
            result = result * 59 + ($asOf == null ? 43 : ((Object)$asOf).hashCode());
            Cash $cash = this.getCash();
            result = result * 59 + ($cash == null ? 43 : ((Object)$cash).hashCode());
            Credit $credit = this.getCredit();
            result = result * 59 + ($credit == null ? 43 : ((Object)$credit).hashCode());
            Map<String, Long> $current = this.getCurrent();
            result = result * 59 + ($current == null ? 43 : ((Object)$current).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class Cash
        extends StripeObject {
            @SerializedName(value="available")
            Map<String, Long> available;

            @Generated
            public Map<String, Long> getAvailable() {
                return this.available;
            }

            @Generated
            public void setAvailable(Map<String, Long> available) {
                this.available = available;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Cash)) {
                    return false;
                }
                Cash other = (Cash)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Long> this$available = this.getAvailable();
                Map<String, Long> other$available = other.getAvailable();
                return !(this$available == null ? other$available != null : !((Object)this$available).equals(other$available));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Cash;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Long> $available = this.getAvailable();
                result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
                return result;
            }
        }

        public static class Credit
        extends StripeObject {
            @SerializedName(value="used")
            Map<String, Long> used;

            @Generated
            public Map<String, Long> getUsed() {
                return this.used;
            }

            @Generated
            public void setUsed(Map<String, Long> used) {
                this.used = used;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Credit)) {
                    return false;
                }
                Credit other = (Credit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Long> this$used = this.getUsed();
                Map<String, Long> other$used = other.getUsed();
                return !(this$used == null ? other$used != null : !((Object)this$used).equals(other$used));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Credit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Long> $used = this.getUsed();
                result = result * 59 + ($used == null ? 43 : ((Object)$used).hashCode());
                return result;
            }
        }
    }

    public static class BalanceRefresh
    extends StripeObject {
        @SerializedName(value="last_attempted_at")
        Long lastAttemptedAt;
        @SerializedName(value="next_refresh_available_at")
        Long nextRefreshAvailableAt;
        @SerializedName(value="status")
        String status;

        @Generated
        public Long getLastAttemptedAt() {
            return this.lastAttemptedAt;
        }

        @Generated
        public Long getNextRefreshAvailableAt() {
            return this.nextRefreshAvailableAt;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public void setLastAttemptedAt(Long lastAttemptedAt) {
            this.lastAttemptedAt = lastAttemptedAt;
        }

        @Generated
        public void setNextRefreshAvailableAt(Long nextRefreshAvailableAt) {
            this.nextRefreshAvailableAt = nextRefreshAvailableAt;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BalanceRefresh)) {
                return false;
            }
            BalanceRefresh other = (BalanceRefresh)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$lastAttemptedAt = this.getLastAttemptedAt();
            Long other$lastAttemptedAt = other.getLastAttemptedAt();
            if (this$lastAttemptedAt == null ? other$lastAttemptedAt != null : !((Object)this$lastAttemptedAt).equals(other$lastAttemptedAt)) {
                return false;
            }
            Long this$nextRefreshAvailableAt = this.getNextRefreshAvailableAt();
            Long other$nextRefreshAvailableAt = other.getNextRefreshAvailableAt();
            if (this$nextRefreshAvailableAt == null ? other$nextRefreshAvailableAt != null : !((Object)this$nextRefreshAvailableAt).equals(other$nextRefreshAvailableAt)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !this$status.equals(other$status));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BalanceRefresh;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $lastAttemptedAt = this.getLastAttemptedAt();
            result = result * 59 + ($lastAttemptedAt == null ? 43 : ((Object)$lastAttemptedAt).hashCode());
            Long $nextRefreshAvailableAt = this.getNextRefreshAvailableAt();
            result = result * 59 + ($nextRefreshAvailableAt == null ? 43 : ((Object)$nextRefreshAvailableAt).hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            return result;
        }
    }

    public static class InferredBalancesRefresh
    extends StripeObject {
        @SerializedName(value="last_attempted_at")
        Long lastAttemptedAt;
        @SerializedName(value="next_refresh_available_at")
        Long nextRefreshAvailableAt;
        @SerializedName(value="status")
        String status;

        @Generated
        public Long getLastAttemptedAt() {
            return this.lastAttemptedAt;
        }

        @Generated
        public Long getNextRefreshAvailableAt() {
            return this.nextRefreshAvailableAt;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public void setLastAttemptedAt(Long lastAttemptedAt) {
            this.lastAttemptedAt = lastAttemptedAt;
        }

        @Generated
        public void setNextRefreshAvailableAt(Long nextRefreshAvailableAt) {
            this.nextRefreshAvailableAt = nextRefreshAvailableAt;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InferredBalancesRefresh)) {
                return false;
            }
            InferredBalancesRefresh other = (InferredBalancesRefresh)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$lastAttemptedAt = this.getLastAttemptedAt();
            Long other$lastAttemptedAt = other.getLastAttemptedAt();
            if (this$lastAttemptedAt == null ? other$lastAttemptedAt != null : !((Object)this$lastAttemptedAt).equals(other$lastAttemptedAt)) {
                return false;
            }
            Long this$nextRefreshAvailableAt = this.getNextRefreshAvailableAt();
            Long other$nextRefreshAvailableAt = other.getNextRefreshAvailableAt();
            if (this$nextRefreshAvailableAt == null ? other$nextRefreshAvailableAt != null : !((Object)this$nextRefreshAvailableAt).equals(other$nextRefreshAvailableAt)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !this$status.equals(other$status));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InferredBalancesRefresh;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $lastAttemptedAt = this.getLastAttemptedAt();
            result = result * 59 + ($lastAttemptedAt == null ? 43 : ((Object)$lastAttemptedAt).hashCode());
            Long $nextRefreshAvailableAt = this.getNextRefreshAvailableAt();
            result = result * 59 + ($nextRefreshAvailableAt == null ? 43 : ((Object)$nextRefreshAvailableAt).hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            return result;
        }
    }

    public static class OwnershipRefresh
    extends StripeObject {
        @SerializedName(value="last_attempted_at")
        Long lastAttemptedAt;
        @SerializedName(value="next_refresh_available_at")
        Long nextRefreshAvailableAt;
        @SerializedName(value="status")
        String status;

        @Generated
        public Long getLastAttemptedAt() {
            return this.lastAttemptedAt;
        }

        @Generated
        public Long getNextRefreshAvailableAt() {
            return this.nextRefreshAvailableAt;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public void setLastAttemptedAt(Long lastAttemptedAt) {
            this.lastAttemptedAt = lastAttemptedAt;
        }

        @Generated
        public void setNextRefreshAvailableAt(Long nextRefreshAvailableAt) {
            this.nextRefreshAvailableAt = nextRefreshAvailableAt;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OwnershipRefresh)) {
                return false;
            }
            OwnershipRefresh other = (OwnershipRefresh)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$lastAttemptedAt = this.getLastAttemptedAt();
            Long other$lastAttemptedAt = other.getLastAttemptedAt();
            if (this$lastAttemptedAt == null ? other$lastAttemptedAt != null : !((Object)this$lastAttemptedAt).equals(other$lastAttemptedAt)) {
                return false;
            }
            Long this$nextRefreshAvailableAt = this.getNextRefreshAvailableAt();
            Long other$nextRefreshAvailableAt = other.getNextRefreshAvailableAt();
            if (this$nextRefreshAvailableAt == null ? other$nextRefreshAvailableAt != null : !((Object)this$nextRefreshAvailableAt).equals(other$nextRefreshAvailableAt)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !this$status.equals(other$status));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OwnershipRefresh;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $lastAttemptedAt = this.getLastAttemptedAt();
            result = result * 59 + ($lastAttemptedAt == null ? 43 : ((Object)$lastAttemptedAt).hashCode());
            Long $nextRefreshAvailableAt = this.getNextRefreshAvailableAt();
            result = result * 59 + ($nextRefreshAvailableAt == null ? 43 : ((Object)$nextRefreshAvailableAt).hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            return result;
        }
    }

    public static class TransactionRefresh
    extends StripeObject
    implements HasId {
        @SerializedName(value="id")
        String id;
        @SerializedName(value="last_attempted_at")
        Long lastAttemptedAt;
        @SerializedName(value="next_refresh_available_at")
        Long nextRefreshAvailableAt;
        @SerializedName(value="status")
        String status;

        @Generated
        public Long getLastAttemptedAt() {
            return this.lastAttemptedAt;
        }

        @Generated
        public Long getNextRefreshAvailableAt() {
            return this.nextRefreshAvailableAt;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setLastAttemptedAt(Long lastAttemptedAt) {
            this.lastAttemptedAt = lastAttemptedAt;
        }

        @Generated
        public void setNextRefreshAvailableAt(Long nextRefreshAvailableAt) {
            this.nextRefreshAvailableAt = nextRefreshAvailableAt;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransactionRefresh)) {
                return false;
            }
            TransactionRefresh other = (TransactionRefresh)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$lastAttemptedAt = this.getLastAttemptedAt();
            Long other$lastAttemptedAt = other.getLastAttemptedAt();
            if (this$lastAttemptedAt == null ? other$lastAttemptedAt != null : !((Object)this$lastAttemptedAt).equals(other$lastAttemptedAt)) {
                return false;
            }
            Long this$nextRefreshAvailableAt = this.getNextRefreshAvailableAt();
            Long other$nextRefreshAvailableAt = other.getNextRefreshAvailableAt();
            if (this$nextRefreshAvailableAt == null ? other$nextRefreshAvailableAt != null : !((Object)this$nextRefreshAvailableAt).equals(other$nextRefreshAvailableAt)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !this$status.equals(other$status));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TransactionRefresh;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $lastAttemptedAt = this.getLastAttemptedAt();
            result = result * 59 + ($lastAttemptedAt == null ? 43 : ((Object)$lastAttemptedAt).hashCode());
            Long $nextRefreshAvailableAt = this.getNextRefreshAvailableAt();
            result = result * 59 + ($nextRefreshAvailableAt == null ? 43 : ((Object)$nextRefreshAvailableAt).hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            return result;
        }

        @Override
        @Generated
        public String getId() {
            return this.id;
        }
    }
}

