/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.EventCollection;
import com.stripe.model.EventDataObjectDeserializer;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.EventListParams;
import com.stripe.param.EventRetrieveParams;
import java.util.Map;
import lombok.Generated;

public class Event
extends ApiResource
implements HasId {
    @SerializedName(value="account")
    String account;
    @SerializedName(value="api_version")
    String apiVersion;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="data")
    Data data;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="pending_webhooks")
    Long pendingWebhooks;
    @SerializedName(value="request")
    Request request;
    @SerializedName(value="type")
    String type;

    public static EventCollection list(Map<String, Object> params) throws StripeException {
        return Event.list(params, (RequestOptions)null);
    }

    public static EventCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/events");
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, EventCollection.class, options);
    }

    public static EventCollection list(EventListParams params) throws StripeException {
        return Event.list(params, (RequestOptions)null);
    }

    public static EventCollection list(EventListParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/events");
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, EventCollection.class, options);
    }

    public static Event retrieve(String id) throws StripeException {
        return Event.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Event retrieve(String id, RequestOptions options) throws StripeException {
        return Event.retrieve(id, (Map<String, Object>)null, options);
    }

    public static Event retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/events/%s", ApiResource.urlEncodeId(id)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Event.class, options);
    }

    public static Event retrieve(String id, EventRetrieveParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/events/%s", ApiResource.urlEncodeId(id)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Event.class, options);
    }

    public EventDataObjectDeserializer getDataObjectDeserializer() {
        return new EventDataObjectDeserializer(this.apiVersion, this.type, this.data.object);
    }

    @Generated
    public String getAccount() {
        return this.account;
    }

    @Generated
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Data getData() {
        return this.data;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Long getPendingWebhooks() {
        return this.pendingWebhooks;
    }

    @Generated
    public Request getRequest() {
        return this.request;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setAccount(String account) {
        this.account = account;
    }

    @Generated
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setData(Data data) {
        this.data = data;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPendingWebhooks(Long pendingWebhooks) {
        this.pendingWebhooks = pendingWebhooks;
    }

    @Generated
    public void setRequest(Request request) {
        this.request = request;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$pendingWebhooks = this.getPendingWebhooks();
        Long other$pendingWebhooks = other.getPendingWebhooks();
        if (this$pendingWebhooks == null ? other$pendingWebhooks != null : !((Object)this$pendingWebhooks).equals(other$pendingWebhooks)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        Data this$data = this.getData();
        Data other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Request this$request = this.getRequest();
        Request other$request = other.getRequest();
        if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Event;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $pendingWebhooks = this.getPendingWebhooks();
        result = result * 59 + ($pendingWebhooks == null ? 43 : ((Object)$pendingWebhooks).hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        Data $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Request $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class Data
    extends StripeObject {
        @SerializedName(value="previous_attributes")
        Map<String, Object> previousAttributes;
        @SerializedName(value="object")
        JsonObject object;

        @Deprecated
        public StripeObject getObject() {
            return StripeObject.deserializeStripeObject(this.object);
        }

        @Generated
        public Map<String, Object> getPreviousAttributes() {
            return this.previousAttributes;
        }

        @Generated
        public void setPreviousAttributes(Map<String, Object> previousAttributes) {
            this.previousAttributes = previousAttributes;
        }

        @Generated
        public void setObject(JsonObject object) {
            this.object = object;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Data)) {
                return false;
            }
            Data other = (Data)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Object> this$previousAttributes = this.getPreviousAttributes();
            Map<String, Object> other$previousAttributes = other.getPreviousAttributes();
            if (this$previousAttributes == null ? other$previousAttributes != null : !((Object)this$previousAttributes).equals(other$previousAttributes)) {
                return false;
            }
            StripeObject this$object = this.getObject();
            StripeObject other$object = other.getObject();
            return !(this$object == null ? other$object != null : !this$object.equals(other$object));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Data;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Object> $previousAttributes = this.getPreviousAttributes();
            result = result * 59 + ($previousAttributes == null ? 43 : ((Object)$previousAttributes).hashCode());
            StripeObject $object = this.getObject();
            result = result * 59 + ($object == null ? 43 : $object.hashCode());
            return result;
        }
    }

    public static class Request
    extends StripeObject
    implements HasId {
        @SerializedName(value="id")
        String id;
        @SerializedName(value="idempotency_key")
        String idempotencyKey;

        @Generated
        public String getIdempotencyKey() {
            return this.idempotencyKey;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setIdempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Request)) {
                return false;
            }
            Request other = (Request)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$idempotencyKey = this.getIdempotencyKey();
            String other$idempotencyKey = other.getIdempotencyKey();
            return !(this$idempotencyKey == null ? other$idempotencyKey != null : !this$idempotencyKey.equals(other$idempotencyKey));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Request;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $idempotencyKey = this.getIdempotencyKey();
            result = result * 59 + ($idempotencyKey == null ? 43 : $idempotencyKey.hashCode());
            return result;
        }

        @Override
        @Generated
        public String getId() {
            return this.id;
        }
    }
}

