/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.issuing;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.issuing.CardBundle;
import com.stripe.model.issuing.CardDesignCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.issuing.CardDesignActivateTestmodeParams;
import com.stripe.param.issuing.CardDesignDeactivateTestmodeParams;
import com.stripe.param.issuing.CardDesignListParams;
import com.stripe.param.issuing.CardDesignRetrieveParams;
import com.stripe.param.issuing.CardDesignUpdateParams;
import java.util.Map;
import lombok.Generated;

public class CardDesign
extends ApiResource
implements HasId,
MetadataStore<CardDesign> {
    @SerializedName(value="card_bundle")
    ExpandableField<CardBundle> cardBundle;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="lookup_key")
    String lookupKey;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="name")
    String name;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="preference")
    String preference;
    @SerializedName(value="status")
    String status;

    public String getCardBundle() {
        return this.cardBundle != null ? this.cardBundle.getId() : null;
    }

    public void setCardBundle(String id) {
        this.cardBundle = ApiResource.setExpandableFieldId(id, this.cardBundle);
    }

    public CardBundle getCardBundleObject() {
        return this.cardBundle != null ? this.cardBundle.getExpanded() : null;
    }

    public void setCardBundleObject(CardBundle expandableObject) {
        this.cardBundle = new ExpandableField<CardBundle>(expandableObject.getId(), expandableObject);
    }

    public static CardDesignCollection list(Map<String, Object> params) throws StripeException {
        return CardDesign.list(params, (RequestOptions)null);
    }

    public static CardDesignCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/issuing/card_designs");
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, CardDesignCollection.class, options);
    }

    public static CardDesignCollection list(CardDesignListParams params) throws StripeException {
        return CardDesign.list(params, (RequestOptions)null);
    }

    public static CardDesignCollection list(CardDesignListParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/issuing/card_designs");
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, CardDesignCollection.class, options);
    }

    public static CardDesign retrieve(String cardDesign) throws StripeException {
        return CardDesign.retrieve(cardDesign, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static CardDesign retrieve(String cardDesign, RequestOptions options) throws StripeException {
        return CardDesign.retrieve(cardDesign, (Map<String, Object>)null, options);
    }

    public static CardDesign retrieve(String cardDesign, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/issuing/card_designs/%s", ApiResource.urlEncodeId(cardDesign)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, CardDesign.class, options);
    }

    public static CardDesign retrieve(String cardDesign, CardDesignRetrieveParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/issuing/card_designs/%s", ApiResource.urlEncodeId(cardDesign)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, CardDesign.class, options);
    }

    public CardDesign update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public CardDesign update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/issuing/card_designs/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, CardDesign.class, options);
    }

    public CardDesign update(CardDesignUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public CardDesign update(CardDesignUpdateParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/issuing/card_designs/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, CardDesign.class, options);
    }

    public TestHelpers getTestHelpers() {
        return new TestHelpers(this);
    }

    @Generated
    public String getLookupKey() {
        return this.lookupKey;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getPreference() {
        return this.preference;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLookupKey(String lookupKey) {
        this.lookupKey = lookupKey;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPreference(String preference) {
        this.preference = preference;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CardDesign)) {
            return false;
        }
        CardDesign other = (CardDesign)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$cardBundle = this.getCardBundle();
        String other$cardBundle = other.getCardBundle();
        if (this$cardBundle == null ? other$cardBundle != null : !this$cardBundle.equals(other$cardBundle)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$lookupKey = this.getLookupKey();
        String other$lookupKey = other.getLookupKey();
        if (this$lookupKey == null ? other$lookupKey != null : !this$lookupKey.equals(other$lookupKey)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$preference = this.getPreference();
        String other$preference = other.getPreference();
        if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !this$status.equals(other$status));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CardDesign;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $cardBundle = this.getCardBundle();
        result = result * 59 + ($cardBundle == null ? 43 : $cardBundle.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $lookupKey = this.getLookupKey();
        result = result * 59 + ($lookupKey == null ? 43 : $lookupKey.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $preference = this.getPreference();
        result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class TestHelpers {
        private final CardDesign resource;

        private TestHelpers(CardDesign resource) {
            this.resource = resource;
        }

        public CardDesign activateTestmode() throws StripeException {
            return this.activateTestmode((Map<String, Object>)null, (RequestOptions)null);
        }

        public CardDesign activateTestmode(RequestOptions options) throws StripeException {
            return this.activateTestmode((Map<String, Object>)null, options);
        }

        public CardDesign activateTestmode(Map<String, Object> params) throws StripeException {
            return this.activateTestmode(params, (RequestOptions)null);
        }

        public CardDesign activateTestmode(Map<String, Object> params, RequestOptions options) throws StripeException {
            String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/test_helpers/issuing/card_designs/%s/status/activate", ApiResource.urlEncodeId(this.resource.getId())));
            return ApiResource.request(ApiResource.RequestMethod.POST, url, params, CardDesign.class, options);
        }

        public CardDesign activateTestmode(CardDesignActivateTestmodeParams params) throws StripeException {
            return this.activateTestmode(params, (RequestOptions)null);
        }

        public CardDesign activateTestmode(CardDesignActivateTestmodeParams params, RequestOptions options) throws StripeException {
            String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/test_helpers/issuing/card_designs/%s/status/activate", ApiResource.urlEncodeId(this.resource.getId())));
            return ApiResource.request(ApiResource.RequestMethod.POST, url, params, CardDesign.class, options);
        }

        public CardDesign deactivateTestmode() throws StripeException {
            return this.deactivateTestmode((Map<String, Object>)null, (RequestOptions)null);
        }

        public CardDesign deactivateTestmode(RequestOptions options) throws StripeException {
            return this.deactivateTestmode((Map<String, Object>)null, options);
        }

        public CardDesign deactivateTestmode(Map<String, Object> params) throws StripeException {
            return this.deactivateTestmode(params, (RequestOptions)null);
        }

        public CardDesign deactivateTestmode(Map<String, Object> params, RequestOptions options) throws StripeException {
            String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/test_helpers/issuing/card_designs/%s/status/deactivate", ApiResource.urlEncodeId(this.resource.getId())));
            return ApiResource.request(ApiResource.RequestMethod.POST, url, params, CardDesign.class, options);
        }

        public CardDesign deactivateTestmode(CardDesignDeactivateTestmodeParams params) throws StripeException {
            return this.deactivateTestmode(params, (RequestOptions)null);
        }

        public CardDesign deactivateTestmode(CardDesignDeactivateTestmodeParams params, RequestOptions options) throws StripeException {
            String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/test_helpers/issuing/card_designs/%s/status/deactivate", ApiResource.urlEncodeId(this.resource.getId())));
            return ApiResource.request(ApiResource.RequestMethod.POST, url, params, CardDesign.class, options);
        }
    }
}

