// Generated by delombok at Thu Dec 08 23:15:20 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.AccountSessionCreateParams;
import java.util.Map;

/**
 * An AccountSession allows a Connect platform to grant access to a connected account in Connect
 * embedded UIs.
 *
 * <p>We recommend that you create an AccountSession each time you need to display an embedded UI to
 * your user. Do not save AccountSessions to your database as they expire relatively quickly, and
 * cannot be used more than once.
 *
 * <p>Related guide: <a
 * href="https://stripe.com/docs/connect/get-started-connect-embedded-uis">Connect embedded UIs</a>.
 */
public class AccountSession extends ApiResource {
  /**
   * The ID of the account the AccountSession was created for.
   */
  @SerializedName("account")
  String account;
  /**
   * The client secret of this AccountSession. Used on the client to set up secure access to the
   * given {@code account}.
   *
   * <p>The client secret can be used to provide access to {@code account} from your frontend. It
   * should not be stored, logged, or exposed to anyone other than the connected account. Make sure
   * that you have TLS enabled on any page that includes the client secret.
   *
   * <p>Refer to our docs to <a
   * href="https://stripe.com/docs/connect/get-started-connect-embedded-uis">setup Connect embedded
   * UIs</a> and learn about how {@code client_secret} should be handled.
   */
  @SerializedName("client_secret")
  String clientSecret;
  /**
   * The timestamp at which this AccountSession will expire.
   */
  @SerializedName("expires_at")
  Long expiresAt;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code account_session}.
   */
  @SerializedName("object")
  String object;

  /**
   * Creates a AccountSession object that includes a single-use token that the platform can use on
   * their front-end to grant client-side API access.
   */
  public static AccountSession create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a AccountSession object that includes a single-use token that the platform can use on
   * their front-end to grant client-side API access.
   */
  public static AccountSession create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/account_sessions");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, AccountSession.class, options);
  }

  /**
   * Creates a AccountSession object that includes a single-use token that the platform can use on
   * their front-end to grant client-side API access.
   */
  public static AccountSession create(AccountSessionCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a AccountSession object that includes a single-use token that the platform can use on
   * their front-end to grant client-side API access.
   */
  public static AccountSession create(AccountSessionCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/account_sessions");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, AccountSession.class, options);
  }

  /**
   * The ID of the account the AccountSession was created for.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getAccount() {
    return this.account;
  }

  /**
   * The client secret of this AccountSession. Used on the client to set up secure access to the
   * given {@code account}.
   *
   * <p>The client secret can be used to provide access to {@code account} from your frontend. It
   * should not be stored, logged, or exposed to anyone other than the connected account. Make sure
   * that you have TLS enabled on any page that includes the client secret.
   *
   * <p>Refer to our docs to <a
   * href="https://stripe.com/docs/connect/get-started-connect-embedded-uis">setup Connect embedded
   * UIs</a> and learn about how {@code client_secret} should be handled.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getClientSecret() {
    return this.clientSecret;
  }

  /**
   * The timestamp at which this AccountSession will expire.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getExpiresAt() {
    return this.expiresAt;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code account_session}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * The ID of the account the AccountSession was created for.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAccount(final String account) {
    this.account = account;
  }

  /**
   * The client secret of this AccountSession. Used on the client to set up secure access to the
   * given {@code account}.
   *
   * <p>The client secret can be used to provide access to {@code account} from your frontend. It
   * should not be stored, logged, or exposed to anyone other than the connected account. Make sure
   * that you have TLS enabled on any page that includes the client secret.
   *
   * <p>Refer to our docs to <a
   * href="https://stripe.com/docs/connect/get-started-connect-embedded-uis">setup Connect embedded
   * UIs</a> and learn about how {@code client_secret} should be handled.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setClientSecret(final String clientSecret) {
    this.clientSecret = clientSecret;
  }

  /**
   * The timestamp at which this AccountSession will expire.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setExpiresAt(final Long expiresAt) {
    this.expiresAt = expiresAt;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code account_session}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof AccountSession)) return false;
    final AccountSession other = (AccountSession) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$expiresAt = this.getExpiresAt();
    final java.lang.Object other$expiresAt = other.getExpiresAt();
    if (this$expiresAt == null ? other$expiresAt != null : !this$expiresAt.equals(other$expiresAt)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$account = this.getAccount();
    final java.lang.Object other$account = other.getAccount();
    if (this$account == null ? other$account != null : !this$account.equals(other$account)) return false;
    final java.lang.Object this$clientSecret = this.getClientSecret();
    final java.lang.Object other$clientSecret = other.getClientSecret();
    if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof AccountSession;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $expiresAt = this.getExpiresAt();
    result = result * PRIME + ($expiresAt == null ? 43 : $expiresAt.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $account = this.getAccount();
    result = result * PRIME + ($account == null ? 43 : $account.hashCode());
    final java.lang.Object $clientSecret = this.getClientSecret();
    result = result * PRIME + ($clientSecret == null ? 43 : $clientSecret.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    return result;
  }
}
