// Generated by delombok at Thu Dec 08 23:15:20 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model.giftcards;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.giftcards.TransactionCancelParams;
import com.stripe.param.giftcards.TransactionConfirmParams;
import com.stripe.param.giftcards.TransactionCreateParams;
import com.stripe.param.giftcards.TransactionListParams;
import com.stripe.param.giftcards.TransactionRetrieveParams;
import com.stripe.param.giftcards.TransactionUpdateParams;
import java.util.Map;

/**
 * A gift card transaction represents a single transaction on a referenced gift card. A transaction
 * is in one of three states, {@code confirmed}, {@code held} or {@code canceled}. A {@code
 * confirmed} transaction is one that has added/deducted funds. A {@code held} transaction has
 * created a temporary hold on funds, which can then be cancelled or confirmed. A {@code held}
 * transaction can be confirmed into a {@code confirmed} transaction, or canceled into a {@code
 * canceled} transaction. A {@code canceled} transaction has no effect on a gift card's balance.
 */
public class Transaction extends ApiResource implements HasId, MetadataStore<Transaction> {
  /**
   * The amount of this transaction. A positive value indicates that funds were added to the gift
   * card. A negative value indicates that funds were removed from the gift card.
   */
  @SerializedName("amount")
  Long amount;
  /**
   * Time at which the transaction was confirmed. Measured in seconds since the Unix epoch.
   */
  @SerializedName("confirmed_at")
  Long confirmedAt;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * The related Stripe objects that created this gift card transaction.
   */
  @SerializedName("created_by")
  CreatedBy createdBy;
  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @SerializedName("currency")
  String currency;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @SerializedName("description")
  String description;
  /**
   * The gift card that this transaction occurred on.
   */
  @SerializedName("gift_card")
  String giftCard;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code gift_cards.transaction}.
   */
  @SerializedName("object")
  String object;
  /**
   * Status of this transaction, one of {@code held}, {@code confirmed}, or {@code canceled}.
   */
  @SerializedName("status")
  String status;
  /**
   * A string that identifies this transaction as part of a group. See the <a
   * href="https://stripe.com/docs/connect/charges-transfers">Connect documentation</a> for details.
   */
  @SerializedName("transfer_group")
  String transferGroup;

  /**
   * Cancel a gift card transaction.
   */
  public Transaction cancel() throws StripeException {
    return cancel((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Cancel a gift card transaction.
   */
  public Transaction cancel(RequestOptions options) throws StripeException {
    return cancel((Map<String, Object>) null, options);
  }

  /**
   * Cancel a gift card transaction.
   */
  public Transaction cancel(Map<String, Object> params) throws StripeException {
    return cancel(params, (RequestOptions) null);
  }

  /**
   * Cancel a gift card transaction.
   */
  public Transaction cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/gift_cards/transactions/%s/cancel", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Transaction.class, options);
  }

  /**
   * Cancel a gift card transaction.
   */
  public Transaction cancel(TransactionCancelParams params) throws StripeException {
    return cancel(params, (RequestOptions) null);
  }

  /**
   * Cancel a gift card transaction.
   */
  public Transaction cancel(TransactionCancelParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/gift_cards/transactions/%s/cancel", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Transaction.class, options);
  }

  /**
   * Confirm a gift card transaction.
   */
  public Transaction confirm() throws StripeException {
    return confirm((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Confirm a gift card transaction.
   */
  public Transaction confirm(RequestOptions options) throws StripeException {
    return confirm((Map<String, Object>) null, options);
  }

  /**
   * Confirm a gift card transaction.
   */
  public Transaction confirm(Map<String, Object> params) throws StripeException {
    return confirm(params, (RequestOptions) null);
  }

  /**
   * Confirm a gift card transaction.
   */
  public Transaction confirm(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/gift_cards/transactions/%s/confirm", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Transaction.class, options);
  }

  /**
   * Confirm a gift card transaction.
   */
  public Transaction confirm(TransactionConfirmParams params) throws StripeException {
    return confirm(params, (RequestOptions) null);
  }

  /**
   * Confirm a gift card transaction.
   */
  public Transaction confirm(TransactionConfirmParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/gift_cards/transactions/%s/confirm", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Transaction.class, options);
  }

  /**
   * Create a gift card transaction.
   */
  public static Transaction create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Create a gift card transaction.
   */
  public static Transaction create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/gift_cards/transactions");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Transaction.class, options);
  }

  /**
   * Create a gift card transaction.
   */
  public static Transaction create(TransactionCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Create a gift card transaction.
   */
  public static Transaction create(TransactionCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/gift_cards/transactions");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Transaction.class, options);
  }

  /**
   * List gift card transactions for a gift card.
   */
  public static TransactionCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * List gift card transactions for a gift card.
   */
  public static TransactionCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/gift_cards/transactions");
    return ApiResource.requestCollection(url, params, TransactionCollection.class, options);
  }

  /**
   * List gift card transactions for a gift card.
   */
  public static TransactionCollection list(TransactionListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * List gift card transactions for a gift card.
   */
  public static TransactionCollection list(TransactionListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/gift_cards/transactions");
    return ApiResource.requestCollection(url, params, TransactionCollection.class, options);
  }

  /**
   * Retrieves the gift card transaction.
   */
  public static Transaction retrieve(String id) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the gift card transaction.
   */
  public static Transaction retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the gift card transaction.
   */
  public static Transaction retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/gift_cards/transactions/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Transaction.class, options);
  }

  /**
   * Retrieves the gift card transaction.
   */
  public static Transaction retrieve(String id, TransactionRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/gift_cards/transactions/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Transaction.class, options);
  }

  /**
   * Update a gift card transaction.
   */
  @Override
  public Transaction update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Update a gift card transaction.
   */
  @Override
  public Transaction update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/gift_cards/transactions/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Transaction.class, options);
  }

  /**
   * Update a gift card transaction.
   */
  public Transaction update(TransactionUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Update a gift card transaction.
   */
  public Transaction update(TransactionUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/gift_cards/transactions/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Transaction.class, options);
  }


  public static class CreatedBy extends StripeObject {
    @SerializedName("checkout")
    Checkout checkout;
    @SerializedName("order")
    Order order;
    @SerializedName("payment")
    Payment payment;
    /**
     * The type of event that created this object.
     *
     * <p>One of {@code checkout}, {@code order}, or {@code payment}.
     */
    @SerializedName("type")
    String type;


    public static class Checkout extends StripeObject {
      /** The Stripe CheckoutSession that created this object. */
      @SerializedName("checkout_session")
      String checkoutSession;
      /** The Stripe CheckoutSession LineItem that created this object. */
      @SerializedName("line_item")
      String lineItem;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCheckoutSession() {
        return this.checkoutSession;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getLineItem() {
        return this.lineItem;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCheckoutSession(final String checkoutSession) {
        this.checkoutSession = checkoutSession;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setLineItem(final String lineItem) {
        this.lineItem = lineItem;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Transaction.CreatedBy.Checkout)) return false;
        final Transaction.CreatedBy.Checkout other = (Transaction.CreatedBy.Checkout) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$checkoutSession = this.getCheckoutSession();
        final java.lang.Object other$checkoutSession = other.getCheckoutSession();
        if (this$checkoutSession == null ? other$checkoutSession != null : !this$checkoutSession.equals(other$checkoutSession)) return false;
        final java.lang.Object this$lineItem = this.getLineItem();
        final java.lang.Object other$lineItem = other.getLineItem();
        if (this$lineItem == null ? other$lineItem != null : !this$lineItem.equals(other$lineItem)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Transaction.CreatedBy.Checkout;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $checkoutSession = this.getCheckoutSession();
        result = result * PRIME + ($checkoutSession == null ? 43 : $checkoutSession.hashCode());
        final java.lang.Object $lineItem = this.getLineItem();
        result = result * PRIME + ($lineItem == null ? 43 : $lineItem.hashCode());
        return result;
      }
    }


    public static class Order extends StripeObject {
      /** The Stripe Order LineItem that created this object. */
      @SerializedName("line_item")
      String lineItem;
      /** The Stripe Order that created this object. */
      @SerializedName("order")
      String order;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getLineItem() {
        return this.lineItem;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getOrder() {
        return this.order;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setLineItem(final String lineItem) {
        this.lineItem = lineItem;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setOrder(final String order) {
        this.order = order;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Transaction.CreatedBy.Order)) return false;
        final Transaction.CreatedBy.Order other = (Transaction.CreatedBy.Order) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$lineItem = this.getLineItem();
        final java.lang.Object other$lineItem = other.getLineItem();
        if (this$lineItem == null ? other$lineItem != null : !this$lineItem.equals(other$lineItem)) return false;
        final java.lang.Object this$order = this.getOrder();
        final java.lang.Object other$order = other.getOrder();
        if (this$order == null ? other$order != null : !this$order.equals(other$order)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Transaction.CreatedBy.Order;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $lineItem = this.getLineItem();
        result = result * PRIME + ($lineItem == null ? 43 : $lineItem.hashCode());
        final java.lang.Object $order = this.getOrder();
        result = result * PRIME + ($order == null ? 43 : $order.hashCode());
        return result;
      }
    }


    public static class Payment extends StripeObject {
      /** The PaymentIntent that created this object. */
      @SerializedName("payment_intent")
      String paymentIntent;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getPaymentIntent() {
        return this.paymentIntent;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setPaymentIntent(final String paymentIntent) {
        this.paymentIntent = paymentIntent;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Transaction.CreatedBy.Payment)) return false;
        final Transaction.CreatedBy.Payment other = (Transaction.CreatedBy.Payment) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$paymentIntent = this.getPaymentIntent();
        final java.lang.Object other$paymentIntent = other.getPaymentIntent();
        if (this$paymentIntent == null ? other$paymentIntent != null : !this$paymentIntent.equals(other$paymentIntent)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Transaction.CreatedBy.Payment;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $paymentIntent = this.getPaymentIntent();
        result = result * PRIME + ($paymentIntent == null ? 43 : $paymentIntent.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Checkout getCheckout() {
      return this.checkout;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Order getOrder() {
      return this.order;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Payment getPayment() {
      return this.payment;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCheckout(final Checkout checkout) {
      this.checkout = checkout;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setOrder(final Order order) {
      this.order = order;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPayment(final Payment payment) {
      this.payment = payment;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Transaction.CreatedBy)) return false;
      final Transaction.CreatedBy other = (Transaction.CreatedBy) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$checkout = this.getCheckout();
      final java.lang.Object other$checkout = other.getCheckout();
      if (this$checkout == null ? other$checkout != null : !this$checkout.equals(other$checkout)) return false;
      final java.lang.Object this$order = this.getOrder();
      final java.lang.Object other$order = other.getOrder();
      if (this$order == null ? other$order != null : !this$order.equals(other$order)) return false;
      final java.lang.Object this$payment = this.getPayment();
      final java.lang.Object other$payment = other.getPayment();
      if (this$payment == null ? other$payment != null : !this$payment.equals(other$payment)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Transaction.CreatedBy;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $checkout = this.getCheckout();
      result = result * PRIME + ($checkout == null ? 43 : $checkout.hashCode());
      final java.lang.Object $order = this.getOrder();
      result = result * PRIME + ($order == null ? 43 : $order.hashCode());
      final java.lang.Object $payment = this.getPayment();
      result = result * PRIME + ($payment == null ? 43 : $payment.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      return result;
    }
  }

  /**
   * The amount of this transaction. A positive value indicates that funds were added to the gift
   * card. A negative value indicates that funds were removed from the gift card.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmount() {
    return this.amount;
  }

  /**
   * Time at which the transaction was confirmed. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getConfirmedAt() {
    return this.confirmedAt;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * The related Stripe objects that created this gift card transaction.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public CreatedBy getCreatedBy() {
    return this.createdBy;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDescription() {
    return this.description;
  }

  /**
   * The gift card that this transaction occurred on.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getGiftCard() {
    return this.giftCard;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code gift_cards.transaction}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Status of this transaction, one of {@code held}, {@code confirmed}, or {@code canceled}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  /**
   * A string that identifies this transaction as part of a group. See the <a
   * href="https://stripe.com/docs/connect/charges-transfers">Connect documentation</a> for details.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getTransferGroup() {
    return this.transferGroup;
  }

  /**
   * The amount of this transaction. A positive value indicates that funds were added to the gift
   * card. A negative value indicates that funds were removed from the gift card.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final Long amount) {
    this.amount = amount;
  }

  /**
   * Time at which the transaction was confirmed. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setConfirmedAt(final Long confirmedAt) {
    this.confirmedAt = confirmedAt;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * The related Stripe objects that created this gift card transaction.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreatedBy(final CreatedBy createdBy) {
    this.createdBy = createdBy;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDescription(final String description) {
    this.description = description;
  }

  /**
   * The gift card that this transaction occurred on.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setGiftCard(final String giftCard) {
    this.giftCard = giftCard;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code gift_cards.transaction}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Status of this transaction, one of {@code held}, {@code confirmed}, or {@code canceled}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  /**
   * A string that identifies this transaction as part of a group. See the <a
   * href="https://stripe.com/docs/connect/charges-transfers">Connect documentation</a> for details.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTransferGroup(final String transferGroup) {
    this.transferGroup = transferGroup;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Transaction)) return false;
    final Transaction other = (Transaction) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$confirmedAt = this.getConfirmedAt();
    final java.lang.Object other$confirmedAt = other.getConfirmedAt();
    if (this$confirmedAt == null ? other$confirmedAt != null : !this$confirmedAt.equals(other$confirmedAt)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$createdBy = this.getCreatedBy();
    final java.lang.Object other$createdBy = other.getCreatedBy();
    if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$description = this.getDescription();
    final java.lang.Object other$description = other.getDescription();
    if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
    final java.lang.Object this$giftCard = this.getGiftCard();
    final java.lang.Object other$giftCard = other.getGiftCard();
    if (this$giftCard == null ? other$giftCard != null : !this$giftCard.equals(other$giftCard)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$transferGroup = this.getTransferGroup();
    final java.lang.Object other$transferGroup = other.getTransferGroup();
    if (this$transferGroup == null ? other$transferGroup != null : !this$transferGroup.equals(other$transferGroup)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Transaction;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $confirmedAt = this.getConfirmedAt();
    result = result * PRIME + ($confirmedAt == null ? 43 : $confirmedAt.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $createdBy = this.getCreatedBy();
    result = result * PRIME + ($createdBy == null ? 43 : $createdBy.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $description = this.getDescription();
    result = result * PRIME + ($description == null ? 43 : $description.hashCode());
    final java.lang.Object $giftCard = this.getGiftCard();
    result = result * PRIME + ($giftCard == null ? 43 : $giftCard.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $transferGroup = this.getTransferGroup();
    result = result * PRIME + ($transferGroup == null ? 43 : $transferGroup.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
