/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.FileCollection;
import com.stripe.model.FileLinkCollection;
import com.stripe.model.HasId;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.FileCreateParams;
import com.stripe.param.FileListParams;
import com.stripe.param.FileRetrieveParams;
import java.util.Map;
import lombok.Generated;

public class File
extends ApiResource
implements HasId {
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="expires_at")
    Long expiresAt;
    @SerializedName(value="filename")
    String filename;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="links")
    FileLinkCollection links;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="purpose")
    String purpose;
    @SerializedName(value="size")
    Long size;
    @SerializedName(value="title")
    String title;
    @SerializedName(value="type")
    String type;
    @SerializedName(value="url")
    String url;

    public static File create(Map<String, Object> params) throws StripeException {
        return File.create(params, (RequestOptions)null);
    }

    public static File create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getUploadBase(), options, "/v1/files");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, File.class, options);
    }

    public static File create(FileCreateParams params) throws StripeException {
        return File.create(params, (RequestOptions)null);
    }

    public static File create(FileCreateParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getUploadBase(), options, "/v1/files");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, File.class, options);
    }

    public static FileCollection list(Map<String, Object> params) throws StripeException {
        return File.list(params, (RequestOptions)null);
    }

    public static FileCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/files");
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, FileCollection.class, options);
    }

    public static FileCollection list(FileListParams params) throws StripeException {
        return File.list(params, (RequestOptions)null);
    }

    public static FileCollection list(FileListParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/files");
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, FileCollection.class, options);
    }

    public static File retrieve(String file) throws StripeException {
        return File.retrieve(file, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static File retrieve(String file, RequestOptions options) throws StripeException {
        return File.retrieve(file, (Map<String, Object>)null, options);
    }

    public static File retrieve(String file, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/files/%s", ApiResource.urlEncodeId(file)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, File.class, options);
    }

    public static File retrieve(String file, FileRetrieveParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/files/%s", ApiResource.urlEncodeId(file)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, File.class, options);
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Long getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public String getFilename() {
        return this.filename;
    }

    @Generated
    public FileLinkCollection getLinks() {
        return this.links;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getPurpose() {
        return this.purpose;
    }

    @Generated
    public Long getSize() {
        return this.size;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setExpiresAt(Long expiresAt) {
        this.expiresAt = expiresAt;
    }

    @Generated
    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLinks(FileLinkCollection links) {
        this.links = links;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    @Generated
    public void setSize(Long size) {
        this.size = size;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof File)) {
            return false;
        }
        File other = (File)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$expiresAt = this.getExpiresAt();
        Long other$expiresAt = other.getExpiresAt();
        if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
            return false;
        }
        Long this$size = this.getSize();
        Long other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        String this$filename = this.getFilename();
        String other$filename = other.getFilename();
        if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        FileLinkCollection this$links = this.getLinks();
        FileLinkCollection other$links = other.getLinks();
        if (this$links == null ? other$links != null : !((Object)this$links).equals(other$links)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$purpose = this.getPurpose();
        String other$purpose = other.getPurpose();
        if (this$purpose == null ? other$purpose != null : !this$purpose.equals(other$purpose)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof File;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $expiresAt = this.getExpiresAt();
        result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
        Long $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        String $filename = this.getFilename();
        result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        FileLinkCollection $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $purpose = this.getPurpose();
        result = result * 59 + ($purpose == null ? 43 : $purpose.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }
}

