/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Discount;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.LineItemCollection;
import com.stripe.model.StripeObject;
import com.stripe.model.TaxRate;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.QuotePhaseListLineItemsParams;
import com.stripe.param.QuotePhaseRetrieveParams;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class QuotePhase
extends ApiResource
implements HasId {
    @SerializedName(value="amount_subtotal")
    Long amountSubtotal;
    @SerializedName(value="amount_total")
    Long amountTotal;
    @SerializedName(value="billing_cycle_anchor")
    String billingCycleAnchor;
    @SerializedName(value="collection_method")
    String collectionMethod;
    @SerializedName(value="default_tax_rates")
    List<ExpandableField<TaxRate>> defaultTaxRates;
    @SerializedName(value="discounts")
    List<ExpandableField<Discount>> discounts;
    @SerializedName(value="end_date")
    Long endDate;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="invoice_settings")
    InvoiceSettings invoiceSettings;
    @SerializedName(value="iterations")
    Long iterations;
    @SerializedName(value="line_items")
    LineItemCollection lineItems;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="proration_behavior")
    String prorationBehavior;
    @SerializedName(value="total_details")
    TotalDetails totalDetails;
    @SerializedName(value="trial")
    Boolean trial;
    @SerializedName(value="trial_end")
    Long trialEnd;

    public List<String> getDefaultTaxRates() {
        return this.defaultTaxRates != null ? this.defaultTaxRates.stream().map(x -> x.getId()).collect(Collectors.toList()) : null;
    }

    public void setDefaultTaxRates(List<String> ids) {
        if (ids == null) {
            this.defaultTaxRates = null;
            return;
        }
        if (this.defaultTaxRates != null && this.defaultTaxRates.stream().map(x -> x.getId()).collect(Collectors.toList()).equals(ids)) {
            return;
        }
        this.defaultTaxRates = ids != null ? ids.stream().map(id -> new ExpandableField<Object>((String)id, null)).collect(Collectors.toList()) : null;
    }

    public List<TaxRate> getDefaultTaxRateObjects() {
        return this.defaultTaxRates != null ? this.defaultTaxRates.stream().map(x -> (TaxRate)x.getExpanded()).collect(Collectors.toList()) : null;
    }

    public void setDefaultTaxRateObjects(List<TaxRate> objs) {
        this.defaultTaxRates = objs != null ? objs.stream().map(x -> new ExpandableField<TaxRate>(x.getId(), (TaxRate)x)).collect(Collectors.toList()) : null;
    }

    public List<String> getDiscounts() {
        return this.discounts != null ? this.discounts.stream().map(x -> x.getId()).collect(Collectors.toList()) : null;
    }

    public void setDiscounts(List<String> ids) {
        if (ids == null) {
            this.discounts = null;
            return;
        }
        if (this.discounts != null && this.discounts.stream().map(x -> x.getId()).collect(Collectors.toList()).equals(ids)) {
            return;
        }
        this.discounts = ids != null ? ids.stream().map(id -> new ExpandableField<Object>((String)id, null)).collect(Collectors.toList()) : null;
    }

    public List<Discount> getDiscountObjects() {
        return this.discounts != null ? this.discounts.stream().map(x -> (Discount)x.getExpanded()).collect(Collectors.toList()) : null;
    }

    public void setDiscountObjects(List<Discount> objs) {
        this.discounts = objs != null ? objs.stream().map(x -> new ExpandableField<Discount>(x.getId(), (Discount)x)).collect(Collectors.toList()) : null;
    }

    public LineItemCollection listLineItems() throws StripeException {
        return this.listLineItems((Map<String, Object>)null, (RequestOptions)null);
    }

    public LineItemCollection listLineItems(Map<String, Object> params) throws StripeException {
        return this.listLineItems(params, (RequestOptions)null);
    }

    public LineItemCollection listLineItems(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quote_phases/%s/line_items", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, LineItemCollection.class, options);
    }

    public LineItemCollection listLineItems(QuotePhaseListLineItemsParams params) throws StripeException {
        return this.listLineItems(params, (RequestOptions)null);
    }

    public LineItemCollection listLineItems(QuotePhaseListLineItemsParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quote_phases/%s/line_items", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, LineItemCollection.class, options);
    }

    public static QuotePhase retrieve(String quotePhase) throws StripeException {
        return QuotePhase.retrieve(quotePhase, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static QuotePhase retrieve(String quotePhase, RequestOptions options) throws StripeException {
        return QuotePhase.retrieve(quotePhase, (Map<String, Object>)null, options);
    }

    public static QuotePhase retrieve(String quotePhase, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quote_phases/%s", ApiResource.urlEncodeId(quotePhase)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, QuotePhase.class, options);
    }

    public static QuotePhase retrieve(String quotePhase, QuotePhaseRetrieveParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quote_phases/%s", ApiResource.urlEncodeId(quotePhase)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, QuotePhase.class, options);
    }

    @Generated
    public Long getAmountSubtotal() {
        return this.amountSubtotal;
    }

    @Generated
    public Long getAmountTotal() {
        return this.amountTotal;
    }

    @Generated
    public String getBillingCycleAnchor() {
        return this.billingCycleAnchor;
    }

    @Generated
    public String getCollectionMethod() {
        return this.collectionMethod;
    }

    @Generated
    public Long getEndDate() {
        return this.endDate;
    }

    @Generated
    public InvoiceSettings getInvoiceSettings() {
        return this.invoiceSettings;
    }

    @Generated
    public Long getIterations() {
        return this.iterations;
    }

    @Generated
    public LineItemCollection getLineItems() {
        return this.lineItems;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getProrationBehavior() {
        return this.prorationBehavior;
    }

    @Generated
    public TotalDetails getTotalDetails() {
        return this.totalDetails;
    }

    @Generated
    public Boolean getTrial() {
        return this.trial;
    }

    @Generated
    public Long getTrialEnd() {
        return this.trialEnd;
    }

    @Generated
    public void setAmountSubtotal(Long amountSubtotal) {
        this.amountSubtotal = amountSubtotal;
    }

    @Generated
    public void setAmountTotal(Long amountTotal) {
        this.amountTotal = amountTotal;
    }

    @Generated
    public void setBillingCycleAnchor(String billingCycleAnchor) {
        this.billingCycleAnchor = billingCycleAnchor;
    }

    @Generated
    public void setCollectionMethod(String collectionMethod) {
        this.collectionMethod = collectionMethod;
    }

    @Generated
    public void setEndDate(Long endDate) {
        this.endDate = endDate;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setInvoiceSettings(InvoiceSettings invoiceSettings) {
        this.invoiceSettings = invoiceSettings;
    }

    @Generated
    public void setIterations(Long iterations) {
        this.iterations = iterations;
    }

    @Generated
    public void setLineItems(LineItemCollection lineItems) {
        this.lineItems = lineItems;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setProrationBehavior(String prorationBehavior) {
        this.prorationBehavior = prorationBehavior;
    }

    @Generated
    public void setTotalDetails(TotalDetails totalDetails) {
        this.totalDetails = totalDetails;
    }

    @Generated
    public void setTrial(Boolean trial) {
        this.trial = trial;
    }

    @Generated
    public void setTrialEnd(Long trialEnd) {
        this.trialEnd = trialEnd;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuotePhase)) {
            return false;
        }
        QuotePhase other = (QuotePhase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amountSubtotal = this.getAmountSubtotal();
        Long other$amountSubtotal = other.getAmountSubtotal();
        if (this$amountSubtotal == null ? other$amountSubtotal != null : !((Object)this$amountSubtotal).equals(other$amountSubtotal)) {
            return false;
        }
        Long this$amountTotal = this.getAmountTotal();
        Long other$amountTotal = other.getAmountTotal();
        if (this$amountTotal == null ? other$amountTotal != null : !((Object)this$amountTotal).equals(other$amountTotal)) {
            return false;
        }
        Long this$endDate = this.getEndDate();
        Long other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        Long this$iterations = this.getIterations();
        Long other$iterations = other.getIterations();
        if (this$iterations == null ? other$iterations != null : !((Object)this$iterations).equals(other$iterations)) {
            return false;
        }
        Boolean this$trial = this.getTrial();
        Boolean other$trial = other.getTrial();
        if (this$trial == null ? other$trial != null : !((Object)this$trial).equals(other$trial)) {
            return false;
        }
        Long this$trialEnd = this.getTrialEnd();
        Long other$trialEnd = other.getTrialEnd();
        if (this$trialEnd == null ? other$trialEnd != null : !((Object)this$trialEnd).equals(other$trialEnd)) {
            return false;
        }
        String this$billingCycleAnchor = this.getBillingCycleAnchor();
        String other$billingCycleAnchor = other.getBillingCycleAnchor();
        if (this$billingCycleAnchor == null ? other$billingCycleAnchor != null : !this$billingCycleAnchor.equals(other$billingCycleAnchor)) {
            return false;
        }
        String this$collectionMethod = this.getCollectionMethod();
        String other$collectionMethod = other.getCollectionMethod();
        if (this$collectionMethod == null ? other$collectionMethod != null : !this$collectionMethod.equals(other$collectionMethod)) {
            return false;
        }
        List<String> this$defaultTaxRates = this.getDefaultTaxRates();
        List<String> other$defaultTaxRates = other.getDefaultTaxRates();
        if (this$defaultTaxRates == null ? other$defaultTaxRates != null : !((Object)this$defaultTaxRates).equals(other$defaultTaxRates)) {
            return false;
        }
        List<String> this$discounts = this.getDiscounts();
        List<String> other$discounts = other.getDiscounts();
        if (this$discounts == null ? other$discounts != null : !((Object)this$discounts).equals(other$discounts)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        InvoiceSettings this$invoiceSettings = this.getInvoiceSettings();
        InvoiceSettings other$invoiceSettings = other.getInvoiceSettings();
        if (this$invoiceSettings == null ? other$invoiceSettings != null : !((Object)this$invoiceSettings).equals(other$invoiceSettings)) {
            return false;
        }
        LineItemCollection this$lineItems = this.getLineItems();
        LineItemCollection other$lineItems = other.getLineItems();
        if (this$lineItems == null ? other$lineItems != null : !((Object)this$lineItems).equals(other$lineItems)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$prorationBehavior = this.getProrationBehavior();
        String other$prorationBehavior = other.getProrationBehavior();
        if (this$prorationBehavior == null ? other$prorationBehavior != null : !this$prorationBehavior.equals(other$prorationBehavior)) {
            return false;
        }
        TotalDetails this$totalDetails = this.getTotalDetails();
        TotalDetails other$totalDetails = other.getTotalDetails();
        return !(this$totalDetails == null ? other$totalDetails != null : !((Object)this$totalDetails).equals(other$totalDetails));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QuotePhase;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amountSubtotal = this.getAmountSubtotal();
        result = result * 59 + ($amountSubtotal == null ? 43 : ((Object)$amountSubtotal).hashCode());
        Long $amountTotal = this.getAmountTotal();
        result = result * 59 + ($amountTotal == null ? 43 : ((Object)$amountTotal).hashCode());
        Long $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        Long $iterations = this.getIterations();
        result = result * 59 + ($iterations == null ? 43 : ((Object)$iterations).hashCode());
        Boolean $trial = this.getTrial();
        result = result * 59 + ($trial == null ? 43 : ((Object)$trial).hashCode());
        Long $trialEnd = this.getTrialEnd();
        result = result * 59 + ($trialEnd == null ? 43 : ((Object)$trialEnd).hashCode());
        String $billingCycleAnchor = this.getBillingCycleAnchor();
        result = result * 59 + ($billingCycleAnchor == null ? 43 : $billingCycleAnchor.hashCode());
        String $collectionMethod = this.getCollectionMethod();
        result = result * 59 + ($collectionMethod == null ? 43 : $collectionMethod.hashCode());
        List<String> $defaultTaxRates = this.getDefaultTaxRates();
        result = result * 59 + ($defaultTaxRates == null ? 43 : ((Object)$defaultTaxRates).hashCode());
        List<String> $discounts = this.getDiscounts();
        result = result * 59 + ($discounts == null ? 43 : ((Object)$discounts).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        InvoiceSettings $invoiceSettings = this.getInvoiceSettings();
        result = result * 59 + ($invoiceSettings == null ? 43 : ((Object)$invoiceSettings).hashCode());
        LineItemCollection $lineItems = this.getLineItems();
        result = result * 59 + ($lineItems == null ? 43 : ((Object)$lineItems).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $prorationBehavior = this.getProrationBehavior();
        result = result * 59 + ($prorationBehavior == null ? 43 : $prorationBehavior.hashCode());
        TotalDetails $totalDetails = this.getTotalDetails();
        result = result * 59 + ($totalDetails == null ? 43 : ((Object)$totalDetails).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class InvoiceSettings
    extends StripeObject {
        @SerializedName(value="days_until_due")
        Long daysUntilDue;

        @Generated
        public Long getDaysUntilDue() {
            return this.daysUntilDue;
        }

        @Generated
        public void setDaysUntilDue(Long daysUntilDue) {
            this.daysUntilDue = daysUntilDue;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InvoiceSettings)) {
                return false;
            }
            InvoiceSettings other = (InvoiceSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$daysUntilDue = this.getDaysUntilDue();
            Long other$daysUntilDue = other.getDaysUntilDue();
            return !(this$daysUntilDue == null ? other$daysUntilDue != null : !((Object)this$daysUntilDue).equals(other$daysUntilDue));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InvoiceSettings;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $daysUntilDue = this.getDaysUntilDue();
            result = result * 59 + ($daysUntilDue == null ? 43 : ((Object)$daysUntilDue).hashCode());
            return result;
        }
    }

    public static class TotalDetails
    extends StripeObject {
        @SerializedName(value="amount_discount")
        Long amountDiscount;
        @SerializedName(value="amount_shipping")
        Long amountShipping;
        @SerializedName(value="amount_tax")
        Long amountTax;
        @SerializedName(value="breakdown")
        Breakdown breakdown;

        @Generated
        public Long getAmountDiscount() {
            return this.amountDiscount;
        }

        @Generated
        public Long getAmountShipping() {
            return this.amountShipping;
        }

        @Generated
        public Long getAmountTax() {
            return this.amountTax;
        }

        @Generated
        public Breakdown getBreakdown() {
            return this.breakdown;
        }

        @Generated
        public void setAmountDiscount(Long amountDiscount) {
            this.amountDiscount = amountDiscount;
        }

        @Generated
        public void setAmountShipping(Long amountShipping) {
            this.amountShipping = amountShipping;
        }

        @Generated
        public void setAmountTax(Long amountTax) {
            this.amountTax = amountTax;
        }

        @Generated
        public void setBreakdown(Breakdown breakdown) {
            this.breakdown = breakdown;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TotalDetails)) {
                return false;
            }
            TotalDetails other = (TotalDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amountDiscount = this.getAmountDiscount();
            Long other$amountDiscount = other.getAmountDiscount();
            if (this$amountDiscount == null ? other$amountDiscount != null : !((Object)this$amountDiscount).equals(other$amountDiscount)) {
                return false;
            }
            Long this$amountShipping = this.getAmountShipping();
            Long other$amountShipping = other.getAmountShipping();
            if (this$amountShipping == null ? other$amountShipping != null : !((Object)this$amountShipping).equals(other$amountShipping)) {
                return false;
            }
            Long this$amountTax = this.getAmountTax();
            Long other$amountTax = other.getAmountTax();
            if (this$amountTax == null ? other$amountTax != null : !((Object)this$amountTax).equals(other$amountTax)) {
                return false;
            }
            Breakdown this$breakdown = this.getBreakdown();
            Breakdown other$breakdown = other.getBreakdown();
            return !(this$breakdown == null ? other$breakdown != null : !((Object)this$breakdown).equals(other$breakdown));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TotalDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amountDiscount = this.getAmountDiscount();
            result = result * 59 + ($amountDiscount == null ? 43 : ((Object)$amountDiscount).hashCode());
            Long $amountShipping = this.getAmountShipping();
            result = result * 59 + ($amountShipping == null ? 43 : ((Object)$amountShipping).hashCode());
            Long $amountTax = this.getAmountTax();
            result = result * 59 + ($amountTax == null ? 43 : ((Object)$amountTax).hashCode());
            Breakdown $breakdown = this.getBreakdown();
            result = result * 59 + ($breakdown == null ? 43 : ((Object)$breakdown).hashCode());
            return result;
        }

        public static class Breakdown
        extends StripeObject {
            @SerializedName(value="discounts")
            List<Discount> discounts;
            @SerializedName(value="taxes")
            List<Tax> taxes;

            @Generated
            public List<Discount> getDiscounts() {
                return this.discounts;
            }

            @Generated
            public List<Tax> getTaxes() {
                return this.taxes;
            }

            @Generated
            public void setDiscounts(List<Discount> discounts) {
                this.discounts = discounts;
            }

            @Generated
            public void setTaxes(List<Tax> taxes) {
                this.taxes = taxes;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Breakdown)) {
                    return false;
                }
                Breakdown other = (Breakdown)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<Discount> this$discounts = this.getDiscounts();
                List<Discount> other$discounts = other.getDiscounts();
                if (this$discounts == null ? other$discounts != null : !((Object)this$discounts).equals(other$discounts)) {
                    return false;
                }
                List<Tax> this$taxes = this.getTaxes();
                List<Tax> other$taxes = other.getTaxes();
                return !(this$taxes == null ? other$taxes != null : !((Object)this$taxes).equals(other$taxes));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Breakdown;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<Discount> $discounts = this.getDiscounts();
                result = result * 59 + ($discounts == null ? 43 : ((Object)$discounts).hashCode());
                List<Tax> $taxes = this.getTaxes();
                result = result * 59 + ($taxes == null ? 43 : ((Object)$taxes).hashCode());
                return result;
            }

            public static class Tax
            extends StripeObject {
                @SerializedName(value="amount")
                Long amount;
                @SerializedName(value="rate")
                TaxRate rate;
                @SerializedName(value="taxability_reason")
                String taxabilityReason;
                @SerializedName(value="taxable_amount")
                Long taxableAmount;

                @Generated
                public Long getAmount() {
                    return this.amount;
                }

                @Generated
                public TaxRate getRate() {
                    return this.rate;
                }

                @Generated
                public String getTaxabilityReason() {
                    return this.taxabilityReason;
                }

                @Generated
                public Long getTaxableAmount() {
                    return this.taxableAmount;
                }

                @Generated
                public void setAmount(Long amount) {
                    this.amount = amount;
                }

                @Generated
                public void setRate(TaxRate rate) {
                    this.rate = rate;
                }

                @Generated
                public void setTaxabilityReason(String taxabilityReason) {
                    this.taxabilityReason = taxabilityReason;
                }

                @Generated
                public void setTaxableAmount(Long taxableAmount) {
                    this.taxableAmount = taxableAmount;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Tax)) {
                        return false;
                    }
                    Tax other = (Tax)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$amount = this.getAmount();
                    Long other$amount = other.getAmount();
                    if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                        return false;
                    }
                    Long this$taxableAmount = this.getTaxableAmount();
                    Long other$taxableAmount = other.getTaxableAmount();
                    if (this$taxableAmount == null ? other$taxableAmount != null : !((Object)this$taxableAmount).equals(other$taxableAmount)) {
                        return false;
                    }
                    TaxRate this$rate = this.getRate();
                    TaxRate other$rate = other.getRate();
                    if (this$rate == null ? other$rate != null : !((Object)this$rate).equals(other$rate)) {
                        return false;
                    }
                    String this$taxabilityReason = this.getTaxabilityReason();
                    String other$taxabilityReason = other.getTaxabilityReason();
                    return !(this$taxabilityReason == null ? other$taxabilityReason != null : !this$taxabilityReason.equals(other$taxabilityReason));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Tax;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $amount = this.getAmount();
                    result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                    Long $taxableAmount = this.getTaxableAmount();
                    result = result * 59 + ($taxableAmount == null ? 43 : ((Object)$taxableAmount).hashCode());
                    TaxRate $rate = this.getRate();
                    result = result * 59 + ($rate == null ? 43 : ((Object)$rate).hashCode());
                    String $taxabilityReason = this.getTaxabilityReason();
                    result = result * 59 + ($taxabilityReason == null ? 43 : $taxabilityReason.hashCode());
                    return result;
                }
            }

            public static class Discount
            extends StripeObject {
                @SerializedName(value="amount")
                Long amount;
                @SerializedName(value="discount")
                com.stripe.model.Discount discount;

                @Generated
                public Long getAmount() {
                    return this.amount;
                }

                @Generated
                public com.stripe.model.Discount getDiscount() {
                    return this.discount;
                }

                @Generated
                public void setAmount(Long amount) {
                    this.amount = amount;
                }

                @Generated
                public void setDiscount(com.stripe.model.Discount discount) {
                    this.discount = discount;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Discount)) {
                        return false;
                    }
                    Discount other = (Discount)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$amount = this.getAmount();
                    Long other$amount = other.getAmount();
                    if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                        return false;
                    }
                    com.stripe.model.Discount this$discount = this.getDiscount();
                    com.stripe.model.Discount other$discount = other.getDiscount();
                    return !(this$discount == null ? other$discount != null : !((Object)this$discount).equals(other$discount));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Discount;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $amount = this.getAmount();
                    result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                    com.stripe.model.Discount $discount = this.getDiscount();
                    result = result * 59 + ($discount == null ? 43 : ((Object)$discount).hashCode());
                    return result;
                }
            }
        }
    }
}

