/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.tax;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Account;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.tax.FormCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.tax.FormListParams;
import com.stripe.param.tax.FormPdfParams;
import com.stripe.param.tax.FormRetrieveParams;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Form
extends ApiResource
implements HasId {
    @SerializedName(value="corrected_by")
    ExpandableField<Form> correctedBy;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="filing_statuses")
    List<FilingStatus> filingStatuses;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="payee")
    Payee payee;
    @SerializedName(value="type")
    String type;
    @SerializedName(value="us_1099_k")
    Us1099K us1099K;
    @SerializedName(value="us_1099_misc")
    Us1099Misc us1099Misc;
    @SerializedName(value="us_1099_nec")
    Us1099Nec us1099Nec;

    public String getCorrectedBy() {
        return this.correctedBy != null ? this.correctedBy.getId() : null;
    }

    public void setCorrectedBy(String id) {
        this.correctedBy = ApiResource.setExpandableFieldId(id, this.correctedBy);
    }

    public Form getCorrectedByObject() {
        return this.correctedBy != null ? this.correctedBy.getExpanded() : null;
    }

    public void setCorrectedByObject(Form expandableObject) {
        this.correctedBy = new ExpandableField<Form>(expandableObject.getId(), expandableObject);
    }

    public static FormCollection list(Map<String, Object> params) throws StripeException {
        return Form.list(params, (RequestOptions)null);
    }

    public static FormCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/tax/forms");
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, FormCollection.class, options);
    }

    public static FormCollection list(FormListParams params) throws StripeException {
        return Form.list(params, (RequestOptions)null);
    }

    public static FormCollection list(FormListParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/tax/forms");
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, FormCollection.class, options);
    }

    public InputStream pdf() throws StripeException {
        return this.pdf((Map<String, Object>)null, (RequestOptions)null);
    }

    public InputStream pdf(Map<String, Object> params) throws StripeException {
        return this.pdf(params, (RequestOptions)null);
    }

    public InputStream pdf(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getUploadBase(), options, String.format("/v1/tax/forms/%s/pdf", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.requestStream(ApiResource.RequestMethod.GET, url, params, options);
    }

    public InputStream pdf(FormPdfParams params) throws StripeException {
        return this.pdf(params, (RequestOptions)null);
    }

    public InputStream pdf(FormPdfParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getUploadBase(), options, String.format("/v1/tax/forms/%s/pdf", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.requestStream(ApiResource.RequestMethod.GET, url, params, options);
    }

    public static Form retrieve(String id) throws StripeException {
        return Form.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Form retrieve(String id, RequestOptions options) throws StripeException {
        return Form.retrieve(id, (Map<String, Object>)null, options);
    }

    public static Form retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/tax/forms/%s", ApiResource.urlEncodeId(id)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Form.class, options);
    }

    public static Form retrieve(String id, FormRetrieveParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/tax/forms/%s", ApiResource.urlEncodeId(id)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Form.class, options);
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public List<FilingStatus> getFilingStatuses() {
        return this.filingStatuses;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Payee getPayee() {
        return this.payee;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Us1099K getUs1099K() {
        return this.us1099K;
    }

    @Generated
    public Us1099Misc getUs1099Misc() {
        return this.us1099Misc;
    }

    @Generated
    public Us1099Nec getUs1099Nec() {
        return this.us1099Nec;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setFilingStatuses(List<FilingStatus> filingStatuses) {
        this.filingStatuses = filingStatuses;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPayee(Payee payee) {
        this.payee = payee;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setUs1099K(Us1099K us1099K) {
        this.us1099K = us1099K;
    }

    @Generated
    public void setUs1099Misc(Us1099Misc us1099Misc) {
        this.us1099Misc = us1099Misc;
    }

    @Generated
    public void setUs1099Nec(Us1099Nec us1099Nec) {
        this.us1099Nec = us1099Nec;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Form)) {
            return false;
        }
        Form other = (Form)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$correctedBy = this.getCorrectedBy();
        String other$correctedBy = other.getCorrectedBy();
        if (this$correctedBy == null ? other$correctedBy != null : !this$correctedBy.equals(other$correctedBy)) {
            return false;
        }
        List<FilingStatus> this$filingStatuses = this.getFilingStatuses();
        List<FilingStatus> other$filingStatuses = other.getFilingStatuses();
        if (this$filingStatuses == null ? other$filingStatuses != null : !((Object)this$filingStatuses).equals(other$filingStatuses)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Payee this$payee = this.getPayee();
        Payee other$payee = other.getPayee();
        if (this$payee == null ? other$payee != null : !((Object)this$payee).equals(other$payee)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Us1099K this$us1099K = this.getUs1099K();
        Us1099K other$us1099K = other.getUs1099K();
        if (this$us1099K == null ? other$us1099K != null : !((Object)this$us1099K).equals(other$us1099K)) {
            return false;
        }
        Us1099Misc this$us1099Misc = this.getUs1099Misc();
        Us1099Misc other$us1099Misc = other.getUs1099Misc();
        if (this$us1099Misc == null ? other$us1099Misc != null : !((Object)this$us1099Misc).equals(other$us1099Misc)) {
            return false;
        }
        Us1099Nec this$us1099Nec = this.getUs1099Nec();
        Us1099Nec other$us1099Nec = other.getUs1099Nec();
        return !(this$us1099Nec == null ? other$us1099Nec != null : !((Object)this$us1099Nec).equals(other$us1099Nec));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Form;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $correctedBy = this.getCorrectedBy();
        result = result * 59 + ($correctedBy == null ? 43 : $correctedBy.hashCode());
        List<FilingStatus> $filingStatuses = this.getFilingStatuses();
        result = result * 59 + ($filingStatuses == null ? 43 : ((Object)$filingStatuses).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Payee $payee = this.getPayee();
        result = result * 59 + ($payee == null ? 43 : ((Object)$payee).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Us1099K $us1099K = this.getUs1099K();
        result = result * 59 + ($us1099K == null ? 43 : ((Object)$us1099K).hashCode());
        Us1099Misc $us1099Misc = this.getUs1099Misc();
        result = result * 59 + ($us1099Misc == null ? 43 : ((Object)$us1099Misc).hashCode());
        Us1099Nec $us1099Nec = this.getUs1099Nec();
        result = result * 59 + ($us1099Nec == null ? 43 : ((Object)$us1099Nec).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class Payee
    extends StripeObject {
        @SerializedName(value="account")
        ExpandableField<Account> account;
        @SerializedName(value="type")
        String type;

        public String getAccount() {
            return this.account != null ? this.account.getId() : null;
        }

        public void setAccount(String id) {
            this.account = ApiResource.setExpandableFieldId(id, this.account);
        }

        public Account getAccountObject() {
            return this.account != null ? this.account.getExpanded() : null;
        }

        public void setAccountObject(Account expandableObject) {
            this.account = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Payee)) {
                return false;
            }
            Payee other = (Payee)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$account = this.getAccount();
            String other$account = other.getAccount();
            if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Payee;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $account = this.getAccount();
            result = result * 59 + ($account == null ? 43 : $account.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }
    }

    public static class Us1099K
    extends StripeObject {
        @SerializedName(value="reporting_year")
        Long reportingYear;

        @Generated
        public Long getReportingYear() {
            return this.reportingYear;
        }

        @Generated
        public void setReportingYear(Long reportingYear) {
            this.reportingYear = reportingYear;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Us1099K)) {
                return false;
            }
            Us1099K other = (Us1099K)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$reportingYear = this.getReportingYear();
            Long other$reportingYear = other.getReportingYear();
            return !(this$reportingYear == null ? other$reportingYear != null : !((Object)this$reportingYear).equals(other$reportingYear));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Us1099K;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $reportingYear = this.getReportingYear();
            result = result * 59 + ($reportingYear == null ? 43 : ((Object)$reportingYear).hashCode());
            return result;
        }
    }

    public static class Us1099Misc
    extends StripeObject {
        @SerializedName(value="reporting_year")
        Long reportingYear;

        @Generated
        public Long getReportingYear() {
            return this.reportingYear;
        }

        @Generated
        public void setReportingYear(Long reportingYear) {
            this.reportingYear = reportingYear;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Us1099Misc)) {
                return false;
            }
            Us1099Misc other = (Us1099Misc)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$reportingYear = this.getReportingYear();
            Long other$reportingYear = other.getReportingYear();
            return !(this$reportingYear == null ? other$reportingYear != null : !((Object)this$reportingYear).equals(other$reportingYear));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Us1099Misc;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $reportingYear = this.getReportingYear();
            result = result * 59 + ($reportingYear == null ? 43 : ((Object)$reportingYear).hashCode());
            return result;
        }
    }

    public static class Us1099Nec
    extends StripeObject {
        @SerializedName(value="reporting_year")
        Long reportingYear;

        @Generated
        public Long getReportingYear() {
            return this.reportingYear;
        }

        @Generated
        public void setReportingYear(Long reportingYear) {
            this.reportingYear = reportingYear;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Us1099Nec)) {
                return false;
            }
            Us1099Nec other = (Us1099Nec)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$reportingYear = this.getReportingYear();
            Long other$reportingYear = other.getReportingYear();
            return !(this$reportingYear == null ? other$reportingYear != null : !((Object)this$reportingYear).equals(other$reportingYear));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Us1099Nec;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $reportingYear = this.getReportingYear();
            result = result * 59 + ($reportingYear == null ? 43 : ((Object)$reportingYear).hashCode());
            return result;
        }
    }

    public static class FilingStatus
    extends StripeObject {
        @SerializedName(value="effective_at")
        Long effectiveAt;
        @SerializedName(value="jurisdiction")
        Jurisdiction jurisdiction;
        @SerializedName(value="value")
        String value;

        @Generated
        public Long getEffectiveAt() {
            return this.effectiveAt;
        }

        @Generated
        public Jurisdiction getJurisdiction() {
            return this.jurisdiction;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public void setEffectiveAt(Long effectiveAt) {
            this.effectiveAt = effectiveAt;
        }

        @Generated
        public void setJurisdiction(Jurisdiction jurisdiction) {
            this.jurisdiction = jurisdiction;
        }

        @Generated
        public void setValue(String value) {
            this.value = value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FilingStatus)) {
                return false;
            }
            FilingStatus other = (FilingStatus)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$effectiveAt = this.getEffectiveAt();
            Long other$effectiveAt = other.getEffectiveAt();
            if (this$effectiveAt == null ? other$effectiveAt != null : !((Object)this$effectiveAt).equals(other$effectiveAt)) {
                return false;
            }
            Jurisdiction this$jurisdiction = this.getJurisdiction();
            Jurisdiction other$jurisdiction = other.getJurisdiction();
            if (this$jurisdiction == null ? other$jurisdiction != null : !((Object)this$jurisdiction).equals(other$jurisdiction)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FilingStatus;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $effectiveAt = this.getEffectiveAt();
            result = result * 59 + ($effectiveAt == null ? 43 : ((Object)$effectiveAt).hashCode());
            Jurisdiction $jurisdiction = this.getJurisdiction();
            result = result * 59 + ($jurisdiction == null ? 43 : ((Object)$jurisdiction).hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public static class Jurisdiction
        extends StripeObject {
            @SerializedName(value="country")
            String country;
            @SerializedName(value="level")
            String level;
            @SerializedName(value="state")
            String state;

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public String getLevel() {
                return this.level;
            }

            @Generated
            public String getState() {
                return this.state;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public void setLevel(String level) {
                this.level = level;
            }

            @Generated
            public void setState(String state) {
                this.state = state;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Jurisdiction)) {
                    return false;
                }
                Jurisdiction other = (Jurisdiction)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                String this$level = this.getLevel();
                String other$level = other.getLevel();
                if (this$level == null ? other$level != null : !this$level.equals(other$level)) {
                    return false;
                }
                String this$state = this.getState();
                String other$state = other.getState();
                return !(this$state == null ? other$state != null : !this$state.equals(other$state));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Jurisdiction;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                String $level = this.getLevel();
                result = result * 59 + ($level == null ? 43 : $level.hashCode());
                String $state = this.getState();
                result = result * 59 + ($state == null ? 43 : $state.hashCode());
                return result;
            }
        }
    }
}

