/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Account;
import com.stripe.model.Address;
import com.stripe.model.Application;
import com.stripe.model.Charge;
import com.stripe.model.Customer;
import com.stripe.model.Discount;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.InvoiceCollection;
import com.stripe.model.InvoiceLineItemCollection;
import com.stripe.model.InvoiceSearchResult;
import com.stripe.model.MetadataStore;
import com.stripe.model.PaymentIntent;
import com.stripe.model.PaymentMethod;
import com.stripe.model.PaymentSource;
import com.stripe.model.Quote;
import com.stripe.model.ShippingDetails;
import com.stripe.model.ShippingRate;
import com.stripe.model.StripeError;
import com.stripe.model.StripeObject;
import com.stripe.model.Subscription;
import com.stripe.model.TaxId;
import com.stripe.model.TaxRate;
import com.stripe.model.testhelpers.TestClock;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.InvoiceCreateParams;
import com.stripe.param.InvoiceFinalizeInvoiceParams;
import com.stripe.param.InvoiceListParams;
import com.stripe.param.InvoiceMarkUncollectibleParams;
import com.stripe.param.InvoicePayParams;
import com.stripe.param.InvoiceRetrieveParams;
import com.stripe.param.InvoiceSearchParams;
import com.stripe.param.InvoiceSendInvoiceParams;
import com.stripe.param.InvoiceUpcomingLinesParams;
import com.stripe.param.InvoiceUpcomingParams;
import com.stripe.param.InvoiceUpdateParams;
import com.stripe.param.InvoiceVoidInvoiceParams;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class Invoice
extends ApiResource
implements HasId,
MetadataStore<Invoice> {
    @SerializedName(value="account_country")
    String accountCountry;
    @SerializedName(value="account_name")
    String accountName;
    @SerializedName(value="account_tax_ids")
    List<ExpandableField<TaxId>> accountTaxIds;
    @SerializedName(value="amount_due")
    Long amountDue;
    @SerializedName(value="amount_paid")
    Long amountPaid;
    @SerializedName(value="amount_remaining")
    Long amountRemaining;
    @SerializedName(value="amount_shipping")
    Long amountShipping;
    @SerializedName(value="application")
    ExpandableField<Application> application;
    @SerializedName(value="application_fee_amount")
    Long applicationFeeAmount;
    @SerializedName(value="attempt_count")
    Long attemptCount;
    @SerializedName(value="attempted")
    Boolean attempted;
    @SerializedName(value="auto_advance")
    Boolean autoAdvance;
    @SerializedName(value="automatic_tax")
    AutomaticTax automaticTax;
    @SerializedName(value="billing_reason")
    String billingReason;
    @SerializedName(value="charge")
    ExpandableField<Charge> charge;
    @SerializedName(value="collection_method")
    String collectionMethod;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="custom_fields")
    List<CustomField> customFields;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="customer_address")
    Address customerAddress;
    @SerializedName(value="customer_email")
    String customerEmail;
    @SerializedName(value="customer_name")
    String customerName;
    @SerializedName(value="customer_phone")
    String customerPhone;
    @SerializedName(value="customer_shipping")
    ShippingDetails customerShipping;
    @SerializedName(value="customer_tax_exempt")
    String customerTaxExempt;
    @SerializedName(value="customer_tax_ids")
    List<CustomerTaxId> customerTaxIds;
    @SerializedName(value="default_payment_method")
    ExpandableField<PaymentMethod> defaultPaymentMethod;
    @SerializedName(value="default_source")
    ExpandableField<PaymentSource> defaultSource;
    @SerializedName(value="default_tax_rates")
    List<TaxRate> defaultTaxRates;
    @SerializedName(value="deleted")
    Boolean deleted;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="discount")
    Discount discount;
    @SerializedName(value="discounts")
    List<ExpandableField<Discount>> discounts;
    @SerializedName(value="due_date")
    Long dueDate;
    @SerializedName(value="effective_at")
    Long effectiveAt;
    @SerializedName(value="ending_balance")
    Long endingBalance;
    @SerializedName(value="footer")
    String footer;
    @SerializedName(value="from_invoice")
    FromInvoice fromInvoice;
    @SerializedName(value="hosted_invoice_url")
    String hostedInvoiceUrl;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="invoice_pdf")
    String invoicePdf;
    @SerializedName(value="last_finalization_error")
    StripeError lastFinalizationError;
    @SerializedName(value="latest_revision")
    ExpandableField<Invoice> latestRevision;
    @SerializedName(value="lines")
    InvoiceLineItemCollection lines;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="next_payment_attempt")
    Long nextPaymentAttempt;
    @SerializedName(value="number")
    String number;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="on_behalf_of")
    ExpandableField<Account> onBehalfOf;
    @SerializedName(value="paid")
    Boolean paid;
    @SerializedName(value="paid_out_of_band")
    Boolean paidOutOfBand;
    @SerializedName(value="payment_intent")
    ExpandableField<PaymentIntent> paymentIntent;
    @SerializedName(value="payment_settings")
    PaymentSettings paymentSettings;
    @SerializedName(value="period_end")
    Long periodEnd;
    @SerializedName(value="period_start")
    Long periodStart;
    @SerializedName(value="post_payment_credit_notes_amount")
    Long postPaymentCreditNotesAmount;
    @SerializedName(value="pre_payment_credit_notes_amount")
    Long prePaymentCreditNotesAmount;
    @SerializedName(value="quote")
    ExpandableField<Quote> quote;
    @SerializedName(value="receipt_number")
    String receiptNumber;
    @SerializedName(value="rendering_options")
    RenderingOptions renderingOptions;
    @SerializedName(value="shipping_cost")
    ShippingCost shippingCost;
    @SerializedName(value="shipping_details")
    ShippingDetails shippingDetails;
    @SerializedName(value="starting_balance")
    Long startingBalance;
    @SerializedName(value="statement_descriptor")
    String statementDescriptor;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="status_transitions")
    StatusTransitions statusTransitions;
    @SerializedName(value="subscription")
    ExpandableField<Subscription> subscription;
    @SerializedName(value="subscription_details")
    SubscriptionDetails subscriptionDetails;
    @SerializedName(value="subscription_proration_date")
    Long subscriptionProrationDate;
    @SerializedName(value="subtotal")
    Long subtotal;
    @SerializedName(value="subtotal_excluding_tax")
    Long subtotalExcludingTax;
    @SerializedName(value="tax")
    Long tax;
    @SerializedName(value="test_clock")
    ExpandableField<TestClock> testClock;
    @SerializedName(value="threshold_reason")
    ThresholdReason thresholdReason;
    @SerializedName(value="total")
    Long total;
    @SerializedName(value="total_discount_amounts")
    List<TotalDiscountAmount> totalDiscountAmounts;
    @SerializedName(value="total_excluding_tax")
    Long totalExcludingTax;
    @SerializedName(value="total_tax_amounts")
    List<TotalTaxAmount> totalTaxAmounts;
    @SerializedName(value="transfer_data")
    TransferData transferData;
    @SerializedName(value="webhooks_delivered_at")
    Long webhooksDeliveredAt;

    public String getApplication() {
        return this.application != null ? this.application.getId() : null;
    }

    public void setApplication(String id) {
        this.application = ApiResource.setExpandableFieldId(id, this.application);
    }

    public Application getApplicationObject() {
        return this.application != null ? this.application.getExpanded() : null;
    }

    public void setApplicationObject(Application expandableObject) {
        this.application = new ExpandableField<Application>(expandableObject.getId(), expandableObject);
    }

    public String getCharge() {
        return this.charge != null ? this.charge.getId() : null;
    }

    public void setCharge(String id) {
        this.charge = ApiResource.setExpandableFieldId(id, this.charge);
    }

    public Charge getChargeObject() {
        return this.charge != null ? this.charge.getExpanded() : null;
    }

    public void setChargeObject(Charge expandableObject) {
        this.charge = new ExpandableField<Charge>(expandableObject.getId(), expandableObject);
    }

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public String getDefaultPaymentMethod() {
        return this.defaultPaymentMethod != null ? this.defaultPaymentMethod.getId() : null;
    }

    public void setDefaultPaymentMethod(String id) {
        this.defaultPaymentMethod = ApiResource.setExpandableFieldId(id, this.defaultPaymentMethod);
    }

    public PaymentMethod getDefaultPaymentMethodObject() {
        return this.defaultPaymentMethod != null ? this.defaultPaymentMethod.getExpanded() : null;
    }

    public void setDefaultPaymentMethodObject(PaymentMethod expandableObject) {
        this.defaultPaymentMethod = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
    }

    public String getDefaultSource() {
        return this.defaultSource != null ? this.defaultSource.getId() : null;
    }

    public void setDefaultSource(String id) {
        this.defaultSource = ApiResource.setExpandableFieldId(id, this.defaultSource);
    }

    public PaymentSource getDefaultSourceObject() {
        return this.defaultSource != null ? this.defaultSource.getExpanded() : null;
    }

    public void setDefaultSourceObject(PaymentSource expandableObject) {
        this.defaultSource = new ExpandableField<PaymentSource>(expandableObject.getId(), expandableObject);
    }

    public String getLatestRevision() {
        return this.latestRevision != null ? this.latestRevision.getId() : null;
    }

    public void setLatestRevision(String id) {
        this.latestRevision = ApiResource.setExpandableFieldId(id, this.latestRevision);
    }

    public Invoice getLatestRevisionObject() {
        return this.latestRevision != null ? this.latestRevision.getExpanded() : null;
    }

    public void setLatestRevisionObject(Invoice expandableObject) {
        this.latestRevision = new ExpandableField<Invoice>(expandableObject.getId(), expandableObject);
    }

    public String getOnBehalfOf() {
        return this.onBehalfOf != null ? this.onBehalfOf.getId() : null;
    }

    public void setOnBehalfOf(String id) {
        this.onBehalfOf = ApiResource.setExpandableFieldId(id, this.onBehalfOf);
    }

    public Account getOnBehalfOfObject() {
        return this.onBehalfOf != null ? this.onBehalfOf.getExpanded() : null;
    }

    public void setOnBehalfOfObject(Account expandableObject) {
        this.onBehalfOf = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
    }

    public String getPaymentIntent() {
        return this.paymentIntent != null ? this.paymentIntent.getId() : null;
    }

    public void setPaymentIntent(String id) {
        this.paymentIntent = ApiResource.setExpandableFieldId(id, this.paymentIntent);
    }

    public PaymentIntent getPaymentIntentObject() {
        return this.paymentIntent != null ? this.paymentIntent.getExpanded() : null;
    }

    public void setPaymentIntentObject(PaymentIntent expandableObject) {
        this.paymentIntent = new ExpandableField<PaymentIntent>(expandableObject.getId(), expandableObject);
    }

    public String getQuote() {
        return this.quote != null ? this.quote.getId() : null;
    }

    public void setQuote(String id) {
        this.quote = ApiResource.setExpandableFieldId(id, this.quote);
    }

    public Quote getQuoteObject() {
        return this.quote != null ? this.quote.getExpanded() : null;
    }

    public void setQuoteObject(Quote expandableObject) {
        this.quote = new ExpandableField<Quote>(expandableObject.getId(), expandableObject);
    }

    public String getSubscription() {
        return this.subscription != null ? this.subscription.getId() : null;
    }

    public void setSubscription(String id) {
        this.subscription = ApiResource.setExpandableFieldId(id, this.subscription);
    }

    public Subscription getSubscriptionObject() {
        return this.subscription != null ? this.subscription.getExpanded() : null;
    }

    public void setSubscriptionObject(Subscription expandableObject) {
        this.subscription = new ExpandableField<Subscription>(expandableObject.getId(), expandableObject);
    }

    public String getTestClock() {
        return this.testClock != null ? this.testClock.getId() : null;
    }

    public void setTestClock(String id) {
        this.testClock = ApiResource.setExpandableFieldId(id, this.testClock);
    }

    public TestClock getTestClockObject() {
        return this.testClock != null ? this.testClock.getExpanded() : null;
    }

    public void setTestClockObject(TestClock expandableObject) {
        this.testClock = new ExpandableField<TestClock>(expandableObject.getId(), expandableObject);
    }

    public List<String> getAccountTaxIds() {
        return this.accountTaxIds != null ? this.accountTaxIds.stream().map(x -> x.getId()).collect(Collectors.toList()) : null;
    }

    public void setAccountTaxIds(List<String> ids) {
        if (ids == null) {
            this.accountTaxIds = null;
            return;
        }
        if (this.accountTaxIds != null && this.accountTaxIds.stream().map(x -> x.getId()).collect(Collectors.toList()).equals(ids)) {
            return;
        }
        this.accountTaxIds = ids != null ? ids.stream().map(id -> new ExpandableField<Object>((String)id, null)).collect(Collectors.toList()) : null;
    }

    public List<TaxId> getAccountTaxIdObjects() {
        return this.accountTaxIds != null ? this.accountTaxIds.stream().map(x -> (TaxId)x.getExpanded()).collect(Collectors.toList()) : null;
    }

    public void setAccountTaxIdObjects(List<TaxId> objs) {
        this.accountTaxIds = objs != null ? objs.stream().map(x -> new ExpandableField<TaxId>(x.getId(), (TaxId)x)).collect(Collectors.toList()) : null;
    }

    public List<String> getDiscounts() {
        return this.discounts != null ? this.discounts.stream().map(x -> x.getId()).collect(Collectors.toList()) : null;
    }

    public void setDiscounts(List<String> ids) {
        if (ids == null) {
            this.discounts = null;
            return;
        }
        if (this.discounts != null && this.discounts.stream().map(x -> x.getId()).collect(Collectors.toList()).equals(ids)) {
            return;
        }
        this.discounts = ids != null ? ids.stream().map(id -> new ExpandableField<Object>((String)id, null)).collect(Collectors.toList()) : null;
    }

    public List<Discount> getDiscountObjects() {
        return this.discounts != null ? this.discounts.stream().map(x -> (Discount)x.getExpanded()).collect(Collectors.toList()) : null;
    }

    public void setDiscountObjects(List<Discount> objs) {
        this.discounts = objs != null ? objs.stream().map(x -> new ExpandableField<Discount>(x.getId(), (Discount)x)).collect(Collectors.toList()) : null;
    }

    public static Invoice create(Map<String, Object> params) throws StripeException {
        return Invoice.create(params, (RequestOptions)null);
    }

    public static Invoice create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/invoices");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Invoice.class, options);
    }

    public static Invoice create(InvoiceCreateParams params) throws StripeException {
        return Invoice.create(params, (RequestOptions)null);
    }

    public static Invoice create(InvoiceCreateParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/invoices");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Invoice.class, options);
    }

    public Invoice delete() throws StripeException {
        return this.delete(null, null);
    }

    public Invoice delete(RequestOptions options) throws StripeException {
        return this.delete(null, options);
    }

    public Invoice delete(Map<String, Object> params) throws StripeException {
        return this.delete(params, null);
    }

    public Invoice delete(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/invoices/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, Invoice.class, options);
    }

    public Invoice finalizeInvoice() throws StripeException {
        return this.finalizeInvoice((Map<String, Object>)null, (RequestOptions)null);
    }

    public Invoice finalizeInvoice(RequestOptions options) throws StripeException {
        return this.finalizeInvoice((Map<String, Object>)null, options);
    }

    public Invoice finalizeInvoice(Map<String, Object> params) throws StripeException {
        return this.finalizeInvoice(params, (RequestOptions)null);
    }

    public Invoice finalizeInvoice(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/invoices/%s/finalize", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Invoice.class, options);
    }

    public Invoice finalizeInvoice(InvoiceFinalizeInvoiceParams params) throws StripeException {
        return this.finalizeInvoice(params, (RequestOptions)null);
    }

    public Invoice finalizeInvoice(InvoiceFinalizeInvoiceParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/invoices/%s/finalize", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Invoice.class, options);
    }

    public static InvoiceCollection list(Map<String, Object> params) throws StripeException {
        return Invoice.list(params, (RequestOptions)null);
    }

    public static InvoiceCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/invoices");
        return ApiResource.requestCollection(url, params, InvoiceCollection.class, options);
    }

    public static InvoiceCollection list(InvoiceListParams params) throws StripeException {
        return Invoice.list(params, (RequestOptions)null);
    }

    public static InvoiceCollection list(InvoiceListParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/invoices");
        return ApiResource.requestCollection(url, params, InvoiceCollection.class, options);
    }

    public Invoice markUncollectible() throws StripeException {
        return this.markUncollectible((Map<String, Object>)null, (RequestOptions)null);
    }

    public Invoice markUncollectible(RequestOptions options) throws StripeException {
        return this.markUncollectible((Map<String, Object>)null, options);
    }

    public Invoice markUncollectible(Map<String, Object> params) throws StripeException {
        return this.markUncollectible(params, (RequestOptions)null);
    }

    public Invoice markUncollectible(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/invoices/%s/mark_uncollectible", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Invoice.class, options);
    }

    public Invoice markUncollectible(InvoiceMarkUncollectibleParams params) throws StripeException {
        return this.markUncollectible(params, (RequestOptions)null);
    }

    public Invoice markUncollectible(InvoiceMarkUncollectibleParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/invoices/%s/mark_uncollectible", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Invoice.class, options);
    }

    public Invoice pay() throws StripeException {
        return this.pay((Map<String, Object>)null, (RequestOptions)null);
    }

    public Invoice pay(RequestOptions options) throws StripeException {
        return this.pay((Map<String, Object>)null, options);
    }

    public Invoice pay(Map<String, Object> params) throws StripeException {
        return this.pay(params, (RequestOptions)null);
    }

    public Invoice pay(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/invoices/%s/pay", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Invoice.class, options);
    }

    public Invoice pay(InvoicePayParams params) throws StripeException {
        return this.pay(params, (RequestOptions)null);
    }

    public Invoice pay(InvoicePayParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/invoices/%s/pay", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Invoice.class, options);
    }

    public static Invoice retrieve(String invoice) throws StripeException {
        return Invoice.retrieve(invoice, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Invoice retrieve(String invoice, RequestOptions options) throws StripeException {
        return Invoice.retrieve(invoice, (Map<String, Object>)null, options);
    }

    public static Invoice retrieve(String invoice, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/invoices/%s", ApiResource.urlEncodeId(invoice)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Invoice.class, options);
    }

    public static Invoice retrieve(String invoice, InvoiceRetrieveParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/invoices/%s", ApiResource.urlEncodeId(invoice)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Invoice.class, options);
    }

    public static InvoiceSearchResult search(Map<String, Object> params) throws StripeException {
        return Invoice.search(params, (RequestOptions)null);
    }

    public static InvoiceSearchResult search(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/invoices/search");
        return ApiResource.requestSearchResult(url, params, InvoiceSearchResult.class, options);
    }

    public static InvoiceSearchResult search(InvoiceSearchParams params) throws StripeException {
        return Invoice.search(params, (RequestOptions)null);
    }

    public static InvoiceSearchResult search(InvoiceSearchParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/invoices/search");
        return ApiResource.requestSearchResult(url, params, InvoiceSearchResult.class, options);
    }

    public Invoice sendInvoice() throws StripeException {
        return this.sendInvoice((Map<String, Object>)null, (RequestOptions)null);
    }

    public Invoice sendInvoice(RequestOptions options) throws StripeException {
        return this.sendInvoice((Map<String, Object>)null, options);
    }

    public Invoice sendInvoice(Map<String, Object> params) throws StripeException {
        return this.sendInvoice(params, (RequestOptions)null);
    }

    public Invoice sendInvoice(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/invoices/%s/send", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Invoice.class, options);
    }

    public Invoice sendInvoice(InvoiceSendInvoiceParams params) throws StripeException {
        return this.sendInvoice(params, (RequestOptions)null);
    }

    public Invoice sendInvoice(InvoiceSendInvoiceParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/invoices/%s/send", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Invoice.class, options);
    }

    public static Invoice upcoming() throws StripeException {
        return Invoice.upcoming((Map<String, Object>)null, (RequestOptions)null);
    }

    public static Invoice upcoming(Map<String, Object> params) throws StripeException {
        return Invoice.upcoming(params, (RequestOptions)null);
    }

    public static Invoice upcoming(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/invoices/upcoming");
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Invoice.class, options);
    }

    public static Invoice upcoming(InvoiceUpcomingParams params) throws StripeException {
        return Invoice.upcoming(params, (RequestOptions)null);
    }

    public static Invoice upcoming(InvoiceUpcomingParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/invoices/upcoming");
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Invoice.class, options);
    }

    public static InvoiceLineItemCollection upcomingLines() throws StripeException {
        return Invoice.upcomingLines((Map<String, Object>)null, (RequestOptions)null);
    }

    public static InvoiceLineItemCollection upcomingLines(Map<String, Object> params) throws StripeException {
        return Invoice.upcomingLines(params, (RequestOptions)null);
    }

    public static InvoiceLineItemCollection upcomingLines(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/invoices/upcoming/lines");
        return ApiResource.requestCollection(url, params, InvoiceLineItemCollection.class, options);
    }

    public static InvoiceLineItemCollection upcomingLines(InvoiceUpcomingLinesParams params) throws StripeException {
        return Invoice.upcomingLines(params, (RequestOptions)null);
    }

    public static InvoiceLineItemCollection upcomingLines(InvoiceUpcomingLinesParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/invoices/upcoming/lines");
        return ApiResource.requestCollection(url, params, InvoiceLineItemCollection.class, options);
    }

    public Invoice update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Invoice update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/invoices/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Invoice.class, options);
    }

    public Invoice update(InvoiceUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Invoice update(InvoiceUpdateParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/invoices/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Invoice.class, options);
    }

    public Invoice voidInvoice() throws StripeException {
        return this.voidInvoice((Map<String, Object>)null, (RequestOptions)null);
    }

    public Invoice voidInvoice(RequestOptions options) throws StripeException {
        return this.voidInvoice((Map<String, Object>)null, options);
    }

    public Invoice voidInvoice(Map<String, Object> params) throws StripeException {
        return this.voidInvoice(params, (RequestOptions)null);
    }

    public Invoice voidInvoice(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/invoices/%s/void", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Invoice.class, options);
    }

    public Invoice voidInvoice(InvoiceVoidInvoiceParams params) throws StripeException {
        return this.voidInvoice(params, (RequestOptions)null);
    }

    public Invoice voidInvoice(InvoiceVoidInvoiceParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/invoices/%s/void", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Invoice.class, options);
    }

    @Generated
    public String getAccountCountry() {
        return this.accountCountry;
    }

    @Generated
    public String getAccountName() {
        return this.accountName;
    }

    @Generated
    public Long getAmountDue() {
        return this.amountDue;
    }

    @Generated
    public Long getAmountPaid() {
        return this.amountPaid;
    }

    @Generated
    public Long getAmountRemaining() {
        return this.amountRemaining;
    }

    @Generated
    public Long getAmountShipping() {
        return this.amountShipping;
    }

    @Generated
    public Long getApplicationFeeAmount() {
        return this.applicationFeeAmount;
    }

    @Generated
    public Long getAttemptCount() {
        return this.attemptCount;
    }

    @Generated
    public Boolean getAttempted() {
        return this.attempted;
    }

    @Generated
    public Boolean getAutoAdvance() {
        return this.autoAdvance;
    }

    @Generated
    public AutomaticTax getAutomaticTax() {
        return this.automaticTax;
    }

    @Generated
    public String getBillingReason() {
        return this.billingReason;
    }

    @Generated
    public String getCollectionMethod() {
        return this.collectionMethod;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public List<CustomField> getCustomFields() {
        return this.customFields;
    }

    @Generated
    public Address getCustomerAddress() {
        return this.customerAddress;
    }

    @Generated
    public String getCustomerEmail() {
        return this.customerEmail;
    }

    @Generated
    public String getCustomerName() {
        return this.customerName;
    }

    @Generated
    public String getCustomerPhone() {
        return this.customerPhone;
    }

    @Generated
    public ShippingDetails getCustomerShipping() {
        return this.customerShipping;
    }

    @Generated
    public String getCustomerTaxExempt() {
        return this.customerTaxExempt;
    }

    @Generated
    public List<CustomerTaxId> getCustomerTaxIds() {
        return this.customerTaxIds;
    }

    @Generated
    public List<TaxRate> getDefaultTaxRates() {
        return this.defaultTaxRates;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Discount getDiscount() {
        return this.discount;
    }

    @Generated
    public Long getDueDate() {
        return this.dueDate;
    }

    @Generated
    public Long getEffectiveAt() {
        return this.effectiveAt;
    }

    @Generated
    public Long getEndingBalance() {
        return this.endingBalance;
    }

    @Generated
    public String getFooter() {
        return this.footer;
    }

    @Generated
    public FromInvoice getFromInvoice() {
        return this.fromInvoice;
    }

    @Generated
    public String getHostedInvoiceUrl() {
        return this.hostedInvoiceUrl;
    }

    @Generated
    public String getInvoicePdf() {
        return this.invoicePdf;
    }

    @Generated
    public StripeError getLastFinalizationError() {
        return this.lastFinalizationError;
    }

    @Generated
    public InvoiceLineItemCollection getLines() {
        return this.lines;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public Long getNextPaymentAttempt() {
        return this.nextPaymentAttempt;
    }

    @Generated
    public String getNumber() {
        return this.number;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Boolean getPaid() {
        return this.paid;
    }

    @Generated
    public Boolean getPaidOutOfBand() {
        return this.paidOutOfBand;
    }

    @Generated
    public PaymentSettings getPaymentSettings() {
        return this.paymentSettings;
    }

    @Generated
    public Long getPeriodEnd() {
        return this.periodEnd;
    }

    @Generated
    public Long getPeriodStart() {
        return this.periodStart;
    }

    @Generated
    public Long getPostPaymentCreditNotesAmount() {
        return this.postPaymentCreditNotesAmount;
    }

    @Generated
    public Long getPrePaymentCreditNotesAmount() {
        return this.prePaymentCreditNotesAmount;
    }

    @Generated
    public String getReceiptNumber() {
        return this.receiptNumber;
    }

    @Generated
    public RenderingOptions getRenderingOptions() {
        return this.renderingOptions;
    }

    @Generated
    public ShippingCost getShippingCost() {
        return this.shippingCost;
    }

    @Generated
    public ShippingDetails getShippingDetails() {
        return this.shippingDetails;
    }

    @Generated
    public Long getStartingBalance() {
        return this.startingBalance;
    }

    @Generated
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public StatusTransitions getStatusTransitions() {
        return this.statusTransitions;
    }

    @Generated
    public SubscriptionDetails getSubscriptionDetails() {
        return this.subscriptionDetails;
    }

    @Generated
    public Long getSubscriptionProrationDate() {
        return this.subscriptionProrationDate;
    }

    @Generated
    public Long getSubtotal() {
        return this.subtotal;
    }

    @Generated
    public Long getSubtotalExcludingTax() {
        return this.subtotalExcludingTax;
    }

    @Generated
    public Long getTax() {
        return this.tax;
    }

    @Generated
    public ThresholdReason getThresholdReason() {
        return this.thresholdReason;
    }

    @Generated
    public Long getTotal() {
        return this.total;
    }

    @Generated
    public List<TotalDiscountAmount> getTotalDiscountAmounts() {
        return this.totalDiscountAmounts;
    }

    @Generated
    public Long getTotalExcludingTax() {
        return this.totalExcludingTax;
    }

    @Generated
    public List<TotalTaxAmount> getTotalTaxAmounts() {
        return this.totalTaxAmounts;
    }

    @Generated
    public TransferData getTransferData() {
        return this.transferData;
    }

    @Generated
    public Long getWebhooksDeliveredAt() {
        return this.webhooksDeliveredAt;
    }

    @Generated
    public void setAccountCountry(String accountCountry) {
        this.accountCountry = accountCountry;
    }

    @Generated
    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    @Generated
    public void setAmountDue(Long amountDue) {
        this.amountDue = amountDue;
    }

    @Generated
    public void setAmountPaid(Long amountPaid) {
        this.amountPaid = amountPaid;
    }

    @Generated
    public void setAmountRemaining(Long amountRemaining) {
        this.amountRemaining = amountRemaining;
    }

    @Generated
    public void setAmountShipping(Long amountShipping) {
        this.amountShipping = amountShipping;
    }

    @Generated
    public void setApplicationFeeAmount(Long applicationFeeAmount) {
        this.applicationFeeAmount = applicationFeeAmount;
    }

    @Generated
    public void setAttemptCount(Long attemptCount) {
        this.attemptCount = attemptCount;
    }

    @Generated
    public void setAttempted(Boolean attempted) {
        this.attempted = attempted;
    }

    @Generated
    public void setAutoAdvance(Boolean autoAdvance) {
        this.autoAdvance = autoAdvance;
    }

    @Generated
    public void setAutomaticTax(AutomaticTax automaticTax) {
        this.automaticTax = automaticTax;
    }

    @Generated
    public void setBillingReason(String billingReason) {
        this.billingReason = billingReason;
    }

    @Generated
    public void setCollectionMethod(String collectionMethod) {
        this.collectionMethod = collectionMethod;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setCustomFields(List<CustomField> customFields) {
        this.customFields = customFields;
    }

    @Generated
    public void setCustomerAddress(Address customerAddress) {
        this.customerAddress = customerAddress;
    }

    @Generated
    public void setCustomerEmail(String customerEmail) {
        this.customerEmail = customerEmail;
    }

    @Generated
    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    @Generated
    public void setCustomerPhone(String customerPhone) {
        this.customerPhone = customerPhone;
    }

    @Generated
    public void setCustomerShipping(ShippingDetails customerShipping) {
        this.customerShipping = customerShipping;
    }

    @Generated
    public void setCustomerTaxExempt(String customerTaxExempt) {
        this.customerTaxExempt = customerTaxExempt;
    }

    @Generated
    public void setCustomerTaxIds(List<CustomerTaxId> customerTaxIds) {
        this.customerTaxIds = customerTaxIds;
    }

    @Generated
    public void setDefaultTaxRates(List<TaxRate> defaultTaxRates) {
        this.defaultTaxRates = defaultTaxRates;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setDiscount(Discount discount) {
        this.discount = discount;
    }

    @Generated
    public void setDueDate(Long dueDate) {
        this.dueDate = dueDate;
    }

    @Generated
    public void setEffectiveAt(Long effectiveAt) {
        this.effectiveAt = effectiveAt;
    }

    @Generated
    public void setEndingBalance(Long endingBalance) {
        this.endingBalance = endingBalance;
    }

    @Generated
    public void setFooter(String footer) {
        this.footer = footer;
    }

    @Generated
    public void setFromInvoice(FromInvoice fromInvoice) {
        this.fromInvoice = fromInvoice;
    }

    @Generated
    public void setHostedInvoiceUrl(String hostedInvoiceUrl) {
        this.hostedInvoiceUrl = hostedInvoiceUrl;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setInvoicePdf(String invoicePdf) {
        this.invoicePdf = invoicePdf;
    }

    @Generated
    public void setLastFinalizationError(StripeError lastFinalizationError) {
        this.lastFinalizationError = lastFinalizationError;
    }

    @Generated
    public void setLines(InvoiceLineItemCollection lines) {
        this.lines = lines;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setNextPaymentAttempt(Long nextPaymentAttempt) {
        this.nextPaymentAttempt = nextPaymentAttempt;
    }

    @Generated
    public void setNumber(String number) {
        this.number = number;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPaid(Boolean paid) {
        this.paid = paid;
    }

    @Generated
    public void setPaidOutOfBand(Boolean paidOutOfBand) {
        this.paidOutOfBand = paidOutOfBand;
    }

    @Generated
    public void setPaymentSettings(PaymentSettings paymentSettings) {
        this.paymentSettings = paymentSettings;
    }

    @Generated
    public void setPeriodEnd(Long periodEnd) {
        this.periodEnd = periodEnd;
    }

    @Generated
    public void setPeriodStart(Long periodStart) {
        this.periodStart = periodStart;
    }

    @Generated
    public void setPostPaymentCreditNotesAmount(Long postPaymentCreditNotesAmount) {
        this.postPaymentCreditNotesAmount = postPaymentCreditNotesAmount;
    }

    @Generated
    public void setPrePaymentCreditNotesAmount(Long prePaymentCreditNotesAmount) {
        this.prePaymentCreditNotesAmount = prePaymentCreditNotesAmount;
    }

    @Generated
    public void setReceiptNumber(String receiptNumber) {
        this.receiptNumber = receiptNumber;
    }

    @Generated
    public void setRenderingOptions(RenderingOptions renderingOptions) {
        this.renderingOptions = renderingOptions;
    }

    @Generated
    public void setShippingCost(ShippingCost shippingCost) {
        this.shippingCost = shippingCost;
    }

    @Generated
    public void setShippingDetails(ShippingDetails shippingDetails) {
        this.shippingDetails = shippingDetails;
    }

    @Generated
    public void setStartingBalance(Long startingBalance) {
        this.startingBalance = startingBalance;
    }

    @Generated
    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setStatusTransitions(StatusTransitions statusTransitions) {
        this.statusTransitions = statusTransitions;
    }

    @Generated
    public void setSubscriptionDetails(SubscriptionDetails subscriptionDetails) {
        this.subscriptionDetails = subscriptionDetails;
    }

    @Generated
    public void setSubscriptionProrationDate(Long subscriptionProrationDate) {
        this.subscriptionProrationDate = subscriptionProrationDate;
    }

    @Generated
    public void setSubtotal(Long subtotal) {
        this.subtotal = subtotal;
    }

    @Generated
    public void setSubtotalExcludingTax(Long subtotalExcludingTax) {
        this.subtotalExcludingTax = subtotalExcludingTax;
    }

    @Generated
    public void setTax(Long tax) {
        this.tax = tax;
    }

    @Generated
    public void setThresholdReason(ThresholdReason thresholdReason) {
        this.thresholdReason = thresholdReason;
    }

    @Generated
    public void setTotal(Long total) {
        this.total = total;
    }

    @Generated
    public void setTotalDiscountAmounts(List<TotalDiscountAmount> totalDiscountAmounts) {
        this.totalDiscountAmounts = totalDiscountAmounts;
    }

    @Generated
    public void setTotalExcludingTax(Long totalExcludingTax) {
        this.totalExcludingTax = totalExcludingTax;
    }

    @Generated
    public void setTotalTaxAmounts(List<TotalTaxAmount> totalTaxAmounts) {
        this.totalTaxAmounts = totalTaxAmounts;
    }

    @Generated
    public void setTransferData(TransferData transferData) {
        this.transferData = transferData;
    }

    @Generated
    public void setWebhooksDeliveredAt(Long webhooksDeliveredAt) {
        this.webhooksDeliveredAt = webhooksDeliveredAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Invoice)) {
            return false;
        }
        Invoice other = (Invoice)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amountDue = this.getAmountDue();
        Long other$amountDue = other.getAmountDue();
        if (this$amountDue == null ? other$amountDue != null : !((Object)this$amountDue).equals(other$amountDue)) {
            return false;
        }
        Long this$amountPaid = this.getAmountPaid();
        Long other$amountPaid = other.getAmountPaid();
        if (this$amountPaid == null ? other$amountPaid != null : !((Object)this$amountPaid).equals(other$amountPaid)) {
            return false;
        }
        Long this$amountRemaining = this.getAmountRemaining();
        Long other$amountRemaining = other.getAmountRemaining();
        if (this$amountRemaining == null ? other$amountRemaining != null : !((Object)this$amountRemaining).equals(other$amountRemaining)) {
            return false;
        }
        Long this$amountShipping = this.getAmountShipping();
        Long other$amountShipping = other.getAmountShipping();
        if (this$amountShipping == null ? other$amountShipping != null : !((Object)this$amountShipping).equals(other$amountShipping)) {
            return false;
        }
        Long this$applicationFeeAmount = this.getApplicationFeeAmount();
        Long other$applicationFeeAmount = other.getApplicationFeeAmount();
        if (this$applicationFeeAmount == null ? other$applicationFeeAmount != null : !((Object)this$applicationFeeAmount).equals(other$applicationFeeAmount)) {
            return false;
        }
        Long this$attemptCount = this.getAttemptCount();
        Long other$attemptCount = other.getAttemptCount();
        if (this$attemptCount == null ? other$attemptCount != null : !((Object)this$attemptCount).equals(other$attemptCount)) {
            return false;
        }
        Boolean this$attempted = this.getAttempted();
        Boolean other$attempted = other.getAttempted();
        if (this$attempted == null ? other$attempted != null : !((Object)this$attempted).equals(other$attempted)) {
            return false;
        }
        Boolean this$autoAdvance = this.getAutoAdvance();
        Boolean other$autoAdvance = other.getAutoAdvance();
        if (this$autoAdvance == null ? other$autoAdvance != null : !((Object)this$autoAdvance).equals(other$autoAdvance)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        Long this$dueDate = this.getDueDate();
        Long other$dueDate = other.getDueDate();
        if (this$dueDate == null ? other$dueDate != null : !((Object)this$dueDate).equals(other$dueDate)) {
            return false;
        }
        Long this$effectiveAt = this.getEffectiveAt();
        Long other$effectiveAt = other.getEffectiveAt();
        if (this$effectiveAt == null ? other$effectiveAt != null : !((Object)this$effectiveAt).equals(other$effectiveAt)) {
            return false;
        }
        Long this$endingBalance = this.getEndingBalance();
        Long other$endingBalance = other.getEndingBalance();
        if (this$endingBalance == null ? other$endingBalance != null : !((Object)this$endingBalance).equals(other$endingBalance)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$nextPaymentAttempt = this.getNextPaymentAttempt();
        Long other$nextPaymentAttempt = other.getNextPaymentAttempt();
        if (this$nextPaymentAttempt == null ? other$nextPaymentAttempt != null : !((Object)this$nextPaymentAttempt).equals(other$nextPaymentAttempt)) {
            return false;
        }
        Boolean this$paid = this.getPaid();
        Boolean other$paid = other.getPaid();
        if (this$paid == null ? other$paid != null : !((Object)this$paid).equals(other$paid)) {
            return false;
        }
        Boolean this$paidOutOfBand = this.getPaidOutOfBand();
        Boolean other$paidOutOfBand = other.getPaidOutOfBand();
        if (this$paidOutOfBand == null ? other$paidOutOfBand != null : !((Object)this$paidOutOfBand).equals(other$paidOutOfBand)) {
            return false;
        }
        Long this$periodEnd = this.getPeriodEnd();
        Long other$periodEnd = other.getPeriodEnd();
        if (this$periodEnd == null ? other$periodEnd != null : !((Object)this$periodEnd).equals(other$periodEnd)) {
            return false;
        }
        Long this$periodStart = this.getPeriodStart();
        Long other$periodStart = other.getPeriodStart();
        if (this$periodStart == null ? other$periodStart != null : !((Object)this$periodStart).equals(other$periodStart)) {
            return false;
        }
        Long this$postPaymentCreditNotesAmount = this.getPostPaymentCreditNotesAmount();
        Long other$postPaymentCreditNotesAmount = other.getPostPaymentCreditNotesAmount();
        if (this$postPaymentCreditNotesAmount == null ? other$postPaymentCreditNotesAmount != null : !((Object)this$postPaymentCreditNotesAmount).equals(other$postPaymentCreditNotesAmount)) {
            return false;
        }
        Long this$prePaymentCreditNotesAmount = this.getPrePaymentCreditNotesAmount();
        Long other$prePaymentCreditNotesAmount = other.getPrePaymentCreditNotesAmount();
        if (this$prePaymentCreditNotesAmount == null ? other$prePaymentCreditNotesAmount != null : !((Object)this$prePaymentCreditNotesAmount).equals(other$prePaymentCreditNotesAmount)) {
            return false;
        }
        Long this$startingBalance = this.getStartingBalance();
        Long other$startingBalance = other.getStartingBalance();
        if (this$startingBalance == null ? other$startingBalance != null : !((Object)this$startingBalance).equals(other$startingBalance)) {
            return false;
        }
        Long this$subscriptionProrationDate = this.getSubscriptionProrationDate();
        Long other$subscriptionProrationDate = other.getSubscriptionProrationDate();
        if (this$subscriptionProrationDate == null ? other$subscriptionProrationDate != null : !((Object)this$subscriptionProrationDate).equals(other$subscriptionProrationDate)) {
            return false;
        }
        Long this$subtotal = this.getSubtotal();
        Long other$subtotal = other.getSubtotal();
        if (this$subtotal == null ? other$subtotal != null : !((Object)this$subtotal).equals(other$subtotal)) {
            return false;
        }
        Long this$subtotalExcludingTax = this.getSubtotalExcludingTax();
        Long other$subtotalExcludingTax = other.getSubtotalExcludingTax();
        if (this$subtotalExcludingTax == null ? other$subtotalExcludingTax != null : !((Object)this$subtotalExcludingTax).equals(other$subtotalExcludingTax)) {
            return false;
        }
        Long this$tax = this.getTax();
        Long other$tax = other.getTax();
        if (this$tax == null ? other$tax != null : !((Object)this$tax).equals(other$tax)) {
            return false;
        }
        Long this$total = this.getTotal();
        Long other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        Long this$totalExcludingTax = this.getTotalExcludingTax();
        Long other$totalExcludingTax = other.getTotalExcludingTax();
        if (this$totalExcludingTax == null ? other$totalExcludingTax != null : !((Object)this$totalExcludingTax).equals(other$totalExcludingTax)) {
            return false;
        }
        Long this$webhooksDeliveredAt = this.getWebhooksDeliveredAt();
        Long other$webhooksDeliveredAt = other.getWebhooksDeliveredAt();
        if (this$webhooksDeliveredAt == null ? other$webhooksDeliveredAt != null : !((Object)this$webhooksDeliveredAt).equals(other$webhooksDeliveredAt)) {
            return false;
        }
        String this$accountCountry = this.getAccountCountry();
        String other$accountCountry = other.getAccountCountry();
        if (this$accountCountry == null ? other$accountCountry != null : !this$accountCountry.equals(other$accountCountry)) {
            return false;
        }
        String this$accountName = this.getAccountName();
        String other$accountName = other.getAccountName();
        if (this$accountName == null ? other$accountName != null : !this$accountName.equals(other$accountName)) {
            return false;
        }
        List<String> this$accountTaxIds = this.getAccountTaxIds();
        List<String> other$accountTaxIds = other.getAccountTaxIds();
        if (this$accountTaxIds == null ? other$accountTaxIds != null : !((Object)this$accountTaxIds).equals(other$accountTaxIds)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        AutomaticTax this$automaticTax = this.getAutomaticTax();
        AutomaticTax other$automaticTax = other.getAutomaticTax();
        if (this$automaticTax == null ? other$automaticTax != null : !((Object)this$automaticTax).equals(other$automaticTax)) {
            return false;
        }
        String this$billingReason = this.getBillingReason();
        String other$billingReason = other.getBillingReason();
        if (this$billingReason == null ? other$billingReason != null : !this$billingReason.equals(other$billingReason)) {
            return false;
        }
        String this$charge = this.getCharge();
        String other$charge = other.getCharge();
        if (this$charge == null ? other$charge != null : !this$charge.equals(other$charge)) {
            return false;
        }
        String this$collectionMethod = this.getCollectionMethod();
        String other$collectionMethod = other.getCollectionMethod();
        if (this$collectionMethod == null ? other$collectionMethod != null : !this$collectionMethod.equals(other$collectionMethod)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        List<CustomField> this$customFields = this.getCustomFields();
        List<CustomField> other$customFields = other.getCustomFields();
        if (this$customFields == null ? other$customFields != null : !((Object)this$customFields).equals(other$customFields)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        Address this$customerAddress = this.getCustomerAddress();
        Address other$customerAddress = other.getCustomerAddress();
        if (this$customerAddress == null ? other$customerAddress != null : !((Object)this$customerAddress).equals(other$customerAddress)) {
            return false;
        }
        String this$customerEmail = this.getCustomerEmail();
        String other$customerEmail = other.getCustomerEmail();
        if (this$customerEmail == null ? other$customerEmail != null : !this$customerEmail.equals(other$customerEmail)) {
            return false;
        }
        String this$customerName = this.getCustomerName();
        String other$customerName = other.getCustomerName();
        if (this$customerName == null ? other$customerName != null : !this$customerName.equals(other$customerName)) {
            return false;
        }
        String this$customerPhone = this.getCustomerPhone();
        String other$customerPhone = other.getCustomerPhone();
        if (this$customerPhone == null ? other$customerPhone != null : !this$customerPhone.equals(other$customerPhone)) {
            return false;
        }
        ShippingDetails this$customerShipping = this.getCustomerShipping();
        ShippingDetails other$customerShipping = other.getCustomerShipping();
        if (this$customerShipping == null ? other$customerShipping != null : !((Object)this$customerShipping).equals(other$customerShipping)) {
            return false;
        }
        String this$customerTaxExempt = this.getCustomerTaxExempt();
        String other$customerTaxExempt = other.getCustomerTaxExempt();
        if (this$customerTaxExempt == null ? other$customerTaxExempt != null : !this$customerTaxExempt.equals(other$customerTaxExempt)) {
            return false;
        }
        List<CustomerTaxId> this$customerTaxIds = this.getCustomerTaxIds();
        List<CustomerTaxId> other$customerTaxIds = other.getCustomerTaxIds();
        if (this$customerTaxIds == null ? other$customerTaxIds != null : !((Object)this$customerTaxIds).equals(other$customerTaxIds)) {
            return false;
        }
        String this$defaultPaymentMethod = this.getDefaultPaymentMethod();
        String other$defaultPaymentMethod = other.getDefaultPaymentMethod();
        if (this$defaultPaymentMethod == null ? other$defaultPaymentMethod != null : !this$defaultPaymentMethod.equals(other$defaultPaymentMethod)) {
            return false;
        }
        String this$defaultSource = this.getDefaultSource();
        String other$defaultSource = other.getDefaultSource();
        if (this$defaultSource == null ? other$defaultSource != null : !this$defaultSource.equals(other$defaultSource)) {
            return false;
        }
        List<TaxRate> this$defaultTaxRates = this.getDefaultTaxRates();
        List<TaxRate> other$defaultTaxRates = other.getDefaultTaxRates();
        if (this$defaultTaxRates == null ? other$defaultTaxRates != null : !((Object)this$defaultTaxRates).equals(other$defaultTaxRates)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Discount this$discount = this.getDiscount();
        Discount other$discount = other.getDiscount();
        if (this$discount == null ? other$discount != null : !((Object)this$discount).equals(other$discount)) {
            return false;
        }
        List<String> this$discounts = this.getDiscounts();
        List<String> other$discounts = other.getDiscounts();
        if (this$discounts == null ? other$discounts != null : !((Object)this$discounts).equals(other$discounts)) {
            return false;
        }
        String this$footer = this.getFooter();
        String other$footer = other.getFooter();
        if (this$footer == null ? other$footer != null : !this$footer.equals(other$footer)) {
            return false;
        }
        FromInvoice this$fromInvoice = this.getFromInvoice();
        FromInvoice other$fromInvoice = other.getFromInvoice();
        if (this$fromInvoice == null ? other$fromInvoice != null : !((Object)this$fromInvoice).equals(other$fromInvoice)) {
            return false;
        }
        String this$hostedInvoiceUrl = this.getHostedInvoiceUrl();
        String other$hostedInvoiceUrl = other.getHostedInvoiceUrl();
        if (this$hostedInvoiceUrl == null ? other$hostedInvoiceUrl != null : !this$hostedInvoiceUrl.equals(other$hostedInvoiceUrl)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$invoicePdf = this.getInvoicePdf();
        String other$invoicePdf = other.getInvoicePdf();
        if (this$invoicePdf == null ? other$invoicePdf != null : !this$invoicePdf.equals(other$invoicePdf)) {
            return false;
        }
        StripeError this$lastFinalizationError = this.getLastFinalizationError();
        StripeError other$lastFinalizationError = other.getLastFinalizationError();
        if (this$lastFinalizationError == null ? other$lastFinalizationError != null : !((Object)this$lastFinalizationError).equals(other$lastFinalizationError)) {
            return false;
        }
        String this$latestRevision = this.getLatestRevision();
        String other$latestRevision = other.getLatestRevision();
        if (this$latestRevision == null ? other$latestRevision != null : !this$latestRevision.equals(other$latestRevision)) {
            return false;
        }
        InvoiceLineItemCollection this$lines = this.getLines();
        InvoiceLineItemCollection other$lines = other.getLines();
        if (this$lines == null ? other$lines != null : !((Object)this$lines).equals(other$lines)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$number = this.getNumber();
        String other$number = other.getNumber();
        if (this$number == null ? other$number != null : !this$number.equals(other$number)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$onBehalfOf = this.getOnBehalfOf();
        String other$onBehalfOf = other.getOnBehalfOf();
        if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) {
            return false;
        }
        String this$paymentIntent = this.getPaymentIntent();
        String other$paymentIntent = other.getPaymentIntent();
        if (this$paymentIntent == null ? other$paymentIntent != null : !this$paymentIntent.equals(other$paymentIntent)) {
            return false;
        }
        PaymentSettings this$paymentSettings = this.getPaymentSettings();
        PaymentSettings other$paymentSettings = other.getPaymentSettings();
        if (this$paymentSettings == null ? other$paymentSettings != null : !((Object)this$paymentSettings).equals(other$paymentSettings)) {
            return false;
        }
        String this$quote = this.getQuote();
        String other$quote = other.getQuote();
        if (this$quote == null ? other$quote != null : !this$quote.equals(other$quote)) {
            return false;
        }
        String this$receiptNumber = this.getReceiptNumber();
        String other$receiptNumber = other.getReceiptNumber();
        if (this$receiptNumber == null ? other$receiptNumber != null : !this$receiptNumber.equals(other$receiptNumber)) {
            return false;
        }
        RenderingOptions this$renderingOptions = this.getRenderingOptions();
        RenderingOptions other$renderingOptions = other.getRenderingOptions();
        if (this$renderingOptions == null ? other$renderingOptions != null : !((Object)this$renderingOptions).equals(other$renderingOptions)) {
            return false;
        }
        ShippingCost this$shippingCost = this.getShippingCost();
        ShippingCost other$shippingCost = other.getShippingCost();
        if (this$shippingCost == null ? other$shippingCost != null : !((Object)this$shippingCost).equals(other$shippingCost)) {
            return false;
        }
        ShippingDetails this$shippingDetails = this.getShippingDetails();
        ShippingDetails other$shippingDetails = other.getShippingDetails();
        if (this$shippingDetails == null ? other$shippingDetails != null : !((Object)this$shippingDetails).equals(other$shippingDetails)) {
            return false;
        }
        String this$statementDescriptor = this.getStatementDescriptor();
        String other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        StatusTransitions this$statusTransitions = this.getStatusTransitions();
        StatusTransitions other$statusTransitions = other.getStatusTransitions();
        if (this$statusTransitions == null ? other$statusTransitions != null : !((Object)this$statusTransitions).equals(other$statusTransitions)) {
            return false;
        }
        String this$subscription = this.getSubscription();
        String other$subscription = other.getSubscription();
        if (this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription)) {
            return false;
        }
        SubscriptionDetails this$subscriptionDetails = this.getSubscriptionDetails();
        SubscriptionDetails other$subscriptionDetails = other.getSubscriptionDetails();
        if (this$subscriptionDetails == null ? other$subscriptionDetails != null : !((Object)this$subscriptionDetails).equals(other$subscriptionDetails)) {
            return false;
        }
        String this$testClock = this.getTestClock();
        String other$testClock = other.getTestClock();
        if (this$testClock == null ? other$testClock != null : !this$testClock.equals(other$testClock)) {
            return false;
        }
        ThresholdReason this$thresholdReason = this.getThresholdReason();
        ThresholdReason other$thresholdReason = other.getThresholdReason();
        if (this$thresholdReason == null ? other$thresholdReason != null : !((Object)this$thresholdReason).equals(other$thresholdReason)) {
            return false;
        }
        List<TotalDiscountAmount> this$totalDiscountAmounts = this.getTotalDiscountAmounts();
        List<TotalDiscountAmount> other$totalDiscountAmounts = other.getTotalDiscountAmounts();
        if (this$totalDiscountAmounts == null ? other$totalDiscountAmounts != null : !((Object)this$totalDiscountAmounts).equals(other$totalDiscountAmounts)) {
            return false;
        }
        List<TotalTaxAmount> this$totalTaxAmounts = this.getTotalTaxAmounts();
        List<TotalTaxAmount> other$totalTaxAmounts = other.getTotalTaxAmounts();
        if (this$totalTaxAmounts == null ? other$totalTaxAmounts != null : !((Object)this$totalTaxAmounts).equals(other$totalTaxAmounts)) {
            return false;
        }
        TransferData this$transferData = this.getTransferData();
        TransferData other$transferData = other.getTransferData();
        return !(this$transferData == null ? other$transferData != null : !((Object)this$transferData).equals(other$transferData));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Invoice;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amountDue = this.getAmountDue();
        result = result * 59 + ($amountDue == null ? 43 : ((Object)$amountDue).hashCode());
        Long $amountPaid = this.getAmountPaid();
        result = result * 59 + ($amountPaid == null ? 43 : ((Object)$amountPaid).hashCode());
        Long $amountRemaining = this.getAmountRemaining();
        result = result * 59 + ($amountRemaining == null ? 43 : ((Object)$amountRemaining).hashCode());
        Long $amountShipping = this.getAmountShipping();
        result = result * 59 + ($amountShipping == null ? 43 : ((Object)$amountShipping).hashCode());
        Long $applicationFeeAmount = this.getApplicationFeeAmount();
        result = result * 59 + ($applicationFeeAmount == null ? 43 : ((Object)$applicationFeeAmount).hashCode());
        Long $attemptCount = this.getAttemptCount();
        result = result * 59 + ($attemptCount == null ? 43 : ((Object)$attemptCount).hashCode());
        Boolean $attempted = this.getAttempted();
        result = result * 59 + ($attempted == null ? 43 : ((Object)$attempted).hashCode());
        Boolean $autoAdvance = this.getAutoAdvance();
        result = result * 59 + ($autoAdvance == null ? 43 : ((Object)$autoAdvance).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        Long $dueDate = this.getDueDate();
        result = result * 59 + ($dueDate == null ? 43 : ((Object)$dueDate).hashCode());
        Long $effectiveAt = this.getEffectiveAt();
        result = result * 59 + ($effectiveAt == null ? 43 : ((Object)$effectiveAt).hashCode());
        Long $endingBalance = this.getEndingBalance();
        result = result * 59 + ($endingBalance == null ? 43 : ((Object)$endingBalance).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $nextPaymentAttempt = this.getNextPaymentAttempt();
        result = result * 59 + ($nextPaymentAttempt == null ? 43 : ((Object)$nextPaymentAttempt).hashCode());
        Boolean $paid = this.getPaid();
        result = result * 59 + ($paid == null ? 43 : ((Object)$paid).hashCode());
        Boolean $paidOutOfBand = this.getPaidOutOfBand();
        result = result * 59 + ($paidOutOfBand == null ? 43 : ((Object)$paidOutOfBand).hashCode());
        Long $periodEnd = this.getPeriodEnd();
        result = result * 59 + ($periodEnd == null ? 43 : ((Object)$periodEnd).hashCode());
        Long $periodStart = this.getPeriodStart();
        result = result * 59 + ($periodStart == null ? 43 : ((Object)$periodStart).hashCode());
        Long $postPaymentCreditNotesAmount = this.getPostPaymentCreditNotesAmount();
        result = result * 59 + ($postPaymentCreditNotesAmount == null ? 43 : ((Object)$postPaymentCreditNotesAmount).hashCode());
        Long $prePaymentCreditNotesAmount = this.getPrePaymentCreditNotesAmount();
        result = result * 59 + ($prePaymentCreditNotesAmount == null ? 43 : ((Object)$prePaymentCreditNotesAmount).hashCode());
        Long $startingBalance = this.getStartingBalance();
        result = result * 59 + ($startingBalance == null ? 43 : ((Object)$startingBalance).hashCode());
        Long $subscriptionProrationDate = this.getSubscriptionProrationDate();
        result = result * 59 + ($subscriptionProrationDate == null ? 43 : ((Object)$subscriptionProrationDate).hashCode());
        Long $subtotal = this.getSubtotal();
        result = result * 59 + ($subtotal == null ? 43 : ((Object)$subtotal).hashCode());
        Long $subtotalExcludingTax = this.getSubtotalExcludingTax();
        result = result * 59 + ($subtotalExcludingTax == null ? 43 : ((Object)$subtotalExcludingTax).hashCode());
        Long $tax = this.getTax();
        result = result * 59 + ($tax == null ? 43 : ((Object)$tax).hashCode());
        Long $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        Long $totalExcludingTax = this.getTotalExcludingTax();
        result = result * 59 + ($totalExcludingTax == null ? 43 : ((Object)$totalExcludingTax).hashCode());
        Long $webhooksDeliveredAt = this.getWebhooksDeliveredAt();
        result = result * 59 + ($webhooksDeliveredAt == null ? 43 : ((Object)$webhooksDeliveredAt).hashCode());
        String $accountCountry = this.getAccountCountry();
        result = result * 59 + ($accountCountry == null ? 43 : $accountCountry.hashCode());
        String $accountName = this.getAccountName();
        result = result * 59 + ($accountName == null ? 43 : $accountName.hashCode());
        List<String> $accountTaxIds = this.getAccountTaxIds();
        result = result * 59 + ($accountTaxIds == null ? 43 : ((Object)$accountTaxIds).hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        AutomaticTax $automaticTax = this.getAutomaticTax();
        result = result * 59 + ($automaticTax == null ? 43 : ((Object)$automaticTax).hashCode());
        String $billingReason = this.getBillingReason();
        result = result * 59 + ($billingReason == null ? 43 : $billingReason.hashCode());
        String $charge = this.getCharge();
        result = result * 59 + ($charge == null ? 43 : $charge.hashCode());
        String $collectionMethod = this.getCollectionMethod();
        result = result * 59 + ($collectionMethod == null ? 43 : $collectionMethod.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        List<CustomField> $customFields = this.getCustomFields();
        result = result * 59 + ($customFields == null ? 43 : ((Object)$customFields).hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        Address $customerAddress = this.getCustomerAddress();
        result = result * 59 + ($customerAddress == null ? 43 : ((Object)$customerAddress).hashCode());
        String $customerEmail = this.getCustomerEmail();
        result = result * 59 + ($customerEmail == null ? 43 : $customerEmail.hashCode());
        String $customerName = this.getCustomerName();
        result = result * 59 + ($customerName == null ? 43 : $customerName.hashCode());
        String $customerPhone = this.getCustomerPhone();
        result = result * 59 + ($customerPhone == null ? 43 : $customerPhone.hashCode());
        ShippingDetails $customerShipping = this.getCustomerShipping();
        result = result * 59 + ($customerShipping == null ? 43 : ((Object)$customerShipping).hashCode());
        String $customerTaxExempt = this.getCustomerTaxExempt();
        result = result * 59 + ($customerTaxExempt == null ? 43 : $customerTaxExempt.hashCode());
        List<CustomerTaxId> $customerTaxIds = this.getCustomerTaxIds();
        result = result * 59 + ($customerTaxIds == null ? 43 : ((Object)$customerTaxIds).hashCode());
        String $defaultPaymentMethod = this.getDefaultPaymentMethod();
        result = result * 59 + ($defaultPaymentMethod == null ? 43 : $defaultPaymentMethod.hashCode());
        String $defaultSource = this.getDefaultSource();
        result = result * 59 + ($defaultSource == null ? 43 : $defaultSource.hashCode());
        List<TaxRate> $defaultTaxRates = this.getDefaultTaxRates();
        result = result * 59 + ($defaultTaxRates == null ? 43 : ((Object)$defaultTaxRates).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Discount $discount = this.getDiscount();
        result = result * 59 + ($discount == null ? 43 : ((Object)$discount).hashCode());
        List<String> $discounts = this.getDiscounts();
        result = result * 59 + ($discounts == null ? 43 : ((Object)$discounts).hashCode());
        String $footer = this.getFooter();
        result = result * 59 + ($footer == null ? 43 : $footer.hashCode());
        FromInvoice $fromInvoice = this.getFromInvoice();
        result = result * 59 + ($fromInvoice == null ? 43 : ((Object)$fromInvoice).hashCode());
        String $hostedInvoiceUrl = this.getHostedInvoiceUrl();
        result = result * 59 + ($hostedInvoiceUrl == null ? 43 : $hostedInvoiceUrl.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $invoicePdf = this.getInvoicePdf();
        result = result * 59 + ($invoicePdf == null ? 43 : $invoicePdf.hashCode());
        StripeError $lastFinalizationError = this.getLastFinalizationError();
        result = result * 59 + ($lastFinalizationError == null ? 43 : ((Object)$lastFinalizationError).hashCode());
        String $latestRevision = this.getLatestRevision();
        result = result * 59 + ($latestRevision == null ? 43 : $latestRevision.hashCode());
        InvoiceLineItemCollection $lines = this.getLines();
        result = result * 59 + ($lines == null ? 43 : ((Object)$lines).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $number = this.getNumber();
        result = result * 59 + ($number == null ? 43 : $number.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $onBehalfOf = this.getOnBehalfOf();
        result = result * 59 + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
        String $paymentIntent = this.getPaymentIntent();
        result = result * 59 + ($paymentIntent == null ? 43 : $paymentIntent.hashCode());
        PaymentSettings $paymentSettings = this.getPaymentSettings();
        result = result * 59 + ($paymentSettings == null ? 43 : ((Object)$paymentSettings).hashCode());
        String $quote = this.getQuote();
        result = result * 59 + ($quote == null ? 43 : $quote.hashCode());
        String $receiptNumber = this.getReceiptNumber();
        result = result * 59 + ($receiptNumber == null ? 43 : $receiptNumber.hashCode());
        RenderingOptions $renderingOptions = this.getRenderingOptions();
        result = result * 59 + ($renderingOptions == null ? 43 : ((Object)$renderingOptions).hashCode());
        ShippingCost $shippingCost = this.getShippingCost();
        result = result * 59 + ($shippingCost == null ? 43 : ((Object)$shippingCost).hashCode());
        ShippingDetails $shippingDetails = this.getShippingDetails();
        result = result * 59 + ($shippingDetails == null ? 43 : ((Object)$shippingDetails).hashCode());
        String $statementDescriptor = this.getStatementDescriptor();
        result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        StatusTransitions $statusTransitions = this.getStatusTransitions();
        result = result * 59 + ($statusTransitions == null ? 43 : ((Object)$statusTransitions).hashCode());
        String $subscription = this.getSubscription();
        result = result * 59 + ($subscription == null ? 43 : $subscription.hashCode());
        SubscriptionDetails $subscriptionDetails = this.getSubscriptionDetails();
        result = result * 59 + ($subscriptionDetails == null ? 43 : ((Object)$subscriptionDetails).hashCode());
        String $testClock = this.getTestClock();
        result = result * 59 + ($testClock == null ? 43 : $testClock.hashCode());
        ThresholdReason $thresholdReason = this.getThresholdReason();
        result = result * 59 + ($thresholdReason == null ? 43 : ((Object)$thresholdReason).hashCode());
        List<TotalDiscountAmount> $totalDiscountAmounts = this.getTotalDiscountAmounts();
        result = result * 59 + ($totalDiscountAmounts == null ? 43 : ((Object)$totalDiscountAmounts).hashCode());
        List<TotalTaxAmount> $totalTaxAmounts = this.getTotalTaxAmounts();
        result = result * 59 + ($totalTaxAmounts == null ? 43 : ((Object)$totalTaxAmounts).hashCode());
        TransferData $transferData = this.getTransferData();
        result = result * 59 + ($transferData == null ? 43 : ((Object)$transferData).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class AutomaticTax
    extends StripeObject {
        @SerializedName(value="enabled")
        Boolean enabled;
        @SerializedName(value="status")
        String status;

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AutomaticTax)) {
                return false;
            }
            AutomaticTax other = (AutomaticTax)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !this$status.equals(other$status));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AutomaticTax;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            return result;
        }
    }

    public static class FromInvoice
    extends StripeObject {
        @SerializedName(value="action")
        String action;
        @SerializedName(value="invoice")
        ExpandableField<Invoice> invoice;

        public String getInvoice() {
            return this.invoice != null ? this.invoice.getId() : null;
        }

        public void setInvoice(String id) {
            this.invoice = ApiResource.setExpandableFieldId(id, this.invoice);
        }

        public Invoice getInvoiceObject() {
            return this.invoice != null ? this.invoice.getExpanded() : null;
        }

        public void setInvoiceObject(Invoice expandableObject) {
            this.invoice = new ExpandableField<Invoice>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public String getAction() {
            return this.action;
        }

        @Generated
        public void setAction(String action) {
            this.action = action;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FromInvoice)) {
                return false;
            }
            FromInvoice other = (FromInvoice)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$action = this.getAction();
            String other$action = other.getAction();
            if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
                return false;
            }
            String this$invoice = this.getInvoice();
            String other$invoice = other.getInvoice();
            return !(this$invoice == null ? other$invoice != null : !this$invoice.equals(other$invoice));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FromInvoice;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : $action.hashCode());
            String $invoice = this.getInvoice();
            result = result * 59 + ($invoice == null ? 43 : $invoice.hashCode());
            return result;
        }
    }

    public static class PaymentSettings
    extends StripeObject {
        @SerializedName(value="default_mandate")
        String defaultMandate;
        @SerializedName(value="payment_method_options")
        PaymentMethodOptions paymentMethodOptions;
        @SerializedName(value="payment_method_types")
        List<String> paymentMethodTypes;

        @Generated
        public String getDefaultMandate() {
            return this.defaultMandate;
        }

        @Generated
        public PaymentMethodOptions getPaymentMethodOptions() {
            return this.paymentMethodOptions;
        }

        @Generated
        public List<String> getPaymentMethodTypes() {
            return this.paymentMethodTypes;
        }

        @Generated
        public void setDefaultMandate(String defaultMandate) {
            this.defaultMandate = defaultMandate;
        }

        @Generated
        public void setPaymentMethodOptions(PaymentMethodOptions paymentMethodOptions) {
            this.paymentMethodOptions = paymentMethodOptions;
        }

        @Generated
        public void setPaymentMethodTypes(List<String> paymentMethodTypes) {
            this.paymentMethodTypes = paymentMethodTypes;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentSettings)) {
                return false;
            }
            PaymentSettings other = (PaymentSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$defaultMandate = this.getDefaultMandate();
            String other$defaultMandate = other.getDefaultMandate();
            if (this$defaultMandate == null ? other$defaultMandate != null : !this$defaultMandate.equals(other$defaultMandate)) {
                return false;
            }
            PaymentMethodOptions this$paymentMethodOptions = this.getPaymentMethodOptions();
            PaymentMethodOptions other$paymentMethodOptions = other.getPaymentMethodOptions();
            if (this$paymentMethodOptions == null ? other$paymentMethodOptions != null : !((Object)this$paymentMethodOptions).equals(other$paymentMethodOptions)) {
                return false;
            }
            List<String> this$paymentMethodTypes = this.getPaymentMethodTypes();
            List<String> other$paymentMethodTypes = other.getPaymentMethodTypes();
            return !(this$paymentMethodTypes == null ? other$paymentMethodTypes != null : !((Object)this$paymentMethodTypes).equals(other$paymentMethodTypes));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaymentSettings;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $defaultMandate = this.getDefaultMandate();
            result = result * 59 + ($defaultMandate == null ? 43 : $defaultMandate.hashCode());
            PaymentMethodOptions $paymentMethodOptions = this.getPaymentMethodOptions();
            result = result * 59 + ($paymentMethodOptions == null ? 43 : ((Object)$paymentMethodOptions).hashCode());
            List<String> $paymentMethodTypes = this.getPaymentMethodTypes();
            result = result * 59 + ($paymentMethodTypes == null ? 43 : ((Object)$paymentMethodTypes).hashCode());
            return result;
        }

        public static class PaymentMethodOptions
        extends StripeObject {
            @SerializedName(value="acss_debit")
            AcssDebit acssDebit;
            @SerializedName(value="bancontact")
            Bancontact bancontact;
            @SerializedName(value="card")
            Card card;
            @SerializedName(value="customer_balance")
            CustomerBalance customerBalance;
            @SerializedName(value="konbini")
            Konbini konbini;
            @SerializedName(value="us_bank_account")
            UsBankAccount usBankAccount;

            @Generated
            public AcssDebit getAcssDebit() {
                return this.acssDebit;
            }

            @Generated
            public Bancontact getBancontact() {
                return this.bancontact;
            }

            @Generated
            public Card getCard() {
                return this.card;
            }

            @Generated
            public CustomerBalance getCustomerBalance() {
                return this.customerBalance;
            }

            @Generated
            public Konbini getKonbini() {
                return this.konbini;
            }

            @Generated
            public UsBankAccount getUsBankAccount() {
                return this.usBankAccount;
            }

            @Generated
            public void setAcssDebit(AcssDebit acssDebit) {
                this.acssDebit = acssDebit;
            }

            @Generated
            public void setBancontact(Bancontact bancontact) {
                this.bancontact = bancontact;
            }

            @Generated
            public void setCard(Card card) {
                this.card = card;
            }

            @Generated
            public void setCustomerBalance(CustomerBalance customerBalance) {
                this.customerBalance = customerBalance;
            }

            @Generated
            public void setKonbini(Konbini konbini) {
                this.konbini = konbini;
            }

            @Generated
            public void setUsBankAccount(UsBankAccount usBankAccount) {
                this.usBankAccount = usBankAccount;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PaymentMethodOptions)) {
                    return false;
                }
                PaymentMethodOptions other = (PaymentMethodOptions)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                AcssDebit this$acssDebit = this.getAcssDebit();
                AcssDebit other$acssDebit = other.getAcssDebit();
                if (this$acssDebit == null ? other$acssDebit != null : !((Object)this$acssDebit).equals(other$acssDebit)) {
                    return false;
                }
                Bancontact this$bancontact = this.getBancontact();
                Bancontact other$bancontact = other.getBancontact();
                if (this$bancontact == null ? other$bancontact != null : !((Object)this$bancontact).equals(other$bancontact)) {
                    return false;
                }
                Card this$card = this.getCard();
                Card other$card = other.getCard();
                if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                    return false;
                }
                CustomerBalance this$customerBalance = this.getCustomerBalance();
                CustomerBalance other$customerBalance = other.getCustomerBalance();
                if (this$customerBalance == null ? other$customerBalance != null : !((Object)this$customerBalance).equals(other$customerBalance)) {
                    return false;
                }
                Konbini this$konbini = this.getKonbini();
                Konbini other$konbini = other.getKonbini();
                if (this$konbini == null ? other$konbini != null : !((Object)this$konbini).equals(other$konbini)) {
                    return false;
                }
                UsBankAccount this$usBankAccount = this.getUsBankAccount();
                UsBankAccount other$usBankAccount = other.getUsBankAccount();
                return !(this$usBankAccount == null ? other$usBankAccount != null : !((Object)this$usBankAccount).equals(other$usBankAccount));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof PaymentMethodOptions;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                AcssDebit $acssDebit = this.getAcssDebit();
                result = result * 59 + ($acssDebit == null ? 43 : ((Object)$acssDebit).hashCode());
                Bancontact $bancontact = this.getBancontact();
                result = result * 59 + ($bancontact == null ? 43 : ((Object)$bancontact).hashCode());
                Card $card = this.getCard();
                result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
                CustomerBalance $customerBalance = this.getCustomerBalance();
                result = result * 59 + ($customerBalance == null ? 43 : ((Object)$customerBalance).hashCode());
                Konbini $konbini = this.getKonbini();
                result = result * 59 + ($konbini == null ? 43 : ((Object)$konbini).hashCode());
                UsBankAccount $usBankAccount = this.getUsBankAccount();
                result = result * 59 + ($usBankAccount == null ? 43 : ((Object)$usBankAccount).hashCode());
                return result;
            }

            public static class AcssDebit
            extends StripeObject {
                @SerializedName(value="mandate_options")
                MandateOptions mandateOptions;
                @SerializedName(value="verification_method")
                String verificationMethod;

                @Generated
                public MandateOptions getMandateOptions() {
                    return this.mandateOptions;
                }

                @Generated
                public String getVerificationMethod() {
                    return this.verificationMethod;
                }

                @Generated
                public void setMandateOptions(MandateOptions mandateOptions) {
                    this.mandateOptions = mandateOptions;
                }

                @Generated
                public void setVerificationMethod(String verificationMethod) {
                    this.verificationMethod = verificationMethod;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof AcssDebit)) {
                        return false;
                    }
                    AcssDebit other = (AcssDebit)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    MandateOptions this$mandateOptions = this.getMandateOptions();
                    MandateOptions other$mandateOptions = other.getMandateOptions();
                    if (this$mandateOptions == null ? other$mandateOptions != null : !((Object)this$mandateOptions).equals(other$mandateOptions)) {
                        return false;
                    }
                    String this$verificationMethod = this.getVerificationMethod();
                    String other$verificationMethod = other.getVerificationMethod();
                    return !(this$verificationMethod == null ? other$verificationMethod != null : !this$verificationMethod.equals(other$verificationMethod));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof AcssDebit;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    MandateOptions $mandateOptions = this.getMandateOptions();
                    result = result * 59 + ($mandateOptions == null ? 43 : ((Object)$mandateOptions).hashCode());
                    String $verificationMethod = this.getVerificationMethod();
                    result = result * 59 + ($verificationMethod == null ? 43 : $verificationMethod.hashCode());
                    return result;
                }

                public static class MandateOptions
                extends StripeObject {
                    @SerializedName(value="transaction_type")
                    String transactionType;

                    @Generated
                    public String getTransactionType() {
                        return this.transactionType;
                    }

                    @Generated
                    public void setTransactionType(String transactionType) {
                        this.transactionType = transactionType;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof MandateOptions)) {
                            return false;
                        }
                        MandateOptions other = (MandateOptions)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$transactionType = this.getTransactionType();
                        String other$transactionType = other.getTransactionType();
                        return !(this$transactionType == null ? other$transactionType != null : !this$transactionType.equals(other$transactionType));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof MandateOptions;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $transactionType = this.getTransactionType();
                        result = result * 59 + ($transactionType == null ? 43 : $transactionType.hashCode());
                        return result;
                    }
                }
            }

            public static class Bancontact
            extends StripeObject {
                @SerializedName(value="preferred_language")
                String preferredLanguage;

                @Generated
                public String getPreferredLanguage() {
                    return this.preferredLanguage;
                }

                @Generated
                public void setPreferredLanguage(String preferredLanguage) {
                    this.preferredLanguage = preferredLanguage;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Bancontact)) {
                        return false;
                    }
                    Bancontact other = (Bancontact)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$preferredLanguage = this.getPreferredLanguage();
                    String other$preferredLanguage = other.getPreferredLanguage();
                    return !(this$preferredLanguage == null ? other$preferredLanguage != null : !this$preferredLanguage.equals(other$preferredLanguage));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Bancontact;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $preferredLanguage = this.getPreferredLanguage();
                    result = result * 59 + ($preferredLanguage == null ? 43 : $preferredLanguage.hashCode());
                    return result;
                }
            }

            public static class Card
            extends StripeObject {
                @SerializedName(value="installments")
                Installments installments;
                @SerializedName(value="request_three_d_secure")
                String requestThreeDSecure;

                @Generated
                public Installments getInstallments() {
                    return this.installments;
                }

                @Generated
                public String getRequestThreeDSecure() {
                    return this.requestThreeDSecure;
                }

                @Generated
                public void setInstallments(Installments installments) {
                    this.installments = installments;
                }

                @Generated
                public void setRequestThreeDSecure(String requestThreeDSecure) {
                    this.requestThreeDSecure = requestThreeDSecure;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Card)) {
                        return false;
                    }
                    Card other = (Card)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Installments this$installments = this.getInstallments();
                    Installments other$installments = other.getInstallments();
                    if (this$installments == null ? other$installments != null : !((Object)this$installments).equals(other$installments)) {
                        return false;
                    }
                    String this$requestThreeDSecure = this.getRequestThreeDSecure();
                    String other$requestThreeDSecure = other.getRequestThreeDSecure();
                    return !(this$requestThreeDSecure == null ? other$requestThreeDSecure != null : !this$requestThreeDSecure.equals(other$requestThreeDSecure));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Card;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Installments $installments = this.getInstallments();
                    result = result * 59 + ($installments == null ? 43 : ((Object)$installments).hashCode());
                    String $requestThreeDSecure = this.getRequestThreeDSecure();
                    result = result * 59 + ($requestThreeDSecure == null ? 43 : $requestThreeDSecure.hashCode());
                    return result;
                }

                public static class Installments
                extends StripeObject {
                    @SerializedName(value="enabled")
                    Boolean enabled;

                    @Generated
                    public Boolean getEnabled() {
                        return this.enabled;
                    }

                    @Generated
                    public void setEnabled(Boolean enabled) {
                        this.enabled = enabled;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Installments)) {
                            return false;
                        }
                        Installments other = (Installments)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Boolean this$enabled = this.getEnabled();
                        Boolean other$enabled = other.getEnabled();
                        return !(this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Installments;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Boolean $enabled = this.getEnabled();
                        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                        return result;
                    }
                }
            }

            public static class CustomerBalance
            extends StripeObject {
                @SerializedName(value="bank_transfer")
                BankTransfer bankTransfer;
                @SerializedName(value="funding_type")
                String fundingType;

                @Generated
                public BankTransfer getBankTransfer() {
                    return this.bankTransfer;
                }

                @Generated
                public String getFundingType() {
                    return this.fundingType;
                }

                @Generated
                public void setBankTransfer(BankTransfer bankTransfer) {
                    this.bankTransfer = bankTransfer;
                }

                @Generated
                public void setFundingType(String fundingType) {
                    this.fundingType = fundingType;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof CustomerBalance)) {
                        return false;
                    }
                    CustomerBalance other = (CustomerBalance)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    BankTransfer this$bankTransfer = this.getBankTransfer();
                    BankTransfer other$bankTransfer = other.getBankTransfer();
                    if (this$bankTransfer == null ? other$bankTransfer != null : !((Object)this$bankTransfer).equals(other$bankTransfer)) {
                        return false;
                    }
                    String this$fundingType = this.getFundingType();
                    String other$fundingType = other.getFundingType();
                    return !(this$fundingType == null ? other$fundingType != null : !this$fundingType.equals(other$fundingType));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof CustomerBalance;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    BankTransfer $bankTransfer = this.getBankTransfer();
                    result = result * 59 + ($bankTransfer == null ? 43 : ((Object)$bankTransfer).hashCode());
                    String $fundingType = this.getFundingType();
                    result = result * 59 + ($fundingType == null ? 43 : $fundingType.hashCode());
                    return result;
                }

                public static class BankTransfer
                extends StripeObject {
                    @SerializedName(value="eu_bank_transfer")
                    EuBankTransfer euBankTransfer;
                    @SerializedName(value="type")
                    String type;

                    @Generated
                    public EuBankTransfer getEuBankTransfer() {
                        return this.euBankTransfer;
                    }

                    @Generated
                    public String getType() {
                        return this.type;
                    }

                    @Generated
                    public void setEuBankTransfer(EuBankTransfer euBankTransfer) {
                        this.euBankTransfer = euBankTransfer;
                    }

                    @Generated
                    public void setType(String type) {
                        this.type = type;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof BankTransfer)) {
                            return false;
                        }
                        BankTransfer other = (BankTransfer)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        EuBankTransfer this$euBankTransfer = this.getEuBankTransfer();
                        EuBankTransfer other$euBankTransfer = other.getEuBankTransfer();
                        if (this$euBankTransfer == null ? other$euBankTransfer != null : !((Object)this$euBankTransfer).equals(other$euBankTransfer)) {
                            return false;
                        }
                        String this$type = this.getType();
                        String other$type = other.getType();
                        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof BankTransfer;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        EuBankTransfer $euBankTransfer = this.getEuBankTransfer();
                        result = result * 59 + ($euBankTransfer == null ? 43 : ((Object)$euBankTransfer).hashCode());
                        String $type = this.getType();
                        result = result * 59 + ($type == null ? 43 : $type.hashCode());
                        return result;
                    }

                    public static class EuBankTransfer
                    extends StripeObject {
                        @SerializedName(value="country")
                        String country;

                        @Generated
                        public String getCountry() {
                            return this.country;
                        }

                        @Generated
                        public void setCountry(String country) {
                            this.country = country;
                        }

                        @Generated
                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof EuBankTransfer)) {
                                return false;
                            }
                            EuBankTransfer other = (EuBankTransfer)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            String this$country = this.getCountry();
                            String other$country = other.getCountry();
                            return !(this$country == null ? other$country != null : !this$country.equals(other$country));
                        }

                        @Generated
                        protected boolean canEqual(Object other) {
                            return other instanceof EuBankTransfer;
                        }

                        @Generated
                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            String $country = this.getCountry();
                            result = result * 59 + ($country == null ? 43 : $country.hashCode());
                            return result;
                        }
                    }
                }
            }

            public static class Konbini
            extends StripeObject {
                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Konbini)) {
                        return false;
                    }
                    Konbini other = (Konbini)o;
                    return other.canEqual(this);
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Konbini;
                }

                @Generated
                public int hashCode() {
                    boolean result = true;
                    return 1;
                }
            }

            public static class UsBankAccount
            extends StripeObject {
                @SerializedName(value="financial_connections")
                FinancialConnections financialConnections;
                @SerializedName(value="verification_method")
                String verificationMethod;

                @Generated
                public FinancialConnections getFinancialConnections() {
                    return this.financialConnections;
                }

                @Generated
                public String getVerificationMethod() {
                    return this.verificationMethod;
                }

                @Generated
                public void setFinancialConnections(FinancialConnections financialConnections) {
                    this.financialConnections = financialConnections;
                }

                @Generated
                public void setVerificationMethod(String verificationMethod) {
                    this.verificationMethod = verificationMethod;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof UsBankAccount)) {
                        return false;
                    }
                    UsBankAccount other = (UsBankAccount)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    FinancialConnections this$financialConnections = this.getFinancialConnections();
                    FinancialConnections other$financialConnections = other.getFinancialConnections();
                    if (this$financialConnections == null ? other$financialConnections != null : !((Object)this$financialConnections).equals(other$financialConnections)) {
                        return false;
                    }
                    String this$verificationMethod = this.getVerificationMethod();
                    String other$verificationMethod = other.getVerificationMethod();
                    return !(this$verificationMethod == null ? other$verificationMethod != null : !this$verificationMethod.equals(other$verificationMethod));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof UsBankAccount;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    FinancialConnections $financialConnections = this.getFinancialConnections();
                    result = result * 59 + ($financialConnections == null ? 43 : ((Object)$financialConnections).hashCode());
                    String $verificationMethod = this.getVerificationMethod();
                    result = result * 59 + ($verificationMethod == null ? 43 : $verificationMethod.hashCode());
                    return result;
                }

                public static class FinancialConnections
                extends StripeObject {
                    @SerializedName(value="permissions")
                    List<String> permissions;

                    @Generated
                    public List<String> getPermissions() {
                        return this.permissions;
                    }

                    @Generated
                    public void setPermissions(List<String> permissions) {
                        this.permissions = permissions;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof FinancialConnections)) {
                            return false;
                        }
                        FinancialConnections other = (FinancialConnections)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        List<String> this$permissions = this.getPermissions();
                        List<String> other$permissions = other.getPermissions();
                        return !(this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof FinancialConnections;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        List<String> $permissions = this.getPermissions();
                        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
                        return result;
                    }
                }
            }
        }
    }

    public static class RenderingOptions
    extends StripeObject {
        @SerializedName(value="amount_tax_display")
        String amountTaxDisplay;

        @Generated
        public String getAmountTaxDisplay() {
            return this.amountTaxDisplay;
        }

        @Generated
        public void setAmountTaxDisplay(String amountTaxDisplay) {
            this.amountTaxDisplay = amountTaxDisplay;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RenderingOptions)) {
                return false;
            }
            RenderingOptions other = (RenderingOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$amountTaxDisplay = this.getAmountTaxDisplay();
            String other$amountTaxDisplay = other.getAmountTaxDisplay();
            return !(this$amountTaxDisplay == null ? other$amountTaxDisplay != null : !this$amountTaxDisplay.equals(other$amountTaxDisplay));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RenderingOptions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $amountTaxDisplay = this.getAmountTaxDisplay();
            result = result * 59 + ($amountTaxDisplay == null ? 43 : $amountTaxDisplay.hashCode());
            return result;
        }
    }

    public static class ShippingCost
    extends StripeObject {
        @SerializedName(value="amount_subtotal")
        Long amountSubtotal;
        @SerializedName(value="amount_tax")
        Long amountTax;
        @SerializedName(value="amount_total")
        Long amountTotal;
        @SerializedName(value="shipping_rate")
        ExpandableField<ShippingRate> shippingRate;
        @SerializedName(value="taxes")
        List<Tax> taxes;

        public String getShippingRate() {
            return this.shippingRate != null ? this.shippingRate.getId() : null;
        }

        public void setShippingRate(String id) {
            this.shippingRate = ApiResource.setExpandableFieldId(id, this.shippingRate);
        }

        public ShippingRate getShippingRateObject() {
            return this.shippingRate != null ? this.shippingRate.getExpanded() : null;
        }

        public void setShippingRateObject(ShippingRate expandableObject) {
            this.shippingRate = new ExpandableField<ShippingRate>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public Long getAmountSubtotal() {
            return this.amountSubtotal;
        }

        @Generated
        public Long getAmountTax() {
            return this.amountTax;
        }

        @Generated
        public Long getAmountTotal() {
            return this.amountTotal;
        }

        @Generated
        public List<Tax> getTaxes() {
            return this.taxes;
        }

        @Generated
        public void setAmountSubtotal(Long amountSubtotal) {
            this.amountSubtotal = amountSubtotal;
        }

        @Generated
        public void setAmountTax(Long amountTax) {
            this.amountTax = amountTax;
        }

        @Generated
        public void setAmountTotal(Long amountTotal) {
            this.amountTotal = amountTotal;
        }

        @Generated
        public void setTaxes(List<Tax> taxes) {
            this.taxes = taxes;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShippingCost)) {
                return false;
            }
            ShippingCost other = (ShippingCost)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amountSubtotal = this.getAmountSubtotal();
            Long other$amountSubtotal = other.getAmountSubtotal();
            if (this$amountSubtotal == null ? other$amountSubtotal != null : !((Object)this$amountSubtotal).equals(other$amountSubtotal)) {
                return false;
            }
            Long this$amountTax = this.getAmountTax();
            Long other$amountTax = other.getAmountTax();
            if (this$amountTax == null ? other$amountTax != null : !((Object)this$amountTax).equals(other$amountTax)) {
                return false;
            }
            Long this$amountTotal = this.getAmountTotal();
            Long other$amountTotal = other.getAmountTotal();
            if (this$amountTotal == null ? other$amountTotal != null : !((Object)this$amountTotal).equals(other$amountTotal)) {
                return false;
            }
            String this$shippingRate = this.getShippingRate();
            String other$shippingRate = other.getShippingRate();
            if (this$shippingRate == null ? other$shippingRate != null : !this$shippingRate.equals(other$shippingRate)) {
                return false;
            }
            List<Tax> this$taxes = this.getTaxes();
            List<Tax> other$taxes = other.getTaxes();
            return !(this$taxes == null ? other$taxes != null : !((Object)this$taxes).equals(other$taxes));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ShippingCost;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amountSubtotal = this.getAmountSubtotal();
            result = result * 59 + ($amountSubtotal == null ? 43 : ((Object)$amountSubtotal).hashCode());
            Long $amountTax = this.getAmountTax();
            result = result * 59 + ($amountTax == null ? 43 : ((Object)$amountTax).hashCode());
            Long $amountTotal = this.getAmountTotal();
            result = result * 59 + ($amountTotal == null ? 43 : ((Object)$amountTotal).hashCode());
            String $shippingRate = this.getShippingRate();
            result = result * 59 + ($shippingRate == null ? 43 : $shippingRate.hashCode());
            List<Tax> $taxes = this.getTaxes();
            result = result * 59 + ($taxes == null ? 43 : ((Object)$taxes).hashCode());
            return result;
        }

        public static class Tax
        extends StripeObject {
            @SerializedName(value="amount")
            Long amount;
            @SerializedName(value="rate")
            TaxRate rate;
            @SerializedName(value="taxability_reason")
            String taxabilityReason;
            @SerializedName(value="taxable_amount")
            Long taxableAmount;

            @Generated
            public Long getAmount() {
                return this.amount;
            }

            @Generated
            public TaxRate getRate() {
                return this.rate;
            }

            @Generated
            public String getTaxabilityReason() {
                return this.taxabilityReason;
            }

            @Generated
            public Long getTaxableAmount() {
                return this.taxableAmount;
            }

            @Generated
            public void setAmount(Long amount) {
                this.amount = amount;
            }

            @Generated
            public void setRate(TaxRate rate) {
                this.rate = rate;
            }

            @Generated
            public void setTaxabilityReason(String taxabilityReason) {
                this.taxabilityReason = taxabilityReason;
            }

            @Generated
            public void setTaxableAmount(Long taxableAmount) {
                this.taxableAmount = taxableAmount;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Tax)) {
                    return false;
                }
                Tax other = (Tax)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$amount = this.getAmount();
                Long other$amount = other.getAmount();
                if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                    return false;
                }
                Long this$taxableAmount = this.getTaxableAmount();
                Long other$taxableAmount = other.getTaxableAmount();
                if (this$taxableAmount == null ? other$taxableAmount != null : !((Object)this$taxableAmount).equals(other$taxableAmount)) {
                    return false;
                }
                TaxRate this$rate = this.getRate();
                TaxRate other$rate = other.getRate();
                if (this$rate == null ? other$rate != null : !((Object)this$rate).equals(other$rate)) {
                    return false;
                }
                String this$taxabilityReason = this.getTaxabilityReason();
                String other$taxabilityReason = other.getTaxabilityReason();
                return !(this$taxabilityReason == null ? other$taxabilityReason != null : !this$taxabilityReason.equals(other$taxabilityReason));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Tax;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $amount = this.getAmount();
                result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                Long $taxableAmount = this.getTaxableAmount();
                result = result * 59 + ($taxableAmount == null ? 43 : ((Object)$taxableAmount).hashCode());
                TaxRate $rate = this.getRate();
                result = result * 59 + ($rate == null ? 43 : ((Object)$rate).hashCode());
                String $taxabilityReason = this.getTaxabilityReason();
                result = result * 59 + ($taxabilityReason == null ? 43 : $taxabilityReason.hashCode());
                return result;
            }
        }
    }

    public static class StatusTransitions
    extends StripeObject {
        @SerializedName(value="finalized_at")
        Long finalizedAt;
        @SerializedName(value="marked_uncollectible_at")
        Long markedUncollectibleAt;
        @SerializedName(value="paid_at")
        Long paidAt;
        @SerializedName(value="voided_at")
        Long voidedAt;

        @Generated
        public Long getFinalizedAt() {
            return this.finalizedAt;
        }

        @Generated
        public Long getMarkedUncollectibleAt() {
            return this.markedUncollectibleAt;
        }

        @Generated
        public Long getPaidAt() {
            return this.paidAt;
        }

        @Generated
        public Long getVoidedAt() {
            return this.voidedAt;
        }

        @Generated
        public void setFinalizedAt(Long finalizedAt) {
            this.finalizedAt = finalizedAt;
        }

        @Generated
        public void setMarkedUncollectibleAt(Long markedUncollectibleAt) {
            this.markedUncollectibleAt = markedUncollectibleAt;
        }

        @Generated
        public void setPaidAt(Long paidAt) {
            this.paidAt = paidAt;
        }

        @Generated
        public void setVoidedAt(Long voidedAt) {
            this.voidedAt = voidedAt;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatusTransitions)) {
                return false;
            }
            StatusTransitions other = (StatusTransitions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$finalizedAt = this.getFinalizedAt();
            Long other$finalizedAt = other.getFinalizedAt();
            if (this$finalizedAt == null ? other$finalizedAt != null : !((Object)this$finalizedAt).equals(other$finalizedAt)) {
                return false;
            }
            Long this$markedUncollectibleAt = this.getMarkedUncollectibleAt();
            Long other$markedUncollectibleAt = other.getMarkedUncollectibleAt();
            if (this$markedUncollectibleAt == null ? other$markedUncollectibleAt != null : !((Object)this$markedUncollectibleAt).equals(other$markedUncollectibleAt)) {
                return false;
            }
            Long this$paidAt = this.getPaidAt();
            Long other$paidAt = other.getPaidAt();
            if (this$paidAt == null ? other$paidAt != null : !((Object)this$paidAt).equals(other$paidAt)) {
                return false;
            }
            Long this$voidedAt = this.getVoidedAt();
            Long other$voidedAt = other.getVoidedAt();
            return !(this$voidedAt == null ? other$voidedAt != null : !((Object)this$voidedAt).equals(other$voidedAt));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof StatusTransitions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $finalizedAt = this.getFinalizedAt();
            result = result * 59 + ($finalizedAt == null ? 43 : ((Object)$finalizedAt).hashCode());
            Long $markedUncollectibleAt = this.getMarkedUncollectibleAt();
            result = result * 59 + ($markedUncollectibleAt == null ? 43 : ((Object)$markedUncollectibleAt).hashCode());
            Long $paidAt = this.getPaidAt();
            result = result * 59 + ($paidAt == null ? 43 : ((Object)$paidAt).hashCode());
            Long $voidedAt = this.getVoidedAt();
            result = result * 59 + ($voidedAt == null ? 43 : ((Object)$voidedAt).hashCode());
            return result;
        }
    }

    public static class SubscriptionDetails
    extends StripeObject {
        @SerializedName(value="metadata")
        Map<String, String> metadata;

        @Generated
        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        @Generated
        public void setMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubscriptionDetails)) {
                return false;
            }
            SubscriptionDetails other = (SubscriptionDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, String> this$metadata = this.getMetadata();
            Map<String, String> other$metadata = other.getMetadata();
            return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SubscriptionDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, String> $metadata = this.getMetadata();
            result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
            return result;
        }
    }

    public static class ThresholdReason
    extends StripeObject {
        @SerializedName(value="amount_gte")
        Long amountGte;
        @SerializedName(value="item_reasons")
        List<ItemReason> itemReasons;

        @Generated
        public Long getAmountGte() {
            return this.amountGte;
        }

        @Generated
        public List<ItemReason> getItemReasons() {
            return this.itemReasons;
        }

        @Generated
        public void setAmountGte(Long amountGte) {
            this.amountGte = amountGte;
        }

        @Generated
        public void setItemReasons(List<ItemReason> itemReasons) {
            this.itemReasons = itemReasons;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ThresholdReason)) {
                return false;
            }
            ThresholdReason other = (ThresholdReason)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amountGte = this.getAmountGte();
            Long other$amountGte = other.getAmountGte();
            if (this$amountGte == null ? other$amountGte != null : !((Object)this$amountGte).equals(other$amountGte)) {
                return false;
            }
            List<ItemReason> this$itemReasons = this.getItemReasons();
            List<ItemReason> other$itemReasons = other.getItemReasons();
            return !(this$itemReasons == null ? other$itemReasons != null : !((Object)this$itemReasons).equals(other$itemReasons));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ThresholdReason;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amountGte = this.getAmountGte();
            result = result * 59 + ($amountGte == null ? 43 : ((Object)$amountGte).hashCode());
            List<ItemReason> $itemReasons = this.getItemReasons();
            result = result * 59 + ($itemReasons == null ? 43 : ((Object)$itemReasons).hashCode());
            return result;
        }

        public static class ItemReason
        extends StripeObject {
            @SerializedName(value="line_item_ids")
            List<String> lineItemIds;
            @SerializedName(value="usage_gte")
            Long usageGte;

            @Generated
            public List<String> getLineItemIds() {
                return this.lineItemIds;
            }

            @Generated
            public Long getUsageGte() {
                return this.usageGte;
            }

            @Generated
            public void setLineItemIds(List<String> lineItemIds) {
                this.lineItemIds = lineItemIds;
            }

            @Generated
            public void setUsageGte(Long usageGte) {
                this.usageGte = usageGte;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ItemReason)) {
                    return false;
                }
                ItemReason other = (ItemReason)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$usageGte = this.getUsageGte();
                Long other$usageGte = other.getUsageGte();
                if (this$usageGte == null ? other$usageGte != null : !((Object)this$usageGte).equals(other$usageGte)) {
                    return false;
                }
                List<String> this$lineItemIds = this.getLineItemIds();
                List<String> other$lineItemIds = other.getLineItemIds();
                return !(this$lineItemIds == null ? other$lineItemIds != null : !((Object)this$lineItemIds).equals(other$lineItemIds));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ItemReason;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $usageGte = this.getUsageGte();
                result = result * 59 + ($usageGte == null ? 43 : ((Object)$usageGte).hashCode());
                List<String> $lineItemIds = this.getLineItemIds();
                result = result * 59 + ($lineItemIds == null ? 43 : ((Object)$lineItemIds).hashCode());
                return result;
            }
        }
    }

    public static class TransferData
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="destination")
        ExpandableField<Account> destination;

        public String getDestination() {
            return this.destination != null ? this.destination.getId() : null;
        }

        public void setDestination(String id) {
            this.destination = ApiResource.setExpandableFieldId(id, this.destination);
        }

        public Account getDestinationObject() {
            return this.destination != null ? this.destination.getExpanded() : null;
        }

        public void setDestinationObject(Account expandableObject) {
            this.destination = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransferData)) {
                return false;
            }
            TransferData other = (TransferData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            String this$destination = this.getDestination();
            String other$destination = other.getDestination();
            return !(this$destination == null ? other$destination != null : !this$destination.equals(other$destination));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TransferData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            String $destination = this.getDestination();
            result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
            return result;
        }
    }

    public static class TotalTaxAmount
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="inclusive")
        Boolean inclusive;
        @SerializedName(value="tax_rate")
        ExpandableField<TaxRate> taxRate;
        @SerializedName(value="taxability_reason")
        String taxabilityReason;
        @SerializedName(value="taxable_amount")
        Long taxableAmount;

        public String getTaxRate() {
            return this.taxRate != null ? this.taxRate.getId() : null;
        }

        public void setTaxRate(String id) {
            this.taxRate = ApiResource.setExpandableFieldId(id, this.taxRate);
        }

        public TaxRate getTaxRateObject() {
            return this.taxRate != null ? this.taxRate.getExpanded() : null;
        }

        public void setTaxRateObject(TaxRate expandableObject) {
            this.taxRate = new ExpandableField<TaxRate>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public Boolean getInclusive() {
            return this.inclusive;
        }

        @Generated
        public String getTaxabilityReason() {
            return this.taxabilityReason;
        }

        @Generated
        public Long getTaxableAmount() {
            return this.taxableAmount;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public void setInclusive(Boolean inclusive) {
            this.inclusive = inclusive;
        }

        @Generated
        public void setTaxabilityReason(String taxabilityReason) {
            this.taxabilityReason = taxabilityReason;
        }

        @Generated
        public void setTaxableAmount(Long taxableAmount) {
            this.taxableAmount = taxableAmount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TotalTaxAmount)) {
                return false;
            }
            TotalTaxAmount other = (TotalTaxAmount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            Boolean this$inclusive = this.getInclusive();
            Boolean other$inclusive = other.getInclusive();
            if (this$inclusive == null ? other$inclusive != null : !((Object)this$inclusive).equals(other$inclusive)) {
                return false;
            }
            Long this$taxableAmount = this.getTaxableAmount();
            Long other$taxableAmount = other.getTaxableAmount();
            if (this$taxableAmount == null ? other$taxableAmount != null : !((Object)this$taxableAmount).equals(other$taxableAmount)) {
                return false;
            }
            String this$taxRate = this.getTaxRate();
            String other$taxRate = other.getTaxRate();
            if (this$taxRate == null ? other$taxRate != null : !this$taxRate.equals(other$taxRate)) {
                return false;
            }
            String this$taxabilityReason = this.getTaxabilityReason();
            String other$taxabilityReason = other.getTaxabilityReason();
            return !(this$taxabilityReason == null ? other$taxabilityReason != null : !this$taxabilityReason.equals(other$taxabilityReason));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TotalTaxAmount;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            Boolean $inclusive = this.getInclusive();
            result = result * 59 + ($inclusive == null ? 43 : ((Object)$inclusive).hashCode());
            Long $taxableAmount = this.getTaxableAmount();
            result = result * 59 + ($taxableAmount == null ? 43 : ((Object)$taxableAmount).hashCode());
            String $taxRate = this.getTaxRate();
            result = result * 59 + ($taxRate == null ? 43 : $taxRate.hashCode());
            String $taxabilityReason = this.getTaxabilityReason();
            result = result * 59 + ($taxabilityReason == null ? 43 : $taxabilityReason.hashCode());
            return result;
        }
    }

    public static class TotalDiscountAmount
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="discount")
        ExpandableField<Discount> discount;

        public String getDiscount() {
            return this.discount != null ? this.discount.getId() : null;
        }

        public void setDiscount(String id) {
            this.discount = ApiResource.setExpandableFieldId(id, this.discount);
        }

        public Discount getDiscountObject() {
            return this.discount != null ? this.discount.getExpanded() : null;
        }

        public void setDiscountObject(Discount expandableObject) {
            this.discount = new ExpandableField<Discount>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TotalDiscountAmount)) {
                return false;
            }
            TotalDiscountAmount other = (TotalDiscountAmount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            String this$discount = this.getDiscount();
            String other$discount = other.getDiscount();
            return !(this$discount == null ? other$discount != null : !this$discount.equals(other$discount));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TotalDiscountAmount;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            String $discount = this.getDiscount();
            result = result * 59 + ($discount == null ? 43 : $discount.hashCode());
            return result;
        }
    }

    public static class CustomerTaxId
    extends StripeObject {
        @SerializedName(value="type")
        String type;
        @SerializedName(value="value")
        String value;

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setValue(String value) {
            this.value = value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomerTaxId)) {
                return false;
            }
            CustomerTaxId other = (CustomerTaxId)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CustomerTaxId;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }
    }

    public static class CustomField
    extends StripeObject {
        @SerializedName(value="name")
        String name;
        @SerializedName(value="value")
        String value;

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setValue(String value) {
            this.value = value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomField)) {
                return false;
            }
            CustomField other = (CustomField)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CustomField;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }
    }
}

