/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Account;
import com.stripe.model.Application;
import com.stripe.model.Customer;
import com.stripe.model.Discount;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.Invoice;
import com.stripe.model.LineItemCollection;
import com.stripe.model.MetadataStore;
import com.stripe.model.QuoteCollection;
import com.stripe.model.StripeObject;
import com.stripe.model.Subscription;
import com.stripe.model.SubscriptionSchedule;
import com.stripe.model.TaxRate;
import com.stripe.model.testhelpers.TestClock;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.QuoteAcceptParams;
import com.stripe.param.QuoteCancelParams;
import com.stripe.param.QuoteCreateParams;
import com.stripe.param.QuoteFinalizeQuoteParams;
import com.stripe.param.QuoteListComputedUpfrontLineItemsParams;
import com.stripe.param.QuoteListLineItemsParams;
import com.stripe.param.QuoteListParams;
import com.stripe.param.QuotePdfParams;
import com.stripe.param.QuoteRetrieveParams;
import com.stripe.param.QuoteUpdateParams;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class Quote
extends ApiResource
implements HasId,
MetadataStore<Quote> {
    @SerializedName(value="amount_subtotal")
    Long amountSubtotal;
    @SerializedName(value="amount_total")
    Long amountTotal;
    @SerializedName(value="application")
    ExpandableField<Application> application;
    @SerializedName(value="application_fee_amount")
    Long applicationFeeAmount;
    @SerializedName(value="application_fee_percent")
    BigDecimal applicationFeePercent;
    @SerializedName(value="automatic_tax")
    AutomaticTax automaticTax;
    @SerializedName(value="collection_method")
    String collectionMethod;
    @SerializedName(value="computed")
    Computed computed;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="default_tax_rates")
    List<ExpandableField<TaxRate>> defaultTaxRates;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="discounts")
    List<ExpandableField<Discount>> discounts;
    @SerializedName(value="expires_at")
    Long expiresAt;
    @SerializedName(value="footer")
    String footer;
    @SerializedName(value="from_quote")
    FromQuote fromQuote;
    @SerializedName(value="header")
    String header;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="invoice")
    ExpandableField<Invoice> invoice;
    @SerializedName(value="invoice_settings")
    InvoiceSettings invoiceSettings;
    @SerializedName(value="line_items")
    LineItemCollection lineItems;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="number")
    String number;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="on_behalf_of")
    ExpandableField<Account> onBehalfOf;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="status_transitions")
    StatusTransitions statusTransitions;
    @SerializedName(value="subscription")
    ExpandableField<Subscription> subscription;
    @SerializedName(value="subscription_data")
    SubscriptionData subscriptionData;
    @SerializedName(value="subscription_schedule")
    ExpandableField<SubscriptionSchedule> subscriptionSchedule;
    @SerializedName(value="test_clock")
    ExpandableField<TestClock> testClock;
    @SerializedName(value="total_details")
    TotalDetails totalDetails;
    @SerializedName(value="transfer_data")
    TransferData transferData;

    public String getApplication() {
        return this.application != null ? this.application.getId() : null;
    }

    public void setApplication(String id) {
        this.application = ApiResource.setExpandableFieldId(id, this.application);
    }

    public Application getApplicationObject() {
        return this.application != null ? this.application.getExpanded() : null;
    }

    public void setApplicationObject(Application expandableObject) {
        this.application = new ExpandableField<Application>(expandableObject.getId(), expandableObject);
    }

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public String getInvoice() {
        return this.invoice != null ? this.invoice.getId() : null;
    }

    public void setInvoice(String id) {
        this.invoice = ApiResource.setExpandableFieldId(id, this.invoice);
    }

    public Invoice getInvoiceObject() {
        return this.invoice != null ? this.invoice.getExpanded() : null;
    }

    public void setInvoiceObject(Invoice expandableObject) {
        this.invoice = new ExpandableField<Invoice>(expandableObject.getId(), expandableObject);
    }

    public String getOnBehalfOf() {
        return this.onBehalfOf != null ? this.onBehalfOf.getId() : null;
    }

    public void setOnBehalfOf(String id) {
        this.onBehalfOf = ApiResource.setExpandableFieldId(id, this.onBehalfOf);
    }

    public Account getOnBehalfOfObject() {
        return this.onBehalfOf != null ? this.onBehalfOf.getExpanded() : null;
    }

    public void setOnBehalfOfObject(Account expandableObject) {
        this.onBehalfOf = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
    }

    public String getSubscription() {
        return this.subscription != null ? this.subscription.getId() : null;
    }

    public void setSubscription(String id) {
        this.subscription = ApiResource.setExpandableFieldId(id, this.subscription);
    }

    public Subscription getSubscriptionObject() {
        return this.subscription != null ? this.subscription.getExpanded() : null;
    }

    public void setSubscriptionObject(Subscription expandableObject) {
        this.subscription = new ExpandableField<Subscription>(expandableObject.getId(), expandableObject);
    }

    public String getSubscriptionSchedule() {
        return this.subscriptionSchedule != null ? this.subscriptionSchedule.getId() : null;
    }

    public void setSubscriptionSchedule(String id) {
        this.subscriptionSchedule = ApiResource.setExpandableFieldId(id, this.subscriptionSchedule);
    }

    public SubscriptionSchedule getSubscriptionScheduleObject() {
        return this.subscriptionSchedule != null ? this.subscriptionSchedule.getExpanded() : null;
    }

    public void setSubscriptionScheduleObject(SubscriptionSchedule expandableObject) {
        this.subscriptionSchedule = new ExpandableField<SubscriptionSchedule>(expandableObject.getId(), expandableObject);
    }

    public String getTestClock() {
        return this.testClock != null ? this.testClock.getId() : null;
    }

    public void setTestClock(String id) {
        this.testClock = ApiResource.setExpandableFieldId(id, this.testClock);
    }

    public TestClock getTestClockObject() {
        return this.testClock != null ? this.testClock.getExpanded() : null;
    }

    public void setTestClockObject(TestClock expandableObject) {
        this.testClock = new ExpandableField<TestClock>(expandableObject.getId(), expandableObject);
    }

    public List<String> getDefaultTaxRates() {
        return this.defaultTaxRates != null ? this.defaultTaxRates.stream().map(x -> x.getId()).collect(Collectors.toList()) : null;
    }

    public void setDefaultTaxRates(List<String> ids) {
        if (ids == null) {
            this.defaultTaxRates = null;
            return;
        }
        if (this.defaultTaxRates != null && this.defaultTaxRates.stream().map(x -> x.getId()).collect(Collectors.toList()).equals(ids)) {
            return;
        }
        this.defaultTaxRates = ids != null ? ids.stream().map(id -> new ExpandableField<Object>((String)id, null)).collect(Collectors.toList()) : null;
    }

    public List<TaxRate> getDefaultTaxRateObjects() {
        return this.defaultTaxRates != null ? this.defaultTaxRates.stream().map(x -> (TaxRate)x.getExpanded()).collect(Collectors.toList()) : null;
    }

    public void setDefaultTaxRateObjects(List<TaxRate> objs) {
        this.defaultTaxRates = objs != null ? objs.stream().map(x -> new ExpandableField<TaxRate>(x.getId(), (TaxRate)x)).collect(Collectors.toList()) : null;
    }

    public List<String> getDiscounts() {
        return this.discounts != null ? this.discounts.stream().map(x -> x.getId()).collect(Collectors.toList()) : null;
    }

    public void setDiscounts(List<String> ids) {
        if (ids == null) {
            this.discounts = null;
            return;
        }
        if (this.discounts != null && this.discounts.stream().map(x -> x.getId()).collect(Collectors.toList()).equals(ids)) {
            return;
        }
        this.discounts = ids != null ? ids.stream().map(id -> new ExpandableField<Object>((String)id, null)).collect(Collectors.toList()) : null;
    }

    public List<Discount> getDiscountObjects() {
        return this.discounts != null ? this.discounts.stream().map(x -> (Discount)x.getExpanded()).collect(Collectors.toList()) : null;
    }

    public void setDiscountObjects(List<Discount> objs) {
        this.discounts = objs != null ? objs.stream().map(x -> new ExpandableField<Discount>(x.getId(), (Discount)x)).collect(Collectors.toList()) : null;
    }

    public Quote accept() throws StripeException {
        return this.accept((Map<String, Object>)null, (RequestOptions)null);
    }

    public Quote accept(RequestOptions options) throws StripeException {
        return this.accept((Map<String, Object>)null, options);
    }

    public Quote accept(Map<String, Object> params) throws StripeException {
        return this.accept(params, (RequestOptions)null);
    }

    public Quote accept(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/accept", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Quote.class, options);
    }

    public Quote accept(QuoteAcceptParams params) throws StripeException {
        return this.accept(params, (RequestOptions)null);
    }

    public Quote accept(QuoteAcceptParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/accept", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Quote.class, options);
    }

    public Quote cancel() throws StripeException {
        return this.cancel((Map<String, Object>)null, (RequestOptions)null);
    }

    public Quote cancel(RequestOptions options) throws StripeException {
        return this.cancel((Map<String, Object>)null, options);
    }

    public Quote cancel(Map<String, Object> params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public Quote cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/cancel", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Quote.class, options);
    }

    public Quote cancel(QuoteCancelParams params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public Quote cancel(QuoteCancelParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/cancel", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Quote.class, options);
    }

    public static Quote create(Map<String, Object> params) throws StripeException {
        return Quote.create(params, (RequestOptions)null);
    }

    public static Quote create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/quotes");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Quote.class, options);
    }

    public static Quote create(QuoteCreateParams params) throws StripeException {
        return Quote.create(params, (RequestOptions)null);
    }

    public static Quote create(QuoteCreateParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/quotes");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Quote.class, options);
    }

    public Quote finalizeQuote() throws StripeException {
        return this.finalizeQuote((Map<String, Object>)null, (RequestOptions)null);
    }

    public Quote finalizeQuote(RequestOptions options) throws StripeException {
        return this.finalizeQuote((Map<String, Object>)null, options);
    }

    public Quote finalizeQuote(Map<String, Object> params) throws StripeException {
        return this.finalizeQuote(params, (RequestOptions)null);
    }

    public Quote finalizeQuote(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/finalize", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Quote.class, options);
    }

    public Quote finalizeQuote(QuoteFinalizeQuoteParams params) throws StripeException {
        return this.finalizeQuote(params, (RequestOptions)null);
    }

    public Quote finalizeQuote(QuoteFinalizeQuoteParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/finalize", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Quote.class, options);
    }

    public static QuoteCollection list(Map<String, Object> params) throws StripeException {
        return Quote.list(params, (RequestOptions)null);
    }

    public static QuoteCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/quotes");
        return ApiResource.requestCollection(url, params, QuoteCollection.class, options);
    }

    public static QuoteCollection list(QuoteListParams params) throws StripeException {
        return Quote.list(params, (RequestOptions)null);
    }

    public static QuoteCollection list(QuoteListParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/quotes");
        return ApiResource.requestCollection(url, params, QuoteCollection.class, options);
    }

    public LineItemCollection listComputedUpfrontLineItems() throws StripeException {
        return this.listComputedUpfrontLineItems((Map<String, Object>)null, (RequestOptions)null);
    }

    public LineItemCollection listComputedUpfrontLineItems(Map<String, Object> params) throws StripeException {
        return this.listComputedUpfrontLineItems(params, (RequestOptions)null);
    }

    public LineItemCollection listComputedUpfrontLineItems(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/computed_upfront_line_items", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.requestCollection(url, params, LineItemCollection.class, options);
    }

    public LineItemCollection listComputedUpfrontLineItems(QuoteListComputedUpfrontLineItemsParams params) throws StripeException {
        return this.listComputedUpfrontLineItems(params, (RequestOptions)null);
    }

    public LineItemCollection listComputedUpfrontLineItems(QuoteListComputedUpfrontLineItemsParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/computed_upfront_line_items", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.requestCollection(url, params, LineItemCollection.class, options);
    }

    public LineItemCollection listLineItems() throws StripeException {
        return this.listLineItems((Map<String, Object>)null, (RequestOptions)null);
    }

    public LineItemCollection listLineItems(Map<String, Object> params) throws StripeException {
        return this.listLineItems(params, (RequestOptions)null);
    }

    public LineItemCollection listLineItems(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/line_items", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.requestCollection(url, params, LineItemCollection.class, options);
    }

    public LineItemCollection listLineItems(QuoteListLineItemsParams params) throws StripeException {
        return this.listLineItems(params, (RequestOptions)null);
    }

    public LineItemCollection listLineItems(QuoteListLineItemsParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s/line_items", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.requestCollection(url, params, LineItemCollection.class, options);
    }

    public InputStream pdf() throws StripeException {
        return this.pdf((Map<String, Object>)null, (RequestOptions)null);
    }

    public InputStream pdf(Map<String, Object> params) throws StripeException {
        return this.pdf(params, (RequestOptions)null);
    }

    public InputStream pdf(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getUploadBase(), options, String.format("/v1/quotes/%s/pdf", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.requestStream(ApiResource.RequestMethod.GET, url, params, options);
    }

    public InputStream pdf(QuotePdfParams params) throws StripeException {
        return this.pdf(params, (RequestOptions)null);
    }

    public InputStream pdf(QuotePdfParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getUploadBase(), options, String.format("/v1/quotes/%s/pdf", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.requestStream(ApiResource.RequestMethod.GET, url, params, options);
    }

    public static Quote retrieve(String quote) throws StripeException {
        return Quote.retrieve(quote, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Quote retrieve(String quote, RequestOptions options) throws StripeException {
        return Quote.retrieve(quote, (Map<String, Object>)null, options);
    }

    public static Quote retrieve(String quote, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s", ApiResource.urlEncodeId(quote)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Quote.class, options);
    }

    public static Quote retrieve(String quote, QuoteRetrieveParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s", ApiResource.urlEncodeId(quote)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Quote.class, options);
    }

    public Quote update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Quote update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Quote.class, options);
    }

    public Quote update(QuoteUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Quote update(QuoteUpdateParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/quotes/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Quote.class, options);
    }

    @Generated
    public Long getAmountSubtotal() {
        return this.amountSubtotal;
    }

    @Generated
    public Long getAmountTotal() {
        return this.amountTotal;
    }

    @Generated
    public Long getApplicationFeeAmount() {
        return this.applicationFeeAmount;
    }

    @Generated
    public BigDecimal getApplicationFeePercent() {
        return this.applicationFeePercent;
    }

    @Generated
    public AutomaticTax getAutomaticTax() {
        return this.automaticTax;
    }

    @Generated
    public String getCollectionMethod() {
        return this.collectionMethod;
    }

    @Generated
    public Computed getComputed() {
        return this.computed;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Long getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public String getFooter() {
        return this.footer;
    }

    @Generated
    public FromQuote getFromQuote() {
        return this.fromQuote;
    }

    @Generated
    public String getHeader() {
        return this.header;
    }

    @Generated
    public InvoiceSettings getInvoiceSettings() {
        return this.invoiceSettings;
    }

    @Generated
    public LineItemCollection getLineItems() {
        return this.lineItems;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getNumber() {
        return this.number;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public StatusTransitions getStatusTransitions() {
        return this.statusTransitions;
    }

    @Generated
    public SubscriptionData getSubscriptionData() {
        return this.subscriptionData;
    }

    @Generated
    public TotalDetails getTotalDetails() {
        return this.totalDetails;
    }

    @Generated
    public TransferData getTransferData() {
        return this.transferData;
    }

    @Generated
    public void setAmountSubtotal(Long amountSubtotal) {
        this.amountSubtotal = amountSubtotal;
    }

    @Generated
    public void setAmountTotal(Long amountTotal) {
        this.amountTotal = amountTotal;
    }

    @Generated
    public void setApplicationFeeAmount(Long applicationFeeAmount) {
        this.applicationFeeAmount = applicationFeeAmount;
    }

    @Generated
    public void setApplicationFeePercent(BigDecimal applicationFeePercent) {
        this.applicationFeePercent = applicationFeePercent;
    }

    @Generated
    public void setAutomaticTax(AutomaticTax automaticTax) {
        this.automaticTax = automaticTax;
    }

    @Generated
    public void setCollectionMethod(String collectionMethod) {
        this.collectionMethod = collectionMethod;
    }

    @Generated
    public void setComputed(Computed computed) {
        this.computed = computed;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setExpiresAt(Long expiresAt) {
        this.expiresAt = expiresAt;
    }

    @Generated
    public void setFooter(String footer) {
        this.footer = footer;
    }

    @Generated
    public void setFromQuote(FromQuote fromQuote) {
        this.fromQuote = fromQuote;
    }

    @Generated
    public void setHeader(String header) {
        this.header = header;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setInvoiceSettings(InvoiceSettings invoiceSettings) {
        this.invoiceSettings = invoiceSettings;
    }

    @Generated
    public void setLineItems(LineItemCollection lineItems) {
        this.lineItems = lineItems;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setNumber(String number) {
        this.number = number;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setStatusTransitions(StatusTransitions statusTransitions) {
        this.statusTransitions = statusTransitions;
    }

    @Generated
    public void setSubscriptionData(SubscriptionData subscriptionData) {
        this.subscriptionData = subscriptionData;
    }

    @Generated
    public void setTotalDetails(TotalDetails totalDetails) {
        this.totalDetails = totalDetails;
    }

    @Generated
    public void setTransferData(TransferData transferData) {
        this.transferData = transferData;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Quote)) {
            return false;
        }
        Quote other = (Quote)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amountSubtotal = this.getAmountSubtotal();
        Long other$amountSubtotal = other.getAmountSubtotal();
        if (this$amountSubtotal == null ? other$amountSubtotal != null : !((Object)this$amountSubtotal).equals(other$amountSubtotal)) {
            return false;
        }
        Long this$amountTotal = this.getAmountTotal();
        Long other$amountTotal = other.getAmountTotal();
        if (this$amountTotal == null ? other$amountTotal != null : !((Object)this$amountTotal).equals(other$amountTotal)) {
            return false;
        }
        Long this$applicationFeeAmount = this.getApplicationFeeAmount();
        Long other$applicationFeeAmount = other.getApplicationFeeAmount();
        if (this$applicationFeeAmount == null ? other$applicationFeeAmount != null : !((Object)this$applicationFeeAmount).equals(other$applicationFeeAmount)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$expiresAt = this.getExpiresAt();
        Long other$expiresAt = other.getExpiresAt();
        if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        BigDecimal this$applicationFeePercent = this.getApplicationFeePercent();
        BigDecimal other$applicationFeePercent = other.getApplicationFeePercent();
        if (this$applicationFeePercent == null ? other$applicationFeePercent != null : !((Object)this$applicationFeePercent).equals(other$applicationFeePercent)) {
            return false;
        }
        AutomaticTax this$automaticTax = this.getAutomaticTax();
        AutomaticTax other$automaticTax = other.getAutomaticTax();
        if (this$automaticTax == null ? other$automaticTax != null : !((Object)this$automaticTax).equals(other$automaticTax)) {
            return false;
        }
        String this$collectionMethod = this.getCollectionMethod();
        String other$collectionMethod = other.getCollectionMethod();
        if (this$collectionMethod == null ? other$collectionMethod != null : !this$collectionMethod.equals(other$collectionMethod)) {
            return false;
        }
        Computed this$computed = this.getComputed();
        Computed other$computed = other.getComputed();
        if (this$computed == null ? other$computed != null : !((Object)this$computed).equals(other$computed)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        List<String> this$defaultTaxRates = this.getDefaultTaxRates();
        List<String> other$defaultTaxRates = other.getDefaultTaxRates();
        if (this$defaultTaxRates == null ? other$defaultTaxRates != null : !((Object)this$defaultTaxRates).equals(other$defaultTaxRates)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<String> this$discounts = this.getDiscounts();
        List<String> other$discounts = other.getDiscounts();
        if (this$discounts == null ? other$discounts != null : !((Object)this$discounts).equals(other$discounts)) {
            return false;
        }
        String this$footer = this.getFooter();
        String other$footer = other.getFooter();
        if (this$footer == null ? other$footer != null : !this$footer.equals(other$footer)) {
            return false;
        }
        FromQuote this$fromQuote = this.getFromQuote();
        FromQuote other$fromQuote = other.getFromQuote();
        if (this$fromQuote == null ? other$fromQuote != null : !((Object)this$fromQuote).equals(other$fromQuote)) {
            return false;
        }
        String this$header = this.getHeader();
        String other$header = other.getHeader();
        if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$invoice = this.getInvoice();
        String other$invoice = other.getInvoice();
        if (this$invoice == null ? other$invoice != null : !this$invoice.equals(other$invoice)) {
            return false;
        }
        InvoiceSettings this$invoiceSettings = this.getInvoiceSettings();
        InvoiceSettings other$invoiceSettings = other.getInvoiceSettings();
        if (this$invoiceSettings == null ? other$invoiceSettings != null : !((Object)this$invoiceSettings).equals(other$invoiceSettings)) {
            return false;
        }
        LineItemCollection this$lineItems = this.getLineItems();
        LineItemCollection other$lineItems = other.getLineItems();
        if (this$lineItems == null ? other$lineItems != null : !((Object)this$lineItems).equals(other$lineItems)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$number = this.getNumber();
        String other$number = other.getNumber();
        if (this$number == null ? other$number != null : !this$number.equals(other$number)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$onBehalfOf = this.getOnBehalfOf();
        String other$onBehalfOf = other.getOnBehalfOf();
        if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        StatusTransitions this$statusTransitions = this.getStatusTransitions();
        StatusTransitions other$statusTransitions = other.getStatusTransitions();
        if (this$statusTransitions == null ? other$statusTransitions != null : !((Object)this$statusTransitions).equals(other$statusTransitions)) {
            return false;
        }
        String this$subscription = this.getSubscription();
        String other$subscription = other.getSubscription();
        if (this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription)) {
            return false;
        }
        SubscriptionData this$subscriptionData = this.getSubscriptionData();
        SubscriptionData other$subscriptionData = other.getSubscriptionData();
        if (this$subscriptionData == null ? other$subscriptionData != null : !((Object)this$subscriptionData).equals(other$subscriptionData)) {
            return false;
        }
        String this$subscriptionSchedule = this.getSubscriptionSchedule();
        String other$subscriptionSchedule = other.getSubscriptionSchedule();
        if (this$subscriptionSchedule == null ? other$subscriptionSchedule != null : !this$subscriptionSchedule.equals(other$subscriptionSchedule)) {
            return false;
        }
        String this$testClock = this.getTestClock();
        String other$testClock = other.getTestClock();
        if (this$testClock == null ? other$testClock != null : !this$testClock.equals(other$testClock)) {
            return false;
        }
        TotalDetails this$totalDetails = this.getTotalDetails();
        TotalDetails other$totalDetails = other.getTotalDetails();
        if (this$totalDetails == null ? other$totalDetails != null : !((Object)this$totalDetails).equals(other$totalDetails)) {
            return false;
        }
        TransferData this$transferData = this.getTransferData();
        TransferData other$transferData = other.getTransferData();
        return !(this$transferData == null ? other$transferData != null : !((Object)this$transferData).equals(other$transferData));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Quote;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amountSubtotal = this.getAmountSubtotal();
        result = result * 59 + ($amountSubtotal == null ? 43 : ((Object)$amountSubtotal).hashCode());
        Long $amountTotal = this.getAmountTotal();
        result = result * 59 + ($amountTotal == null ? 43 : ((Object)$amountTotal).hashCode());
        Long $applicationFeeAmount = this.getApplicationFeeAmount();
        result = result * 59 + ($applicationFeeAmount == null ? 43 : ((Object)$applicationFeeAmount).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $expiresAt = this.getExpiresAt();
        result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        BigDecimal $applicationFeePercent = this.getApplicationFeePercent();
        result = result * 59 + ($applicationFeePercent == null ? 43 : ((Object)$applicationFeePercent).hashCode());
        AutomaticTax $automaticTax = this.getAutomaticTax();
        result = result * 59 + ($automaticTax == null ? 43 : ((Object)$automaticTax).hashCode());
        String $collectionMethod = this.getCollectionMethod();
        result = result * 59 + ($collectionMethod == null ? 43 : $collectionMethod.hashCode());
        Computed $computed = this.getComputed();
        result = result * 59 + ($computed == null ? 43 : ((Object)$computed).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        List<String> $defaultTaxRates = this.getDefaultTaxRates();
        result = result * 59 + ($defaultTaxRates == null ? 43 : ((Object)$defaultTaxRates).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<String> $discounts = this.getDiscounts();
        result = result * 59 + ($discounts == null ? 43 : ((Object)$discounts).hashCode());
        String $footer = this.getFooter();
        result = result * 59 + ($footer == null ? 43 : $footer.hashCode());
        FromQuote $fromQuote = this.getFromQuote();
        result = result * 59 + ($fromQuote == null ? 43 : ((Object)$fromQuote).hashCode());
        String $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : $header.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $invoice = this.getInvoice();
        result = result * 59 + ($invoice == null ? 43 : $invoice.hashCode());
        InvoiceSettings $invoiceSettings = this.getInvoiceSettings();
        result = result * 59 + ($invoiceSettings == null ? 43 : ((Object)$invoiceSettings).hashCode());
        LineItemCollection $lineItems = this.getLineItems();
        result = result * 59 + ($lineItems == null ? 43 : ((Object)$lineItems).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $number = this.getNumber();
        result = result * 59 + ($number == null ? 43 : $number.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $onBehalfOf = this.getOnBehalfOf();
        result = result * 59 + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        StatusTransitions $statusTransitions = this.getStatusTransitions();
        result = result * 59 + ($statusTransitions == null ? 43 : ((Object)$statusTransitions).hashCode());
        String $subscription = this.getSubscription();
        result = result * 59 + ($subscription == null ? 43 : $subscription.hashCode());
        SubscriptionData $subscriptionData = this.getSubscriptionData();
        result = result * 59 + ($subscriptionData == null ? 43 : ((Object)$subscriptionData).hashCode());
        String $subscriptionSchedule = this.getSubscriptionSchedule();
        result = result * 59 + ($subscriptionSchedule == null ? 43 : $subscriptionSchedule.hashCode());
        String $testClock = this.getTestClock();
        result = result * 59 + ($testClock == null ? 43 : $testClock.hashCode());
        TotalDetails $totalDetails = this.getTotalDetails();
        result = result * 59 + ($totalDetails == null ? 43 : ((Object)$totalDetails).hashCode());
        TransferData $transferData = this.getTransferData();
        result = result * 59 + ($transferData == null ? 43 : ((Object)$transferData).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class AutomaticTax
    extends StripeObject {
        @SerializedName(value="enabled")
        Boolean enabled;
        @SerializedName(value="status")
        String status;

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AutomaticTax)) {
                return false;
            }
            AutomaticTax other = (AutomaticTax)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !this$status.equals(other$status));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AutomaticTax;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            return result;
        }
    }

    public static class Computed
    extends StripeObject {
        @SerializedName(value="recurring")
        Recurring recurring;
        @SerializedName(value="upfront")
        Upfront upfront;

        @Generated
        public Recurring getRecurring() {
            return this.recurring;
        }

        @Generated
        public Upfront getUpfront() {
            return this.upfront;
        }

        @Generated
        public void setRecurring(Recurring recurring) {
            this.recurring = recurring;
        }

        @Generated
        public void setUpfront(Upfront upfront) {
            this.upfront = upfront;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Computed)) {
                return false;
            }
            Computed other = (Computed)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Recurring this$recurring = this.getRecurring();
            Recurring other$recurring = other.getRecurring();
            if (this$recurring == null ? other$recurring != null : !((Object)this$recurring).equals(other$recurring)) {
                return false;
            }
            Upfront this$upfront = this.getUpfront();
            Upfront other$upfront = other.getUpfront();
            return !(this$upfront == null ? other$upfront != null : !((Object)this$upfront).equals(other$upfront));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Computed;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Recurring $recurring = this.getRecurring();
            result = result * 59 + ($recurring == null ? 43 : ((Object)$recurring).hashCode());
            Upfront $upfront = this.getUpfront();
            result = result * 59 + ($upfront == null ? 43 : ((Object)$upfront).hashCode());
            return result;
        }

        public static class Recurring
        extends StripeObject {
            @SerializedName(value="amount_subtotal")
            Long amountSubtotal;
            @SerializedName(value="amount_total")
            Long amountTotal;
            @SerializedName(value="interval")
            String interval;
            @SerializedName(value="interval_count")
            Long intervalCount;
            @SerializedName(value="total_details")
            TotalDetails totalDetails;

            @Generated
            public Long getAmountSubtotal() {
                return this.amountSubtotal;
            }

            @Generated
            public Long getAmountTotal() {
                return this.amountTotal;
            }

            @Generated
            public String getInterval() {
                return this.interval;
            }

            @Generated
            public Long getIntervalCount() {
                return this.intervalCount;
            }

            @Generated
            public TotalDetails getTotalDetails() {
                return this.totalDetails;
            }

            @Generated
            public void setAmountSubtotal(Long amountSubtotal) {
                this.amountSubtotal = amountSubtotal;
            }

            @Generated
            public void setAmountTotal(Long amountTotal) {
                this.amountTotal = amountTotal;
            }

            @Generated
            public void setInterval(String interval) {
                this.interval = interval;
            }

            @Generated
            public void setIntervalCount(Long intervalCount) {
                this.intervalCount = intervalCount;
            }

            @Generated
            public void setTotalDetails(TotalDetails totalDetails) {
                this.totalDetails = totalDetails;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Recurring)) {
                    return false;
                }
                Recurring other = (Recurring)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$amountSubtotal = this.getAmountSubtotal();
                Long other$amountSubtotal = other.getAmountSubtotal();
                if (this$amountSubtotal == null ? other$amountSubtotal != null : !((Object)this$amountSubtotal).equals(other$amountSubtotal)) {
                    return false;
                }
                Long this$amountTotal = this.getAmountTotal();
                Long other$amountTotal = other.getAmountTotal();
                if (this$amountTotal == null ? other$amountTotal != null : !((Object)this$amountTotal).equals(other$amountTotal)) {
                    return false;
                }
                Long this$intervalCount = this.getIntervalCount();
                Long other$intervalCount = other.getIntervalCount();
                if (this$intervalCount == null ? other$intervalCount != null : !((Object)this$intervalCount).equals(other$intervalCount)) {
                    return false;
                }
                String this$interval = this.getInterval();
                String other$interval = other.getInterval();
                if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) {
                    return false;
                }
                TotalDetails this$totalDetails = this.getTotalDetails();
                TotalDetails other$totalDetails = other.getTotalDetails();
                return !(this$totalDetails == null ? other$totalDetails != null : !((Object)this$totalDetails).equals(other$totalDetails));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Recurring;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $amountSubtotal = this.getAmountSubtotal();
                result = result * 59 + ($amountSubtotal == null ? 43 : ((Object)$amountSubtotal).hashCode());
                Long $amountTotal = this.getAmountTotal();
                result = result * 59 + ($amountTotal == null ? 43 : ((Object)$amountTotal).hashCode());
                Long $intervalCount = this.getIntervalCount();
                result = result * 59 + ($intervalCount == null ? 43 : ((Object)$intervalCount).hashCode());
                String $interval = this.getInterval();
                result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
                TotalDetails $totalDetails = this.getTotalDetails();
                result = result * 59 + ($totalDetails == null ? 43 : ((Object)$totalDetails).hashCode());
                return result;
            }

            public static class TotalDetails
            extends StripeObject {
                @SerializedName(value="amount_discount")
                Long amountDiscount;
                @SerializedName(value="amount_shipping")
                Long amountShipping;
                @SerializedName(value="amount_tax")
                Long amountTax;
                @SerializedName(value="breakdown")
                Breakdown breakdown;

                @Generated
                public Long getAmountDiscount() {
                    return this.amountDiscount;
                }

                @Generated
                public Long getAmountShipping() {
                    return this.amountShipping;
                }

                @Generated
                public Long getAmountTax() {
                    return this.amountTax;
                }

                @Generated
                public Breakdown getBreakdown() {
                    return this.breakdown;
                }

                @Generated
                public void setAmountDiscount(Long amountDiscount) {
                    this.amountDiscount = amountDiscount;
                }

                @Generated
                public void setAmountShipping(Long amountShipping) {
                    this.amountShipping = amountShipping;
                }

                @Generated
                public void setAmountTax(Long amountTax) {
                    this.amountTax = amountTax;
                }

                @Generated
                public void setBreakdown(Breakdown breakdown) {
                    this.breakdown = breakdown;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof TotalDetails)) {
                        return false;
                    }
                    TotalDetails other = (TotalDetails)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$amountDiscount = this.getAmountDiscount();
                    Long other$amountDiscount = other.getAmountDiscount();
                    if (this$amountDiscount == null ? other$amountDiscount != null : !((Object)this$amountDiscount).equals(other$amountDiscount)) {
                        return false;
                    }
                    Long this$amountShipping = this.getAmountShipping();
                    Long other$amountShipping = other.getAmountShipping();
                    if (this$amountShipping == null ? other$amountShipping != null : !((Object)this$amountShipping).equals(other$amountShipping)) {
                        return false;
                    }
                    Long this$amountTax = this.getAmountTax();
                    Long other$amountTax = other.getAmountTax();
                    if (this$amountTax == null ? other$amountTax != null : !((Object)this$amountTax).equals(other$amountTax)) {
                        return false;
                    }
                    Breakdown this$breakdown = this.getBreakdown();
                    Breakdown other$breakdown = other.getBreakdown();
                    return !(this$breakdown == null ? other$breakdown != null : !((Object)this$breakdown).equals(other$breakdown));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof TotalDetails;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $amountDiscount = this.getAmountDiscount();
                    result = result * 59 + ($amountDiscount == null ? 43 : ((Object)$amountDiscount).hashCode());
                    Long $amountShipping = this.getAmountShipping();
                    result = result * 59 + ($amountShipping == null ? 43 : ((Object)$amountShipping).hashCode());
                    Long $amountTax = this.getAmountTax();
                    result = result * 59 + ($amountTax == null ? 43 : ((Object)$amountTax).hashCode());
                    Breakdown $breakdown = this.getBreakdown();
                    result = result * 59 + ($breakdown == null ? 43 : ((Object)$breakdown).hashCode());
                    return result;
                }

                public static class Breakdown
                extends StripeObject {
                    @SerializedName(value="discounts")
                    List<Discount> discounts;
                    @SerializedName(value="taxes")
                    List<Tax> taxes;

                    @Generated
                    public List<Discount> getDiscounts() {
                        return this.discounts;
                    }

                    @Generated
                    public List<Tax> getTaxes() {
                        return this.taxes;
                    }

                    @Generated
                    public void setDiscounts(List<Discount> discounts) {
                        this.discounts = discounts;
                    }

                    @Generated
                    public void setTaxes(List<Tax> taxes) {
                        this.taxes = taxes;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Breakdown)) {
                            return false;
                        }
                        Breakdown other = (Breakdown)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        List<Discount> this$discounts = this.getDiscounts();
                        List<Discount> other$discounts = other.getDiscounts();
                        if (this$discounts == null ? other$discounts != null : !((Object)this$discounts).equals(other$discounts)) {
                            return false;
                        }
                        List<Tax> this$taxes = this.getTaxes();
                        List<Tax> other$taxes = other.getTaxes();
                        return !(this$taxes == null ? other$taxes != null : !((Object)this$taxes).equals(other$taxes));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Breakdown;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        List<Discount> $discounts = this.getDiscounts();
                        result = result * 59 + ($discounts == null ? 43 : ((Object)$discounts).hashCode());
                        List<Tax> $taxes = this.getTaxes();
                        result = result * 59 + ($taxes == null ? 43 : ((Object)$taxes).hashCode());
                        return result;
                    }

                    public static class Tax
                    extends StripeObject {
                        @SerializedName(value="amount")
                        Long amount;
                        @SerializedName(value="rate")
                        TaxRate rate;
                        @SerializedName(value="taxability_reason")
                        String taxabilityReason;
                        @SerializedName(value="taxable_amount")
                        Long taxableAmount;

                        @Generated
                        public Long getAmount() {
                            return this.amount;
                        }

                        @Generated
                        public TaxRate getRate() {
                            return this.rate;
                        }

                        @Generated
                        public String getTaxabilityReason() {
                            return this.taxabilityReason;
                        }

                        @Generated
                        public Long getTaxableAmount() {
                            return this.taxableAmount;
                        }

                        @Generated
                        public void setAmount(Long amount) {
                            this.amount = amount;
                        }

                        @Generated
                        public void setRate(TaxRate rate) {
                            this.rate = rate;
                        }

                        @Generated
                        public void setTaxabilityReason(String taxabilityReason) {
                            this.taxabilityReason = taxabilityReason;
                        }

                        @Generated
                        public void setTaxableAmount(Long taxableAmount) {
                            this.taxableAmount = taxableAmount;
                        }

                        @Generated
                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof Tax)) {
                                return false;
                            }
                            Tax other = (Tax)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            Long this$amount = this.getAmount();
                            Long other$amount = other.getAmount();
                            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                                return false;
                            }
                            Long this$taxableAmount = this.getTaxableAmount();
                            Long other$taxableAmount = other.getTaxableAmount();
                            if (this$taxableAmount == null ? other$taxableAmount != null : !((Object)this$taxableAmount).equals(other$taxableAmount)) {
                                return false;
                            }
                            TaxRate this$rate = this.getRate();
                            TaxRate other$rate = other.getRate();
                            if (this$rate == null ? other$rate != null : !((Object)this$rate).equals(other$rate)) {
                                return false;
                            }
                            String this$taxabilityReason = this.getTaxabilityReason();
                            String other$taxabilityReason = other.getTaxabilityReason();
                            return !(this$taxabilityReason == null ? other$taxabilityReason != null : !this$taxabilityReason.equals(other$taxabilityReason));
                        }

                        @Generated
                        protected boolean canEqual(Object other) {
                            return other instanceof Tax;
                        }

                        @Generated
                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            Long $amount = this.getAmount();
                            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                            Long $taxableAmount = this.getTaxableAmount();
                            result = result * 59 + ($taxableAmount == null ? 43 : ((Object)$taxableAmount).hashCode());
                            TaxRate $rate = this.getRate();
                            result = result * 59 + ($rate == null ? 43 : ((Object)$rate).hashCode());
                            String $taxabilityReason = this.getTaxabilityReason();
                            result = result * 59 + ($taxabilityReason == null ? 43 : $taxabilityReason.hashCode());
                            return result;
                        }
                    }

                    public static class Discount
                    extends StripeObject {
                        @SerializedName(value="amount")
                        Long amount;
                        @SerializedName(value="discount")
                        com.stripe.model.Discount discount;

                        @Generated
                        public Long getAmount() {
                            return this.amount;
                        }

                        @Generated
                        public com.stripe.model.Discount getDiscount() {
                            return this.discount;
                        }

                        @Generated
                        public void setAmount(Long amount) {
                            this.amount = amount;
                        }

                        @Generated
                        public void setDiscount(com.stripe.model.Discount discount) {
                            this.discount = discount;
                        }

                        @Generated
                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof Discount)) {
                                return false;
                            }
                            Discount other = (Discount)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            Long this$amount = this.getAmount();
                            Long other$amount = other.getAmount();
                            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                                return false;
                            }
                            com.stripe.model.Discount this$discount = this.getDiscount();
                            com.stripe.model.Discount other$discount = other.getDiscount();
                            return !(this$discount == null ? other$discount != null : !((Object)this$discount).equals(other$discount));
                        }

                        @Generated
                        protected boolean canEqual(Object other) {
                            return other instanceof Discount;
                        }

                        @Generated
                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            Long $amount = this.getAmount();
                            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                            com.stripe.model.Discount $discount = this.getDiscount();
                            result = result * 59 + ($discount == null ? 43 : ((Object)$discount).hashCode());
                            return result;
                        }
                    }
                }
            }
        }

        public static class Upfront
        extends StripeObject {
            @SerializedName(value="amount_subtotal")
            Long amountSubtotal;
            @SerializedName(value="amount_total")
            Long amountTotal;
            @SerializedName(value="line_items")
            LineItemCollection lineItems;
            @SerializedName(value="total_details")
            TotalDetails totalDetails;

            @Generated
            public Long getAmountSubtotal() {
                return this.amountSubtotal;
            }

            @Generated
            public Long getAmountTotal() {
                return this.amountTotal;
            }

            @Generated
            public LineItemCollection getLineItems() {
                return this.lineItems;
            }

            @Generated
            public TotalDetails getTotalDetails() {
                return this.totalDetails;
            }

            @Generated
            public void setAmountSubtotal(Long amountSubtotal) {
                this.amountSubtotal = amountSubtotal;
            }

            @Generated
            public void setAmountTotal(Long amountTotal) {
                this.amountTotal = amountTotal;
            }

            @Generated
            public void setLineItems(LineItemCollection lineItems) {
                this.lineItems = lineItems;
            }

            @Generated
            public void setTotalDetails(TotalDetails totalDetails) {
                this.totalDetails = totalDetails;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Upfront)) {
                    return false;
                }
                Upfront other = (Upfront)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$amountSubtotal = this.getAmountSubtotal();
                Long other$amountSubtotal = other.getAmountSubtotal();
                if (this$amountSubtotal == null ? other$amountSubtotal != null : !((Object)this$amountSubtotal).equals(other$amountSubtotal)) {
                    return false;
                }
                Long this$amountTotal = this.getAmountTotal();
                Long other$amountTotal = other.getAmountTotal();
                if (this$amountTotal == null ? other$amountTotal != null : !((Object)this$amountTotal).equals(other$amountTotal)) {
                    return false;
                }
                LineItemCollection this$lineItems = this.getLineItems();
                LineItemCollection other$lineItems = other.getLineItems();
                if (this$lineItems == null ? other$lineItems != null : !((Object)this$lineItems).equals(other$lineItems)) {
                    return false;
                }
                TotalDetails this$totalDetails = this.getTotalDetails();
                TotalDetails other$totalDetails = other.getTotalDetails();
                return !(this$totalDetails == null ? other$totalDetails != null : !((Object)this$totalDetails).equals(other$totalDetails));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Upfront;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $amountSubtotal = this.getAmountSubtotal();
                result = result * 59 + ($amountSubtotal == null ? 43 : ((Object)$amountSubtotal).hashCode());
                Long $amountTotal = this.getAmountTotal();
                result = result * 59 + ($amountTotal == null ? 43 : ((Object)$amountTotal).hashCode());
                LineItemCollection $lineItems = this.getLineItems();
                result = result * 59 + ($lineItems == null ? 43 : ((Object)$lineItems).hashCode());
                TotalDetails $totalDetails = this.getTotalDetails();
                result = result * 59 + ($totalDetails == null ? 43 : ((Object)$totalDetails).hashCode());
                return result;
            }

            public static class TotalDetails
            extends StripeObject {
                @SerializedName(value="amount_discount")
                Long amountDiscount;
                @SerializedName(value="amount_shipping")
                Long amountShipping;
                @SerializedName(value="amount_tax")
                Long amountTax;
                @SerializedName(value="breakdown")
                Breakdown breakdown;

                @Generated
                public Long getAmountDiscount() {
                    return this.amountDiscount;
                }

                @Generated
                public Long getAmountShipping() {
                    return this.amountShipping;
                }

                @Generated
                public Long getAmountTax() {
                    return this.amountTax;
                }

                @Generated
                public Breakdown getBreakdown() {
                    return this.breakdown;
                }

                @Generated
                public void setAmountDiscount(Long amountDiscount) {
                    this.amountDiscount = amountDiscount;
                }

                @Generated
                public void setAmountShipping(Long amountShipping) {
                    this.amountShipping = amountShipping;
                }

                @Generated
                public void setAmountTax(Long amountTax) {
                    this.amountTax = amountTax;
                }

                @Generated
                public void setBreakdown(Breakdown breakdown) {
                    this.breakdown = breakdown;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof TotalDetails)) {
                        return false;
                    }
                    TotalDetails other = (TotalDetails)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$amountDiscount = this.getAmountDiscount();
                    Long other$amountDiscount = other.getAmountDiscount();
                    if (this$amountDiscount == null ? other$amountDiscount != null : !((Object)this$amountDiscount).equals(other$amountDiscount)) {
                        return false;
                    }
                    Long this$amountShipping = this.getAmountShipping();
                    Long other$amountShipping = other.getAmountShipping();
                    if (this$amountShipping == null ? other$amountShipping != null : !((Object)this$amountShipping).equals(other$amountShipping)) {
                        return false;
                    }
                    Long this$amountTax = this.getAmountTax();
                    Long other$amountTax = other.getAmountTax();
                    if (this$amountTax == null ? other$amountTax != null : !((Object)this$amountTax).equals(other$amountTax)) {
                        return false;
                    }
                    Breakdown this$breakdown = this.getBreakdown();
                    Breakdown other$breakdown = other.getBreakdown();
                    return !(this$breakdown == null ? other$breakdown != null : !((Object)this$breakdown).equals(other$breakdown));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof TotalDetails;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $amountDiscount = this.getAmountDiscount();
                    result = result * 59 + ($amountDiscount == null ? 43 : ((Object)$amountDiscount).hashCode());
                    Long $amountShipping = this.getAmountShipping();
                    result = result * 59 + ($amountShipping == null ? 43 : ((Object)$amountShipping).hashCode());
                    Long $amountTax = this.getAmountTax();
                    result = result * 59 + ($amountTax == null ? 43 : ((Object)$amountTax).hashCode());
                    Breakdown $breakdown = this.getBreakdown();
                    result = result * 59 + ($breakdown == null ? 43 : ((Object)$breakdown).hashCode());
                    return result;
                }

                public static class Breakdown
                extends StripeObject {
                    @SerializedName(value="discounts")
                    List<Discount> discounts;
                    @SerializedName(value="taxes")
                    List<Tax> taxes;

                    @Generated
                    public List<Discount> getDiscounts() {
                        return this.discounts;
                    }

                    @Generated
                    public List<Tax> getTaxes() {
                        return this.taxes;
                    }

                    @Generated
                    public void setDiscounts(List<Discount> discounts) {
                        this.discounts = discounts;
                    }

                    @Generated
                    public void setTaxes(List<Tax> taxes) {
                        this.taxes = taxes;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Breakdown)) {
                            return false;
                        }
                        Breakdown other = (Breakdown)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        List<Discount> this$discounts = this.getDiscounts();
                        List<Discount> other$discounts = other.getDiscounts();
                        if (this$discounts == null ? other$discounts != null : !((Object)this$discounts).equals(other$discounts)) {
                            return false;
                        }
                        List<Tax> this$taxes = this.getTaxes();
                        List<Tax> other$taxes = other.getTaxes();
                        return !(this$taxes == null ? other$taxes != null : !((Object)this$taxes).equals(other$taxes));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Breakdown;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        List<Discount> $discounts = this.getDiscounts();
                        result = result * 59 + ($discounts == null ? 43 : ((Object)$discounts).hashCode());
                        List<Tax> $taxes = this.getTaxes();
                        result = result * 59 + ($taxes == null ? 43 : ((Object)$taxes).hashCode());
                        return result;
                    }

                    public static class Tax
                    extends StripeObject {
                        @SerializedName(value="amount")
                        Long amount;
                        @SerializedName(value="rate")
                        TaxRate rate;
                        @SerializedName(value="taxability_reason")
                        String taxabilityReason;
                        @SerializedName(value="taxable_amount")
                        Long taxableAmount;

                        @Generated
                        public Long getAmount() {
                            return this.amount;
                        }

                        @Generated
                        public TaxRate getRate() {
                            return this.rate;
                        }

                        @Generated
                        public String getTaxabilityReason() {
                            return this.taxabilityReason;
                        }

                        @Generated
                        public Long getTaxableAmount() {
                            return this.taxableAmount;
                        }

                        @Generated
                        public void setAmount(Long amount) {
                            this.amount = amount;
                        }

                        @Generated
                        public void setRate(TaxRate rate) {
                            this.rate = rate;
                        }

                        @Generated
                        public void setTaxabilityReason(String taxabilityReason) {
                            this.taxabilityReason = taxabilityReason;
                        }

                        @Generated
                        public void setTaxableAmount(Long taxableAmount) {
                            this.taxableAmount = taxableAmount;
                        }

                        @Generated
                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof Tax)) {
                                return false;
                            }
                            Tax other = (Tax)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            Long this$amount = this.getAmount();
                            Long other$amount = other.getAmount();
                            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                                return false;
                            }
                            Long this$taxableAmount = this.getTaxableAmount();
                            Long other$taxableAmount = other.getTaxableAmount();
                            if (this$taxableAmount == null ? other$taxableAmount != null : !((Object)this$taxableAmount).equals(other$taxableAmount)) {
                                return false;
                            }
                            TaxRate this$rate = this.getRate();
                            TaxRate other$rate = other.getRate();
                            if (this$rate == null ? other$rate != null : !((Object)this$rate).equals(other$rate)) {
                                return false;
                            }
                            String this$taxabilityReason = this.getTaxabilityReason();
                            String other$taxabilityReason = other.getTaxabilityReason();
                            return !(this$taxabilityReason == null ? other$taxabilityReason != null : !this$taxabilityReason.equals(other$taxabilityReason));
                        }

                        @Generated
                        protected boolean canEqual(Object other) {
                            return other instanceof Tax;
                        }

                        @Generated
                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            Long $amount = this.getAmount();
                            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                            Long $taxableAmount = this.getTaxableAmount();
                            result = result * 59 + ($taxableAmount == null ? 43 : ((Object)$taxableAmount).hashCode());
                            TaxRate $rate = this.getRate();
                            result = result * 59 + ($rate == null ? 43 : ((Object)$rate).hashCode());
                            String $taxabilityReason = this.getTaxabilityReason();
                            result = result * 59 + ($taxabilityReason == null ? 43 : $taxabilityReason.hashCode());
                            return result;
                        }
                    }

                    public static class Discount
                    extends StripeObject {
                        @SerializedName(value="amount")
                        Long amount;
                        @SerializedName(value="discount")
                        com.stripe.model.Discount discount;

                        @Generated
                        public Long getAmount() {
                            return this.amount;
                        }

                        @Generated
                        public com.stripe.model.Discount getDiscount() {
                            return this.discount;
                        }

                        @Generated
                        public void setAmount(Long amount) {
                            this.amount = amount;
                        }

                        @Generated
                        public void setDiscount(com.stripe.model.Discount discount) {
                            this.discount = discount;
                        }

                        @Generated
                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof Discount)) {
                                return false;
                            }
                            Discount other = (Discount)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            Long this$amount = this.getAmount();
                            Long other$amount = other.getAmount();
                            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                                return false;
                            }
                            com.stripe.model.Discount this$discount = this.getDiscount();
                            com.stripe.model.Discount other$discount = other.getDiscount();
                            return !(this$discount == null ? other$discount != null : !((Object)this$discount).equals(other$discount));
                        }

                        @Generated
                        protected boolean canEqual(Object other) {
                            return other instanceof Discount;
                        }

                        @Generated
                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            Long $amount = this.getAmount();
                            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                            com.stripe.model.Discount $discount = this.getDiscount();
                            result = result * 59 + ($discount == null ? 43 : ((Object)$discount).hashCode());
                            return result;
                        }
                    }
                }
            }
        }
    }

    public static class FromQuote
    extends StripeObject {
        @SerializedName(value="is_revision")
        Boolean isRevision;
        @SerializedName(value="quote")
        ExpandableField<Quote> quote;

        public String getQuote() {
            return this.quote != null ? this.quote.getId() : null;
        }

        public void setQuote(String id) {
            this.quote = ApiResource.setExpandableFieldId(id, this.quote);
        }

        public Quote getQuoteObject() {
            return this.quote != null ? this.quote.getExpanded() : null;
        }

        public void setQuoteObject(Quote expandableObject) {
            this.quote = new ExpandableField<Quote>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public Boolean getIsRevision() {
            return this.isRevision;
        }

        @Generated
        public void setIsRevision(Boolean isRevision) {
            this.isRevision = isRevision;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FromQuote)) {
                return false;
            }
            FromQuote other = (FromQuote)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$isRevision = this.getIsRevision();
            Boolean other$isRevision = other.getIsRevision();
            if (this$isRevision == null ? other$isRevision != null : !((Object)this$isRevision).equals(other$isRevision)) {
                return false;
            }
            String this$quote = this.getQuote();
            String other$quote = other.getQuote();
            return !(this$quote == null ? other$quote != null : !this$quote.equals(other$quote));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FromQuote;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $isRevision = this.getIsRevision();
            result = result * 59 + ($isRevision == null ? 43 : ((Object)$isRevision).hashCode());
            String $quote = this.getQuote();
            result = result * 59 + ($quote == null ? 43 : $quote.hashCode());
            return result;
        }
    }

    public static class InvoiceSettings
    extends StripeObject {
        @SerializedName(value="days_until_due")
        Long daysUntilDue;

        @Generated
        public Long getDaysUntilDue() {
            return this.daysUntilDue;
        }

        @Generated
        public void setDaysUntilDue(Long daysUntilDue) {
            this.daysUntilDue = daysUntilDue;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InvoiceSettings)) {
                return false;
            }
            InvoiceSettings other = (InvoiceSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$daysUntilDue = this.getDaysUntilDue();
            Long other$daysUntilDue = other.getDaysUntilDue();
            return !(this$daysUntilDue == null ? other$daysUntilDue != null : !((Object)this$daysUntilDue).equals(other$daysUntilDue));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InvoiceSettings;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $daysUntilDue = this.getDaysUntilDue();
            result = result * 59 + ($daysUntilDue == null ? 43 : ((Object)$daysUntilDue).hashCode());
            return result;
        }
    }

    public static class StatusTransitions
    extends StripeObject {
        @SerializedName(value="accepted_at")
        Long acceptedAt;
        @SerializedName(value="canceled_at")
        Long canceledAt;
        @SerializedName(value="finalized_at")
        Long finalizedAt;

        @Generated
        public Long getAcceptedAt() {
            return this.acceptedAt;
        }

        @Generated
        public Long getCanceledAt() {
            return this.canceledAt;
        }

        @Generated
        public Long getFinalizedAt() {
            return this.finalizedAt;
        }

        @Generated
        public void setAcceptedAt(Long acceptedAt) {
            this.acceptedAt = acceptedAt;
        }

        @Generated
        public void setCanceledAt(Long canceledAt) {
            this.canceledAt = canceledAt;
        }

        @Generated
        public void setFinalizedAt(Long finalizedAt) {
            this.finalizedAt = finalizedAt;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatusTransitions)) {
                return false;
            }
            StatusTransitions other = (StatusTransitions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$acceptedAt = this.getAcceptedAt();
            Long other$acceptedAt = other.getAcceptedAt();
            if (this$acceptedAt == null ? other$acceptedAt != null : !((Object)this$acceptedAt).equals(other$acceptedAt)) {
                return false;
            }
            Long this$canceledAt = this.getCanceledAt();
            Long other$canceledAt = other.getCanceledAt();
            if (this$canceledAt == null ? other$canceledAt != null : !((Object)this$canceledAt).equals(other$canceledAt)) {
                return false;
            }
            Long this$finalizedAt = this.getFinalizedAt();
            Long other$finalizedAt = other.getFinalizedAt();
            return !(this$finalizedAt == null ? other$finalizedAt != null : !((Object)this$finalizedAt).equals(other$finalizedAt));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof StatusTransitions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $acceptedAt = this.getAcceptedAt();
            result = result * 59 + ($acceptedAt == null ? 43 : ((Object)$acceptedAt).hashCode());
            Long $canceledAt = this.getCanceledAt();
            result = result * 59 + ($canceledAt == null ? 43 : ((Object)$canceledAt).hashCode());
            Long $finalizedAt = this.getFinalizedAt();
            result = result * 59 + ($finalizedAt == null ? 43 : ((Object)$finalizedAt).hashCode());
            return result;
        }
    }

    public static class SubscriptionData
    extends StripeObject {
        @SerializedName(value="description")
        String description;
        @SerializedName(value="effective_date")
        Long effectiveDate;
        @SerializedName(value="trial_period_days")
        Long trialPeriodDays;

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public Long getEffectiveDate() {
            return this.effectiveDate;
        }

        @Generated
        public Long getTrialPeriodDays() {
            return this.trialPeriodDays;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public void setEffectiveDate(Long effectiveDate) {
            this.effectiveDate = effectiveDate;
        }

        @Generated
        public void setTrialPeriodDays(Long trialPeriodDays) {
            this.trialPeriodDays = trialPeriodDays;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubscriptionData)) {
                return false;
            }
            SubscriptionData other = (SubscriptionData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$effectiveDate = this.getEffectiveDate();
            Long other$effectiveDate = other.getEffectiveDate();
            if (this$effectiveDate == null ? other$effectiveDate != null : !((Object)this$effectiveDate).equals(other$effectiveDate)) {
                return false;
            }
            Long this$trialPeriodDays = this.getTrialPeriodDays();
            Long other$trialPeriodDays = other.getTrialPeriodDays();
            if (this$trialPeriodDays == null ? other$trialPeriodDays != null : !((Object)this$trialPeriodDays).equals(other$trialPeriodDays)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SubscriptionData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $effectiveDate = this.getEffectiveDate();
            result = result * 59 + ($effectiveDate == null ? 43 : ((Object)$effectiveDate).hashCode());
            Long $trialPeriodDays = this.getTrialPeriodDays();
            result = result * 59 + ($trialPeriodDays == null ? 43 : ((Object)$trialPeriodDays).hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }
    }

    public static class TotalDetails
    extends StripeObject {
        @SerializedName(value="amount_discount")
        Long amountDiscount;
        @SerializedName(value="amount_shipping")
        Long amountShipping;
        @SerializedName(value="amount_tax")
        Long amountTax;
        @SerializedName(value="breakdown")
        Breakdown breakdown;

        @Generated
        public Long getAmountDiscount() {
            return this.amountDiscount;
        }

        @Generated
        public Long getAmountShipping() {
            return this.amountShipping;
        }

        @Generated
        public Long getAmountTax() {
            return this.amountTax;
        }

        @Generated
        public Breakdown getBreakdown() {
            return this.breakdown;
        }

        @Generated
        public void setAmountDiscount(Long amountDiscount) {
            this.amountDiscount = amountDiscount;
        }

        @Generated
        public void setAmountShipping(Long amountShipping) {
            this.amountShipping = amountShipping;
        }

        @Generated
        public void setAmountTax(Long amountTax) {
            this.amountTax = amountTax;
        }

        @Generated
        public void setBreakdown(Breakdown breakdown) {
            this.breakdown = breakdown;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TotalDetails)) {
                return false;
            }
            TotalDetails other = (TotalDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amountDiscount = this.getAmountDiscount();
            Long other$amountDiscount = other.getAmountDiscount();
            if (this$amountDiscount == null ? other$amountDiscount != null : !((Object)this$amountDiscount).equals(other$amountDiscount)) {
                return false;
            }
            Long this$amountShipping = this.getAmountShipping();
            Long other$amountShipping = other.getAmountShipping();
            if (this$amountShipping == null ? other$amountShipping != null : !((Object)this$amountShipping).equals(other$amountShipping)) {
                return false;
            }
            Long this$amountTax = this.getAmountTax();
            Long other$amountTax = other.getAmountTax();
            if (this$amountTax == null ? other$amountTax != null : !((Object)this$amountTax).equals(other$amountTax)) {
                return false;
            }
            Breakdown this$breakdown = this.getBreakdown();
            Breakdown other$breakdown = other.getBreakdown();
            return !(this$breakdown == null ? other$breakdown != null : !((Object)this$breakdown).equals(other$breakdown));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TotalDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amountDiscount = this.getAmountDiscount();
            result = result * 59 + ($amountDiscount == null ? 43 : ((Object)$amountDiscount).hashCode());
            Long $amountShipping = this.getAmountShipping();
            result = result * 59 + ($amountShipping == null ? 43 : ((Object)$amountShipping).hashCode());
            Long $amountTax = this.getAmountTax();
            result = result * 59 + ($amountTax == null ? 43 : ((Object)$amountTax).hashCode());
            Breakdown $breakdown = this.getBreakdown();
            result = result * 59 + ($breakdown == null ? 43 : ((Object)$breakdown).hashCode());
            return result;
        }

        public static class Breakdown
        extends StripeObject {
            @SerializedName(value="discounts")
            List<Discount> discounts;
            @SerializedName(value="taxes")
            List<Tax> taxes;

            @Generated
            public List<Discount> getDiscounts() {
                return this.discounts;
            }

            @Generated
            public List<Tax> getTaxes() {
                return this.taxes;
            }

            @Generated
            public void setDiscounts(List<Discount> discounts) {
                this.discounts = discounts;
            }

            @Generated
            public void setTaxes(List<Tax> taxes) {
                this.taxes = taxes;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Breakdown)) {
                    return false;
                }
                Breakdown other = (Breakdown)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<Discount> this$discounts = this.getDiscounts();
                List<Discount> other$discounts = other.getDiscounts();
                if (this$discounts == null ? other$discounts != null : !((Object)this$discounts).equals(other$discounts)) {
                    return false;
                }
                List<Tax> this$taxes = this.getTaxes();
                List<Tax> other$taxes = other.getTaxes();
                return !(this$taxes == null ? other$taxes != null : !((Object)this$taxes).equals(other$taxes));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Breakdown;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<Discount> $discounts = this.getDiscounts();
                result = result * 59 + ($discounts == null ? 43 : ((Object)$discounts).hashCode());
                List<Tax> $taxes = this.getTaxes();
                result = result * 59 + ($taxes == null ? 43 : ((Object)$taxes).hashCode());
                return result;
            }

            public static class Tax
            extends StripeObject {
                @SerializedName(value="amount")
                Long amount;
                @SerializedName(value="rate")
                TaxRate rate;
                @SerializedName(value="taxability_reason")
                String taxabilityReason;
                @SerializedName(value="taxable_amount")
                Long taxableAmount;

                @Generated
                public Long getAmount() {
                    return this.amount;
                }

                @Generated
                public TaxRate getRate() {
                    return this.rate;
                }

                @Generated
                public String getTaxabilityReason() {
                    return this.taxabilityReason;
                }

                @Generated
                public Long getTaxableAmount() {
                    return this.taxableAmount;
                }

                @Generated
                public void setAmount(Long amount) {
                    this.amount = amount;
                }

                @Generated
                public void setRate(TaxRate rate) {
                    this.rate = rate;
                }

                @Generated
                public void setTaxabilityReason(String taxabilityReason) {
                    this.taxabilityReason = taxabilityReason;
                }

                @Generated
                public void setTaxableAmount(Long taxableAmount) {
                    this.taxableAmount = taxableAmount;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Tax)) {
                        return false;
                    }
                    Tax other = (Tax)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$amount = this.getAmount();
                    Long other$amount = other.getAmount();
                    if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                        return false;
                    }
                    Long this$taxableAmount = this.getTaxableAmount();
                    Long other$taxableAmount = other.getTaxableAmount();
                    if (this$taxableAmount == null ? other$taxableAmount != null : !((Object)this$taxableAmount).equals(other$taxableAmount)) {
                        return false;
                    }
                    TaxRate this$rate = this.getRate();
                    TaxRate other$rate = other.getRate();
                    if (this$rate == null ? other$rate != null : !((Object)this$rate).equals(other$rate)) {
                        return false;
                    }
                    String this$taxabilityReason = this.getTaxabilityReason();
                    String other$taxabilityReason = other.getTaxabilityReason();
                    return !(this$taxabilityReason == null ? other$taxabilityReason != null : !this$taxabilityReason.equals(other$taxabilityReason));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Tax;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $amount = this.getAmount();
                    result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                    Long $taxableAmount = this.getTaxableAmount();
                    result = result * 59 + ($taxableAmount == null ? 43 : ((Object)$taxableAmount).hashCode());
                    TaxRate $rate = this.getRate();
                    result = result * 59 + ($rate == null ? 43 : ((Object)$rate).hashCode());
                    String $taxabilityReason = this.getTaxabilityReason();
                    result = result * 59 + ($taxabilityReason == null ? 43 : $taxabilityReason.hashCode());
                    return result;
                }
            }

            public static class Discount
            extends StripeObject {
                @SerializedName(value="amount")
                Long amount;
                @SerializedName(value="discount")
                com.stripe.model.Discount discount;

                @Generated
                public Long getAmount() {
                    return this.amount;
                }

                @Generated
                public com.stripe.model.Discount getDiscount() {
                    return this.discount;
                }

                @Generated
                public void setAmount(Long amount) {
                    this.amount = amount;
                }

                @Generated
                public void setDiscount(com.stripe.model.Discount discount) {
                    this.discount = discount;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Discount)) {
                        return false;
                    }
                    Discount other = (Discount)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$amount = this.getAmount();
                    Long other$amount = other.getAmount();
                    if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                        return false;
                    }
                    com.stripe.model.Discount this$discount = this.getDiscount();
                    com.stripe.model.Discount other$discount = other.getDiscount();
                    return !(this$discount == null ? other$discount != null : !((Object)this$discount).equals(other$discount));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Discount;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $amount = this.getAmount();
                    result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                    com.stripe.model.Discount $discount = this.getDiscount();
                    result = result * 59 + ($discount == null ? 43 : ((Object)$discount).hashCode());
                    return result;
                }
            }
        }
    }

    public static class TransferData
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="amount_percent")
        BigDecimal amountPercent;
        @SerializedName(value="destination")
        ExpandableField<Account> destination;

        public String getDestination() {
            return this.destination != null ? this.destination.getId() : null;
        }

        public void setDestination(String id) {
            this.destination = ApiResource.setExpandableFieldId(id, this.destination);
        }

        public Account getDestinationObject() {
            return this.destination != null ? this.destination.getExpanded() : null;
        }

        public void setDestinationObject(Account expandableObject) {
            this.destination = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public BigDecimal getAmountPercent() {
            return this.amountPercent;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public void setAmountPercent(BigDecimal amountPercent) {
            this.amountPercent = amountPercent;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransferData)) {
                return false;
            }
            TransferData other = (TransferData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            BigDecimal this$amountPercent = this.getAmountPercent();
            BigDecimal other$amountPercent = other.getAmountPercent();
            if (this$amountPercent == null ? other$amountPercent != null : !((Object)this$amountPercent).equals(other$amountPercent)) {
                return false;
            }
            String this$destination = this.getDestination();
            String other$destination = other.getDestination();
            return !(this$destination == null ? other$destination != null : !this$destination.equals(other$destination));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TransferData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            BigDecimal $amountPercent = this.getAmountPercent();
            result = result * 59 + ($amountPercent == null ? 43 : ((Object)$amountPercent).hashCode());
            String $destination = this.getDestination();
            result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
            return result;
        }
    }
}

