/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.PaymentMethod;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.MandateRetrieveParams;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Mandate
extends ApiResource
implements HasId {
    @SerializedName(value="customer_acceptance")
    CustomerAcceptance customerAcceptance;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="multi_use")
    MultiUse multiUse;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="on_behalf_of")
    String onBehalfOf;
    @SerializedName(value="payment_method")
    ExpandableField<PaymentMethod> paymentMethod;
    @SerializedName(value="payment_method_details")
    PaymentMethodDetails paymentMethodDetails;
    @SerializedName(value="single_use")
    SingleUse singleUse;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="type")
    String type;

    public String getPaymentMethod() {
        return this.paymentMethod != null ? this.paymentMethod.getId() : null;
    }

    public void setPaymentMethod(String id) {
        this.paymentMethod = ApiResource.setExpandableFieldId(id, this.paymentMethod);
    }

    public PaymentMethod getPaymentMethodObject() {
        return this.paymentMethod != null ? this.paymentMethod.getExpanded() : null;
    }

    public void setPaymentMethodObject(PaymentMethod expandableObject) {
        this.paymentMethod = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
    }

    public static Mandate retrieve(String mandate) throws StripeException {
        return Mandate.retrieve(mandate, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Mandate retrieve(String mandate, RequestOptions options) throws StripeException {
        return Mandate.retrieve(mandate, (Map<String, Object>)null, options);
    }

    public static Mandate retrieve(String mandate, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/mandates/%s", ApiResource.urlEncodeId(mandate)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Mandate.class, options);
    }

    public static Mandate retrieve(String mandate, MandateRetrieveParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/mandates/%s", ApiResource.urlEncodeId(mandate)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Mandate.class, options);
    }

    @Generated
    public CustomerAcceptance getCustomerAcceptance() {
        return this.customerAcceptance;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public MultiUse getMultiUse() {
        return this.multiUse;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getOnBehalfOf() {
        return this.onBehalfOf;
    }

    @Generated
    public PaymentMethodDetails getPaymentMethodDetails() {
        return this.paymentMethodDetails;
    }

    @Generated
    public SingleUse getSingleUse() {
        return this.singleUse;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setCustomerAcceptance(CustomerAcceptance customerAcceptance) {
        this.customerAcceptance = customerAcceptance;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMultiUse(MultiUse multiUse) {
        this.multiUse = multiUse;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }

    @Generated
    public void setPaymentMethodDetails(PaymentMethodDetails paymentMethodDetails) {
        this.paymentMethodDetails = paymentMethodDetails;
    }

    @Generated
    public void setSingleUse(SingleUse singleUse) {
        this.singleUse = singleUse;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Mandate)) {
            return false;
        }
        Mandate other = (Mandate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        CustomerAcceptance this$customerAcceptance = this.getCustomerAcceptance();
        CustomerAcceptance other$customerAcceptance = other.getCustomerAcceptance();
        if (this$customerAcceptance == null ? other$customerAcceptance != null : !((Object)this$customerAcceptance).equals(other$customerAcceptance)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        MultiUse this$multiUse = this.getMultiUse();
        MultiUse other$multiUse = other.getMultiUse();
        if (this$multiUse == null ? other$multiUse != null : !((Object)this$multiUse).equals(other$multiUse)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$onBehalfOf = this.getOnBehalfOf();
        String other$onBehalfOf = other.getOnBehalfOf();
        if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) {
            return false;
        }
        String this$paymentMethod = this.getPaymentMethod();
        String other$paymentMethod = other.getPaymentMethod();
        if (this$paymentMethod == null ? other$paymentMethod != null : !this$paymentMethod.equals(other$paymentMethod)) {
            return false;
        }
        PaymentMethodDetails this$paymentMethodDetails = this.getPaymentMethodDetails();
        PaymentMethodDetails other$paymentMethodDetails = other.getPaymentMethodDetails();
        if (this$paymentMethodDetails == null ? other$paymentMethodDetails != null : !((Object)this$paymentMethodDetails).equals(other$paymentMethodDetails)) {
            return false;
        }
        SingleUse this$singleUse = this.getSingleUse();
        SingleUse other$singleUse = other.getSingleUse();
        if (this$singleUse == null ? other$singleUse != null : !((Object)this$singleUse).equals(other$singleUse)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Mandate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        CustomerAcceptance $customerAcceptance = this.getCustomerAcceptance();
        result = result * 59 + ($customerAcceptance == null ? 43 : ((Object)$customerAcceptance).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        MultiUse $multiUse = this.getMultiUse();
        result = result * 59 + ($multiUse == null ? 43 : ((Object)$multiUse).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $onBehalfOf = this.getOnBehalfOf();
        result = result * 59 + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
        String $paymentMethod = this.getPaymentMethod();
        result = result * 59 + ($paymentMethod == null ? 43 : $paymentMethod.hashCode());
        PaymentMethodDetails $paymentMethodDetails = this.getPaymentMethodDetails();
        result = result * 59 + ($paymentMethodDetails == null ? 43 : ((Object)$paymentMethodDetails).hashCode());
        SingleUse $singleUse = this.getSingleUse();
        result = result * 59 + ($singleUse == null ? 43 : ((Object)$singleUse).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class CustomerAcceptance
    extends StripeObject {
        @SerializedName(value="accepted_at")
        Long acceptedAt;
        @SerializedName(value="offline")
        Offline offline;
        @SerializedName(value="online")
        Online online;
        @SerializedName(value="type")
        String type;

        @Generated
        public Long getAcceptedAt() {
            return this.acceptedAt;
        }

        @Generated
        public Offline getOffline() {
            return this.offline;
        }

        @Generated
        public Online getOnline() {
            return this.online;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setAcceptedAt(Long acceptedAt) {
            this.acceptedAt = acceptedAt;
        }

        @Generated
        public void setOffline(Offline offline) {
            this.offline = offline;
        }

        @Generated
        public void setOnline(Online online) {
            this.online = online;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomerAcceptance)) {
                return false;
            }
            CustomerAcceptance other = (CustomerAcceptance)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$acceptedAt = this.getAcceptedAt();
            Long other$acceptedAt = other.getAcceptedAt();
            if (this$acceptedAt == null ? other$acceptedAt != null : !((Object)this$acceptedAt).equals(other$acceptedAt)) {
                return false;
            }
            Offline this$offline = this.getOffline();
            Offline other$offline = other.getOffline();
            if (this$offline == null ? other$offline != null : !((Object)this$offline).equals(other$offline)) {
                return false;
            }
            Online this$online = this.getOnline();
            Online other$online = other.getOnline();
            if (this$online == null ? other$online != null : !((Object)this$online).equals(other$online)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CustomerAcceptance;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $acceptedAt = this.getAcceptedAt();
            result = result * 59 + ($acceptedAt == null ? 43 : ((Object)$acceptedAt).hashCode());
            Offline $offline = this.getOffline();
            result = result * 59 + ($offline == null ? 43 : ((Object)$offline).hashCode());
            Online $online = this.getOnline();
            result = result * 59 + ($online == null ? 43 : ((Object)$online).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class Offline
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Offline)) {
                    return false;
                }
                Offline other = (Offline)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Offline;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Online
        extends StripeObject {
            @SerializedName(value="ip_address")
            String ipAddress;
            @SerializedName(value="user_agent")
            String userAgent;

            @Generated
            public String getIpAddress() {
                return this.ipAddress;
            }

            @Generated
            public String getUserAgent() {
                return this.userAgent;
            }

            @Generated
            public void setIpAddress(String ipAddress) {
                this.ipAddress = ipAddress;
            }

            @Generated
            public void setUserAgent(String userAgent) {
                this.userAgent = userAgent;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Online)) {
                    return false;
                }
                Online other = (Online)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$ipAddress = this.getIpAddress();
                String other$ipAddress = other.getIpAddress();
                if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
                    return false;
                }
                String this$userAgent = this.getUserAgent();
                String other$userAgent = other.getUserAgent();
                return !(this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Online;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $ipAddress = this.getIpAddress();
                result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
                String $userAgent = this.getUserAgent();
                result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
                return result;
            }
        }
    }

    public static class MultiUse
    extends StripeObject {
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MultiUse)) {
                return false;
            }
            MultiUse other = (MultiUse)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MultiUse;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }

    public static class PaymentMethodDetails
    extends StripeObject {
        @SerializedName(value="acss_debit")
        AcssDebit acssDebit;
        @SerializedName(value="au_becs_debit")
        AuBecsDebit auBecsDebit;
        @SerializedName(value="bacs_debit")
        BacsDebit bacsDebit;
        @SerializedName(value="blik")
        Blik blik;
        @SerializedName(value="card")
        Card card;
        @SerializedName(value="cashapp")
        Cashapp cashapp;
        @SerializedName(value="link")
        Link link;
        @SerializedName(value="paypal")
        Paypal paypal;
        @SerializedName(value="sepa_debit")
        SepaDebit sepaDebit;
        @SerializedName(value="type")
        String type;
        @SerializedName(value="us_bank_account")
        UsBankAccount usBankAccount;

        @Generated
        public AcssDebit getAcssDebit() {
            return this.acssDebit;
        }

        @Generated
        public AuBecsDebit getAuBecsDebit() {
            return this.auBecsDebit;
        }

        @Generated
        public BacsDebit getBacsDebit() {
            return this.bacsDebit;
        }

        @Generated
        public Blik getBlik() {
            return this.blik;
        }

        @Generated
        public Card getCard() {
            return this.card;
        }

        @Generated
        public Cashapp getCashapp() {
            return this.cashapp;
        }

        @Generated
        public Link getLink() {
            return this.link;
        }

        @Generated
        public Paypal getPaypal() {
            return this.paypal;
        }

        @Generated
        public SepaDebit getSepaDebit() {
            return this.sepaDebit;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public UsBankAccount getUsBankAccount() {
            return this.usBankAccount;
        }

        @Generated
        public void setAcssDebit(AcssDebit acssDebit) {
            this.acssDebit = acssDebit;
        }

        @Generated
        public void setAuBecsDebit(AuBecsDebit auBecsDebit) {
            this.auBecsDebit = auBecsDebit;
        }

        @Generated
        public void setBacsDebit(BacsDebit bacsDebit) {
            this.bacsDebit = bacsDebit;
        }

        @Generated
        public void setBlik(Blik blik) {
            this.blik = blik;
        }

        @Generated
        public void setCard(Card card) {
            this.card = card;
        }

        @Generated
        public void setCashapp(Cashapp cashapp) {
            this.cashapp = cashapp;
        }

        @Generated
        public void setLink(Link link) {
            this.link = link;
        }

        @Generated
        public void setPaypal(Paypal paypal) {
            this.paypal = paypal;
        }

        @Generated
        public void setSepaDebit(SepaDebit sepaDebit) {
            this.sepaDebit = sepaDebit;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setUsBankAccount(UsBankAccount usBankAccount) {
            this.usBankAccount = usBankAccount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentMethodDetails)) {
                return false;
            }
            PaymentMethodDetails other = (PaymentMethodDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AcssDebit this$acssDebit = this.getAcssDebit();
            AcssDebit other$acssDebit = other.getAcssDebit();
            if (this$acssDebit == null ? other$acssDebit != null : !((Object)this$acssDebit).equals(other$acssDebit)) {
                return false;
            }
            AuBecsDebit this$auBecsDebit = this.getAuBecsDebit();
            AuBecsDebit other$auBecsDebit = other.getAuBecsDebit();
            if (this$auBecsDebit == null ? other$auBecsDebit != null : !((Object)this$auBecsDebit).equals(other$auBecsDebit)) {
                return false;
            }
            BacsDebit this$bacsDebit = this.getBacsDebit();
            BacsDebit other$bacsDebit = other.getBacsDebit();
            if (this$bacsDebit == null ? other$bacsDebit != null : !((Object)this$bacsDebit).equals(other$bacsDebit)) {
                return false;
            }
            Blik this$blik = this.getBlik();
            Blik other$blik = other.getBlik();
            if (this$blik == null ? other$blik != null : !((Object)this$blik).equals(other$blik)) {
                return false;
            }
            Card this$card = this.getCard();
            Card other$card = other.getCard();
            if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                return false;
            }
            Cashapp this$cashapp = this.getCashapp();
            Cashapp other$cashapp = other.getCashapp();
            if (this$cashapp == null ? other$cashapp != null : !((Object)this$cashapp).equals(other$cashapp)) {
                return false;
            }
            Link this$link = this.getLink();
            Link other$link = other.getLink();
            if (this$link == null ? other$link != null : !((Object)this$link).equals(other$link)) {
                return false;
            }
            Paypal this$paypal = this.getPaypal();
            Paypal other$paypal = other.getPaypal();
            if (this$paypal == null ? other$paypal != null : !((Object)this$paypal).equals(other$paypal)) {
                return false;
            }
            SepaDebit this$sepaDebit = this.getSepaDebit();
            SepaDebit other$sepaDebit = other.getSepaDebit();
            if (this$sepaDebit == null ? other$sepaDebit != null : !((Object)this$sepaDebit).equals(other$sepaDebit)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            UsBankAccount this$usBankAccount = this.getUsBankAccount();
            UsBankAccount other$usBankAccount = other.getUsBankAccount();
            return !(this$usBankAccount == null ? other$usBankAccount != null : !((Object)this$usBankAccount).equals(other$usBankAccount));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaymentMethodDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AcssDebit $acssDebit = this.getAcssDebit();
            result = result * 59 + ($acssDebit == null ? 43 : ((Object)$acssDebit).hashCode());
            AuBecsDebit $auBecsDebit = this.getAuBecsDebit();
            result = result * 59 + ($auBecsDebit == null ? 43 : ((Object)$auBecsDebit).hashCode());
            BacsDebit $bacsDebit = this.getBacsDebit();
            result = result * 59 + ($bacsDebit == null ? 43 : ((Object)$bacsDebit).hashCode());
            Blik $blik = this.getBlik();
            result = result * 59 + ($blik == null ? 43 : ((Object)$blik).hashCode());
            Card $card = this.getCard();
            result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
            Cashapp $cashapp = this.getCashapp();
            result = result * 59 + ($cashapp == null ? 43 : ((Object)$cashapp).hashCode());
            Link $link = this.getLink();
            result = result * 59 + ($link == null ? 43 : ((Object)$link).hashCode());
            Paypal $paypal = this.getPaypal();
            result = result * 59 + ($paypal == null ? 43 : ((Object)$paypal).hashCode());
            SepaDebit $sepaDebit = this.getSepaDebit();
            result = result * 59 + ($sepaDebit == null ? 43 : ((Object)$sepaDebit).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            UsBankAccount $usBankAccount = this.getUsBankAccount();
            result = result * 59 + ($usBankAccount == null ? 43 : ((Object)$usBankAccount).hashCode());
            return result;
        }

        public static class AcssDebit
        extends StripeObject {
            @SerializedName(value="default_for")
            List<String> defaultFor;
            @SerializedName(value="interval_description")
            String intervalDescription;
            @SerializedName(value="payment_schedule")
            String paymentSchedule;
            @SerializedName(value="transaction_type")
            String transactionType;

            @Generated
            public List<String> getDefaultFor() {
                return this.defaultFor;
            }

            @Generated
            public String getIntervalDescription() {
                return this.intervalDescription;
            }

            @Generated
            public String getPaymentSchedule() {
                return this.paymentSchedule;
            }

            @Generated
            public String getTransactionType() {
                return this.transactionType;
            }

            @Generated
            public void setDefaultFor(List<String> defaultFor) {
                this.defaultFor = defaultFor;
            }

            @Generated
            public void setIntervalDescription(String intervalDescription) {
                this.intervalDescription = intervalDescription;
            }

            @Generated
            public void setPaymentSchedule(String paymentSchedule) {
                this.paymentSchedule = paymentSchedule;
            }

            @Generated
            public void setTransactionType(String transactionType) {
                this.transactionType = transactionType;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AcssDebit)) {
                    return false;
                }
                AcssDebit other = (AcssDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<String> this$defaultFor = this.getDefaultFor();
                List<String> other$defaultFor = other.getDefaultFor();
                if (this$defaultFor == null ? other$defaultFor != null : !((Object)this$defaultFor).equals(other$defaultFor)) {
                    return false;
                }
                String this$intervalDescription = this.getIntervalDescription();
                String other$intervalDescription = other.getIntervalDescription();
                if (this$intervalDescription == null ? other$intervalDescription != null : !this$intervalDescription.equals(other$intervalDescription)) {
                    return false;
                }
                String this$paymentSchedule = this.getPaymentSchedule();
                String other$paymentSchedule = other.getPaymentSchedule();
                if (this$paymentSchedule == null ? other$paymentSchedule != null : !this$paymentSchedule.equals(other$paymentSchedule)) {
                    return false;
                }
                String this$transactionType = this.getTransactionType();
                String other$transactionType = other.getTransactionType();
                return !(this$transactionType == null ? other$transactionType != null : !this$transactionType.equals(other$transactionType));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AcssDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<String> $defaultFor = this.getDefaultFor();
                result = result * 59 + ($defaultFor == null ? 43 : ((Object)$defaultFor).hashCode());
                String $intervalDescription = this.getIntervalDescription();
                result = result * 59 + ($intervalDescription == null ? 43 : $intervalDescription.hashCode());
                String $paymentSchedule = this.getPaymentSchedule();
                result = result * 59 + ($paymentSchedule == null ? 43 : $paymentSchedule.hashCode());
                String $transactionType = this.getTransactionType();
                result = result * 59 + ($transactionType == null ? 43 : $transactionType.hashCode());
                return result;
            }
        }

        public static class AuBecsDebit
        extends StripeObject {
            @SerializedName(value="url")
            String url;

            @Generated
            public String getUrl() {
                return this.url;
            }

            @Generated
            public void setUrl(String url) {
                this.url = url;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AuBecsDebit)) {
                    return false;
                }
                AuBecsDebit other = (AuBecsDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$url = this.getUrl();
                String other$url = other.getUrl();
                return !(this$url == null ? other$url != null : !this$url.equals(other$url));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AuBecsDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $url = this.getUrl();
                result = result * 59 + ($url == null ? 43 : $url.hashCode());
                return result;
            }
        }

        public static class BacsDebit
        extends StripeObject {
            @SerializedName(value="network_status")
            String networkStatus;
            @SerializedName(value="reference")
            String reference;
            @SerializedName(value="url")
            String url;

            @Generated
            public String getNetworkStatus() {
                return this.networkStatus;
            }

            @Generated
            public String getReference() {
                return this.reference;
            }

            @Generated
            public String getUrl() {
                return this.url;
            }

            @Generated
            public void setNetworkStatus(String networkStatus) {
                this.networkStatus = networkStatus;
            }

            @Generated
            public void setReference(String reference) {
                this.reference = reference;
            }

            @Generated
            public void setUrl(String url) {
                this.url = url;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BacsDebit)) {
                    return false;
                }
                BacsDebit other = (BacsDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$networkStatus = this.getNetworkStatus();
                String other$networkStatus = other.getNetworkStatus();
                if (this$networkStatus == null ? other$networkStatus != null : !this$networkStatus.equals(other$networkStatus)) {
                    return false;
                }
                String this$reference = this.getReference();
                String other$reference = other.getReference();
                if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                    return false;
                }
                String this$url = this.getUrl();
                String other$url = other.getUrl();
                return !(this$url == null ? other$url != null : !this$url.equals(other$url));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof BacsDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $networkStatus = this.getNetworkStatus();
                result = result * 59 + ($networkStatus == null ? 43 : $networkStatus.hashCode());
                String $reference = this.getReference();
                result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                String $url = this.getUrl();
                result = result * 59 + ($url == null ? 43 : $url.hashCode());
                return result;
            }
        }

        public static class Blik
        extends StripeObject {
            @SerializedName(value="expires_after")
            Long expiresAfter;
            @SerializedName(value="off_session")
            OffSession offSession;
            @SerializedName(value="type")
            String type;

            @Generated
            public Long getExpiresAfter() {
                return this.expiresAfter;
            }

            @Generated
            public OffSession getOffSession() {
                return this.offSession;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setExpiresAfter(Long expiresAfter) {
                this.expiresAfter = expiresAfter;
            }

            @Generated
            public void setOffSession(OffSession offSession) {
                this.offSession = offSession;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Blik)) {
                    return false;
                }
                Blik other = (Blik)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expiresAfter = this.getExpiresAfter();
                Long other$expiresAfter = other.getExpiresAfter();
                if (this$expiresAfter == null ? other$expiresAfter != null : !((Object)this$expiresAfter).equals(other$expiresAfter)) {
                    return false;
                }
                OffSession this$offSession = this.getOffSession();
                OffSession other$offSession = other.getOffSession();
                if (this$offSession == null ? other$offSession != null : !((Object)this$offSession).equals(other$offSession)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Blik;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expiresAfter = this.getExpiresAfter();
                result = result * 59 + ($expiresAfter == null ? 43 : ((Object)$expiresAfter).hashCode());
                OffSession $offSession = this.getOffSession();
                result = result * 59 + ($offSession == null ? 43 : ((Object)$offSession).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class OffSession
            extends StripeObject {
                @SerializedName(value="amount")
                Long amount;
                @SerializedName(value="currency")
                String currency;
                @SerializedName(value="interval")
                String interval;
                @SerializedName(value="interval_count")
                Long intervalCount;

                @Generated
                public Long getAmount() {
                    return this.amount;
                }

                @Generated
                public String getCurrency() {
                    return this.currency;
                }

                @Generated
                public String getInterval() {
                    return this.interval;
                }

                @Generated
                public Long getIntervalCount() {
                    return this.intervalCount;
                }

                @Generated
                public void setAmount(Long amount) {
                    this.amount = amount;
                }

                @Generated
                public void setCurrency(String currency) {
                    this.currency = currency;
                }

                @Generated
                public void setInterval(String interval) {
                    this.interval = interval;
                }

                @Generated
                public void setIntervalCount(Long intervalCount) {
                    this.intervalCount = intervalCount;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof OffSession)) {
                        return false;
                    }
                    OffSession other = (OffSession)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$amount = this.getAmount();
                    Long other$amount = other.getAmount();
                    if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                        return false;
                    }
                    Long this$intervalCount = this.getIntervalCount();
                    Long other$intervalCount = other.getIntervalCount();
                    if (this$intervalCount == null ? other$intervalCount != null : !((Object)this$intervalCount).equals(other$intervalCount)) {
                        return false;
                    }
                    String this$currency = this.getCurrency();
                    String other$currency = other.getCurrency();
                    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                        return false;
                    }
                    String this$interval = this.getInterval();
                    String other$interval = other.getInterval();
                    return !(this$interval == null ? other$interval != null : !this$interval.equals(other$interval));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof OffSession;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $amount = this.getAmount();
                    result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                    Long $intervalCount = this.getIntervalCount();
                    result = result * 59 + ($intervalCount == null ? 43 : ((Object)$intervalCount).hashCode());
                    String $currency = this.getCurrency();
                    result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
                    String $interval = this.getInterval();
                    result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
                    return result;
                }
            }
        }

        public static class Card
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Card)) {
                    return false;
                }
                Card other = (Card)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Card;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Cashapp
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Cashapp)) {
                    return false;
                }
                Cashapp other = (Cashapp)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Cashapp;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Link
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Link)) {
                    return false;
                }
                Link other = (Link)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Link;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Paypal
        extends StripeObject {
            @SerializedName(value="billing_agreement_id")
            String billingAgreementId;
            @SerializedName(value="payer_id")
            String payerId;

            @Generated
            public String getBillingAgreementId() {
                return this.billingAgreementId;
            }

            @Generated
            public String getPayerId() {
                return this.payerId;
            }

            @Generated
            public void setBillingAgreementId(String billingAgreementId) {
                this.billingAgreementId = billingAgreementId;
            }

            @Generated
            public void setPayerId(String payerId) {
                this.payerId = payerId;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Paypal)) {
                    return false;
                }
                Paypal other = (Paypal)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$billingAgreementId = this.getBillingAgreementId();
                String other$billingAgreementId = other.getBillingAgreementId();
                if (this$billingAgreementId == null ? other$billingAgreementId != null : !this$billingAgreementId.equals(other$billingAgreementId)) {
                    return false;
                }
                String this$payerId = this.getPayerId();
                String other$payerId = other.getPayerId();
                return !(this$payerId == null ? other$payerId != null : !this$payerId.equals(other$payerId));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Paypal;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $billingAgreementId = this.getBillingAgreementId();
                result = result * 59 + ($billingAgreementId == null ? 43 : $billingAgreementId.hashCode());
                String $payerId = this.getPayerId();
                result = result * 59 + ($payerId == null ? 43 : $payerId.hashCode());
                return result;
            }
        }

        public static class SepaDebit
        extends StripeObject {
            @SerializedName(value="reference")
            String reference;
            @SerializedName(value="url")
            String url;

            @Generated
            public String getReference() {
                return this.reference;
            }

            @Generated
            public String getUrl() {
                return this.url;
            }

            @Generated
            public void setReference(String reference) {
                this.reference = reference;
            }

            @Generated
            public void setUrl(String url) {
                this.url = url;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SepaDebit)) {
                    return false;
                }
                SepaDebit other = (SepaDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$reference = this.getReference();
                String other$reference = other.getReference();
                if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                    return false;
                }
                String this$url = this.getUrl();
                String other$url = other.getUrl();
                return !(this$url == null ? other$url != null : !this$url.equals(other$url));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SepaDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $reference = this.getReference();
                result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                String $url = this.getUrl();
                result = result * 59 + ($url == null ? 43 : $url.hashCode());
                return result;
            }
        }

        public static class UsBankAccount
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof UsBankAccount)) {
                    return false;
                }
                UsBankAccount other = (UsBankAccount)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof UsBankAccount;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }
    }

    public static class SingleUse
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="currency")
        String currency;

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SingleUse)) {
                return false;
            }
            SingleUse other = (SingleUse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            return !(this$currency == null ? other$currency != null : !this$currency.equals(other$currency));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SingleUse;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            return result;
        }
    }
}

