/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.PaymentMethodConfigurationCollection;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.PaymentMethodConfigurationCreateParams;
import com.stripe.param.PaymentMethodConfigurationListParams;
import com.stripe.param.PaymentMethodConfigurationRetrieveParams;
import com.stripe.param.PaymentMethodConfigurationUpdateParams;
import java.util.Map;
import lombok.Generated;

public class PaymentMethodConfiguration
extends ApiResource
implements HasId {
    @SerializedName(value="acss_debit")
    AcssDebit acssDebit;
    @SerializedName(value="active")
    Boolean active;
    @SerializedName(value="affirm")
    Affirm affirm;
    @SerializedName(value="afterpay_clearpay")
    AfterpayClearpay afterpayClearpay;
    @SerializedName(value="alipay")
    Alipay alipay;
    @SerializedName(value="apple_pay")
    ApplePay applePay;
    @SerializedName(value="application")
    String application;
    @SerializedName(value="au_becs_debit")
    AuBecsDebit auBecsDebit;
    @SerializedName(value="bacs_debit")
    BacsDebit bacsDebit;
    @SerializedName(value="bancontact")
    Bancontact bancontact;
    @SerializedName(value="blik")
    Blik blik;
    @SerializedName(value="boleto")
    Boleto boleto;
    @SerializedName(value="card")
    Card card;
    @SerializedName(value="cartes_bancaires")
    CartesBancaires cartesBancaires;
    @SerializedName(value="cashapp")
    Cashapp cashapp;
    @SerializedName(value="eps")
    Eps eps;
    @SerializedName(value="fpx")
    Fpx fpx;
    @SerializedName(value="giropay")
    Giropay giropay;
    @SerializedName(value="google_pay")
    GooglePay googlePay;
    @SerializedName(value="grabpay")
    Grabpay grabpay;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="id_bank_transfer")
    IdBankTransfer idBankTransfer;
    @SerializedName(value="ideal")
    Ideal ideal;
    @SerializedName(value="is_default")
    Boolean isDefault;
    @SerializedName(value="jcb")
    Jcb jcb;
    @SerializedName(value="klarna")
    Klarna klarna;
    @SerializedName(value="konbini")
    Konbini konbini;
    @SerializedName(value="link")
    Link link;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="multibanco")
    Multibanco multibanco;
    @SerializedName(value="name")
    String name;
    @SerializedName(value="netbanking")
    Netbanking netbanking;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="oxxo")
    Oxxo oxxo;
    @SerializedName(value="p24")
    P24 p24;
    @SerializedName(value="parent")
    String parent;
    @SerializedName(value="pay_by_bank")
    PayByBank payByBank;
    @SerializedName(value="paynow")
    Paynow paynow;
    @SerializedName(value="paypal")
    Paypal paypal;
    @SerializedName(value="promptpay")
    Promptpay promptpay;
    @SerializedName(value="sepa_debit")
    SepaDebit sepaDebit;
    @SerializedName(value="sofort")
    Sofort sofort;
    @SerializedName(value="upi")
    Upi upi;
    @SerializedName(value="us_bank_account")
    UsBankAccount usBankAccount;
    @SerializedName(value="wechat_pay")
    WechatPay wechatPay;

    public static PaymentMethodConfiguration create(Map<String, Object> params) throws StripeException {
        return PaymentMethodConfiguration.create(params, (RequestOptions)null);
    }

    public static PaymentMethodConfiguration create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/payment_method_configurations");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentMethodConfiguration.class, options);
    }

    public static PaymentMethodConfiguration create(PaymentMethodConfigurationCreateParams params) throws StripeException {
        return PaymentMethodConfiguration.create(params, (RequestOptions)null);
    }

    public static PaymentMethodConfiguration create(PaymentMethodConfigurationCreateParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/payment_method_configurations");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentMethodConfiguration.class, options);
    }

    public static PaymentMethodConfigurationCollection list(Map<String, Object> params) throws StripeException {
        return PaymentMethodConfiguration.list(params, (RequestOptions)null);
    }

    public static PaymentMethodConfigurationCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/payment_method_configurations");
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, PaymentMethodConfigurationCollection.class, options);
    }

    public static PaymentMethodConfigurationCollection list(PaymentMethodConfigurationListParams params) throws StripeException {
        return PaymentMethodConfiguration.list(params, (RequestOptions)null);
    }

    public static PaymentMethodConfigurationCollection list(PaymentMethodConfigurationListParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/payment_method_configurations");
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, PaymentMethodConfigurationCollection.class, options);
    }

    public static PaymentMethodConfiguration retrieve(String configuration) throws StripeException {
        return PaymentMethodConfiguration.retrieve(configuration, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static PaymentMethodConfiguration retrieve(String configuration, RequestOptions options) throws StripeException {
        return PaymentMethodConfiguration.retrieve(configuration, (Map<String, Object>)null, options);
    }

    public static PaymentMethodConfiguration retrieve(String configuration, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/payment_method_configurations/%s", ApiResource.urlEncodeId(configuration)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, PaymentMethodConfiguration.class, options);
    }

    public static PaymentMethodConfiguration retrieve(String configuration, PaymentMethodConfigurationRetrieveParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/payment_method_configurations/%s", ApiResource.urlEncodeId(configuration)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, PaymentMethodConfiguration.class, options);
    }

    public PaymentMethodConfiguration update(Map<String, Object> params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public PaymentMethodConfiguration update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/payment_method_configurations/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentMethodConfiguration.class, options);
    }

    public PaymentMethodConfiguration update(PaymentMethodConfigurationUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public PaymentMethodConfiguration update(PaymentMethodConfigurationUpdateParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/payment_method_configurations/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentMethodConfiguration.class, options);
    }

    @Generated
    public AcssDebit getAcssDebit() {
        return this.acssDebit;
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public Affirm getAffirm() {
        return this.affirm;
    }

    @Generated
    public AfterpayClearpay getAfterpayClearpay() {
        return this.afterpayClearpay;
    }

    @Generated
    public Alipay getAlipay() {
        return this.alipay;
    }

    @Generated
    public ApplePay getApplePay() {
        return this.applePay;
    }

    @Generated
    public String getApplication() {
        return this.application;
    }

    @Generated
    public AuBecsDebit getAuBecsDebit() {
        return this.auBecsDebit;
    }

    @Generated
    public BacsDebit getBacsDebit() {
        return this.bacsDebit;
    }

    @Generated
    public Bancontact getBancontact() {
        return this.bancontact;
    }

    @Generated
    public Blik getBlik() {
        return this.blik;
    }

    @Generated
    public Boleto getBoleto() {
        return this.boleto;
    }

    @Generated
    public Card getCard() {
        return this.card;
    }

    @Generated
    public CartesBancaires getCartesBancaires() {
        return this.cartesBancaires;
    }

    @Generated
    public Cashapp getCashapp() {
        return this.cashapp;
    }

    @Generated
    public Eps getEps() {
        return this.eps;
    }

    @Generated
    public Fpx getFpx() {
        return this.fpx;
    }

    @Generated
    public Giropay getGiropay() {
        return this.giropay;
    }

    @Generated
    public GooglePay getGooglePay() {
        return this.googlePay;
    }

    @Generated
    public Grabpay getGrabpay() {
        return this.grabpay;
    }

    @Generated
    public IdBankTransfer getIdBankTransfer() {
        return this.idBankTransfer;
    }

    @Generated
    public Ideal getIdeal() {
        return this.ideal;
    }

    @Generated
    public Boolean getIsDefault() {
        return this.isDefault;
    }

    @Generated
    public Jcb getJcb() {
        return this.jcb;
    }

    @Generated
    public Klarna getKlarna() {
        return this.klarna;
    }

    @Generated
    public Konbini getKonbini() {
        return this.konbini;
    }

    @Generated
    public Link getLink() {
        return this.link;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public Multibanco getMultibanco() {
        return this.multibanco;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Netbanking getNetbanking() {
        return this.netbanking;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Oxxo getOxxo() {
        return this.oxxo;
    }

    @Generated
    public P24 getP24() {
        return this.p24;
    }

    @Generated
    public String getParent() {
        return this.parent;
    }

    @Generated
    public PayByBank getPayByBank() {
        return this.payByBank;
    }

    @Generated
    public Paynow getPaynow() {
        return this.paynow;
    }

    @Generated
    public Paypal getPaypal() {
        return this.paypal;
    }

    @Generated
    public Promptpay getPromptpay() {
        return this.promptpay;
    }

    @Generated
    public SepaDebit getSepaDebit() {
        return this.sepaDebit;
    }

    @Generated
    public Sofort getSofort() {
        return this.sofort;
    }

    @Generated
    public Upi getUpi() {
        return this.upi;
    }

    @Generated
    public UsBankAccount getUsBankAccount() {
        return this.usBankAccount;
    }

    @Generated
    public WechatPay getWechatPay() {
        return this.wechatPay;
    }

    @Generated
    public void setAcssDebit(AcssDebit acssDebit) {
        this.acssDebit = acssDebit;
    }

    @Generated
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Generated
    public void setAffirm(Affirm affirm) {
        this.affirm = affirm;
    }

    @Generated
    public void setAfterpayClearpay(AfterpayClearpay afterpayClearpay) {
        this.afterpayClearpay = afterpayClearpay;
    }

    @Generated
    public void setAlipay(Alipay alipay) {
        this.alipay = alipay;
    }

    @Generated
    public void setApplePay(ApplePay applePay) {
        this.applePay = applePay;
    }

    @Generated
    public void setApplication(String application) {
        this.application = application;
    }

    @Generated
    public void setAuBecsDebit(AuBecsDebit auBecsDebit) {
        this.auBecsDebit = auBecsDebit;
    }

    @Generated
    public void setBacsDebit(BacsDebit bacsDebit) {
        this.bacsDebit = bacsDebit;
    }

    @Generated
    public void setBancontact(Bancontact bancontact) {
        this.bancontact = bancontact;
    }

    @Generated
    public void setBlik(Blik blik) {
        this.blik = blik;
    }

    @Generated
    public void setBoleto(Boleto boleto) {
        this.boleto = boleto;
    }

    @Generated
    public void setCard(Card card) {
        this.card = card;
    }

    @Generated
    public void setCartesBancaires(CartesBancaires cartesBancaires) {
        this.cartesBancaires = cartesBancaires;
    }

    @Generated
    public void setCashapp(Cashapp cashapp) {
        this.cashapp = cashapp;
    }

    @Generated
    public void setEps(Eps eps) {
        this.eps = eps;
    }

    @Generated
    public void setFpx(Fpx fpx) {
        this.fpx = fpx;
    }

    @Generated
    public void setGiropay(Giropay giropay) {
        this.giropay = giropay;
    }

    @Generated
    public void setGooglePay(GooglePay googlePay) {
        this.googlePay = googlePay;
    }

    @Generated
    public void setGrabpay(Grabpay grabpay) {
        this.grabpay = grabpay;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIdBankTransfer(IdBankTransfer idBankTransfer) {
        this.idBankTransfer = idBankTransfer;
    }

    @Generated
    public void setIdeal(Ideal ideal) {
        this.ideal = ideal;
    }

    @Generated
    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    @Generated
    public void setJcb(Jcb jcb) {
        this.jcb = jcb;
    }

    @Generated
    public void setKlarna(Klarna klarna) {
        this.klarna = klarna;
    }

    @Generated
    public void setKonbini(Konbini konbini) {
        this.konbini = konbini;
    }

    @Generated
    public void setLink(Link link) {
        this.link = link;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMultibanco(Multibanco multibanco) {
        this.multibanco = multibanco;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setNetbanking(Netbanking netbanking) {
        this.netbanking = netbanking;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setOxxo(Oxxo oxxo) {
        this.oxxo = oxxo;
    }

    @Generated
    public void setP24(P24 p24) {
        this.p24 = p24;
    }

    @Generated
    public void setParent(String parent) {
        this.parent = parent;
    }

    @Generated
    public void setPayByBank(PayByBank payByBank) {
        this.payByBank = payByBank;
    }

    @Generated
    public void setPaynow(Paynow paynow) {
        this.paynow = paynow;
    }

    @Generated
    public void setPaypal(Paypal paypal) {
        this.paypal = paypal;
    }

    @Generated
    public void setPromptpay(Promptpay promptpay) {
        this.promptpay = promptpay;
    }

    @Generated
    public void setSepaDebit(SepaDebit sepaDebit) {
        this.sepaDebit = sepaDebit;
    }

    @Generated
    public void setSofort(Sofort sofort) {
        this.sofort = sofort;
    }

    @Generated
    public void setUpi(Upi upi) {
        this.upi = upi;
    }

    @Generated
    public void setUsBankAccount(UsBankAccount usBankAccount) {
        this.usBankAccount = usBankAccount;
    }

    @Generated
    public void setWechatPay(WechatPay wechatPay) {
        this.wechatPay = wechatPay;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentMethodConfiguration)) {
            return false;
        }
        PaymentMethodConfiguration other = (PaymentMethodConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Boolean this$isDefault = this.getIsDefault();
        Boolean other$isDefault = other.getIsDefault();
        if (this$isDefault == null ? other$isDefault != null : !((Object)this$isDefault).equals(other$isDefault)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        AcssDebit this$acssDebit = this.getAcssDebit();
        AcssDebit other$acssDebit = other.getAcssDebit();
        if (this$acssDebit == null ? other$acssDebit != null : !((Object)this$acssDebit).equals(other$acssDebit)) {
            return false;
        }
        Affirm this$affirm = this.getAffirm();
        Affirm other$affirm = other.getAffirm();
        if (this$affirm == null ? other$affirm != null : !((Object)this$affirm).equals(other$affirm)) {
            return false;
        }
        AfterpayClearpay this$afterpayClearpay = this.getAfterpayClearpay();
        AfterpayClearpay other$afterpayClearpay = other.getAfterpayClearpay();
        if (this$afterpayClearpay == null ? other$afterpayClearpay != null : !((Object)this$afterpayClearpay).equals(other$afterpayClearpay)) {
            return false;
        }
        Alipay this$alipay = this.getAlipay();
        Alipay other$alipay = other.getAlipay();
        if (this$alipay == null ? other$alipay != null : !((Object)this$alipay).equals(other$alipay)) {
            return false;
        }
        ApplePay this$applePay = this.getApplePay();
        ApplePay other$applePay = other.getApplePay();
        if (this$applePay == null ? other$applePay != null : !((Object)this$applePay).equals(other$applePay)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        AuBecsDebit this$auBecsDebit = this.getAuBecsDebit();
        AuBecsDebit other$auBecsDebit = other.getAuBecsDebit();
        if (this$auBecsDebit == null ? other$auBecsDebit != null : !((Object)this$auBecsDebit).equals(other$auBecsDebit)) {
            return false;
        }
        BacsDebit this$bacsDebit = this.getBacsDebit();
        BacsDebit other$bacsDebit = other.getBacsDebit();
        if (this$bacsDebit == null ? other$bacsDebit != null : !((Object)this$bacsDebit).equals(other$bacsDebit)) {
            return false;
        }
        Bancontact this$bancontact = this.getBancontact();
        Bancontact other$bancontact = other.getBancontact();
        if (this$bancontact == null ? other$bancontact != null : !((Object)this$bancontact).equals(other$bancontact)) {
            return false;
        }
        Blik this$blik = this.getBlik();
        Blik other$blik = other.getBlik();
        if (this$blik == null ? other$blik != null : !((Object)this$blik).equals(other$blik)) {
            return false;
        }
        Boleto this$boleto = this.getBoleto();
        Boleto other$boleto = other.getBoleto();
        if (this$boleto == null ? other$boleto != null : !((Object)this$boleto).equals(other$boleto)) {
            return false;
        }
        Card this$card = this.getCard();
        Card other$card = other.getCard();
        if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
            return false;
        }
        CartesBancaires this$cartesBancaires = this.getCartesBancaires();
        CartesBancaires other$cartesBancaires = other.getCartesBancaires();
        if (this$cartesBancaires == null ? other$cartesBancaires != null : !((Object)this$cartesBancaires).equals(other$cartesBancaires)) {
            return false;
        }
        Cashapp this$cashapp = this.getCashapp();
        Cashapp other$cashapp = other.getCashapp();
        if (this$cashapp == null ? other$cashapp != null : !((Object)this$cashapp).equals(other$cashapp)) {
            return false;
        }
        Eps this$eps = this.getEps();
        Eps other$eps = other.getEps();
        if (this$eps == null ? other$eps != null : !((Object)this$eps).equals(other$eps)) {
            return false;
        }
        Fpx this$fpx = this.getFpx();
        Fpx other$fpx = other.getFpx();
        if (this$fpx == null ? other$fpx != null : !((Object)this$fpx).equals(other$fpx)) {
            return false;
        }
        Giropay this$giropay = this.getGiropay();
        Giropay other$giropay = other.getGiropay();
        if (this$giropay == null ? other$giropay != null : !((Object)this$giropay).equals(other$giropay)) {
            return false;
        }
        GooglePay this$googlePay = this.getGooglePay();
        GooglePay other$googlePay = other.getGooglePay();
        if (this$googlePay == null ? other$googlePay != null : !((Object)this$googlePay).equals(other$googlePay)) {
            return false;
        }
        Grabpay this$grabpay = this.getGrabpay();
        Grabpay other$grabpay = other.getGrabpay();
        if (this$grabpay == null ? other$grabpay != null : !((Object)this$grabpay).equals(other$grabpay)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        IdBankTransfer this$idBankTransfer = this.getIdBankTransfer();
        IdBankTransfer other$idBankTransfer = other.getIdBankTransfer();
        if (this$idBankTransfer == null ? other$idBankTransfer != null : !((Object)this$idBankTransfer).equals(other$idBankTransfer)) {
            return false;
        }
        Ideal this$ideal = this.getIdeal();
        Ideal other$ideal = other.getIdeal();
        if (this$ideal == null ? other$ideal != null : !((Object)this$ideal).equals(other$ideal)) {
            return false;
        }
        Jcb this$jcb = this.getJcb();
        Jcb other$jcb = other.getJcb();
        if (this$jcb == null ? other$jcb != null : !((Object)this$jcb).equals(other$jcb)) {
            return false;
        }
        Klarna this$klarna = this.getKlarna();
        Klarna other$klarna = other.getKlarna();
        if (this$klarna == null ? other$klarna != null : !((Object)this$klarna).equals(other$klarna)) {
            return false;
        }
        Konbini this$konbini = this.getKonbini();
        Konbini other$konbini = other.getKonbini();
        if (this$konbini == null ? other$konbini != null : !((Object)this$konbini).equals(other$konbini)) {
            return false;
        }
        Link this$link = this.getLink();
        Link other$link = other.getLink();
        if (this$link == null ? other$link != null : !((Object)this$link).equals(other$link)) {
            return false;
        }
        Multibanco this$multibanco = this.getMultibanco();
        Multibanco other$multibanco = other.getMultibanco();
        if (this$multibanco == null ? other$multibanco != null : !((Object)this$multibanco).equals(other$multibanco)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Netbanking this$netbanking = this.getNetbanking();
        Netbanking other$netbanking = other.getNetbanking();
        if (this$netbanking == null ? other$netbanking != null : !((Object)this$netbanking).equals(other$netbanking)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Oxxo this$oxxo = this.getOxxo();
        Oxxo other$oxxo = other.getOxxo();
        if (this$oxxo == null ? other$oxxo != null : !((Object)this$oxxo).equals(other$oxxo)) {
            return false;
        }
        P24 this$p24 = this.getP24();
        P24 other$p24 = other.getP24();
        if (this$p24 == null ? other$p24 != null : !((Object)this$p24).equals(other$p24)) {
            return false;
        }
        String this$parent = this.getParent();
        String other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !this$parent.equals(other$parent)) {
            return false;
        }
        PayByBank this$payByBank = this.getPayByBank();
        PayByBank other$payByBank = other.getPayByBank();
        if (this$payByBank == null ? other$payByBank != null : !((Object)this$payByBank).equals(other$payByBank)) {
            return false;
        }
        Paynow this$paynow = this.getPaynow();
        Paynow other$paynow = other.getPaynow();
        if (this$paynow == null ? other$paynow != null : !((Object)this$paynow).equals(other$paynow)) {
            return false;
        }
        Paypal this$paypal = this.getPaypal();
        Paypal other$paypal = other.getPaypal();
        if (this$paypal == null ? other$paypal != null : !((Object)this$paypal).equals(other$paypal)) {
            return false;
        }
        Promptpay this$promptpay = this.getPromptpay();
        Promptpay other$promptpay = other.getPromptpay();
        if (this$promptpay == null ? other$promptpay != null : !((Object)this$promptpay).equals(other$promptpay)) {
            return false;
        }
        SepaDebit this$sepaDebit = this.getSepaDebit();
        SepaDebit other$sepaDebit = other.getSepaDebit();
        if (this$sepaDebit == null ? other$sepaDebit != null : !((Object)this$sepaDebit).equals(other$sepaDebit)) {
            return false;
        }
        Sofort this$sofort = this.getSofort();
        Sofort other$sofort = other.getSofort();
        if (this$sofort == null ? other$sofort != null : !((Object)this$sofort).equals(other$sofort)) {
            return false;
        }
        Upi this$upi = this.getUpi();
        Upi other$upi = other.getUpi();
        if (this$upi == null ? other$upi != null : !((Object)this$upi).equals(other$upi)) {
            return false;
        }
        UsBankAccount this$usBankAccount = this.getUsBankAccount();
        UsBankAccount other$usBankAccount = other.getUsBankAccount();
        if (this$usBankAccount == null ? other$usBankAccount != null : !((Object)this$usBankAccount).equals(other$usBankAccount)) {
            return false;
        }
        WechatPay this$wechatPay = this.getWechatPay();
        WechatPay other$wechatPay = other.getWechatPay();
        return !(this$wechatPay == null ? other$wechatPay != null : !((Object)this$wechatPay).equals(other$wechatPay));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PaymentMethodConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Boolean $isDefault = this.getIsDefault();
        result = result * 59 + ($isDefault == null ? 43 : ((Object)$isDefault).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        AcssDebit $acssDebit = this.getAcssDebit();
        result = result * 59 + ($acssDebit == null ? 43 : ((Object)$acssDebit).hashCode());
        Affirm $affirm = this.getAffirm();
        result = result * 59 + ($affirm == null ? 43 : ((Object)$affirm).hashCode());
        AfterpayClearpay $afterpayClearpay = this.getAfterpayClearpay();
        result = result * 59 + ($afterpayClearpay == null ? 43 : ((Object)$afterpayClearpay).hashCode());
        Alipay $alipay = this.getAlipay();
        result = result * 59 + ($alipay == null ? 43 : ((Object)$alipay).hashCode());
        ApplePay $applePay = this.getApplePay();
        result = result * 59 + ($applePay == null ? 43 : ((Object)$applePay).hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        AuBecsDebit $auBecsDebit = this.getAuBecsDebit();
        result = result * 59 + ($auBecsDebit == null ? 43 : ((Object)$auBecsDebit).hashCode());
        BacsDebit $bacsDebit = this.getBacsDebit();
        result = result * 59 + ($bacsDebit == null ? 43 : ((Object)$bacsDebit).hashCode());
        Bancontact $bancontact = this.getBancontact();
        result = result * 59 + ($bancontact == null ? 43 : ((Object)$bancontact).hashCode());
        Blik $blik = this.getBlik();
        result = result * 59 + ($blik == null ? 43 : ((Object)$blik).hashCode());
        Boleto $boleto = this.getBoleto();
        result = result * 59 + ($boleto == null ? 43 : ((Object)$boleto).hashCode());
        Card $card = this.getCard();
        result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
        CartesBancaires $cartesBancaires = this.getCartesBancaires();
        result = result * 59 + ($cartesBancaires == null ? 43 : ((Object)$cartesBancaires).hashCode());
        Cashapp $cashapp = this.getCashapp();
        result = result * 59 + ($cashapp == null ? 43 : ((Object)$cashapp).hashCode());
        Eps $eps = this.getEps();
        result = result * 59 + ($eps == null ? 43 : ((Object)$eps).hashCode());
        Fpx $fpx = this.getFpx();
        result = result * 59 + ($fpx == null ? 43 : ((Object)$fpx).hashCode());
        Giropay $giropay = this.getGiropay();
        result = result * 59 + ($giropay == null ? 43 : ((Object)$giropay).hashCode());
        GooglePay $googlePay = this.getGooglePay();
        result = result * 59 + ($googlePay == null ? 43 : ((Object)$googlePay).hashCode());
        Grabpay $grabpay = this.getGrabpay();
        result = result * 59 + ($grabpay == null ? 43 : ((Object)$grabpay).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        IdBankTransfer $idBankTransfer = this.getIdBankTransfer();
        result = result * 59 + ($idBankTransfer == null ? 43 : ((Object)$idBankTransfer).hashCode());
        Ideal $ideal = this.getIdeal();
        result = result * 59 + ($ideal == null ? 43 : ((Object)$ideal).hashCode());
        Jcb $jcb = this.getJcb();
        result = result * 59 + ($jcb == null ? 43 : ((Object)$jcb).hashCode());
        Klarna $klarna = this.getKlarna();
        result = result * 59 + ($klarna == null ? 43 : ((Object)$klarna).hashCode());
        Konbini $konbini = this.getKonbini();
        result = result * 59 + ($konbini == null ? 43 : ((Object)$konbini).hashCode());
        Link $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : ((Object)$link).hashCode());
        Multibanco $multibanco = this.getMultibanco();
        result = result * 59 + ($multibanco == null ? 43 : ((Object)$multibanco).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Netbanking $netbanking = this.getNetbanking();
        result = result * 59 + ($netbanking == null ? 43 : ((Object)$netbanking).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Oxxo $oxxo = this.getOxxo();
        result = result * 59 + ($oxxo == null ? 43 : ((Object)$oxxo).hashCode());
        P24 $p24 = this.getP24();
        result = result * 59 + ($p24 == null ? 43 : ((Object)$p24).hashCode());
        String $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
        PayByBank $payByBank = this.getPayByBank();
        result = result * 59 + ($payByBank == null ? 43 : ((Object)$payByBank).hashCode());
        Paynow $paynow = this.getPaynow();
        result = result * 59 + ($paynow == null ? 43 : ((Object)$paynow).hashCode());
        Paypal $paypal = this.getPaypal();
        result = result * 59 + ($paypal == null ? 43 : ((Object)$paypal).hashCode());
        Promptpay $promptpay = this.getPromptpay();
        result = result * 59 + ($promptpay == null ? 43 : ((Object)$promptpay).hashCode());
        SepaDebit $sepaDebit = this.getSepaDebit();
        result = result * 59 + ($sepaDebit == null ? 43 : ((Object)$sepaDebit).hashCode());
        Sofort $sofort = this.getSofort();
        result = result * 59 + ($sofort == null ? 43 : ((Object)$sofort).hashCode());
        Upi $upi = this.getUpi();
        result = result * 59 + ($upi == null ? 43 : ((Object)$upi).hashCode());
        UsBankAccount $usBankAccount = this.getUsBankAccount();
        result = result * 59 + ($usBankAccount == null ? 43 : ((Object)$usBankAccount).hashCode());
        WechatPay $wechatPay = this.getWechatPay();
        result = result * 59 + ($wechatPay == null ? 43 : ((Object)$wechatPay).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class AcssDebit
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AcssDebit)) {
                return false;
            }
            AcssDebit other = (AcssDebit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AcssDebit;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Affirm
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Affirm)) {
                return false;
            }
            Affirm other = (Affirm)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Affirm;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class AfterpayClearpay
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AfterpayClearpay)) {
                return false;
            }
            AfterpayClearpay other = (AfterpayClearpay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AfterpayClearpay;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Alipay
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Alipay)) {
                return false;
            }
            Alipay other = (Alipay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Alipay;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class ApplePay
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApplePay)) {
                return false;
            }
            ApplePay other = (ApplePay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ApplePay;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class AuBecsDebit
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AuBecsDebit)) {
                return false;
            }
            AuBecsDebit other = (AuBecsDebit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AuBecsDebit;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class BacsDebit
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BacsDebit)) {
                return false;
            }
            BacsDebit other = (BacsDebit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BacsDebit;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Bancontact
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Bancontact)) {
                return false;
            }
            Bancontact other = (Bancontact)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Bancontact;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Blik
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Blik)) {
                return false;
            }
            Blik other = (Blik)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Blik;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Boleto
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Boleto)) {
                return false;
            }
            Boleto other = (Boleto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Boleto;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Card
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Card)) {
                return false;
            }
            Card other = (Card)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Card;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class CartesBancaires
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CartesBancaires)) {
                return false;
            }
            CartesBancaires other = (CartesBancaires)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CartesBancaires;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Cashapp
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Cashapp)) {
                return false;
            }
            Cashapp other = (Cashapp)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Cashapp;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Eps
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Eps)) {
                return false;
            }
            Eps other = (Eps)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Eps;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Fpx
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Fpx)) {
                return false;
            }
            Fpx other = (Fpx)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Fpx;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Giropay
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Giropay)) {
                return false;
            }
            Giropay other = (Giropay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Giropay;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class GooglePay
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GooglePay)) {
                return false;
            }
            GooglePay other = (GooglePay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof GooglePay;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Grabpay
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Grabpay)) {
                return false;
            }
            Grabpay other = (Grabpay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Grabpay;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class IdBankTransfer
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IdBankTransfer)) {
                return false;
            }
            IdBankTransfer other = (IdBankTransfer)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof IdBankTransfer;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Ideal
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ideal)) {
                return false;
            }
            Ideal other = (Ideal)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Ideal;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Jcb
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Jcb)) {
                return false;
            }
            Jcb other = (Jcb)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Jcb;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Klarna
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Klarna)) {
                return false;
            }
            Klarna other = (Klarna)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Klarna;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Konbini
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Konbini)) {
                return false;
            }
            Konbini other = (Konbini)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Konbini;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Link
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Link)) {
                return false;
            }
            Link other = (Link)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Link;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Multibanco
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Multibanco)) {
                return false;
            }
            Multibanco other = (Multibanco)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Multibanco;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Netbanking
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Netbanking)) {
                return false;
            }
            Netbanking other = (Netbanking)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Netbanking;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Oxxo
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Oxxo)) {
                return false;
            }
            Oxxo other = (Oxxo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Oxxo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class P24
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof P24)) {
                return false;
            }
            P24 other = (P24)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof P24;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class PayByBank
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PayByBank)) {
                return false;
            }
            PayByBank other = (PayByBank)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PayByBank;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Paynow
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Paynow)) {
                return false;
            }
            Paynow other = (Paynow)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Paynow;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Paypal
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Paypal)) {
                return false;
            }
            Paypal other = (Paypal)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Paypal;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Promptpay
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Promptpay)) {
                return false;
            }
            Promptpay other = (Promptpay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Promptpay;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class SepaDebit
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SepaDebit)) {
                return false;
            }
            SepaDebit other = (SepaDebit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SepaDebit;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Sofort
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Sofort)) {
                return false;
            }
            Sofort other = (Sofort)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Sofort;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Upi
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Upi)) {
                return false;
            }
            Upi other = (Upi)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Upi;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class UsBankAccount
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UsBankAccount)) {
                return false;
            }
            UsBankAccount other = (UsBankAccount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UsBankAccount;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class WechatPay
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WechatPay)) {
                return false;
            }
            WechatPay other = (WechatPay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WechatPay;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }
}

