/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import com.stripe.param.common.EmptyParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class QuoteCreateParams
extends ApiRequestParams {
    @SerializedName(value="application_fee_amount")
    Object applicationFeeAmount;
    @SerializedName(value="application_fee_percent")
    Object applicationFeePercent;
    @SerializedName(value="automatic_tax")
    AutomaticTax automaticTax;
    @SerializedName(value="collection_method")
    CollectionMethod collectionMethod;
    @SerializedName(value="customer")
    String customer;
    @SerializedName(value="default_tax_rates")
    Object defaultTaxRates;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="discounts")
    Object discounts;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="expires_at")
    Long expiresAt;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="footer")
    String footer;
    @SerializedName(value="from_quote")
    FromQuote fromQuote;
    @SerializedName(value="header")
    String header;
    @SerializedName(value="invoice_settings")
    InvoiceSettings invoiceSettings;
    @SerializedName(value="line_items")
    List<LineItem> lineItems;
    @SerializedName(value="lines")
    List<Line> lines;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="on_behalf_of")
    Object onBehalfOf;
    @SerializedName(value="phases")
    List<Phase> phases;
    @SerializedName(value="subscription_data")
    SubscriptionData subscriptionData;
    @SerializedName(value="subscription_data_overrides")
    List<SubscriptionDataOverride> subscriptionDataOverrides;
    @SerializedName(value="test_clock")
    String testClock;
    @SerializedName(value="transfer_data")
    Object transferData;

    private QuoteCreateParams(Object applicationFeeAmount, Object applicationFeePercent, AutomaticTax automaticTax, CollectionMethod collectionMethod, String customer, Object defaultTaxRates, String description, Object discounts, List<String> expand, Long expiresAt, Map<String, Object> extraParams, String footer, FromQuote fromQuote, String header, InvoiceSettings invoiceSettings, List<LineItem> lineItems, List<Line> lines, Map<String, String> metadata, Object onBehalfOf, List<Phase> phases, SubscriptionData subscriptionData, List<SubscriptionDataOverride> subscriptionDataOverrides, String testClock, Object transferData) {
        this.applicationFeeAmount = applicationFeeAmount;
        this.applicationFeePercent = applicationFeePercent;
        this.automaticTax = automaticTax;
        this.collectionMethod = collectionMethod;
        this.customer = customer;
        this.defaultTaxRates = defaultTaxRates;
        this.description = description;
        this.discounts = discounts;
        this.expand = expand;
        this.expiresAt = expiresAt;
        this.extraParams = extraParams;
        this.footer = footer;
        this.fromQuote = fromQuote;
        this.header = header;
        this.invoiceSettings = invoiceSettings;
        this.lineItems = lineItems;
        this.lines = lines;
        this.metadata = metadata;
        this.onBehalfOf = onBehalfOf;
        this.phases = phases;
        this.subscriptionData = subscriptionData;
        this.subscriptionDataOverrides = subscriptionDataOverrides;
        this.testClock = testClock;
        this.transferData = transferData;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Object getApplicationFeeAmount() {
        return this.applicationFeeAmount;
    }

    @Generated
    public Object getApplicationFeePercent() {
        return this.applicationFeePercent;
    }

    @Generated
    public AutomaticTax getAutomaticTax() {
        return this.automaticTax;
    }

    @Generated
    public CollectionMethod getCollectionMethod() {
        return this.collectionMethod;
    }

    @Generated
    public String getCustomer() {
        return this.customer;
    }

    @Generated
    public Object getDefaultTaxRates() {
        return this.defaultTaxRates;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Object getDiscounts() {
        return this.discounts;
    }

    @Generated
    public List<String> getExpand() {
        return this.expand;
    }

    @Generated
    public Long getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public Map<String, Object> getExtraParams() {
        return this.extraParams;
    }

    @Generated
    public String getFooter() {
        return this.footer;
    }

    @Generated
    public FromQuote getFromQuote() {
        return this.fromQuote;
    }

    @Generated
    public String getHeader() {
        return this.header;
    }

    @Generated
    public InvoiceSettings getInvoiceSettings() {
        return this.invoiceSettings;
    }

    @Generated
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    @Generated
    public List<Line> getLines() {
        return this.lines;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public Object getOnBehalfOf() {
        return this.onBehalfOf;
    }

    @Generated
    public List<Phase> getPhases() {
        return this.phases;
    }

    @Generated
    public SubscriptionData getSubscriptionData() {
        return this.subscriptionData;
    }

    @Generated
    public List<SubscriptionDataOverride> getSubscriptionDataOverrides() {
        return this.subscriptionDataOverrides;
    }

    @Generated
    public String getTestClock() {
        return this.testClock;
    }

    @Generated
    public Object getTransferData() {
        return this.transferData;
    }

    public static class AutomaticTax {
        @SerializedName(value="enabled")
        Boolean enabled;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;

        private AutomaticTax(Boolean enabled, Map<String, Object> extraParams) {
            this.enabled = enabled;
            this.extraParams = extraParams;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        public static class Builder {
            private Boolean enabled;
            private Map<String, Object> extraParams;

            public AutomaticTax build() {
                return new AutomaticTax(this.enabled, this.extraParams);
            }

            public Builder setEnabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }
        }
    }

    public static enum CollectionMethod implements ApiRequestParams.EnumParam
    {
        CHARGE_AUTOMATICALLY("charge_automatically"),
        SEND_INVOICE("send_invoice");

        private final String value;

        private CollectionMethod(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class FromQuote {
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="is_revision")
        Boolean isRevision;
        @SerializedName(value="quote")
        String quote;

        private FromQuote(Map<String, Object> extraParams, Boolean isRevision, String quote) {
            this.extraParams = extraParams;
            this.isRevision = isRevision;
            this.quote = quote;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Boolean getIsRevision() {
            return this.isRevision;
        }

        @Generated
        public String getQuote() {
            return this.quote;
        }

        public static class Builder {
            private Map<String, Object> extraParams;
            private Boolean isRevision;
            private String quote;

            public FromQuote build() {
                return new FromQuote(this.extraParams, this.isRevision, this.quote);
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setIsRevision(Boolean isRevision) {
                this.isRevision = isRevision;
                return this;
            }

            public Builder setQuote(String quote) {
                this.quote = quote;
                return this;
            }
        }
    }

    public static class InvoiceSettings {
        @SerializedName(value="days_until_due")
        Long daysUntilDue;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;

        private InvoiceSettings(Long daysUntilDue, Map<String, Object> extraParams) {
            this.daysUntilDue = daysUntilDue;
            this.extraParams = extraParams;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Long getDaysUntilDue() {
            return this.daysUntilDue;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        public static class Builder {
            private Long daysUntilDue;
            private Map<String, Object> extraParams;

            public InvoiceSettings build() {
                return new InvoiceSettings(this.daysUntilDue, this.extraParams);
            }

            public Builder setDaysUntilDue(Long daysUntilDue) {
                this.daysUntilDue = daysUntilDue;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }
        }
    }

    public static class SubscriptionData {
        @SerializedName(value="bill_on_acceptance")
        BillOnAcceptance billOnAcceptance;
        @SerializedName(value="billing_behavior")
        BillingBehavior billingBehavior;
        @SerializedName(value="billing_cycle_anchor")
        ApiRequestParams.EnumParam billingCycleAnchor;
        @SerializedName(value="description")
        String description;
        @SerializedName(value="effective_date")
        Object effectiveDate;
        @SerializedName(value="end_behavior")
        EndBehavior endBehavior;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="from_schedule")
        String fromSchedule;
        @SerializedName(value="from_subscription")
        String fromSubscription;
        @SerializedName(value="prebilling")
        Object prebilling;
        @SerializedName(value="proration_behavior")
        ProrationBehavior prorationBehavior;
        @SerializedName(value="trial_period_days")
        Object trialPeriodDays;

        private SubscriptionData(BillOnAcceptance billOnAcceptance, BillingBehavior billingBehavior, ApiRequestParams.EnumParam billingCycleAnchor, String description, Object effectiveDate, EndBehavior endBehavior, Map<String, Object> extraParams, String fromSchedule, String fromSubscription, Object prebilling, ProrationBehavior prorationBehavior, Object trialPeriodDays) {
            this.billOnAcceptance = billOnAcceptance;
            this.billingBehavior = billingBehavior;
            this.billingCycleAnchor = billingCycleAnchor;
            this.description = description;
            this.effectiveDate = effectiveDate;
            this.endBehavior = endBehavior;
            this.extraParams = extraParams;
            this.fromSchedule = fromSchedule;
            this.fromSubscription = fromSubscription;
            this.prebilling = prebilling;
            this.prorationBehavior = prorationBehavior;
            this.trialPeriodDays = trialPeriodDays;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public BillOnAcceptance getBillOnAcceptance() {
            return this.billOnAcceptance;
        }

        @Generated
        public BillingBehavior getBillingBehavior() {
            return this.billingBehavior;
        }

        @Generated
        public ApiRequestParams.EnumParam getBillingCycleAnchor() {
            return this.billingCycleAnchor;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public Object getEffectiveDate() {
            return this.effectiveDate;
        }

        @Generated
        public EndBehavior getEndBehavior() {
            return this.endBehavior;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public String getFromSchedule() {
            return this.fromSchedule;
        }

        @Generated
        public String getFromSubscription() {
            return this.fromSubscription;
        }

        @Generated
        public Object getPrebilling() {
            return this.prebilling;
        }

        @Generated
        public ProrationBehavior getProrationBehavior() {
            return this.prorationBehavior;
        }

        @Generated
        public Object getTrialPeriodDays() {
            return this.trialPeriodDays;
        }

        public static class BillOnAcceptance {
            @SerializedName(value="bill_from")
            BillFrom billFrom;
            @SerializedName(value="bill_until")
            BillUntil billUntil;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private BillOnAcceptance(BillFrom billFrom, BillUntil billUntil, Map<String, Object> extraParams) {
                this.billFrom = billFrom;
                this.billUntil = billUntil;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public BillFrom getBillFrom() {
                return this.billFrom;
            }

            @Generated
            public BillUntil getBillUntil() {
                return this.billUntil;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class BillFrom {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="line_starts_at")
                LineStartsAt lineStartsAt;
                @SerializedName(value="timestamp")
                Timestamp timestamp;
                @SerializedName(value="type")
                Type type;

                private BillFrom(Map<String, Object> extraParams, LineStartsAt lineStartsAt, Timestamp timestamp, Type type) {
                    this.extraParams = extraParams;
                    this.lineStartsAt = lineStartsAt;
                    this.timestamp = timestamp;
                    this.type = type;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public LineStartsAt getLineStartsAt() {
                    return this.lineStartsAt;
                }

                @Generated
                public Timestamp getTimestamp() {
                    return this.timestamp;
                }

                @Generated
                public Type getType() {
                    return this.type;
                }

                public static class LineStartsAt {
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="id")
                    String id;
                    @SerializedName(value="index")
                    Long index;

                    private LineStartsAt(Map<String, Object> extraParams, String id, Long index) {
                        this.extraParams = extraParams;
                        this.id = id;
                        this.index = index;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public String getId() {
                        return this.id;
                    }

                    @Generated
                    public Long getIndex() {
                        return this.index;
                    }

                    public static class Builder {
                        private Map<String, Object> extraParams;
                        private String id;
                        private Long index;

                        public LineStartsAt build() {
                            return new LineStartsAt(this.extraParams, this.id, this.index);
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setId(String id) {
                            this.id = id;
                            return this;
                        }

                        public Builder setIndex(Long index) {
                            this.index = index;
                            return this;
                        }
                    }
                }

                public static class Timestamp {
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="timestamp")
                    Long timestamp;

                    private Timestamp(Map<String, Object> extraParams, Long timestamp) {
                        this.extraParams = extraParams;
                        this.timestamp = timestamp;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Long getTimestamp() {
                        return this.timestamp;
                    }

                    public static class Builder {
                        private Map<String, Object> extraParams;
                        private Long timestamp;

                        public Timestamp build() {
                            return new Timestamp(this.extraParams, this.timestamp);
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setTimestamp(Long timestamp) {
                            this.timestamp = timestamp;
                            return this;
                        }
                    }
                }

                public static enum Type implements ApiRequestParams.EnumParam
                {
                    LINE_STARTS_AT("line_starts_at"),
                    NOW("now"),
                    QUOTE_ACCEPTANCE_DATE("quote_acceptance_date"),
                    TIMESTAMP("timestamp");

                    private final String value;

                    private Type(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private LineStartsAt lineStartsAt;
                    private Timestamp timestamp;
                    private Type type;

                    public BillFrom build() {
                        return new BillFrom(this.extraParams, this.lineStartsAt, this.timestamp, this.type);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setLineStartsAt(LineStartsAt lineStartsAt) {
                        this.lineStartsAt = lineStartsAt;
                        return this;
                    }

                    public Builder setTimestamp(Timestamp timestamp) {
                        this.timestamp = timestamp;
                        return this;
                    }

                    public Builder setType(Type type) {
                        this.type = type;
                        return this;
                    }
                }
            }

            public static class BillUntil {
                @SerializedName(value="duration")
                Duration duration;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="line_ends_at")
                LineEndsAt lineEndsAt;
                @SerializedName(value="timestamp")
                Timestamp timestamp;
                @SerializedName(value="type")
                Type type;

                private BillUntil(Duration duration, Map<String, Object> extraParams, LineEndsAt lineEndsAt, Timestamp timestamp, Type type) {
                    this.duration = duration;
                    this.extraParams = extraParams;
                    this.lineEndsAt = lineEndsAt;
                    this.timestamp = timestamp;
                    this.type = type;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Duration getDuration() {
                    return this.duration;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public LineEndsAt getLineEndsAt() {
                    return this.lineEndsAt;
                }

                @Generated
                public Timestamp getTimestamp() {
                    return this.timestamp;
                }

                @Generated
                public Type getType() {
                    return this.type;
                }

                public static class Duration {
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="interval")
                    Interval interval;
                    @SerializedName(value="interval_count")
                    Long intervalCount;

                    private Duration(Map<String, Object> extraParams, Interval interval, Long intervalCount) {
                        this.extraParams = extraParams;
                        this.interval = interval;
                        this.intervalCount = intervalCount;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Interval getInterval() {
                        return this.interval;
                    }

                    @Generated
                    public Long getIntervalCount() {
                        return this.intervalCount;
                    }

                    public static enum Interval implements ApiRequestParams.EnumParam
                    {
                        DAY("day"),
                        MONTH("month"),
                        WEEK("week"),
                        YEAR("year");

                        private final String value;

                        private Interval(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static class Builder {
                        private Map<String, Object> extraParams;
                        private Interval interval;
                        private Long intervalCount;

                        public Duration build() {
                            return new Duration(this.extraParams, this.interval, this.intervalCount);
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setInterval(Interval interval) {
                            this.interval = interval;
                            return this;
                        }

                        public Builder setIntervalCount(Long intervalCount) {
                            this.intervalCount = intervalCount;
                            return this;
                        }
                    }
                }

                public static class LineEndsAt {
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="id")
                    String id;
                    @SerializedName(value="index")
                    Long index;

                    private LineEndsAt(Map<String, Object> extraParams, String id, Long index) {
                        this.extraParams = extraParams;
                        this.id = id;
                        this.index = index;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public String getId() {
                        return this.id;
                    }

                    @Generated
                    public Long getIndex() {
                        return this.index;
                    }

                    public static class Builder {
                        private Map<String, Object> extraParams;
                        private String id;
                        private Long index;

                        public LineEndsAt build() {
                            return new LineEndsAt(this.extraParams, this.id, this.index);
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setId(String id) {
                            this.id = id;
                            return this;
                        }

                        public Builder setIndex(Long index) {
                            this.index = index;
                            return this;
                        }
                    }
                }

                public static class Timestamp {
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="timestamp")
                    Long timestamp;

                    private Timestamp(Map<String, Object> extraParams, Long timestamp) {
                        this.extraParams = extraParams;
                        this.timestamp = timestamp;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Long getTimestamp() {
                        return this.timestamp;
                    }

                    public static class Builder {
                        private Map<String, Object> extraParams;
                        private Long timestamp;

                        public Timestamp build() {
                            return new Timestamp(this.extraParams, this.timestamp);
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setTimestamp(Long timestamp) {
                            this.timestamp = timestamp;
                            return this;
                        }
                    }
                }

                public static enum Type implements ApiRequestParams.EnumParam
                {
                    DURATION("duration"),
                    LINE_ENDS_AT("line_ends_at"),
                    SCHEDULE_END("schedule_end"),
                    TIMESTAMP("timestamp"),
                    UPCOMING_INVOICE("upcoming_invoice");

                    private final String value;

                    private Type(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Duration duration;
                    private Map<String, Object> extraParams;
                    private LineEndsAt lineEndsAt;
                    private Timestamp timestamp;
                    private Type type;

                    public BillUntil build() {
                        return new BillUntil(this.duration, this.extraParams, this.lineEndsAt, this.timestamp, this.type);
                    }

                    public Builder setDuration(Duration duration) {
                        this.duration = duration;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setLineEndsAt(LineEndsAt lineEndsAt) {
                        this.lineEndsAt = lineEndsAt;
                        return this;
                    }

                    public Builder setTimestamp(Timestamp timestamp) {
                        this.timestamp = timestamp;
                        return this;
                    }

                    public Builder setType(Type type) {
                        this.type = type;
                        return this;
                    }
                }
            }

            public static class Builder {
                private BillFrom billFrom;
                private BillUntil billUntil;
                private Map<String, Object> extraParams;

                public BillOnAcceptance build() {
                    return new BillOnAcceptance(this.billFrom, this.billUntil, this.extraParams);
                }

                public Builder setBillFrom(BillFrom billFrom) {
                    this.billFrom = billFrom;
                    return this;
                }

                public Builder setBillUntil(BillUntil billUntil) {
                    this.billUntil = billUntil;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static enum BillingBehavior implements ApiRequestParams.EnumParam
        {
            PRORATE_ON_NEXT_PHASE("prorate_on_next_phase"),
            PRORATE_UP_FRONT("prorate_up_front");

            private final String value;

            private BillingBehavior(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static enum EndBehavior implements ApiRequestParams.EnumParam
        {
            CANCEL("cancel"),
            RELEASE("release");

            private final String value;

            private EndBehavior(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static enum ProrationBehavior implements ApiRequestParams.EnumParam
        {
            ALWAYS_INVOICE("always_invoice"),
            CREATE_PRORATIONS("create_prorations"),
            NONE("none");

            private final String value;

            private ProrationBehavior(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private BillOnAcceptance billOnAcceptance;
            private BillingBehavior billingBehavior;
            private ApiRequestParams.EnumParam billingCycleAnchor;
            private String description;
            private Object effectiveDate;
            private EndBehavior endBehavior;
            private Map<String, Object> extraParams;
            private String fromSchedule;
            private String fromSubscription;
            private Object prebilling;
            private ProrationBehavior prorationBehavior;
            private Object trialPeriodDays;

            public SubscriptionData build() {
                return new SubscriptionData(this.billOnAcceptance, this.billingBehavior, this.billingCycleAnchor, this.description, this.effectiveDate, this.endBehavior, this.extraParams, this.fromSchedule, this.fromSubscription, this.prebilling, this.prorationBehavior, this.trialPeriodDays);
            }

            public Builder setBillOnAcceptance(BillOnAcceptance billOnAcceptance) {
                this.billOnAcceptance = billOnAcceptance;
                return this;
            }

            public Builder setBillingBehavior(BillingBehavior billingBehavior) {
                this.billingBehavior = billingBehavior;
                return this;
            }

            public Builder setBillingCycleAnchor(BillingCycleAnchor billingCycleAnchor) {
                this.billingCycleAnchor = billingCycleAnchor;
                return this;
            }

            public Builder setBillingCycleAnchor(EmptyParam billingCycleAnchor) {
                this.billingCycleAnchor = billingCycleAnchor;
                return this;
            }

            public Builder setDescription(String description) {
                this.description = description;
                return this;
            }

            public Builder setEffectiveDate(EffectiveDate effectiveDate) {
                this.effectiveDate = effectiveDate;
                return this;
            }

            public Builder setEffectiveDate(Long effectiveDate) {
                this.effectiveDate = effectiveDate;
                return this;
            }

            public Builder setEffectiveDate(EmptyParam effectiveDate) {
                this.effectiveDate = effectiveDate;
                return this;
            }

            public Builder setEndBehavior(EndBehavior endBehavior) {
                this.endBehavior = endBehavior;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setFromSchedule(String fromSchedule) {
                this.fromSchedule = fromSchedule;
                return this;
            }

            public Builder setFromSubscription(String fromSubscription) {
                this.fromSubscription = fromSubscription;
                return this;
            }

            public Builder setPrebilling(Prebilling prebilling) {
                this.prebilling = prebilling;
                return this;
            }

            public Builder setPrebilling(EmptyParam prebilling) {
                this.prebilling = prebilling;
                return this;
            }

            public Builder setProrationBehavior(ProrationBehavior prorationBehavior) {
                this.prorationBehavior = prorationBehavior;
                return this;
            }

            public Builder setTrialPeriodDays(Long trialPeriodDays) {
                this.trialPeriodDays = trialPeriodDays;
                return this;
            }

            public Builder setTrialPeriodDays(EmptyParam trialPeriodDays) {
                this.trialPeriodDays = trialPeriodDays;
                return this;
            }
        }

        public static enum EffectiveDate implements ApiRequestParams.EnumParam
        {
            CURRENT_PERIOD_END("current_period_end");

            private final String value;

            private EffectiveDate(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static enum BillingCycleAnchor implements ApiRequestParams.EnumParam
        {
            RESET("reset");

            private final String value;

            private BillingCycleAnchor(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Prebilling {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="iterations")
            Long iterations;

            private Prebilling(Map<String, Object> extraParams, Long iterations) {
                this.extraParams = extraParams;
                this.iterations = iterations;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Long getIterations() {
                return this.iterations;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Long iterations;

                public Prebilling build() {
                    return new Prebilling(this.extraParams, this.iterations);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setIterations(Long iterations) {
                    this.iterations = iterations;
                    return this;
                }
            }
        }
    }

    public static class Builder {
        private Object applicationFeeAmount;
        private Object applicationFeePercent;
        private AutomaticTax automaticTax;
        private CollectionMethod collectionMethod;
        private String customer;
        private Object defaultTaxRates;
        private String description;
        private Object discounts;
        private List<String> expand;
        private Long expiresAt;
        private Map<String, Object> extraParams;
        private String footer;
        private FromQuote fromQuote;
        private String header;
        private InvoiceSettings invoiceSettings;
        private List<LineItem> lineItems;
        private List<Line> lines;
        private Map<String, String> metadata;
        private Object onBehalfOf;
        private List<Phase> phases;
        private SubscriptionData subscriptionData;
        private List<SubscriptionDataOverride> subscriptionDataOverrides;
        private String testClock;
        private Object transferData;

        public QuoteCreateParams build() {
            return new QuoteCreateParams(this.applicationFeeAmount, this.applicationFeePercent, this.automaticTax, this.collectionMethod, this.customer, this.defaultTaxRates, this.description, this.discounts, this.expand, this.expiresAt, this.extraParams, this.footer, this.fromQuote, this.header, this.invoiceSettings, this.lineItems, this.lines, this.metadata, this.onBehalfOf, this.phases, this.subscriptionData, this.subscriptionDataOverrides, this.testClock, this.transferData);
        }

        public Builder setApplicationFeeAmount(Long applicationFeeAmount) {
            this.applicationFeeAmount = applicationFeeAmount;
            return this;
        }

        public Builder setApplicationFeeAmount(EmptyParam applicationFeeAmount) {
            this.applicationFeeAmount = applicationFeeAmount;
            return this;
        }

        public Builder setApplicationFeePercent(BigDecimal applicationFeePercent) {
            this.applicationFeePercent = applicationFeePercent;
            return this;
        }

        public Builder setApplicationFeePercent(EmptyParam applicationFeePercent) {
            this.applicationFeePercent = applicationFeePercent;
            return this;
        }

        public Builder setAutomaticTax(AutomaticTax automaticTax) {
            this.automaticTax = automaticTax;
            return this;
        }

        public Builder setCollectionMethod(CollectionMethod collectionMethod) {
            this.collectionMethod = collectionMethod;
            return this;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder addDefaultTaxRate(String element) {
            if (this.defaultTaxRates == null || this.defaultTaxRates instanceof EmptyParam) {
                this.defaultTaxRates = new ArrayList();
            }
            ((List)this.defaultTaxRates).add(element);
            return this;
        }

        public Builder addAllDefaultTaxRate(List<String> elements) {
            if (this.defaultTaxRates == null || this.defaultTaxRates instanceof EmptyParam) {
                this.defaultTaxRates = new ArrayList();
            }
            ((List)this.defaultTaxRates).addAll(elements);
            return this;
        }

        public Builder setDefaultTaxRates(EmptyParam defaultTaxRates) {
            this.defaultTaxRates = defaultTaxRates;
            return this;
        }

        public Builder setDefaultTaxRates(List<String> defaultTaxRates) {
            this.defaultTaxRates = defaultTaxRates;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder addDiscount(Discount element) {
            if (this.discounts == null || this.discounts instanceof EmptyParam) {
                this.discounts = new ArrayList();
            }
            ((List)this.discounts).add(element);
            return this;
        }

        public Builder addAllDiscount(List<Discount> elements) {
            if (this.discounts == null || this.discounts instanceof EmptyParam) {
                this.discounts = new ArrayList();
            }
            ((List)this.discounts).addAll(elements);
            return this;
        }

        public Builder setDiscounts(EmptyParam discounts) {
            this.discounts = discounts;
            return this;
        }

        public Builder setDiscounts(List<Discount> discounts) {
            this.discounts = discounts;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder setExpiresAt(Long expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder setFooter(String footer) {
            this.footer = footer;
            return this;
        }

        public Builder setFromQuote(FromQuote fromQuote) {
            this.fromQuote = fromQuote;
            return this;
        }

        public Builder setHeader(String header) {
            this.header = header;
            return this;
        }

        public Builder setInvoiceSettings(InvoiceSettings invoiceSettings) {
            this.invoiceSettings = invoiceSettings;
            return this;
        }

        public Builder addLineItem(LineItem element) {
            if (this.lineItems == null) {
                this.lineItems = new ArrayList<LineItem>();
            }
            this.lineItems.add(element);
            return this;
        }

        public Builder addAllLineItem(List<LineItem> elements) {
            if (this.lineItems == null) {
                this.lineItems = new ArrayList<LineItem>();
            }
            this.lineItems.addAll(elements);
            return this;
        }

        public Builder addLine(Line element) {
            if (this.lines == null) {
                this.lines = new ArrayList<Line>();
            }
            this.lines.add(element);
            return this;
        }

        public Builder addAllLine(List<Line> elements) {
            if (this.lines == null) {
                this.lines = new ArrayList<Line>();
            }
            this.lines.addAll(elements);
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.putAll(map);
            return this;
        }

        public Builder setOnBehalfOf(String onBehalfOf) {
            this.onBehalfOf = onBehalfOf;
            return this;
        }

        public Builder setOnBehalfOf(EmptyParam onBehalfOf) {
            this.onBehalfOf = onBehalfOf;
            return this;
        }

        public Builder addPhase(Phase element) {
            if (this.phases == null) {
                this.phases = new ArrayList<Phase>();
            }
            this.phases.add(element);
            return this;
        }

        public Builder addAllPhase(List<Phase> elements) {
            if (this.phases == null) {
                this.phases = new ArrayList<Phase>();
            }
            this.phases.addAll(elements);
            return this;
        }

        public Builder setSubscriptionData(SubscriptionData subscriptionData) {
            this.subscriptionData = subscriptionData;
            return this;
        }

        public Builder addSubscriptionDataOverride(SubscriptionDataOverride element) {
            if (this.subscriptionDataOverrides == null) {
                this.subscriptionDataOverrides = new ArrayList<SubscriptionDataOverride>();
            }
            this.subscriptionDataOverrides.add(element);
            return this;
        }

        public Builder addAllSubscriptionDataOverride(List<SubscriptionDataOverride> elements) {
            if (this.subscriptionDataOverrides == null) {
                this.subscriptionDataOverrides = new ArrayList<SubscriptionDataOverride>();
            }
            this.subscriptionDataOverrides.addAll(elements);
            return this;
        }

        public Builder setTestClock(String testClock) {
            this.testClock = testClock;
            return this;
        }

        public Builder setTransferData(TransferData transferData) {
            this.transferData = transferData;
            return this;
        }

        public Builder setTransferData(EmptyParam transferData) {
            this.transferData = transferData;
            return this;
        }
    }

    public static class TransferData {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="amount_percent")
        BigDecimal amountPercent;
        @SerializedName(value="destination")
        String destination;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;

        private TransferData(Long amount, BigDecimal amountPercent, String destination, Map<String, Object> extraParams) {
            this.amount = amount;
            this.amountPercent = amountPercent;
            this.destination = destination;
            this.extraParams = extraParams;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public BigDecimal getAmountPercent() {
            return this.amountPercent;
        }

        @Generated
        public String getDestination() {
            return this.destination;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        public static class Builder {
            private Long amount;
            private BigDecimal amountPercent;
            private String destination;
            private Map<String, Object> extraParams;

            public TransferData build() {
                return new TransferData(this.amount, this.amountPercent, this.destination, this.extraParams);
            }

            public Builder setAmount(Long amount) {
                this.amount = amount;
                return this;
            }

            public Builder setAmountPercent(BigDecimal amountPercent) {
                this.amountPercent = amountPercent;
                return this;
            }

            public Builder setDestination(String destination) {
                this.destination = destination;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }
        }
    }

    public static class SubscriptionDataOverride {
        @SerializedName(value="applies_to")
        AppliesTo appliesTo;
        @SerializedName(value="bill_on_acceptance")
        BillOnAcceptance billOnAcceptance;
        @SerializedName(value="billing_behavior")
        BillingBehavior billingBehavior;
        @SerializedName(value="customer")
        String customer;
        @SerializedName(value="description")
        String description;
        @SerializedName(value="end_behavior")
        EndBehavior endBehavior;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="proration_behavior")
        ProrationBehavior prorationBehavior;

        private SubscriptionDataOverride(AppliesTo appliesTo, BillOnAcceptance billOnAcceptance, BillingBehavior billingBehavior, String customer, String description, EndBehavior endBehavior, Map<String, Object> extraParams, ProrationBehavior prorationBehavior) {
            this.appliesTo = appliesTo;
            this.billOnAcceptance = billOnAcceptance;
            this.billingBehavior = billingBehavior;
            this.customer = customer;
            this.description = description;
            this.endBehavior = endBehavior;
            this.extraParams = extraParams;
            this.prorationBehavior = prorationBehavior;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public AppliesTo getAppliesTo() {
            return this.appliesTo;
        }

        @Generated
        public BillOnAcceptance getBillOnAcceptance() {
            return this.billOnAcceptance;
        }

        @Generated
        public BillingBehavior getBillingBehavior() {
            return this.billingBehavior;
        }

        @Generated
        public String getCustomer() {
            return this.customer;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public EndBehavior getEndBehavior() {
            return this.endBehavior;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public ProrationBehavior getProrationBehavior() {
            return this.prorationBehavior;
        }

        public static class AppliesTo {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="new_reference")
            String newReference;
            @SerializedName(value="subscription_schedule")
            String subscriptionSchedule;
            @SerializedName(value="type")
            Type type;

            private AppliesTo(Map<String, Object> extraParams, String newReference, String subscriptionSchedule, Type type) {
                this.extraParams = extraParams;
                this.newReference = newReference;
                this.subscriptionSchedule = subscriptionSchedule;
                this.type = type;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getNewReference() {
                return this.newReference;
            }

            @Generated
            public String getSubscriptionSchedule() {
                return this.subscriptionSchedule;
            }

            @Generated
            public Type getType() {
                return this.type;
            }

            public static enum Type implements ApiRequestParams.EnumParam
            {
                NEW_REFERENCE("new_reference"),
                SUBSCRIPTION_SCHEDULE("subscription_schedule");

                private final String value;

                private Type(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private String newReference;
                private String subscriptionSchedule;
                private Type type;

                public AppliesTo build() {
                    return new AppliesTo(this.extraParams, this.newReference, this.subscriptionSchedule, this.type);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setNewReference(String newReference) {
                    this.newReference = newReference;
                    return this;
                }

                public Builder setSubscriptionSchedule(String subscriptionSchedule) {
                    this.subscriptionSchedule = subscriptionSchedule;
                    return this;
                }

                public Builder setType(Type type) {
                    this.type = type;
                    return this;
                }
            }
        }

        public static class BillOnAcceptance {
            @SerializedName(value="bill_from")
            BillFrom billFrom;
            @SerializedName(value="bill_until")
            BillUntil billUntil;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private BillOnAcceptance(BillFrom billFrom, BillUntil billUntil, Map<String, Object> extraParams) {
                this.billFrom = billFrom;
                this.billUntil = billUntil;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public BillFrom getBillFrom() {
                return this.billFrom;
            }

            @Generated
            public BillUntil getBillUntil() {
                return this.billUntil;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class BillFrom {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="line_starts_at")
                LineStartsAt lineStartsAt;
                @SerializedName(value="timestamp")
                Timestamp timestamp;
                @SerializedName(value="type")
                Type type;

                private BillFrom(Map<String, Object> extraParams, LineStartsAt lineStartsAt, Timestamp timestamp, Type type) {
                    this.extraParams = extraParams;
                    this.lineStartsAt = lineStartsAt;
                    this.timestamp = timestamp;
                    this.type = type;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public LineStartsAt getLineStartsAt() {
                    return this.lineStartsAt;
                }

                @Generated
                public Timestamp getTimestamp() {
                    return this.timestamp;
                }

                @Generated
                public Type getType() {
                    return this.type;
                }

                public static class LineStartsAt {
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="id")
                    String id;
                    @SerializedName(value="index")
                    Long index;

                    private LineStartsAt(Map<String, Object> extraParams, String id, Long index) {
                        this.extraParams = extraParams;
                        this.id = id;
                        this.index = index;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public String getId() {
                        return this.id;
                    }

                    @Generated
                    public Long getIndex() {
                        return this.index;
                    }

                    public static class Builder {
                        private Map<String, Object> extraParams;
                        private String id;
                        private Long index;

                        public LineStartsAt build() {
                            return new LineStartsAt(this.extraParams, this.id, this.index);
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setId(String id) {
                            this.id = id;
                            return this;
                        }

                        public Builder setIndex(Long index) {
                            this.index = index;
                            return this;
                        }
                    }
                }

                public static class Timestamp {
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="timestamp")
                    Long timestamp;

                    private Timestamp(Map<String, Object> extraParams, Long timestamp) {
                        this.extraParams = extraParams;
                        this.timestamp = timestamp;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Long getTimestamp() {
                        return this.timestamp;
                    }

                    public static class Builder {
                        private Map<String, Object> extraParams;
                        private Long timestamp;

                        public Timestamp build() {
                            return new Timestamp(this.extraParams, this.timestamp);
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setTimestamp(Long timestamp) {
                            this.timestamp = timestamp;
                            return this;
                        }
                    }
                }

                public static enum Type implements ApiRequestParams.EnumParam
                {
                    LINE_STARTS_AT("line_starts_at"),
                    NOW("now"),
                    QUOTE_ACCEPTANCE_DATE("quote_acceptance_date"),
                    TIMESTAMP("timestamp");

                    private final String value;

                    private Type(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private LineStartsAt lineStartsAt;
                    private Timestamp timestamp;
                    private Type type;

                    public BillFrom build() {
                        return new BillFrom(this.extraParams, this.lineStartsAt, this.timestamp, this.type);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setLineStartsAt(LineStartsAt lineStartsAt) {
                        this.lineStartsAt = lineStartsAt;
                        return this;
                    }

                    public Builder setTimestamp(Timestamp timestamp) {
                        this.timestamp = timestamp;
                        return this;
                    }

                    public Builder setType(Type type) {
                        this.type = type;
                        return this;
                    }
                }
            }

            public static class BillUntil {
                @SerializedName(value="duration")
                Duration duration;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="line_ends_at")
                LineEndsAt lineEndsAt;
                @SerializedName(value="timestamp")
                Timestamp timestamp;
                @SerializedName(value="type")
                Type type;

                private BillUntil(Duration duration, Map<String, Object> extraParams, LineEndsAt lineEndsAt, Timestamp timestamp, Type type) {
                    this.duration = duration;
                    this.extraParams = extraParams;
                    this.lineEndsAt = lineEndsAt;
                    this.timestamp = timestamp;
                    this.type = type;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Duration getDuration() {
                    return this.duration;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public LineEndsAt getLineEndsAt() {
                    return this.lineEndsAt;
                }

                @Generated
                public Timestamp getTimestamp() {
                    return this.timestamp;
                }

                @Generated
                public Type getType() {
                    return this.type;
                }

                public static class Duration {
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="interval")
                    Interval interval;
                    @SerializedName(value="interval_count")
                    Long intervalCount;

                    private Duration(Map<String, Object> extraParams, Interval interval, Long intervalCount) {
                        this.extraParams = extraParams;
                        this.interval = interval;
                        this.intervalCount = intervalCount;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Interval getInterval() {
                        return this.interval;
                    }

                    @Generated
                    public Long getIntervalCount() {
                        return this.intervalCount;
                    }

                    public static enum Interval implements ApiRequestParams.EnumParam
                    {
                        DAY("day"),
                        MONTH("month"),
                        WEEK("week"),
                        YEAR("year");

                        private final String value;

                        private Interval(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static class Builder {
                        private Map<String, Object> extraParams;
                        private Interval interval;
                        private Long intervalCount;

                        public Duration build() {
                            return new Duration(this.extraParams, this.interval, this.intervalCount);
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setInterval(Interval interval) {
                            this.interval = interval;
                            return this;
                        }

                        public Builder setIntervalCount(Long intervalCount) {
                            this.intervalCount = intervalCount;
                            return this;
                        }
                    }
                }

                public static class LineEndsAt {
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="id")
                    String id;
                    @SerializedName(value="index")
                    Long index;

                    private LineEndsAt(Map<String, Object> extraParams, String id, Long index) {
                        this.extraParams = extraParams;
                        this.id = id;
                        this.index = index;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public String getId() {
                        return this.id;
                    }

                    @Generated
                    public Long getIndex() {
                        return this.index;
                    }

                    public static class Builder {
                        private Map<String, Object> extraParams;
                        private String id;
                        private Long index;

                        public LineEndsAt build() {
                            return new LineEndsAt(this.extraParams, this.id, this.index);
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setId(String id) {
                            this.id = id;
                            return this;
                        }

                        public Builder setIndex(Long index) {
                            this.index = index;
                            return this;
                        }
                    }
                }

                public static class Timestamp {
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="timestamp")
                    Long timestamp;

                    private Timestamp(Map<String, Object> extraParams, Long timestamp) {
                        this.extraParams = extraParams;
                        this.timestamp = timestamp;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Long getTimestamp() {
                        return this.timestamp;
                    }

                    public static class Builder {
                        private Map<String, Object> extraParams;
                        private Long timestamp;

                        public Timestamp build() {
                            return new Timestamp(this.extraParams, this.timestamp);
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setTimestamp(Long timestamp) {
                            this.timestamp = timestamp;
                            return this;
                        }
                    }
                }

                public static enum Type implements ApiRequestParams.EnumParam
                {
                    DURATION("duration"),
                    LINE_ENDS_AT("line_ends_at"),
                    SCHEDULE_END("schedule_end"),
                    TIMESTAMP("timestamp"),
                    UPCOMING_INVOICE("upcoming_invoice");

                    private final String value;

                    private Type(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Duration duration;
                    private Map<String, Object> extraParams;
                    private LineEndsAt lineEndsAt;
                    private Timestamp timestamp;
                    private Type type;

                    public BillUntil build() {
                        return new BillUntil(this.duration, this.extraParams, this.lineEndsAt, this.timestamp, this.type);
                    }

                    public Builder setDuration(Duration duration) {
                        this.duration = duration;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setLineEndsAt(LineEndsAt lineEndsAt) {
                        this.lineEndsAt = lineEndsAt;
                        return this;
                    }

                    public Builder setTimestamp(Timestamp timestamp) {
                        this.timestamp = timestamp;
                        return this;
                    }

                    public Builder setType(Type type) {
                        this.type = type;
                        return this;
                    }
                }
            }

            public static class Builder {
                private BillFrom billFrom;
                private BillUntil billUntil;
                private Map<String, Object> extraParams;

                public BillOnAcceptance build() {
                    return new BillOnAcceptance(this.billFrom, this.billUntil, this.extraParams);
                }

                public Builder setBillFrom(BillFrom billFrom) {
                    this.billFrom = billFrom;
                    return this;
                }

                public Builder setBillUntil(BillUntil billUntil) {
                    this.billUntil = billUntil;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static enum BillingBehavior implements ApiRequestParams.EnumParam
        {
            PRORATE_ON_NEXT_PHASE("prorate_on_next_phase"),
            PRORATE_UP_FRONT("prorate_up_front");

            private final String value;

            private BillingBehavior(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static enum EndBehavior implements ApiRequestParams.EnumParam
        {
            CANCEL("cancel"),
            RELEASE("release");

            private final String value;

            private EndBehavior(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static enum ProrationBehavior implements ApiRequestParams.EnumParam
        {
            ALWAYS_INVOICE("always_invoice"),
            CREATE_PRORATIONS("create_prorations"),
            NONE("none");

            private final String value;

            private ProrationBehavior(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private AppliesTo appliesTo;
            private BillOnAcceptance billOnAcceptance;
            private BillingBehavior billingBehavior;
            private String customer;
            private String description;
            private EndBehavior endBehavior;
            private Map<String, Object> extraParams;
            private ProrationBehavior prorationBehavior;

            public SubscriptionDataOverride build() {
                return new SubscriptionDataOverride(this.appliesTo, this.billOnAcceptance, this.billingBehavior, this.customer, this.description, this.endBehavior, this.extraParams, this.prorationBehavior);
            }

            public Builder setAppliesTo(AppliesTo appliesTo) {
                this.appliesTo = appliesTo;
                return this;
            }

            public Builder setBillOnAcceptance(BillOnAcceptance billOnAcceptance) {
                this.billOnAcceptance = billOnAcceptance;
                return this;
            }

            public Builder setBillingBehavior(BillingBehavior billingBehavior) {
                this.billingBehavior = billingBehavior;
                return this;
            }

            public Builder setCustomer(String customer) {
                this.customer = customer;
                return this;
            }

            public Builder setDescription(String description) {
                this.description = description;
                return this;
            }

            public Builder setEndBehavior(EndBehavior endBehavior) {
                this.endBehavior = endBehavior;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setProrationBehavior(ProrationBehavior prorationBehavior) {
                this.prorationBehavior = prorationBehavior;
                return this;
            }
        }
    }

    public static class Phase {
        @SerializedName(value="billing_cycle_anchor")
        BillingCycleAnchor billingCycleAnchor;
        @SerializedName(value="collection_method")
        CollectionMethod collectionMethod;
        @SerializedName(value="default_tax_rates")
        Object defaultTaxRates;
        @SerializedName(value="discounts")
        Object discounts;
        @SerializedName(value="end_date")
        Long endDate;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="invoice_settings")
        InvoiceSettings invoiceSettings;
        @SerializedName(value="iterations")
        Long iterations;
        @SerializedName(value="line_items")
        List<LineItem> lineItems;
        @SerializedName(value="proration_behavior")
        ProrationBehavior prorationBehavior;
        @SerializedName(value="trial")
        Boolean trial;
        @SerializedName(value="trial_end")
        Long trialEnd;

        private Phase(BillingCycleAnchor billingCycleAnchor, CollectionMethod collectionMethod, Object defaultTaxRates, Object discounts, Long endDate, Map<String, Object> extraParams, InvoiceSettings invoiceSettings, Long iterations, List<LineItem> lineItems, ProrationBehavior prorationBehavior, Boolean trial, Long trialEnd) {
            this.billingCycleAnchor = billingCycleAnchor;
            this.collectionMethod = collectionMethod;
            this.defaultTaxRates = defaultTaxRates;
            this.discounts = discounts;
            this.endDate = endDate;
            this.extraParams = extraParams;
            this.invoiceSettings = invoiceSettings;
            this.iterations = iterations;
            this.lineItems = lineItems;
            this.prorationBehavior = prorationBehavior;
            this.trial = trial;
            this.trialEnd = trialEnd;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public BillingCycleAnchor getBillingCycleAnchor() {
            return this.billingCycleAnchor;
        }

        @Generated
        public CollectionMethod getCollectionMethod() {
            return this.collectionMethod;
        }

        @Generated
        public Object getDefaultTaxRates() {
            return this.defaultTaxRates;
        }

        @Generated
        public Object getDiscounts() {
            return this.discounts;
        }

        @Generated
        public Long getEndDate() {
            return this.endDate;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public InvoiceSettings getInvoiceSettings() {
            return this.invoiceSettings;
        }

        @Generated
        public Long getIterations() {
            return this.iterations;
        }

        @Generated
        public List<LineItem> getLineItems() {
            return this.lineItems;
        }

        @Generated
        public ProrationBehavior getProrationBehavior() {
            return this.prorationBehavior;
        }

        @Generated
        public Boolean getTrial() {
            return this.trial;
        }

        @Generated
        public Long getTrialEnd() {
            return this.trialEnd;
        }

        public static enum BillingCycleAnchor implements ApiRequestParams.EnumParam
        {
            RESET("reset");

            private final String value;

            private BillingCycleAnchor(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static enum CollectionMethod implements ApiRequestParams.EnumParam
        {
            CHARGE_AUTOMATICALLY("charge_automatically"),
            SEND_INVOICE("send_invoice");

            private final String value;

            private CollectionMethod(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class InvoiceSettings {
            @SerializedName(value="days_until_due")
            Long daysUntilDue;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private InvoiceSettings(Long daysUntilDue, Map<String, Object> extraParams) {
                this.daysUntilDue = daysUntilDue;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Long getDaysUntilDue() {
                return this.daysUntilDue;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Long daysUntilDue;
                private Map<String, Object> extraParams;

                public InvoiceSettings build() {
                    return new InvoiceSettings(this.daysUntilDue, this.extraParams);
                }

                public Builder setDaysUntilDue(Long daysUntilDue) {
                    this.daysUntilDue = daysUntilDue;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static enum ProrationBehavior implements ApiRequestParams.EnumParam
        {
            ALWAYS_INVOICE("always_invoice"),
            CREATE_PRORATIONS("create_prorations"),
            NONE("none");

            private final String value;

            private ProrationBehavior(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private BillingCycleAnchor billingCycleAnchor;
            private CollectionMethod collectionMethod;
            private Object defaultTaxRates;
            private Object discounts;
            private Long endDate;
            private Map<String, Object> extraParams;
            private InvoiceSettings invoiceSettings;
            private Long iterations;
            private List<LineItem> lineItems;
            private ProrationBehavior prorationBehavior;
            private Boolean trial;
            private Long trialEnd;

            public Phase build() {
                return new Phase(this.billingCycleAnchor, this.collectionMethod, this.defaultTaxRates, this.discounts, this.endDate, this.extraParams, this.invoiceSettings, this.iterations, this.lineItems, this.prorationBehavior, this.trial, this.trialEnd);
            }

            public Builder setBillingCycleAnchor(BillingCycleAnchor billingCycleAnchor) {
                this.billingCycleAnchor = billingCycleAnchor;
                return this;
            }

            public Builder setCollectionMethod(CollectionMethod collectionMethod) {
                this.collectionMethod = collectionMethod;
                return this;
            }

            public Builder addDefaultTaxRate(String element) {
                if (this.defaultTaxRates == null || this.defaultTaxRates instanceof EmptyParam) {
                    this.defaultTaxRates = new ArrayList();
                }
                ((List)this.defaultTaxRates).add(element);
                return this;
            }

            public Builder addAllDefaultTaxRate(List<String> elements) {
                if (this.defaultTaxRates == null || this.defaultTaxRates instanceof EmptyParam) {
                    this.defaultTaxRates = new ArrayList();
                }
                ((List)this.defaultTaxRates).addAll(elements);
                return this;
            }

            public Builder setDefaultTaxRates(EmptyParam defaultTaxRates) {
                this.defaultTaxRates = defaultTaxRates;
                return this;
            }

            public Builder setDefaultTaxRates(List<String> defaultTaxRates) {
                this.defaultTaxRates = defaultTaxRates;
                return this;
            }

            public Builder addDiscount(Discount element) {
                if (this.discounts == null || this.discounts instanceof EmptyParam) {
                    this.discounts = new ArrayList();
                }
                ((List)this.discounts).add(element);
                return this;
            }

            public Builder addAllDiscount(List<Discount> elements) {
                if (this.discounts == null || this.discounts instanceof EmptyParam) {
                    this.discounts = new ArrayList();
                }
                ((List)this.discounts).addAll(elements);
                return this;
            }

            public Builder setDiscounts(EmptyParam discounts) {
                this.discounts = discounts;
                return this;
            }

            public Builder setDiscounts(List<Discount> discounts) {
                this.discounts = discounts;
                return this;
            }

            public Builder setEndDate(Long endDate) {
                this.endDate = endDate;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setInvoiceSettings(InvoiceSettings invoiceSettings) {
                this.invoiceSettings = invoiceSettings;
                return this;
            }

            public Builder setIterations(Long iterations) {
                this.iterations = iterations;
                return this;
            }

            public Builder addLineItem(LineItem element) {
                if (this.lineItems == null) {
                    this.lineItems = new ArrayList<LineItem>();
                }
                this.lineItems.add(element);
                return this;
            }

            public Builder addAllLineItem(List<LineItem> elements) {
                if (this.lineItems == null) {
                    this.lineItems = new ArrayList<LineItem>();
                }
                this.lineItems.addAll(elements);
                return this;
            }

            public Builder setProrationBehavior(ProrationBehavior prorationBehavior) {
                this.prorationBehavior = prorationBehavior;
                return this;
            }

            public Builder setTrial(Boolean trial) {
                this.trial = trial;
                return this;
            }

            public Builder setTrialEnd(Long trialEnd) {
                this.trialEnd = trialEnd;
                return this;
            }
        }

        public static class LineItem {
            @SerializedName(value="discounts")
            Object discounts;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="price")
            String price;
            @SerializedName(value="price_data")
            PriceData priceData;
            @SerializedName(value="quantity")
            Long quantity;
            @SerializedName(value="tax_rates")
            Object taxRates;

            private LineItem(Object discounts, Map<String, Object> extraParams, String price, PriceData priceData, Long quantity, Object taxRates) {
                this.discounts = discounts;
                this.extraParams = extraParams;
                this.price = price;
                this.priceData = priceData;
                this.quantity = quantity;
                this.taxRates = taxRates;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Object getDiscounts() {
                return this.discounts;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getPrice() {
                return this.price;
            }

            @Generated
            public PriceData getPriceData() {
                return this.priceData;
            }

            @Generated
            public Long getQuantity() {
                return this.quantity;
            }

            @Generated
            public Object getTaxRates() {
                return this.taxRates;
            }

            public static class PriceData {
                @SerializedName(value="currency")
                String currency;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="product")
                String product;
                @SerializedName(value="recurring")
                Recurring recurring;
                @SerializedName(value="tax_behavior")
                TaxBehavior taxBehavior;
                @SerializedName(value="unit_amount")
                Long unitAmount;
                @SerializedName(value="unit_amount_decimal")
                BigDecimal unitAmountDecimal;

                private PriceData(String currency, Map<String, Object> extraParams, String product, Recurring recurring, TaxBehavior taxBehavior, Long unitAmount, BigDecimal unitAmountDecimal) {
                    this.currency = currency;
                    this.extraParams = extraParams;
                    this.product = product;
                    this.recurring = recurring;
                    this.taxBehavior = taxBehavior;
                    this.unitAmount = unitAmount;
                    this.unitAmountDecimal = unitAmountDecimal;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getCurrency() {
                    return this.currency;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getProduct() {
                    return this.product;
                }

                @Generated
                public Recurring getRecurring() {
                    return this.recurring;
                }

                @Generated
                public TaxBehavior getTaxBehavior() {
                    return this.taxBehavior;
                }

                @Generated
                public Long getUnitAmount() {
                    return this.unitAmount;
                }

                @Generated
                public BigDecimal getUnitAmountDecimal() {
                    return this.unitAmountDecimal;
                }

                public static class Recurring {
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="interval")
                    Interval interval;
                    @SerializedName(value="interval_count")
                    Long intervalCount;

                    private Recurring(Map<String, Object> extraParams, Interval interval, Long intervalCount) {
                        this.extraParams = extraParams;
                        this.interval = interval;
                        this.intervalCount = intervalCount;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Interval getInterval() {
                        return this.interval;
                    }

                    @Generated
                    public Long getIntervalCount() {
                        return this.intervalCount;
                    }

                    public static enum Interval implements ApiRequestParams.EnumParam
                    {
                        DAY("day"),
                        MONTH("month"),
                        WEEK("week"),
                        YEAR("year");

                        private final String value;

                        private Interval(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static class Builder {
                        private Map<String, Object> extraParams;
                        private Interval interval;
                        private Long intervalCount;

                        public Recurring build() {
                            return new Recurring(this.extraParams, this.interval, this.intervalCount);
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setInterval(Interval interval) {
                            this.interval = interval;
                            return this;
                        }

                        public Builder setIntervalCount(Long intervalCount) {
                            this.intervalCount = intervalCount;
                            return this;
                        }
                    }
                }

                public static enum TaxBehavior implements ApiRequestParams.EnumParam
                {
                    EXCLUSIVE("exclusive"),
                    INCLUSIVE("inclusive"),
                    UNSPECIFIED("unspecified");

                    private final String value;

                    private TaxBehavior(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private String currency;
                    private Map<String, Object> extraParams;
                    private String product;
                    private Recurring recurring;
                    private TaxBehavior taxBehavior;
                    private Long unitAmount;
                    private BigDecimal unitAmountDecimal;

                    public PriceData build() {
                        return new PriceData(this.currency, this.extraParams, this.product, this.recurring, this.taxBehavior, this.unitAmount, this.unitAmountDecimal);
                    }

                    public Builder setCurrency(String currency) {
                        this.currency = currency;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setProduct(String product) {
                        this.product = product;
                        return this;
                    }

                    public Builder setRecurring(Recurring recurring) {
                        this.recurring = recurring;
                        return this;
                    }

                    public Builder setTaxBehavior(TaxBehavior taxBehavior) {
                        this.taxBehavior = taxBehavior;
                        return this;
                    }

                    public Builder setUnitAmount(Long unitAmount) {
                        this.unitAmount = unitAmount;
                        return this;
                    }

                    public Builder setUnitAmountDecimal(BigDecimal unitAmountDecimal) {
                        this.unitAmountDecimal = unitAmountDecimal;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Object discounts;
                private Map<String, Object> extraParams;
                private String price;
                private PriceData priceData;
                private Long quantity;
                private Object taxRates;

                public LineItem build() {
                    return new LineItem(this.discounts, this.extraParams, this.price, this.priceData, this.quantity, this.taxRates);
                }

                public Builder addDiscount(Discount element) {
                    if (this.discounts == null || this.discounts instanceof EmptyParam) {
                        this.discounts = new ArrayList();
                    }
                    ((List)this.discounts).add(element);
                    return this;
                }

                public Builder addAllDiscount(List<Discount> elements) {
                    if (this.discounts == null || this.discounts instanceof EmptyParam) {
                        this.discounts = new ArrayList();
                    }
                    ((List)this.discounts).addAll(elements);
                    return this;
                }

                public Builder setDiscounts(EmptyParam discounts) {
                    this.discounts = discounts;
                    return this;
                }

                public Builder setDiscounts(List<Discount> discounts) {
                    this.discounts = discounts;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setPrice(String price) {
                    this.price = price;
                    return this;
                }

                public Builder setPriceData(PriceData priceData) {
                    this.priceData = priceData;
                    return this;
                }

                public Builder setQuantity(Long quantity) {
                    this.quantity = quantity;
                    return this;
                }

                public Builder addTaxRate(String element) {
                    if (this.taxRates == null || this.taxRates instanceof EmptyParam) {
                        this.taxRates = new ArrayList();
                    }
                    ((List)this.taxRates).add(element);
                    return this;
                }

                public Builder addAllTaxRate(List<String> elements) {
                    if (this.taxRates == null || this.taxRates instanceof EmptyParam) {
                        this.taxRates = new ArrayList();
                    }
                    ((List)this.taxRates).addAll(elements);
                    return this;
                }

                public Builder setTaxRates(EmptyParam taxRates) {
                    this.taxRates = taxRates;
                    return this;
                }

                public Builder setTaxRates(List<String> taxRates) {
                    this.taxRates = taxRates;
                    return this;
                }
            }

            public static class Discount {
                @SerializedName(value="coupon")
                String coupon;
                @SerializedName(value="discount")
                String discount;
                @SerializedName(value="discount_end")
                DiscountEnd discountEnd;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;

                private Discount(String coupon, String discount, DiscountEnd discountEnd, Map<String, Object> extraParams) {
                    this.coupon = coupon;
                    this.discount = discount;
                    this.discountEnd = discountEnd;
                    this.extraParams = extraParams;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getCoupon() {
                    return this.coupon;
                }

                @Generated
                public String getDiscount() {
                    return this.discount;
                }

                @Generated
                public DiscountEnd getDiscountEnd() {
                    return this.discountEnd;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                public static class DiscountEnd {
                    @SerializedName(value="duration")
                    Duration duration;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="timestamp")
                    Long timestamp;
                    @SerializedName(value="type")
                    Type type;

                    private DiscountEnd(Duration duration, Map<String, Object> extraParams, Long timestamp, Type type) {
                        this.duration = duration;
                        this.extraParams = extraParams;
                        this.timestamp = timestamp;
                        this.type = type;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Duration getDuration() {
                        return this.duration;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Long getTimestamp() {
                        return this.timestamp;
                    }

                    @Generated
                    public Type getType() {
                        return this.type;
                    }

                    public static class Duration {
                        @SerializedName(value="_stripe_java_extra_param_key")
                        Map<String, Object> extraParams;
                        @SerializedName(value="interval")
                        Interval interval;
                        @SerializedName(value="interval_count")
                        Long intervalCount;

                        private Duration(Map<String, Object> extraParams, Interval interval, Long intervalCount) {
                            this.extraParams = extraParams;
                            this.interval = interval;
                            this.intervalCount = intervalCount;
                        }

                        public static Builder builder() {
                            return new Builder();
                        }

                        @Generated
                        public Map<String, Object> getExtraParams() {
                            return this.extraParams;
                        }

                        @Generated
                        public Interval getInterval() {
                            return this.interval;
                        }

                        @Generated
                        public Long getIntervalCount() {
                            return this.intervalCount;
                        }

                        public static enum Interval implements ApiRequestParams.EnumParam
                        {
                            DAY("day"),
                            MONTH("month"),
                            WEEK("week"),
                            YEAR("year");

                            private final String value;

                            private Interval(String value) {
                                this.value = value;
                            }

                            @Override
                            @Generated
                            public String getValue() {
                                return this.value;
                            }
                        }

                        public static class Builder {
                            private Map<String, Object> extraParams;
                            private Interval interval;
                            private Long intervalCount;

                            public Duration build() {
                                return new Duration(this.extraParams, this.interval, this.intervalCount);
                            }

                            public Builder putExtraParam(String key, Object value) {
                                if (this.extraParams == null) {
                                    this.extraParams = new HashMap<String, Object>();
                                }
                                this.extraParams.put(key, value);
                                return this;
                            }

                            public Builder putAllExtraParam(Map<String, Object> map) {
                                if (this.extraParams == null) {
                                    this.extraParams = new HashMap<String, Object>();
                                }
                                this.extraParams.putAll(map);
                                return this;
                            }

                            public Builder setInterval(Interval interval) {
                                this.interval = interval;
                                return this;
                            }

                            public Builder setIntervalCount(Long intervalCount) {
                                this.intervalCount = intervalCount;
                                return this;
                            }
                        }
                    }

                    public static enum Type implements ApiRequestParams.EnumParam
                    {
                        DURATION("duration"),
                        TIMESTAMP("timestamp");

                        private final String value;

                        private Type(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static class Builder {
                        private Duration duration;
                        private Map<String, Object> extraParams;
                        private Long timestamp;
                        private Type type;

                        public DiscountEnd build() {
                            return new DiscountEnd(this.duration, this.extraParams, this.timestamp, this.type);
                        }

                        public Builder setDuration(Duration duration) {
                            this.duration = duration;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setTimestamp(Long timestamp) {
                            this.timestamp = timestamp;
                            return this;
                        }

                        public Builder setType(Type type) {
                            this.type = type;
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private String coupon;
                    private String discount;
                    private DiscountEnd discountEnd;
                    private Map<String, Object> extraParams;

                    public Discount build() {
                        return new Discount(this.coupon, this.discount, this.discountEnd, this.extraParams);
                    }

                    public Builder setCoupon(String coupon) {
                        this.coupon = coupon;
                        return this;
                    }

                    public Builder setDiscount(String discount) {
                        this.discount = discount;
                        return this;
                    }

                    public Builder setDiscountEnd(DiscountEnd discountEnd) {
                        this.discountEnd = discountEnd;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }
                }
            }
        }

        public static class Discount {
            @SerializedName(value="coupon")
            String coupon;
            @SerializedName(value="discount")
            String discount;
            @SerializedName(value="discount_end")
            DiscountEnd discountEnd;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Discount(String coupon, String discount, DiscountEnd discountEnd, Map<String, Object> extraParams) {
                this.coupon = coupon;
                this.discount = discount;
                this.discountEnd = discountEnd;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getCoupon() {
                return this.coupon;
            }

            @Generated
            public String getDiscount() {
                return this.discount;
            }

            @Generated
            public DiscountEnd getDiscountEnd() {
                return this.discountEnd;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class DiscountEnd {
                @SerializedName(value="duration")
                Duration duration;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="timestamp")
                Long timestamp;
                @SerializedName(value="type")
                Type type;

                private DiscountEnd(Duration duration, Map<String, Object> extraParams, Long timestamp, Type type) {
                    this.duration = duration;
                    this.extraParams = extraParams;
                    this.timestamp = timestamp;
                    this.type = type;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Duration getDuration() {
                    return this.duration;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Long getTimestamp() {
                    return this.timestamp;
                }

                @Generated
                public Type getType() {
                    return this.type;
                }

                public static class Duration {
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="interval")
                    Interval interval;
                    @SerializedName(value="interval_count")
                    Long intervalCount;

                    private Duration(Map<String, Object> extraParams, Interval interval, Long intervalCount) {
                        this.extraParams = extraParams;
                        this.interval = interval;
                        this.intervalCount = intervalCount;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Interval getInterval() {
                        return this.interval;
                    }

                    @Generated
                    public Long getIntervalCount() {
                        return this.intervalCount;
                    }

                    public static enum Interval implements ApiRequestParams.EnumParam
                    {
                        DAY("day"),
                        MONTH("month"),
                        WEEK("week"),
                        YEAR("year");

                        private final String value;

                        private Interval(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static class Builder {
                        private Map<String, Object> extraParams;
                        private Interval interval;
                        private Long intervalCount;

                        public Duration build() {
                            return new Duration(this.extraParams, this.interval, this.intervalCount);
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setInterval(Interval interval) {
                            this.interval = interval;
                            return this;
                        }

                        public Builder setIntervalCount(Long intervalCount) {
                            this.intervalCount = intervalCount;
                            return this;
                        }
                    }
                }

                public static enum Type implements ApiRequestParams.EnumParam
                {
                    DURATION("duration"),
                    TIMESTAMP("timestamp");

                    private final String value;

                    private Type(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Duration duration;
                    private Map<String, Object> extraParams;
                    private Long timestamp;
                    private Type type;

                    public DiscountEnd build() {
                        return new DiscountEnd(this.duration, this.extraParams, this.timestamp, this.type);
                    }

                    public Builder setDuration(Duration duration) {
                        this.duration = duration;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setTimestamp(Long timestamp) {
                        this.timestamp = timestamp;
                        return this;
                    }

                    public Builder setType(Type type) {
                        this.type = type;
                        return this;
                    }
                }
            }

            public static class Builder {
                private String coupon;
                private String discount;
                private DiscountEnd discountEnd;
                private Map<String, Object> extraParams;

                public Discount build() {
                    return new Discount(this.coupon, this.discount, this.discountEnd, this.extraParams);
                }

                public Builder setCoupon(String coupon) {
                    this.coupon = coupon;
                    return this;
                }

                public Builder setDiscount(String discount) {
                    this.discount = discount;
                    return this;
                }

                public Builder setDiscountEnd(DiscountEnd discountEnd) {
                    this.discountEnd = discountEnd;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }
    }

    public static class LineItem {
        @SerializedName(value="discounts")
        Object discounts;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="price")
        String price;
        @SerializedName(value="price_data")
        PriceData priceData;
        @SerializedName(value="quantity")
        Long quantity;
        @SerializedName(value="tax_rates")
        Object taxRates;

        private LineItem(Object discounts, Map<String, Object> extraParams, String price, PriceData priceData, Long quantity, Object taxRates) {
            this.discounts = discounts;
            this.extraParams = extraParams;
            this.price = price;
            this.priceData = priceData;
            this.quantity = quantity;
            this.taxRates = taxRates;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Object getDiscounts() {
            return this.discounts;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public String getPrice() {
            return this.price;
        }

        @Generated
        public PriceData getPriceData() {
            return this.priceData;
        }

        @Generated
        public Long getQuantity() {
            return this.quantity;
        }

        @Generated
        public Object getTaxRates() {
            return this.taxRates;
        }

        public static class PriceData {
            @SerializedName(value="currency")
            String currency;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="product")
            String product;
            @SerializedName(value="recurring")
            Recurring recurring;
            @SerializedName(value="tax_behavior")
            TaxBehavior taxBehavior;
            @SerializedName(value="unit_amount")
            Long unitAmount;
            @SerializedName(value="unit_amount_decimal")
            BigDecimal unitAmountDecimal;

            private PriceData(String currency, Map<String, Object> extraParams, String product, Recurring recurring, TaxBehavior taxBehavior, Long unitAmount, BigDecimal unitAmountDecimal) {
                this.currency = currency;
                this.extraParams = extraParams;
                this.product = product;
                this.recurring = recurring;
                this.taxBehavior = taxBehavior;
                this.unitAmount = unitAmount;
                this.unitAmountDecimal = unitAmountDecimal;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getCurrency() {
                return this.currency;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getProduct() {
                return this.product;
            }

            @Generated
            public Recurring getRecurring() {
                return this.recurring;
            }

            @Generated
            public TaxBehavior getTaxBehavior() {
                return this.taxBehavior;
            }

            @Generated
            public Long getUnitAmount() {
                return this.unitAmount;
            }

            @Generated
            public BigDecimal getUnitAmountDecimal() {
                return this.unitAmountDecimal;
            }

            public static class Recurring {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="interval")
                Interval interval;
                @SerializedName(value="interval_count")
                Long intervalCount;

                private Recurring(Map<String, Object> extraParams, Interval interval, Long intervalCount) {
                    this.extraParams = extraParams;
                    this.interval = interval;
                    this.intervalCount = intervalCount;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Interval getInterval() {
                    return this.interval;
                }

                @Generated
                public Long getIntervalCount() {
                    return this.intervalCount;
                }

                public static enum Interval implements ApiRequestParams.EnumParam
                {
                    DAY("day"),
                    MONTH("month"),
                    WEEK("week"),
                    YEAR("year");

                    private final String value;

                    private Interval(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Interval interval;
                    private Long intervalCount;

                    public Recurring build() {
                        return new Recurring(this.extraParams, this.interval, this.intervalCount);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setInterval(Interval interval) {
                        this.interval = interval;
                        return this;
                    }

                    public Builder setIntervalCount(Long intervalCount) {
                        this.intervalCount = intervalCount;
                        return this;
                    }
                }
            }

            public static enum TaxBehavior implements ApiRequestParams.EnumParam
            {
                EXCLUSIVE("exclusive"),
                INCLUSIVE("inclusive"),
                UNSPECIFIED("unspecified");

                private final String value;

                private TaxBehavior(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private String currency;
                private Map<String, Object> extraParams;
                private String product;
                private Recurring recurring;
                private TaxBehavior taxBehavior;
                private Long unitAmount;
                private BigDecimal unitAmountDecimal;

                public PriceData build() {
                    return new PriceData(this.currency, this.extraParams, this.product, this.recurring, this.taxBehavior, this.unitAmount, this.unitAmountDecimal);
                }

                public Builder setCurrency(String currency) {
                    this.currency = currency;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setProduct(String product) {
                    this.product = product;
                    return this;
                }

                public Builder setRecurring(Recurring recurring) {
                    this.recurring = recurring;
                    return this;
                }

                public Builder setTaxBehavior(TaxBehavior taxBehavior) {
                    this.taxBehavior = taxBehavior;
                    return this;
                }

                public Builder setUnitAmount(Long unitAmount) {
                    this.unitAmount = unitAmount;
                    return this;
                }

                public Builder setUnitAmountDecimal(BigDecimal unitAmountDecimal) {
                    this.unitAmountDecimal = unitAmountDecimal;
                    return this;
                }
            }
        }

        public static class Builder {
            private Object discounts;
            private Map<String, Object> extraParams;
            private String price;
            private PriceData priceData;
            private Long quantity;
            private Object taxRates;

            public LineItem build() {
                return new LineItem(this.discounts, this.extraParams, this.price, this.priceData, this.quantity, this.taxRates);
            }

            public Builder addDiscount(Discount element) {
                if (this.discounts == null || this.discounts instanceof EmptyParam) {
                    this.discounts = new ArrayList();
                }
                ((List)this.discounts).add(element);
                return this;
            }

            public Builder addAllDiscount(List<Discount> elements) {
                if (this.discounts == null || this.discounts instanceof EmptyParam) {
                    this.discounts = new ArrayList();
                }
                ((List)this.discounts).addAll(elements);
                return this;
            }

            public Builder setDiscounts(EmptyParam discounts) {
                this.discounts = discounts;
                return this;
            }

            public Builder setDiscounts(List<Discount> discounts) {
                this.discounts = discounts;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setPrice(String price) {
                this.price = price;
                return this;
            }

            public Builder setPriceData(PriceData priceData) {
                this.priceData = priceData;
                return this;
            }

            public Builder setQuantity(Long quantity) {
                this.quantity = quantity;
                return this;
            }

            public Builder addTaxRate(String element) {
                if (this.taxRates == null || this.taxRates instanceof EmptyParam) {
                    this.taxRates = new ArrayList();
                }
                ((List)this.taxRates).add(element);
                return this;
            }

            public Builder addAllTaxRate(List<String> elements) {
                if (this.taxRates == null || this.taxRates instanceof EmptyParam) {
                    this.taxRates = new ArrayList();
                }
                ((List)this.taxRates).addAll(elements);
                return this;
            }

            public Builder setTaxRates(EmptyParam taxRates) {
                this.taxRates = taxRates;
                return this;
            }

            public Builder setTaxRates(List<String> taxRates) {
                this.taxRates = taxRates;
                return this;
            }
        }

        public static class Discount {
            @SerializedName(value="coupon")
            String coupon;
            @SerializedName(value="discount")
            String discount;
            @SerializedName(value="discount_end")
            DiscountEnd discountEnd;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Discount(String coupon, String discount, DiscountEnd discountEnd, Map<String, Object> extraParams) {
                this.coupon = coupon;
                this.discount = discount;
                this.discountEnd = discountEnd;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getCoupon() {
                return this.coupon;
            }

            @Generated
            public String getDiscount() {
                return this.discount;
            }

            @Generated
            public DiscountEnd getDiscountEnd() {
                return this.discountEnd;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class DiscountEnd {
                @SerializedName(value="duration")
                Duration duration;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="timestamp")
                Long timestamp;
                @SerializedName(value="type")
                Type type;

                private DiscountEnd(Duration duration, Map<String, Object> extraParams, Long timestamp, Type type) {
                    this.duration = duration;
                    this.extraParams = extraParams;
                    this.timestamp = timestamp;
                    this.type = type;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Duration getDuration() {
                    return this.duration;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Long getTimestamp() {
                    return this.timestamp;
                }

                @Generated
                public Type getType() {
                    return this.type;
                }

                public static class Duration {
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="interval")
                    Interval interval;
                    @SerializedName(value="interval_count")
                    Long intervalCount;

                    private Duration(Map<String, Object> extraParams, Interval interval, Long intervalCount) {
                        this.extraParams = extraParams;
                        this.interval = interval;
                        this.intervalCount = intervalCount;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Interval getInterval() {
                        return this.interval;
                    }

                    @Generated
                    public Long getIntervalCount() {
                        return this.intervalCount;
                    }

                    public static enum Interval implements ApiRequestParams.EnumParam
                    {
                        DAY("day"),
                        MONTH("month"),
                        WEEK("week"),
                        YEAR("year");

                        private final String value;

                        private Interval(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static class Builder {
                        private Map<String, Object> extraParams;
                        private Interval interval;
                        private Long intervalCount;

                        public Duration build() {
                            return new Duration(this.extraParams, this.interval, this.intervalCount);
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setInterval(Interval interval) {
                            this.interval = interval;
                            return this;
                        }

                        public Builder setIntervalCount(Long intervalCount) {
                            this.intervalCount = intervalCount;
                            return this;
                        }
                    }
                }

                public static enum Type implements ApiRequestParams.EnumParam
                {
                    DURATION("duration"),
                    TIMESTAMP("timestamp");

                    private final String value;

                    private Type(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Duration duration;
                    private Map<String, Object> extraParams;
                    private Long timestamp;
                    private Type type;

                    public DiscountEnd build() {
                        return new DiscountEnd(this.duration, this.extraParams, this.timestamp, this.type);
                    }

                    public Builder setDuration(Duration duration) {
                        this.duration = duration;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setTimestamp(Long timestamp) {
                        this.timestamp = timestamp;
                        return this;
                    }

                    public Builder setType(Type type) {
                        this.type = type;
                        return this;
                    }
                }
            }

            public static class Builder {
                private String coupon;
                private String discount;
                private DiscountEnd discountEnd;
                private Map<String, Object> extraParams;

                public Discount build() {
                    return new Discount(this.coupon, this.discount, this.discountEnd, this.extraParams);
                }

                public Builder setCoupon(String coupon) {
                    this.coupon = coupon;
                    return this;
                }

                public Builder setDiscount(String discount) {
                    this.discount = discount;
                    return this;
                }

                public Builder setDiscountEnd(DiscountEnd discountEnd) {
                    this.discountEnd = discountEnd;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }
    }

    public static class Line {
        @SerializedName(value="actions")
        List<Action> actions;
        @SerializedName(value="applies_to")
        AppliesTo appliesTo;
        @SerializedName(value="billing_cycle_anchor")
        BillingCycleAnchor billingCycleAnchor;
        @SerializedName(value="ends_at")
        EndsAt endsAt;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="proration_behavior")
        ProrationBehavior prorationBehavior;
        @SerializedName(value="starts_at")
        StartsAt startsAt;
        @SerializedName(value="trial_settings")
        TrialSettings trialSettings;

        private Line(List<Action> actions, AppliesTo appliesTo, BillingCycleAnchor billingCycleAnchor, EndsAt endsAt, Map<String, Object> extraParams, ProrationBehavior prorationBehavior, StartsAt startsAt, TrialSettings trialSettings) {
            this.actions = actions;
            this.appliesTo = appliesTo;
            this.billingCycleAnchor = billingCycleAnchor;
            this.endsAt = endsAt;
            this.extraParams = extraParams;
            this.prorationBehavior = prorationBehavior;
            this.startsAt = startsAt;
            this.trialSettings = trialSettings;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public List<Action> getActions() {
            return this.actions;
        }

        @Generated
        public AppliesTo getAppliesTo() {
            return this.appliesTo;
        }

        @Generated
        public BillingCycleAnchor getBillingCycleAnchor() {
            return this.billingCycleAnchor;
        }

        @Generated
        public EndsAt getEndsAt() {
            return this.endsAt;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public ProrationBehavior getProrationBehavior() {
            return this.prorationBehavior;
        }

        @Generated
        public StartsAt getStartsAt() {
            return this.startsAt;
        }

        @Generated
        public TrialSettings getTrialSettings() {
            return this.trialSettings;
        }

        public static class AppliesTo {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="new_reference")
            String newReference;
            @SerializedName(value="subscription_schedule")
            String subscriptionSchedule;
            @SerializedName(value="type")
            Type type;

            private AppliesTo(Map<String, Object> extraParams, String newReference, String subscriptionSchedule, Type type) {
                this.extraParams = extraParams;
                this.newReference = newReference;
                this.subscriptionSchedule = subscriptionSchedule;
                this.type = type;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getNewReference() {
                return this.newReference;
            }

            @Generated
            public String getSubscriptionSchedule() {
                return this.subscriptionSchedule;
            }

            @Generated
            public Type getType() {
                return this.type;
            }

            public static enum Type implements ApiRequestParams.EnumParam
            {
                NEW_REFERENCE("new_reference"),
                SUBSCRIPTION_SCHEDULE("subscription_schedule");

                private final String value;

                private Type(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private String newReference;
                private String subscriptionSchedule;
                private Type type;

                public AppliesTo build() {
                    return new AppliesTo(this.extraParams, this.newReference, this.subscriptionSchedule, this.type);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setNewReference(String newReference) {
                    this.newReference = newReference;
                    return this;
                }

                public Builder setSubscriptionSchedule(String subscriptionSchedule) {
                    this.subscriptionSchedule = subscriptionSchedule;
                    return this;
                }

                public Builder setType(Type type) {
                    this.type = type;
                    return this;
                }
            }
        }

        public static enum BillingCycleAnchor implements ApiRequestParams.EnumParam
        {
            AUTOMATIC("automatic"),
            LINE_STARTS_AT("line_starts_at");

            private final String value;

            private BillingCycleAnchor(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class EndsAt {
            @SerializedName(value="discount_end")
            DiscountEnd discountEnd;
            @SerializedName(value="duration")
            Duration duration;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="timestamp")
            Long timestamp;
            @SerializedName(value="type")
            Type type;

            private EndsAt(DiscountEnd discountEnd, Duration duration, Map<String, Object> extraParams, Long timestamp, Type type) {
                this.discountEnd = discountEnd;
                this.duration = duration;
                this.extraParams = extraParams;
                this.timestamp = timestamp;
                this.type = type;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public DiscountEnd getDiscountEnd() {
                return this.discountEnd;
            }

            @Generated
            public Duration getDuration() {
                return this.duration;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Long getTimestamp() {
                return this.timestamp;
            }

            @Generated
            public Type getType() {
                return this.type;
            }

            public static class DiscountEnd {
                @SerializedName(value="discount")
                String discount;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;

                private DiscountEnd(String discount, Map<String, Object> extraParams) {
                    this.discount = discount;
                    this.extraParams = extraParams;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getDiscount() {
                    return this.discount;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                public static class Builder {
                    private String discount;
                    private Map<String, Object> extraParams;

                    public DiscountEnd build() {
                        return new DiscountEnd(this.discount, this.extraParams);
                    }

                    public Builder setDiscount(String discount) {
                        this.discount = discount;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }
                }
            }

            public static class Duration {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="interval")
                Interval interval;
                @SerializedName(value="interval_count")
                Long intervalCount;

                private Duration(Map<String, Object> extraParams, Interval interval, Long intervalCount) {
                    this.extraParams = extraParams;
                    this.interval = interval;
                    this.intervalCount = intervalCount;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Interval getInterval() {
                    return this.interval;
                }

                @Generated
                public Long getIntervalCount() {
                    return this.intervalCount;
                }

                public static enum Interval implements ApiRequestParams.EnumParam
                {
                    DAY("day"),
                    MONTH("month"),
                    WEEK("week"),
                    YEAR("year");

                    private final String value;

                    private Interval(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Interval interval;
                    private Long intervalCount;

                    public Duration build() {
                        return new Duration(this.extraParams, this.interval, this.intervalCount);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setInterval(Interval interval) {
                        this.interval = interval;
                        return this;
                    }

                    public Builder setIntervalCount(Long intervalCount) {
                        this.intervalCount = intervalCount;
                        return this;
                    }
                }
            }

            public static enum Type implements ApiRequestParams.EnumParam
            {
                DISCOUNT_END("discount_end"),
                DURATION("duration"),
                QUOTE_ACCEPTANCE_DATE("quote_acceptance_date"),
                SCHEDULE_END("schedule_end"),
                TIMESTAMP("timestamp"),
                UPCOMING_INVOICE("upcoming_invoice");

                private final String value;

                private Type(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private DiscountEnd discountEnd;
                private Duration duration;
                private Map<String, Object> extraParams;
                private Long timestamp;
                private Type type;

                public EndsAt build() {
                    return new EndsAt(this.discountEnd, this.duration, this.extraParams, this.timestamp, this.type);
                }

                public Builder setDiscountEnd(DiscountEnd discountEnd) {
                    this.discountEnd = discountEnd;
                    return this;
                }

                public Builder setDuration(Duration duration) {
                    this.duration = duration;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setTimestamp(Long timestamp) {
                    this.timestamp = timestamp;
                    return this;
                }

                public Builder setType(Type type) {
                    this.type = type;
                    return this;
                }
            }
        }

        public static enum ProrationBehavior implements ApiRequestParams.EnumParam
        {
            ALWAYS_INVOICE("always_invoice"),
            CREATE_PRORATIONS("create_prorations"),
            NONE("none");

            private final String value;

            private ProrationBehavior(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class StartsAt {
            @SerializedName(value="discount_end")
            DiscountEnd discountEnd;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="line_ends_at")
            LineEndsAt lineEndsAt;
            @SerializedName(value="timestamp")
            Long timestamp;
            @SerializedName(value="type")
            Type type;

            private StartsAt(DiscountEnd discountEnd, Map<String, Object> extraParams, LineEndsAt lineEndsAt, Long timestamp, Type type) {
                this.discountEnd = discountEnd;
                this.extraParams = extraParams;
                this.lineEndsAt = lineEndsAt;
                this.timestamp = timestamp;
                this.type = type;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public DiscountEnd getDiscountEnd() {
                return this.discountEnd;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public LineEndsAt getLineEndsAt() {
                return this.lineEndsAt;
            }

            @Generated
            public Long getTimestamp() {
                return this.timestamp;
            }

            @Generated
            public Type getType() {
                return this.type;
            }

            public static class DiscountEnd {
                @SerializedName(value="discount")
                String discount;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;

                private DiscountEnd(String discount, Map<String, Object> extraParams) {
                    this.discount = discount;
                    this.extraParams = extraParams;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getDiscount() {
                    return this.discount;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                public static class Builder {
                    private String discount;
                    private Map<String, Object> extraParams;

                    public DiscountEnd build() {
                        return new DiscountEnd(this.discount, this.extraParams);
                    }

                    public Builder setDiscount(String discount) {
                        this.discount = discount;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }
                }
            }

            public static class LineEndsAt {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="id")
                String id;
                @SerializedName(value="index")
                Long index;

                private LineEndsAt(Map<String, Object> extraParams, String id, Long index) {
                    this.extraParams = extraParams;
                    this.id = id;
                    this.index = index;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getId() {
                    return this.id;
                }

                @Generated
                public Long getIndex() {
                    return this.index;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private String id;
                    private Long index;

                    public LineEndsAt build() {
                        return new LineEndsAt(this.extraParams, this.id, this.index);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setId(String id) {
                        this.id = id;
                        return this;
                    }

                    public Builder setIndex(Long index) {
                        this.index = index;
                        return this;
                    }
                }
            }

            public static enum Type implements ApiRequestParams.EnumParam
            {
                DISCOUNT_END("discount_end"),
                LINE_ENDS_AT("line_ends_at"),
                NOW("now"),
                QUOTE_ACCEPTANCE_DATE("quote_acceptance_date"),
                SCHEDULE_END("schedule_end"),
                TIMESTAMP("timestamp"),
                UPCOMING_INVOICE("upcoming_invoice");

                private final String value;

                private Type(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private DiscountEnd discountEnd;
                private Map<String, Object> extraParams;
                private LineEndsAt lineEndsAt;
                private Long timestamp;
                private Type type;

                public StartsAt build() {
                    return new StartsAt(this.discountEnd, this.extraParams, this.lineEndsAt, this.timestamp, this.type);
                }

                public Builder setDiscountEnd(DiscountEnd discountEnd) {
                    this.discountEnd = discountEnd;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setLineEndsAt(LineEndsAt lineEndsAt) {
                    this.lineEndsAt = lineEndsAt;
                    return this;
                }

                public Builder setTimestamp(Long timestamp) {
                    this.timestamp = timestamp;
                    return this;
                }

                public Builder setType(Type type) {
                    this.type = type;
                    return this;
                }
            }
        }

        public static class TrialSettings {
            @SerializedName(value="end_behavior")
            EndBehavior endBehavior;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private TrialSettings(EndBehavior endBehavior, Map<String, Object> extraParams) {
                this.endBehavior = endBehavior;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public EndBehavior getEndBehavior() {
                return this.endBehavior;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class EndBehavior {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="prorate_up_front")
                ProrateUpFront prorateUpFront;

                private EndBehavior(Map<String, Object> extraParams, ProrateUpFront prorateUpFront) {
                    this.extraParams = extraParams;
                    this.prorateUpFront = prorateUpFront;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public ProrateUpFront getProrateUpFront() {
                    return this.prorateUpFront;
                }

                public static enum ProrateUpFront implements ApiRequestParams.EnumParam
                {
                    DEFER("defer"),
                    INCLUDE("include");

                    private final String value;

                    private ProrateUpFront(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private ProrateUpFront prorateUpFront;

                    public EndBehavior build() {
                        return new EndBehavior(this.extraParams, this.prorateUpFront);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setProrateUpFront(ProrateUpFront prorateUpFront) {
                        this.prorateUpFront = prorateUpFront;
                        return this;
                    }
                }
            }

            public static class Builder {
                private EndBehavior endBehavior;
                private Map<String, Object> extraParams;

                public TrialSettings build() {
                    return new TrialSettings(this.endBehavior, this.extraParams);
                }

                public Builder setEndBehavior(EndBehavior endBehavior) {
                    this.endBehavior = endBehavior;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Builder {
            private List<Action> actions;
            private AppliesTo appliesTo;
            private BillingCycleAnchor billingCycleAnchor;
            private EndsAt endsAt;
            private Map<String, Object> extraParams;
            private ProrationBehavior prorationBehavior;
            private StartsAt startsAt;
            private TrialSettings trialSettings;

            public Line build() {
                return new Line(this.actions, this.appliesTo, this.billingCycleAnchor, this.endsAt, this.extraParams, this.prorationBehavior, this.startsAt, this.trialSettings);
            }

            public Builder addAction(Action element) {
                if (this.actions == null) {
                    this.actions = new ArrayList<Action>();
                }
                this.actions.add(element);
                return this;
            }

            public Builder addAllAction(List<Action> elements) {
                if (this.actions == null) {
                    this.actions = new ArrayList<Action>();
                }
                this.actions.addAll(elements);
                return this;
            }

            public Builder setAppliesTo(AppliesTo appliesTo) {
                this.appliesTo = appliesTo;
                return this;
            }

            public Builder setBillingCycleAnchor(BillingCycleAnchor billingCycleAnchor) {
                this.billingCycleAnchor = billingCycleAnchor;
                return this;
            }

            public Builder setEndsAt(EndsAt endsAt) {
                this.endsAt = endsAt;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setProrationBehavior(ProrationBehavior prorationBehavior) {
                this.prorationBehavior = prorationBehavior;
                return this;
            }

            public Builder setStartsAt(StartsAt startsAt) {
                this.startsAt = startsAt;
                return this;
            }

            public Builder setTrialSettings(TrialSettings trialSettings) {
                this.trialSettings = trialSettings;
                return this;
            }
        }

        public static class Action {
            @SerializedName(value="add_discount")
            AddDiscount addDiscount;
            @SerializedName(value="add_item")
            AddItem addItem;
            @SerializedName(value="add_metadata")
            Map<String, String> addMetadata;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="remove_discount")
            RemoveDiscount removeDiscount;
            @SerializedName(value="remove_item")
            RemoveItem removeItem;
            @SerializedName(value="remove_metadata")
            List<String> removeMetadata;
            @SerializedName(value="set_discounts")
            List<SetDiscount> setDiscounts;
            @SerializedName(value="set_items")
            List<SetItem> setItems;
            @SerializedName(value="set_metadata")
            Object setMetadata;
            @SerializedName(value="type")
            Type type;

            private Action(AddDiscount addDiscount, AddItem addItem, Map<String, String> addMetadata, Map<String, Object> extraParams, RemoveDiscount removeDiscount, RemoveItem removeItem, List<String> removeMetadata, List<SetDiscount> setDiscounts, List<SetItem> setItems, Object setMetadata, Type type) {
                this.addDiscount = addDiscount;
                this.addItem = addItem;
                this.addMetadata = addMetadata;
                this.extraParams = extraParams;
                this.removeDiscount = removeDiscount;
                this.removeItem = removeItem;
                this.removeMetadata = removeMetadata;
                this.setDiscounts = setDiscounts;
                this.setItems = setItems;
                this.setMetadata = setMetadata;
                this.type = type;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public AddDiscount getAddDiscount() {
                return this.addDiscount;
            }

            @Generated
            public AddItem getAddItem() {
                return this.addItem;
            }

            @Generated
            public Map<String, String> getAddMetadata() {
                return this.addMetadata;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public RemoveDiscount getRemoveDiscount() {
                return this.removeDiscount;
            }

            @Generated
            public RemoveItem getRemoveItem() {
                return this.removeItem;
            }

            @Generated
            public List<String> getRemoveMetadata() {
                return this.removeMetadata;
            }

            @Generated
            public List<SetDiscount> getSetDiscounts() {
                return this.setDiscounts;
            }

            @Generated
            public List<SetItem> getSetItems() {
                return this.setItems;
            }

            @Generated
            public Object getSetMetadata() {
                return this.setMetadata;
            }

            @Generated
            public Type getType() {
                return this.type;
            }

            public static class AddDiscount {
                @SerializedName(value="coupon")
                String coupon;
                @SerializedName(value="discount")
                String discount;
                @SerializedName(value="discount_end")
                DiscountEnd discountEnd;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="index")
                Long index;

                private AddDiscount(String coupon, String discount, DiscountEnd discountEnd, Map<String, Object> extraParams, Long index) {
                    this.coupon = coupon;
                    this.discount = discount;
                    this.discountEnd = discountEnd;
                    this.extraParams = extraParams;
                    this.index = index;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getCoupon() {
                    return this.coupon;
                }

                @Generated
                public String getDiscount() {
                    return this.discount;
                }

                @Generated
                public DiscountEnd getDiscountEnd() {
                    return this.discountEnd;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Long getIndex() {
                    return this.index;
                }

                public static class DiscountEnd {
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="type")
                    Type type;

                    private DiscountEnd(Map<String, Object> extraParams, Type type) {
                        this.extraParams = extraParams;
                        this.type = type;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Type getType() {
                        return this.type;
                    }

                    public static enum Type implements ApiRequestParams.EnumParam
                    {
                        LINE_ENDS_AT("line_ends_at");

                        private final String value;

                        private Type(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static class Builder {
                        private Map<String, Object> extraParams;
                        private Type type;

                        public DiscountEnd build() {
                            return new DiscountEnd(this.extraParams, this.type);
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setType(Type type) {
                            this.type = type;
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private String coupon;
                    private String discount;
                    private DiscountEnd discountEnd;
                    private Map<String, Object> extraParams;
                    private Long index;

                    public AddDiscount build() {
                        return new AddDiscount(this.coupon, this.discount, this.discountEnd, this.extraParams, this.index);
                    }

                    public Builder setCoupon(String coupon) {
                        this.coupon = coupon;
                        return this;
                    }

                    public Builder setDiscount(String discount) {
                        this.discount = discount;
                        return this;
                    }

                    public Builder setDiscountEnd(DiscountEnd discountEnd) {
                        this.discountEnd = discountEnd;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setIndex(Long index) {
                        this.index = index;
                        return this;
                    }
                }
            }

            public static class AddItem {
                @SerializedName(value="discounts")
                List<Discount> discounts;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="metadata")
                Map<String, String> metadata;
                @SerializedName(value="price")
                String price;
                @SerializedName(value="quantity")
                Long quantity;
                @SerializedName(value="tax_rates")
                List<String> taxRates;
                @SerializedName(value="trial")
                Trial trial;

                private AddItem(List<Discount> discounts, Map<String, Object> extraParams, Map<String, String> metadata, String price, Long quantity, List<String> taxRates, Trial trial) {
                    this.discounts = discounts;
                    this.extraParams = extraParams;
                    this.metadata = metadata;
                    this.price = price;
                    this.quantity = quantity;
                    this.taxRates = taxRates;
                    this.trial = trial;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public List<Discount> getDiscounts() {
                    return this.discounts;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Map<String, String> getMetadata() {
                    return this.metadata;
                }

                @Generated
                public String getPrice() {
                    return this.price;
                }

                @Generated
                public Long getQuantity() {
                    return this.quantity;
                }

                @Generated
                public List<String> getTaxRates() {
                    return this.taxRates;
                }

                @Generated
                public Trial getTrial() {
                    return this.trial;
                }

                public static class Trial {
                    @SerializedName(value="converts_to")
                    List<String> convertsTo;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="type")
                    Type type;

                    private Trial(List<String> convertsTo, Map<String, Object> extraParams, Type type) {
                        this.convertsTo = convertsTo;
                        this.extraParams = extraParams;
                        this.type = type;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public List<String> getConvertsTo() {
                        return this.convertsTo;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Type getType() {
                        return this.type;
                    }

                    public static enum Type implements ApiRequestParams.EnumParam
                    {
                        FREE("free"),
                        PAID("paid");

                        private final String value;

                        private Type(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static class Builder {
                        private List<String> convertsTo;
                        private Map<String, Object> extraParams;
                        private Type type;

                        public Trial build() {
                            return new Trial(this.convertsTo, this.extraParams, this.type);
                        }

                        public Builder addConvertsTo(String element) {
                            if (this.convertsTo == null) {
                                this.convertsTo = new ArrayList<String>();
                            }
                            this.convertsTo.add(element);
                            return this;
                        }

                        public Builder addAllConvertsTo(List<String> elements) {
                            if (this.convertsTo == null) {
                                this.convertsTo = new ArrayList<String>();
                            }
                            this.convertsTo.addAll(elements);
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setType(Type type) {
                            this.type = type;
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private List<Discount> discounts;
                    private Map<String, Object> extraParams;
                    private Map<String, String> metadata;
                    private String price;
                    private Long quantity;
                    private List<String> taxRates;
                    private Trial trial;

                    public AddItem build() {
                        return new AddItem(this.discounts, this.extraParams, this.metadata, this.price, this.quantity, this.taxRates, this.trial);
                    }

                    public Builder addDiscount(Discount element) {
                        if (this.discounts == null) {
                            this.discounts = new ArrayList<Discount>();
                        }
                        this.discounts.add(element);
                        return this;
                    }

                    public Builder addAllDiscount(List<Discount> elements) {
                        if (this.discounts == null) {
                            this.discounts = new ArrayList<Discount>();
                        }
                        this.discounts.addAll(elements);
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder putMetadata(String key, String value) {
                        if (this.metadata == null) {
                            this.metadata = new HashMap<String, String>();
                        }
                        this.metadata.put(key, value);
                        return this;
                    }

                    public Builder putAllMetadata(Map<String, String> map) {
                        if (this.metadata == null) {
                            this.metadata = new HashMap<String, String>();
                        }
                        this.metadata.putAll(map);
                        return this;
                    }

                    public Builder setPrice(String price) {
                        this.price = price;
                        return this;
                    }

                    public Builder setQuantity(Long quantity) {
                        this.quantity = quantity;
                        return this;
                    }

                    public Builder addTaxRate(String element) {
                        if (this.taxRates == null) {
                            this.taxRates = new ArrayList<String>();
                        }
                        this.taxRates.add(element);
                        return this;
                    }

                    public Builder addAllTaxRate(List<String> elements) {
                        if (this.taxRates == null) {
                            this.taxRates = new ArrayList<String>();
                        }
                        this.taxRates.addAll(elements);
                        return this;
                    }

                    public Builder setTrial(Trial trial) {
                        this.trial = trial;
                        return this;
                    }
                }

                public static class Discount {
                    @SerializedName(value="coupon")
                    String coupon;
                    @SerializedName(value="discount")
                    String discount;
                    @SerializedName(value="discount_end")
                    DiscountEnd discountEnd;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;

                    private Discount(String coupon, String discount, DiscountEnd discountEnd, Map<String, Object> extraParams) {
                        this.coupon = coupon;
                        this.discount = discount;
                        this.discountEnd = discountEnd;
                        this.extraParams = extraParams;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public String getCoupon() {
                        return this.coupon;
                    }

                    @Generated
                    public String getDiscount() {
                        return this.discount;
                    }

                    @Generated
                    public DiscountEnd getDiscountEnd() {
                        return this.discountEnd;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    public static class DiscountEnd {
                        @SerializedName(value="duration")
                        Duration duration;
                        @SerializedName(value="_stripe_java_extra_param_key")
                        Map<String, Object> extraParams;
                        @SerializedName(value="timestamp")
                        Long timestamp;
                        @SerializedName(value="type")
                        Type type;

                        private DiscountEnd(Duration duration, Map<String, Object> extraParams, Long timestamp, Type type) {
                            this.duration = duration;
                            this.extraParams = extraParams;
                            this.timestamp = timestamp;
                            this.type = type;
                        }

                        public static Builder builder() {
                            return new Builder();
                        }

                        @Generated
                        public Duration getDuration() {
                            return this.duration;
                        }

                        @Generated
                        public Map<String, Object> getExtraParams() {
                            return this.extraParams;
                        }

                        @Generated
                        public Long getTimestamp() {
                            return this.timestamp;
                        }

                        @Generated
                        public Type getType() {
                            return this.type;
                        }

                        public static class Duration {
                            @SerializedName(value="_stripe_java_extra_param_key")
                            Map<String, Object> extraParams;
                            @SerializedName(value="interval")
                            Interval interval;
                            @SerializedName(value="interval_count")
                            Long intervalCount;

                            private Duration(Map<String, Object> extraParams, Interval interval, Long intervalCount) {
                                this.extraParams = extraParams;
                                this.interval = interval;
                                this.intervalCount = intervalCount;
                            }

                            public static Builder builder() {
                                return new Builder();
                            }

                            @Generated
                            public Map<String, Object> getExtraParams() {
                                return this.extraParams;
                            }

                            @Generated
                            public Interval getInterval() {
                                return this.interval;
                            }

                            @Generated
                            public Long getIntervalCount() {
                                return this.intervalCount;
                            }

                            public static enum Interval implements ApiRequestParams.EnumParam
                            {
                                DAY("day"),
                                MONTH("month"),
                                WEEK("week"),
                                YEAR("year");

                                private final String value;

                                private Interval(String value) {
                                    this.value = value;
                                }

                                @Override
                                @Generated
                                public String getValue() {
                                    return this.value;
                                }
                            }

                            public static class Builder {
                                private Map<String, Object> extraParams;
                                private Interval interval;
                                private Long intervalCount;

                                public Duration build() {
                                    return new Duration(this.extraParams, this.interval, this.intervalCount);
                                }

                                public Builder putExtraParam(String key, Object value) {
                                    if (this.extraParams == null) {
                                        this.extraParams = new HashMap<String, Object>();
                                    }
                                    this.extraParams.put(key, value);
                                    return this;
                                }

                                public Builder putAllExtraParam(Map<String, Object> map) {
                                    if (this.extraParams == null) {
                                        this.extraParams = new HashMap<String, Object>();
                                    }
                                    this.extraParams.putAll(map);
                                    return this;
                                }

                                public Builder setInterval(Interval interval) {
                                    this.interval = interval;
                                    return this;
                                }

                                public Builder setIntervalCount(Long intervalCount) {
                                    this.intervalCount = intervalCount;
                                    return this;
                                }
                            }
                        }

                        public static enum Type implements ApiRequestParams.EnumParam
                        {
                            DURATION("duration"),
                            TIMESTAMP("timestamp");

                            private final String value;

                            private Type(String value) {
                                this.value = value;
                            }

                            @Override
                            @Generated
                            public String getValue() {
                                return this.value;
                            }
                        }

                        public static class Builder {
                            private Duration duration;
                            private Map<String, Object> extraParams;
                            private Long timestamp;
                            private Type type;

                            public DiscountEnd build() {
                                return new DiscountEnd(this.duration, this.extraParams, this.timestamp, this.type);
                            }

                            public Builder setDuration(Duration duration) {
                                this.duration = duration;
                                return this;
                            }

                            public Builder putExtraParam(String key, Object value) {
                                if (this.extraParams == null) {
                                    this.extraParams = new HashMap<String, Object>();
                                }
                                this.extraParams.put(key, value);
                                return this;
                            }

                            public Builder putAllExtraParam(Map<String, Object> map) {
                                if (this.extraParams == null) {
                                    this.extraParams = new HashMap<String, Object>();
                                }
                                this.extraParams.putAll(map);
                                return this;
                            }

                            public Builder setTimestamp(Long timestamp) {
                                this.timestamp = timestamp;
                                return this;
                            }

                            public Builder setType(Type type) {
                                this.type = type;
                                return this;
                            }
                        }
                    }

                    public static class Builder {
                        private String coupon;
                        private String discount;
                        private DiscountEnd discountEnd;
                        private Map<String, Object> extraParams;

                        public Discount build() {
                            return new Discount(this.coupon, this.discount, this.discountEnd, this.extraParams);
                        }

                        public Builder setCoupon(String coupon) {
                            this.coupon = coupon;
                            return this;
                        }

                        public Builder setDiscount(String discount) {
                            this.discount = discount;
                            return this;
                        }

                        public Builder setDiscountEnd(DiscountEnd discountEnd) {
                            this.discountEnd = discountEnd;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }
                    }
                }
            }

            public static class RemoveDiscount {
                @SerializedName(value="coupon")
                String coupon;
                @SerializedName(value="discount")
                String discount;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;

                private RemoveDiscount(String coupon, String discount, Map<String, Object> extraParams) {
                    this.coupon = coupon;
                    this.discount = discount;
                    this.extraParams = extraParams;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getCoupon() {
                    return this.coupon;
                }

                @Generated
                public String getDiscount() {
                    return this.discount;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                public static class Builder {
                    private String coupon;
                    private String discount;
                    private Map<String, Object> extraParams;

                    public RemoveDiscount build() {
                        return new RemoveDiscount(this.coupon, this.discount, this.extraParams);
                    }

                    public Builder setCoupon(String coupon) {
                        this.coupon = coupon;
                        return this;
                    }

                    public Builder setDiscount(String discount) {
                        this.discount = discount;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }
                }
            }

            public static class RemoveItem {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="price")
                String price;

                private RemoveItem(Map<String, Object> extraParams, String price) {
                    this.extraParams = extraParams;
                    this.price = price;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getPrice() {
                    return this.price;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private String price;

                    public RemoveItem build() {
                        return new RemoveItem(this.extraParams, this.price);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setPrice(String price) {
                        this.price = price;
                        return this;
                    }
                }
            }

            public static enum Type implements ApiRequestParams.EnumParam
            {
                ADD_DISCOUNT("add_discount"),
                ADD_ITEM("add_item"),
                ADD_METADATA("add_metadata"),
                CLEAR_DISCOUNTS("clear_discounts"),
                CLEAR_METADATA("clear_metadata"),
                REMOVE_DISCOUNT("remove_discount"),
                REMOVE_ITEM("remove_item"),
                REMOVE_METADATA("remove_metadata"),
                SET_DISCOUNTS("set_discounts"),
                SET_ITEMS("set_items"),
                SET_METADATA("set_metadata");

                private final String value;

                private Type(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private AddDiscount addDiscount;
                private AddItem addItem;
                private Map<String, String> addMetadata;
                private Map<String, Object> extraParams;
                private RemoveDiscount removeDiscount;
                private RemoveItem removeItem;
                private List<String> removeMetadata;
                private List<SetDiscount> setDiscounts;
                private List<SetItem> setItems;
                private Object setMetadata;
                private Type type;

                public Action build() {
                    return new Action(this.addDiscount, this.addItem, this.addMetadata, this.extraParams, this.removeDiscount, this.removeItem, this.removeMetadata, this.setDiscounts, this.setItems, this.setMetadata, this.type);
                }

                public Builder setAddDiscount(AddDiscount addDiscount) {
                    this.addDiscount = addDiscount;
                    return this;
                }

                public Builder setAddItem(AddItem addItem) {
                    this.addItem = addItem;
                    return this;
                }

                public Builder putAddMetadata(String key, String value) {
                    if (this.addMetadata == null) {
                        this.addMetadata = new HashMap<String, String>();
                    }
                    this.addMetadata.put(key, value);
                    return this;
                }

                public Builder putAllAddMetadata(Map<String, String> map) {
                    if (this.addMetadata == null) {
                        this.addMetadata = new HashMap<String, String>();
                    }
                    this.addMetadata.putAll(map);
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setRemoveDiscount(RemoveDiscount removeDiscount) {
                    this.removeDiscount = removeDiscount;
                    return this;
                }

                public Builder setRemoveItem(RemoveItem removeItem) {
                    this.removeItem = removeItem;
                    return this;
                }

                public Builder addRemoveMetadata(String element) {
                    if (this.removeMetadata == null) {
                        this.removeMetadata = new ArrayList<String>();
                    }
                    this.removeMetadata.add(element);
                    return this;
                }

                public Builder addAllRemoveMetadata(List<String> elements) {
                    if (this.removeMetadata == null) {
                        this.removeMetadata = new ArrayList<String>();
                    }
                    this.removeMetadata.addAll(elements);
                    return this;
                }

                public Builder addSetDiscount(SetDiscount element) {
                    if (this.setDiscounts == null) {
                        this.setDiscounts = new ArrayList<SetDiscount>();
                    }
                    this.setDiscounts.add(element);
                    return this;
                }

                public Builder addAllSetDiscount(List<SetDiscount> elements) {
                    if (this.setDiscounts == null) {
                        this.setDiscounts = new ArrayList<SetDiscount>();
                    }
                    this.setDiscounts.addAll(elements);
                    return this;
                }

                public Builder addSetItem(SetItem element) {
                    if (this.setItems == null) {
                        this.setItems = new ArrayList<SetItem>();
                    }
                    this.setItems.add(element);
                    return this;
                }

                public Builder addAllSetItem(List<SetItem> elements) {
                    if (this.setItems == null) {
                        this.setItems = new ArrayList<SetItem>();
                    }
                    this.setItems.addAll(elements);
                    return this;
                }

                public Builder putSetMetadata(String key, String value) {
                    if (this.setMetadata == null || this.setMetadata instanceof EmptyParam) {
                        this.setMetadata = new HashMap();
                    }
                    ((Map)this.setMetadata).put(key, value);
                    return this;
                }

                public Builder putAllSetMetadata(Map<String, String> map) {
                    if (this.setMetadata == null || this.setMetadata instanceof EmptyParam) {
                        this.setMetadata = new HashMap();
                    }
                    ((Map)this.setMetadata).putAll(map);
                    return this;
                }

                public Builder setSetMetadata(EmptyParam setMetadata) {
                    this.setMetadata = setMetadata;
                    return this;
                }

                public Builder setSetMetadata(Map<String, String> setMetadata) {
                    this.setMetadata = setMetadata;
                    return this;
                }

                public Builder setType(Type type) {
                    this.type = type;
                    return this;
                }
            }

            public static class SetItem {
                @SerializedName(value="discounts")
                List<Discount> discounts;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="metadata")
                Map<String, String> metadata;
                @SerializedName(value="price")
                String price;
                @SerializedName(value="quantity")
                Long quantity;
                @SerializedName(value="tax_rates")
                List<String> taxRates;
                @SerializedName(value="trial")
                Trial trial;

                private SetItem(List<Discount> discounts, Map<String, Object> extraParams, Map<String, String> metadata, String price, Long quantity, List<String> taxRates, Trial trial) {
                    this.discounts = discounts;
                    this.extraParams = extraParams;
                    this.metadata = metadata;
                    this.price = price;
                    this.quantity = quantity;
                    this.taxRates = taxRates;
                    this.trial = trial;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public List<Discount> getDiscounts() {
                    return this.discounts;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Map<String, String> getMetadata() {
                    return this.metadata;
                }

                @Generated
                public String getPrice() {
                    return this.price;
                }

                @Generated
                public Long getQuantity() {
                    return this.quantity;
                }

                @Generated
                public List<String> getTaxRates() {
                    return this.taxRates;
                }

                @Generated
                public Trial getTrial() {
                    return this.trial;
                }

                public static class Trial {
                    @SerializedName(value="converts_to")
                    List<String> convertsTo;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="type")
                    Type type;

                    private Trial(List<String> convertsTo, Map<String, Object> extraParams, Type type) {
                        this.convertsTo = convertsTo;
                        this.extraParams = extraParams;
                        this.type = type;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public List<String> getConvertsTo() {
                        return this.convertsTo;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Type getType() {
                        return this.type;
                    }

                    public static enum Type implements ApiRequestParams.EnumParam
                    {
                        FREE("free"),
                        PAID("paid");

                        private final String value;

                        private Type(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static class Builder {
                        private List<String> convertsTo;
                        private Map<String, Object> extraParams;
                        private Type type;

                        public Trial build() {
                            return new Trial(this.convertsTo, this.extraParams, this.type);
                        }

                        public Builder addConvertsTo(String element) {
                            if (this.convertsTo == null) {
                                this.convertsTo = new ArrayList<String>();
                            }
                            this.convertsTo.add(element);
                            return this;
                        }

                        public Builder addAllConvertsTo(List<String> elements) {
                            if (this.convertsTo == null) {
                                this.convertsTo = new ArrayList<String>();
                            }
                            this.convertsTo.addAll(elements);
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setType(Type type) {
                            this.type = type;
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private List<Discount> discounts;
                    private Map<String, Object> extraParams;
                    private Map<String, String> metadata;
                    private String price;
                    private Long quantity;
                    private List<String> taxRates;
                    private Trial trial;

                    public SetItem build() {
                        return new SetItem(this.discounts, this.extraParams, this.metadata, this.price, this.quantity, this.taxRates, this.trial);
                    }

                    public Builder addDiscount(Discount element) {
                        if (this.discounts == null) {
                            this.discounts = new ArrayList<Discount>();
                        }
                        this.discounts.add(element);
                        return this;
                    }

                    public Builder addAllDiscount(List<Discount> elements) {
                        if (this.discounts == null) {
                            this.discounts = new ArrayList<Discount>();
                        }
                        this.discounts.addAll(elements);
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder putMetadata(String key, String value) {
                        if (this.metadata == null) {
                            this.metadata = new HashMap<String, String>();
                        }
                        this.metadata.put(key, value);
                        return this;
                    }

                    public Builder putAllMetadata(Map<String, String> map) {
                        if (this.metadata == null) {
                            this.metadata = new HashMap<String, String>();
                        }
                        this.metadata.putAll(map);
                        return this;
                    }

                    public Builder setPrice(String price) {
                        this.price = price;
                        return this;
                    }

                    public Builder setQuantity(Long quantity) {
                        this.quantity = quantity;
                        return this;
                    }

                    public Builder addTaxRate(String element) {
                        if (this.taxRates == null) {
                            this.taxRates = new ArrayList<String>();
                        }
                        this.taxRates.add(element);
                        return this;
                    }

                    public Builder addAllTaxRate(List<String> elements) {
                        if (this.taxRates == null) {
                            this.taxRates = new ArrayList<String>();
                        }
                        this.taxRates.addAll(elements);
                        return this;
                    }

                    public Builder setTrial(Trial trial) {
                        this.trial = trial;
                        return this;
                    }
                }

                public static class Discount {
                    @SerializedName(value="coupon")
                    String coupon;
                    @SerializedName(value="discount")
                    String discount;
                    @SerializedName(value="discount_end")
                    DiscountEnd discountEnd;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;

                    private Discount(String coupon, String discount, DiscountEnd discountEnd, Map<String, Object> extraParams) {
                        this.coupon = coupon;
                        this.discount = discount;
                        this.discountEnd = discountEnd;
                        this.extraParams = extraParams;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public String getCoupon() {
                        return this.coupon;
                    }

                    @Generated
                    public String getDiscount() {
                        return this.discount;
                    }

                    @Generated
                    public DiscountEnd getDiscountEnd() {
                        return this.discountEnd;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    public static class DiscountEnd {
                        @SerializedName(value="duration")
                        Duration duration;
                        @SerializedName(value="_stripe_java_extra_param_key")
                        Map<String, Object> extraParams;
                        @SerializedName(value="timestamp")
                        Long timestamp;
                        @SerializedName(value="type")
                        Type type;

                        private DiscountEnd(Duration duration, Map<String, Object> extraParams, Long timestamp, Type type) {
                            this.duration = duration;
                            this.extraParams = extraParams;
                            this.timestamp = timestamp;
                            this.type = type;
                        }

                        public static Builder builder() {
                            return new Builder();
                        }

                        @Generated
                        public Duration getDuration() {
                            return this.duration;
                        }

                        @Generated
                        public Map<String, Object> getExtraParams() {
                            return this.extraParams;
                        }

                        @Generated
                        public Long getTimestamp() {
                            return this.timestamp;
                        }

                        @Generated
                        public Type getType() {
                            return this.type;
                        }

                        public static class Duration {
                            @SerializedName(value="_stripe_java_extra_param_key")
                            Map<String, Object> extraParams;
                            @SerializedName(value="interval")
                            Interval interval;
                            @SerializedName(value="interval_count")
                            Long intervalCount;

                            private Duration(Map<String, Object> extraParams, Interval interval, Long intervalCount) {
                                this.extraParams = extraParams;
                                this.interval = interval;
                                this.intervalCount = intervalCount;
                            }

                            public static Builder builder() {
                                return new Builder();
                            }

                            @Generated
                            public Map<String, Object> getExtraParams() {
                                return this.extraParams;
                            }

                            @Generated
                            public Interval getInterval() {
                                return this.interval;
                            }

                            @Generated
                            public Long getIntervalCount() {
                                return this.intervalCount;
                            }

                            public static enum Interval implements ApiRequestParams.EnumParam
                            {
                                DAY("day"),
                                MONTH("month"),
                                WEEK("week"),
                                YEAR("year");

                                private final String value;

                                private Interval(String value) {
                                    this.value = value;
                                }

                                @Override
                                @Generated
                                public String getValue() {
                                    return this.value;
                                }
                            }

                            public static class Builder {
                                private Map<String, Object> extraParams;
                                private Interval interval;
                                private Long intervalCount;

                                public Duration build() {
                                    return new Duration(this.extraParams, this.interval, this.intervalCount);
                                }

                                public Builder putExtraParam(String key, Object value) {
                                    if (this.extraParams == null) {
                                        this.extraParams = new HashMap<String, Object>();
                                    }
                                    this.extraParams.put(key, value);
                                    return this;
                                }

                                public Builder putAllExtraParam(Map<String, Object> map) {
                                    if (this.extraParams == null) {
                                        this.extraParams = new HashMap<String, Object>();
                                    }
                                    this.extraParams.putAll(map);
                                    return this;
                                }

                                public Builder setInterval(Interval interval) {
                                    this.interval = interval;
                                    return this;
                                }

                                public Builder setIntervalCount(Long intervalCount) {
                                    this.intervalCount = intervalCount;
                                    return this;
                                }
                            }
                        }

                        public static enum Type implements ApiRequestParams.EnumParam
                        {
                            DURATION("duration"),
                            TIMESTAMP("timestamp");

                            private final String value;

                            private Type(String value) {
                                this.value = value;
                            }

                            @Override
                            @Generated
                            public String getValue() {
                                return this.value;
                            }
                        }

                        public static class Builder {
                            private Duration duration;
                            private Map<String, Object> extraParams;
                            private Long timestamp;
                            private Type type;

                            public DiscountEnd build() {
                                return new DiscountEnd(this.duration, this.extraParams, this.timestamp, this.type);
                            }

                            public Builder setDuration(Duration duration) {
                                this.duration = duration;
                                return this;
                            }

                            public Builder putExtraParam(String key, Object value) {
                                if (this.extraParams == null) {
                                    this.extraParams = new HashMap<String, Object>();
                                }
                                this.extraParams.put(key, value);
                                return this;
                            }

                            public Builder putAllExtraParam(Map<String, Object> map) {
                                if (this.extraParams == null) {
                                    this.extraParams = new HashMap<String, Object>();
                                }
                                this.extraParams.putAll(map);
                                return this;
                            }

                            public Builder setTimestamp(Long timestamp) {
                                this.timestamp = timestamp;
                                return this;
                            }

                            public Builder setType(Type type) {
                                this.type = type;
                                return this;
                            }
                        }
                    }

                    public static class Builder {
                        private String coupon;
                        private String discount;
                        private DiscountEnd discountEnd;
                        private Map<String, Object> extraParams;

                        public Discount build() {
                            return new Discount(this.coupon, this.discount, this.discountEnd, this.extraParams);
                        }

                        public Builder setCoupon(String coupon) {
                            this.coupon = coupon;
                            return this;
                        }

                        public Builder setDiscount(String discount) {
                            this.discount = discount;
                            return this;
                        }

                        public Builder setDiscountEnd(DiscountEnd discountEnd) {
                            this.discountEnd = discountEnd;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }
                    }
                }
            }

            public static class SetDiscount {
                @SerializedName(value="coupon")
                String coupon;
                @SerializedName(value="discount")
                String discount;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;

                private SetDiscount(String coupon, String discount, Map<String, Object> extraParams) {
                    this.coupon = coupon;
                    this.discount = discount;
                    this.extraParams = extraParams;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getCoupon() {
                    return this.coupon;
                }

                @Generated
                public String getDiscount() {
                    return this.discount;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                public static class Builder {
                    private String coupon;
                    private String discount;
                    private Map<String, Object> extraParams;

                    public SetDiscount build() {
                        return new SetDiscount(this.coupon, this.discount, this.extraParams);
                    }

                    public Builder setCoupon(String coupon) {
                        this.coupon = coupon;
                        return this;
                    }

                    public Builder setDiscount(String discount) {
                        this.discount = discount;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }
                }
            }
        }
    }

    public static class Discount {
        @SerializedName(value="coupon")
        String coupon;
        @SerializedName(value="discount")
        String discount;
        @SerializedName(value="discount_end")
        DiscountEnd discountEnd;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;

        private Discount(String coupon, String discount, DiscountEnd discountEnd, Map<String, Object> extraParams) {
            this.coupon = coupon;
            this.discount = discount;
            this.discountEnd = discountEnd;
            this.extraParams = extraParams;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public String getCoupon() {
            return this.coupon;
        }

        @Generated
        public String getDiscount() {
            return this.discount;
        }

        @Generated
        public DiscountEnd getDiscountEnd() {
            return this.discountEnd;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        public static class DiscountEnd {
            @SerializedName(value="duration")
            Duration duration;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="timestamp")
            Long timestamp;
            @SerializedName(value="type")
            Type type;

            private DiscountEnd(Duration duration, Map<String, Object> extraParams, Long timestamp, Type type) {
                this.duration = duration;
                this.extraParams = extraParams;
                this.timestamp = timestamp;
                this.type = type;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Duration getDuration() {
                return this.duration;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Long getTimestamp() {
                return this.timestamp;
            }

            @Generated
            public Type getType() {
                return this.type;
            }

            public static class Duration {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="interval")
                Interval interval;
                @SerializedName(value="interval_count")
                Long intervalCount;

                private Duration(Map<String, Object> extraParams, Interval interval, Long intervalCount) {
                    this.extraParams = extraParams;
                    this.interval = interval;
                    this.intervalCount = intervalCount;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Interval getInterval() {
                    return this.interval;
                }

                @Generated
                public Long getIntervalCount() {
                    return this.intervalCount;
                }

                public static enum Interval implements ApiRequestParams.EnumParam
                {
                    DAY("day"),
                    MONTH("month"),
                    WEEK("week"),
                    YEAR("year");

                    private final String value;

                    private Interval(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Interval interval;
                    private Long intervalCount;

                    public Duration build() {
                        return new Duration(this.extraParams, this.interval, this.intervalCount);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setInterval(Interval interval) {
                        this.interval = interval;
                        return this;
                    }

                    public Builder setIntervalCount(Long intervalCount) {
                        this.intervalCount = intervalCount;
                        return this;
                    }
                }
            }

            public static enum Type implements ApiRequestParams.EnumParam
            {
                DURATION("duration"),
                TIMESTAMP("timestamp");

                private final String value;

                private Type(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Duration duration;
                private Map<String, Object> extraParams;
                private Long timestamp;
                private Type type;

                public DiscountEnd build() {
                    return new DiscountEnd(this.duration, this.extraParams, this.timestamp, this.type);
                }

                public Builder setDuration(Duration duration) {
                    this.duration = duration;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setTimestamp(Long timestamp) {
                    this.timestamp = timestamp;
                    return this;
                }

                public Builder setType(Type type) {
                    this.type = type;
                    return this;
                }
            }
        }

        public static class Builder {
            private String coupon;
            private String discount;
            private DiscountEnd discountEnd;
            private Map<String, Object> extraParams;

            public Discount build() {
                return new Discount(this.coupon, this.discount, this.discountEnd, this.extraParams);
            }

            public Builder setCoupon(String coupon) {
                this.coupon = coupon;
                return this;
            }

            public Builder setDiscount(String discount) {
                this.discount = discount;
                return this;
            }

            public Builder setDiscountEnd(DiscountEnd discountEnd) {
                this.discountEnd = discountEnd;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }
        }
    }
}

