/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Account;
import com.stripe.model.Application;
import com.stripe.model.Customer;
import com.stripe.model.Discount;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.Invoice;
import com.stripe.model.MetadataStore;
import com.stripe.model.PaymentMethod;
import com.stripe.model.PaymentSource;
import com.stripe.model.SetupIntent;
import com.stripe.model.StripeObject;
import com.stripe.model.SubscriptionCollection;
import com.stripe.model.SubscriptionItem;
import com.stripe.model.SubscriptionItemCollection;
import com.stripe.model.SubscriptionSchedule;
import com.stripe.model.SubscriptionSearchResult;
import com.stripe.model.TaxRate;
import com.stripe.model.testhelpers.TestClock;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.SubscriptionCancelParams;
import com.stripe.param.SubscriptionCreateParams;
import com.stripe.param.SubscriptionListParams;
import com.stripe.param.SubscriptionRetrieveParams;
import com.stripe.param.SubscriptionSearchParams;
import com.stripe.param.SubscriptionUpdateParams;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class Subscription
extends ApiResource
implements HasId,
MetadataStore<Subscription> {
    @SerializedName(value="application")
    ExpandableField<Application> application;
    @SerializedName(value="application_fee_percent")
    BigDecimal applicationFeePercent;
    @SerializedName(value="automatic_tax")
    AutomaticTax automaticTax;
    @SerializedName(value="billing_cycle_anchor")
    Long billingCycleAnchor;
    @SerializedName(value="billing_thresholds")
    BillingThresholds billingThresholds;
    @SerializedName(value="cancel_at")
    Long cancelAt;
    @SerializedName(value="cancel_at_period_end")
    Boolean cancelAtPeriodEnd;
    @SerializedName(value="canceled_at")
    Long canceledAt;
    @SerializedName(value="collection_method")
    String collectionMethod;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="current_period_end")
    Long currentPeriodEnd;
    @SerializedName(value="current_period_start")
    Long currentPeriodStart;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="days_until_due")
    Long daysUntilDue;
    @SerializedName(value="default_payment_method")
    ExpandableField<PaymentMethod> defaultPaymentMethod;
    @SerializedName(value="default_source")
    ExpandableField<PaymentSource> defaultSource;
    @SerializedName(value="default_tax_rates")
    List<TaxRate> defaultTaxRates;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="discount")
    Discount discount;
    @SerializedName(value="discounts")
    List<ExpandableField<Discount>> discounts;
    @SerializedName(value="ended_at")
    Long endedAt;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="items")
    SubscriptionItemCollection items;
    @SerializedName(value="latest_invoice")
    ExpandableField<Invoice> latestInvoice;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="next_pending_invoice_item_invoice")
    Long nextPendingInvoiceItemInvoice;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="on_behalf_of")
    ExpandableField<Account> onBehalfOf;
    @SerializedName(value="pause_collection")
    PauseCollection pauseCollection;
    @SerializedName(value="payment_settings")
    PaymentSettings paymentSettings;
    @SerializedName(value="pending_invoice_item_interval")
    PendingInvoiceItemInterval pendingInvoiceItemInterval;
    @SerializedName(value="pending_setup_intent")
    ExpandableField<SetupIntent> pendingSetupIntent;
    @SerializedName(value="pending_update")
    PendingUpdate pendingUpdate;
    @SerializedName(value="prebilling")
    Prebilling prebilling;
    @SerializedName(value="schedule")
    ExpandableField<SubscriptionSchedule> schedule;
    @SerializedName(value="start_date")
    Long startDate;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="test_clock")
    ExpandableField<TestClock> testClock;
    @SerializedName(value="transfer_data")
    TransferData transferData;
    @SerializedName(value="trial_end")
    Long trialEnd;
    @SerializedName(value="trial_start")
    Long trialStart;

    public String getApplication() {
        return this.application != null ? this.application.getId() : null;
    }

    public void setApplication(String id) {
        this.application = ApiResource.setExpandableFieldId(id, this.application);
    }

    public Application getApplicationObject() {
        return this.application != null ? this.application.getExpanded() : null;
    }

    public void setApplicationObject(Application expandableObject) {
        this.application = new ExpandableField<Application>(expandableObject.getId(), expandableObject);
    }

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public String getDefaultPaymentMethod() {
        return this.defaultPaymentMethod != null ? this.defaultPaymentMethod.getId() : null;
    }

    public void setDefaultPaymentMethod(String id) {
        this.defaultPaymentMethod = ApiResource.setExpandableFieldId(id, this.defaultPaymentMethod);
    }

    public PaymentMethod getDefaultPaymentMethodObject() {
        return this.defaultPaymentMethod != null ? this.defaultPaymentMethod.getExpanded() : null;
    }

    public void setDefaultPaymentMethodObject(PaymentMethod expandableObject) {
        this.defaultPaymentMethod = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
    }

    public String getDefaultSource() {
        return this.defaultSource != null ? this.defaultSource.getId() : null;
    }

    public void setDefaultSource(String id) {
        this.defaultSource = ApiResource.setExpandableFieldId(id, this.defaultSource);
    }

    public PaymentSource getDefaultSourceObject() {
        return this.defaultSource != null ? this.defaultSource.getExpanded() : null;
    }

    public void setDefaultSourceObject(PaymentSource expandableObject) {
        this.defaultSource = new ExpandableField<PaymentSource>(expandableObject.getId(), expandableObject);
    }

    public String getLatestInvoice() {
        return this.latestInvoice != null ? this.latestInvoice.getId() : null;
    }

    public void setLatestInvoice(String id) {
        this.latestInvoice = ApiResource.setExpandableFieldId(id, this.latestInvoice);
    }

    public Invoice getLatestInvoiceObject() {
        return this.latestInvoice != null ? this.latestInvoice.getExpanded() : null;
    }

    public void setLatestInvoiceObject(Invoice expandableObject) {
        this.latestInvoice = new ExpandableField<Invoice>(expandableObject.getId(), expandableObject);
    }

    public String getOnBehalfOf() {
        return this.onBehalfOf != null ? this.onBehalfOf.getId() : null;
    }

    public void setOnBehalfOf(String id) {
        this.onBehalfOf = ApiResource.setExpandableFieldId(id, this.onBehalfOf);
    }

    public Account getOnBehalfOfObject() {
        return this.onBehalfOf != null ? this.onBehalfOf.getExpanded() : null;
    }

    public void setOnBehalfOfObject(Account expandableObject) {
        this.onBehalfOf = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
    }

    public String getPendingSetupIntent() {
        return this.pendingSetupIntent != null ? this.pendingSetupIntent.getId() : null;
    }

    public void setPendingSetupIntent(String id) {
        this.pendingSetupIntent = ApiResource.setExpandableFieldId(id, this.pendingSetupIntent);
    }

    public SetupIntent getPendingSetupIntentObject() {
        return this.pendingSetupIntent != null ? this.pendingSetupIntent.getExpanded() : null;
    }

    public void setPendingSetupIntentObject(SetupIntent expandableObject) {
        this.pendingSetupIntent = new ExpandableField<SetupIntent>(expandableObject.getId(), expandableObject);
    }

    public String getSchedule() {
        return this.schedule != null ? this.schedule.getId() : null;
    }

    public void setSchedule(String id) {
        this.schedule = ApiResource.setExpandableFieldId(id, this.schedule);
    }

    public SubscriptionSchedule getScheduleObject() {
        return this.schedule != null ? this.schedule.getExpanded() : null;
    }

    public void setScheduleObject(SubscriptionSchedule expandableObject) {
        this.schedule = new ExpandableField<SubscriptionSchedule>(expandableObject.getId(), expandableObject);
    }

    public String getTestClock() {
        return this.testClock != null ? this.testClock.getId() : null;
    }

    public void setTestClock(String id) {
        this.testClock = ApiResource.setExpandableFieldId(id, this.testClock);
    }

    public TestClock getTestClockObject() {
        return this.testClock != null ? this.testClock.getExpanded() : null;
    }

    public void setTestClockObject(TestClock expandableObject) {
        this.testClock = new ExpandableField<TestClock>(expandableObject.getId(), expandableObject);
    }

    public List<String> getDiscounts() {
        return this.discounts != null ? this.discounts.stream().map(x -> x.getId()).collect(Collectors.toList()) : null;
    }

    public void setDiscounts(List<String> ids) {
        if (ids == null) {
            this.discounts = null;
            return;
        }
        if (this.discounts != null && this.discounts.stream().map(x -> x.getId()).collect(Collectors.toList()).equals(ids)) {
            return;
        }
        this.discounts = ids != null ? ids.stream().map(id -> new ExpandableField<Object>((String)id, null)).collect(Collectors.toList()) : null;
    }

    public List<Discount> getDiscountObjects() {
        return this.discounts != null ? this.discounts.stream().map(x -> (Discount)x.getExpanded()).collect(Collectors.toList()) : null;
    }

    public void setDiscountObjects(List<Discount> objs) {
        this.discounts = objs != null ? objs.stream().map(x -> new ExpandableField<Discount>(x.getId(), (Discount)x)).collect(Collectors.toList()) : null;
    }

    public Subscription cancel() throws StripeException {
        return this.cancel((Map<String, Object>)null, (RequestOptions)null);
    }

    public Subscription cancel(Map<String, Object> params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public Subscription cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/subscriptions/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, Subscription.class, options);
    }

    public Subscription cancel(SubscriptionCancelParams params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public Subscription cancel(SubscriptionCancelParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/subscriptions/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, Subscription.class, options);
    }

    public static Subscription create(Map<String, Object> params) throws StripeException {
        return Subscription.create(params, (RequestOptions)null);
    }

    public static Subscription create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/subscriptions");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Subscription.class, options);
    }

    public static Subscription create(SubscriptionCreateParams params) throws StripeException {
        return Subscription.create(params, (RequestOptions)null);
    }

    public static Subscription create(SubscriptionCreateParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/subscriptions");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Subscription.class, options);
    }

    public Discount deleteDiscount() throws StripeException {
        return this.deleteDiscount(null, null);
    }

    public Discount deleteDiscount(Map<String, Object> params) throws StripeException {
        return this.deleteDiscount(params, null);
    }

    public Discount deleteDiscount(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/subscriptions/%s/discount", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, Discount.class, options);
    }

    public static SubscriptionCollection list(Map<String, Object> params) throws StripeException {
        return Subscription.list(params, (RequestOptions)null);
    }

    public static SubscriptionCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/subscriptions");
        return ApiResource.requestCollection(url, params, SubscriptionCollection.class, options);
    }

    public static SubscriptionCollection list(SubscriptionListParams params) throws StripeException {
        return Subscription.list(params, (RequestOptions)null);
    }

    public static SubscriptionCollection list(SubscriptionListParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/subscriptions");
        return ApiResource.requestCollection(url, params, SubscriptionCollection.class, options);
    }

    public static Subscription retrieve(String subscriptionExposedId) throws StripeException {
        return Subscription.retrieve(subscriptionExposedId, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Subscription retrieve(String subscriptionExposedId, RequestOptions options) throws StripeException {
        return Subscription.retrieve(subscriptionExposedId, (Map<String, Object>)null, options);
    }

    public static Subscription retrieve(String subscriptionExposedId, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/subscriptions/%s", ApiResource.urlEncodeId(subscriptionExposedId)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Subscription.class, options);
    }

    public static Subscription retrieve(String subscriptionExposedId, SubscriptionRetrieveParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/subscriptions/%s", ApiResource.urlEncodeId(subscriptionExposedId)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Subscription.class, options);
    }

    public static SubscriptionSearchResult search(Map<String, Object> params) throws StripeException {
        return Subscription.search(params, (RequestOptions)null);
    }

    public static SubscriptionSearchResult search(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/subscriptions/search");
        return ApiResource.requestSearchResult(url, params, SubscriptionSearchResult.class, options);
    }

    public static SubscriptionSearchResult search(SubscriptionSearchParams params) throws StripeException {
        return Subscription.search(params, (RequestOptions)null);
    }

    public static SubscriptionSearchResult search(SubscriptionSearchParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/subscriptions/search");
        return ApiResource.requestSearchResult(url, params, SubscriptionSearchResult.class, options);
    }

    public Subscription update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Subscription update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/subscriptions/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Subscription.class, options);
    }

    public Subscription update(SubscriptionUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Subscription update(SubscriptionUpdateParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/subscriptions/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Subscription.class, options);
    }

    @Generated
    public BigDecimal getApplicationFeePercent() {
        return this.applicationFeePercent;
    }

    @Generated
    public AutomaticTax getAutomaticTax() {
        return this.automaticTax;
    }

    @Generated
    public Long getBillingCycleAnchor() {
        return this.billingCycleAnchor;
    }

    @Generated
    public BillingThresholds getBillingThresholds() {
        return this.billingThresholds;
    }

    @Generated
    public Long getCancelAt() {
        return this.cancelAt;
    }

    @Generated
    public Boolean getCancelAtPeriodEnd() {
        return this.cancelAtPeriodEnd;
    }

    @Generated
    public Long getCanceledAt() {
        return this.canceledAt;
    }

    @Generated
    public String getCollectionMethod() {
        return this.collectionMethod;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public Long getCurrentPeriodEnd() {
        return this.currentPeriodEnd;
    }

    @Generated
    public Long getCurrentPeriodStart() {
        return this.currentPeriodStart;
    }

    @Generated
    public Long getDaysUntilDue() {
        return this.daysUntilDue;
    }

    @Generated
    public List<TaxRate> getDefaultTaxRates() {
        return this.defaultTaxRates;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Discount getDiscount() {
        return this.discount;
    }

    @Generated
    public Long getEndedAt() {
        return this.endedAt;
    }

    @Generated
    public SubscriptionItemCollection getItems() {
        return this.items;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public Long getNextPendingInvoiceItemInvoice() {
        return this.nextPendingInvoiceItemInvoice;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public PauseCollection getPauseCollection() {
        return this.pauseCollection;
    }

    @Generated
    public PaymentSettings getPaymentSettings() {
        return this.paymentSettings;
    }

    @Generated
    public PendingInvoiceItemInterval getPendingInvoiceItemInterval() {
        return this.pendingInvoiceItemInterval;
    }

    @Generated
    public PendingUpdate getPendingUpdate() {
        return this.pendingUpdate;
    }

    @Generated
    public Prebilling getPrebilling() {
        return this.prebilling;
    }

    @Generated
    public Long getStartDate() {
        return this.startDate;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public TransferData getTransferData() {
        return this.transferData;
    }

    @Generated
    public Long getTrialEnd() {
        return this.trialEnd;
    }

    @Generated
    public Long getTrialStart() {
        return this.trialStart;
    }

    @Generated
    public void setApplicationFeePercent(BigDecimal applicationFeePercent) {
        this.applicationFeePercent = applicationFeePercent;
    }

    @Generated
    public void setAutomaticTax(AutomaticTax automaticTax) {
        this.automaticTax = automaticTax;
    }

    @Generated
    public void setBillingCycleAnchor(Long billingCycleAnchor) {
        this.billingCycleAnchor = billingCycleAnchor;
    }

    @Generated
    public void setBillingThresholds(BillingThresholds billingThresholds) {
        this.billingThresholds = billingThresholds;
    }

    @Generated
    public void setCancelAt(Long cancelAt) {
        this.cancelAt = cancelAt;
    }

    @Generated
    public void setCancelAtPeriodEnd(Boolean cancelAtPeriodEnd) {
        this.cancelAtPeriodEnd = cancelAtPeriodEnd;
    }

    @Generated
    public void setCanceledAt(Long canceledAt) {
        this.canceledAt = canceledAt;
    }

    @Generated
    public void setCollectionMethod(String collectionMethod) {
        this.collectionMethod = collectionMethod;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setCurrentPeriodEnd(Long currentPeriodEnd) {
        this.currentPeriodEnd = currentPeriodEnd;
    }

    @Generated
    public void setCurrentPeriodStart(Long currentPeriodStart) {
        this.currentPeriodStart = currentPeriodStart;
    }

    @Generated
    public void setDaysUntilDue(Long daysUntilDue) {
        this.daysUntilDue = daysUntilDue;
    }

    @Generated
    public void setDefaultTaxRates(List<TaxRate> defaultTaxRates) {
        this.defaultTaxRates = defaultTaxRates;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setDiscount(Discount discount) {
        this.discount = discount;
    }

    @Generated
    public void setEndedAt(Long endedAt) {
        this.endedAt = endedAt;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setItems(SubscriptionItemCollection items) {
        this.items = items;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setNextPendingInvoiceItemInvoice(Long nextPendingInvoiceItemInvoice) {
        this.nextPendingInvoiceItemInvoice = nextPendingInvoiceItemInvoice;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPauseCollection(PauseCollection pauseCollection) {
        this.pauseCollection = pauseCollection;
    }

    @Generated
    public void setPaymentSettings(PaymentSettings paymentSettings) {
        this.paymentSettings = paymentSettings;
    }

    @Generated
    public void setPendingInvoiceItemInterval(PendingInvoiceItemInterval pendingInvoiceItemInterval) {
        this.pendingInvoiceItemInterval = pendingInvoiceItemInterval;
    }

    @Generated
    public void setPendingUpdate(PendingUpdate pendingUpdate) {
        this.pendingUpdate = pendingUpdate;
    }

    @Generated
    public void setPrebilling(Prebilling prebilling) {
        this.prebilling = prebilling;
    }

    @Generated
    public void setStartDate(Long startDate) {
        this.startDate = startDate;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setTransferData(TransferData transferData) {
        this.transferData = transferData;
    }

    @Generated
    public void setTrialEnd(Long trialEnd) {
        this.trialEnd = trialEnd;
    }

    @Generated
    public void setTrialStart(Long trialStart) {
        this.trialStart = trialStart;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$billingCycleAnchor = this.getBillingCycleAnchor();
        Long other$billingCycleAnchor = other.getBillingCycleAnchor();
        if (this$billingCycleAnchor == null ? other$billingCycleAnchor != null : !((Object)this$billingCycleAnchor).equals(other$billingCycleAnchor)) {
            return false;
        }
        Long this$cancelAt = this.getCancelAt();
        Long other$cancelAt = other.getCancelAt();
        if (this$cancelAt == null ? other$cancelAt != null : !((Object)this$cancelAt).equals(other$cancelAt)) {
            return false;
        }
        Boolean this$cancelAtPeriodEnd = this.getCancelAtPeriodEnd();
        Boolean other$cancelAtPeriodEnd = other.getCancelAtPeriodEnd();
        if (this$cancelAtPeriodEnd == null ? other$cancelAtPeriodEnd != null : !((Object)this$cancelAtPeriodEnd).equals(other$cancelAtPeriodEnd)) {
            return false;
        }
        Long this$canceledAt = this.getCanceledAt();
        Long other$canceledAt = other.getCanceledAt();
        if (this$canceledAt == null ? other$canceledAt != null : !((Object)this$canceledAt).equals(other$canceledAt)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$currentPeriodEnd = this.getCurrentPeriodEnd();
        Long other$currentPeriodEnd = other.getCurrentPeriodEnd();
        if (this$currentPeriodEnd == null ? other$currentPeriodEnd != null : !((Object)this$currentPeriodEnd).equals(other$currentPeriodEnd)) {
            return false;
        }
        Long this$currentPeriodStart = this.getCurrentPeriodStart();
        Long other$currentPeriodStart = other.getCurrentPeriodStart();
        if (this$currentPeriodStart == null ? other$currentPeriodStart != null : !((Object)this$currentPeriodStart).equals(other$currentPeriodStart)) {
            return false;
        }
        Long this$daysUntilDue = this.getDaysUntilDue();
        Long other$daysUntilDue = other.getDaysUntilDue();
        if (this$daysUntilDue == null ? other$daysUntilDue != null : !((Object)this$daysUntilDue).equals(other$daysUntilDue)) {
            return false;
        }
        Long this$endedAt = this.getEndedAt();
        Long other$endedAt = other.getEndedAt();
        if (this$endedAt == null ? other$endedAt != null : !((Object)this$endedAt).equals(other$endedAt)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$nextPendingInvoiceItemInvoice = this.getNextPendingInvoiceItemInvoice();
        Long other$nextPendingInvoiceItemInvoice = other.getNextPendingInvoiceItemInvoice();
        if (this$nextPendingInvoiceItemInvoice == null ? other$nextPendingInvoiceItemInvoice != null : !((Object)this$nextPendingInvoiceItemInvoice).equals(other$nextPendingInvoiceItemInvoice)) {
            return false;
        }
        Long this$startDate = this.getStartDate();
        Long other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        Long this$trialEnd = this.getTrialEnd();
        Long other$trialEnd = other.getTrialEnd();
        if (this$trialEnd == null ? other$trialEnd != null : !((Object)this$trialEnd).equals(other$trialEnd)) {
            return false;
        }
        Long this$trialStart = this.getTrialStart();
        Long other$trialStart = other.getTrialStart();
        if (this$trialStart == null ? other$trialStart != null : !((Object)this$trialStart).equals(other$trialStart)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        BigDecimal this$applicationFeePercent = this.getApplicationFeePercent();
        BigDecimal other$applicationFeePercent = other.getApplicationFeePercent();
        if (this$applicationFeePercent == null ? other$applicationFeePercent != null : !((Object)this$applicationFeePercent).equals(other$applicationFeePercent)) {
            return false;
        }
        AutomaticTax this$automaticTax = this.getAutomaticTax();
        AutomaticTax other$automaticTax = other.getAutomaticTax();
        if (this$automaticTax == null ? other$automaticTax != null : !((Object)this$automaticTax).equals(other$automaticTax)) {
            return false;
        }
        BillingThresholds this$billingThresholds = this.getBillingThresholds();
        BillingThresholds other$billingThresholds = other.getBillingThresholds();
        if (this$billingThresholds == null ? other$billingThresholds != null : !((Object)this$billingThresholds).equals(other$billingThresholds)) {
            return false;
        }
        String this$collectionMethod = this.getCollectionMethod();
        String other$collectionMethod = other.getCollectionMethod();
        if (this$collectionMethod == null ? other$collectionMethod != null : !this$collectionMethod.equals(other$collectionMethod)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        String this$defaultPaymentMethod = this.getDefaultPaymentMethod();
        String other$defaultPaymentMethod = other.getDefaultPaymentMethod();
        if (this$defaultPaymentMethod == null ? other$defaultPaymentMethod != null : !this$defaultPaymentMethod.equals(other$defaultPaymentMethod)) {
            return false;
        }
        String this$defaultSource = this.getDefaultSource();
        String other$defaultSource = other.getDefaultSource();
        if (this$defaultSource == null ? other$defaultSource != null : !this$defaultSource.equals(other$defaultSource)) {
            return false;
        }
        List<TaxRate> this$defaultTaxRates = this.getDefaultTaxRates();
        List<TaxRate> other$defaultTaxRates = other.getDefaultTaxRates();
        if (this$defaultTaxRates == null ? other$defaultTaxRates != null : !((Object)this$defaultTaxRates).equals(other$defaultTaxRates)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Discount this$discount = this.getDiscount();
        Discount other$discount = other.getDiscount();
        if (this$discount == null ? other$discount != null : !((Object)this$discount).equals(other$discount)) {
            return false;
        }
        List<String> this$discounts = this.getDiscounts();
        List<String> other$discounts = other.getDiscounts();
        if (this$discounts == null ? other$discounts != null : !((Object)this$discounts).equals(other$discounts)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        SubscriptionItemCollection this$items = this.getItems();
        SubscriptionItemCollection other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        String this$latestInvoice = this.getLatestInvoice();
        String other$latestInvoice = other.getLatestInvoice();
        if (this$latestInvoice == null ? other$latestInvoice != null : !this$latestInvoice.equals(other$latestInvoice)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$onBehalfOf = this.getOnBehalfOf();
        String other$onBehalfOf = other.getOnBehalfOf();
        if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) {
            return false;
        }
        PauseCollection this$pauseCollection = this.getPauseCollection();
        PauseCollection other$pauseCollection = other.getPauseCollection();
        if (this$pauseCollection == null ? other$pauseCollection != null : !((Object)this$pauseCollection).equals(other$pauseCollection)) {
            return false;
        }
        PaymentSettings this$paymentSettings = this.getPaymentSettings();
        PaymentSettings other$paymentSettings = other.getPaymentSettings();
        if (this$paymentSettings == null ? other$paymentSettings != null : !((Object)this$paymentSettings).equals(other$paymentSettings)) {
            return false;
        }
        PendingInvoiceItemInterval this$pendingInvoiceItemInterval = this.getPendingInvoiceItemInterval();
        PendingInvoiceItemInterval other$pendingInvoiceItemInterval = other.getPendingInvoiceItemInterval();
        if (this$pendingInvoiceItemInterval == null ? other$pendingInvoiceItemInterval != null : !((Object)this$pendingInvoiceItemInterval).equals(other$pendingInvoiceItemInterval)) {
            return false;
        }
        String this$pendingSetupIntent = this.getPendingSetupIntent();
        String other$pendingSetupIntent = other.getPendingSetupIntent();
        if (this$pendingSetupIntent == null ? other$pendingSetupIntent != null : !this$pendingSetupIntent.equals(other$pendingSetupIntent)) {
            return false;
        }
        PendingUpdate this$pendingUpdate = this.getPendingUpdate();
        PendingUpdate other$pendingUpdate = other.getPendingUpdate();
        if (this$pendingUpdate == null ? other$pendingUpdate != null : !((Object)this$pendingUpdate).equals(other$pendingUpdate)) {
            return false;
        }
        Prebilling this$prebilling = this.getPrebilling();
        Prebilling other$prebilling = other.getPrebilling();
        if (this$prebilling == null ? other$prebilling != null : !((Object)this$prebilling).equals(other$prebilling)) {
            return false;
        }
        String this$schedule = this.getSchedule();
        String other$schedule = other.getSchedule();
        if (this$schedule == null ? other$schedule != null : !this$schedule.equals(other$schedule)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$testClock = this.getTestClock();
        String other$testClock = other.getTestClock();
        if (this$testClock == null ? other$testClock != null : !this$testClock.equals(other$testClock)) {
            return false;
        }
        TransferData this$transferData = this.getTransferData();
        TransferData other$transferData = other.getTransferData();
        return !(this$transferData == null ? other$transferData != null : !((Object)this$transferData).equals(other$transferData));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Subscription;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $billingCycleAnchor = this.getBillingCycleAnchor();
        result = result * 59 + ($billingCycleAnchor == null ? 43 : ((Object)$billingCycleAnchor).hashCode());
        Long $cancelAt = this.getCancelAt();
        result = result * 59 + ($cancelAt == null ? 43 : ((Object)$cancelAt).hashCode());
        Boolean $cancelAtPeriodEnd = this.getCancelAtPeriodEnd();
        result = result * 59 + ($cancelAtPeriodEnd == null ? 43 : ((Object)$cancelAtPeriodEnd).hashCode());
        Long $canceledAt = this.getCanceledAt();
        result = result * 59 + ($canceledAt == null ? 43 : ((Object)$canceledAt).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $currentPeriodEnd = this.getCurrentPeriodEnd();
        result = result * 59 + ($currentPeriodEnd == null ? 43 : ((Object)$currentPeriodEnd).hashCode());
        Long $currentPeriodStart = this.getCurrentPeriodStart();
        result = result * 59 + ($currentPeriodStart == null ? 43 : ((Object)$currentPeriodStart).hashCode());
        Long $daysUntilDue = this.getDaysUntilDue();
        result = result * 59 + ($daysUntilDue == null ? 43 : ((Object)$daysUntilDue).hashCode());
        Long $endedAt = this.getEndedAt();
        result = result * 59 + ($endedAt == null ? 43 : ((Object)$endedAt).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $nextPendingInvoiceItemInvoice = this.getNextPendingInvoiceItemInvoice();
        result = result * 59 + ($nextPendingInvoiceItemInvoice == null ? 43 : ((Object)$nextPendingInvoiceItemInvoice).hashCode());
        Long $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        Long $trialEnd = this.getTrialEnd();
        result = result * 59 + ($trialEnd == null ? 43 : ((Object)$trialEnd).hashCode());
        Long $trialStart = this.getTrialStart();
        result = result * 59 + ($trialStart == null ? 43 : ((Object)$trialStart).hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        BigDecimal $applicationFeePercent = this.getApplicationFeePercent();
        result = result * 59 + ($applicationFeePercent == null ? 43 : ((Object)$applicationFeePercent).hashCode());
        AutomaticTax $automaticTax = this.getAutomaticTax();
        result = result * 59 + ($automaticTax == null ? 43 : ((Object)$automaticTax).hashCode());
        BillingThresholds $billingThresholds = this.getBillingThresholds();
        result = result * 59 + ($billingThresholds == null ? 43 : ((Object)$billingThresholds).hashCode());
        String $collectionMethod = this.getCollectionMethod();
        result = result * 59 + ($collectionMethod == null ? 43 : $collectionMethod.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        String $defaultPaymentMethod = this.getDefaultPaymentMethod();
        result = result * 59 + ($defaultPaymentMethod == null ? 43 : $defaultPaymentMethod.hashCode());
        String $defaultSource = this.getDefaultSource();
        result = result * 59 + ($defaultSource == null ? 43 : $defaultSource.hashCode());
        List<TaxRate> $defaultTaxRates = this.getDefaultTaxRates();
        result = result * 59 + ($defaultTaxRates == null ? 43 : ((Object)$defaultTaxRates).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Discount $discount = this.getDiscount();
        result = result * 59 + ($discount == null ? 43 : ((Object)$discount).hashCode());
        List<String> $discounts = this.getDiscounts();
        result = result * 59 + ($discounts == null ? 43 : ((Object)$discounts).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        SubscriptionItemCollection $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        String $latestInvoice = this.getLatestInvoice();
        result = result * 59 + ($latestInvoice == null ? 43 : $latestInvoice.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $onBehalfOf = this.getOnBehalfOf();
        result = result * 59 + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
        PauseCollection $pauseCollection = this.getPauseCollection();
        result = result * 59 + ($pauseCollection == null ? 43 : ((Object)$pauseCollection).hashCode());
        PaymentSettings $paymentSettings = this.getPaymentSettings();
        result = result * 59 + ($paymentSettings == null ? 43 : ((Object)$paymentSettings).hashCode());
        PendingInvoiceItemInterval $pendingInvoiceItemInterval = this.getPendingInvoiceItemInterval();
        result = result * 59 + ($pendingInvoiceItemInterval == null ? 43 : ((Object)$pendingInvoiceItemInterval).hashCode());
        String $pendingSetupIntent = this.getPendingSetupIntent();
        result = result * 59 + ($pendingSetupIntent == null ? 43 : $pendingSetupIntent.hashCode());
        PendingUpdate $pendingUpdate = this.getPendingUpdate();
        result = result * 59 + ($pendingUpdate == null ? 43 : ((Object)$pendingUpdate).hashCode());
        Prebilling $prebilling = this.getPrebilling();
        result = result * 59 + ($prebilling == null ? 43 : ((Object)$prebilling).hashCode());
        String $schedule = this.getSchedule();
        result = result * 59 + ($schedule == null ? 43 : $schedule.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $testClock = this.getTestClock();
        result = result * 59 + ($testClock == null ? 43 : $testClock.hashCode());
        TransferData $transferData = this.getTransferData();
        result = result * 59 + ($transferData == null ? 43 : ((Object)$transferData).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class AutomaticTax
    extends StripeObject {
        @SerializedName(value="enabled")
        Boolean enabled;

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AutomaticTax)) {
                return false;
            }
            AutomaticTax other = (AutomaticTax)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            return !(this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AutomaticTax;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            return result;
        }
    }

    public static class BillingThresholds
    extends StripeObject {
        @SerializedName(value="amount_gte")
        Long amountGte;
        @SerializedName(value="reset_billing_cycle_anchor")
        Boolean resetBillingCycleAnchor;

        @Generated
        public Long getAmountGte() {
            return this.amountGte;
        }

        @Generated
        public Boolean getResetBillingCycleAnchor() {
            return this.resetBillingCycleAnchor;
        }

        @Generated
        public void setAmountGte(Long amountGte) {
            this.amountGte = amountGte;
        }

        @Generated
        public void setResetBillingCycleAnchor(Boolean resetBillingCycleAnchor) {
            this.resetBillingCycleAnchor = resetBillingCycleAnchor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BillingThresholds)) {
                return false;
            }
            BillingThresholds other = (BillingThresholds)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amountGte = this.getAmountGte();
            Long other$amountGte = other.getAmountGte();
            if (this$amountGte == null ? other$amountGte != null : !((Object)this$amountGte).equals(other$amountGte)) {
                return false;
            }
            Boolean this$resetBillingCycleAnchor = this.getResetBillingCycleAnchor();
            Boolean other$resetBillingCycleAnchor = other.getResetBillingCycleAnchor();
            return !(this$resetBillingCycleAnchor == null ? other$resetBillingCycleAnchor != null : !((Object)this$resetBillingCycleAnchor).equals(other$resetBillingCycleAnchor));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BillingThresholds;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amountGte = this.getAmountGte();
            result = result * 59 + ($amountGte == null ? 43 : ((Object)$amountGte).hashCode());
            Boolean $resetBillingCycleAnchor = this.getResetBillingCycleAnchor();
            result = result * 59 + ($resetBillingCycleAnchor == null ? 43 : ((Object)$resetBillingCycleAnchor).hashCode());
            return result;
        }
    }

    public static class PauseCollection
    extends StripeObject {
        @SerializedName(value="behavior")
        String behavior;
        @SerializedName(value="resumes_at")
        Long resumesAt;

        @Generated
        public String getBehavior() {
            return this.behavior;
        }

        @Generated
        public Long getResumesAt() {
            return this.resumesAt;
        }

        @Generated
        public void setBehavior(String behavior) {
            this.behavior = behavior;
        }

        @Generated
        public void setResumesAt(Long resumesAt) {
            this.resumesAt = resumesAt;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PauseCollection)) {
                return false;
            }
            PauseCollection other = (PauseCollection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$resumesAt = this.getResumesAt();
            Long other$resumesAt = other.getResumesAt();
            if (this$resumesAt == null ? other$resumesAt != null : !((Object)this$resumesAt).equals(other$resumesAt)) {
                return false;
            }
            String this$behavior = this.getBehavior();
            String other$behavior = other.getBehavior();
            return !(this$behavior == null ? other$behavior != null : !this$behavior.equals(other$behavior));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PauseCollection;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $resumesAt = this.getResumesAt();
            result = result * 59 + ($resumesAt == null ? 43 : ((Object)$resumesAt).hashCode());
            String $behavior = this.getBehavior();
            result = result * 59 + ($behavior == null ? 43 : $behavior.hashCode());
            return result;
        }
    }

    public static class PaymentSettings
    extends StripeObject {
        @SerializedName(value="payment_method_options")
        PaymentMethodOptions paymentMethodOptions;
        @SerializedName(value="payment_method_types")
        List<String> paymentMethodTypes;
        @SerializedName(value="save_default_payment_method")
        String saveDefaultPaymentMethod;

        @Generated
        public PaymentMethodOptions getPaymentMethodOptions() {
            return this.paymentMethodOptions;
        }

        @Generated
        public List<String> getPaymentMethodTypes() {
            return this.paymentMethodTypes;
        }

        @Generated
        public String getSaveDefaultPaymentMethod() {
            return this.saveDefaultPaymentMethod;
        }

        @Generated
        public void setPaymentMethodOptions(PaymentMethodOptions paymentMethodOptions) {
            this.paymentMethodOptions = paymentMethodOptions;
        }

        @Generated
        public void setPaymentMethodTypes(List<String> paymentMethodTypes) {
            this.paymentMethodTypes = paymentMethodTypes;
        }

        @Generated
        public void setSaveDefaultPaymentMethod(String saveDefaultPaymentMethod) {
            this.saveDefaultPaymentMethod = saveDefaultPaymentMethod;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentSettings)) {
                return false;
            }
            PaymentSettings other = (PaymentSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            PaymentMethodOptions this$paymentMethodOptions = this.getPaymentMethodOptions();
            PaymentMethodOptions other$paymentMethodOptions = other.getPaymentMethodOptions();
            if (this$paymentMethodOptions == null ? other$paymentMethodOptions != null : !((Object)this$paymentMethodOptions).equals(other$paymentMethodOptions)) {
                return false;
            }
            List<String> this$paymentMethodTypes = this.getPaymentMethodTypes();
            List<String> other$paymentMethodTypes = other.getPaymentMethodTypes();
            if (this$paymentMethodTypes == null ? other$paymentMethodTypes != null : !((Object)this$paymentMethodTypes).equals(other$paymentMethodTypes)) {
                return false;
            }
            String this$saveDefaultPaymentMethod = this.getSaveDefaultPaymentMethod();
            String other$saveDefaultPaymentMethod = other.getSaveDefaultPaymentMethod();
            return !(this$saveDefaultPaymentMethod == null ? other$saveDefaultPaymentMethod != null : !this$saveDefaultPaymentMethod.equals(other$saveDefaultPaymentMethod));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaymentSettings;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PaymentMethodOptions $paymentMethodOptions = this.getPaymentMethodOptions();
            result = result * 59 + ($paymentMethodOptions == null ? 43 : ((Object)$paymentMethodOptions).hashCode());
            List<String> $paymentMethodTypes = this.getPaymentMethodTypes();
            result = result * 59 + ($paymentMethodTypes == null ? 43 : ((Object)$paymentMethodTypes).hashCode());
            String $saveDefaultPaymentMethod = this.getSaveDefaultPaymentMethod();
            result = result * 59 + ($saveDefaultPaymentMethod == null ? 43 : $saveDefaultPaymentMethod.hashCode());
            return result;
        }

        public static class PaymentMethodOptions
        extends StripeObject {
            @SerializedName(value="acss_debit")
            AcssDebit acssDebit;
            @SerializedName(value="bancontact")
            Bancontact bancontact;
            @SerializedName(value="card")
            Card card;
            @SerializedName(value="customer_balance")
            CustomerBalance customerBalance;
            @SerializedName(value="konbini")
            Konbini konbini;
            @SerializedName(value="us_bank_account")
            UsBankAccount usBankAccount;

            @Generated
            public AcssDebit getAcssDebit() {
                return this.acssDebit;
            }

            @Generated
            public Bancontact getBancontact() {
                return this.bancontact;
            }

            @Generated
            public Card getCard() {
                return this.card;
            }

            @Generated
            public CustomerBalance getCustomerBalance() {
                return this.customerBalance;
            }

            @Generated
            public Konbini getKonbini() {
                return this.konbini;
            }

            @Generated
            public UsBankAccount getUsBankAccount() {
                return this.usBankAccount;
            }

            @Generated
            public void setAcssDebit(AcssDebit acssDebit) {
                this.acssDebit = acssDebit;
            }

            @Generated
            public void setBancontact(Bancontact bancontact) {
                this.bancontact = bancontact;
            }

            @Generated
            public void setCard(Card card) {
                this.card = card;
            }

            @Generated
            public void setCustomerBalance(CustomerBalance customerBalance) {
                this.customerBalance = customerBalance;
            }

            @Generated
            public void setKonbini(Konbini konbini) {
                this.konbini = konbini;
            }

            @Generated
            public void setUsBankAccount(UsBankAccount usBankAccount) {
                this.usBankAccount = usBankAccount;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PaymentMethodOptions)) {
                    return false;
                }
                PaymentMethodOptions other = (PaymentMethodOptions)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                AcssDebit this$acssDebit = this.getAcssDebit();
                AcssDebit other$acssDebit = other.getAcssDebit();
                if (this$acssDebit == null ? other$acssDebit != null : !((Object)this$acssDebit).equals(other$acssDebit)) {
                    return false;
                }
                Bancontact this$bancontact = this.getBancontact();
                Bancontact other$bancontact = other.getBancontact();
                if (this$bancontact == null ? other$bancontact != null : !((Object)this$bancontact).equals(other$bancontact)) {
                    return false;
                }
                Card this$card = this.getCard();
                Card other$card = other.getCard();
                if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                    return false;
                }
                CustomerBalance this$customerBalance = this.getCustomerBalance();
                CustomerBalance other$customerBalance = other.getCustomerBalance();
                if (this$customerBalance == null ? other$customerBalance != null : !((Object)this$customerBalance).equals(other$customerBalance)) {
                    return false;
                }
                Konbini this$konbini = this.getKonbini();
                Konbini other$konbini = other.getKonbini();
                if (this$konbini == null ? other$konbini != null : !((Object)this$konbini).equals(other$konbini)) {
                    return false;
                }
                UsBankAccount this$usBankAccount = this.getUsBankAccount();
                UsBankAccount other$usBankAccount = other.getUsBankAccount();
                return !(this$usBankAccount == null ? other$usBankAccount != null : !((Object)this$usBankAccount).equals(other$usBankAccount));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof PaymentMethodOptions;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                AcssDebit $acssDebit = this.getAcssDebit();
                result = result * 59 + ($acssDebit == null ? 43 : ((Object)$acssDebit).hashCode());
                Bancontact $bancontact = this.getBancontact();
                result = result * 59 + ($bancontact == null ? 43 : ((Object)$bancontact).hashCode());
                Card $card = this.getCard();
                result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
                CustomerBalance $customerBalance = this.getCustomerBalance();
                result = result * 59 + ($customerBalance == null ? 43 : ((Object)$customerBalance).hashCode());
                Konbini $konbini = this.getKonbini();
                result = result * 59 + ($konbini == null ? 43 : ((Object)$konbini).hashCode());
                UsBankAccount $usBankAccount = this.getUsBankAccount();
                result = result * 59 + ($usBankAccount == null ? 43 : ((Object)$usBankAccount).hashCode());
                return result;
            }

            public static class AcssDebit
            extends StripeObject {
                @SerializedName(value="mandate_options")
                MandateOptions mandateOptions;
                @SerializedName(value="verification_method")
                String verificationMethod;

                @Generated
                public MandateOptions getMandateOptions() {
                    return this.mandateOptions;
                }

                @Generated
                public String getVerificationMethod() {
                    return this.verificationMethod;
                }

                @Generated
                public void setMandateOptions(MandateOptions mandateOptions) {
                    this.mandateOptions = mandateOptions;
                }

                @Generated
                public void setVerificationMethod(String verificationMethod) {
                    this.verificationMethod = verificationMethod;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof AcssDebit)) {
                        return false;
                    }
                    AcssDebit other = (AcssDebit)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    MandateOptions this$mandateOptions = this.getMandateOptions();
                    MandateOptions other$mandateOptions = other.getMandateOptions();
                    if (this$mandateOptions == null ? other$mandateOptions != null : !((Object)this$mandateOptions).equals(other$mandateOptions)) {
                        return false;
                    }
                    String this$verificationMethod = this.getVerificationMethod();
                    String other$verificationMethod = other.getVerificationMethod();
                    return !(this$verificationMethod == null ? other$verificationMethod != null : !this$verificationMethod.equals(other$verificationMethod));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof AcssDebit;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    MandateOptions $mandateOptions = this.getMandateOptions();
                    result = result * 59 + ($mandateOptions == null ? 43 : ((Object)$mandateOptions).hashCode());
                    String $verificationMethod = this.getVerificationMethod();
                    result = result * 59 + ($verificationMethod == null ? 43 : $verificationMethod.hashCode());
                    return result;
                }

                public static class MandateOptions
                extends StripeObject {
                    @SerializedName(value="transaction_type")
                    String transactionType;

                    @Generated
                    public String getTransactionType() {
                        return this.transactionType;
                    }

                    @Generated
                    public void setTransactionType(String transactionType) {
                        this.transactionType = transactionType;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof MandateOptions)) {
                            return false;
                        }
                        MandateOptions other = (MandateOptions)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$transactionType = this.getTransactionType();
                        String other$transactionType = other.getTransactionType();
                        return !(this$transactionType == null ? other$transactionType != null : !this$transactionType.equals(other$transactionType));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof MandateOptions;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $transactionType = this.getTransactionType();
                        result = result * 59 + ($transactionType == null ? 43 : $transactionType.hashCode());
                        return result;
                    }
                }
            }

            public static class Bancontact
            extends StripeObject {
                @SerializedName(value="preferred_language")
                String preferredLanguage;

                @Generated
                public String getPreferredLanguage() {
                    return this.preferredLanguage;
                }

                @Generated
                public void setPreferredLanguage(String preferredLanguage) {
                    this.preferredLanguage = preferredLanguage;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Bancontact)) {
                        return false;
                    }
                    Bancontact other = (Bancontact)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$preferredLanguage = this.getPreferredLanguage();
                    String other$preferredLanguage = other.getPreferredLanguage();
                    return !(this$preferredLanguage == null ? other$preferredLanguage != null : !this$preferredLanguage.equals(other$preferredLanguage));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Bancontact;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $preferredLanguage = this.getPreferredLanguage();
                    result = result * 59 + ($preferredLanguage == null ? 43 : $preferredLanguage.hashCode());
                    return result;
                }
            }

            public static class Card
            extends StripeObject {
                @SerializedName(value="mandate_options")
                MandateOptions mandateOptions;
                @SerializedName(value="network")
                String network;
                @SerializedName(value="request_three_d_secure")
                String requestThreeDSecure;

                @Generated
                public MandateOptions getMandateOptions() {
                    return this.mandateOptions;
                }

                @Generated
                public String getNetwork() {
                    return this.network;
                }

                @Generated
                public String getRequestThreeDSecure() {
                    return this.requestThreeDSecure;
                }

                @Generated
                public void setMandateOptions(MandateOptions mandateOptions) {
                    this.mandateOptions = mandateOptions;
                }

                @Generated
                public void setNetwork(String network) {
                    this.network = network;
                }

                @Generated
                public void setRequestThreeDSecure(String requestThreeDSecure) {
                    this.requestThreeDSecure = requestThreeDSecure;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Card)) {
                        return false;
                    }
                    Card other = (Card)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    MandateOptions this$mandateOptions = this.getMandateOptions();
                    MandateOptions other$mandateOptions = other.getMandateOptions();
                    if (this$mandateOptions == null ? other$mandateOptions != null : !((Object)this$mandateOptions).equals(other$mandateOptions)) {
                        return false;
                    }
                    String this$network = this.getNetwork();
                    String other$network = other.getNetwork();
                    if (this$network == null ? other$network != null : !this$network.equals(other$network)) {
                        return false;
                    }
                    String this$requestThreeDSecure = this.getRequestThreeDSecure();
                    String other$requestThreeDSecure = other.getRequestThreeDSecure();
                    return !(this$requestThreeDSecure == null ? other$requestThreeDSecure != null : !this$requestThreeDSecure.equals(other$requestThreeDSecure));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Card;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    MandateOptions $mandateOptions = this.getMandateOptions();
                    result = result * 59 + ($mandateOptions == null ? 43 : ((Object)$mandateOptions).hashCode());
                    String $network = this.getNetwork();
                    result = result * 59 + ($network == null ? 43 : $network.hashCode());
                    String $requestThreeDSecure = this.getRequestThreeDSecure();
                    result = result * 59 + ($requestThreeDSecure == null ? 43 : $requestThreeDSecure.hashCode());
                    return result;
                }

                public static class MandateOptions
                extends StripeObject {
                    @SerializedName(value="amount")
                    Long amount;
                    @SerializedName(value="amount_type")
                    String amountType;
                    @SerializedName(value="description")
                    String description;

                    @Generated
                    public Long getAmount() {
                        return this.amount;
                    }

                    @Generated
                    public String getAmountType() {
                        return this.amountType;
                    }

                    @Generated
                    public String getDescription() {
                        return this.description;
                    }

                    @Generated
                    public void setAmount(Long amount) {
                        this.amount = amount;
                    }

                    @Generated
                    public void setAmountType(String amountType) {
                        this.amountType = amountType;
                    }

                    @Generated
                    public void setDescription(String description) {
                        this.description = description;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof MandateOptions)) {
                            return false;
                        }
                        MandateOptions other = (MandateOptions)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Long this$amount = this.getAmount();
                        Long other$amount = other.getAmount();
                        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                            return false;
                        }
                        String this$amountType = this.getAmountType();
                        String other$amountType = other.getAmountType();
                        if (this$amountType == null ? other$amountType != null : !this$amountType.equals(other$amountType)) {
                            return false;
                        }
                        String this$description = this.getDescription();
                        String other$description = other.getDescription();
                        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof MandateOptions;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Long $amount = this.getAmount();
                        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                        String $amountType = this.getAmountType();
                        result = result * 59 + ($amountType == null ? 43 : $amountType.hashCode());
                        String $description = this.getDescription();
                        result = result * 59 + ($description == null ? 43 : $description.hashCode());
                        return result;
                    }
                }
            }

            public static class CustomerBalance
            extends StripeObject {
                @SerializedName(value="bank_transfer")
                BankTransfer bankTransfer;
                @SerializedName(value="funding_type")
                String fundingType;

                @Generated
                public BankTransfer getBankTransfer() {
                    return this.bankTransfer;
                }

                @Generated
                public String getFundingType() {
                    return this.fundingType;
                }

                @Generated
                public void setBankTransfer(BankTransfer bankTransfer) {
                    this.bankTransfer = bankTransfer;
                }

                @Generated
                public void setFundingType(String fundingType) {
                    this.fundingType = fundingType;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof CustomerBalance)) {
                        return false;
                    }
                    CustomerBalance other = (CustomerBalance)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    BankTransfer this$bankTransfer = this.getBankTransfer();
                    BankTransfer other$bankTransfer = other.getBankTransfer();
                    if (this$bankTransfer == null ? other$bankTransfer != null : !((Object)this$bankTransfer).equals(other$bankTransfer)) {
                        return false;
                    }
                    String this$fundingType = this.getFundingType();
                    String other$fundingType = other.getFundingType();
                    return !(this$fundingType == null ? other$fundingType != null : !this$fundingType.equals(other$fundingType));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof CustomerBalance;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    BankTransfer $bankTransfer = this.getBankTransfer();
                    result = result * 59 + ($bankTransfer == null ? 43 : ((Object)$bankTransfer).hashCode());
                    String $fundingType = this.getFundingType();
                    result = result * 59 + ($fundingType == null ? 43 : $fundingType.hashCode());
                    return result;
                }

                public static class BankTransfer
                extends StripeObject {
                    @SerializedName(value="eu_bank_transfer")
                    EuBankTransfer euBankTransfer;
                    @SerializedName(value="type")
                    String type;

                    @Generated
                    public EuBankTransfer getEuBankTransfer() {
                        return this.euBankTransfer;
                    }

                    @Generated
                    public String getType() {
                        return this.type;
                    }

                    @Generated
                    public void setEuBankTransfer(EuBankTransfer euBankTransfer) {
                        this.euBankTransfer = euBankTransfer;
                    }

                    @Generated
                    public void setType(String type) {
                        this.type = type;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof BankTransfer)) {
                            return false;
                        }
                        BankTransfer other = (BankTransfer)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        EuBankTransfer this$euBankTransfer = this.getEuBankTransfer();
                        EuBankTransfer other$euBankTransfer = other.getEuBankTransfer();
                        if (this$euBankTransfer == null ? other$euBankTransfer != null : !((Object)this$euBankTransfer).equals(other$euBankTransfer)) {
                            return false;
                        }
                        String this$type = this.getType();
                        String other$type = other.getType();
                        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof BankTransfer;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        EuBankTransfer $euBankTransfer = this.getEuBankTransfer();
                        result = result * 59 + ($euBankTransfer == null ? 43 : ((Object)$euBankTransfer).hashCode());
                        String $type = this.getType();
                        result = result * 59 + ($type == null ? 43 : $type.hashCode());
                        return result;
                    }

                    public static class EuBankTransfer
                    extends StripeObject {
                        @SerializedName(value="country")
                        String country;

                        @Generated
                        public String getCountry() {
                            return this.country;
                        }

                        @Generated
                        public void setCountry(String country) {
                            this.country = country;
                        }

                        @Generated
                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof EuBankTransfer)) {
                                return false;
                            }
                            EuBankTransfer other = (EuBankTransfer)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            String this$country = this.getCountry();
                            String other$country = other.getCountry();
                            return !(this$country == null ? other$country != null : !this$country.equals(other$country));
                        }

                        @Generated
                        protected boolean canEqual(Object other) {
                            return other instanceof EuBankTransfer;
                        }

                        @Generated
                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            String $country = this.getCountry();
                            result = result * 59 + ($country == null ? 43 : $country.hashCode());
                            return result;
                        }
                    }
                }
            }

            public static class Konbini
            extends StripeObject {
                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Konbini)) {
                        return false;
                    }
                    Konbini other = (Konbini)o;
                    return other.canEqual(this);
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Konbini;
                }

                @Generated
                public int hashCode() {
                    boolean result = true;
                    return 1;
                }
            }

            public static class UsBankAccount
            extends StripeObject {
                @SerializedName(value="financial_connections")
                FinancialConnections financialConnections;
                @SerializedName(value="verification_method")
                String verificationMethod;

                @Generated
                public FinancialConnections getFinancialConnections() {
                    return this.financialConnections;
                }

                @Generated
                public String getVerificationMethod() {
                    return this.verificationMethod;
                }

                @Generated
                public void setFinancialConnections(FinancialConnections financialConnections) {
                    this.financialConnections = financialConnections;
                }

                @Generated
                public void setVerificationMethod(String verificationMethod) {
                    this.verificationMethod = verificationMethod;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof UsBankAccount)) {
                        return false;
                    }
                    UsBankAccount other = (UsBankAccount)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    FinancialConnections this$financialConnections = this.getFinancialConnections();
                    FinancialConnections other$financialConnections = other.getFinancialConnections();
                    if (this$financialConnections == null ? other$financialConnections != null : !((Object)this$financialConnections).equals(other$financialConnections)) {
                        return false;
                    }
                    String this$verificationMethod = this.getVerificationMethod();
                    String other$verificationMethod = other.getVerificationMethod();
                    return !(this$verificationMethod == null ? other$verificationMethod != null : !this$verificationMethod.equals(other$verificationMethod));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof UsBankAccount;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    FinancialConnections $financialConnections = this.getFinancialConnections();
                    result = result * 59 + ($financialConnections == null ? 43 : ((Object)$financialConnections).hashCode());
                    String $verificationMethod = this.getVerificationMethod();
                    result = result * 59 + ($verificationMethod == null ? 43 : $verificationMethod.hashCode());
                    return result;
                }

                public static class FinancialConnections
                extends StripeObject {
                    @SerializedName(value="permissions")
                    List<String> permissions;

                    @Generated
                    public List<String> getPermissions() {
                        return this.permissions;
                    }

                    @Generated
                    public void setPermissions(List<String> permissions) {
                        this.permissions = permissions;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof FinancialConnections)) {
                            return false;
                        }
                        FinancialConnections other = (FinancialConnections)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        List<String> this$permissions = this.getPermissions();
                        List<String> other$permissions = other.getPermissions();
                        return !(this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof FinancialConnections;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        List<String> $permissions = this.getPermissions();
                        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
                        return result;
                    }
                }
            }
        }
    }

    public static class PendingInvoiceItemInterval
    extends StripeObject {
        @SerializedName(value="interval")
        String interval;
        @SerializedName(value="interval_count")
        Long intervalCount;

        @Generated
        public String getInterval() {
            return this.interval;
        }

        @Generated
        public Long getIntervalCount() {
            return this.intervalCount;
        }

        @Generated
        public void setInterval(String interval) {
            this.interval = interval;
        }

        @Generated
        public void setIntervalCount(Long intervalCount) {
            this.intervalCount = intervalCount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PendingInvoiceItemInterval)) {
                return false;
            }
            PendingInvoiceItemInterval other = (PendingInvoiceItemInterval)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$intervalCount = this.getIntervalCount();
            Long other$intervalCount = other.getIntervalCount();
            if (this$intervalCount == null ? other$intervalCount != null : !((Object)this$intervalCount).equals(other$intervalCount)) {
                return false;
            }
            String this$interval = this.getInterval();
            String other$interval = other.getInterval();
            return !(this$interval == null ? other$interval != null : !this$interval.equals(other$interval));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PendingInvoiceItemInterval;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $intervalCount = this.getIntervalCount();
            result = result * 59 + ($intervalCount == null ? 43 : ((Object)$intervalCount).hashCode());
            String $interval = this.getInterval();
            result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
            return result;
        }
    }

    public static class PendingUpdate
    extends StripeObject {
        @SerializedName(value="billing_cycle_anchor")
        Long billingCycleAnchor;
        @SerializedName(value="expires_at")
        Long expiresAt;
        @SerializedName(value="prebilling_iterations")
        Long prebillingIterations;
        @SerializedName(value="subscription_items")
        List<SubscriptionItem> subscriptionItems;
        @SerializedName(value="trial_end")
        Long trialEnd;
        @SerializedName(value="trial_from_plan")
        Boolean trialFromPlan;

        @Generated
        public Long getBillingCycleAnchor() {
            return this.billingCycleAnchor;
        }

        @Generated
        public Long getExpiresAt() {
            return this.expiresAt;
        }

        @Generated
        public Long getPrebillingIterations() {
            return this.prebillingIterations;
        }

        @Generated
        public List<SubscriptionItem> getSubscriptionItems() {
            return this.subscriptionItems;
        }

        @Generated
        public Long getTrialEnd() {
            return this.trialEnd;
        }

        @Generated
        public Boolean getTrialFromPlan() {
            return this.trialFromPlan;
        }

        @Generated
        public void setBillingCycleAnchor(Long billingCycleAnchor) {
            this.billingCycleAnchor = billingCycleAnchor;
        }

        @Generated
        public void setExpiresAt(Long expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Generated
        public void setPrebillingIterations(Long prebillingIterations) {
            this.prebillingIterations = prebillingIterations;
        }

        @Generated
        public void setSubscriptionItems(List<SubscriptionItem> subscriptionItems) {
            this.subscriptionItems = subscriptionItems;
        }

        @Generated
        public void setTrialEnd(Long trialEnd) {
            this.trialEnd = trialEnd;
        }

        @Generated
        public void setTrialFromPlan(Boolean trialFromPlan) {
            this.trialFromPlan = trialFromPlan;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PendingUpdate)) {
                return false;
            }
            PendingUpdate other = (PendingUpdate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$billingCycleAnchor = this.getBillingCycleAnchor();
            Long other$billingCycleAnchor = other.getBillingCycleAnchor();
            if (this$billingCycleAnchor == null ? other$billingCycleAnchor != null : !((Object)this$billingCycleAnchor).equals(other$billingCycleAnchor)) {
                return false;
            }
            Long this$expiresAt = this.getExpiresAt();
            Long other$expiresAt = other.getExpiresAt();
            if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
                return false;
            }
            Long this$prebillingIterations = this.getPrebillingIterations();
            Long other$prebillingIterations = other.getPrebillingIterations();
            if (this$prebillingIterations == null ? other$prebillingIterations != null : !((Object)this$prebillingIterations).equals(other$prebillingIterations)) {
                return false;
            }
            Long this$trialEnd = this.getTrialEnd();
            Long other$trialEnd = other.getTrialEnd();
            if (this$trialEnd == null ? other$trialEnd != null : !((Object)this$trialEnd).equals(other$trialEnd)) {
                return false;
            }
            Boolean this$trialFromPlan = this.getTrialFromPlan();
            Boolean other$trialFromPlan = other.getTrialFromPlan();
            if (this$trialFromPlan == null ? other$trialFromPlan != null : !((Object)this$trialFromPlan).equals(other$trialFromPlan)) {
                return false;
            }
            List<SubscriptionItem> this$subscriptionItems = this.getSubscriptionItems();
            List<SubscriptionItem> other$subscriptionItems = other.getSubscriptionItems();
            return !(this$subscriptionItems == null ? other$subscriptionItems != null : !((Object)this$subscriptionItems).equals(other$subscriptionItems));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PendingUpdate;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $billingCycleAnchor = this.getBillingCycleAnchor();
            result = result * 59 + ($billingCycleAnchor == null ? 43 : ((Object)$billingCycleAnchor).hashCode());
            Long $expiresAt = this.getExpiresAt();
            result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
            Long $prebillingIterations = this.getPrebillingIterations();
            result = result * 59 + ($prebillingIterations == null ? 43 : ((Object)$prebillingIterations).hashCode());
            Long $trialEnd = this.getTrialEnd();
            result = result * 59 + ($trialEnd == null ? 43 : ((Object)$trialEnd).hashCode());
            Boolean $trialFromPlan = this.getTrialFromPlan();
            result = result * 59 + ($trialFromPlan == null ? 43 : ((Object)$trialFromPlan).hashCode());
            List<SubscriptionItem> $subscriptionItems = this.getSubscriptionItems();
            result = result * 59 + ($subscriptionItems == null ? 43 : ((Object)$subscriptionItems).hashCode());
            return result;
        }
    }

    public static class Prebilling
    extends StripeObject {
        @SerializedName(value="invoice")
        ExpandableField<Invoice> invoice;
        @SerializedName(value="period_end")
        Long periodEnd;
        @SerializedName(value="period_start")
        Long periodStart;

        public String getInvoice() {
            return this.invoice != null ? this.invoice.getId() : null;
        }

        public void setInvoice(String id) {
            this.invoice = ApiResource.setExpandableFieldId(id, this.invoice);
        }

        public Invoice getInvoiceObject() {
            return this.invoice != null ? this.invoice.getExpanded() : null;
        }

        public void setInvoiceObject(Invoice expandableObject) {
            this.invoice = new ExpandableField<Invoice>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public Long getPeriodEnd() {
            return this.periodEnd;
        }

        @Generated
        public Long getPeriodStart() {
            return this.periodStart;
        }

        @Generated
        public void setPeriodEnd(Long periodEnd) {
            this.periodEnd = periodEnd;
        }

        @Generated
        public void setPeriodStart(Long periodStart) {
            this.periodStart = periodStart;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Prebilling)) {
                return false;
            }
            Prebilling other = (Prebilling)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$periodEnd = this.getPeriodEnd();
            Long other$periodEnd = other.getPeriodEnd();
            if (this$periodEnd == null ? other$periodEnd != null : !((Object)this$periodEnd).equals(other$periodEnd)) {
                return false;
            }
            Long this$periodStart = this.getPeriodStart();
            Long other$periodStart = other.getPeriodStart();
            if (this$periodStart == null ? other$periodStart != null : !((Object)this$periodStart).equals(other$periodStart)) {
                return false;
            }
            String this$invoice = this.getInvoice();
            String other$invoice = other.getInvoice();
            return !(this$invoice == null ? other$invoice != null : !this$invoice.equals(other$invoice));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Prebilling;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $periodEnd = this.getPeriodEnd();
            result = result * 59 + ($periodEnd == null ? 43 : ((Object)$periodEnd).hashCode());
            Long $periodStart = this.getPeriodStart();
            result = result * 59 + ($periodStart == null ? 43 : ((Object)$periodStart).hashCode());
            String $invoice = this.getInvoice();
            result = result * 59 + ($invoice == null ? 43 : $invoice.hashCode());
            return result;
        }
    }

    public static class TransferData
    extends StripeObject {
        @SerializedName(value="amount_percent")
        BigDecimal amountPercent;
        @SerializedName(value="destination")
        ExpandableField<Account> destination;

        public String getDestination() {
            return this.destination != null ? this.destination.getId() : null;
        }

        public void setDestination(String id) {
            this.destination = ApiResource.setExpandableFieldId(id, this.destination);
        }

        public Account getDestinationObject() {
            return this.destination != null ? this.destination.getExpanded() : null;
        }

        public void setDestinationObject(Account expandableObject) {
            this.destination = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public BigDecimal getAmountPercent() {
            return this.amountPercent;
        }

        @Generated
        public void setAmountPercent(BigDecimal amountPercent) {
            this.amountPercent = amountPercent;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransferData)) {
                return false;
            }
            TransferData other = (TransferData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BigDecimal this$amountPercent = this.getAmountPercent();
            BigDecimal other$amountPercent = other.getAmountPercent();
            if (this$amountPercent == null ? other$amountPercent != null : !((Object)this$amountPercent).equals(other$amountPercent)) {
                return false;
            }
            String this$destination = this.getDestination();
            String other$destination = other.getDestination();
            return !(this$destination == null ? other$destination != null : !this$destination.equals(other$destination));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TransferData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BigDecimal $amountPercent = this.getAmountPercent();
            result = result * 59 + ($amountPercent == null ? 43 : ((Object)$amountPercent).hashCode());
            String $destination = this.getDestination();
            result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
            return result;
        }
    }
}

