/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.CountrySpec;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.CountrySpecListParams;
import com.stripe.param.CountrySpecRetrieveParams;
import java.lang.reflect.Type;

public final class CountrySpecService
extends ApiService {
    public CountrySpecService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<CountrySpec> list(CountrySpecListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<CountrySpec> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<CountrySpec> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<CountrySpec> list(CountrySpecListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/country_specs";
        return (StripeCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), new TypeToken<StripeCollection<CountrySpec>>(){}.getType(), options, ApiMode.V1);
    }

    public CountrySpec retrieve(String country, CountrySpecRetrieveParams params) throws StripeException {
        return this.retrieve(country, params, null);
    }

    public CountrySpec retrieve(String country, RequestOptions options) throws StripeException {
        return this.retrieve(country, null, options);
    }

    public CountrySpec retrieve(String country) throws StripeException {
        return this.retrieve(country, null, null);
    }

    public CountrySpec retrieve(String country, CountrySpecRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/country_specs/%s", ApiResource.urlEncodeId(country));
        return (CountrySpec)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)CountrySpec.class), options, ApiMode.V1);
    }
}

