/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.QuotePhase;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.QuotePhaseListParams;
import com.stripe.param.QuotePhaseRetrieveParams;
import com.stripe.service.QuotePhaseLineItemService;
import java.lang.reflect.Type;

public final class QuotePhaseService
extends ApiService {
    public QuotePhaseService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<QuotePhase> list(QuotePhaseListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<QuotePhase> list(QuotePhaseListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/quote_phases";
        return (StripeCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), new TypeToken<StripeCollection<QuotePhase>>(){}.getType(), options, ApiMode.V1);
    }

    public QuotePhase retrieve(String quotePhase, QuotePhaseRetrieveParams params) throws StripeException {
        return this.retrieve(quotePhase, params, null);
    }

    public QuotePhase retrieve(String quotePhase, RequestOptions options) throws StripeException {
        return this.retrieve(quotePhase, null, options);
    }

    public QuotePhase retrieve(String quotePhase) throws StripeException {
        return this.retrieve(quotePhase, null, null);
    }

    public QuotePhase retrieve(String quotePhase, QuotePhaseRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/quote_phases/%s", ApiResource.urlEncodeId(quotePhase));
        return (QuotePhase)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)QuotePhase.class), options, ApiMode.V1);
    }

    public QuotePhaseLineItemService lineItems() {
        return new QuotePhaseLineItemService(this.getResponseGetter());
    }
}

