/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.CountrySpecCollection;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.CountrySpecListParams;
import com.stripe.param.CountrySpecRetrieveParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class CountrySpec
extends ApiResource
implements HasId {
    @SerializedName(value="default_currency")
    String defaultCurrency;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="supported_bank_account_currencies")
    Map<String, List<String>> supportedBankAccountCurrencies;
    @SerializedName(value="supported_payment_currencies")
    List<String> supportedPaymentCurrencies;
    @SerializedName(value="supported_payment_methods")
    List<String> supportedPaymentMethods;
    @SerializedName(value="supported_transfer_countries")
    List<String> supportedTransferCountries;
    @SerializedName(value="verification_fields")
    VerificationFields verificationFields;

    public static CountrySpecCollection list(Map<String, Object> params) throws StripeException {
        return CountrySpec.list(params, (RequestOptions)null);
    }

    public static CountrySpecCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/country_specs";
        return (CountrySpecCollection)CountrySpec.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)CountrySpecCollection.class), options, ApiMode.V1);
    }

    public static CountrySpecCollection list(CountrySpecListParams params) throws StripeException {
        return CountrySpec.list(params, (RequestOptions)null);
    }

    public static CountrySpecCollection list(CountrySpecListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/country_specs";
        ApiResource.checkNullTypedParams(path, params);
        return (CountrySpecCollection)CountrySpec.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)CountrySpecCollection.class), options, ApiMode.V1);
    }

    public static CountrySpec retrieve(String country) throws StripeException {
        return CountrySpec.retrieve(country, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static CountrySpec retrieve(String country, RequestOptions options) throws StripeException {
        return CountrySpec.retrieve(country, (Map<String, Object>)null, options);
    }

    public static CountrySpec retrieve(String country, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/country_specs/%s", ApiResource.urlEncodeId(country));
        return (CountrySpec)CountrySpec.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)CountrySpec.class), options, ApiMode.V1);
    }

    public static CountrySpec retrieve(String country, CountrySpecRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/country_specs/%s", ApiResource.urlEncodeId(country));
        ApiResource.checkNullTypedParams(path, params);
        return (CountrySpec)CountrySpec.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)CountrySpec.class), options, ApiMode.V1);
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.verificationFields, responseGetter);
    }

    @Generated
    public String getDefaultCurrency() {
        return this.defaultCurrency;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Map<String, List<String>> getSupportedBankAccountCurrencies() {
        return this.supportedBankAccountCurrencies;
    }

    @Generated
    public List<String> getSupportedPaymentCurrencies() {
        return this.supportedPaymentCurrencies;
    }

    @Generated
    public List<String> getSupportedPaymentMethods() {
        return this.supportedPaymentMethods;
    }

    @Generated
    public List<String> getSupportedTransferCountries() {
        return this.supportedTransferCountries;
    }

    @Generated
    public VerificationFields getVerificationFields() {
        return this.verificationFields;
    }

    @Generated
    public void setDefaultCurrency(String defaultCurrency) {
        this.defaultCurrency = defaultCurrency;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setSupportedBankAccountCurrencies(Map<String, List<String>> supportedBankAccountCurrencies) {
        this.supportedBankAccountCurrencies = supportedBankAccountCurrencies;
    }

    @Generated
    public void setSupportedPaymentCurrencies(List<String> supportedPaymentCurrencies) {
        this.supportedPaymentCurrencies = supportedPaymentCurrencies;
    }

    @Generated
    public void setSupportedPaymentMethods(List<String> supportedPaymentMethods) {
        this.supportedPaymentMethods = supportedPaymentMethods;
    }

    @Generated
    public void setSupportedTransferCountries(List<String> supportedTransferCountries) {
        this.supportedTransferCountries = supportedTransferCountries;
    }

    @Generated
    public void setVerificationFields(VerificationFields verificationFields) {
        this.verificationFields = verificationFields;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CountrySpec)) {
            return false;
        }
        CountrySpec other = (CountrySpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$defaultCurrency = this.getDefaultCurrency();
        String other$defaultCurrency = other.getDefaultCurrency();
        if (this$defaultCurrency == null ? other$defaultCurrency != null : !this$defaultCurrency.equals(other$defaultCurrency)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Map<String, List<String>> this$supportedBankAccountCurrencies = this.getSupportedBankAccountCurrencies();
        Map<String, List<String>> other$supportedBankAccountCurrencies = other.getSupportedBankAccountCurrencies();
        if (this$supportedBankAccountCurrencies == null ? other$supportedBankAccountCurrencies != null : !((Object)this$supportedBankAccountCurrencies).equals(other$supportedBankAccountCurrencies)) {
            return false;
        }
        List<String> this$supportedPaymentCurrencies = this.getSupportedPaymentCurrencies();
        List<String> other$supportedPaymentCurrencies = other.getSupportedPaymentCurrencies();
        if (this$supportedPaymentCurrencies == null ? other$supportedPaymentCurrencies != null : !((Object)this$supportedPaymentCurrencies).equals(other$supportedPaymentCurrencies)) {
            return false;
        }
        List<String> this$supportedPaymentMethods = this.getSupportedPaymentMethods();
        List<String> other$supportedPaymentMethods = other.getSupportedPaymentMethods();
        if (this$supportedPaymentMethods == null ? other$supportedPaymentMethods != null : !((Object)this$supportedPaymentMethods).equals(other$supportedPaymentMethods)) {
            return false;
        }
        List<String> this$supportedTransferCountries = this.getSupportedTransferCountries();
        List<String> other$supportedTransferCountries = other.getSupportedTransferCountries();
        if (this$supportedTransferCountries == null ? other$supportedTransferCountries != null : !((Object)this$supportedTransferCountries).equals(other$supportedTransferCountries)) {
            return false;
        }
        VerificationFields this$verificationFields = this.getVerificationFields();
        VerificationFields other$verificationFields = other.getVerificationFields();
        return !(this$verificationFields == null ? other$verificationFields != null : !((Object)this$verificationFields).equals(other$verificationFields));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CountrySpec;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $defaultCurrency = this.getDefaultCurrency();
        result = result * 59 + ($defaultCurrency == null ? 43 : $defaultCurrency.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Map<String, List<String>> $supportedBankAccountCurrencies = this.getSupportedBankAccountCurrencies();
        result = result * 59 + ($supportedBankAccountCurrencies == null ? 43 : ((Object)$supportedBankAccountCurrencies).hashCode());
        List<String> $supportedPaymentCurrencies = this.getSupportedPaymentCurrencies();
        result = result * 59 + ($supportedPaymentCurrencies == null ? 43 : ((Object)$supportedPaymentCurrencies).hashCode());
        List<String> $supportedPaymentMethods = this.getSupportedPaymentMethods();
        result = result * 59 + ($supportedPaymentMethods == null ? 43 : ((Object)$supportedPaymentMethods).hashCode());
        List<String> $supportedTransferCountries = this.getSupportedTransferCountries();
        result = result * 59 + ($supportedTransferCountries == null ? 43 : ((Object)$supportedTransferCountries).hashCode());
        VerificationFields $verificationFields = this.getVerificationFields();
        result = result * 59 + ($verificationFields == null ? 43 : ((Object)$verificationFields).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class VerificationFields
    extends StripeObject {
        @SerializedName(value="company")
        Company company;
        @SerializedName(value="individual")
        Individual individual;

        @Generated
        public Company getCompany() {
            return this.company;
        }

        @Generated
        public Individual getIndividual() {
            return this.individual;
        }

        @Generated
        public void setCompany(Company company) {
            this.company = company;
        }

        @Generated
        public void setIndividual(Individual individual) {
            this.individual = individual;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VerificationFields)) {
                return false;
            }
            VerificationFields other = (VerificationFields)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Company this$company = this.getCompany();
            Company other$company = other.getCompany();
            if (this$company == null ? other$company != null : !((Object)this$company).equals(other$company)) {
                return false;
            }
            Individual this$individual = this.getIndividual();
            Individual other$individual = other.getIndividual();
            return !(this$individual == null ? other$individual != null : !((Object)this$individual).equals(other$individual));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof VerificationFields;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Company $company = this.getCompany();
            result = result * 59 + ($company == null ? 43 : ((Object)$company).hashCode());
            Individual $individual = this.getIndividual();
            result = result * 59 + ($individual == null ? 43 : ((Object)$individual).hashCode());
            return result;
        }

        public static class Company
        extends StripeObject {
            @SerializedName(value="additional")
            List<String> additional;
            @SerializedName(value="minimum")
            List<String> minimum;

            @Generated
            public List<String> getAdditional() {
                return this.additional;
            }

            @Generated
            public List<String> getMinimum() {
                return this.minimum;
            }

            @Generated
            public void setAdditional(List<String> additional) {
                this.additional = additional;
            }

            @Generated
            public void setMinimum(List<String> minimum) {
                this.minimum = minimum;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Company)) {
                    return false;
                }
                Company other = (Company)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<String> this$additional = this.getAdditional();
                List<String> other$additional = other.getAdditional();
                if (this$additional == null ? other$additional != null : !((Object)this$additional).equals(other$additional)) {
                    return false;
                }
                List<String> this$minimum = this.getMinimum();
                List<String> other$minimum = other.getMinimum();
                return !(this$minimum == null ? other$minimum != null : !((Object)this$minimum).equals(other$minimum));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Company;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<String> $additional = this.getAdditional();
                result = result * 59 + ($additional == null ? 43 : ((Object)$additional).hashCode());
                List<String> $minimum = this.getMinimum();
                result = result * 59 + ($minimum == null ? 43 : ((Object)$minimum).hashCode());
                return result;
            }
        }

        public static class Individual
        extends StripeObject {
            @SerializedName(value="additional")
            List<String> additional;
            @SerializedName(value="minimum")
            List<String> minimum;

            @Generated
            public List<String> getAdditional() {
                return this.additional;
            }

            @Generated
            public List<String> getMinimum() {
                return this.minimum;
            }

            @Generated
            public void setAdditional(List<String> additional) {
                this.additional = additional;
            }

            @Generated
            public void setMinimum(List<String> minimum) {
                this.minimum = minimum;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Individual)) {
                    return false;
                }
                Individual other = (Individual)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<String> this$additional = this.getAdditional();
                List<String> other$additional = other.getAdditional();
                if (this$additional == null ? other$additional != null : !((Object)this$additional).equals(other$additional)) {
                    return false;
                }
                List<String> this$minimum = this.getMinimum();
                List<String> other$minimum = other.getMinimum();
                return !(this$minimum == null ? other$minimum != null : !((Object)this$minimum).equals(other$minimum));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Individual;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<String> $additional = this.getAdditional();
                result = result * 59 + ($additional == null ? 43 : ((Object)$additional).hashCode());
                List<String> $minimum = this.getMinimum();
                result = result * 59 + ($minimum == null ? 43 : ((Object)$minimum).hashCode());
                return result;
            }
        }
    }
}

