/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.checkout;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.checkout.Session;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.checkout.SessionCreateParams;
import com.stripe.param.checkout.SessionExpireParams;
import com.stripe.param.checkout.SessionListParams;
import com.stripe.param.checkout.SessionRetrieveParams;
import com.stripe.service.checkout.SessionLineItemService;
import java.lang.reflect.Type;

public final class SessionService
extends ApiService {
    public SessionService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Session> list(SessionListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Session> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Session> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Session> list(SessionListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/checkout/sessions";
        return (StripeCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), new TypeToken<StripeCollection<Session>>(){}.getType(), options, ApiMode.V1);
    }

    public Session create(SessionCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Session create(RequestOptions options) throws StripeException {
        return this.create(null, options);
    }

    public Session create() throws StripeException {
        return this.create(null, null);
    }

    public Session create(SessionCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/checkout/sessions";
        return (Session)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Session.class), options, ApiMode.V1);
    }

    public Session retrieve(String session, SessionRetrieveParams params) throws StripeException {
        return this.retrieve(session, params, null);
    }

    public Session retrieve(String session, RequestOptions options) throws StripeException {
        return this.retrieve(session, null, options);
    }

    public Session retrieve(String session) throws StripeException {
        return this.retrieve(session, null, null);
    }

    public Session retrieve(String session, SessionRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/checkout/sessions/%s", ApiResource.urlEncodeId(session));
        return (Session)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Session.class), options, ApiMode.V1);
    }

    public Session expire(String session, SessionExpireParams params) throws StripeException {
        return this.expire(session, params, null);
    }

    public Session expire(String session, RequestOptions options) throws StripeException {
        return this.expire(session, null, options);
    }

    public Session expire(String session) throws StripeException {
        return this.expire(session, null, null);
    }

    public Session expire(String session, SessionExpireParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/checkout/sessions/%s/expire", ApiResource.urlEncodeId(session));
        return (Session)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Session.class), options, ApiMode.V1);
    }

    public SessionLineItemService lineItems() {
        return new SessionLineItemService(this.getResponseGetter());
    }
}

