/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import com.stripe.param.common.EmptyParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class PaymentIntentCaptureParams
extends ApiRequestParams {
    @SerializedName(value="amount_to_capture")
    Long amountToCapture;
    @SerializedName(value="application_fee_amount")
    Long applicationFeeAmount;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="final_capture")
    Boolean finalCapture;
    @SerializedName(value="metadata")
    Object metadata;
    @SerializedName(value="payment_details")
    Object paymentDetails;
    @SerializedName(value="statement_descriptor")
    String statementDescriptor;
    @SerializedName(value="statement_descriptor_suffix")
    String statementDescriptorSuffix;
    @SerializedName(value="transfer_data")
    TransferData transferData;

    private PaymentIntentCaptureParams(Long amountToCapture, Long applicationFeeAmount, List<String> expand, Map<String, Object> extraParams, Boolean finalCapture, Object metadata, Object paymentDetails, String statementDescriptor, String statementDescriptorSuffix, TransferData transferData) {
        this.amountToCapture = amountToCapture;
        this.applicationFeeAmount = applicationFeeAmount;
        this.expand = expand;
        this.extraParams = extraParams;
        this.finalCapture = finalCapture;
        this.metadata = metadata;
        this.paymentDetails = paymentDetails;
        this.statementDescriptor = statementDescriptor;
        this.statementDescriptorSuffix = statementDescriptorSuffix;
        this.transferData = transferData;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Long getAmountToCapture() {
        return this.amountToCapture;
    }

    @Generated
    public Long getApplicationFeeAmount() {
        return this.applicationFeeAmount;
    }

    @Generated
    public List<String> getExpand() {
        return this.expand;
    }

    @Generated
    public Map<String, Object> getExtraParams() {
        return this.extraParams;
    }

    @Generated
    public Boolean getFinalCapture() {
        return this.finalCapture;
    }

    @Generated
    public Object getMetadata() {
        return this.metadata;
    }

    @Generated
    public Object getPaymentDetails() {
        return this.paymentDetails;
    }

    @Generated
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @Generated
    public String getStatementDescriptorSuffix() {
        return this.statementDescriptorSuffix;
    }

    @Generated
    public TransferData getTransferData() {
        return this.transferData;
    }

    public static class TransferData {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;

        private TransferData(Long amount, Map<String, Object> extraParams) {
            this.amount = amount;
            this.extraParams = extraParams;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        public static class Builder {
            private Long amount;
            private Map<String, Object> extraParams;

            public TransferData build() {
                return new TransferData(this.amount, this.extraParams);
            }

            public Builder setAmount(Long amount) {
                this.amount = amount;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }
        }
    }

    public static class Builder {
        private Long amountToCapture;
        private Long applicationFeeAmount;
        private List<String> expand;
        private Map<String, Object> extraParams;
        private Boolean finalCapture;
        private Object metadata;
        private Object paymentDetails;
        private String statementDescriptor;
        private String statementDescriptorSuffix;
        private TransferData transferData;

        public PaymentIntentCaptureParams build() {
            return new PaymentIntentCaptureParams(this.amountToCapture, this.applicationFeeAmount, this.expand, this.extraParams, this.finalCapture, this.metadata, this.paymentDetails, this.statementDescriptor, this.statementDescriptorSuffix, this.transferData);
        }

        public Builder setAmountToCapture(Long amountToCapture) {
            this.amountToCapture = amountToCapture;
            return this;
        }

        public Builder setApplicationFeeAmount(Long applicationFeeAmount) {
            this.applicationFeeAmount = applicationFeeAmount;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder setFinalCapture(Boolean finalCapture) {
            this.finalCapture = finalCapture;
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null || this.metadata instanceof EmptyParam) {
                this.metadata = new HashMap();
            }
            ((Map)this.metadata).put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null || this.metadata instanceof EmptyParam) {
                this.metadata = new HashMap();
            }
            ((Map)this.metadata).putAll(map);
            return this;
        }

        public Builder setMetadata(EmptyParam metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setPaymentDetails(PaymentDetails paymentDetails) {
            this.paymentDetails = paymentDetails;
            return this;
        }

        public Builder setPaymentDetails(EmptyParam paymentDetails) {
            this.paymentDetails = paymentDetails;
            return this;
        }

        public Builder setStatementDescriptor(String statementDescriptor) {
            this.statementDescriptor = statementDescriptor;
            return this;
        }

        public Builder setStatementDescriptorSuffix(String statementDescriptorSuffix) {
            this.statementDescriptorSuffix = statementDescriptorSuffix;
            return this;
        }

        public Builder setTransferData(TransferData transferData) {
            this.transferData = transferData;
            return this;
        }
    }

    public static class PaymentDetails {
        @SerializedName(value="car_rental")
        CarRental carRental;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="flight")
        Flight flight;
        @SerializedName(value="lodging")
        Lodging lodging;

        private PaymentDetails(CarRental carRental, Map<String, Object> extraParams, Flight flight, Lodging lodging) {
            this.carRental = carRental;
            this.extraParams = extraParams;
            this.flight = flight;
            this.lodging = lodging;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public CarRental getCarRental() {
            return this.carRental;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Flight getFlight() {
            return this.flight;
        }

        @Generated
        public Lodging getLodging() {
            return this.lodging;
        }

        public static class CarRental {
            @SerializedName(value="booking_number")
            String bookingNumber;
            @SerializedName(value="car_class_code")
            String carClassCode;
            @SerializedName(value="car_make")
            String carMake;
            @SerializedName(value="car_model")
            String carModel;
            @SerializedName(value="company")
            String company;
            @SerializedName(value="customer_service_phone_number")
            String customerServicePhoneNumber;
            @SerializedName(value="days_rented")
            Long daysRented;
            @SerializedName(value="extra_charges")
            List<ExtraCharge> extraCharges;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="no_show")
            Boolean noShow;
            @SerializedName(value="pickup_address")
            PickupAddress pickupAddress;
            @SerializedName(value="pickup_at")
            Long pickupAt;
            @SerializedName(value="rate_amount")
            Long rateAmount;
            @SerializedName(value="rate_interval")
            RateInterval rateInterval;
            @SerializedName(value="renter_name")
            String renterName;
            @SerializedName(value="return_address")
            ReturnAddress returnAddress;
            @SerializedName(value="return_at")
            Long returnAt;
            @SerializedName(value="tax_exempt")
            Boolean taxExempt;

            private CarRental(String bookingNumber, String carClassCode, String carMake, String carModel, String company, String customerServicePhoneNumber, Long daysRented, List<ExtraCharge> extraCharges, Map<String, Object> extraParams, Boolean noShow, PickupAddress pickupAddress, Long pickupAt, Long rateAmount, RateInterval rateInterval, String renterName, ReturnAddress returnAddress, Long returnAt, Boolean taxExempt) {
                this.bookingNumber = bookingNumber;
                this.carClassCode = carClassCode;
                this.carMake = carMake;
                this.carModel = carModel;
                this.company = company;
                this.customerServicePhoneNumber = customerServicePhoneNumber;
                this.daysRented = daysRented;
                this.extraCharges = extraCharges;
                this.extraParams = extraParams;
                this.noShow = noShow;
                this.pickupAddress = pickupAddress;
                this.pickupAt = pickupAt;
                this.rateAmount = rateAmount;
                this.rateInterval = rateInterval;
                this.renterName = renterName;
                this.returnAddress = returnAddress;
                this.returnAt = returnAt;
                this.taxExempt = taxExempt;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getBookingNumber() {
                return this.bookingNumber;
            }

            @Generated
            public String getCarClassCode() {
                return this.carClassCode;
            }

            @Generated
            public String getCarMake() {
                return this.carMake;
            }

            @Generated
            public String getCarModel() {
                return this.carModel;
            }

            @Generated
            public String getCompany() {
                return this.company;
            }

            @Generated
            public String getCustomerServicePhoneNumber() {
                return this.customerServicePhoneNumber;
            }

            @Generated
            public Long getDaysRented() {
                return this.daysRented;
            }

            @Generated
            public List<ExtraCharge> getExtraCharges() {
                return this.extraCharges;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getNoShow() {
                return this.noShow;
            }

            @Generated
            public PickupAddress getPickupAddress() {
                return this.pickupAddress;
            }

            @Generated
            public Long getPickupAt() {
                return this.pickupAt;
            }

            @Generated
            public Long getRateAmount() {
                return this.rateAmount;
            }

            @Generated
            public RateInterval getRateInterval() {
                return this.rateInterval;
            }

            @Generated
            public String getRenterName() {
                return this.renterName;
            }

            @Generated
            public ReturnAddress getReturnAddress() {
                return this.returnAddress;
            }

            @Generated
            public Long getReturnAt() {
                return this.returnAt;
            }

            @Generated
            public Boolean getTaxExempt() {
                return this.taxExempt;
            }

            public static class PickupAddress {
                @SerializedName(value="city")
                String city;
                @SerializedName(value="country")
                String country;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="line1")
                String line1;
                @SerializedName(value="line2")
                String line2;
                @SerializedName(value="postal_code")
                String postalCode;
                @SerializedName(value="state")
                String state;

                private PickupAddress(String city, String country, Map<String, Object> extraParams, String line1, String line2, String postalCode, String state) {
                    this.city = city;
                    this.country = country;
                    this.extraParams = extraParams;
                    this.line1 = line1;
                    this.line2 = line2;
                    this.postalCode = postalCode;
                    this.state = state;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getCity() {
                    return this.city;
                }

                @Generated
                public String getCountry() {
                    return this.country;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getLine1() {
                    return this.line1;
                }

                @Generated
                public String getLine2() {
                    return this.line2;
                }

                @Generated
                public String getPostalCode() {
                    return this.postalCode;
                }

                @Generated
                public String getState() {
                    return this.state;
                }

                public static class Builder {
                    private String city;
                    private String country;
                    private Map<String, Object> extraParams;
                    private String line1;
                    private String line2;
                    private String postalCode;
                    private String state;

                    public PickupAddress build() {
                        return new PickupAddress(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                    }

                    public Builder setCity(String city) {
                        this.city = city;
                        return this;
                    }

                    public Builder setCountry(String country) {
                        this.country = country;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setLine1(String line1) {
                        this.line1 = line1;
                        return this;
                    }

                    public Builder setLine2(String line2) {
                        this.line2 = line2;
                        return this;
                    }

                    public Builder setPostalCode(String postalCode) {
                        this.postalCode = postalCode;
                        return this;
                    }

                    public Builder setState(String state) {
                        this.state = state;
                        return this;
                    }
                }
            }

            public static enum RateInterval implements ApiRequestParams.EnumParam
            {
                DAY("day"),
                MONTH("month"),
                WEEK("week");

                private final String value;

                private RateInterval(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class ReturnAddress {
                @SerializedName(value="city")
                String city;
                @SerializedName(value="country")
                String country;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="line1")
                String line1;
                @SerializedName(value="line2")
                String line2;
                @SerializedName(value="postal_code")
                String postalCode;
                @SerializedName(value="state")
                String state;

                private ReturnAddress(String city, String country, Map<String, Object> extraParams, String line1, String line2, String postalCode, String state) {
                    this.city = city;
                    this.country = country;
                    this.extraParams = extraParams;
                    this.line1 = line1;
                    this.line2 = line2;
                    this.postalCode = postalCode;
                    this.state = state;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getCity() {
                    return this.city;
                }

                @Generated
                public String getCountry() {
                    return this.country;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getLine1() {
                    return this.line1;
                }

                @Generated
                public String getLine2() {
                    return this.line2;
                }

                @Generated
                public String getPostalCode() {
                    return this.postalCode;
                }

                @Generated
                public String getState() {
                    return this.state;
                }

                public static class Builder {
                    private String city;
                    private String country;
                    private Map<String, Object> extraParams;
                    private String line1;
                    private String line2;
                    private String postalCode;
                    private String state;

                    public ReturnAddress build() {
                        return new ReturnAddress(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                    }

                    public Builder setCity(String city) {
                        this.city = city;
                        return this;
                    }

                    public Builder setCountry(String country) {
                        this.country = country;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setLine1(String line1) {
                        this.line1 = line1;
                        return this;
                    }

                    public Builder setLine2(String line2) {
                        this.line2 = line2;
                        return this;
                    }

                    public Builder setPostalCode(String postalCode) {
                        this.postalCode = postalCode;
                        return this;
                    }

                    public Builder setState(String state) {
                        this.state = state;
                        return this;
                    }
                }
            }

            public static class Builder {
                private String bookingNumber;
                private String carClassCode;
                private String carMake;
                private String carModel;
                private String company;
                private String customerServicePhoneNumber;
                private Long daysRented;
                private List<ExtraCharge> extraCharges;
                private Map<String, Object> extraParams;
                private Boolean noShow;
                private PickupAddress pickupAddress;
                private Long pickupAt;
                private Long rateAmount;
                private RateInterval rateInterval;
                private String renterName;
                private ReturnAddress returnAddress;
                private Long returnAt;
                private Boolean taxExempt;

                public CarRental build() {
                    return new CarRental(this.bookingNumber, this.carClassCode, this.carMake, this.carModel, this.company, this.customerServicePhoneNumber, this.daysRented, this.extraCharges, this.extraParams, this.noShow, this.pickupAddress, this.pickupAt, this.rateAmount, this.rateInterval, this.renterName, this.returnAddress, this.returnAt, this.taxExempt);
                }

                public Builder setBookingNumber(String bookingNumber) {
                    this.bookingNumber = bookingNumber;
                    return this;
                }

                public Builder setCarClassCode(String carClassCode) {
                    this.carClassCode = carClassCode;
                    return this;
                }

                public Builder setCarMake(String carMake) {
                    this.carMake = carMake;
                    return this;
                }

                public Builder setCarModel(String carModel) {
                    this.carModel = carModel;
                    return this;
                }

                public Builder setCompany(String company) {
                    this.company = company;
                    return this;
                }

                public Builder setCustomerServicePhoneNumber(String customerServicePhoneNumber) {
                    this.customerServicePhoneNumber = customerServicePhoneNumber;
                    return this;
                }

                public Builder setDaysRented(Long daysRented) {
                    this.daysRented = daysRented;
                    return this;
                }

                public Builder addExtraCharge(ExtraCharge element) {
                    if (this.extraCharges == null) {
                        this.extraCharges = new ArrayList<ExtraCharge>();
                    }
                    this.extraCharges.add(element);
                    return this;
                }

                public Builder addAllExtraCharge(List<ExtraCharge> elements) {
                    if (this.extraCharges == null) {
                        this.extraCharges = new ArrayList<ExtraCharge>();
                    }
                    this.extraCharges.addAll(elements);
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setNoShow(Boolean noShow) {
                    this.noShow = noShow;
                    return this;
                }

                public Builder setPickupAddress(PickupAddress pickupAddress) {
                    this.pickupAddress = pickupAddress;
                    return this;
                }

                public Builder setPickupAt(Long pickupAt) {
                    this.pickupAt = pickupAt;
                    return this;
                }

                public Builder setRateAmount(Long rateAmount) {
                    this.rateAmount = rateAmount;
                    return this;
                }

                public Builder setRateInterval(RateInterval rateInterval) {
                    this.rateInterval = rateInterval;
                    return this;
                }

                public Builder setRenterName(String renterName) {
                    this.renterName = renterName;
                    return this;
                }

                public Builder setReturnAddress(ReturnAddress returnAddress) {
                    this.returnAddress = returnAddress;
                    return this;
                }

                public Builder setReturnAt(Long returnAt) {
                    this.returnAt = returnAt;
                    return this;
                }

                public Builder setTaxExempt(Boolean taxExempt) {
                    this.taxExempt = taxExempt;
                    return this;
                }
            }

            public static enum ExtraCharge implements ApiRequestParams.EnumParam
            {
                EXTRA_MILEAGE("extra_mileage"),
                GAS("gas"),
                LATE_RETURN("late_return"),
                ONE_WAY_SERVICE("one_way_service"),
                PARKING_VIOLATION("parking_violation");

                private final String value;

                private ExtraCharge(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class Flight {
            @SerializedName(value="agency_number")
            String agencyNumber;
            @SerializedName(value="carrier")
            String carrier;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="passenger_name")
            String passengerName;
            @SerializedName(value="segments")
            List<Segment> segments;
            @SerializedName(value="ticket_number")
            String ticketNumber;

            private Flight(String agencyNumber, String carrier, Map<String, Object> extraParams, String passengerName, List<Segment> segments, String ticketNumber) {
                this.agencyNumber = agencyNumber;
                this.carrier = carrier;
                this.extraParams = extraParams;
                this.passengerName = passengerName;
                this.segments = segments;
                this.ticketNumber = ticketNumber;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getAgencyNumber() {
                return this.agencyNumber;
            }

            @Generated
            public String getCarrier() {
                return this.carrier;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getPassengerName() {
                return this.passengerName;
            }

            @Generated
            public List<Segment> getSegments() {
                return this.segments;
            }

            @Generated
            public String getTicketNumber() {
                return this.ticketNumber;
            }

            public static class Builder {
                private String agencyNumber;
                private String carrier;
                private Map<String, Object> extraParams;
                private String passengerName;
                private List<Segment> segments;
                private String ticketNumber;

                public Flight build() {
                    return new Flight(this.agencyNumber, this.carrier, this.extraParams, this.passengerName, this.segments, this.ticketNumber);
                }

                public Builder setAgencyNumber(String agencyNumber) {
                    this.agencyNumber = agencyNumber;
                    return this;
                }

                public Builder setCarrier(String carrier) {
                    this.carrier = carrier;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setPassengerName(String passengerName) {
                    this.passengerName = passengerName;
                    return this;
                }

                public Builder addSegment(Segment element) {
                    if (this.segments == null) {
                        this.segments = new ArrayList<Segment>();
                    }
                    this.segments.add(element);
                    return this;
                }

                public Builder addAllSegment(List<Segment> elements) {
                    if (this.segments == null) {
                        this.segments = new ArrayList<Segment>();
                    }
                    this.segments.addAll(elements);
                    return this;
                }

                public Builder setTicketNumber(String ticketNumber) {
                    this.ticketNumber = ticketNumber;
                    return this;
                }
            }

            public static class Segment {
                @SerializedName(value="arrival_airport")
                String arrivalAirport;
                @SerializedName(value="arrives_at")
                Long arrivesAt;
                @SerializedName(value="carrier")
                String carrier;
                @SerializedName(value="departs_at")
                Long departsAt;
                @SerializedName(value="departure_airport")
                String departureAirport;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="flight_number")
                String flightNumber;
                @SerializedName(value="service_class")
                ServiceClass serviceClass;

                private Segment(String arrivalAirport, Long arrivesAt, String carrier, Long departsAt, String departureAirport, Map<String, Object> extraParams, String flightNumber, ServiceClass serviceClass) {
                    this.arrivalAirport = arrivalAirport;
                    this.arrivesAt = arrivesAt;
                    this.carrier = carrier;
                    this.departsAt = departsAt;
                    this.departureAirport = departureAirport;
                    this.extraParams = extraParams;
                    this.flightNumber = flightNumber;
                    this.serviceClass = serviceClass;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getArrivalAirport() {
                    return this.arrivalAirport;
                }

                @Generated
                public Long getArrivesAt() {
                    return this.arrivesAt;
                }

                @Generated
                public String getCarrier() {
                    return this.carrier;
                }

                @Generated
                public Long getDepartsAt() {
                    return this.departsAt;
                }

                @Generated
                public String getDepartureAirport() {
                    return this.departureAirport;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getFlightNumber() {
                    return this.flightNumber;
                }

                @Generated
                public ServiceClass getServiceClass() {
                    return this.serviceClass;
                }

                public static enum ServiceClass implements ApiRequestParams.EnumParam
                {
                    BUSINESS("business"),
                    ECONOMY("economy"),
                    FIRST("first"),
                    PREMIUM_ECONOMY("premium_economy");

                    private final String value;

                    private ServiceClass(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private String arrivalAirport;
                    private Long arrivesAt;
                    private String carrier;
                    private Long departsAt;
                    private String departureAirport;
                    private Map<String, Object> extraParams;
                    private String flightNumber;
                    private ServiceClass serviceClass;

                    public Segment build() {
                        return new Segment(this.arrivalAirport, this.arrivesAt, this.carrier, this.departsAt, this.departureAirport, this.extraParams, this.flightNumber, this.serviceClass);
                    }

                    public Builder setArrivalAirport(String arrivalAirport) {
                        this.arrivalAirport = arrivalAirport;
                        return this;
                    }

                    public Builder setArrivesAt(Long arrivesAt) {
                        this.arrivesAt = arrivesAt;
                        return this;
                    }

                    public Builder setCarrier(String carrier) {
                        this.carrier = carrier;
                        return this;
                    }

                    public Builder setDepartsAt(Long departsAt) {
                        this.departsAt = departsAt;
                        return this;
                    }

                    public Builder setDepartureAirport(String departureAirport) {
                        this.departureAirport = departureAirport;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setFlightNumber(String flightNumber) {
                        this.flightNumber = flightNumber;
                        return this;
                    }

                    public Builder setServiceClass(ServiceClass serviceClass) {
                        this.serviceClass = serviceClass;
                        return this;
                    }
                }
            }
        }

        public static class Lodging {
            @SerializedName(value="address")
            Address address;
            @SerializedName(value="adults")
            Long adults;
            @SerializedName(value="booking_number")
            String bookingNumber;
            @SerializedName(value="category")
            Category category;
            @SerializedName(value="checkin_at")
            Long checkinAt;
            @SerializedName(value="checkout_at")
            Long checkoutAt;
            @SerializedName(value="customer_service_phone_number")
            String customerServicePhoneNumber;
            @SerializedName(value="daily_room_rate_amount")
            Long dailyRoomRateAmount;
            @SerializedName(value="extra_charges")
            List<ExtraCharge> extraCharges;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="fire_safety_act_compliance")
            Boolean fireSafetyActCompliance;
            @SerializedName(value="name")
            String name;
            @SerializedName(value="no_show")
            Boolean noShow;
            @SerializedName(value="property_phone_number")
            String propertyPhoneNumber;
            @SerializedName(value="room_nights")
            Long roomNights;
            @SerializedName(value="total_room_tax_amount")
            Long totalRoomTaxAmount;
            @SerializedName(value="total_tax_amount")
            Long totalTaxAmount;

            private Lodging(Address address, Long adults, String bookingNumber, Category category, Long checkinAt, Long checkoutAt, String customerServicePhoneNumber, Long dailyRoomRateAmount, List<ExtraCharge> extraCharges, Map<String, Object> extraParams, Boolean fireSafetyActCompliance, String name, Boolean noShow, String propertyPhoneNumber, Long roomNights, Long totalRoomTaxAmount, Long totalTaxAmount) {
                this.address = address;
                this.adults = adults;
                this.bookingNumber = bookingNumber;
                this.category = category;
                this.checkinAt = checkinAt;
                this.checkoutAt = checkoutAt;
                this.customerServicePhoneNumber = customerServicePhoneNumber;
                this.dailyRoomRateAmount = dailyRoomRateAmount;
                this.extraCharges = extraCharges;
                this.extraParams = extraParams;
                this.fireSafetyActCompliance = fireSafetyActCompliance;
                this.name = name;
                this.noShow = noShow;
                this.propertyPhoneNumber = propertyPhoneNumber;
                this.roomNights = roomNights;
                this.totalRoomTaxAmount = totalRoomTaxAmount;
                this.totalTaxAmount = totalTaxAmount;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Address getAddress() {
                return this.address;
            }

            @Generated
            public Long getAdults() {
                return this.adults;
            }

            @Generated
            public String getBookingNumber() {
                return this.bookingNumber;
            }

            @Generated
            public Category getCategory() {
                return this.category;
            }

            @Generated
            public Long getCheckinAt() {
                return this.checkinAt;
            }

            @Generated
            public Long getCheckoutAt() {
                return this.checkoutAt;
            }

            @Generated
            public String getCustomerServicePhoneNumber() {
                return this.customerServicePhoneNumber;
            }

            @Generated
            public Long getDailyRoomRateAmount() {
                return this.dailyRoomRateAmount;
            }

            @Generated
            public List<ExtraCharge> getExtraCharges() {
                return this.extraCharges;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getFireSafetyActCompliance() {
                return this.fireSafetyActCompliance;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public Boolean getNoShow() {
                return this.noShow;
            }

            @Generated
            public String getPropertyPhoneNumber() {
                return this.propertyPhoneNumber;
            }

            @Generated
            public Long getRoomNights() {
                return this.roomNights;
            }

            @Generated
            public Long getTotalRoomTaxAmount() {
                return this.totalRoomTaxAmount;
            }

            @Generated
            public Long getTotalTaxAmount() {
                return this.totalTaxAmount;
            }

            public static class Address {
                @SerializedName(value="city")
                String city;
                @SerializedName(value="country")
                String country;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="line1")
                String line1;
                @SerializedName(value="line2")
                String line2;
                @SerializedName(value="postal_code")
                String postalCode;
                @SerializedName(value="state")
                String state;

                private Address(String city, String country, Map<String, Object> extraParams, String line1, String line2, String postalCode, String state) {
                    this.city = city;
                    this.country = country;
                    this.extraParams = extraParams;
                    this.line1 = line1;
                    this.line2 = line2;
                    this.postalCode = postalCode;
                    this.state = state;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getCity() {
                    return this.city;
                }

                @Generated
                public String getCountry() {
                    return this.country;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getLine1() {
                    return this.line1;
                }

                @Generated
                public String getLine2() {
                    return this.line2;
                }

                @Generated
                public String getPostalCode() {
                    return this.postalCode;
                }

                @Generated
                public String getState() {
                    return this.state;
                }

                public static class Builder {
                    private String city;
                    private String country;
                    private Map<String, Object> extraParams;
                    private String line1;
                    private String line2;
                    private String postalCode;
                    private String state;

                    public Address build() {
                        return new Address(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                    }

                    public Builder setCity(String city) {
                        this.city = city;
                        return this;
                    }

                    public Builder setCountry(String country) {
                        this.country = country;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setLine1(String line1) {
                        this.line1 = line1;
                        return this;
                    }

                    public Builder setLine2(String line2) {
                        this.line2 = line2;
                        return this;
                    }

                    public Builder setPostalCode(String postalCode) {
                        this.postalCode = postalCode;
                        return this;
                    }

                    public Builder setState(String state) {
                        this.state = state;
                        return this;
                    }
                }
            }

            public static enum Category implements ApiRequestParams.EnumParam
            {
                HOTEL("hotel"),
                VACATION_RENTAL("vacation_rental");

                private final String value;

                private Category(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Address address;
                private Long adults;
                private String bookingNumber;
                private Category category;
                private Long checkinAt;
                private Long checkoutAt;
                private String customerServicePhoneNumber;
                private Long dailyRoomRateAmount;
                private List<ExtraCharge> extraCharges;
                private Map<String, Object> extraParams;
                private Boolean fireSafetyActCompliance;
                private String name;
                private Boolean noShow;
                private String propertyPhoneNumber;
                private Long roomNights;
                private Long totalRoomTaxAmount;
                private Long totalTaxAmount;

                public Lodging build() {
                    return new Lodging(this.address, this.adults, this.bookingNumber, this.category, this.checkinAt, this.checkoutAt, this.customerServicePhoneNumber, this.dailyRoomRateAmount, this.extraCharges, this.extraParams, this.fireSafetyActCompliance, this.name, this.noShow, this.propertyPhoneNumber, this.roomNights, this.totalRoomTaxAmount, this.totalTaxAmount);
                }

                public Builder setAddress(Address address) {
                    this.address = address;
                    return this;
                }

                public Builder setAdults(Long adults) {
                    this.adults = adults;
                    return this;
                }

                public Builder setBookingNumber(String bookingNumber) {
                    this.bookingNumber = bookingNumber;
                    return this;
                }

                public Builder setCategory(Category category) {
                    this.category = category;
                    return this;
                }

                public Builder setCheckinAt(Long checkinAt) {
                    this.checkinAt = checkinAt;
                    return this;
                }

                public Builder setCheckoutAt(Long checkoutAt) {
                    this.checkoutAt = checkoutAt;
                    return this;
                }

                public Builder setCustomerServicePhoneNumber(String customerServicePhoneNumber) {
                    this.customerServicePhoneNumber = customerServicePhoneNumber;
                    return this;
                }

                public Builder setDailyRoomRateAmount(Long dailyRoomRateAmount) {
                    this.dailyRoomRateAmount = dailyRoomRateAmount;
                    return this;
                }

                public Builder addExtraCharge(ExtraCharge element) {
                    if (this.extraCharges == null) {
                        this.extraCharges = new ArrayList<ExtraCharge>();
                    }
                    this.extraCharges.add(element);
                    return this;
                }

                public Builder addAllExtraCharge(List<ExtraCharge> elements) {
                    if (this.extraCharges == null) {
                        this.extraCharges = new ArrayList<ExtraCharge>();
                    }
                    this.extraCharges.addAll(elements);
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setFireSafetyActCompliance(Boolean fireSafetyActCompliance) {
                    this.fireSafetyActCompliance = fireSafetyActCompliance;
                    return this;
                }

                public Builder setName(String name) {
                    this.name = name;
                    return this;
                }

                public Builder setNoShow(Boolean noShow) {
                    this.noShow = noShow;
                    return this;
                }

                public Builder setPropertyPhoneNumber(String propertyPhoneNumber) {
                    this.propertyPhoneNumber = propertyPhoneNumber;
                    return this;
                }

                public Builder setRoomNights(Long roomNights) {
                    this.roomNights = roomNights;
                    return this;
                }

                public Builder setTotalRoomTaxAmount(Long totalRoomTaxAmount) {
                    this.totalRoomTaxAmount = totalRoomTaxAmount;
                    return this;
                }

                public Builder setTotalTaxAmount(Long totalTaxAmount) {
                    this.totalTaxAmount = totalTaxAmount;
                    return this;
                }
            }

            public static enum ExtraCharge implements ApiRequestParams.EnumParam
            {
                GIFT_SHOP("gift_shop"),
                LAUNDRY("laundry"),
                MINI_BAR("mini_bar"),
                OTHER("other"),
                RESTAURANT("restaurant"),
                TELEPHONE("telephone");

                private final String value;

                private ExtraCharge(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class Builder {
            private CarRental carRental;
            private Map<String, Object> extraParams;
            private Flight flight;
            private Lodging lodging;

            public PaymentDetails build() {
                return new PaymentDetails(this.carRental, this.extraParams, this.flight, this.lodging);
            }

            public Builder setCarRental(CarRental carRental) {
                this.carRental = carRental;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setFlight(Flight flight) {
                this.flight = flight;
                return this;
            }

            public Builder setLodging(Lodging lodging) {
                this.lodging = lodging;
                return this;
            }
        }
    }
}

