/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.InvoiceLineItem;
import com.stripe.model.Quote;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.QuoteAcceptParams;
import com.stripe.param.QuoteCancelParams;
import com.stripe.param.QuoteCreateParams;
import com.stripe.param.QuoteFinalizeQuoteParams;
import com.stripe.param.QuoteListParams;
import com.stripe.param.QuoteListPreviewInvoiceLinesParams;
import com.stripe.param.QuoteMarkDraftParams;
import com.stripe.param.QuoteMarkStaleParams;
import com.stripe.param.QuotePdfParams;
import com.stripe.param.QuoteReestimateParams;
import com.stripe.param.QuoteRetrieveParams;
import com.stripe.param.QuoteUpdateParams;
import com.stripe.service.QuoteComputedUpfrontLineItemsService;
import com.stripe.service.QuoteLineItemService;
import com.stripe.service.QuoteLineService;
import com.stripe.service.QuotePreviewInvoiceService;
import com.stripe.service.QuotePreviewSubscriptionScheduleService;
import java.io.InputStream;
import java.lang.reflect.Type;

public final class QuoteService
extends ApiService {
    public QuoteService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public Quote retrieve(String quote, QuoteRetrieveParams params) throws StripeException {
        return this.retrieve(quote, params, null);
    }

    public Quote retrieve(String quote, RequestOptions options) throws StripeException {
        return this.retrieve(quote, null, options);
    }

    public Quote retrieve(String quote) throws StripeException {
        return this.retrieve(quote, null, null);
    }

    public Quote retrieve(String quote, QuoteRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/quotes/%s", ApiResource.urlEncodeId(quote));
        return (Quote)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Quote.class), options, ApiMode.V1);
    }

    public Quote update(String quote, QuoteUpdateParams params) throws StripeException {
        return this.update(quote, params, null);
    }

    public Quote update(String quote, RequestOptions options) throws StripeException {
        return this.update(quote, null, options);
    }

    public Quote update(String quote) throws StripeException {
        return this.update(quote, null, null);
    }

    public Quote update(String quote, QuoteUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/quotes/%s", ApiResource.urlEncodeId(quote));
        return (Quote)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Quote.class), options, ApiMode.V1);
    }

    public Quote create(QuoteCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Quote create(RequestOptions options) throws StripeException {
        return this.create(null, options);
    }

    public Quote create() throws StripeException {
        return this.create(null, null);
    }

    public Quote create(QuoteCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/quotes";
        return (Quote)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Quote.class), options, ApiMode.V1);
    }

    public StripeCollection<Quote> list(QuoteListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Quote> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Quote> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Quote> list(QuoteListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/quotes";
        return (StripeCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), new TypeToken<StripeCollection<Quote>>(){}.getType(), options, ApiMode.V1);
    }

    public Quote cancel(String quote, QuoteCancelParams params) throws StripeException {
        return this.cancel(quote, params, null);
    }

    public Quote cancel(String quote, RequestOptions options) throws StripeException {
        return this.cancel(quote, null, options);
    }

    public Quote cancel(String quote) throws StripeException {
        return this.cancel(quote, null, null);
    }

    public Quote cancel(String quote, QuoteCancelParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/quotes/%s/cancel", ApiResource.urlEncodeId(quote));
        return (Quote)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Quote.class), options, ApiMode.V1);
    }

    public Quote finalizeQuote(String quote, QuoteFinalizeQuoteParams params) throws StripeException {
        return this.finalizeQuote(quote, params, null);
    }

    public Quote finalizeQuote(String quote, RequestOptions options) throws StripeException {
        return this.finalizeQuote(quote, null, options);
    }

    public Quote finalizeQuote(String quote) throws StripeException {
        return this.finalizeQuote(quote, null, null);
    }

    public Quote finalizeQuote(String quote, QuoteFinalizeQuoteParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/quotes/%s/finalize", ApiResource.urlEncodeId(quote));
        return (Quote)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Quote.class), options, ApiMode.V1);
    }

    public Quote accept(String quote, QuoteAcceptParams params) throws StripeException {
        return this.accept(quote, params, null);
    }

    public Quote accept(String quote, RequestOptions options) throws StripeException {
        return this.accept(quote, null, options);
    }

    public Quote accept(String quote) throws StripeException {
        return this.accept(quote, null, null);
    }

    public Quote accept(String quote, QuoteAcceptParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/quotes/%s/accept", ApiResource.urlEncodeId(quote));
        return (Quote)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Quote.class), options, ApiMode.V1);
    }

    public Quote reestimate(String quote, QuoteReestimateParams params) throws StripeException {
        return this.reestimate(quote, params, null);
    }

    public Quote reestimate(String quote, RequestOptions options) throws StripeException {
        return this.reestimate(quote, null, options);
    }

    public Quote reestimate(String quote) throws StripeException {
        return this.reestimate(quote, null, null);
    }

    public Quote reestimate(String quote, QuoteReestimateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/quotes/%s/reestimate", ApiResource.urlEncodeId(quote));
        return (Quote)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Quote.class), options, ApiMode.V1);
    }

    public Quote markDraft(String quote, QuoteMarkDraftParams params) throws StripeException {
        return this.markDraft(quote, params, null);
    }

    public Quote markDraft(String quote, RequestOptions options) throws StripeException {
        return this.markDraft(quote, null, options);
    }

    public Quote markDraft(String quote) throws StripeException {
        return this.markDraft(quote, null, null);
    }

    public Quote markDraft(String quote, QuoteMarkDraftParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/quotes/%s/mark_draft", ApiResource.urlEncodeId(quote));
        return (Quote)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Quote.class), options, ApiMode.V1);
    }

    public Quote markStale(String quote, QuoteMarkStaleParams params) throws StripeException {
        return this.markStale(quote, params, null);
    }

    public Quote markStale(String quote, RequestOptions options) throws StripeException {
        return this.markStale(quote, null, options);
    }

    public Quote markStale(String quote) throws StripeException {
        return this.markStale(quote, null, null);
    }

    public Quote markStale(String quote, QuoteMarkStaleParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/quotes/%s/mark_stale", ApiResource.urlEncodeId(quote));
        return (Quote)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Quote.class), options, ApiMode.V1);
    }

    public InputStream pdf(String quote, QuotePdfParams params) throws StripeException {
        return this.pdf(quote, params, null);
    }

    public InputStream pdf(String quote, RequestOptions options) throws StripeException {
        return this.pdf(quote, null, options);
    }

    public InputStream pdf(String quote) throws StripeException {
        return this.pdf(quote, null, null);
    }

    public InputStream pdf(String quote, QuotePdfParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/quotes/%s/pdf", ApiResource.urlEncodeId(quote));
        return this.getResponseGetter().requestStream(BaseAddress.FILES, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
    }

    public StripeCollection<InvoiceLineItem> listPreviewInvoiceLines(String quote, String previewInvoice, QuoteListPreviewInvoiceLinesParams params) throws StripeException {
        return this.listPreviewInvoiceLines(quote, previewInvoice, params, null);
    }

    public StripeCollection<InvoiceLineItem> listPreviewInvoiceLines(String quote, String previewInvoice, RequestOptions options) throws StripeException {
        return this.listPreviewInvoiceLines(quote, previewInvoice, null, options);
    }

    public StripeCollection<InvoiceLineItem> listPreviewInvoiceLines(String quote, String previewInvoice) throws StripeException {
        return this.listPreviewInvoiceLines(quote, previewInvoice, null, null);
    }

    public StripeCollection<InvoiceLineItem> listPreviewInvoiceLines(String quote, String previewInvoice, QuoteListPreviewInvoiceLinesParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/quotes/%s/preview_invoices/%s/lines", ApiResource.urlEncodeId(quote), ApiResource.urlEncodeId(previewInvoice));
        return (StripeCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), new TypeToken<StripeCollection<InvoiceLineItem>>(){}.getType(), options, ApiMode.V1);
    }

    public QuoteComputedUpfrontLineItemsService computedUpfrontLineItems() {
        return new QuoteComputedUpfrontLineItemsService(this.getResponseGetter());
    }

    public QuoteLineItemService lineItems() {
        return new QuoteLineItemService(this.getResponseGetter());
    }

    public QuoteLineService lines() {
        return new QuoteLineService(this.getResponseGetter());
    }

    public QuotePreviewInvoiceService previewInvoices() {
        return new QuotePreviewInvoiceService(this.getResponseGetter());
    }

    public QuotePreviewSubscriptionScheduleService previewSubscriptionSchedules() {
        return new QuotePreviewSubscriptionScheduleService(this.getResponseGetter());
    }
}

