/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.issuing;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.issuing.CardDesign;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.issuing.CardDesignListParams;
import com.stripe.param.issuing.CardDesignRetrieveParams;
import com.stripe.param.issuing.CardDesignUpdateParams;
import java.lang.reflect.Type;

public final class CardDesignService
extends ApiService {
    public CardDesignService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<CardDesign> list(CardDesignListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<CardDesign> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<CardDesign> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<CardDesign> list(CardDesignListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/card_designs";
        return (StripeCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), new TypeToken<StripeCollection<CardDesign>>(){}.getType(), options, ApiMode.V1);
    }

    public CardDesign retrieve(String cardDesign, CardDesignRetrieveParams params) throws StripeException {
        return this.retrieve(cardDesign, params, null);
    }

    public CardDesign retrieve(String cardDesign, RequestOptions options) throws StripeException {
        return this.retrieve(cardDesign, null, options);
    }

    public CardDesign retrieve(String cardDesign) throws StripeException {
        return this.retrieve(cardDesign, null, null);
    }

    public CardDesign retrieve(String cardDesign, CardDesignRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/card_designs/%s", ApiResource.urlEncodeId(cardDesign));
        return (CardDesign)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)CardDesign.class), options, ApiMode.V1);
    }

    public CardDesign update(String cardDesign, CardDesignUpdateParams params) throws StripeException {
        return this.update(cardDesign, params, null);
    }

    public CardDesign update(String cardDesign, RequestOptions options) throws StripeException {
        return this.update(cardDesign, null, options);
    }

    public CardDesign update(String cardDesign) throws StripeException {
        return this.update(cardDesign, null, null);
    }

    public CardDesign update(String cardDesign, CardDesignUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/card_designs/%s", ApiResource.urlEncodeId(cardDesign));
        return (CardDesign)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)CardDesign.class), options, ApiMode.V1);
    }
}

