/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.testhelpers.issuing;

import com.stripe.exception.StripeException;
import com.stripe.model.issuing.CardDesign;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.issuing.CardDesignActivateTestmodeParams;
import com.stripe.param.issuing.CardDesignDeactivateTestmodeParams;
import java.lang.reflect.Type;

public final class CardDesignService
extends ApiService {
    public CardDesignService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public CardDesign activateTestmode(String cardDesign, CardDesignActivateTestmodeParams params) throws StripeException {
        return this.activateTestmode(cardDesign, params, null);
    }

    public CardDesign activateTestmode(String cardDesign, RequestOptions options) throws StripeException {
        return this.activateTestmode(cardDesign, null, options);
    }

    public CardDesign activateTestmode(String cardDesign) throws StripeException {
        return this.activateTestmode(cardDesign, null, null);
    }

    public CardDesign activateTestmode(String cardDesign, CardDesignActivateTestmodeParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/test_helpers/issuing/card_designs/%s/status/activate", ApiResource.urlEncodeId(cardDesign));
        return (CardDesign)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)CardDesign.class), options, ApiMode.V1);
    }

    public CardDesign deactivateTestmode(String cardDesign, CardDesignDeactivateTestmodeParams params) throws StripeException {
        return this.deactivateTestmode(cardDesign, params, null);
    }

    public CardDesign deactivateTestmode(String cardDesign, RequestOptions options) throws StripeException {
        return this.deactivateTestmode(cardDesign, null, options);
    }

    public CardDesign deactivateTestmode(String cardDesign) throws StripeException {
        return this.deactivateTestmode(cardDesign, null, null);
    }

    public CardDesign deactivateTestmode(String cardDesign, CardDesignDeactivateTestmodeParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/test_helpers/issuing/card_designs/%s/status/deactivate", ApiResource.urlEncodeId(cardDesign));
        return (CardDesign)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)CardDesign.class), options, ApiMode.V1);
    }
}

