/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.issuing;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.issuing.CardBundleCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.issuing.CardBundleListParams;
import com.stripe.param.issuing.CardBundleRetrieveParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class CardBundle
extends ApiResource
implements HasId {
    @SerializedName(value="features")
    Features features;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="name")
    String name;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="type")
    String type;

    public static CardBundleCollection list(Map<String, Object> params) throws StripeException {
        return CardBundle.list(params, (RequestOptions)null);
    }

    public static CardBundleCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/card_bundles";
        return (CardBundleCollection)CardBundle.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)CardBundleCollection.class), options, ApiMode.V1);
    }

    public static CardBundleCollection list(CardBundleListParams params) throws StripeException {
        return CardBundle.list(params, (RequestOptions)null);
    }

    public static CardBundleCollection list(CardBundleListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/card_bundles";
        ApiResource.checkNullTypedParams(path, params);
        return (CardBundleCollection)CardBundle.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)CardBundleCollection.class), options, ApiMode.V1);
    }

    public static CardBundle retrieve(String cardBundle) throws StripeException {
        return CardBundle.retrieve(cardBundle, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static CardBundle retrieve(String cardBundle, RequestOptions options) throws StripeException {
        return CardBundle.retrieve(cardBundle, (Map<String, Object>)null, options);
    }

    public static CardBundle retrieve(String cardBundle, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/card_bundles/%s", ApiResource.urlEncodeId(cardBundle));
        return (CardBundle)CardBundle.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)CardBundle.class), options, ApiMode.V1);
    }

    public static CardBundle retrieve(String cardBundle, CardBundleRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/card_bundles/%s", ApiResource.urlEncodeId(cardBundle));
        ApiResource.checkNullTypedParams(path, params);
        return (CardBundle)CardBundle.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)CardBundle.class), options, ApiMode.V1);
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.features, responseGetter);
    }

    @Generated
    public Features getFeatures() {
        return this.features;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setFeatures(Features features) {
        this.features = features;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CardBundle)) {
            return false;
        }
        CardBundle other = (CardBundle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Features this$features = this.getFeatures();
        Features other$features = other.getFeatures();
        if (this$features == null ? other$features != null : !((Object)this$features).equals(other$features)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CardBundle;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Features $features = this.getFeatures();
        result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class Features
    extends StripeObject {
        @SerializedName(value="card_logo")
        String cardLogo;
        @SerializedName(value="carrier_text")
        String carrierText;

        @Generated
        public String getCardLogo() {
            return this.cardLogo;
        }

        @Generated
        public String getCarrierText() {
            return this.carrierText;
        }

        @Generated
        public void setCardLogo(String cardLogo) {
            this.cardLogo = cardLogo;
        }

        @Generated
        public void setCarrierText(String carrierText) {
            this.carrierText = carrierText;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Features)) {
                return false;
            }
            Features other = (Features)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$cardLogo = this.getCardLogo();
            String other$cardLogo = other.getCardLogo();
            if (this$cardLogo == null ? other$cardLogo != null : !this$cardLogo.equals(other$cardLogo)) {
                return false;
            }
            String this$carrierText = this.getCarrierText();
            String other$carrierText = other.getCarrierText();
            return !(this$carrierText == null ? other$carrierText != null : !this$carrierText.equals(other$carrierText));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Features;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $cardLogo = this.getCardLogo();
            result = result * 59 + ($cardLogo == null ? 43 : $cardLogo.hashCode());
            String $carrierText = this.getCarrierText();
            result = result * 59 + ($carrierText == null ? 43 : $carrierText.hashCode());
            return result;
        }
    }
}

