/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.issuing;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.File;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.model.issuing.CardBundle;
import com.stripe.model.issuing.CardDesignCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.issuing.CardDesignActivateTestmodeParams;
import com.stripe.param.issuing.CardDesignCreateParams;
import com.stripe.param.issuing.CardDesignDeactivateTestmodeParams;
import com.stripe.param.issuing.CardDesignListParams;
import com.stripe.param.issuing.CardDesignRejectTestmodeParams;
import com.stripe.param.issuing.CardDesignRetrieveParams;
import com.stripe.param.issuing.CardDesignUpdateParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class CardDesign
extends ApiResource
implements HasId,
MetadataStore<CardDesign> {
    @SerializedName(value="card_bundle")
    ExpandableField<CardBundle> cardBundle;
    @SerializedName(value="card_logo")
    ExpandableField<File> cardLogo;
    @SerializedName(value="carrier_text")
    CarrierText carrierText;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="lookup_key")
    String lookupKey;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="name")
    String name;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="preferences")
    Preferences preferences;
    @SerializedName(value="rejection_reasons")
    RejectionReasons rejectionReasons;
    @SerializedName(value="status")
    String status;

    public String getCardBundle() {
        return this.cardBundle != null ? this.cardBundle.getId() : null;
    }

    public void setCardBundle(String id) {
        this.cardBundle = ApiResource.setExpandableFieldId(id, this.cardBundle);
    }

    public CardBundle getCardBundleObject() {
        return this.cardBundle != null ? this.cardBundle.getExpanded() : null;
    }

    public void setCardBundleObject(CardBundle expandableObject) {
        this.cardBundle = new ExpandableField<CardBundle>(expandableObject.getId(), expandableObject);
    }

    public String getCardLogo() {
        return this.cardLogo != null ? this.cardLogo.getId() : null;
    }

    public void setCardLogo(String id) {
        this.cardLogo = ApiResource.setExpandableFieldId(id, this.cardLogo);
    }

    public File getCardLogoObject() {
        return this.cardLogo != null ? this.cardLogo.getExpanded() : null;
    }

    public void setCardLogoObject(File expandableObject) {
        this.cardLogo = new ExpandableField<File>(expandableObject.getId(), expandableObject);
    }

    public static CardDesign create(Map<String, Object> params) throws StripeException {
        return CardDesign.create(params, (RequestOptions)null);
    }

    public static CardDesign create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/card_designs";
        return (CardDesign)CardDesign.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)CardDesign.class), options, ApiMode.V1);
    }

    public static CardDesign create(CardDesignCreateParams params) throws StripeException {
        return CardDesign.create(params, (RequestOptions)null);
    }

    public static CardDesign create(CardDesignCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/card_designs";
        ApiResource.checkNullTypedParams(path, params);
        return (CardDesign)CardDesign.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)CardDesign.class), options, ApiMode.V1);
    }

    public static CardDesignCollection list(Map<String, Object> params) throws StripeException {
        return CardDesign.list(params, (RequestOptions)null);
    }

    public static CardDesignCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/card_designs";
        return (CardDesignCollection)CardDesign.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)CardDesignCollection.class), options, ApiMode.V1);
    }

    public static CardDesignCollection list(CardDesignListParams params) throws StripeException {
        return CardDesign.list(params, (RequestOptions)null);
    }

    public static CardDesignCollection list(CardDesignListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/card_designs";
        ApiResource.checkNullTypedParams(path, params);
        return (CardDesignCollection)CardDesign.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)CardDesignCollection.class), options, ApiMode.V1);
    }

    public static CardDesign retrieve(String cardDesign) throws StripeException {
        return CardDesign.retrieve(cardDesign, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static CardDesign retrieve(String cardDesign, RequestOptions options) throws StripeException {
        return CardDesign.retrieve(cardDesign, (Map<String, Object>)null, options);
    }

    public static CardDesign retrieve(String cardDesign, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/card_designs/%s", ApiResource.urlEncodeId(cardDesign));
        return (CardDesign)CardDesign.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)CardDesign.class), options, ApiMode.V1);
    }

    public static CardDesign retrieve(String cardDesign, CardDesignRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/card_designs/%s", ApiResource.urlEncodeId(cardDesign));
        ApiResource.checkNullTypedParams(path, params);
        return (CardDesign)CardDesign.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)CardDesign.class), options, ApiMode.V1);
    }

    public CardDesign update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public CardDesign update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/card_designs/%s", ApiResource.urlEncodeId(this.getId()));
        return (CardDesign)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)CardDesign.class), options, ApiMode.V1);
    }

    public CardDesign update(CardDesignUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public CardDesign update(CardDesignUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/card_designs/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        return (CardDesign)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)CardDesign.class), options, ApiMode.V1);
    }

    public TestHelpers getTestHelpers() {
        return new TestHelpers(this);
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.cardBundle, responseGetter);
        this.trySetResponseGetter(this.cardLogo, responseGetter);
        this.trySetResponseGetter(this.carrierText, responseGetter);
        this.trySetResponseGetter(this.preferences, responseGetter);
        this.trySetResponseGetter(this.rejectionReasons, responseGetter);
    }

    @Generated
    public CarrierText getCarrierText() {
        return this.carrierText;
    }

    @Generated
    public String getLookupKey() {
        return this.lookupKey;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Preferences getPreferences() {
        return this.preferences;
    }

    @Generated
    public RejectionReasons getRejectionReasons() {
        return this.rejectionReasons;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public void setCarrierText(CarrierText carrierText) {
        this.carrierText = carrierText;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLookupKey(String lookupKey) {
        this.lookupKey = lookupKey;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Generated
    public void setRejectionReasons(RejectionReasons rejectionReasons) {
        this.rejectionReasons = rejectionReasons;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CardDesign)) {
            return false;
        }
        CardDesign other = (CardDesign)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$cardBundle = this.getCardBundle();
        String other$cardBundle = other.getCardBundle();
        if (this$cardBundle == null ? other$cardBundle != null : !this$cardBundle.equals(other$cardBundle)) {
            return false;
        }
        String this$cardLogo = this.getCardLogo();
        String other$cardLogo = other.getCardLogo();
        if (this$cardLogo == null ? other$cardLogo != null : !this$cardLogo.equals(other$cardLogo)) {
            return false;
        }
        CarrierText this$carrierText = this.getCarrierText();
        CarrierText other$carrierText = other.getCarrierText();
        if (this$carrierText == null ? other$carrierText != null : !((Object)this$carrierText).equals(other$carrierText)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$lookupKey = this.getLookupKey();
        String other$lookupKey = other.getLookupKey();
        if (this$lookupKey == null ? other$lookupKey != null : !this$lookupKey.equals(other$lookupKey)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Preferences this$preferences = this.getPreferences();
        Preferences other$preferences = other.getPreferences();
        if (this$preferences == null ? other$preferences != null : !((Object)this$preferences).equals(other$preferences)) {
            return false;
        }
        RejectionReasons this$rejectionReasons = this.getRejectionReasons();
        RejectionReasons other$rejectionReasons = other.getRejectionReasons();
        if (this$rejectionReasons == null ? other$rejectionReasons != null : !((Object)this$rejectionReasons).equals(other$rejectionReasons)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !this$status.equals(other$status));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CardDesign;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $cardBundle = this.getCardBundle();
        result = result * 59 + ($cardBundle == null ? 43 : $cardBundle.hashCode());
        String $cardLogo = this.getCardLogo();
        result = result * 59 + ($cardLogo == null ? 43 : $cardLogo.hashCode());
        CarrierText $carrierText = this.getCarrierText();
        result = result * 59 + ($carrierText == null ? 43 : ((Object)$carrierText).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $lookupKey = this.getLookupKey();
        result = result * 59 + ($lookupKey == null ? 43 : $lookupKey.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Preferences $preferences = this.getPreferences();
        result = result * 59 + ($preferences == null ? 43 : ((Object)$preferences).hashCode());
        RejectionReasons $rejectionReasons = this.getRejectionReasons();
        result = result * 59 + ($rejectionReasons == null ? 43 : ((Object)$rejectionReasons).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class TestHelpers {
        private final CardDesign resource;

        private TestHelpers(CardDesign resource) {
            this.resource = resource;
        }

        public CardDesign activateTestmode() throws StripeException {
            return this.activateTestmode((Map<String, Object>)null, (RequestOptions)null);
        }

        public CardDesign activateTestmode(RequestOptions options) throws StripeException {
            return this.activateTestmode((Map<String, Object>)null, options);
        }

        public CardDesign activateTestmode(Map<String, Object> params) throws StripeException {
            return this.activateTestmode(params, (RequestOptions)null);
        }

        public CardDesign activateTestmode(Map<String, Object> params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/issuing/card_designs/%s/status/activate", ApiResource.urlEncodeId(this.resource.getId()));
            return (CardDesign)this.resource.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)CardDesign.class), options, ApiMode.V1);
        }

        public CardDesign activateTestmode(CardDesignActivateTestmodeParams params) throws StripeException {
            return this.activateTestmode(params, (RequestOptions)null);
        }

        public CardDesign activateTestmode(CardDesignActivateTestmodeParams params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/issuing/card_designs/%s/status/activate", ApiResource.urlEncodeId(this.resource.getId()));
            ApiResource.checkNullTypedParams(path, params);
            return (CardDesign)this.resource.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)CardDesign.class), options, ApiMode.V1);
        }

        public CardDesign deactivateTestmode() throws StripeException {
            return this.deactivateTestmode((Map<String, Object>)null, (RequestOptions)null);
        }

        public CardDesign deactivateTestmode(RequestOptions options) throws StripeException {
            return this.deactivateTestmode((Map<String, Object>)null, options);
        }

        public CardDesign deactivateTestmode(Map<String, Object> params) throws StripeException {
            return this.deactivateTestmode(params, (RequestOptions)null);
        }

        public CardDesign deactivateTestmode(Map<String, Object> params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/issuing/card_designs/%s/status/deactivate", ApiResource.urlEncodeId(this.resource.getId()));
            return (CardDesign)this.resource.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)CardDesign.class), options, ApiMode.V1);
        }

        public CardDesign deactivateTestmode(CardDesignDeactivateTestmodeParams params) throws StripeException {
            return this.deactivateTestmode(params, (RequestOptions)null);
        }

        public CardDesign deactivateTestmode(CardDesignDeactivateTestmodeParams params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/issuing/card_designs/%s/status/deactivate", ApiResource.urlEncodeId(this.resource.getId()));
            ApiResource.checkNullTypedParams(path, params);
            return (CardDesign)this.resource.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)CardDesign.class), options, ApiMode.V1);
        }

        public CardDesign rejectTestmode(Map<String, Object> params) throws StripeException {
            return this.rejectTestmode(params, (RequestOptions)null);
        }

        public CardDesign rejectTestmode(Map<String, Object> params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/issuing/card_designs/%s/status/reject", ApiResource.urlEncodeId(this.resource.getId()));
            return (CardDesign)this.resource.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)CardDesign.class), options, ApiMode.V1);
        }

        public CardDesign rejectTestmode(CardDesignRejectTestmodeParams params) throws StripeException {
            return this.rejectTestmode(params, (RequestOptions)null);
        }

        public CardDesign rejectTestmode(CardDesignRejectTestmodeParams params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/issuing/card_designs/%s/status/reject", ApiResource.urlEncodeId(this.resource.getId()));
            ApiResource.checkNullTypedParams(path, params);
            return (CardDesign)this.resource.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)CardDesign.class), options, ApiMode.V1);
        }
    }

    public static class CarrierText
    extends StripeObject {
        @SerializedName(value="footer_body")
        String footerBody;
        @SerializedName(value="footer_title")
        String footerTitle;
        @SerializedName(value="header_body")
        String headerBody;
        @SerializedName(value="header_title")
        String headerTitle;

        @Generated
        public String getFooterBody() {
            return this.footerBody;
        }

        @Generated
        public String getFooterTitle() {
            return this.footerTitle;
        }

        @Generated
        public String getHeaderBody() {
            return this.headerBody;
        }

        @Generated
        public String getHeaderTitle() {
            return this.headerTitle;
        }

        @Generated
        public void setFooterBody(String footerBody) {
            this.footerBody = footerBody;
        }

        @Generated
        public void setFooterTitle(String footerTitle) {
            this.footerTitle = footerTitle;
        }

        @Generated
        public void setHeaderBody(String headerBody) {
            this.headerBody = headerBody;
        }

        @Generated
        public void setHeaderTitle(String headerTitle) {
            this.headerTitle = headerTitle;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CarrierText)) {
                return false;
            }
            CarrierText other = (CarrierText)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$footerBody = this.getFooterBody();
            String other$footerBody = other.getFooterBody();
            if (this$footerBody == null ? other$footerBody != null : !this$footerBody.equals(other$footerBody)) {
                return false;
            }
            String this$footerTitle = this.getFooterTitle();
            String other$footerTitle = other.getFooterTitle();
            if (this$footerTitle == null ? other$footerTitle != null : !this$footerTitle.equals(other$footerTitle)) {
                return false;
            }
            String this$headerBody = this.getHeaderBody();
            String other$headerBody = other.getHeaderBody();
            if (this$headerBody == null ? other$headerBody != null : !this$headerBody.equals(other$headerBody)) {
                return false;
            }
            String this$headerTitle = this.getHeaderTitle();
            String other$headerTitle = other.getHeaderTitle();
            return !(this$headerTitle == null ? other$headerTitle != null : !this$headerTitle.equals(other$headerTitle));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CarrierText;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $footerBody = this.getFooterBody();
            result = result * 59 + ($footerBody == null ? 43 : $footerBody.hashCode());
            String $footerTitle = this.getFooterTitle();
            result = result * 59 + ($footerTitle == null ? 43 : $footerTitle.hashCode());
            String $headerBody = this.getHeaderBody();
            result = result * 59 + ($headerBody == null ? 43 : $headerBody.hashCode());
            String $headerTitle = this.getHeaderTitle();
            result = result * 59 + ($headerTitle == null ? 43 : $headerTitle.hashCode());
            return result;
        }
    }

    public static class Preferences
    extends StripeObject {
        @SerializedName(value="account_default")
        Boolean accountDefault;
        @SerializedName(value="platform_default")
        Boolean platformDefault;

        @Generated
        public Boolean getAccountDefault() {
            return this.accountDefault;
        }

        @Generated
        public Boolean getPlatformDefault() {
            return this.platformDefault;
        }

        @Generated
        public void setAccountDefault(Boolean accountDefault) {
            this.accountDefault = accountDefault;
        }

        @Generated
        public void setPlatformDefault(Boolean platformDefault) {
            this.platformDefault = platformDefault;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Preferences)) {
                return false;
            }
            Preferences other = (Preferences)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$accountDefault = this.getAccountDefault();
            Boolean other$accountDefault = other.getAccountDefault();
            if (this$accountDefault == null ? other$accountDefault != null : !((Object)this$accountDefault).equals(other$accountDefault)) {
                return false;
            }
            Boolean this$platformDefault = this.getPlatformDefault();
            Boolean other$platformDefault = other.getPlatformDefault();
            return !(this$platformDefault == null ? other$platformDefault != null : !((Object)this$platformDefault).equals(other$platformDefault));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Preferences;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $accountDefault = this.getAccountDefault();
            result = result * 59 + ($accountDefault == null ? 43 : ((Object)$accountDefault).hashCode());
            Boolean $platformDefault = this.getPlatformDefault();
            result = result * 59 + ($platformDefault == null ? 43 : ((Object)$platformDefault).hashCode());
            return result;
        }
    }

    public static class RejectionReasons
    extends StripeObject {
        @SerializedName(value="card_logo")
        List<String> cardLogo;
        @SerializedName(value="carrier_text")
        List<String> carrierText;

        @Generated
        public List<String> getCardLogo() {
            return this.cardLogo;
        }

        @Generated
        public List<String> getCarrierText() {
            return this.carrierText;
        }

        @Generated
        public void setCardLogo(List<String> cardLogo) {
            this.cardLogo = cardLogo;
        }

        @Generated
        public void setCarrierText(List<String> carrierText) {
            this.carrierText = carrierText;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RejectionReasons)) {
                return false;
            }
            RejectionReasons other = (RejectionReasons)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$cardLogo = this.getCardLogo();
            List<String> other$cardLogo = other.getCardLogo();
            if (this$cardLogo == null ? other$cardLogo != null : !((Object)this$cardLogo).equals(other$cardLogo)) {
                return false;
            }
            List<String> this$carrierText = this.getCarrierText();
            List<String> other$carrierText = other.getCarrierText();
            return !(this$carrierText == null ? other$carrierText != null : !((Object)this$carrierText).equals(other$carrierText));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RejectionReasons;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $cardLogo = this.getCardLogo();
            result = result * 59 + ($cardLogo == null ? 43 : ((Object)$cardLogo).hashCode());
            List<String> $carrierText = this.getCarrierText();
            result = result * 59 + ($carrierText == null ? 43 : ((Object)$carrierText).hashCode());
            return result;
        }
    }
}

