/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.issuing;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.issuing.CardBundle;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.issuing.CardBundleListParams;
import com.stripe.param.issuing.CardBundleRetrieveParams;
import java.lang.reflect.Type;

public final class CardBundleService
extends ApiService {
    public CardBundleService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<CardBundle> list(CardBundleListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<CardBundle> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<CardBundle> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<CardBundle> list(CardBundleListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/card_bundles";
        return (StripeCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), new TypeToken<StripeCollection<CardBundle>>(){}.getType(), options, ApiMode.V1);
    }

    public CardBundle retrieve(String cardBundle, CardBundleRetrieveParams params) throws StripeException {
        return this.retrieve(cardBundle, params, null);
    }

    public CardBundle retrieve(String cardBundle, RequestOptions options) throws StripeException {
        return this.retrieve(cardBundle, null, options);
    }

    public CardBundle retrieve(String cardBundle) throws StripeException {
        return this.retrieve(cardBundle, null, null);
    }

    public CardBundle retrieve(String cardBundle, CardBundleRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/card_bundles/%s", ApiResource.urlEncodeId(cardBundle));
        return (CardBundle)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)CardBundle.class), options, ApiMode.V1);
    }
}

