/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.model.StripeSearchResultInterface;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class SearchPagingIterator<T>
extends ApiResource
implements Iterator<T> {
    private final String url;
    private final Class<? extends StripeSearchResultInterface> collectionType;
    private StripeSearchResultInterface<T> currentSearchResult;
    private Iterator<T> currentDataIterator;
    private String nextPage;

    SearchPagingIterator(StripeSearchResultInterface<T> stripeSearchResult, StripeResponseGetter responseGetter) {
        this.url = stripeSearchResult.getUrl();
        this.nextPage = stripeSearchResult.getNextPage();
        this.collectionType = stripeSearchResult.getClass();
        this.currentSearchResult = stripeSearchResult;
        this.currentDataIterator = stripeSearchResult.getData().iterator();
        this.setResponseGetter(responseGetter);
    }

    @Override
    public boolean hasNext() {
        return this.currentDataIterator.hasNext() || this.currentSearchResult.getHasMore() != false;
    }

    @Override
    public T next() {
        if (!this.currentDataIterator.hasNext() && this.currentSearchResult.getHasMore().booleanValue()) {
            try {
                HashMap<String, Object> params = new HashMap<String, Object>();
                Map<String, Object> initialParams = this.currentSearchResult.getRequestParams();
                if (initialParams != null) {
                    params.putAll(initialParams);
                }
                params.put("page", this.nextPage);
                this.currentSearchResult = this.search(params, this.currentSearchResult.getRequestOptions());
                this.nextPage = this.currentSearchResult.getNextPage();
                this.currentDataIterator = this.currentSearchResult.getData().iterator();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to lazy-load stripe objects", e);
            }
        }
        if (this.currentDataIterator.hasNext()) {
            T next = this.currentDataIterator.next();
            return next;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private StripeSearchResultInterface<T> search(Map<String, Object> params, RequestOptions options) throws Exception {
        return (StripeSearchResultInterface)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, this.url, params, this.collectionType, options, ApiMode.V1);
    }
}

