/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.treasury;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.treasury.DebitReversal;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.treasury.DebitReversalCreateParams;
import com.stripe.param.treasury.DebitReversalListParams;
import com.stripe.param.treasury.DebitReversalRetrieveParams;
import java.lang.reflect.Type;

public final class DebitReversalService
extends ApiService {
    public DebitReversalService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public DebitReversal create(DebitReversalCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public DebitReversal create(DebitReversalCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/treasury/debit_reversals";
        return (DebitReversal)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)DebitReversal.class), options, ApiMode.V1);
    }

    public StripeCollection<DebitReversal> list(DebitReversalListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<DebitReversal> list(DebitReversalListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/treasury/debit_reversals";
        return (StripeCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), new TypeToken<StripeCollection<DebitReversal>>(){}.getType(), options, ApiMode.V1);
    }

    public DebitReversal retrieve(String debitReversal, DebitReversalRetrieveParams params) throws StripeException {
        return this.retrieve(debitReversal, params, null);
    }

    public DebitReversal retrieve(String debitReversal, RequestOptions options) throws StripeException {
        return this.retrieve(debitReversal, null, options);
    }

    public DebitReversal retrieve(String debitReversal) throws StripeException {
        return this.retrieve(debitReversal, null, null);
    }

    public DebitReversal retrieve(String debitReversal, DebitReversalRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/debit_reversals/%s", ApiResource.urlEncodeId(debitReversal));
        return (DebitReversal)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)DebitReversal.class), options, ApiMode.V1);
    }
}

