/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.issuing;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.File;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.model.issuing.PersonalizationDesignCollection;
import com.stripe.model.issuing.PhysicalBundle;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.issuing.PersonalizationDesignActivateParams;
import com.stripe.param.issuing.PersonalizationDesignCreateParams;
import com.stripe.param.issuing.PersonalizationDesignDeactivateParams;
import com.stripe.param.issuing.PersonalizationDesignListParams;
import com.stripe.param.issuing.PersonalizationDesignRejectParams;
import com.stripe.param.issuing.PersonalizationDesignRetrieveParams;
import com.stripe.param.issuing.PersonalizationDesignUpdateParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class PersonalizationDesign
extends ApiResource
implements HasId,
MetadataStore<PersonalizationDesign> {
    @SerializedName(value="card_logo")
    ExpandableField<File> cardLogo;
    @SerializedName(value="carrier_text")
    CarrierText carrierText;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="lookup_key")
    String lookupKey;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="name")
    String name;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="physical_bundle")
    ExpandableField<PhysicalBundle> physicalBundle;
    @SerializedName(value="preferences")
    Preferences preferences;
    @SerializedName(value="rejection_reasons")
    RejectionReasons rejectionReasons;
    @SerializedName(value="status")
    String status;

    public String getCardLogo() {
        return this.cardLogo != null ? this.cardLogo.getId() : null;
    }

    public void setCardLogo(String id) {
        this.cardLogo = ApiResource.setExpandableFieldId(id, this.cardLogo);
    }

    public File getCardLogoObject() {
        return this.cardLogo != null ? this.cardLogo.getExpanded() : null;
    }

    public void setCardLogoObject(File expandableObject) {
        this.cardLogo = new ExpandableField<File>(expandableObject.getId(), expandableObject);
    }

    public String getPhysicalBundle() {
        return this.physicalBundle != null ? this.physicalBundle.getId() : null;
    }

    public void setPhysicalBundle(String id) {
        this.physicalBundle = ApiResource.setExpandableFieldId(id, this.physicalBundle);
    }

    public PhysicalBundle getPhysicalBundleObject() {
        return this.physicalBundle != null ? this.physicalBundle.getExpanded() : null;
    }

    public void setPhysicalBundleObject(PhysicalBundle expandableObject) {
        this.physicalBundle = new ExpandableField<PhysicalBundle>(expandableObject.getId(), expandableObject);
    }

    public static PersonalizationDesign create(Map<String, Object> params) throws StripeException {
        return PersonalizationDesign.create(params, (RequestOptions)null);
    }

    public static PersonalizationDesign create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/personalization_designs";
        return (PersonalizationDesign)PersonalizationDesign.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)PersonalizationDesign.class), options, ApiMode.V1);
    }

    public static PersonalizationDesign create(PersonalizationDesignCreateParams params) throws StripeException {
        return PersonalizationDesign.create(params, (RequestOptions)null);
    }

    public static PersonalizationDesign create(PersonalizationDesignCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/personalization_designs";
        ApiResource.checkNullTypedParams(path, params);
        return (PersonalizationDesign)PersonalizationDesign.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)PersonalizationDesign.class), options, ApiMode.V1);
    }

    public static PersonalizationDesignCollection list(Map<String, Object> params) throws StripeException {
        return PersonalizationDesign.list(params, (RequestOptions)null);
    }

    public static PersonalizationDesignCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/personalization_designs";
        return (PersonalizationDesignCollection)PersonalizationDesign.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)PersonalizationDesignCollection.class), options, ApiMode.V1);
    }

    public static PersonalizationDesignCollection list(PersonalizationDesignListParams params) throws StripeException {
        return PersonalizationDesign.list(params, (RequestOptions)null);
    }

    public static PersonalizationDesignCollection list(PersonalizationDesignListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/personalization_designs";
        ApiResource.checkNullTypedParams(path, params);
        return (PersonalizationDesignCollection)PersonalizationDesign.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)PersonalizationDesignCollection.class), options, ApiMode.V1);
    }

    public static PersonalizationDesign retrieve(String personalizationDesign) throws StripeException {
        return PersonalizationDesign.retrieve(personalizationDesign, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static PersonalizationDesign retrieve(String personalizationDesign, RequestOptions options) throws StripeException {
        return PersonalizationDesign.retrieve(personalizationDesign, (Map<String, Object>)null, options);
    }

    public static PersonalizationDesign retrieve(String personalizationDesign, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/personalization_designs/%s", ApiResource.urlEncodeId(personalizationDesign));
        return (PersonalizationDesign)PersonalizationDesign.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)PersonalizationDesign.class), options, ApiMode.V1);
    }

    public static PersonalizationDesign retrieve(String personalizationDesign, PersonalizationDesignRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/personalization_designs/%s", ApiResource.urlEncodeId(personalizationDesign));
        ApiResource.checkNullTypedParams(path, params);
        return (PersonalizationDesign)PersonalizationDesign.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)PersonalizationDesign.class), options, ApiMode.V1);
    }

    public PersonalizationDesign update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public PersonalizationDesign update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/personalization_designs/%s", ApiResource.urlEncodeId(this.getId()));
        return (PersonalizationDesign)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)PersonalizationDesign.class), options, ApiMode.V1);
    }

    public PersonalizationDesign update(PersonalizationDesignUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public PersonalizationDesign update(PersonalizationDesignUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/personalization_designs/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        return (PersonalizationDesign)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)PersonalizationDesign.class), options, ApiMode.V1);
    }

    public TestHelpers getTestHelpers() {
        return new TestHelpers(this);
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.cardLogo, responseGetter);
        this.trySetResponseGetter(this.carrierText, responseGetter);
        this.trySetResponseGetter(this.physicalBundle, responseGetter);
        this.trySetResponseGetter(this.preferences, responseGetter);
        this.trySetResponseGetter(this.rejectionReasons, responseGetter);
    }

    @Generated
    public CarrierText getCarrierText() {
        return this.carrierText;
    }

    @Generated
    public String getLookupKey() {
        return this.lookupKey;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Preferences getPreferences() {
        return this.preferences;
    }

    @Generated
    public RejectionReasons getRejectionReasons() {
        return this.rejectionReasons;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public void setCarrierText(CarrierText carrierText) {
        this.carrierText = carrierText;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLookupKey(String lookupKey) {
        this.lookupKey = lookupKey;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Generated
    public void setRejectionReasons(RejectionReasons rejectionReasons) {
        this.rejectionReasons = rejectionReasons;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PersonalizationDesign)) {
            return false;
        }
        PersonalizationDesign other = (PersonalizationDesign)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$cardLogo = this.getCardLogo();
        String other$cardLogo = other.getCardLogo();
        if (this$cardLogo == null ? other$cardLogo != null : !this$cardLogo.equals(other$cardLogo)) {
            return false;
        }
        CarrierText this$carrierText = this.getCarrierText();
        CarrierText other$carrierText = other.getCarrierText();
        if (this$carrierText == null ? other$carrierText != null : !((Object)this$carrierText).equals(other$carrierText)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$lookupKey = this.getLookupKey();
        String other$lookupKey = other.getLookupKey();
        if (this$lookupKey == null ? other$lookupKey != null : !this$lookupKey.equals(other$lookupKey)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$physicalBundle = this.getPhysicalBundle();
        String other$physicalBundle = other.getPhysicalBundle();
        if (this$physicalBundle == null ? other$physicalBundle != null : !this$physicalBundle.equals(other$physicalBundle)) {
            return false;
        }
        Preferences this$preferences = this.getPreferences();
        Preferences other$preferences = other.getPreferences();
        if (this$preferences == null ? other$preferences != null : !((Object)this$preferences).equals(other$preferences)) {
            return false;
        }
        RejectionReasons this$rejectionReasons = this.getRejectionReasons();
        RejectionReasons other$rejectionReasons = other.getRejectionReasons();
        if (this$rejectionReasons == null ? other$rejectionReasons != null : !((Object)this$rejectionReasons).equals(other$rejectionReasons)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !this$status.equals(other$status));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PersonalizationDesign;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $cardLogo = this.getCardLogo();
        result = result * 59 + ($cardLogo == null ? 43 : $cardLogo.hashCode());
        CarrierText $carrierText = this.getCarrierText();
        result = result * 59 + ($carrierText == null ? 43 : ((Object)$carrierText).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $lookupKey = this.getLookupKey();
        result = result * 59 + ($lookupKey == null ? 43 : $lookupKey.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $physicalBundle = this.getPhysicalBundle();
        result = result * 59 + ($physicalBundle == null ? 43 : $physicalBundle.hashCode());
        Preferences $preferences = this.getPreferences();
        result = result * 59 + ($preferences == null ? 43 : ((Object)$preferences).hashCode());
        RejectionReasons $rejectionReasons = this.getRejectionReasons();
        result = result * 59 + ($rejectionReasons == null ? 43 : ((Object)$rejectionReasons).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class TestHelpers {
        private final PersonalizationDesign resource;

        private TestHelpers(PersonalizationDesign resource) {
            this.resource = resource;
        }

        public PersonalizationDesign activate() throws StripeException {
            return this.activate((Map<String, Object>)null, (RequestOptions)null);
        }

        public PersonalizationDesign activate(RequestOptions options) throws StripeException {
            return this.activate((Map<String, Object>)null, options);
        }

        public PersonalizationDesign activate(Map<String, Object> params) throws StripeException {
            return this.activate(params, (RequestOptions)null);
        }

        public PersonalizationDesign activate(Map<String, Object> params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/issuing/personalization_designs/%s/activate", ApiResource.urlEncodeId(this.resource.getId()));
            return (PersonalizationDesign)this.resource.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)PersonalizationDesign.class), options, ApiMode.V1);
        }

        public PersonalizationDesign activate(PersonalizationDesignActivateParams params) throws StripeException {
            return this.activate(params, (RequestOptions)null);
        }

        public PersonalizationDesign activate(PersonalizationDesignActivateParams params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/issuing/personalization_designs/%s/activate", ApiResource.urlEncodeId(this.resource.getId()));
            ApiResource.checkNullTypedParams(path, params);
            return (PersonalizationDesign)this.resource.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)PersonalizationDesign.class), options, ApiMode.V1);
        }

        public PersonalizationDesign deactivate() throws StripeException {
            return this.deactivate((Map<String, Object>)null, (RequestOptions)null);
        }

        public PersonalizationDesign deactivate(RequestOptions options) throws StripeException {
            return this.deactivate((Map<String, Object>)null, options);
        }

        public PersonalizationDesign deactivate(Map<String, Object> params) throws StripeException {
            return this.deactivate(params, (RequestOptions)null);
        }

        public PersonalizationDesign deactivate(Map<String, Object> params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/issuing/personalization_designs/%s/deactivate", ApiResource.urlEncodeId(this.resource.getId()));
            return (PersonalizationDesign)this.resource.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)PersonalizationDesign.class), options, ApiMode.V1);
        }

        public PersonalizationDesign deactivate(PersonalizationDesignDeactivateParams params) throws StripeException {
            return this.deactivate(params, (RequestOptions)null);
        }

        public PersonalizationDesign deactivate(PersonalizationDesignDeactivateParams params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/issuing/personalization_designs/%s/deactivate", ApiResource.urlEncodeId(this.resource.getId()));
            ApiResource.checkNullTypedParams(path, params);
            return (PersonalizationDesign)this.resource.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)PersonalizationDesign.class), options, ApiMode.V1);
        }

        public PersonalizationDesign reject(Map<String, Object> params) throws StripeException {
            return this.reject(params, (RequestOptions)null);
        }

        public PersonalizationDesign reject(Map<String, Object> params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/issuing/personalization_designs/%s/reject", ApiResource.urlEncodeId(this.resource.getId()));
            return (PersonalizationDesign)this.resource.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)PersonalizationDesign.class), options, ApiMode.V1);
        }

        public PersonalizationDesign reject(PersonalizationDesignRejectParams params) throws StripeException {
            return this.reject(params, (RequestOptions)null);
        }

        public PersonalizationDesign reject(PersonalizationDesignRejectParams params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/issuing/personalization_designs/%s/reject", ApiResource.urlEncodeId(this.resource.getId()));
            ApiResource.checkNullTypedParams(path, params);
            return (PersonalizationDesign)this.resource.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)PersonalizationDesign.class), options, ApiMode.V1);
        }
    }

    public static class CarrierText
    extends StripeObject {
        @SerializedName(value="footer_body")
        String footerBody;
        @SerializedName(value="footer_title")
        String footerTitle;
        @SerializedName(value="header_body")
        String headerBody;
        @SerializedName(value="header_title")
        String headerTitle;

        @Generated
        public String getFooterBody() {
            return this.footerBody;
        }

        @Generated
        public String getFooterTitle() {
            return this.footerTitle;
        }

        @Generated
        public String getHeaderBody() {
            return this.headerBody;
        }

        @Generated
        public String getHeaderTitle() {
            return this.headerTitle;
        }

        @Generated
        public void setFooterBody(String footerBody) {
            this.footerBody = footerBody;
        }

        @Generated
        public void setFooterTitle(String footerTitle) {
            this.footerTitle = footerTitle;
        }

        @Generated
        public void setHeaderBody(String headerBody) {
            this.headerBody = headerBody;
        }

        @Generated
        public void setHeaderTitle(String headerTitle) {
            this.headerTitle = headerTitle;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CarrierText)) {
                return false;
            }
            CarrierText other = (CarrierText)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$footerBody = this.getFooterBody();
            String other$footerBody = other.getFooterBody();
            if (this$footerBody == null ? other$footerBody != null : !this$footerBody.equals(other$footerBody)) {
                return false;
            }
            String this$footerTitle = this.getFooterTitle();
            String other$footerTitle = other.getFooterTitle();
            if (this$footerTitle == null ? other$footerTitle != null : !this$footerTitle.equals(other$footerTitle)) {
                return false;
            }
            String this$headerBody = this.getHeaderBody();
            String other$headerBody = other.getHeaderBody();
            if (this$headerBody == null ? other$headerBody != null : !this$headerBody.equals(other$headerBody)) {
                return false;
            }
            String this$headerTitle = this.getHeaderTitle();
            String other$headerTitle = other.getHeaderTitle();
            return !(this$headerTitle == null ? other$headerTitle != null : !this$headerTitle.equals(other$headerTitle));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CarrierText;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $footerBody = this.getFooterBody();
            result = result * 59 + ($footerBody == null ? 43 : $footerBody.hashCode());
            String $footerTitle = this.getFooterTitle();
            result = result * 59 + ($footerTitle == null ? 43 : $footerTitle.hashCode());
            String $headerBody = this.getHeaderBody();
            result = result * 59 + ($headerBody == null ? 43 : $headerBody.hashCode());
            String $headerTitle = this.getHeaderTitle();
            result = result * 59 + ($headerTitle == null ? 43 : $headerTitle.hashCode());
            return result;
        }
    }

    public static class Preferences
    extends StripeObject {
        @SerializedName(value="account_default")
        Boolean accountDefault;
        @SerializedName(value="platform_default")
        Boolean platformDefault;

        @Generated
        public Boolean getAccountDefault() {
            return this.accountDefault;
        }

        @Generated
        public Boolean getPlatformDefault() {
            return this.platformDefault;
        }

        @Generated
        public void setAccountDefault(Boolean accountDefault) {
            this.accountDefault = accountDefault;
        }

        @Generated
        public void setPlatformDefault(Boolean platformDefault) {
            this.platformDefault = platformDefault;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Preferences)) {
                return false;
            }
            Preferences other = (Preferences)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$accountDefault = this.getAccountDefault();
            Boolean other$accountDefault = other.getAccountDefault();
            if (this$accountDefault == null ? other$accountDefault != null : !((Object)this$accountDefault).equals(other$accountDefault)) {
                return false;
            }
            Boolean this$platformDefault = this.getPlatformDefault();
            Boolean other$platformDefault = other.getPlatformDefault();
            return !(this$platformDefault == null ? other$platformDefault != null : !((Object)this$platformDefault).equals(other$platformDefault));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Preferences;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $accountDefault = this.getAccountDefault();
            result = result * 59 + ($accountDefault == null ? 43 : ((Object)$accountDefault).hashCode());
            Boolean $platformDefault = this.getPlatformDefault();
            result = result * 59 + ($platformDefault == null ? 43 : ((Object)$platformDefault).hashCode());
            return result;
        }
    }

    public static class RejectionReasons
    extends StripeObject {
        @SerializedName(value="card_logo")
        List<String> cardLogo;
        @SerializedName(value="carrier_text")
        List<String> carrierText;

        @Generated
        public List<String> getCardLogo() {
            return this.cardLogo;
        }

        @Generated
        public List<String> getCarrierText() {
            return this.carrierText;
        }

        @Generated
        public void setCardLogo(List<String> cardLogo) {
            this.cardLogo = cardLogo;
        }

        @Generated
        public void setCarrierText(List<String> carrierText) {
            this.carrierText = carrierText;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RejectionReasons)) {
                return false;
            }
            RejectionReasons other = (RejectionReasons)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$cardLogo = this.getCardLogo();
            List<String> other$cardLogo = other.getCardLogo();
            if (this$cardLogo == null ? other$cardLogo != null : !((Object)this$cardLogo).equals(other$cardLogo)) {
                return false;
            }
            List<String> this$carrierText = this.getCarrierText();
            List<String> other$carrierText = other.getCarrierText();
            return !(this$carrierText == null ? other$carrierText != null : !((Object)this$carrierText).equals(other$carrierText));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RejectionReasons;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $cardLogo = this.getCardLogo();
            result = result * 59 + ($cardLogo == null ? 43 : ((Object)$cardLogo).hashCode());
            List<String> $carrierText = this.getCarrierText();
            result = result * 59 + ($carrierText == null ? 43 : ((Object)$carrierText).hashCode());
            return result;
        }
    }
}

