/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.TaxId;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.param.TaxIdCollectionCreateParams;
import com.stripe.param.TaxIdCollectionListParams;
import com.stripe.param.TaxIdCollectionRetrieveParams;
import java.lang.reflect.Type;
import java.util.Map;

public class TaxIdCollection
extends StripeCollection<TaxId> {
    public TaxId create(Map<String, Object> params) throws StripeException {
        return this.create(params, (RequestOptions)null);
    }

    public TaxId create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = this.getUrl();
        return (TaxId)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)TaxId.class), options, ApiMode.V1);
    }

    public TaxId create(TaxIdCollectionCreateParams params) throws StripeException {
        return this.create(params, (RequestOptions)null);
    }

    public TaxId create(TaxIdCollectionCreateParams params, RequestOptions options) throws StripeException {
        String path = this.getUrl();
        ApiResource.checkNullTypedParams(path, params);
        return (TaxId)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)TaxId.class), options, ApiMode.V1);
    }

    public TaxIdCollection list(Map<String, Object> params) throws StripeException {
        return this.list(params, (RequestOptions)null);
    }

    public TaxIdCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = this.getUrl();
        return (TaxIdCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)TaxIdCollection.class), options, ApiMode.V1);
    }

    public TaxIdCollection list(TaxIdCollectionListParams params) throws StripeException {
        return this.list(params, (RequestOptions)null);
    }

    public TaxIdCollection list(TaxIdCollectionListParams params, RequestOptions options) throws StripeException {
        String path = this.getUrl();
        ApiResource.checkNullTypedParams(path, params);
        return (TaxIdCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)TaxIdCollection.class), options, ApiMode.V1);
    }

    public TaxId retrieve(String id) throws StripeException {
        return this.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public TaxId retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, (Map<String, Object>)null, options);
    }

    public TaxId retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("%s/%s", this.getUrl(), ApiResource.urlEncodeId(id));
        return (TaxId)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)TaxId.class), options, ApiMode.V1);
    }

    public TaxId retrieve(String id, TaxIdCollectionRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("%s/%s", this.getUrl(), ApiResource.urlEncodeId(id));
        ApiResource.checkNullTypedParams(path, params);
        return (TaxId)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)TaxId.class), options, ApiMode.V1);
    }
}

