/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.terminal;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.terminal.Configuration;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.terminal.ConfigurationCreateParams;
import com.stripe.param.terminal.ConfigurationListParams;
import com.stripe.param.terminal.ConfigurationRetrieveParams;
import com.stripe.param.terminal.ConfigurationUpdateParams;
import java.lang.reflect.Type;

public final class ConfigurationService
extends ApiService {
    public ConfigurationService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public Configuration create(ConfigurationCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Configuration create(RequestOptions options) throws StripeException {
        return this.create(null, options);
    }

    public Configuration create() throws StripeException {
        return this.create(null, null);
    }

    public Configuration create(ConfigurationCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/terminal/configurations";
        return (Configuration)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Configuration.class), options, ApiMode.V1);
    }

    public StripeCollection<Configuration> list(ConfigurationListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Configuration> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Configuration> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Configuration> list(ConfigurationListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/terminal/configurations";
        return (StripeCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), new TypeToken<StripeCollection<Configuration>>(){}.getType(), options, ApiMode.V1);
    }

    public Configuration retrieve(String configuration, ConfigurationRetrieveParams params) throws StripeException {
        return this.retrieve(configuration, params, null);
    }

    public Configuration retrieve(String configuration, RequestOptions options) throws StripeException {
        return this.retrieve(configuration, null, options);
    }

    public Configuration retrieve(String configuration) throws StripeException {
        return this.retrieve(configuration, null, null);
    }

    public Configuration retrieve(String configuration, ConfigurationRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/configurations/%s", ApiResource.urlEncodeId(configuration));
        return (Configuration)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Configuration.class), options, ApiMode.V1);
    }

    public Configuration update(String configuration, ConfigurationUpdateParams params) throws StripeException {
        return this.update(configuration, params, null);
    }

    public Configuration update(String configuration, RequestOptions options) throws StripeException {
        return this.update(configuration, null, options);
    }

    public Configuration update(String configuration) throws StripeException {
        return this.update(configuration, null, null);
    }

    public Configuration update(String configuration, ConfigurationUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/configurations/%s", ApiResource.urlEncodeId(configuration));
        return (Configuration)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Configuration.class), options, ApiMode.V1);
    }

    public Configuration delete(String configuration) throws StripeException {
        return this.delete(configuration, null);
    }

    public Configuration delete(String configuration, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/configurations/%s", ApiResource.urlEncodeId(configuration));
        return (Configuration)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, null, (Type)((Object)Configuration.class), options, ApiMode.V1);
    }
}

