/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.EventCollection;
import com.stripe.model.EventDataObjectDeserializer;
import com.stripe.model.HasId;
import com.stripe.model.StripeActiveObject;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.EventListParams;
import com.stripe.param.EventRetrieveParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class Event
extends ApiResource
implements HasId {
    @SerializedName(value="account")
    String account;
    @SerializedName(value="api_version")
    String apiVersion;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="data")
    Data data;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="pending_webhooks")
    Long pendingWebhooks;
    @SerializedName(value="reason")
    Reason reason;
    @SerializedName(value="request")
    Request request;
    @SerializedName(value="type")
    String type;

    public static EventCollection list(Map<String, Object> params) throws StripeException {
        return Event.list(params, (RequestOptions)null);
    }

    public static EventCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/events";
        return (EventCollection)Event.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)EventCollection.class), options, ApiMode.V1);
    }

    public static EventCollection list(EventListParams params) throws StripeException {
        return Event.list(params, (RequestOptions)null);
    }

    public static EventCollection list(EventListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/events";
        ApiResource.checkNullTypedParams(path, params);
        return (EventCollection)Event.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)EventCollection.class), options, ApiMode.V1);
    }

    public static Event retrieve(String id) throws StripeException {
        return Event.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Event retrieve(String id, RequestOptions options) throws StripeException {
        return Event.retrieve(id, (Map<String, Object>)null, options);
    }

    public static Event retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/events/%s", ApiResource.urlEncodeId(id));
        return (Event)Event.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)Event.class), options, ApiMode.V1);
    }

    public static Event retrieve(String id, EventRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/events/%s", ApiResource.urlEncodeId(id));
        ApiResource.checkNullTypedParams(path, params);
        return (Event)Event.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Event.class), options, ApiMode.V1);
    }

    public EventDataObjectDeserializer getDataObjectDeserializer() {
        return new EventDataObjectDeserializer(this.apiVersion, this.type, this.data.object, this.getResponseGetter());
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.data, responseGetter);
        this.trySetResponseGetter(this.reason, responseGetter);
        this.trySetResponseGetter(this.request, responseGetter);
    }

    @Generated
    public String getAccount() {
        return this.account;
    }

    @Generated
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Data getData() {
        return this.data;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Long getPendingWebhooks() {
        return this.pendingWebhooks;
    }

    @Generated
    public Reason getReason() {
        return this.reason;
    }

    @Generated
    public Request getRequest() {
        return this.request;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setAccount(String account) {
        this.account = account;
    }

    @Generated
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setData(Data data) {
        this.data = data;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPendingWebhooks(Long pendingWebhooks) {
        this.pendingWebhooks = pendingWebhooks;
    }

    @Generated
    public void setReason(Reason reason) {
        this.reason = reason;
    }

    @Generated
    public void setRequest(Request request) {
        this.request = request;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$pendingWebhooks = this.getPendingWebhooks();
        Long other$pendingWebhooks = other.getPendingWebhooks();
        if (this$pendingWebhooks == null ? other$pendingWebhooks != null : !((Object)this$pendingWebhooks).equals(other$pendingWebhooks)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        Data this$data = this.getData();
        Data other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Reason this$reason = this.getReason();
        Reason other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !((Object)this$reason).equals(other$reason)) {
            return false;
        }
        Request this$request = this.getRequest();
        Request other$request = other.getRequest();
        if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Event;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $pendingWebhooks = this.getPendingWebhooks();
        result = result * 59 + ($pendingWebhooks == null ? 43 : ((Object)$pendingWebhooks).hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        Data $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Reason $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : ((Object)$reason).hashCode());
        Request $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class Data
    extends StripeObject
    implements StripeActiveObject {
        @SerializedName(value="previous_attributes")
        Map<String, Object> previousAttributes;
        @SerializedName(value="object")
        JsonObject object;
        private transient StripeResponseGetter responseGetter;

        @Deprecated
        public StripeObject getObject() {
            return StripeObject.deserializeStripeObject(this.object, this.responseGetter);
        }

        @Override
        public void setResponseGetter(StripeResponseGetter responseGetter) {
            this.responseGetter = responseGetter;
        }

        @Generated
        public Map<String, Object> getPreviousAttributes() {
            return this.previousAttributes;
        }

        @Generated
        public StripeResponseGetter getResponseGetter() {
            return this.responseGetter;
        }

        @Generated
        public void setPreviousAttributes(Map<String, Object> previousAttributes) {
            this.previousAttributes = previousAttributes;
        }

        @Generated
        public void setObject(JsonObject object) {
            this.object = object;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Data)) {
                return false;
            }
            Data other = (Data)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Object> this$previousAttributes = this.getPreviousAttributes();
            Map<String, Object> other$previousAttributes = other.getPreviousAttributes();
            if (this$previousAttributes == null ? other$previousAttributes != null : !((Object)this$previousAttributes).equals(other$previousAttributes)) {
                return false;
            }
            StripeObject this$object = this.getObject();
            StripeObject other$object = other.getObject();
            return !(this$object == null ? other$object != null : !this$object.equals(other$object));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Data;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Object> $previousAttributes = this.getPreviousAttributes();
            result = result * 59 + ($previousAttributes == null ? 43 : ((Object)$previousAttributes).hashCode());
            StripeObject $object = this.getObject();
            result = result * 59 + ($object == null ? 43 : $object.hashCode());
            return result;
        }
    }

    public static class Reason
    extends StripeObject {
        @SerializedName(value="automation_action")
        AutomationAction automationAction;
        @SerializedName(value="request")
        Request request;
        @SerializedName(value="type")
        String type;

        @Generated
        public AutomationAction getAutomationAction() {
            return this.automationAction;
        }

        @Generated
        public Request getRequest() {
            return this.request;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setAutomationAction(AutomationAction automationAction) {
            this.automationAction = automationAction;
        }

        @Generated
        public void setRequest(Request request) {
            this.request = request;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Reason)) {
                return false;
            }
            Reason other = (Reason)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AutomationAction this$automationAction = this.getAutomationAction();
            AutomationAction other$automationAction = other.getAutomationAction();
            if (this$automationAction == null ? other$automationAction != null : !((Object)this$automationAction).equals(other$automationAction)) {
                return false;
            }
            Request this$request = this.getRequest();
            Request other$request = other.getRequest();
            if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Reason;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AutomationAction $automationAction = this.getAutomationAction();
            result = result * 59 + ($automationAction == null ? 43 : ((Object)$automationAction).hashCode());
            Request $request = this.getRequest();
            result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class AutomationAction
        extends StripeObject {
            @SerializedName(value="stripe_send_webhook_custom_event")
            StripeSendWebhookCustomEvent stripeSendWebhookCustomEvent;
            @SerializedName(value="trigger")
            String trigger;
            @SerializedName(value="type")
            String type;

            @Generated
            public StripeSendWebhookCustomEvent getStripeSendWebhookCustomEvent() {
                return this.stripeSendWebhookCustomEvent;
            }

            @Generated
            public String getTrigger() {
                return this.trigger;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStripeSendWebhookCustomEvent(StripeSendWebhookCustomEvent stripeSendWebhookCustomEvent) {
                this.stripeSendWebhookCustomEvent = stripeSendWebhookCustomEvent;
            }

            @Generated
            public void setTrigger(String trigger) {
                this.trigger = trigger;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AutomationAction)) {
                    return false;
                }
                AutomationAction other = (AutomationAction)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                StripeSendWebhookCustomEvent this$stripeSendWebhookCustomEvent = this.getStripeSendWebhookCustomEvent();
                StripeSendWebhookCustomEvent other$stripeSendWebhookCustomEvent = other.getStripeSendWebhookCustomEvent();
                if (this$stripeSendWebhookCustomEvent == null ? other$stripeSendWebhookCustomEvent != null : !((Object)this$stripeSendWebhookCustomEvent).equals(other$stripeSendWebhookCustomEvent)) {
                    return false;
                }
                String this$trigger = this.getTrigger();
                String other$trigger = other.getTrigger();
                if (this$trigger == null ? other$trigger != null : !this$trigger.equals(other$trigger)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AutomationAction;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                StripeSendWebhookCustomEvent $stripeSendWebhookCustomEvent = this.getStripeSendWebhookCustomEvent();
                result = result * 59 + ($stripeSendWebhookCustomEvent == null ? 43 : ((Object)$stripeSendWebhookCustomEvent).hashCode());
                String $trigger = this.getTrigger();
                result = result * 59 + ($trigger == null ? 43 : $trigger.hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class StripeSendWebhookCustomEvent
            extends StripeObject {
                @SerializedName(value="custom_data")
                Map<String, String> customData;

                @Generated
                public Map<String, String> getCustomData() {
                    return this.customData;
                }

                @Generated
                public void setCustomData(Map<String, String> customData) {
                    this.customData = customData;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof StripeSendWebhookCustomEvent)) {
                        return false;
                    }
                    StripeSendWebhookCustomEvent other = (StripeSendWebhookCustomEvent)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Map<String, String> this$customData = this.getCustomData();
                    Map<String, String> other$customData = other.getCustomData();
                    return !(this$customData == null ? other$customData != null : !((Object)this$customData).equals(other$customData));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof StripeSendWebhookCustomEvent;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Map<String, String> $customData = this.getCustomData();
                    result = result * 59 + ($customData == null ? 43 : ((Object)$customData).hashCode());
                    return result;
                }
            }
        }

        public static class Request
        extends StripeObject
        implements HasId {
            @SerializedName(value="id")
            String id;
            @SerializedName(value="idempotency_key")
            String idempotencyKey;

            @Generated
            public String getIdempotencyKey() {
                return this.idempotencyKey;
            }

            @Generated
            public void setId(String id) {
                this.id = id;
            }

            @Generated
            public void setIdempotencyKey(String idempotencyKey) {
                this.idempotencyKey = idempotencyKey;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Request)) {
                    return false;
                }
                Request other = (Request)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$id = this.getId();
                String other$id = other.getId();
                if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                    return false;
                }
                String this$idempotencyKey = this.getIdempotencyKey();
                String other$idempotencyKey = other.getIdempotencyKey();
                return !(this$idempotencyKey == null ? other$idempotencyKey != null : !this$idempotencyKey.equals(other$idempotencyKey));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Request;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $id = this.getId();
                result = result * 59 + ($id == null ? 43 : $id.hashCode());
                String $idempotencyKey = this.getIdempotencyKey();
                result = result * 59 + ($idempotencyKey == null ? 43 : $idempotencyKey.hashCode());
                return result;
            }

            @Override
            @Generated
            public String getId() {
                return this.id;
            }
        }
    }

    public static class Request
    extends StripeObject
    implements HasId {
        @SerializedName(value="id")
        String id;
        @SerializedName(value="idempotency_key")
        String idempotencyKey;

        @Generated
        public String getIdempotencyKey() {
            return this.idempotencyKey;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setIdempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Request)) {
                return false;
            }
            Request other = (Request)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$idempotencyKey = this.getIdempotencyKey();
            String other$idempotencyKey = other.getIdempotencyKey();
            return !(this$idempotencyKey == null ? other$idempotencyKey != null : !this$idempotencyKey.equals(other$idempotencyKey));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Request;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $idempotencyKey = this.getIdempotencyKey();
            result = result * 59 + ($idempotencyKey == null ? 43 : $idempotencyKey.hashCode());
            return result;
        }

        @Override
        @Generated
        public String getId() {
            return this.id;
        }
    }
}

