/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.model.HasId;
import com.stripe.model.StripeCollectionInterface;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class PagingIterator<T extends HasId>
extends ApiResource
implements Iterator<T> {
    private final String url;
    private final Type pageType;
    private StripeCollectionInterface<T> currentCollection;
    private Iterator<T> currentDataIterator;
    private String lastId;

    PagingIterator(StripeCollectionInterface<T> stripeCollection, StripeResponseGetter responseGetter, Type pageType) {
        this.url = stripeCollection.getUrl();
        this.pageType = pageType;
        this.currentCollection = stripeCollection;
        this.currentDataIterator = stripeCollection.getData().iterator();
        this.setResponseGetter(responseGetter);
    }

    @Override
    public boolean hasNext() {
        return this.currentDataIterator.hasNext() || this.currentCollection.getHasMore() != false;
    }

    @Override
    public T next() {
        if (!this.currentDataIterator.hasNext() && this.currentCollection.getHasMore().booleanValue()) {
            try {
                HashMap<String, Object> params = new HashMap<String, Object>();
                Map<String, Object> initialParams = this.currentCollection.getRequestParams();
                if (initialParams != null) {
                    params.putAll(initialParams);
                }
                params.put("starting_after", this.lastId);
                this.currentCollection = this.list(params, this.currentCollection.getRequestOptions());
                this.currentDataIterator = this.currentCollection.getData().iterator();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to lazy-load stripe objects", e);
            }
        }
        if (this.currentDataIterator.hasNext()) {
            HasId next = (HasId)this.currentDataIterator.next();
            this.lastId = next.getId();
            return (T)next;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private StripeCollectionInterface<T> list(Map<String, Object> params, RequestOptions options) throws Exception {
        return (StripeCollectionInterface)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, this.url, params, this.pageType, options, ApiMode.V1);
    }
}

